# gtz.xdc: Constraints for GTZ transceivers in CAUI-4 mode - xc7vh580t FPGA, 
#          OCTAL0 NORTH 
# Copyright (C) 2014 CESNET
# Author: Stepan Friedl <friedl@cesnet.cz>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the Company nor the names of its contributors
#    may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# This software is provided ``as is'', and any express or implied
# warranties, including, but not limited to, the implied warranties of
# merchantability and fitness for a particular purpose are disclaimed.
# In no event shall the company or contributors be liable for any
# direct, indirect, incidental, special, exemplary, or consequential
# damages (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether
# in contract, strict liability, or tort (including negligence or
# otherwise) arising in any way out of the use of this software, even
# if advised of the possibility of such damage.
#
# $Id$
#


set_property LOC GTZE2_OCTAL_X0Y0 [get_cells gtze2_octal_north]
set_property LOC BUFG_LB_X1Y0 [get_cells gtze2_inf_north/clkbuflbtx0]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER37_LUT1A]
set_property LOC SLICE_X181Y262 [get_cells gtze2_inf_north/RXHEADER37_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER37_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER37_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X180Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X180Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X180Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER37_LUT1B]
set_property LOC SLICE_X181Y262 [get_cells gtze2_inf_north/RXHEADER37_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER37_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER37_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X180Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER37_FD]
set_property LOC SLICE_X180Y262 [get_cells gtze2_inf_north/RXHEADER37_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER37_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER36_LUT1A]
set_property LOC SLICE_X181Y267 [get_cells gtze2_inf_north/RXHEADER36_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER36_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER36_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X180Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X180Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X180Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER36_LUT1B]
set_property LOC SLICE_X181Y267 [get_cells gtze2_inf_north/RXHEADER36_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER36_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER36_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X180Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER36_FD]
set_property LOC SLICE_X180Y267 [get_cells gtze2_inf_north/RXHEADER36_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER36_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPWE_LUT1B]
set_property LOC SLICE_X270Y260 [get_cells gtze2_inf_north/DRPWE_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPWE_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPWE_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X270Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X270Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/DRPWE_FD]
set_property LOC SLICE_X270Y260 [get_cells gtze2_inf_north/DRPWE_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPWE_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/GTZINIT_LUT1B]
set_property LOC SLICE_X270Y250 [get_cells gtze2_inf_north/GTZINIT_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/GTZINIT_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/GTZINIT_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X270Y250/D5FF]
set_property PROHIBIT true [get_bels SLICE_X270Y250/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/GTZINIT_FD]
set_property LOC SLICE_X270Y250 [get_cells gtze2_inf_north/GTZINIT_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/GTZINIT_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER39_LUT1A]
set_property LOC SLICE_X179Y262 [get_cells gtze2_inf_north/RXHEADER39_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER39_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER39_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X178Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X178Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X178Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER39_LUT1B]
set_property LOC SLICE_X179Y262 [get_cells gtze2_inf_north/RXHEADER39_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER39_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER39_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X178Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER39_FD]
set_property LOC SLICE_X178Y262 [get_cells gtze2_inf_north/RXHEADER39_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER39_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER38_LUT1A]
set_property LOC SLICE_X179Y267 [get_cells gtze2_inf_north/RXHEADER38_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER38_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER38_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X178Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X178Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X178Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER38_LUT1B]
set_property LOC SLICE_X179Y267 [get_cells gtze2_inf_north/RXHEADER38_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER38_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER38_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X178Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER38_FD]
set_property LOC SLICE_X178Y267 [get_cells gtze2_inf_north/RXHEADER38_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER38_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/TXRESETDONE2_LUT1A]
set_property LOC SLICE_X158Y257 [get_cells gtze2_inf_north/TXRESETDONE2_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/TXRESETDONE2_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE2_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXRESETDONE2_LUT1B]
set_property LOC SLICE_X158Y257 [get_cells gtze2_inf_north/TXRESETDONE2_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/TXRESETDONE2_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE2_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y257/D5FF]
set_property PROHIBIT true [get_bels SLICE_X159Y257/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXRESETDONE2_FD]
set_property LOC SLICE_X159Y257 [get_cells gtze2_inf_north/TXRESETDONE2_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE2_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0156_LUT1B]
set_property LOC SLICE_X97Y250 [get_cells gtze2_inf_north/TXDATA0156_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0156_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0156_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y250/B5FF]
set_property PROHIBIT true [get_bels SLICE_X97Y250/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0156_FD]
set_property LOC SLICE_X97Y250 [get_cells gtze2_inf_north/TXDATA0156_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0156_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0155_LUT1B]
set_property LOC SLICE_X97Y255 [get_cells gtze2_inf_north/TXDATA0155_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0155_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0155_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X97Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0155_FD]
set_property LOC SLICE_X97Y255 [get_cells gtze2_inf_north/TXDATA0155_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0155_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0154_LUT1B]
set_property LOC SLICE_X97Y255 [get_cells gtze2_inf_north/TXDATA0154_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0154_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0154_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0154_FD]
set_property LOC SLICE_X97Y255 [get_cells gtze2_inf_north/TXDATA0154_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0154_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0153_LUT1B]
set_property LOC SLICE_X97Y255 [get_cells gtze2_inf_north/TXDATA0153_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0153_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0153_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0153_FD]
set_property LOC SLICE_X97Y255 [get_cells gtze2_inf_north/TXDATA0153_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0153_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0152_LUT1B]
set_property LOC SLICE_X97Y255 [get_cells gtze2_inf_north/TXDATA0152_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0152_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0152_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0152_FD]
set_property LOC SLICE_X97Y255 [get_cells gtze2_inf_north/TXDATA0152_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0152_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0136_LUT1B]
set_property LOC SLICE_X97Y275 [get_cells gtze2_inf_north/TXDATA0136_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0136_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0136_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y275/B5FF]
set_property PROHIBIT true [get_bels SLICE_X97Y275/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0136_FD]
set_property LOC SLICE_X97Y275 [get_cells gtze2_inf_north/TXDATA0136_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0136_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0135_LUT1B]
set_property LOC SLICE_X97Y280 [get_cells gtze2_inf_north/TXDATA0135_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0135_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0135_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X97Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0135_FD]
set_property LOC SLICE_X97Y280 [get_cells gtze2_inf_north/TXDATA0135_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0135_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0134_LUT1B]
set_property LOC SLICE_X97Y280 [get_cells gtze2_inf_north/TXDATA0134_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0134_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0134_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0134_FD]
set_property LOC SLICE_X97Y280 [get_cells gtze2_inf_north/TXDATA0134_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0134_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA337_LUT1B]
set_property LOC SLICE_X175Y280 [get_cells gtze2_inf_north/TXDATA337_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA337_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA337_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y280/A5FF]
set_property PROHIBIT true [get_bels SLICE_X175Y280/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA337_FD]
set_property LOC SLICE_X175Y280 [get_cells gtze2_inf_north/TXDATA337_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA337_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA336_LUT1B]
set_property LOC SLICE_X175Y280 [get_cells gtze2_inf_north/TXDATA336_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA336_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA336_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA336_FD]
set_property LOC SLICE_X175Y280 [get_cells gtze2_inf_north/TXDATA336_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA336_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA335_LUT1B]
set_property LOC SLICE_X175Y285 [get_cells gtze2_inf_north/TXDATA335_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA335_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA335_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X175Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA335_FD]
set_property LOC SLICE_X175Y285 [get_cells gtze2_inf_north/TXDATA335_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA335_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA334_LUT1B]
set_property LOC SLICE_X175Y285 [get_cells gtze2_inf_north/TXDATA334_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA334_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA334_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA334_FD]
set_property LOC SLICE_X175Y285 [get_cells gtze2_inf_north/TXDATA334_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA334_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA333_LUT1B]
set_property LOC SLICE_X175Y285 [get_cells gtze2_inf_north/TXDATA333_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA333_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA333_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA333_FD]
set_property LOC SLICE_X175Y285 [get_cells gtze2_inf_north/TXDATA333_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA333_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA332_LUT1B]
set_property LOC SLICE_X175Y285 [get_cells gtze2_inf_north/TXDATA332_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA332_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA332_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA332_FD]
set_property LOC SLICE_X175Y285 [get_cells gtze2_inf_north/TXDATA332_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA332_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA331_LUT1B]
set_property LOC SLICE_X177Y250 [get_cells gtze2_inf_north/TXDATA331_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA331_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA331_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA331_FD]
set_property LOC SLICE_X177Y250 [get_cells gtze2_inf_north/TXDATA331_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA331_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA330_LUT1B]
set_property LOC SLICE_X177Y250 [get_cells gtze2_inf_north/TXDATA330_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA330_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA330_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA330_FD]
set_property LOC SLICE_X177Y250 [get_cells gtze2_inf_north/TXDATA330_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA330_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA313_LUT1B]
set_property LOC SLICE_X177Y270 [get_cells gtze2_inf_north/TXDATA313_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA313_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA313_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y270/A5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y270/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA313_FD]
set_property LOC SLICE_X177Y270 [get_cells gtze2_inf_north/TXDATA313_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA313_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA312_LUT1B]
set_property LOC SLICE_X177Y270 [get_cells gtze2_inf_north/TXDATA312_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA312_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA312_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA312_FD]
set_property LOC SLICE_X177Y270 [get_cells gtze2_inf_north/TXDATA312_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA312_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA311_LUT1B]
set_property LOC SLICE_X177Y275 [get_cells gtze2_inf_north/TXDATA311_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA311_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA311_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA311_FD]
set_property LOC SLICE_X177Y275 [get_cells gtze2_inf_north/TXDATA311_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA311_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA310_LUT1B]
set_property LOC SLICE_X177Y275 [get_cells gtze2_inf_north/TXDATA310_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA310_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA310_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA310_FD]
set_property LOC SLICE_X177Y275 [get_cells gtze2_inf_north/TXDATA310_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA310_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA39_LUT1B]
set_property LOC SLICE_X177Y275 [get_cells gtze2_inf_north/TXDATA39_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA39_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA39_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA39_FD]
set_property LOC SLICE_X177Y275 [get_cells gtze2_inf_north/TXDATA39_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA39_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA38_LUT1B]
set_property LOC SLICE_X177Y275 [get_cells gtze2_inf_north/TXDATA38_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA38_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA38_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA38_FD]
set_property LOC SLICE_X177Y275 [get_cells gtze2_inf_north/TXDATA38_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA38_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA37_LUT1B]
set_property LOC SLICE_X177Y280 [get_cells gtze2_inf_north/TXDATA37_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA37_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA37_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA37_FD]
set_property LOC SLICE_X177Y280 [get_cells gtze2_inf_north/TXDATA37_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA37_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA36_LUT1B]
set_property LOC SLICE_X177Y280 [get_cells gtze2_inf_north/TXDATA36_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA36_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA36_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA36_FD]
set_property LOC SLICE_X177Y280 [get_cells gtze2_inf_north/TXDATA36_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA36_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA381_LUT1B]
set_property LOC SLICE_X173Y265 [get_cells gtze2_inf_north/TXDATA381_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA381_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA381_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y265/A5FF]
set_property PROHIBIT true [get_bels SLICE_X173Y265/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA381_FD]
set_property LOC SLICE_X173Y265 [get_cells gtze2_inf_north/TXDATA381_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA381_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA380_LUT1B]
set_property LOC SLICE_X173Y265 [get_cells gtze2_inf_north/TXDATA380_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA380_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA380_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA380_FD]
set_property LOC SLICE_X173Y265 [get_cells gtze2_inf_north/TXDATA380_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA380_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA268_LUT1A]
set_property LOC SLICE_X162Y292 [get_cells gtze2_inf_north/RXDATA268_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA268_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA268_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA268_LUT1B]
set_property LOC SLICE_X162Y292 [get_cells gtze2_inf_north/RXDATA268_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA268_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA268_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y292/A5FF]
set_property PROHIBIT true [get_bels SLICE_X163Y292/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA268_FD]
set_property LOC SLICE_X163Y292 [get_cells gtze2_inf_north/RXDATA268_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA268_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA267_LUT1A]
set_property LOC SLICE_X162Y297 [get_cells gtze2_inf_north/RXDATA267_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA267_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA267_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA267_LUT1B]
set_property LOC SLICE_X162Y297 [get_cells gtze2_inf_north/RXDATA267_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA267_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA267_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X163Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA267_FD]
set_property LOC SLICE_X163Y297 [get_cells gtze2_inf_north/RXDATA267_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA267_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA266_LUT1A]
set_property LOC SLICE_X162Y297 [get_cells gtze2_inf_north/RXDATA266_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA266_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA266_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA266_LUT1B]
set_property LOC SLICE_X162Y297 [get_cells gtze2_inf_north/RXDATA266_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA266_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA266_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA266_FD]
set_property LOC SLICE_X163Y297 [get_cells gtze2_inf_north/RXDATA266_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA266_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA265_LUT1A]
set_property LOC SLICE_X162Y297 [get_cells gtze2_inf_north/RXDATA265_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA265_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA265_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA265_LUT1B]
set_property LOC SLICE_X162Y297 [get_cells gtze2_inf_north/RXDATA265_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA265_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA265_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA265_FD]
set_property LOC SLICE_X163Y297 [get_cells gtze2_inf_north/RXDATA265_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA265_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA264_LUT1A]
set_property LOC SLICE_X162Y297 [get_cells gtze2_inf_north/RXDATA264_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA264_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA264_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA264_LUT1B]
set_property LOC SLICE_X162Y297 [get_cells gtze2_inf_north/RXDATA264_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA264_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA264_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA264_FD]
set_property LOC SLICE_X163Y297 [get_cells gtze2_inf_north/RXDATA264_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA264_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA263_LUT1A]
set_property LOC SLICE_X164Y262 [get_cells gtze2_inf_north/RXDATA263_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA263_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA263_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA263_LUT1B]
set_property LOC SLICE_X164Y262 [get_cells gtze2_inf_north/RXDATA263_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA263_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA263_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X165Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA263_FD]
set_property LOC SLICE_X165Y262 [get_cells gtze2_inf_north/RXDATA263_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA263_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA262_LUT1A]
set_property LOC SLICE_X164Y262 [get_cells gtze2_inf_north/RXDATA262_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA262_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA262_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA262_LUT1B]
set_property LOC SLICE_X164Y262 [get_cells gtze2_inf_north/RXDATA262_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA262_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA262_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA262_FD]
set_property LOC SLICE_X165Y262 [get_cells gtze2_inf_north/RXDATA262_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA262_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA261_LUT1A]
set_property LOC SLICE_X164Y262 [get_cells gtze2_inf_north/RXDATA261_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA261_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA261_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA261_LUT1B]
set_property LOC SLICE_X164Y262 [get_cells gtze2_inf_north/RXDATA261_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA261_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA261_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA261_FD]
set_property LOC SLICE_X165Y262 [get_cells gtze2_inf_north/RXDATA261_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA261_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA373_LUT1B]
set_property LOC SLICE_X173Y275 [get_cells gtze2_inf_north/TXDATA373_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA373_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA373_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y275/A5FF]
set_property PROHIBIT true [get_bels SLICE_X173Y275/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA373_FD]
set_property LOC SLICE_X173Y275 [get_cells gtze2_inf_north/TXDATA373_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA373_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA372_LUT1B]
set_property LOC SLICE_X173Y275 [get_cells gtze2_inf_north/TXDATA372_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA372_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA372_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA372_FD]
set_property LOC SLICE_X173Y275 [get_cells gtze2_inf_north/TXDATA372_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA372_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2108_LUT1A]
set_property LOC SLICE_X160Y282 [get_cells gtze2_inf_north/RXDATA2108_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2108_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2108_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2108_LUT1B]
set_property LOC SLICE_X160Y282 [get_cells gtze2_inf_north/RXDATA2108_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2108_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2108_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y282/A5FF]
set_property PROHIBIT true [get_bels SLICE_X161Y282/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2108_FD]
set_property LOC SLICE_X161Y282 [get_cells gtze2_inf_north/RXDATA2108_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2108_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2107_LUT1A]
set_property LOC SLICE_X160Y287 [get_cells gtze2_inf_north/RXDATA2107_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2107_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2107_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2107_LUT1B]
set_property LOC SLICE_X160Y287 [get_cells gtze2_inf_north/RXDATA2107_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2107_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2107_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X161Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2107_FD]
set_property LOC SLICE_X161Y287 [get_cells gtze2_inf_north/RXDATA2107_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2107_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2106_LUT1A]
set_property LOC SLICE_X160Y287 [get_cells gtze2_inf_north/RXDATA2106_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2106_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2106_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2106_LUT1B]
set_property LOC SLICE_X160Y287 [get_cells gtze2_inf_north/RXDATA2106_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2106_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2106_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2106_FD]
set_property LOC SLICE_X161Y287 [get_cells gtze2_inf_north/RXDATA2106_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2106_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2105_LUT1A]
set_property LOC SLICE_X160Y287 [get_cells gtze2_inf_north/RXDATA2105_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2105_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2105_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2105_LUT1B]
set_property LOC SLICE_X160Y287 [get_cells gtze2_inf_north/RXDATA2105_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2105_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2105_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2105_FD]
set_property LOC SLICE_X161Y287 [get_cells gtze2_inf_north/RXDATA2105_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2105_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2104_LUT1A]
set_property LOC SLICE_X160Y287 [get_cells gtze2_inf_north/RXDATA2104_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2104_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2104_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2104_LUT1B]
set_property LOC SLICE_X160Y287 [get_cells gtze2_inf_north/RXDATA2104_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2104_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2104_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2104_FD]
set_property LOC SLICE_X161Y287 [get_cells gtze2_inf_north/RXDATA2104_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2104_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2103_LUT1A]
set_property LOC SLICE_X160Y292 [get_cells gtze2_inf_north/RXDATA2103_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2103_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2103_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2103_LUT1B]
set_property LOC SLICE_X160Y292 [get_cells gtze2_inf_north/RXDATA2103_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2103_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2103_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X161Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2103_FD]
set_property LOC SLICE_X161Y292 [get_cells gtze2_inf_north/RXDATA2103_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2103_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2102_LUT1A]
set_property LOC SLICE_X160Y292 [get_cells gtze2_inf_north/RXDATA2102_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2102_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2102_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2102_LUT1B]
set_property LOC SLICE_X160Y292 [get_cells gtze2_inf_north/RXDATA2102_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2102_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2102_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2102_FD]
set_property LOC SLICE_X161Y292 [get_cells gtze2_inf_north/RXDATA2102_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2102_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2101_LUT1A]
set_property LOC SLICE_X160Y292 [get_cells gtze2_inf_north/RXDATA2101_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2101_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2101_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2101_LUT1B]
set_property LOC SLICE_X160Y292 [get_cells gtze2_inf_north/RXDATA2101_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2101_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2101_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2101_FD]
set_property LOC SLICE_X161Y292 [get_cells gtze2_inf_north/RXDATA2101_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2101_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA348_LUT1B]
set_property LOC SLICE_X175Y265 [get_cells gtze2_inf_north/TXDATA348_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA348_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA348_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y265/B5FF]
set_property PROHIBIT true [get_bels SLICE_X175Y265/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA348_FD]
set_property LOC SLICE_X175Y265 [get_cells gtze2_inf_north/TXDATA348_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA348_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA347_LUT1B]
set_property LOC SLICE_X175Y270 [get_cells gtze2_inf_north/TXDATA347_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA347_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA347_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X175Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA347_FD]
set_property LOC SLICE_X175Y270 [get_cells gtze2_inf_north/TXDATA347_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA347_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA346_LUT1B]
set_property LOC SLICE_X175Y270 [get_cells gtze2_inf_north/TXDATA346_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA346_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA346_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA346_FD]
set_property LOC SLICE_X175Y270 [get_cells gtze2_inf_north/TXDATA346_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA346_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXOUTPUTEN2_LUT1B]
set_property LOC SLICE_X155Y252 [get_cells gtze2_inf_north/TXOUTPUTEN2_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXOUTPUTEN2_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXOUTPUTEN2_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y252/A5FF]
set_property PROHIBIT true [get_bels SLICE_X155Y252/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXOUTPUTEN2_FD]
set_property LOC SLICE_X155Y252 [get_cells gtze2_inf_north/TXOUTPUTEN2_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXOUTPUTEN2_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/TXRESETDONE0_LUT1A]
set_property LOC SLICE_X118Y257 [get_cells gtze2_inf_north/TXRESETDONE0_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/TXRESETDONE0_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE0_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXRESETDONE0_LUT1B]
set_property LOC SLICE_X118Y257 [get_cells gtze2_inf_north/TXRESETDONE0_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/TXRESETDONE0_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE0_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X119Y257/D5FF]
set_property PROHIBIT true [get_bels SLICE_X119Y257/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXRESETDONE0_FD]
set_property LOC SLICE_X119Y257 [get_cells gtze2_inf_north/TXRESETDONE0_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE0_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA329_LUT1B]
set_property LOC SLICE_X177Y250 [get_cells gtze2_inf_north/TXDATA329_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA329_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA329_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA329_FD]
set_property LOC SLICE_X177Y250 [get_cells gtze2_inf_north/TXDATA329_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA329_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA328_LUT1B]
set_property LOC SLICE_X177Y250 [get_cells gtze2_inf_north/TXDATA328_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA328_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA328_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA328_FD]
set_property LOC SLICE_X177Y250 [get_cells gtze2_inf_north/TXDATA328_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA328_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA327_LUT1B]
set_property LOC SLICE_X177Y255 [get_cells gtze2_inf_north/TXDATA327_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA327_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA327_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA327_FD]
set_property LOC SLICE_X177Y255 [get_cells gtze2_inf_north/TXDATA327_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA327_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA326_LUT1B]
set_property LOC SLICE_X177Y255 [get_cells gtze2_inf_north/TXDATA326_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA326_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA326_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA326_FD]
set_property LOC SLICE_X177Y255 [get_cells gtze2_inf_north/TXDATA326_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA326_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA325_LUT1B]
set_property LOC SLICE_X177Y255 [get_cells gtze2_inf_north/TXDATA325_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA325_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA325_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA325_FD]
set_property LOC SLICE_X177Y255 [get_cells gtze2_inf_north/TXDATA325_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA325_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA324_LUT1B]
set_property LOC SLICE_X177Y255 [get_cells gtze2_inf_north/TXDATA324_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA324_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA324_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA324_FD]
set_property LOC SLICE_X177Y255 [get_cells gtze2_inf_north/TXDATA324_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA324_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA323_LUT1B]
set_property LOC SLICE_X177Y260 [get_cells gtze2_inf_north/TXDATA323_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA323_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA323_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA323_FD]
set_property LOC SLICE_X177Y260 [get_cells gtze2_inf_north/TXDATA323_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA323_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA322_LUT1B]
set_property LOC SLICE_X177Y260 [get_cells gtze2_inf_north/TXDATA322_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA322_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA322_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA322_FD]
set_property LOC SLICE_X177Y260 [get_cells gtze2_inf_north/TXDATA322_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA322_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA353_LUT1B]
set_property LOC SLICE_X175Y260 [get_cells gtze2_inf_north/TXDATA353_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA353_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA353_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y260/A5FF]
set_property PROHIBIT true [get_bels SLICE_X175Y260/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA353_FD]
set_property LOC SLICE_X175Y260 [get_cells gtze2_inf_north/TXDATA353_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA353_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA352_LUT1B]
set_property LOC SLICE_X175Y260 [get_cells gtze2_inf_north/TXDATA352_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA352_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA352_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA352_FD]
set_property LOC SLICE_X175Y260 [get_cells gtze2_inf_north/TXDATA352_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA352_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA351_LUT1B]
set_property LOC SLICE_X175Y265 [get_cells gtze2_inf_north/TXDATA351_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA351_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA351_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y265/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA351_FD]
set_property LOC SLICE_X175Y265 [get_cells gtze2_inf_north/TXDATA351_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA351_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA350_LUT1B]
set_property LOC SLICE_X175Y265 [get_cells gtze2_inf_north/TXDATA350_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA350_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA350_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA350_FD]
set_property LOC SLICE_X175Y265 [get_cells gtze2_inf_north/TXDATA350_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA350_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA349_LUT1B]
set_property LOC SLICE_X175Y265 [get_cells gtze2_inf_north/TXDATA349_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA349_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA349_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA349_FD]
set_property LOC SLICE_X175Y265 [get_cells gtze2_inf_north/TXDATA349_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA349_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2156_LUT1A]
set_property LOC SLICE_X158Y262 [get_cells gtze2_inf_north/RXDATA2156_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2156_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2156_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2156_LUT1B]
set_property LOC SLICE_X158Y262 [get_cells gtze2_inf_north/RXDATA2156_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2156_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2156_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y262/A5FF]
set_property PROHIBIT true [get_bels SLICE_X159Y262/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2156_FD]
set_property LOC SLICE_X159Y262 [get_cells gtze2_inf_north/RXDATA2156_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2156_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2155_LUT1A]
set_property LOC SLICE_X158Y267 [get_cells gtze2_inf_north/RXDATA2155_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2155_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2155_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2155_LUT1B]
set_property LOC SLICE_X158Y267 [get_cells gtze2_inf_north/RXDATA2155_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2155_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2155_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X159Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2155_FD]
set_property LOC SLICE_X159Y267 [get_cells gtze2_inf_north/RXDATA2155_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2155_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2154_LUT1A]
set_property LOC SLICE_X158Y267 [get_cells gtze2_inf_north/RXDATA2154_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2154_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2154_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2154_LUT1B]
set_property LOC SLICE_X158Y267 [get_cells gtze2_inf_north/RXDATA2154_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2154_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2154_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2154_FD]
set_property LOC SLICE_X159Y267 [get_cells gtze2_inf_north/RXDATA2154_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2154_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2153_LUT1A]
set_property LOC SLICE_X158Y267 [get_cells gtze2_inf_north/RXDATA2153_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2153_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2153_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2153_LUT1B]
set_property LOC SLICE_X158Y267 [get_cells gtze2_inf_north/RXDATA2153_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2153_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2153_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2153_FD]
set_property LOC SLICE_X159Y267 [get_cells gtze2_inf_north/RXDATA2153_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2153_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2152_LUT1A]
set_property LOC SLICE_X158Y267 [get_cells gtze2_inf_north/RXDATA2152_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2152_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2152_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2152_LUT1B]
set_property LOC SLICE_X158Y267 [get_cells gtze2_inf_north/RXDATA2152_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2152_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2152_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2152_FD]
set_property LOC SLICE_X159Y267 [get_cells gtze2_inf_north/RXDATA2152_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2152_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2151_LUT1A]
set_property LOC SLICE_X158Y272 [get_cells gtze2_inf_north/RXDATA2151_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2151_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2151_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2151_LUT1B]
set_property LOC SLICE_X158Y272 [get_cells gtze2_inf_north/RXDATA2151_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2151_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2151_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X159Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2151_FD]
set_property LOC SLICE_X159Y272 [get_cells gtze2_inf_north/RXDATA2151_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2151_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2150_LUT1A]
set_property LOC SLICE_X158Y272 [get_cells gtze2_inf_north/RXDATA2150_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2150_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2150_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2150_LUT1B]
set_property LOC SLICE_X158Y272 [get_cells gtze2_inf_north/RXDATA2150_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2150_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2150_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2150_FD]
set_property LOC SLICE_X159Y272 [get_cells gtze2_inf_north/RXDATA2150_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2150_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2149_LUT1A]
set_property LOC SLICE_X158Y272 [get_cells gtze2_inf_north/RXDATA2149_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2149_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2149_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2149_LUT1B]
set_property LOC SLICE_X158Y272 [get_cells gtze2_inf_north/RXDATA2149_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2149_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2149_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2149_FD]
set_property LOC SLICE_X159Y272 [get_cells gtze2_inf_north/RXDATA2149_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2149_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2148_LUT1A]
set_property LOC SLICE_X158Y272 [get_cells gtze2_inf_north/RXDATA2148_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2148_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2148_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2148_LUT1B]
set_property LOC SLICE_X158Y272 [get_cells gtze2_inf_north/RXDATA2148_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2148_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2148_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2148_FD]
set_property LOC SLICE_X159Y272 [get_cells gtze2_inf_north/RXDATA2148_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2148_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2147_LUT1A]
set_property LOC SLICE_X158Y277 [get_cells gtze2_inf_north/RXDATA2147_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2147_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2147_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2147_LUT1B]
set_property LOC SLICE_X158Y277 [get_cells gtze2_inf_north/RXDATA2147_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2147_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2147_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X159Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2147_FD]
set_property LOC SLICE_X159Y277 [get_cells gtze2_inf_north/RXDATA2147_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2147_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2146_LUT1A]
set_property LOC SLICE_X158Y277 [get_cells gtze2_inf_north/RXDATA2146_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2146_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2146_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2146_LUT1B]
set_property LOC SLICE_X158Y277 [get_cells gtze2_inf_north/RXDATA2146_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2146_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2146_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2146_FD]
set_property LOC SLICE_X159Y277 [get_cells gtze2_inf_north/RXDATA2146_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2146_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER19_LUT1B]
set_property LOC SLICE_X128Y285 [get_cells gtze2_inf_north/TXHEADER19_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER19_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER19_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X128Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X128Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER19_FD]
set_property LOC SLICE_X128Y285 [get_cells gtze2_inf_north/TXHEADER19_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER19_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER18_LUT1B]
set_property LOC SLICE_X128Y280 [get_cells gtze2_inf_north/TXHEADER18_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER18_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER18_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X128Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X128Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER18_FD]
set_property LOC SLICE_X128Y280 [get_cells gtze2_inf_north/TXHEADER18_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER18_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER17_LUT1B]
set_property LOC SLICE_X130Y285 [get_cells gtze2_inf_north/TXHEADER17_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER17_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER17_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X130Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X130Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER17_FD]
set_property LOC SLICE_X130Y285 [get_cells gtze2_inf_north/TXHEADER17_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER17_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER16_LUT1B]
set_property LOC SLICE_X130Y280 [get_cells gtze2_inf_north/TXHEADER16_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER16_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER16_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X130Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X130Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER16_FD]
set_property LOC SLICE_X130Y280 [get_cells gtze2_inf_north/TXHEADER16_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER16_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER15_LUT1B]
set_property LOC SLICE_X132Y285 [get_cells gtze2_inf_north/TXHEADER15_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER15_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER15_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X132Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X132Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER15_FD]
set_property LOC SLICE_X132Y285 [get_cells gtze2_inf_north/TXHEADER15_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER15_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER14_LUT1B]
set_property LOC SLICE_X132Y280 [get_cells gtze2_inf_north/TXHEADER14_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X132Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X132Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER14_FD]
set_property LOC SLICE_X132Y280 [get_cells gtze2_inf_north/TXHEADER14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER14_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER13_LUT1B]
set_property LOC SLICE_X134Y285 [get_cells gtze2_inf_north/TXHEADER13_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X134Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X134Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER13_FD]
set_property LOC SLICE_X134Y285 [get_cells gtze2_inf_north/TXHEADER13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER13_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER12_LUT1B]
set_property LOC SLICE_X134Y280 [get_cells gtze2_inf_north/TXHEADER12_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X134Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X134Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER12_FD]
set_property LOC SLICE_X134Y280 [get_cells gtze2_inf_north/TXHEADER12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER12_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER11_LUT1B]
set_property LOC SLICE_X136Y285 [get_cells gtze2_inf_north/TXHEADER11_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X136Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X136Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER11_FD]
set_property LOC SLICE_X136Y285 [get_cells gtze2_inf_north/TXHEADER11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER11_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER10_LUT1B]
set_property LOC SLICE_X136Y280 [get_cells gtze2_inf_north/TXHEADER10_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X136Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X136Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER10_FD]
set_property LOC SLICE_X136Y280 [get_cells gtze2_inf_north/TXHEADER10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER10_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2159_LUT1A]
set_property LOC SLICE_X158Y262 [get_cells gtze2_inf_north/RXDATA2159_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2159_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2159_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2159_LUT1B]
set_property LOC SLICE_X158Y262 [get_cells gtze2_inf_north/RXDATA2159_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2159_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2159_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2159_FD]
set_property LOC SLICE_X159Y262 [get_cells gtze2_inf_north/RXDATA2159_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2159_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2158_LUT1A]
set_property LOC SLICE_X158Y262 [get_cells gtze2_inf_north/RXDATA2158_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2158_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2158_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2158_LUT1B]
set_property LOC SLICE_X158Y262 [get_cells gtze2_inf_north/RXDATA2158_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2158_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2158_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2158_FD]
set_property LOC SLICE_X159Y262 [get_cells gtze2_inf_north/RXDATA2158_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2158_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2157_LUT1A]
set_property LOC SLICE_X158Y262 [get_cells gtze2_inf_north/RXDATA2157_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2157_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2157_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2157_LUT1B]
set_property LOC SLICE_X158Y262 [get_cells gtze2_inf_north/RXDATA2157_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2157_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2157_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2157_FD]
set_property LOC SLICE_X159Y262 [get_cells gtze2_inf_north/RXDATA2157_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2157_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2100_LUT1A]
set_property LOC SLICE_X160Y292 [get_cells gtze2_inf_north/RXDATA2100_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2100_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2100_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2100_LUT1B]
set_property LOC SLICE_X160Y292 [get_cells gtze2_inf_north/RXDATA2100_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2100_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2100_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2100_FD]
set_property LOC SLICE_X161Y292 [get_cells gtze2_inf_north/RXDATA2100_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2100_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA299_LUT1A]
set_property LOC SLICE_X160Y297 [get_cells gtze2_inf_north/RXDATA299_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA299_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA299_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA299_LUT1B]
set_property LOC SLICE_X160Y297 [get_cells gtze2_inf_north/RXDATA299_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA299_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA299_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X161Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA299_FD]
set_property LOC SLICE_X161Y297 [get_cells gtze2_inf_north/RXDATA299_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA299_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA298_LUT1A]
set_property LOC SLICE_X160Y297 [get_cells gtze2_inf_north/RXDATA298_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA298_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA298_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA298_LUT1B]
set_property LOC SLICE_X160Y297 [get_cells gtze2_inf_north/RXDATA298_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA298_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA298_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA298_FD]
set_property LOC SLICE_X161Y297 [get_cells gtze2_inf_north/RXDATA298_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA298_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA297_LUT1A]
set_property LOC SLICE_X160Y297 [get_cells gtze2_inf_north/RXDATA297_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA297_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA297_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA297_LUT1B]
set_property LOC SLICE_X160Y297 [get_cells gtze2_inf_north/RXDATA297_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA297_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA297_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA297_FD]
set_property LOC SLICE_X161Y297 [get_cells gtze2_inf_north/RXDATA297_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA297_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA296_LUT1A]
set_property LOC SLICE_X160Y297 [get_cells gtze2_inf_north/RXDATA296_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA296_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA296_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA296_LUT1B]
set_property LOC SLICE_X160Y297 [get_cells gtze2_inf_north/RXDATA296_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA296_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA296_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA296_FD]
set_property LOC SLICE_X161Y297 [get_cells gtze2_inf_north/RXDATA296_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA296_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA295_LUT1A]
set_property LOC SLICE_X162Y262 [get_cells gtze2_inf_north/RXDATA295_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA295_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA295_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA295_LUT1B]
set_property LOC SLICE_X162Y262 [get_cells gtze2_inf_north/RXDATA295_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA295_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA295_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X163Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA295_FD]
set_property LOC SLICE_X163Y262 [get_cells gtze2_inf_north/RXDATA295_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA295_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA294_LUT1A]
set_property LOC SLICE_X162Y262 [get_cells gtze2_inf_north/RXDATA294_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA294_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA294_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA294_LUT1B]
set_property LOC SLICE_X162Y262 [get_cells gtze2_inf_north/RXDATA294_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA294_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA294_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA294_FD]
set_property LOC SLICE_X163Y262 [get_cells gtze2_inf_north/RXDATA294_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA294_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA293_LUT1A]
set_property LOC SLICE_X162Y262 [get_cells gtze2_inf_north/RXDATA293_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA293_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA293_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA293_LUT1B]
set_property LOC SLICE_X162Y262 [get_cells gtze2_inf_north/RXDATA293_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA293_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA293_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA293_FD]
set_property LOC SLICE_X163Y262 [get_cells gtze2_inf_north/RXDATA293_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA293_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2137_LUT1A]
set_property LOC SLICE_X158Y287 [get_cells gtze2_inf_north/RXDATA2137_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2137_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2137_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2137_LUT1B]
set_property LOC SLICE_X158Y287 [get_cells gtze2_inf_north/RXDATA2137_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2137_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2137_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y287/B5FF]
set_property PROHIBIT true [get_bels SLICE_X159Y287/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2137_FD]
set_property LOC SLICE_X159Y287 [get_cells gtze2_inf_north/RXDATA2137_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2137_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2136_LUT1A]
set_property LOC SLICE_X158Y287 [get_cells gtze2_inf_north/RXDATA2136_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2136_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2136_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2136_LUT1B]
set_property LOC SLICE_X158Y287 [get_cells gtze2_inf_north/RXDATA2136_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2136_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2136_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2136_FD]
set_property LOC SLICE_X159Y287 [get_cells gtze2_inf_north/RXDATA2136_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2136_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2135_LUT1A]
set_property LOC SLICE_X158Y292 [get_cells gtze2_inf_north/RXDATA2135_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2135_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2135_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2135_LUT1B]
set_property LOC SLICE_X158Y292 [get_cells gtze2_inf_north/RXDATA2135_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2135_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2135_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X159Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2135_FD]
set_property LOC SLICE_X159Y292 [get_cells gtze2_inf_north/RXDATA2135_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2135_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/DRPWDTERR_LUT1A]
set_property LOC SLICE_X278Y277 [get_cells gtze2_inf_north/DRPWDTERR_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPWDTERR_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPWDTERR_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPWDTERR_LUT1B]
set_property LOC SLICE_X278Y277 [get_cells gtze2_inf_north/DRPWDTERR_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPWDTERR_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPWDTERR_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y277/D5FF]
set_property PROHIBIT true [get_bels SLICE_X279Y277/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/DRPWDTERR_FD]
set_property LOC SLICE_X279Y277 [get_cells gtze2_inf_north/DRPWDTERR_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPWDTERR_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0109_LUT1B]
set_property LOC SLICE_X99Y270 [get_cells gtze2_inf_north/TXDATA0109_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0109_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0109_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y270/A5FF]
set_property PROHIBIT true [get_bels SLICE_X99Y270/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0109_FD]
set_property LOC SLICE_X99Y270 [get_cells gtze2_inf_north/TXDATA0109_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0109_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0108_LUT1B]
set_property LOC SLICE_X99Y270 [get_cells gtze2_inf_north/TXDATA0108_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0108_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0108_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0108_FD]
set_property LOC SLICE_X99Y270 [get_cells gtze2_inf_north/TXDATA0108_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0108_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0107_LUT1B]
set_property LOC SLICE_X99Y275 [get_cells gtze2_inf_north/TXDATA0107_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0107_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0107_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X99Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0107_FD]
set_property LOC SLICE_X99Y275 [get_cells gtze2_inf_north/TXDATA0107_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0107_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0106_LUT1B]
set_property LOC SLICE_X99Y275 [get_cells gtze2_inf_north/TXDATA0106_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0106_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0106_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0106_FD]
set_property LOC SLICE_X99Y275 [get_cells gtze2_inf_north/TXDATA0106_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0106_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0105_LUT1B]
set_property LOC SLICE_X99Y275 [get_cells gtze2_inf_north/TXDATA0105_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0105_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0105_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0105_FD]
set_property LOC SLICE_X99Y275 [get_cells gtze2_inf_north/TXDATA0105_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0105_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0104_LUT1B]
set_property LOC SLICE_X99Y275 [get_cells gtze2_inf_north/TXDATA0104_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0104_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0104_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0104_FD]
set_property LOC SLICE_X99Y275 [get_cells gtze2_inf_north/TXDATA0104_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0104_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE13_LUT1B]
set_property LOC SLICE_X134Y265 [get_cells gtze2_inf_north/TXSEQUENCE13_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X134Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X134Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE13_FD]
set_property LOC SLICE_X134Y265 [get_cells gtze2_inf_north/TXSEQUENCE13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE13_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE12_LUT1B]
set_property LOC SLICE_X136Y265 [get_cells gtze2_inf_north/TXSEQUENCE12_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X136Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X136Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE12_FD]
set_property LOC SLICE_X136Y265 [get_cells gtze2_inf_north/TXSEQUENCE12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE12_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE11_LUT1B]
set_property LOC SLICE_X128Y260 [get_cells gtze2_inf_north/TXSEQUENCE11_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X128Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X128Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE11_FD]
set_property LOC SLICE_X128Y260 [get_cells gtze2_inf_north/TXSEQUENCE11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE11_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE10_LUT1B]
set_property LOC SLICE_X130Y260 [get_cells gtze2_inf_north/TXSEQUENCE10_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X130Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X130Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE10_FD]
set_property LOC SLICE_X130Y260 [get_cells gtze2_inf_north/TXSEQUENCE10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE10_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP04_LUT1B]
set_property LOC SLICE_X117Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP04_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXGEARBOXSLIP04_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP04_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y290/B5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y290/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/RXGEARBOXSLIP04_FD]
set_property LOC SLICE_X117Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP04_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP04_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP03_LUT1B]
set_property LOC SLICE_X117Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP03_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP03_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP03_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y290/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXGEARBOXSLIP03_FD]
set_property LOC SLICE_X117Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP03_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP03_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP02_LUT1B]
set_property LOC SLICE_X117Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP02_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP02_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP02_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y290/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXGEARBOXSLIP02_FD]
set_property LOC SLICE_X117Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP02_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP02_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP01_LUT1B]
set_property LOC SLICE_X117Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP01_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXGEARBOXSLIP01_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP01_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y290/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXGEARBOXSLIP01_FD]
set_property LOC SLICE_X117Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP01_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP01_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0112_LUT1B]
set_property LOC SLICE_X99Y265 [get_cells gtze2_inf_north/TXDATA0112_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0112_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0112_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y265/B5FF]
set_property PROHIBIT true [get_bels SLICE_X99Y265/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0112_FD]
set_property LOC SLICE_X99Y265 [get_cells gtze2_inf_north/TXDATA0112_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0112_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0111_LUT1B]
set_property LOC SLICE_X99Y270 [get_cells gtze2_inf_north/TXDATA0111_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0111_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0111_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y270/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0111_FD]
set_property LOC SLICE_X99Y270 [get_cells gtze2_inf_north/TXDATA0111_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0111_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0110_LUT1B]
set_property LOC SLICE_X99Y270 [get_cells gtze2_inf_north/TXDATA0110_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0110_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0110_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0110_FD]
set_property LOC SLICE_X99Y270 [get_cells gtze2_inf_north/TXDATA0110_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0110_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER19_LUT1A]
set_property LOC SLICE_X139Y262 [get_cells gtze2_inf_north/RXHEADER19_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER19_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER19_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X138Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X138Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X138Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER19_LUT1B]
set_property LOC SLICE_X139Y262 [get_cells gtze2_inf_north/RXHEADER19_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER19_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER19_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X138Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER19_FD]
set_property LOC SLICE_X138Y262 [get_cells gtze2_inf_north/RXHEADER19_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER19_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER18_LUT1A]
set_property LOC SLICE_X139Y267 [get_cells gtze2_inf_north/RXHEADER18_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER18_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER18_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X138Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X138Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X138Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER18_LUT1B]
set_property LOC SLICE_X139Y267 [get_cells gtze2_inf_north/RXHEADER18_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER18_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER18_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X138Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER18_FD]
set_property LOC SLICE_X138Y267 [get_cells gtze2_inf_north/RXHEADER18_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER18_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER17_LUT1A]
set_property LOC SLICE_X141Y262 [get_cells gtze2_inf_north/RXHEADER17_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER17_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER17_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X140Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X140Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X140Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER17_LUT1B]
set_property LOC SLICE_X141Y262 [get_cells gtze2_inf_north/RXHEADER17_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER17_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER17_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X140Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER17_FD]
set_property LOC SLICE_X140Y262 [get_cells gtze2_inf_north/RXHEADER17_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER17_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER16_LUT1A]
set_property LOC SLICE_X141Y267 [get_cells gtze2_inf_north/RXHEADER16_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER16_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER16_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X140Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X140Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X140Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER16_LUT1B]
set_property LOC SLICE_X141Y267 [get_cells gtze2_inf_north/RXHEADER16_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER16_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER16_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X140Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER16_FD]
set_property LOC SLICE_X140Y267 [get_cells gtze2_inf_north/RXHEADER16_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER16_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER15_LUT1A]
set_property LOC SLICE_X143Y262 [get_cells gtze2_inf_north/RXHEADER15_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER15_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER15_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X142Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X142Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X142Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER15_LUT1B]
set_property LOC SLICE_X143Y262 [get_cells gtze2_inf_north/RXHEADER15_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER15_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER15_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X142Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER15_FD]
set_property LOC SLICE_X142Y262 [get_cells gtze2_inf_north/RXHEADER15_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER15_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/GTZINITDONEB_LUT1A]
set_property LOC SLICE_X276Y277 [get_cells gtze2_inf_north/GTZINITDONEB_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/GTZINITDONEB_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/GTZINITDONEB_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/GTZINITDONEB_LUT1B]
set_property LOC SLICE_X276Y277 [get_cells gtze2_inf_north/GTZINITDONEB_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/GTZINITDONEB_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/GTZINITDONEB_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y277/D5FF]
set_property PROHIBIT true [get_bels SLICE_X277Y277/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/GTZINITDONEB_FD]
set_property LOC SLICE_X277Y277 [get_cells gtze2_inf_north/GTZINITDONEB_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/GTZINITDONEB_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0133_LUT1B]
set_property LOC SLICE_X97Y280 [get_cells gtze2_inf_north/TXDATA0133_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0133_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0133_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0133_FD]
set_property LOC SLICE_X97Y280 [get_cells gtze2_inf_north/TXDATA0133_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0133_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0132_LUT1B]
set_property LOC SLICE_X97Y280 [get_cells gtze2_inf_north/TXDATA0132_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0132_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0132_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0132_FD]
set_property LOC SLICE_X97Y280 [get_cells gtze2_inf_north/TXDATA0132_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0132_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0131_LUT1B]
set_property LOC SLICE_X97Y285 [get_cells gtze2_inf_north/TXDATA0131_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0131_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0131_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X97Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0131_FD]
set_property LOC SLICE_X97Y285 [get_cells gtze2_inf_north/TXDATA0131_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0131_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA31_LUT1B]
set_property LOC SLICE_X177Y285 [get_cells gtze2_inf_north/TXDATA31_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y285/A5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y285/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA31_FD]
set_property LOC SLICE_X177Y285 [get_cells gtze2_inf_north/TXDATA31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA31_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA30_LUT1B]
set_property LOC SLICE_X177Y285 [get_cells gtze2_inf_north/TXDATA30_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA30_FD]
set_property LOC SLICE_X177Y285 [get_cells gtze2_inf_north/TXDATA30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA30_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER29_LUT1B]
set_property LOC SLICE_X148Y285 [get_cells gtze2_inf_north/TXHEADER29_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER29_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER29_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X148Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X148Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER29_FD]
set_property LOC SLICE_X148Y285 [get_cells gtze2_inf_north/TXHEADER29_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER29_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER28_LUT1B]
set_property LOC SLICE_X148Y280 [get_cells gtze2_inf_north/TXHEADER28_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER28_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER28_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X148Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X148Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER28_FD]
set_property LOC SLICE_X148Y280 [get_cells gtze2_inf_north/TXHEADER28_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER28_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXRESETDONE2_LUT1A]
set_property LOC SLICE_X161Y287 [get_cells gtze2_inf_north/RXRESETDONE2_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXRESETDONE2_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE2_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X160Y287/BFF]
set_property PROHIBIT true [get_bels SLICE_X160Y287/B5FF]
set_property PROHIBIT true [get_bels SLICE_X160Y287/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXRESETDONE2_LUT1B]
set_property LOC SLICE_X161Y287 [get_cells gtze2_inf_north/RXRESETDONE2_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXRESETDONE2_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE2_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X160Y287/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXRESETDONE2_FD]
set_property LOC SLICE_X160Y287 [get_cells gtze2_inf_north/RXRESETDONE2_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE2_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/DRPDO11_LUT1A]
set_property LOC SLICE_X278Y292 [get_cells gtze2_inf_north/DRPDO11_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDO11_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO11_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDO11_LUT1B]
set_property LOC SLICE_X278Y292 [get_cells gtze2_inf_north/DRPDO11_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPDO11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y292/A5FF]
set_property PROHIBIT true [get_bels SLICE_X279Y292/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDO11_FD]
set_property LOC SLICE_X279Y292 [get_cells gtze2_inf_north/DRPDO11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO11_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/DRPDO10_LUT1A]
set_property LOC SLICE_X278Y292 [get_cells gtze2_inf_north/DRPDO10_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO10_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO10_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDO10_LUT1B]
set_property LOC SLICE_X278Y292 [get_cells gtze2_inf_north/DRPDO10_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDO10_FD]
set_property LOC SLICE_X279Y292 [get_cells gtze2_inf_north/DRPDO10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO10_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO9_LUT1A]
set_property LOC SLICE_X279Y292 [get_cells gtze2_inf_north/DRPDO9_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO9_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO9_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X278Y292/BFF]
set_property PROHIBIT true [get_bels SLICE_X278Y292/B5FF]
set_property PROHIBIT true [get_bels SLICE_X278Y292/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO9_LUT1B]
set_property LOC SLICE_X279Y292 [get_cells gtze2_inf_north/DRPDO9_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO9_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO9_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X278Y292/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO9_FD]
set_property LOC SLICE_X278Y292 [get_cells gtze2_inf_north/DRPDO9_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO9_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO8_LUT1A]
set_property LOC SLICE_X278Y292 [get_cells gtze2_inf_north/DRPDO8_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO8_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO8_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO8_LUT1B]
set_property LOC SLICE_X278Y292 [get_cells gtze2_inf_north/DRPDO8_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO8_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO8_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y292/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO8_FD]
set_property LOC SLICE_X279Y292 [get_cells gtze2_inf_north/DRPDO8_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO8_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/DRPDO7_LUT1A]
set_property LOC SLICE_X278Y287 [get_cells gtze2_inf_north/DRPDO7_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDO7_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO7_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDO7_LUT1B]
set_property LOC SLICE_X278Y287 [get_cells gtze2_inf_north/DRPDO7_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPDO7_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO7_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y287/A5FF]
set_property PROHIBIT true [get_bels SLICE_X279Y287/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDO7_FD]
set_property LOC SLICE_X279Y287 [get_cells gtze2_inf_north/DRPDO7_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO7_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/DRPDO6_LUT1A]
set_property LOC SLICE_X278Y287 [get_cells gtze2_inf_north/DRPDO6_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO6_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO6_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDO6_LUT1B]
set_property LOC SLICE_X278Y287 [get_cells gtze2_inf_north/DRPDO6_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO6_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO6_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDO6_FD]
set_property LOC SLICE_X279Y287 [get_cells gtze2_inf_north/DRPDO6_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO6_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO5_LUT1A]
set_property LOC SLICE_X279Y287 [get_cells gtze2_inf_north/DRPDO5_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO5_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO5_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X278Y287/BFF]
set_property PROHIBIT true [get_bels SLICE_X278Y287/B5FF]
set_property PROHIBIT true [get_bels SLICE_X278Y287/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO5_LUT1B]
set_property LOC SLICE_X279Y287 [get_cells gtze2_inf_north/DRPDO5_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO5_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO5_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X278Y287/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO5_FD]
set_property LOC SLICE_X278Y287 [get_cells gtze2_inf_north/DRPDO5_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO5_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO4_LUT1A]
set_property LOC SLICE_X278Y287 [get_cells gtze2_inf_north/DRPDO4_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO4_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO4_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO4_LUT1B]
set_property LOC SLICE_X278Y287 [get_cells gtze2_inf_north/DRPDO4_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO4_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO4_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y287/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO4_FD]
set_property LOC SLICE_X279Y287 [get_cells gtze2_inf_north/DRPDO4_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO4_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/DRPDO3_LUT1A]
set_property LOC SLICE_X278Y282 [get_cells gtze2_inf_north/DRPDO3_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDO3_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO3_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDO3_LUT1B]
set_property LOC SLICE_X278Y282 [get_cells gtze2_inf_north/DRPDO3_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPDO3_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO3_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y282/A5FF]
set_property PROHIBIT true [get_bels SLICE_X279Y282/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDO3_FD]
set_property LOC SLICE_X279Y282 [get_cells gtze2_inf_north/DRPDO3_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO3_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/DRPDO2_LUT1A]
set_property LOC SLICE_X278Y282 [get_cells gtze2_inf_north/DRPDO2_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO2_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO2_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDO2_LUT1B]
set_property LOC SLICE_X278Y282 [get_cells gtze2_inf_north/DRPDO2_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO2_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO2_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDO2_FD]
set_property LOC SLICE_X279Y282 [get_cells gtze2_inf_north/DRPDO2_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO2_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO1_LUT1A]
set_property LOC SLICE_X279Y282 [get_cells gtze2_inf_north/DRPDO1_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO1_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO1_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X278Y282/BFF]
set_property PROHIBIT true [get_bels SLICE_X278Y282/B5FF]
set_property PROHIBIT true [get_bels SLICE_X278Y282/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO1_LUT1B]
set_property LOC SLICE_X279Y282 [get_cells gtze2_inf_north/DRPDO1_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO1_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO1_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X278Y282/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO1_FD]
set_property LOC SLICE_X278Y282 [get_cells gtze2_inf_north/DRPDO1_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO1_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO0_LUT1A]
set_property LOC SLICE_X278Y282 [get_cells gtze2_inf_north/DRPDO0_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO0_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO0_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO0_LUT1B]
set_property LOC SLICE_X278Y282 [get_cells gtze2_inf_north/DRPDO0_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO0_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO0_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y282/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO0_FD]
set_property LOC SLICE_X279Y282 [get_cells gtze2_inf_north/DRPDO0_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO0_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID34_LUT1A]
set_property LOC SLICE_X179Y272 [get_cells gtze2_inf_north/RXDATAVALID34_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID34_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID34_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X178Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X178Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X178Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID34_LUT1B]
set_property LOC SLICE_X179Y272 [get_cells gtze2_inf_north/RXDATAVALID34_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID34_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID34_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X178Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID34_FD]
set_property LOC SLICE_X178Y272 [get_cells gtze2_inf_north/RXDATAVALID34_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID34_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID33_LUT1A]
set_property LOC SLICE_X181Y272 [get_cells gtze2_inf_north/RXDATAVALID33_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID33_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID33_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X180Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X180Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X180Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID33_LUT1B]
set_property LOC SLICE_X181Y272 [get_cells gtze2_inf_north/RXDATAVALID33_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID33_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID33_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X180Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID33_FD]
set_property LOC SLICE_X180Y272 [get_cells gtze2_inf_north/RXDATAVALID33_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID33_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID32_LUT1A]
set_property LOC SLICE_X183Y272 [get_cells gtze2_inf_north/RXDATAVALID32_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID32_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID32_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X182Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X182Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X182Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID32_LUT1B]
set_property LOC SLICE_X183Y272 [get_cells gtze2_inf_north/RXDATAVALID32_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID32_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID32_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X182Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID32_FD]
set_property LOC SLICE_X182Y272 [get_cells gtze2_inf_north/RXDATAVALID32_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID32_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID31_LUT1A]
set_property LOC SLICE_X185Y272 [get_cells gtze2_inf_north/RXDATAVALID31_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID31_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID31_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X184Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X184Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X184Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID31_LUT1B]
set_property LOC SLICE_X185Y272 [get_cells gtze2_inf_north/RXDATAVALID31_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X184Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID31_FD]
set_property LOC SLICE_X184Y272 [get_cells gtze2_inf_north/RXDATAVALID31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID31_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID30_LUT1A]
set_property LOC SLICE_X187Y272 [get_cells gtze2_inf_north/RXDATAVALID30_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID30_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID30_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X186Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X186Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X186Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID30_LUT1B]
set_property LOC SLICE_X187Y272 [get_cells gtze2_inf_north/RXDATAVALID30_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X186Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID30_FD]
set_property LOC SLICE_X186Y272 [get_cells gtze2_inf_north/RXDATAVALID30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID30_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/DRPDO31_LUT1A]
set_property LOC SLICE_X276Y297 [get_cells gtze2_inf_north/DRPDO31_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDO31_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO31_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDO31_LUT1B]
set_property LOC SLICE_X276Y297 [get_cells gtze2_inf_north/DRPDO31_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPDO31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y297/A5FF]
set_property PROHIBIT true [get_bels SLICE_X277Y297/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDO31_FD]
set_property LOC SLICE_X277Y297 [get_cells gtze2_inf_north/DRPDO31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO31_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/DRPDO30_LUT1A]
set_property LOC SLICE_X276Y297 [get_cells gtze2_inf_north/DRPDO30_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO30_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO30_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDO30_LUT1B]
set_property LOC SLICE_X276Y297 [get_cells gtze2_inf_north/DRPDO30_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDO30_FD]
set_property LOC SLICE_X277Y297 [get_cells gtze2_inf_north/DRPDO30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO30_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO29_LUT1A]
set_property LOC SLICE_X277Y297 [get_cells gtze2_inf_north/DRPDO29_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO29_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO29_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X276Y297/BFF]
set_property PROHIBIT true [get_bels SLICE_X276Y297/B5FF]
set_property PROHIBIT true [get_bels SLICE_X276Y297/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO29_LUT1B]
set_property LOC SLICE_X277Y297 [get_cells gtze2_inf_north/DRPDO29_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO29_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO29_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X276Y297/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO29_FD]
set_property LOC SLICE_X276Y297 [get_cells gtze2_inf_north/DRPDO29_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO29_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO28_LUT1A]
set_property LOC SLICE_X276Y297 [get_cells gtze2_inf_north/DRPDO28_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO28_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO28_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO28_LUT1B]
set_property LOC SLICE_X276Y297 [get_cells gtze2_inf_north/DRPDO28_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO28_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO28_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y297/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO28_FD]
set_property LOC SLICE_X277Y297 [get_cells gtze2_inf_north/DRPDO28_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO28_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/DRPDO27_LUT1A]
set_property LOC SLICE_X276Y292 [get_cells gtze2_inf_north/DRPDO27_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDO27_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO27_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDO27_LUT1B]
set_property LOC SLICE_X276Y292 [get_cells gtze2_inf_north/DRPDO27_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPDO27_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO27_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y292/A5FF]
set_property PROHIBIT true [get_bels SLICE_X277Y292/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDO27_FD]
set_property LOC SLICE_X277Y292 [get_cells gtze2_inf_north/DRPDO27_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO27_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/DRPDO26_LUT1A]
set_property LOC SLICE_X276Y292 [get_cells gtze2_inf_north/DRPDO26_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO26_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO26_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDO26_LUT1B]
set_property LOC SLICE_X276Y292 [get_cells gtze2_inf_north/DRPDO26_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO26_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO26_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDO26_FD]
set_property LOC SLICE_X277Y292 [get_cells gtze2_inf_north/DRPDO26_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO26_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO25_LUT1A]
set_property LOC SLICE_X277Y292 [get_cells gtze2_inf_north/DRPDO25_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO25_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO25_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X276Y292/BFF]
set_property PROHIBIT true [get_bels SLICE_X276Y292/B5FF]
set_property PROHIBIT true [get_bels SLICE_X276Y292/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO25_LUT1B]
set_property LOC SLICE_X277Y292 [get_cells gtze2_inf_north/DRPDO25_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO25_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO25_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X276Y292/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO25_FD]
set_property LOC SLICE_X276Y292 [get_cells gtze2_inf_north/DRPDO25_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO25_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO24_LUT1A]
set_property LOC SLICE_X276Y292 [get_cells gtze2_inf_north/DRPDO24_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO24_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO24_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO24_LUT1B]
set_property LOC SLICE_X276Y292 [get_cells gtze2_inf_north/DRPDO24_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y292/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO24_FD]
set_property LOC SLICE_X277Y292 [get_cells gtze2_inf_north/DRPDO24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO24_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/DRPDO23_LUT1A]
set_property LOC SLICE_X276Y287 [get_cells gtze2_inf_north/DRPDO23_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDO23_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO23_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDO23_LUT1B]
set_property LOC SLICE_X276Y287 [get_cells gtze2_inf_north/DRPDO23_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPDO23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y287/A5FF]
set_property PROHIBIT true [get_bels SLICE_X277Y287/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDO23_FD]
set_property LOC SLICE_X277Y287 [get_cells gtze2_inf_north/DRPDO23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO23_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/DRPDO22_LUT1A]
set_property LOC SLICE_X276Y287 [get_cells gtze2_inf_north/DRPDO22_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO22_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO22_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDO22_LUT1B]
set_property LOC SLICE_X276Y287 [get_cells gtze2_inf_north/DRPDO22_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDO22_FD]
set_property LOC SLICE_X277Y287 [get_cells gtze2_inf_north/DRPDO22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO22_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO21_LUT1A]
set_property LOC SLICE_X277Y287 [get_cells gtze2_inf_north/DRPDO21_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO21_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO21_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X276Y287/BFF]
set_property PROHIBIT true [get_bels SLICE_X276Y287/B5FF]
set_property PROHIBIT true [get_bels SLICE_X276Y287/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO21_LUT1B]
set_property LOC SLICE_X277Y287 [get_cells gtze2_inf_north/DRPDO21_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X276Y287/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO21_FD]
set_property LOC SLICE_X276Y287 [get_cells gtze2_inf_north/DRPDO21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO21_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO20_LUT1A]
set_property LOC SLICE_X276Y287 [get_cells gtze2_inf_north/DRPDO20_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO20_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO20_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO20_LUT1B]
set_property LOC SLICE_X276Y287 [get_cells gtze2_inf_north/DRPDO20_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y287/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO20_FD]
set_property LOC SLICE_X277Y287 [get_cells gtze2_inf_north/DRPDO20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO20_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/DRPDO19_LUT1A]
set_property LOC SLICE_X276Y282 [get_cells gtze2_inf_north/DRPDO19_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDO19_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO19_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDO19_LUT1B]
set_property LOC SLICE_X276Y282 [get_cells gtze2_inf_north/DRPDO19_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPDO19_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO19_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y282/A5FF]
set_property PROHIBIT true [get_bels SLICE_X277Y282/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDO19_FD]
set_property LOC SLICE_X277Y282 [get_cells gtze2_inf_north/DRPDO19_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO19_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/DRPDO18_LUT1A]
set_property LOC SLICE_X276Y282 [get_cells gtze2_inf_north/DRPDO18_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO18_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO18_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDO18_LUT1B]
set_property LOC SLICE_X276Y282 [get_cells gtze2_inf_north/DRPDO18_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO18_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO18_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDO18_FD]
set_property LOC SLICE_X277Y282 [get_cells gtze2_inf_north/DRPDO18_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO18_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO17_LUT1A]
set_property LOC SLICE_X277Y282 [get_cells gtze2_inf_north/DRPDO17_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO17_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO17_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X276Y282/BFF]
set_property PROHIBIT true [get_bels SLICE_X276Y282/B5FF]
set_property PROHIBIT true [get_bels SLICE_X276Y282/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO17_LUT1B]
set_property LOC SLICE_X277Y282 [get_cells gtze2_inf_north/DRPDO17_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO17_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO17_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X276Y282/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO17_FD]
set_property LOC SLICE_X276Y282 [get_cells gtze2_inf_north/DRPDO17_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO17_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO16_LUT1A]
set_property LOC SLICE_X276Y282 [get_cells gtze2_inf_north/DRPDO16_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO16_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO16_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO16_LUT1B]
set_property LOC SLICE_X276Y282 [get_cells gtze2_inf_north/DRPDO16_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO16_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO16_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y282/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO16_FD]
set_property LOC SLICE_X277Y282 [get_cells gtze2_inf_north/DRPDO16_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO16_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/DRPDO15_LUT1A]
set_property LOC SLICE_X278Y297 [get_cells gtze2_inf_north/DRPDO15_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDO15_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO15_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDO15_LUT1B]
set_property LOC SLICE_X278Y297 [get_cells gtze2_inf_north/DRPDO15_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPDO15_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO15_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y297/A5FF]
set_property PROHIBIT true [get_bels SLICE_X279Y297/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDO15_FD]
set_property LOC SLICE_X279Y297 [get_cells gtze2_inf_north/DRPDO15_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO15_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/DRPDO14_LUT1A]
set_property LOC SLICE_X278Y297 [get_cells gtze2_inf_north/DRPDO14_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO14_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO14_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDO14_LUT1B]
set_property LOC SLICE_X278Y297 [get_cells gtze2_inf_north/DRPDO14_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDO14_FD]
set_property LOC SLICE_X279Y297 [get_cells gtze2_inf_north/DRPDO14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO14_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO13_LUT1A]
set_property LOC SLICE_X279Y297 [get_cells gtze2_inf_north/DRPDO13_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO13_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO13_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X278Y297/BFF]
set_property PROHIBIT true [get_bels SLICE_X278Y297/B5FF]
set_property PROHIBIT true [get_bels SLICE_X278Y297/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO13_LUT1B]
set_property LOC SLICE_X279Y297 [get_cells gtze2_inf_north/DRPDO13_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X278Y297/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO13_FD]
set_property LOC SLICE_X278Y297 [get_cells gtze2_inf_north/DRPDO13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO13_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/DRPDO12_LUT1A]
set_property LOC SLICE_X278Y297 [get_cells gtze2_inf_north/DRPDO12_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPDO12_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO12_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDO12_LUT1B]
set_property LOC SLICE_X278Y297 [get_cells gtze2_inf_north/DRPDO12_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/DRPDO12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y297/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDO12_FD]
set_property LOC SLICE_X279Y297 [get_cells gtze2_inf_north/DRPDO12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDO12_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA284_LUT1A]
set_property LOC SLICE_X162Y272 [get_cells gtze2_inf_north/RXDATA284_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA284_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA284_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA284_LUT1B]
set_property LOC SLICE_X162Y272 [get_cells gtze2_inf_north/RXDATA284_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA284_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA284_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y272/A5FF]
set_property PROHIBIT true [get_bels SLICE_X163Y272/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA284_FD]
set_property LOC SLICE_X163Y272 [get_cells gtze2_inf_north/RXDATA284_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA284_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA283_LUT1A]
set_property LOC SLICE_X162Y277 [get_cells gtze2_inf_north/RXDATA283_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA283_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA283_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA283_LUT1B]
set_property LOC SLICE_X162Y277 [get_cells gtze2_inf_north/RXDATA283_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA283_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA283_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X163Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA283_FD]
set_property LOC SLICE_X163Y277 [get_cells gtze2_inf_north/RXDATA283_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA283_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA282_LUT1A]
set_property LOC SLICE_X162Y277 [get_cells gtze2_inf_north/RXDATA282_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA282_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA282_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA282_LUT1B]
set_property LOC SLICE_X162Y277 [get_cells gtze2_inf_north/RXDATA282_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA282_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA282_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA282_FD]
set_property LOC SLICE_X163Y277 [get_cells gtze2_inf_north/RXDATA282_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA282_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA281_LUT1A]
set_property LOC SLICE_X162Y277 [get_cells gtze2_inf_north/RXDATA281_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA281_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA281_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA281_LUT1B]
set_property LOC SLICE_X162Y277 [get_cells gtze2_inf_north/RXDATA281_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA281_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA281_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA281_FD]
set_property LOC SLICE_X163Y277 [get_cells gtze2_inf_north/RXDATA281_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA281_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA280_LUT1A]
set_property LOC SLICE_X162Y277 [get_cells gtze2_inf_north/RXDATA280_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA280_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA280_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA280_LUT1B]
set_property LOC SLICE_X162Y277 [get_cells gtze2_inf_north/RXDATA280_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA280_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA280_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA280_FD]
set_property LOC SLICE_X163Y277 [get_cells gtze2_inf_north/RXDATA280_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA280_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA279_LUT1A]
set_property LOC SLICE_X162Y282 [get_cells gtze2_inf_north/RXDATA279_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA279_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA279_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA279_LUT1B]
set_property LOC SLICE_X162Y282 [get_cells gtze2_inf_north/RXDATA279_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA279_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA279_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X163Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA279_FD]
set_property LOC SLICE_X163Y282 [get_cells gtze2_inf_north/RXDATA279_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA279_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA278_LUT1A]
set_property LOC SLICE_X162Y282 [get_cells gtze2_inf_north/RXDATA278_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA278_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA278_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA278_LUT1B]
set_property LOC SLICE_X162Y282 [get_cells gtze2_inf_north/RXDATA278_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA278_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA278_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA278_FD]
set_property LOC SLICE_X163Y282 [get_cells gtze2_inf_north/RXDATA278_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA278_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA277_LUT1A]
set_property LOC SLICE_X162Y282 [get_cells gtze2_inf_north/RXDATA277_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA277_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA277_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA277_LUT1B]
set_property LOC SLICE_X162Y282 [get_cells gtze2_inf_north/RXDATA277_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA277_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA277_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA277_FD]
set_property LOC SLICE_X163Y282 [get_cells gtze2_inf_north/RXDATA277_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA277_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0127_LUT1B]
set_property LOC SLICE_X99Y250 [get_cells gtze2_inf_north/TXDATA0127_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0127_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0127_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X99Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0127_FD]
set_property LOC SLICE_X99Y250 [get_cells gtze2_inf_north/TXDATA0127_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0127_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0126_LUT1B]
set_property LOC SLICE_X99Y250 [get_cells gtze2_inf_north/TXDATA0126_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0126_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0126_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0126_FD]
set_property LOC SLICE_X99Y250 [get_cells gtze2_inf_north/TXDATA0126_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0126_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0125_LUT1B]
set_property LOC SLICE_X99Y250 [get_cells gtze2_inf_north/TXDATA0125_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0125_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0125_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0125_FD]
set_property LOC SLICE_X99Y250 [get_cells gtze2_inf_north/TXDATA0125_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0125_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA040_LUT1B]
set_property LOC SLICE_X103Y275 [get_cells gtze2_inf_north/TXDATA040_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA040_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA040_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y275/B5FF]
set_property PROHIBIT true [get_bels SLICE_X103Y275/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA040_FD]
set_property LOC SLICE_X103Y275 [get_cells gtze2_inf_north/TXDATA040_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA040_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA039_LUT1B]
set_property LOC SLICE_X103Y280 [get_cells gtze2_inf_north/TXDATA039_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA039_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA039_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X103Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA039_FD]
set_property LOC SLICE_X103Y280 [get_cells gtze2_inf_north/TXDATA039_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA039_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA038_LUT1B]
set_property LOC SLICE_X103Y280 [get_cells gtze2_inf_north/TXDATA038_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA038_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA038_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA038_FD]
set_property LOC SLICE_X103Y280 [get_cells gtze2_inf_north/TXDATA038_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA038_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA037_LUT1B]
set_property LOC SLICE_X103Y280 [get_cells gtze2_inf_north/TXDATA037_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA037_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA037_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA037_FD]
set_property LOC SLICE_X103Y280 [get_cells gtze2_inf_north/TXDATA037_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA037_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA036_LUT1B]
set_property LOC SLICE_X103Y280 [get_cells gtze2_inf_north/TXDATA036_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA036_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA036_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA036_FD]
set_property LOC SLICE_X103Y280 [get_cells gtze2_inf_north/TXDATA036_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA036_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA035_LUT1B]
set_property LOC SLICE_X103Y285 [get_cells gtze2_inf_north/TXDATA035_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA035_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA035_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X103Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA035_FD]
set_property LOC SLICE_X103Y285 [get_cells gtze2_inf_north/TXDATA035_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA035_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA034_LUT1B]
set_property LOC SLICE_X103Y285 [get_cells gtze2_inf_north/TXDATA034_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA034_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA034_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA034_FD]
set_property LOC SLICE_X103Y285 [get_cells gtze2_inf_north/TXDATA034_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA034_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA033_LUT1B]
set_property LOC SLICE_X103Y285 [get_cells gtze2_inf_north/TXDATA033_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA033_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA033_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA033_FD]
set_property LOC SLICE_X103Y285 [get_cells gtze2_inf_north/TXDATA033_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA033_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA00_LUT1B]
set_property LOC SLICE_X117Y285 [get_cells gtze2_inf_north/TXDATA00_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA00_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA00_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y285/B5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y285/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA00_FD]
set_property LOC SLICE_X117Y285 [get_cells gtze2_inf_north/TXDATA00_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA00_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA022_LUT1B]
set_property LOC SLICE_X117Y260 [get_cells gtze2_inf_north/TXDATA022_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA022_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA022_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA022_FD]
set_property LOC SLICE_X117Y260 [get_cells gtze2_inf_north/TXDATA022_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA022_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA021_LUT1B]
set_property LOC SLICE_X117Y260 [get_cells gtze2_inf_north/TXDATA021_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA021_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA021_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA021_FD]
set_property LOC SLICE_X117Y260 [get_cells gtze2_inf_north/TXDATA021_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA021_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA020_LUT1B]
set_property LOC SLICE_X117Y260 [get_cells gtze2_inf_north/TXDATA020_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA020_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA020_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA020_FD]
set_property LOC SLICE_X117Y260 [get_cells gtze2_inf_north/TXDATA020_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA020_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA019_LUT1B]
set_property LOC SLICE_X117Y265 [get_cells gtze2_inf_north/TXDATA019_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA019_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA019_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA019_FD]
set_property LOC SLICE_X117Y265 [get_cells gtze2_inf_north/TXDATA019_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA019_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA018_LUT1B]
set_property LOC SLICE_X117Y265 [get_cells gtze2_inf_north/TXDATA018_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA018_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA018_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA018_FD]
set_property LOC SLICE_X117Y265 [get_cells gtze2_inf_north/TXDATA018_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA018_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA017_LUT1B]
set_property LOC SLICE_X117Y265 [get_cells gtze2_inf_north/TXDATA017_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA017_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA017_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA017_FD]
set_property LOC SLICE_X117Y265 [get_cells gtze2_inf_north/TXDATA017_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA017_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA016_LUT1B]
set_property LOC SLICE_X117Y265 [get_cells gtze2_inf_north/TXDATA016_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA016_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA016_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA016_FD]
set_property LOC SLICE_X117Y265 [get_cells gtze2_inf_north/TXDATA016_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA016_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA015_LUT1B]
set_property LOC SLICE_X117Y270 [get_cells gtze2_inf_north/TXDATA015_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA015_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA015_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA015_FD]
set_property LOC SLICE_X117Y270 [get_cells gtze2_inf_north/TXDATA015_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA015_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA014_LUT1B]
set_property LOC SLICE_X117Y270 [get_cells gtze2_inf_north/TXDATA014_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA014_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA014_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA014_FD]
set_property LOC SLICE_X117Y270 [get_cells gtze2_inf_north/TXDATA014_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA014_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA013_LUT1B]
set_property LOC SLICE_X117Y270 [get_cells gtze2_inf_north/TXDATA013_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA013_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA013_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA013_FD]
set_property LOC SLICE_X117Y270 [get_cells gtze2_inf_north/TXDATA013_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA013_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA012_LUT1B]
set_property LOC SLICE_X117Y270 [get_cells gtze2_inf_north/TXDATA012_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA012_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA012_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA012_FD]
set_property LOC SLICE_X117Y270 [get_cells gtze2_inf_north/TXDATA012_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA012_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA011_LUT1B]
set_property LOC SLICE_X117Y275 [get_cells gtze2_inf_north/TXDATA011_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA011_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA011_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA011_FD]
set_property LOC SLICE_X117Y275 [get_cells gtze2_inf_north/TXDATA011_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA011_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA010_LUT1B]
set_property LOC SLICE_X117Y275 [get_cells gtze2_inf_north/TXDATA010_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA010_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA010_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA010_FD]
set_property LOC SLICE_X117Y275 [get_cells gtze2_inf_north/TXDATA010_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA010_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA09_LUT1B]
set_property LOC SLICE_X117Y275 [get_cells gtze2_inf_north/TXDATA09_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA09_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA09_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA09_FD]
set_property LOC SLICE_X117Y275 [get_cells gtze2_inf_north/TXDATA09_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA09_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA08_LUT1B]
set_property LOC SLICE_X117Y275 [get_cells gtze2_inf_north/TXDATA08_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA08_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA08_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA08_FD]
set_property LOC SLICE_X117Y275 [get_cells gtze2_inf_north/TXDATA08_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA08_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA07_LUT1B]
set_property LOC SLICE_X117Y280 [get_cells gtze2_inf_north/TXDATA07_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA07_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA07_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA07_FD]
set_property LOC SLICE_X117Y280 [get_cells gtze2_inf_north/TXDATA07_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA07_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA06_LUT1B]
set_property LOC SLICE_X117Y280 [get_cells gtze2_inf_north/TXDATA06_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA06_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA06_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA06_FD]
set_property LOC SLICE_X117Y280 [get_cells gtze2_inf_north/TXDATA06_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA06_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA05_LUT1B]
set_property LOC SLICE_X117Y280 [get_cells gtze2_inf_north/TXDATA05_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA05_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA05_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA05_FD]
set_property LOC SLICE_X117Y280 [get_cells gtze2_inf_north/TXDATA05_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA05_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA04_LUT1B]
set_property LOC SLICE_X117Y280 [get_cells gtze2_inf_north/TXDATA04_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA04_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA04_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA04_FD]
set_property LOC SLICE_X117Y280 [get_cells gtze2_inf_north/TXDATA04_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA04_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA03_LUT1B]
set_property LOC SLICE_X117Y285 [get_cells gtze2_inf_north/TXDATA03_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA03_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA03_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y285/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA03_FD]
set_property LOC SLICE_X117Y285 [get_cells gtze2_inf_north/TXDATA03_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA03_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA02_LUT1B]
set_property LOC SLICE_X117Y285 [get_cells gtze2_inf_north/TXDATA02_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA02_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA02_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA02_FD]
set_property LOC SLICE_X117Y285 [get_cells gtze2_inf_north/TXDATA02_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA02_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA01_LUT1B]
set_property LOC SLICE_X117Y285 [get_cells gtze2_inf_north/TXDATA01_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA01_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA01_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA01_FD]
set_property LOC SLICE_X117Y285 [get_cells gtze2_inf_north/TXDATA01_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA01_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0115_LUT1B]
set_property LOC SLICE_X99Y265 [get_cells gtze2_inf_north/TXDATA0115_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0115_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0115_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y265/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0115_FD]
set_property LOC SLICE_X99Y265 [get_cells gtze2_inf_north/TXDATA0115_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0115_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0114_LUT1B]
set_property LOC SLICE_X99Y265 [get_cells gtze2_inf_north/TXDATA0114_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0114_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0114_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0114_FD]
set_property LOC SLICE_X99Y265 [get_cells gtze2_inf_north/TXDATA0114_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0114_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0113_LUT1B]
set_property LOC SLICE_X99Y265 [get_cells gtze2_inf_north/TXDATA0113_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0113_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0113_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0113_FD]
set_property LOC SLICE_X99Y265 [get_cells gtze2_inf_north/TXDATA0113_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0113_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA385_LUT1B]
set_property LOC SLICE_X173Y260 [get_cells gtze2_inf_north/TXDATA385_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA385_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA385_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y260/A5FF]
set_property PROHIBIT true [get_bels SLICE_X173Y260/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA385_FD]
set_property LOC SLICE_X173Y260 [get_cells gtze2_inf_north/TXDATA385_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA385_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA384_LUT1B]
set_property LOC SLICE_X173Y260 [get_cells gtze2_inf_north/TXDATA384_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA384_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA384_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA384_FD]
set_property LOC SLICE_X173Y260 [get_cells gtze2_inf_north/TXDATA384_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA384_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA345_LUT1B]
set_property LOC SLICE_X175Y270 [get_cells gtze2_inf_north/TXDATA345_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA345_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA345_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA345_FD]
set_property LOC SLICE_X175Y270 [get_cells gtze2_inf_north/TXDATA345_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA345_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA344_LUT1B]
set_property LOC SLICE_X175Y270 [get_cells gtze2_inf_north/TXDATA344_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA344_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA344_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA344_FD]
set_property LOC SLICE_X175Y270 [get_cells gtze2_inf_north/TXDATA344_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA344_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA343_LUT1B]
set_property LOC SLICE_X175Y275 [get_cells gtze2_inf_north/TXDATA343_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA343_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA343_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X175Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA343_FD]
set_property LOC SLICE_X175Y275 [get_cells gtze2_inf_north/TXDATA343_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA343_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA342_LUT1B]
set_property LOC SLICE_X175Y275 [get_cells gtze2_inf_north/TXDATA342_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA342_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA342_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA342_FD]
set_property LOC SLICE_X175Y275 [get_cells gtze2_inf_north/TXDATA342_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA342_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA341_LUT1B]
set_property LOC SLICE_X175Y275 [get_cells gtze2_inf_north/TXDATA341_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA341_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA341_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA341_FD]
set_property LOC SLICE_X175Y275 [get_cells gtze2_inf_north/TXDATA341_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA341_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA340_LUT1B]
set_property LOC SLICE_X175Y275 [get_cells gtze2_inf_north/TXDATA340_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA340_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA340_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA340_FD]
set_property LOC SLICE_X175Y275 [get_cells gtze2_inf_north/TXDATA340_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA340_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA339_LUT1B]
set_property LOC SLICE_X175Y280 [get_cells gtze2_inf_north/TXDATA339_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA339_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA339_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y280/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA339_FD]
set_property LOC SLICE_X175Y280 [get_cells gtze2_inf_north/TXDATA339_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA339_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA338_LUT1B]
set_property LOC SLICE_X175Y280 [get_cells gtze2_inf_north/TXDATA338_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA338_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA338_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA338_FD]
set_property LOC SLICE_X175Y280 [get_cells gtze2_inf_north/TXDATA338_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA338_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA032_LUT1B]
set_property LOC SLICE_X103Y285 [get_cells gtze2_inf_north/TXDATA032_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA032_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA032_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA032_FD]
set_property LOC SLICE_X103Y285 [get_cells gtze2_inf_north/TXDATA032_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA032_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA031_LUT1B]
set_property LOC SLICE_X117Y250 [get_cells gtze2_inf_north/TXDATA031_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA031_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA031_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA031_FD]
set_property LOC SLICE_X117Y250 [get_cells gtze2_inf_north/TXDATA031_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA031_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA030_LUT1B]
set_property LOC SLICE_X117Y250 [get_cells gtze2_inf_north/TXDATA030_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA030_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA030_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA030_FD]
set_property LOC SLICE_X117Y250 [get_cells gtze2_inf_north/TXDATA030_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA030_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA029_LUT1B]
set_property LOC SLICE_X117Y250 [get_cells gtze2_inf_north/TXDATA029_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA029_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA029_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA029_FD]
set_property LOC SLICE_X117Y250 [get_cells gtze2_inf_north/TXDATA029_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA029_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA028_LUT1B]
set_property LOC SLICE_X117Y250 [get_cells gtze2_inf_north/TXDATA028_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA028_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA028_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA028_FD]
set_property LOC SLICE_X117Y250 [get_cells gtze2_inf_north/TXDATA028_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA028_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA027_LUT1B]
set_property LOC SLICE_X117Y255 [get_cells gtze2_inf_north/TXDATA027_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA027_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA027_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA027_FD]
set_property LOC SLICE_X117Y255 [get_cells gtze2_inf_north/TXDATA027_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA027_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA026_LUT1B]
set_property LOC SLICE_X117Y255 [get_cells gtze2_inf_north/TXDATA026_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA026_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA026_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA026_FD]
set_property LOC SLICE_X117Y255 [get_cells gtze2_inf_north/TXDATA026_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA026_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA025_LUT1B]
set_property LOC SLICE_X117Y255 [get_cells gtze2_inf_north/TXDATA025_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA025_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA025_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA025_FD]
set_property LOC SLICE_X117Y255 [get_cells gtze2_inf_north/TXDATA025_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA025_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA024_LUT1B]
set_property LOC SLICE_X117Y255 [get_cells gtze2_inf_north/TXDATA024_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA024_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA024_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA024_FD]
set_property LOC SLICE_X117Y255 [get_cells gtze2_inf_north/TXDATA024_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA024_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA023_LUT1B]
set_property LOC SLICE_X117Y260 [get_cells gtze2_inf_north/TXDATA023_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA023_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA023_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA023_FD]
set_property LOC SLICE_X117Y260 [get_cells gtze2_inf_north/TXDATA023_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA023_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA375_LUT1B]
set_property LOC SLICE_X173Y275 [get_cells gtze2_inf_north/TXDATA375_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA375_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA375_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y275/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA375_FD]
set_property LOC SLICE_X173Y275 [get_cells gtze2_inf_north/TXDATA375_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA375_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA374_LUT1B]
set_property LOC SLICE_X173Y275 [get_cells gtze2_inf_north/TXDATA374_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA374_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA374_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA374_FD]
set_property LOC SLICE_X173Y275 [get_cells gtze2_inf_north/TXDATA374_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA374_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2145_LUT1A]
set_property LOC SLICE_X158Y277 [get_cells gtze2_inf_north/RXDATA2145_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2145_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2145_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2145_LUT1B]
set_property LOC SLICE_X158Y277 [get_cells gtze2_inf_north/RXDATA2145_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2145_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2145_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2145_FD]
set_property LOC SLICE_X159Y277 [get_cells gtze2_inf_north/RXDATA2145_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2145_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2144_LUT1A]
set_property LOC SLICE_X158Y277 [get_cells gtze2_inf_north/RXDATA2144_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2144_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2144_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2144_LUT1B]
set_property LOC SLICE_X158Y277 [get_cells gtze2_inf_north/RXDATA2144_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2144_FD]
set_property LOC SLICE_X159Y277 [get_cells gtze2_inf_north/RXDATA2144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2144_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2143_LUT1A]
set_property LOC SLICE_X158Y282 [get_cells gtze2_inf_north/RXDATA2143_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2143_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2143_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2143_LUT1B]
set_property LOC SLICE_X158Y282 [get_cells gtze2_inf_north/RXDATA2143_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X159Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2143_FD]
set_property LOC SLICE_X159Y282 [get_cells gtze2_inf_north/RXDATA2143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2143_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2142_LUT1A]
set_property LOC SLICE_X158Y282 [get_cells gtze2_inf_north/RXDATA2142_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2142_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2142_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2142_LUT1B]
set_property LOC SLICE_X158Y282 [get_cells gtze2_inf_north/RXDATA2142_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2142_FD]
set_property LOC SLICE_X159Y282 [get_cells gtze2_inf_north/RXDATA2142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2142_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2141_LUT1A]
set_property LOC SLICE_X158Y282 [get_cells gtze2_inf_north/RXDATA2141_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2141_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2141_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2141_LUT1B]
set_property LOC SLICE_X158Y282 [get_cells gtze2_inf_north/RXDATA2141_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2141_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2141_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2141_FD]
set_property LOC SLICE_X159Y282 [get_cells gtze2_inf_north/RXDATA2141_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2141_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2140_LUT1A]
set_property LOC SLICE_X158Y282 [get_cells gtze2_inf_north/RXDATA2140_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2140_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2140_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2140_LUT1B]
set_property LOC SLICE_X158Y282 [get_cells gtze2_inf_north/RXDATA2140_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2140_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2140_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2140_FD]
set_property LOC SLICE_X159Y282 [get_cells gtze2_inf_north/RXDATA2140_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2140_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2139_LUT1A]
set_property LOC SLICE_X158Y287 [get_cells gtze2_inf_north/RXDATA2139_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2139_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2139_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2139_LUT1B]
set_property LOC SLICE_X158Y287 [get_cells gtze2_inf_north/RXDATA2139_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2139_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2139_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y287/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2139_FD]
set_property LOC SLICE_X159Y287 [get_cells gtze2_inf_north/RXDATA2139_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2139_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2138_LUT1A]
set_property LOC SLICE_X158Y287 [get_cells gtze2_inf_north/RXDATA2138_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2138_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2138_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2138_LUT1B]
set_property LOC SLICE_X158Y287 [get_cells gtze2_inf_north/RXDATA2138_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2138_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2138_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2138_FD]
set_property LOC SLICE_X159Y287 [get_cells gtze2_inf_north/RXDATA2138_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2138_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/NEARLOOPBACKEN2_LUT1B]
set_property LOC SLICE_X157Y252 [get_cells gtze2_inf_north/NEARLOOPBACKEN2_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/NEARLOOPBACKEN2_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/NEARLOOPBACKEN2_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y252/A5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y252/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/NEARLOOPBACKEN2_FD]
set_property LOC SLICE_X157Y252 [get_cells gtze2_inf_north/NEARLOOPBACKEN2_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/NEARLOOPBACKEN2_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER23_LUT1B]
set_property LOC SLICE_X154Y285 [get_cells gtze2_inf_north/TXHEADER23_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X154Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X154Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER23_FD]
set_property LOC SLICE_X154Y285 [get_cells gtze2_inf_north/TXHEADER23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER23_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER22_LUT1B]
set_property LOC SLICE_X154Y280 [get_cells gtze2_inf_north/TXHEADER22_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X154Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X154Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER22_FD]
set_property LOC SLICE_X154Y280 [get_cells gtze2_inf_north/TXHEADER22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER22_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER21_LUT1B]
set_property LOC SLICE_X156Y285 [get_cells gtze2_inf_north/TXHEADER21_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X156Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X156Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER21_FD]
set_property LOC SLICE_X156Y285 [get_cells gtze2_inf_north/TXHEADER21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER21_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER20_LUT1B]
set_property LOC SLICE_X156Y280 [get_cells gtze2_inf_north/TXHEADER20_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X156Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X156Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER20_FD]
set_property LOC SLICE_X156Y280 [get_cells gtze2_inf_north/TXHEADER20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER20_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER09_LUT1A]
set_property LOC SLICE_X119Y262 [get_cells gtze2_inf_north/RXHEADER09_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER09_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER09_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X118Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X118Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X118Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER09_LUT1B]
set_property LOC SLICE_X119Y262 [get_cells gtze2_inf_north/RXHEADER09_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER09_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER09_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X118Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER09_FD]
set_property LOC SLICE_X118Y262 [get_cells gtze2_inf_north/RXHEADER09_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER09_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER08_LUT1A]
set_property LOC SLICE_X119Y267 [get_cells gtze2_inf_north/RXHEADER08_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER08_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER08_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X118Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X118Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X118Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER08_LUT1B]
set_property LOC SLICE_X119Y267 [get_cells gtze2_inf_north/RXHEADER08_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER08_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER08_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X118Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER08_FD]
set_property LOC SLICE_X118Y267 [get_cells gtze2_inf_north/RXHEADER08_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER08_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER07_LUT1A]
set_property LOC SLICE_X121Y262 [get_cells gtze2_inf_north/RXHEADER07_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER07_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER07_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X120Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X120Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X120Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER07_LUT1B]
set_property LOC SLICE_X121Y262 [get_cells gtze2_inf_north/RXHEADER07_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER07_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER07_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X120Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER07_FD]
set_property LOC SLICE_X120Y262 [get_cells gtze2_inf_north/RXHEADER07_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER07_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER06_LUT1A]
set_property LOC SLICE_X121Y267 [get_cells gtze2_inf_north/RXHEADER06_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER06_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER06_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X120Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X120Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X120Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER06_LUT1B]
set_property LOC SLICE_X121Y267 [get_cells gtze2_inf_north/RXHEADER06_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER06_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER06_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X120Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER06_FD]
set_property LOC SLICE_X120Y267 [get_cells gtze2_inf_north/RXHEADER06_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER06_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER05_LUT1A]
set_property LOC SLICE_X123Y262 [get_cells gtze2_inf_north/RXHEADER05_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER05_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER05_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X122Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X122Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X122Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER05_LUT1B]
set_property LOC SLICE_X123Y262 [get_cells gtze2_inf_north/RXHEADER05_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER05_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER05_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X122Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER05_FD]
set_property LOC SLICE_X122Y262 [get_cells gtze2_inf_north/RXHEADER05_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER05_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA292_LUT1A]
set_property LOC SLICE_X162Y262 [get_cells gtze2_inf_north/RXDATA292_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA292_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA292_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA292_LUT1B]
set_property LOC SLICE_X162Y262 [get_cells gtze2_inf_north/RXDATA292_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA292_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA292_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA292_FD]
set_property LOC SLICE_X163Y262 [get_cells gtze2_inf_north/RXDATA292_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA292_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA291_LUT1A]
set_property LOC SLICE_X162Y267 [get_cells gtze2_inf_north/RXDATA291_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA291_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA291_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA291_LUT1B]
set_property LOC SLICE_X162Y267 [get_cells gtze2_inf_north/RXDATA291_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA291_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA291_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X163Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA291_FD]
set_property LOC SLICE_X163Y267 [get_cells gtze2_inf_north/RXDATA291_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA291_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA290_LUT1A]
set_property LOC SLICE_X162Y267 [get_cells gtze2_inf_north/RXDATA290_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA290_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA290_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA290_LUT1B]
set_property LOC SLICE_X162Y267 [get_cells gtze2_inf_north/RXDATA290_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA290_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA290_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA290_FD]
set_property LOC SLICE_X163Y267 [get_cells gtze2_inf_north/RXDATA290_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA290_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA289_LUT1A]
set_property LOC SLICE_X162Y267 [get_cells gtze2_inf_north/RXDATA289_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA289_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA289_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA289_LUT1B]
set_property LOC SLICE_X162Y267 [get_cells gtze2_inf_north/RXDATA289_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA289_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA289_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA289_FD]
set_property LOC SLICE_X163Y267 [get_cells gtze2_inf_north/RXDATA289_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA289_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA288_LUT1A]
set_property LOC SLICE_X162Y267 [get_cells gtze2_inf_north/RXDATA288_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA288_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA288_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA288_LUT1B]
set_property LOC SLICE_X162Y267 [get_cells gtze2_inf_north/RXDATA288_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA288_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA288_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA288_FD]
set_property LOC SLICE_X163Y267 [get_cells gtze2_inf_north/RXDATA288_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA288_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA287_LUT1A]
set_property LOC SLICE_X162Y272 [get_cells gtze2_inf_north/RXDATA287_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA287_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA287_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA287_LUT1B]
set_property LOC SLICE_X162Y272 [get_cells gtze2_inf_north/RXDATA287_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA287_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA287_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA287_FD]
set_property LOC SLICE_X163Y272 [get_cells gtze2_inf_north/RXDATA287_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA287_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA286_LUT1A]
set_property LOC SLICE_X162Y272 [get_cells gtze2_inf_north/RXDATA286_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA286_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA286_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA286_LUT1B]
set_property LOC SLICE_X162Y272 [get_cells gtze2_inf_north/RXDATA286_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA286_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA286_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA286_FD]
set_property LOC SLICE_X163Y272 [get_cells gtze2_inf_north/RXDATA286_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA286_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA285_LUT1A]
set_property LOC SLICE_X162Y272 [get_cells gtze2_inf_north/RXDATA285_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA285_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA285_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA285_LUT1B]
set_property LOC SLICE_X162Y272 [get_cells gtze2_inf_north/RXDATA285_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA285_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA285_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA285_FD]
set_property LOC SLICE_X163Y272 [get_cells gtze2_inf_north/RXDATA285_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA285_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXOUTPUTEN0_LUT1B]
set_property LOC SLICE_X103Y252 [get_cells gtze2_inf_north/TXOUTPUTEN0_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXOUTPUTEN0_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXOUTPUTEN0_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y252/A5FF]
set_property PROHIBIT true [get_bels SLICE_X103Y252/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXOUTPUTEN0_FD]
set_property LOC SLICE_X103Y252 [get_cells gtze2_inf_north/TXOUTPUTEN0_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXOUTPUTEN0_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXRESETDONE0_LUT1A]
set_property LOC SLICE_X121Y287 [get_cells gtze2_inf_north/RXRESETDONE0_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXRESETDONE0_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE0_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X120Y287/BFF]
set_property PROHIBIT true [get_bels SLICE_X120Y287/B5FF]
set_property PROHIBIT true [get_bels SLICE_X120Y287/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXRESETDONE0_LUT1B]
set_property LOC SLICE_X121Y287 [get_cells gtze2_inf_north/RXRESETDONE0_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXRESETDONE0_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE0_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X120Y287/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXRESETDONE0_FD]
set_property LOC SLICE_X120Y287 [get_cells gtze2_inf_north/RXRESETDONE0_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE0_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP24_LUT1B]
set_property LOC SLICE_X157Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP24_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXGEARBOXSLIP24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y290/B5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y290/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/RXGEARBOXSLIP24_FD]
set_property LOC SLICE_X157Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP24_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP23_LUT1B]
set_property LOC SLICE_X157Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP23_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y290/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXGEARBOXSLIP23_FD]
set_property LOC SLICE_X157Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP23_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP22_LUT1B]
set_property LOC SLICE_X157Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP22_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y290/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXGEARBOXSLIP22_FD]
set_property LOC SLICE_X157Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP22_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP21_LUT1B]
set_property LOC SLICE_X157Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP21_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXGEARBOXSLIP21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y290/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXGEARBOXSLIP21_FD]
set_property LOC SLICE_X157Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP21_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID14_LUT1A]
set_property LOC SLICE_X139Y272 [get_cells gtze2_inf_north/RXDATAVALID14_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID14_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID14_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X138Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X138Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X138Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID14_LUT1B]
set_property LOC SLICE_X139Y272 [get_cells gtze2_inf_north/RXDATAVALID14_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X138Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID14_FD]
set_property LOC SLICE_X138Y272 [get_cells gtze2_inf_north/RXDATAVALID14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID14_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID13_LUT1A]
set_property LOC SLICE_X141Y272 [get_cells gtze2_inf_north/RXDATAVALID13_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID13_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID13_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X140Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X140Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X140Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID13_LUT1B]
set_property LOC SLICE_X141Y272 [get_cells gtze2_inf_north/RXDATAVALID13_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X140Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID13_FD]
set_property LOC SLICE_X140Y272 [get_cells gtze2_inf_north/RXDATAVALID13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID13_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID12_LUT1A]
set_property LOC SLICE_X143Y272 [get_cells gtze2_inf_north/RXDATAVALID12_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID12_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID12_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X142Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X142Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X142Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID12_LUT1B]
set_property LOC SLICE_X143Y272 [get_cells gtze2_inf_north/RXDATAVALID12_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X142Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID12_FD]
set_property LOC SLICE_X142Y272 [get_cells gtze2_inf_north/RXDATAVALID12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID12_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID11_LUT1A]
set_property LOC SLICE_X145Y272 [get_cells gtze2_inf_north/RXDATAVALID11_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID11_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID11_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X144Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X144Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X144Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID11_LUT1B]
set_property LOC SLICE_X145Y272 [get_cells gtze2_inf_north/RXDATAVALID11_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X144Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID11_FD]
set_property LOC SLICE_X144Y272 [get_cells gtze2_inf_north/RXDATAVALID11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID11_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID10_LUT1A]
set_property LOC SLICE_X147Y272 [get_cells gtze2_inf_north/RXDATAVALID10_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID10_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID10_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X146Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X146Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X146Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID10_LUT1B]
set_property LOC SLICE_X147Y272 [get_cells gtze2_inf_north/RXDATAVALID10_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X146Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID10_FD]
set_property LOC SLICE_X146Y272 [get_cells gtze2_inf_north/RXDATAVALID10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID10_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA121_LUT1B]
set_property LOC SLICE_X137Y260 [get_cells gtze2_inf_north/TXDATA121_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA121_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA121_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y260/A5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y260/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA121_FD]
set_property LOC SLICE_X137Y260 [get_cells gtze2_inf_north/TXDATA121_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA121_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA120_LUT1B]
set_property LOC SLICE_X137Y260 [get_cells gtze2_inf_north/TXDATA120_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA120_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA120_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA120_FD]
set_property LOC SLICE_X137Y260 [get_cells gtze2_inf_north/TXDATA120_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA120_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA119_LUT1B]
set_property LOC SLICE_X137Y265 [get_cells gtze2_inf_north/TXDATA119_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA119_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA119_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA119_FD]
set_property LOC SLICE_X137Y265 [get_cells gtze2_inf_north/TXDATA119_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA119_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA118_LUT1B]
set_property LOC SLICE_X137Y265 [get_cells gtze2_inf_north/TXDATA118_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA118_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA118_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA118_FD]
set_property LOC SLICE_X137Y265 [get_cells gtze2_inf_north/TXDATA118_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA118_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA117_LUT1B]
set_property LOC SLICE_X137Y265 [get_cells gtze2_inf_north/TXDATA117_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA117_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA117_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA117_FD]
set_property LOC SLICE_X137Y265 [get_cells gtze2_inf_north/TXDATA117_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA117_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA116_LUT1B]
set_property LOC SLICE_X137Y265 [get_cells gtze2_inf_north/TXDATA116_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA116_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA116_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA116_FD]
set_property LOC SLICE_X137Y265 [get_cells gtze2_inf_north/TXDATA116_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA116_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA115_LUT1B]
set_property LOC SLICE_X137Y270 [get_cells gtze2_inf_north/TXDATA115_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA115_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA115_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA115_FD]
set_property LOC SLICE_X137Y270 [get_cells gtze2_inf_north/TXDATA115_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA115_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA114_LUT1B]
set_property LOC SLICE_X137Y270 [get_cells gtze2_inf_north/TXDATA114_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA114_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA114_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA114_FD]
set_property LOC SLICE_X137Y270 [get_cells gtze2_inf_north/TXDATA114_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA114_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA113_LUT1B]
set_property LOC SLICE_X137Y270 [get_cells gtze2_inf_north/TXDATA113_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA113_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA113_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA113_FD]
set_property LOC SLICE_X137Y270 [get_cells gtze2_inf_north/TXDATA113_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA113_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA112_LUT1B]
set_property LOC SLICE_X137Y270 [get_cells gtze2_inf_north/TXDATA112_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA112_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA112_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA112_FD]
set_property LOC SLICE_X137Y270 [get_cells gtze2_inf_north/TXDATA112_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA112_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA111_LUT1B]
set_property LOC SLICE_X137Y275 [get_cells gtze2_inf_north/TXDATA111_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA111_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA111_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA111_FD]
set_property LOC SLICE_X137Y275 [get_cells gtze2_inf_north/TXDATA111_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA111_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA110_LUT1B]
set_property LOC SLICE_X137Y275 [get_cells gtze2_inf_north/TXDATA110_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA110_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA110_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA110_FD]
set_property LOC SLICE_X137Y275 [get_cells gtze2_inf_north/TXDATA110_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA110_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA19_LUT1B]
set_property LOC SLICE_X137Y275 [get_cells gtze2_inf_north/TXDATA19_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA19_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA19_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA19_FD]
set_property LOC SLICE_X137Y275 [get_cells gtze2_inf_north/TXDATA19_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA19_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA18_LUT1B]
set_property LOC SLICE_X137Y275 [get_cells gtze2_inf_north/TXDATA18_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA18_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA18_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA18_FD]
set_property LOC SLICE_X137Y275 [get_cells gtze2_inf_north/TXDATA18_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA18_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA17_LUT1B]
set_property LOC SLICE_X137Y280 [get_cells gtze2_inf_north/TXDATA17_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA17_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA17_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA17_FD]
set_property LOC SLICE_X137Y280 [get_cells gtze2_inf_north/TXDATA17_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA17_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA16_LUT1B]
set_property LOC SLICE_X137Y280 [get_cells gtze2_inf_north/TXDATA16_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA16_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA16_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA16_FD]
set_property LOC SLICE_X137Y280 [get_cells gtze2_inf_north/TXDATA16_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA16_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA15_LUT1B]
set_property LOC SLICE_X137Y280 [get_cells gtze2_inf_north/TXDATA15_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA15_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA15_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA15_FD]
set_property LOC SLICE_X137Y280 [get_cells gtze2_inf_north/TXDATA15_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA15_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA14_LUT1B]
set_property LOC SLICE_X137Y280 [get_cells gtze2_inf_north/TXDATA14_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA14_FD]
set_property LOC SLICE_X137Y280 [get_cells gtze2_inf_north/TXDATA14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA14_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA13_LUT1B]
set_property LOC SLICE_X137Y285 [get_cells gtze2_inf_north/TXDATA13_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA13_FD]
set_property LOC SLICE_X137Y285 [get_cells gtze2_inf_north/TXDATA13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA13_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA12_LUT1B]
set_property LOC SLICE_X137Y285 [get_cells gtze2_inf_north/TXDATA12_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA12_FD]
set_property LOC SLICE_X137Y285 [get_cells gtze2_inf_north/TXDATA12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA12_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA11_LUT1B]
set_property LOC SLICE_X137Y285 [get_cells gtze2_inf_north/TXDATA11_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA11_FD]
set_property LOC SLICE_X137Y285 [get_cells gtze2_inf_north/TXDATA11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA11_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA10_LUT1B]
set_property LOC SLICE_X137Y285 [get_cells gtze2_inf_north/TXDATA10_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA10_FD]
set_property LOC SLICE_X137Y285 [get_cells gtze2_inf_north/TXDATA10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA10_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA153_LUT1B]
set_property LOC SLICE_X135Y260 [get_cells gtze2_inf_north/TXDATA153_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA153_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA153_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y260/A5FF]
set_property PROHIBIT true [get_bels SLICE_X135Y260/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA153_FD]
set_property LOC SLICE_X135Y260 [get_cells gtze2_inf_north/TXDATA153_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA153_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA152_LUT1B]
set_property LOC SLICE_X135Y260 [get_cells gtze2_inf_north/TXDATA152_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA152_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA152_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA152_FD]
set_property LOC SLICE_X135Y260 [get_cells gtze2_inf_north/TXDATA152_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA152_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA151_LUT1B]
set_property LOC SLICE_X135Y265 [get_cells gtze2_inf_north/TXDATA151_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA151_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA151_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X135Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA151_FD]
set_property LOC SLICE_X135Y265 [get_cells gtze2_inf_north/TXDATA151_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA151_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA150_LUT1B]
set_property LOC SLICE_X135Y265 [get_cells gtze2_inf_north/TXDATA150_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA150_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA150_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA150_FD]
set_property LOC SLICE_X135Y265 [get_cells gtze2_inf_north/TXDATA150_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA150_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA149_LUT1B]
set_property LOC SLICE_X135Y265 [get_cells gtze2_inf_north/TXDATA149_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA149_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA149_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA149_FD]
set_property LOC SLICE_X135Y265 [get_cells gtze2_inf_north/TXDATA149_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA149_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA148_LUT1B]
set_property LOC SLICE_X135Y265 [get_cells gtze2_inf_north/TXDATA148_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA148_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA148_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA148_FD]
set_property LOC SLICE_X135Y265 [get_cells gtze2_inf_north/TXDATA148_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA148_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA147_LUT1B]
set_property LOC SLICE_X135Y270 [get_cells gtze2_inf_north/TXDATA147_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA147_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA147_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X135Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA147_FD]
set_property LOC SLICE_X135Y270 [get_cells gtze2_inf_north/TXDATA147_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA147_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA146_LUT1B]
set_property LOC SLICE_X135Y270 [get_cells gtze2_inf_north/TXDATA146_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA146_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA146_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA146_FD]
set_property LOC SLICE_X135Y270 [get_cells gtze2_inf_north/TXDATA146_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA146_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA145_LUT1B]
set_property LOC SLICE_X135Y270 [get_cells gtze2_inf_north/TXDATA145_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA145_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA145_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA145_FD]
set_property LOC SLICE_X135Y270 [get_cells gtze2_inf_north/TXDATA145_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA145_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA144_LUT1B]
set_property LOC SLICE_X135Y270 [get_cells gtze2_inf_north/TXDATA144_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA144_FD]
set_property LOC SLICE_X135Y270 [get_cells gtze2_inf_north/TXDATA144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA144_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA143_LUT1B]
set_property LOC SLICE_X135Y275 [get_cells gtze2_inf_north/TXDATA143_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X135Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA143_FD]
set_property LOC SLICE_X135Y275 [get_cells gtze2_inf_north/TXDATA143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA143_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA142_LUT1B]
set_property LOC SLICE_X135Y275 [get_cells gtze2_inf_north/TXDATA142_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA142_FD]
set_property LOC SLICE_X135Y275 [get_cells gtze2_inf_north/TXDATA142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA142_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA141_LUT1B]
set_property LOC SLICE_X135Y275 [get_cells gtze2_inf_north/TXDATA141_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA141_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA141_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA141_FD]
set_property LOC SLICE_X135Y275 [get_cells gtze2_inf_north/TXDATA141_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA141_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA140_LUT1B]
set_property LOC SLICE_X135Y275 [get_cells gtze2_inf_north/TXDATA140_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA140_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA140_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA140_FD]
set_property LOC SLICE_X135Y275 [get_cells gtze2_inf_north/TXDATA140_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA140_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA139_LUT1B]
set_property LOC SLICE_X135Y280 [get_cells gtze2_inf_north/TXDATA139_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA139_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA139_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X135Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA139_FD]
set_property LOC SLICE_X135Y280 [get_cells gtze2_inf_north/TXDATA139_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA139_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA138_LUT1B]
set_property LOC SLICE_X135Y280 [get_cells gtze2_inf_north/TXDATA138_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA138_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA138_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA138_FD]
set_property LOC SLICE_X135Y280 [get_cells gtze2_inf_north/TXDATA138_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA138_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA137_LUT1B]
set_property LOC SLICE_X135Y280 [get_cells gtze2_inf_north/TXDATA137_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA137_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA137_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA137_FD]
set_property LOC SLICE_X135Y280 [get_cells gtze2_inf_north/TXDATA137_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA137_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA136_LUT1B]
set_property LOC SLICE_X135Y280 [get_cells gtze2_inf_north/TXDATA136_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA136_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA136_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA136_FD]
set_property LOC SLICE_X135Y280 [get_cells gtze2_inf_north/TXDATA136_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA136_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA135_LUT1B]
set_property LOC SLICE_X135Y285 [get_cells gtze2_inf_north/TXDATA135_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA135_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA135_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X135Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA135_FD]
set_property LOC SLICE_X135Y285 [get_cells gtze2_inf_north/TXDATA135_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA135_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA134_LUT1B]
set_property LOC SLICE_X135Y285 [get_cells gtze2_inf_north/TXDATA134_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA134_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA134_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA134_FD]
set_property LOC SLICE_X135Y285 [get_cells gtze2_inf_north/TXDATA134_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA134_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA133_LUT1B]
set_property LOC SLICE_X135Y285 [get_cells gtze2_inf_north/TXDATA133_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA133_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA133_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA133_FD]
set_property LOC SLICE_X135Y285 [get_cells gtze2_inf_north/TXDATA133_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA133_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA132_LUT1B]
set_property LOC SLICE_X135Y285 [get_cells gtze2_inf_north/TXDATA132_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA132_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA132_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA132_FD]
set_property LOC SLICE_X135Y285 [get_cells gtze2_inf_north/TXDATA132_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA132_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA131_LUT1B]
set_property LOC SLICE_X137Y250 [get_cells gtze2_inf_north/TXDATA131_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA131_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA131_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA131_FD]
set_property LOC SLICE_X137Y250 [get_cells gtze2_inf_north/TXDATA131_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA131_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA130_LUT1B]
set_property LOC SLICE_X137Y250 [get_cells gtze2_inf_north/TXDATA130_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA130_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA130_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA130_FD]
set_property LOC SLICE_X137Y250 [get_cells gtze2_inf_north/TXDATA130_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA130_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA129_LUT1B]
set_property LOC SLICE_X137Y250 [get_cells gtze2_inf_north/TXDATA129_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA129_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA129_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA129_FD]
set_property LOC SLICE_X137Y250 [get_cells gtze2_inf_north/TXDATA129_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA129_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA128_LUT1B]
set_property LOC SLICE_X137Y250 [get_cells gtze2_inf_north/TXDATA128_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA128_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA128_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA128_FD]
set_property LOC SLICE_X137Y250 [get_cells gtze2_inf_north/TXDATA128_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA128_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA127_LUT1B]
set_property LOC SLICE_X137Y255 [get_cells gtze2_inf_north/TXDATA127_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA127_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA127_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA127_FD]
set_property LOC SLICE_X137Y255 [get_cells gtze2_inf_north/TXDATA127_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA127_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA126_LUT1B]
set_property LOC SLICE_X137Y255 [get_cells gtze2_inf_north/TXDATA126_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA126_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA126_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA126_FD]
set_property LOC SLICE_X137Y255 [get_cells gtze2_inf_north/TXDATA126_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA126_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA125_LUT1B]
set_property LOC SLICE_X137Y255 [get_cells gtze2_inf_north/TXDATA125_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA125_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA125_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA125_FD]
set_property LOC SLICE_X137Y255 [get_cells gtze2_inf_north/TXDATA125_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA125_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA124_LUT1B]
set_property LOC SLICE_X137Y255 [get_cells gtze2_inf_north/TXDATA124_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA124_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA124_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA124_FD]
set_property LOC SLICE_X137Y255 [get_cells gtze2_inf_north/TXDATA124_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA124_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA123_LUT1B]
set_property LOC SLICE_X137Y260 [get_cells gtze2_inf_north/TXDATA123_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA123_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA123_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA123_FD]
set_property LOC SLICE_X137Y260 [get_cells gtze2_inf_north/TXDATA123_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA123_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA122_LUT1B]
set_property LOC SLICE_X137Y260 [get_cells gtze2_inf_north/TXDATA122_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA122_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA122_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA122_FD]
set_property LOC SLICE_X137Y260 [get_cells gtze2_inf_north/TXDATA122_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA122_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA174_LUT1B]
set_property LOC SLICE_X133Y275 [get_cells gtze2_inf_north/TXDATA174_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA174_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA174_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y275/D5FF]
set_property PROHIBIT true [get_bels SLICE_X133Y275/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA174_FD]
set_property LOC SLICE_X133Y275 [get_cells gtze2_inf_north/TXDATA174_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA174_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA173_LUT1B]
set_property LOC SLICE_X133Y275 [get_cells gtze2_inf_north/TXDATA173_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA173_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA173_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA173_FD]
set_property LOC SLICE_X133Y275 [get_cells gtze2_inf_north/TXDATA173_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA173_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA172_LUT1B]
set_property LOC SLICE_X133Y275 [get_cells gtze2_inf_north/TXDATA172_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA172_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA172_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA172_FD]
set_property LOC SLICE_X133Y275 [get_cells gtze2_inf_north/TXDATA172_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA172_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA171_LUT1B]
set_property LOC SLICE_X133Y280 [get_cells gtze2_inf_north/TXDATA171_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA171_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA171_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X133Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA171_FD]
set_property LOC SLICE_X133Y280 [get_cells gtze2_inf_north/TXDATA171_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA171_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA170_LUT1B]
set_property LOC SLICE_X133Y280 [get_cells gtze2_inf_north/TXDATA170_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA170_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA170_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA170_FD]
set_property LOC SLICE_X133Y280 [get_cells gtze2_inf_north/TXDATA170_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA170_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA169_LUT1B]
set_property LOC SLICE_X133Y280 [get_cells gtze2_inf_north/TXDATA169_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA169_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA169_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA169_FD]
set_property LOC SLICE_X133Y280 [get_cells gtze2_inf_north/TXDATA169_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA169_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA168_LUT1B]
set_property LOC SLICE_X133Y280 [get_cells gtze2_inf_north/TXDATA168_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA168_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA168_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA168_FD]
set_property LOC SLICE_X133Y280 [get_cells gtze2_inf_north/TXDATA168_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA168_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA167_LUT1B]
set_property LOC SLICE_X133Y285 [get_cells gtze2_inf_north/TXDATA167_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA167_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA167_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X133Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA167_FD]
set_property LOC SLICE_X133Y285 [get_cells gtze2_inf_north/TXDATA167_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA167_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA166_LUT1B]
set_property LOC SLICE_X133Y285 [get_cells gtze2_inf_north/TXDATA166_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA166_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA166_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA166_FD]
set_property LOC SLICE_X133Y285 [get_cells gtze2_inf_north/TXDATA166_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA166_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA165_LUT1B]
set_property LOC SLICE_X133Y285 [get_cells gtze2_inf_north/TXDATA165_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA165_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA165_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA165_FD]
set_property LOC SLICE_X133Y285 [get_cells gtze2_inf_north/TXDATA165_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA165_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA164_LUT1B]
set_property LOC SLICE_X133Y285 [get_cells gtze2_inf_north/TXDATA164_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA164_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA164_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA164_FD]
set_property LOC SLICE_X133Y285 [get_cells gtze2_inf_north/TXDATA164_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA164_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA163_LUT1B]
set_property LOC SLICE_X135Y250 [get_cells gtze2_inf_north/TXDATA163_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA163_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA163_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X135Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA163_FD]
set_property LOC SLICE_X135Y250 [get_cells gtze2_inf_north/TXDATA163_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA163_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA162_LUT1B]
set_property LOC SLICE_X135Y250 [get_cells gtze2_inf_north/TXDATA162_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA162_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA162_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA162_FD]
set_property LOC SLICE_X135Y250 [get_cells gtze2_inf_north/TXDATA162_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA162_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA161_LUT1B]
set_property LOC SLICE_X135Y250 [get_cells gtze2_inf_north/TXDATA161_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA161_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA161_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA161_FD]
set_property LOC SLICE_X135Y250 [get_cells gtze2_inf_north/TXDATA161_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA161_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA160_LUT1B]
set_property LOC SLICE_X135Y250 [get_cells gtze2_inf_north/TXDATA160_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA160_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA160_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA160_FD]
set_property LOC SLICE_X135Y250 [get_cells gtze2_inf_north/TXDATA160_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA160_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA159_LUT1B]
set_property LOC SLICE_X135Y255 [get_cells gtze2_inf_north/TXDATA159_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA159_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA159_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X135Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA159_FD]
set_property LOC SLICE_X135Y255 [get_cells gtze2_inf_north/TXDATA159_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA159_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA158_LUT1B]
set_property LOC SLICE_X135Y255 [get_cells gtze2_inf_north/TXDATA158_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA158_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA158_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA158_FD]
set_property LOC SLICE_X135Y255 [get_cells gtze2_inf_north/TXDATA158_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA158_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA157_LUT1B]
set_property LOC SLICE_X135Y255 [get_cells gtze2_inf_north/TXDATA157_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA157_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA157_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA157_FD]
set_property LOC SLICE_X135Y255 [get_cells gtze2_inf_north/TXDATA157_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA157_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA156_LUT1B]
set_property LOC SLICE_X135Y255 [get_cells gtze2_inf_north/TXDATA156_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA156_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA156_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA156_FD]
set_property LOC SLICE_X135Y255 [get_cells gtze2_inf_north/TXDATA156_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA156_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA155_LUT1B]
set_property LOC SLICE_X135Y260 [get_cells gtze2_inf_north/TXDATA155_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA155_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA155_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA155_FD]
set_property LOC SLICE_X135Y260 [get_cells gtze2_inf_north/TXDATA155_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA155_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA154_LUT1B]
set_property LOC SLICE_X135Y260 [get_cells gtze2_inf_north/TXDATA154_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA154_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA154_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA154_FD]
set_property LOC SLICE_X135Y260 [get_cells gtze2_inf_north/TXDATA154_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA154_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1106_LUT1B]
set_property LOC SLICE_X131Y275 [get_cells gtze2_inf_north/TXDATA1106_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1106_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1106_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y275/D5FF]
set_property PROHIBIT true [get_bels SLICE_X131Y275/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1106_FD]
set_property LOC SLICE_X131Y275 [get_cells gtze2_inf_north/TXDATA1106_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1106_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1105_LUT1B]
set_property LOC SLICE_X131Y275 [get_cells gtze2_inf_north/TXDATA1105_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1105_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1105_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1105_FD]
set_property LOC SLICE_X131Y275 [get_cells gtze2_inf_north/TXDATA1105_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1105_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1104_LUT1B]
set_property LOC SLICE_X131Y275 [get_cells gtze2_inf_north/TXDATA1104_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1104_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1104_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1104_FD]
set_property LOC SLICE_X131Y275 [get_cells gtze2_inf_north/TXDATA1104_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1104_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1103_LUT1B]
set_property LOC SLICE_X131Y280 [get_cells gtze2_inf_north/TXDATA1103_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1103_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1103_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X131Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1103_FD]
set_property LOC SLICE_X131Y280 [get_cells gtze2_inf_north/TXDATA1103_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1103_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1102_LUT1B]
set_property LOC SLICE_X131Y280 [get_cells gtze2_inf_north/TXDATA1102_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1102_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1102_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1102_FD]
set_property LOC SLICE_X131Y280 [get_cells gtze2_inf_north/TXDATA1102_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1102_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1101_LUT1B]
set_property LOC SLICE_X131Y280 [get_cells gtze2_inf_north/TXDATA1101_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1101_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1101_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1101_FD]
set_property LOC SLICE_X131Y280 [get_cells gtze2_inf_north/TXDATA1101_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1101_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1100_LUT1B]
set_property LOC SLICE_X131Y280 [get_cells gtze2_inf_north/TXDATA1100_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1100_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1100_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1100_FD]
set_property LOC SLICE_X131Y280 [get_cells gtze2_inf_north/TXDATA1100_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1100_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA199_LUT1B]
set_property LOC SLICE_X131Y285 [get_cells gtze2_inf_north/TXDATA199_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA199_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA199_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X131Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA199_FD]
set_property LOC SLICE_X131Y285 [get_cells gtze2_inf_north/TXDATA199_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA199_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA198_LUT1B]
set_property LOC SLICE_X131Y285 [get_cells gtze2_inf_north/TXDATA198_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA198_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA198_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA198_FD]
set_property LOC SLICE_X131Y285 [get_cells gtze2_inf_north/TXDATA198_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA198_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA197_LUT1B]
set_property LOC SLICE_X131Y285 [get_cells gtze2_inf_north/TXDATA197_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA197_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA197_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA197_FD]
set_property LOC SLICE_X131Y285 [get_cells gtze2_inf_north/TXDATA197_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA197_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA196_LUT1B]
set_property LOC SLICE_X131Y285 [get_cells gtze2_inf_north/TXDATA196_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA196_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA196_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA196_FD]
set_property LOC SLICE_X131Y285 [get_cells gtze2_inf_north/TXDATA196_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA196_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA195_LUT1B]
set_property LOC SLICE_X133Y250 [get_cells gtze2_inf_north/TXDATA195_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA195_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA195_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X133Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA195_FD]
set_property LOC SLICE_X133Y250 [get_cells gtze2_inf_north/TXDATA195_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA195_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA194_LUT1B]
set_property LOC SLICE_X133Y250 [get_cells gtze2_inf_north/TXDATA194_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA194_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA194_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA194_FD]
set_property LOC SLICE_X133Y250 [get_cells gtze2_inf_north/TXDATA194_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA194_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA193_LUT1B]
set_property LOC SLICE_X133Y250 [get_cells gtze2_inf_north/TXDATA193_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA193_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA193_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA193_FD]
set_property LOC SLICE_X133Y250 [get_cells gtze2_inf_north/TXDATA193_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA193_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA192_LUT1B]
set_property LOC SLICE_X133Y250 [get_cells gtze2_inf_north/TXDATA192_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA192_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA192_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA192_FD]
set_property LOC SLICE_X133Y250 [get_cells gtze2_inf_north/TXDATA192_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA192_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA191_LUT1B]
set_property LOC SLICE_X133Y255 [get_cells gtze2_inf_north/TXDATA191_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA191_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA191_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X133Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA191_FD]
set_property LOC SLICE_X133Y255 [get_cells gtze2_inf_north/TXDATA191_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA191_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA190_LUT1B]
set_property LOC SLICE_X133Y255 [get_cells gtze2_inf_north/TXDATA190_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA190_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA190_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA190_FD]
set_property LOC SLICE_X133Y255 [get_cells gtze2_inf_north/TXDATA190_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA190_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA189_LUT1B]
set_property LOC SLICE_X133Y255 [get_cells gtze2_inf_north/TXDATA189_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA189_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA189_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA189_FD]
set_property LOC SLICE_X133Y255 [get_cells gtze2_inf_north/TXDATA189_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA189_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA188_LUT1B]
set_property LOC SLICE_X133Y255 [get_cells gtze2_inf_north/TXDATA188_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA188_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA188_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA188_FD]
set_property LOC SLICE_X133Y255 [get_cells gtze2_inf_north/TXDATA188_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA188_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA187_LUT1B]
set_property LOC SLICE_X133Y260 [get_cells gtze2_inf_north/TXDATA187_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA187_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA187_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X133Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA187_FD]
set_property LOC SLICE_X133Y260 [get_cells gtze2_inf_north/TXDATA187_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA187_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA186_LUT1B]
set_property LOC SLICE_X133Y260 [get_cells gtze2_inf_north/TXDATA186_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA186_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA186_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA186_FD]
set_property LOC SLICE_X133Y260 [get_cells gtze2_inf_north/TXDATA186_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA186_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA185_LUT1B]
set_property LOC SLICE_X133Y260 [get_cells gtze2_inf_north/TXDATA185_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA185_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA185_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA185_FD]
set_property LOC SLICE_X133Y260 [get_cells gtze2_inf_north/TXDATA185_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA185_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA184_LUT1B]
set_property LOC SLICE_X133Y260 [get_cells gtze2_inf_north/TXDATA184_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA184_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA184_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA184_FD]
set_property LOC SLICE_X133Y260 [get_cells gtze2_inf_north/TXDATA184_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA184_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA183_LUT1B]
set_property LOC SLICE_X133Y265 [get_cells gtze2_inf_north/TXDATA183_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA183_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA183_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X133Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA183_FD]
set_property LOC SLICE_X133Y265 [get_cells gtze2_inf_north/TXDATA183_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA183_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA182_LUT1B]
set_property LOC SLICE_X133Y265 [get_cells gtze2_inf_north/TXDATA182_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA182_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA182_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA182_FD]
set_property LOC SLICE_X133Y265 [get_cells gtze2_inf_north/TXDATA182_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA182_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA181_LUT1B]
set_property LOC SLICE_X133Y265 [get_cells gtze2_inf_north/TXDATA181_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA181_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA181_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA181_FD]
set_property LOC SLICE_X133Y265 [get_cells gtze2_inf_north/TXDATA181_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA181_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA180_LUT1B]
set_property LOC SLICE_X133Y265 [get_cells gtze2_inf_north/TXDATA180_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA180_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA180_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA180_FD]
set_property LOC SLICE_X133Y265 [get_cells gtze2_inf_north/TXDATA180_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA180_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA179_LUT1B]
set_property LOC SLICE_X133Y270 [get_cells gtze2_inf_north/TXDATA179_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA179_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA179_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X133Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA179_FD]
set_property LOC SLICE_X133Y270 [get_cells gtze2_inf_north/TXDATA179_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA179_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA178_LUT1B]
set_property LOC SLICE_X133Y270 [get_cells gtze2_inf_north/TXDATA178_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA178_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA178_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA178_FD]
set_property LOC SLICE_X133Y270 [get_cells gtze2_inf_north/TXDATA178_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA178_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA177_LUT1B]
set_property LOC SLICE_X133Y270 [get_cells gtze2_inf_north/TXDATA177_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA177_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA177_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA177_FD]
set_property LOC SLICE_X133Y270 [get_cells gtze2_inf_north/TXDATA177_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA177_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA176_LUT1B]
set_property LOC SLICE_X133Y270 [get_cells gtze2_inf_north/TXDATA176_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA176_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA176_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA176_FD]
set_property LOC SLICE_X133Y270 [get_cells gtze2_inf_north/TXDATA176_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA176_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA175_LUT1B]
set_property LOC SLICE_X133Y275 [get_cells gtze2_inf_north/TXDATA175_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA175_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA175_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X133Y275/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA175_FD]
set_property LOC SLICE_X133Y275 [get_cells gtze2_inf_north/TXDATA175_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA175_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1133_LUT1B]
set_property LOC SLICE_X129Y280 [get_cells gtze2_inf_north/TXDATA1133_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1133_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1133_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y280/A5FF]
set_property PROHIBIT true [get_bels SLICE_X129Y280/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1133_FD]
set_property LOC SLICE_X129Y280 [get_cells gtze2_inf_north/TXDATA1133_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1133_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1132_LUT1B]
set_property LOC SLICE_X129Y280 [get_cells gtze2_inf_north/TXDATA1132_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1132_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1132_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1132_FD]
set_property LOC SLICE_X129Y280 [get_cells gtze2_inf_north/TXDATA1132_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1132_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1131_LUT1B]
set_property LOC SLICE_X129Y285 [get_cells gtze2_inf_north/TXDATA1131_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1131_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1131_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X129Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1131_FD]
set_property LOC SLICE_X129Y285 [get_cells gtze2_inf_north/TXDATA1131_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1131_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1130_LUT1B]
set_property LOC SLICE_X129Y285 [get_cells gtze2_inf_north/TXDATA1130_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1130_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1130_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1130_FD]
set_property LOC SLICE_X129Y285 [get_cells gtze2_inf_north/TXDATA1130_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1130_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1129_LUT1B]
set_property LOC SLICE_X129Y285 [get_cells gtze2_inf_north/TXDATA1129_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1129_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1129_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1129_FD]
set_property LOC SLICE_X129Y285 [get_cells gtze2_inf_north/TXDATA1129_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1129_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1128_LUT1B]
set_property LOC SLICE_X129Y285 [get_cells gtze2_inf_north/TXDATA1128_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1128_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1128_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1128_FD]
set_property LOC SLICE_X129Y285 [get_cells gtze2_inf_north/TXDATA1128_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1128_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1127_LUT1B]
set_property LOC SLICE_X131Y250 [get_cells gtze2_inf_north/TXDATA1127_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1127_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1127_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X131Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1127_FD]
set_property LOC SLICE_X131Y250 [get_cells gtze2_inf_north/TXDATA1127_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1127_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1126_LUT1B]
set_property LOC SLICE_X131Y250 [get_cells gtze2_inf_north/TXDATA1126_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1126_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1126_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1126_FD]
set_property LOC SLICE_X131Y250 [get_cells gtze2_inf_north/TXDATA1126_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1126_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1125_LUT1B]
set_property LOC SLICE_X131Y250 [get_cells gtze2_inf_north/TXDATA1125_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1125_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1125_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1125_FD]
set_property LOC SLICE_X131Y250 [get_cells gtze2_inf_north/TXDATA1125_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1125_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1124_LUT1B]
set_property LOC SLICE_X131Y250 [get_cells gtze2_inf_north/TXDATA1124_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1124_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1124_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1124_FD]
set_property LOC SLICE_X131Y250 [get_cells gtze2_inf_north/TXDATA1124_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1124_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1123_LUT1B]
set_property LOC SLICE_X131Y255 [get_cells gtze2_inf_north/TXDATA1123_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1123_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1123_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X131Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1123_FD]
set_property LOC SLICE_X131Y255 [get_cells gtze2_inf_north/TXDATA1123_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1123_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1122_LUT1B]
set_property LOC SLICE_X131Y255 [get_cells gtze2_inf_north/TXDATA1122_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1122_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1122_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1122_FD]
set_property LOC SLICE_X131Y255 [get_cells gtze2_inf_north/TXDATA1122_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1122_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1121_LUT1B]
set_property LOC SLICE_X131Y255 [get_cells gtze2_inf_north/TXDATA1121_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1121_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1121_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1121_FD]
set_property LOC SLICE_X131Y255 [get_cells gtze2_inf_north/TXDATA1121_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1121_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1120_LUT1B]
set_property LOC SLICE_X131Y255 [get_cells gtze2_inf_north/TXDATA1120_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1120_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1120_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1120_FD]
set_property LOC SLICE_X131Y255 [get_cells gtze2_inf_north/TXDATA1120_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1120_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1119_LUT1B]
set_property LOC SLICE_X131Y260 [get_cells gtze2_inf_north/TXDATA1119_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1119_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1119_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X131Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1119_FD]
set_property LOC SLICE_X131Y260 [get_cells gtze2_inf_north/TXDATA1119_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1119_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1118_LUT1B]
set_property LOC SLICE_X131Y260 [get_cells gtze2_inf_north/TXDATA1118_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1118_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1118_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1118_FD]
set_property LOC SLICE_X131Y260 [get_cells gtze2_inf_north/TXDATA1118_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1118_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1117_LUT1B]
set_property LOC SLICE_X131Y260 [get_cells gtze2_inf_north/TXDATA1117_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1117_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1117_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1117_FD]
set_property LOC SLICE_X131Y260 [get_cells gtze2_inf_north/TXDATA1117_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1117_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1116_LUT1B]
set_property LOC SLICE_X131Y260 [get_cells gtze2_inf_north/TXDATA1116_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1116_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1116_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1116_FD]
set_property LOC SLICE_X131Y260 [get_cells gtze2_inf_north/TXDATA1116_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1116_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1115_LUT1B]
set_property LOC SLICE_X131Y265 [get_cells gtze2_inf_north/TXDATA1115_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1115_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1115_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X131Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1115_FD]
set_property LOC SLICE_X131Y265 [get_cells gtze2_inf_north/TXDATA1115_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1115_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1114_LUT1B]
set_property LOC SLICE_X131Y265 [get_cells gtze2_inf_north/TXDATA1114_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1114_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1114_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1114_FD]
set_property LOC SLICE_X131Y265 [get_cells gtze2_inf_north/TXDATA1114_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1114_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1113_LUT1B]
set_property LOC SLICE_X131Y265 [get_cells gtze2_inf_north/TXDATA1113_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1113_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1113_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1113_FD]
set_property LOC SLICE_X131Y265 [get_cells gtze2_inf_north/TXDATA1113_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1113_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1112_LUT1B]
set_property LOC SLICE_X131Y265 [get_cells gtze2_inf_north/TXDATA1112_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1112_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1112_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1112_FD]
set_property LOC SLICE_X131Y265 [get_cells gtze2_inf_north/TXDATA1112_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1112_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1111_LUT1B]
set_property LOC SLICE_X131Y270 [get_cells gtze2_inf_north/TXDATA1111_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1111_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1111_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X131Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1111_FD]
set_property LOC SLICE_X131Y270 [get_cells gtze2_inf_north/TXDATA1111_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1111_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1110_LUT1B]
set_property LOC SLICE_X131Y270 [get_cells gtze2_inf_north/TXDATA1110_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1110_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1110_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1110_FD]
set_property LOC SLICE_X131Y270 [get_cells gtze2_inf_north/TXDATA1110_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1110_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1109_LUT1B]
set_property LOC SLICE_X131Y270 [get_cells gtze2_inf_north/TXDATA1109_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1109_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1109_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1109_FD]
set_property LOC SLICE_X131Y270 [get_cells gtze2_inf_north/TXDATA1109_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1109_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1108_LUT1B]
set_property LOC SLICE_X131Y270 [get_cells gtze2_inf_north/TXDATA1108_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1108_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1108_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1108_FD]
set_property LOC SLICE_X131Y270 [get_cells gtze2_inf_north/TXDATA1108_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1108_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1107_LUT1B]
set_property LOC SLICE_X131Y275 [get_cells gtze2_inf_north/TXDATA1107_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1107_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1107_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X131Y275/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1107_FD]
set_property LOC SLICE_X131Y275 [get_cells gtze2_inf_north/TXDATA1107_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1107_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2134_LUT1A]
set_property LOC SLICE_X158Y292 [get_cells gtze2_inf_north/RXDATA2134_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2134_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2134_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2134_LUT1B]
set_property LOC SLICE_X158Y292 [get_cells gtze2_inf_north/RXDATA2134_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2134_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2134_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2134_FD]
set_property LOC SLICE_X159Y292 [get_cells gtze2_inf_north/RXDATA2134_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2134_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2133_LUT1A]
set_property LOC SLICE_X158Y292 [get_cells gtze2_inf_north/RXDATA2133_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2133_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2133_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2133_LUT1B]
set_property LOC SLICE_X158Y292 [get_cells gtze2_inf_north/RXDATA2133_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2133_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2133_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2133_FD]
set_property LOC SLICE_X159Y292 [get_cells gtze2_inf_north/RXDATA2133_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2133_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2132_LUT1A]
set_property LOC SLICE_X158Y292 [get_cells gtze2_inf_north/RXDATA2132_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2132_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2132_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2132_LUT1B]
set_property LOC SLICE_X158Y292 [get_cells gtze2_inf_north/RXDATA2132_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2132_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2132_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2132_FD]
set_property LOC SLICE_X159Y292 [get_cells gtze2_inf_north/RXDATA2132_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2132_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2131_LUT1A]
set_property LOC SLICE_X158Y297 [get_cells gtze2_inf_north/RXDATA2131_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2131_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2131_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2131_LUT1B]
set_property LOC SLICE_X158Y297 [get_cells gtze2_inf_north/RXDATA2131_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2131_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2131_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X159Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2131_FD]
set_property LOC SLICE_X159Y297 [get_cells gtze2_inf_north/RXDATA2131_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2131_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2130_LUT1A]
set_property LOC SLICE_X158Y297 [get_cells gtze2_inf_north/RXDATA2130_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2130_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2130_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2130_LUT1B]
set_property LOC SLICE_X158Y297 [get_cells gtze2_inf_north/RXDATA2130_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2130_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2130_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2130_FD]
set_property LOC SLICE_X159Y297 [get_cells gtze2_inf_north/RXDATA2130_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2130_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2129_LUT1A]
set_property LOC SLICE_X158Y297 [get_cells gtze2_inf_north/RXDATA2129_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2129_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2129_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2129_LUT1B]
set_property LOC SLICE_X158Y297 [get_cells gtze2_inf_north/RXDATA2129_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2129_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2129_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2129_FD]
set_property LOC SLICE_X159Y297 [get_cells gtze2_inf_north/RXDATA2129_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2129_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2128_LUT1A]
set_property LOC SLICE_X158Y297 [get_cells gtze2_inf_north/RXDATA2128_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2128_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2128_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2128_LUT1B]
set_property LOC SLICE_X158Y297 [get_cells gtze2_inf_north/RXDATA2128_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2128_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2128_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X159Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2128_FD]
set_property LOC SLICE_X159Y297 [get_cells gtze2_inf_north/RXDATA2128_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2128_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2127_LUT1A]
set_property LOC SLICE_X160Y262 [get_cells gtze2_inf_north/RXDATA2127_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2127_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2127_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2127_LUT1B]
set_property LOC SLICE_X160Y262 [get_cells gtze2_inf_north/RXDATA2127_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2127_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2127_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X161Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2127_FD]
set_property LOC SLICE_X161Y262 [get_cells gtze2_inf_north/RXDATA2127_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2127_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2126_LUT1A]
set_property LOC SLICE_X160Y262 [get_cells gtze2_inf_north/RXDATA2126_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2126_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2126_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2126_LUT1B]
set_property LOC SLICE_X160Y262 [get_cells gtze2_inf_north/RXDATA2126_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2126_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2126_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2126_FD]
set_property LOC SLICE_X161Y262 [get_cells gtze2_inf_north/RXDATA2126_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2126_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2125_LUT1A]
set_property LOC SLICE_X160Y262 [get_cells gtze2_inf_north/RXDATA2125_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2125_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2125_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2125_LUT1B]
set_property LOC SLICE_X160Y262 [get_cells gtze2_inf_north/RXDATA2125_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2125_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2125_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2125_FD]
set_property LOC SLICE_X161Y262 [get_cells gtze2_inf_north/RXDATA2125_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2125_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0146_LUT1B]
set_property LOC SLICE_X97Y265 [get_cells gtze2_inf_north/TXDATA0146_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0146_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0146_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X97Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0146_FD]
set_property LOC SLICE_X97Y265 [get_cells gtze2_inf_north/TXDATA0146_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0146_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0145_LUT1B]
set_property LOC SLICE_X97Y265 [get_cells gtze2_inf_north/TXDATA0145_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0145_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0145_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0145_FD]
set_property LOC SLICE_X97Y265 [get_cells gtze2_inf_north/TXDATA0145_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0145_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0144_LUT1B]
set_property LOC SLICE_X97Y265 [get_cells gtze2_inf_north/TXDATA0144_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0144_FD]
set_property LOC SLICE_X97Y265 [get_cells gtze2_inf_north/TXDATA0144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0144_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0143_LUT1B]
set_property LOC SLICE_X97Y270 [get_cells gtze2_inf_north/TXDATA0143_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X97Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0143_FD]
set_property LOC SLICE_X97Y270 [get_cells gtze2_inf_north/TXDATA0143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0143_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0142_LUT1B]
set_property LOC SLICE_X97Y270 [get_cells gtze2_inf_north/TXDATA0142_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0142_FD]
set_property LOC SLICE_X97Y270 [get_cells gtze2_inf_north/TXDATA0142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0142_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID24_LUT1A]
set_property LOC SLICE_X159Y277 [get_cells gtze2_inf_north/RXHEADERVALID24_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID24_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID24_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X158Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X158Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X158Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID24_LUT1B]
set_property LOC SLICE_X159Y277 [get_cells gtze2_inf_north/RXHEADERVALID24_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X158Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID24_FD]
set_property LOC SLICE_X158Y277 [get_cells gtze2_inf_north/RXHEADERVALID24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID24_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID23_LUT1A]
set_property LOC SLICE_X161Y277 [get_cells gtze2_inf_north/RXHEADERVALID23_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID23_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID23_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X160Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X160Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X160Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID23_LUT1B]
set_property LOC SLICE_X161Y277 [get_cells gtze2_inf_north/RXHEADERVALID23_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X160Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID23_FD]
set_property LOC SLICE_X160Y277 [get_cells gtze2_inf_north/RXHEADERVALID23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID23_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID22_LUT1A]
set_property LOC SLICE_X163Y277 [get_cells gtze2_inf_north/RXHEADERVALID22_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID22_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID22_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X162Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X162Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X162Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID22_LUT1B]
set_property LOC SLICE_X163Y277 [get_cells gtze2_inf_north/RXHEADERVALID22_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X162Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID22_FD]
set_property LOC SLICE_X162Y277 [get_cells gtze2_inf_north/RXHEADERVALID22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID22_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID21_LUT1A]
set_property LOC SLICE_X165Y277 [get_cells gtze2_inf_north/RXHEADERVALID21_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID21_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID21_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X164Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X164Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X164Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID21_LUT1B]
set_property LOC SLICE_X165Y277 [get_cells gtze2_inf_north/RXHEADERVALID21_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X164Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID21_FD]
set_property LOC SLICE_X164Y277 [get_cells gtze2_inf_north/RXHEADERVALID21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID21_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID20_LUT1A]
set_property LOC SLICE_X167Y277 [get_cells gtze2_inf_north/RXHEADERVALID20_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID20_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID20_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X166Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X166Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X166Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID20_LUT1B]
set_property LOC SLICE_X167Y277 [get_cells gtze2_inf_north/RXHEADERVALID20_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X166Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID20_FD]
set_property LOC SLICE_X166Y277 [get_cells gtze2_inf_north/RXHEADERVALID20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID20_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXRESETDONE1_LUT1A]
set_property LOC SLICE_X141Y287 [get_cells gtze2_inf_north/RXRESETDONE1_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXRESETDONE1_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE1_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X140Y287/BFF]
set_property PROHIBIT true [get_bels SLICE_X140Y287/B5FF]
set_property PROHIBIT true [get_bels SLICE_X140Y287/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXRESETDONE1_LUT1B]
set_property LOC SLICE_X141Y287 [get_cells gtze2_inf_north/RXRESETDONE1_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXRESETDONE1_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE1_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X140Y287/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXRESETDONE1_FD]
set_property LOC SLICE_X140Y287 [get_cells gtze2_inf_north/RXRESETDONE1_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE1_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/TXRESETDONE3_LUT1A]
set_property LOC SLICE_X178Y257 [get_cells gtze2_inf_north/TXRESETDONE3_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/TXRESETDONE3_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE3_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXRESETDONE3_LUT1B]
set_property LOC SLICE_X178Y257 [get_cells gtze2_inf_north/TXRESETDONE3_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/TXRESETDONE3_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE3_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y257/D5FF]
set_property PROHIBIT true [get_bels SLICE_X179Y257/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXRESETDONE3_FD]
set_property LOC SLICE_X179Y257 [get_cells gtze2_inf_north/TXRESETDONE3_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE3_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/TXRESETDONE1_LUT1A]
set_property LOC SLICE_X138Y257 [get_cells gtze2_inf_north/TXRESETDONE1_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/TXRESETDONE1_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE1_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXRESETDONE1_LUT1B]
set_property LOC SLICE_X138Y257 [get_cells gtze2_inf_north/TXRESETDONE1_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/TXRESETDONE1_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE1_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y257/D5FF]
set_property PROHIBIT true [get_bels SLICE_X139Y257/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXRESETDONE1_FD]
set_property LOC SLICE_X139Y257 [get_cells gtze2_inf_north/TXRESETDONE1_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXRESETDONE1_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA067_LUT1B]
set_property LOC SLICE_X101Y285 [get_cells gtze2_inf_north/TXDATA067_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA067_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA067_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X101Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA067_FD]
set_property LOC SLICE_X101Y285 [get_cells gtze2_inf_north/TXDATA067_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA067_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA066_LUT1B]
set_property LOC SLICE_X101Y285 [get_cells gtze2_inf_north/TXDATA066_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA066_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA066_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA066_FD]
set_property LOC SLICE_X101Y285 [get_cells gtze2_inf_north/TXDATA066_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA066_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA065_LUT1B]
set_property LOC SLICE_X101Y285 [get_cells gtze2_inf_north/TXDATA065_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA065_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA065_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA065_FD]
set_property LOC SLICE_X101Y285 [get_cells gtze2_inf_north/TXDATA065_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA065_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA064_LUT1B]
set_property LOC SLICE_X101Y285 [get_cells gtze2_inf_north/TXDATA064_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA064_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA064_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA064_FD]
set_property LOC SLICE_X101Y285 [get_cells gtze2_inf_north/TXDATA064_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA064_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA063_LUT1B]
set_property LOC SLICE_X103Y250 [get_cells gtze2_inf_north/TXDATA063_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA063_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA063_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X103Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA063_FD]
set_property LOC SLICE_X103Y250 [get_cells gtze2_inf_north/TXDATA063_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA063_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA062_LUT1B]
set_property LOC SLICE_X103Y250 [get_cells gtze2_inf_north/TXDATA062_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA062_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA062_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA062_FD]
set_property LOC SLICE_X103Y250 [get_cells gtze2_inf_north/TXDATA062_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA062_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA061_LUT1B]
set_property LOC SLICE_X103Y250 [get_cells gtze2_inf_north/TXDATA061_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA061_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA061_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA061_FD]
set_property LOC SLICE_X103Y250 [get_cells gtze2_inf_north/TXDATA061_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA061_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA060_LUT1B]
set_property LOC SLICE_X103Y250 [get_cells gtze2_inf_north/TXDATA060_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA060_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA060_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA060_FD]
set_property LOC SLICE_X103Y250 [get_cells gtze2_inf_north/TXDATA060_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA060_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA059_LUT1B]
set_property LOC SLICE_X103Y255 [get_cells gtze2_inf_north/TXDATA059_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA059_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA059_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X103Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA059_FD]
set_property LOC SLICE_X103Y255 [get_cells gtze2_inf_north/TXDATA059_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA059_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/DRPRDY_LUT1A]
set_property LOC SLICE_X276Y292 [get_cells gtze2_inf_north/DRPRDY_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPRDY_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPRDY_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPRDY_LUT1B]
set_property LOC SLICE_X276Y292 [get_cells gtze2_inf_north/DRPRDY_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPRDY_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPRDY_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPRDY_FD]
set_property LOC SLICE_X277Y292 [get_cells gtze2_inf_north/DRPRDY_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPRDY_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP34_LUT1B]
set_property LOC SLICE_X177Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP34_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXGEARBOXSLIP34_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP34_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y290/B5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y290/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/RXGEARBOXSLIP34_FD]
set_property LOC SLICE_X177Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP34_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP34_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP33_LUT1B]
set_property LOC SLICE_X177Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP33_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP33_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP33_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y290/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXGEARBOXSLIP33_FD]
set_property LOC SLICE_X177Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP33_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP33_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP32_LUT1B]
set_property LOC SLICE_X177Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP32_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP32_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP32_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y290/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXGEARBOXSLIP32_FD]
set_property LOC SLICE_X177Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP32_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP32_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP31_LUT1B]
set_property LOC SLICE_X177Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP31_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXGEARBOXSLIP31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y290/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXGEARBOXSLIP31_FD]
set_property LOC SLICE_X177Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP31_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP30_LUT1B]
set_property LOC SLICE_X176Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP30_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X176Y290/D5FF]
set_property PROHIBIT true [get_bels SLICE_X176Y290/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/RXGEARBOXSLIP30_FD]
set_property LOC SLICE_X176Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP30_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/DRPSTATUS2_LUT1A]
set_property LOC SLICE_X278Y297 [get_cells gtze2_inf_north/DRPSTATUS2_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPSTATUS2_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPSTATUS2_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPSTATUS2_LUT1B]
set_property LOC SLICE_X278Y297 [get_cells gtze2_inf_north/DRPSTATUS2_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPSTATUS2_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPSTATUS2_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPSTATUS2_FD]
set_property LOC SLICE_X279Y297 [get_cells gtze2_inf_north/DRPSTATUS2_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPSTATUS2_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/DRPSTATUS1_LUT1A]
set_property LOC SLICE_X276Y297 [get_cells gtze2_inf_north/DRPSTATUS1_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPSTATUS1_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPSTATUS1_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPSTATUS1_LUT1B]
set_property LOC SLICE_X276Y297 [get_cells gtze2_inf_north/DRPSTATUS1_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPSTATUS1_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPSTATUS1_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X277Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPSTATUS1_FD]
set_property LOC SLICE_X277Y297 [get_cells gtze2_inf_north/DRPSTATUS1_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPSTATUS1_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/DRPSTATUS0_LUT1A]
set_property LOC SLICE_X278Y292 [get_cells gtze2_inf_north/DRPSTATUS0_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/DRPSTATUS0_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPSTATUS0_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPSTATUS0_LUT1B]
set_property LOC SLICE_X278Y292 [get_cells gtze2_inf_north/DRPSTATUS0_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/DRPSTATUS0_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPSTATUS0_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X279Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPSTATUS0_FD]
set_property LOC SLICE_X279Y292 [get_cells gtze2_inf_north/DRPSTATUS0_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPSTATUS0_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0151_LUT1B]
set_property LOC SLICE_X97Y260 [get_cells gtze2_inf_north/TXDATA0151_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0151_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0151_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X97Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0151_FD]
set_property LOC SLICE_X97Y260 [get_cells gtze2_inf_north/TXDATA0151_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0151_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0150_LUT1B]
set_property LOC SLICE_X97Y260 [get_cells gtze2_inf_north/TXDATA0150_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0150_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0150_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0150_FD]
set_property LOC SLICE_X97Y260 [get_cells gtze2_inf_north/TXDATA0150_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0150_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0149_LUT1B]
set_property LOC SLICE_X97Y260 [get_cells gtze2_inf_north/TXDATA0149_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0149_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0149_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0149_FD]
set_property LOC SLICE_X97Y260 [get_cells gtze2_inf_north/TXDATA0149_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0149_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0148_LUT1B]
set_property LOC SLICE_X97Y260 [get_cells gtze2_inf_north/TXDATA0148_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0148_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0148_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0148_FD]
set_property LOC SLICE_X97Y260 [get_cells gtze2_inf_north/TXDATA0148_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0148_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0147_LUT1B]
set_property LOC SLICE_X97Y265 [get_cells gtze2_inf_north/TXDATA0147_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0147_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0147_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y265/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0147_FD]
set_property LOC SLICE_X97Y265 [get_cells gtze2_inf_north/TXDATA0147_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0147_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA390_LUT1A]
set_property LOC SLICE_X182Y267 [get_cells gtze2_inf_north/RXDATA390_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA390_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA390_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA390_LUT1B]
set_property LOC SLICE_X182Y267 [get_cells gtze2_inf_north/RXDATA390_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA390_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA390_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y267/D5FF]
set_property PROHIBIT true [get_bels SLICE_X183Y267/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA390_FD]
set_property LOC SLICE_X183Y267 [get_cells gtze2_inf_north/RXDATA390_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA390_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA389_LUT1A]
set_property LOC SLICE_X182Y267 [get_cells gtze2_inf_north/RXDATA389_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA389_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA389_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA389_LUT1B]
set_property LOC SLICE_X182Y267 [get_cells gtze2_inf_north/RXDATA389_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA389_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA389_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA389_FD]
set_property LOC SLICE_X183Y267 [get_cells gtze2_inf_north/RXDATA389_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA389_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA388_LUT1A]
set_property LOC SLICE_X182Y267 [get_cells gtze2_inf_north/RXDATA388_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA388_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA388_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA388_LUT1B]
set_property LOC SLICE_X182Y267 [get_cells gtze2_inf_north/RXDATA388_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA388_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA388_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA388_FD]
set_property LOC SLICE_X183Y267 [get_cells gtze2_inf_north/RXDATA388_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA388_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA387_LUT1A]
set_property LOC SLICE_X182Y272 [get_cells gtze2_inf_north/RXDATA387_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA387_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA387_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA387_LUT1B]
set_property LOC SLICE_X182Y272 [get_cells gtze2_inf_north/RXDATA387_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA387_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA387_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X183Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA387_FD]
set_property LOC SLICE_X183Y272 [get_cells gtze2_inf_north/RXDATA387_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA387_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA386_LUT1A]
set_property LOC SLICE_X182Y272 [get_cells gtze2_inf_north/RXDATA386_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA386_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA386_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA386_LUT1B]
set_property LOC SLICE_X182Y272 [get_cells gtze2_inf_north/RXDATA386_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA386_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA386_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA386_FD]
set_property LOC SLICE_X183Y272 [get_cells gtze2_inf_north/RXDATA386_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA386_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA385_LUT1A]
set_property LOC SLICE_X182Y272 [get_cells gtze2_inf_north/RXDATA385_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA385_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA385_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA385_LUT1B]
set_property LOC SLICE_X182Y272 [get_cells gtze2_inf_north/RXDATA385_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA385_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA385_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA385_FD]
set_property LOC SLICE_X183Y272 [get_cells gtze2_inf_north/RXDATA385_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA385_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA384_LUT1A]
set_property LOC SLICE_X182Y272 [get_cells gtze2_inf_north/RXDATA384_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA384_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA384_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA384_LUT1B]
set_property LOC SLICE_X182Y272 [get_cells gtze2_inf_north/RXDATA384_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA384_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA384_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA384_FD]
set_property LOC SLICE_X183Y272 [get_cells gtze2_inf_north/RXDATA384_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA384_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA383_LUT1A]
set_property LOC SLICE_X182Y277 [get_cells gtze2_inf_north/RXDATA383_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA383_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA383_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA383_LUT1B]
set_property LOC SLICE_X182Y277 [get_cells gtze2_inf_north/RXDATA383_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA383_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA383_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X183Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA383_FD]
set_property LOC SLICE_X183Y277 [get_cells gtze2_inf_north/RXDATA383_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA383_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA382_LUT1A]
set_property LOC SLICE_X182Y277 [get_cells gtze2_inf_north/RXDATA382_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA382_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA382_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA382_LUT1B]
set_property LOC SLICE_X182Y277 [get_cells gtze2_inf_north/RXDATA382_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA382_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA382_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA382_FD]
set_property LOC SLICE_X183Y277 [get_cells gtze2_inf_north/RXDATA382_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA382_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA381_LUT1A]
set_property LOC SLICE_X182Y277 [get_cells gtze2_inf_north/RXDATA381_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA381_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA381_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA381_LUT1B]
set_property LOC SLICE_X182Y277 [get_cells gtze2_inf_north/RXDATA381_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA381_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA381_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA381_FD]
set_property LOC SLICE_X183Y277 [get_cells gtze2_inf_north/RXDATA381_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA381_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA380_LUT1A]
set_property LOC SLICE_X182Y277 [get_cells gtze2_inf_north/RXDATA380_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA380_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA380_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA380_LUT1B]
set_property LOC SLICE_X182Y277 [get_cells gtze2_inf_north/RXDATA380_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA380_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA380_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA380_FD]
set_property LOC SLICE_X183Y277 [get_cells gtze2_inf_north/RXDATA380_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA380_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA379_LUT1A]
set_property LOC SLICE_X182Y282 [get_cells gtze2_inf_north/RXDATA379_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA379_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA379_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA379_LUT1B]
set_property LOC SLICE_X182Y282 [get_cells gtze2_inf_north/RXDATA379_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA379_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA379_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X183Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA379_FD]
set_property LOC SLICE_X183Y282 [get_cells gtze2_inf_north/RXDATA379_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA379_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA378_LUT1A]
set_property LOC SLICE_X182Y282 [get_cells gtze2_inf_north/RXDATA378_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA378_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA378_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA378_LUT1B]
set_property LOC SLICE_X182Y282 [get_cells gtze2_inf_north/RXDATA378_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA378_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA378_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA378_FD]
set_property LOC SLICE_X183Y282 [get_cells gtze2_inf_north/RXDATA378_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA378_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA377_LUT1A]
set_property LOC SLICE_X182Y282 [get_cells gtze2_inf_north/RXDATA377_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA377_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA377_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA377_LUT1B]
set_property LOC SLICE_X182Y282 [get_cells gtze2_inf_north/RXDATA377_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA377_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA377_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA377_FD]
set_property LOC SLICE_X183Y282 [get_cells gtze2_inf_north/RXDATA377_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA377_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA376_LUT1A]
set_property LOC SLICE_X182Y282 [get_cells gtze2_inf_north/RXDATA376_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA376_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA376_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA376_LUT1B]
set_property LOC SLICE_X182Y282 [get_cells gtze2_inf_north/RXDATA376_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA376_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA376_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA376_FD]
set_property LOC SLICE_X183Y282 [get_cells gtze2_inf_north/RXDATA376_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA376_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA375_LUT1A]
set_property LOC SLICE_X182Y287 [get_cells gtze2_inf_north/RXDATA375_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA375_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA375_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA375_LUT1B]
set_property LOC SLICE_X182Y287 [get_cells gtze2_inf_north/RXDATA375_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA375_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA375_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X183Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA375_FD]
set_property LOC SLICE_X183Y287 [get_cells gtze2_inf_north/RXDATA375_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA375_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA374_LUT1A]
set_property LOC SLICE_X182Y287 [get_cells gtze2_inf_north/RXDATA374_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA374_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA374_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA374_LUT1B]
set_property LOC SLICE_X182Y287 [get_cells gtze2_inf_north/RXDATA374_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA374_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA374_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA374_FD]
set_property LOC SLICE_X183Y287 [get_cells gtze2_inf_north/RXDATA374_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA374_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA373_LUT1A]
set_property LOC SLICE_X182Y287 [get_cells gtze2_inf_north/RXDATA373_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA373_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA373_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA373_LUT1B]
set_property LOC SLICE_X182Y287 [get_cells gtze2_inf_north/RXDATA373_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA373_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA373_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA373_FD]
set_property LOC SLICE_X183Y287 [get_cells gtze2_inf_north/RXDATA373_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA373_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA372_LUT1A]
set_property LOC SLICE_X182Y287 [get_cells gtze2_inf_north/RXDATA372_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA372_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA372_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA372_LUT1B]
set_property LOC SLICE_X182Y287 [get_cells gtze2_inf_north/RXDATA372_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA372_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA372_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA372_FD]
set_property LOC SLICE_X183Y287 [get_cells gtze2_inf_north/RXDATA372_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA372_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA371_LUT1A]
set_property LOC SLICE_X182Y292 [get_cells gtze2_inf_north/RXDATA371_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA371_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA371_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA371_LUT1B]
set_property LOC SLICE_X182Y292 [get_cells gtze2_inf_north/RXDATA371_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA371_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA371_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X183Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA371_FD]
set_property LOC SLICE_X183Y292 [get_cells gtze2_inf_north/RXDATA371_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA371_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA370_LUT1A]
set_property LOC SLICE_X182Y292 [get_cells gtze2_inf_north/RXDATA370_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA370_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA370_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA370_LUT1B]
set_property LOC SLICE_X182Y292 [get_cells gtze2_inf_north/RXDATA370_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA370_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA370_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA370_FD]
set_property LOC SLICE_X183Y292 [get_cells gtze2_inf_north/RXDATA370_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA370_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA369_LUT1A]
set_property LOC SLICE_X182Y292 [get_cells gtze2_inf_north/RXDATA369_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA369_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA369_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA369_LUT1B]
set_property LOC SLICE_X182Y292 [get_cells gtze2_inf_north/RXDATA369_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA369_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA369_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA369_FD]
set_property LOC SLICE_X183Y292 [get_cells gtze2_inf_north/RXDATA369_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA369_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA368_LUT1A]
set_property LOC SLICE_X182Y292 [get_cells gtze2_inf_north/RXDATA368_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA368_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA368_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA368_LUT1B]
set_property LOC SLICE_X182Y292 [get_cells gtze2_inf_north/RXDATA368_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA368_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA368_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA368_FD]
set_property LOC SLICE_X183Y292 [get_cells gtze2_inf_north/RXDATA368_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA368_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA367_LUT1A]
set_property LOC SLICE_X182Y297 [get_cells gtze2_inf_north/RXDATA367_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA367_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA367_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA367_LUT1B]
set_property LOC SLICE_X182Y297 [get_cells gtze2_inf_north/RXDATA367_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA367_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA367_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X183Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA367_FD]
set_property LOC SLICE_X183Y297 [get_cells gtze2_inf_north/RXDATA367_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA367_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA366_LUT1A]
set_property LOC SLICE_X182Y297 [get_cells gtze2_inf_north/RXDATA366_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA366_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA366_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA366_LUT1B]
set_property LOC SLICE_X182Y297 [get_cells gtze2_inf_north/RXDATA366_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA366_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA366_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA366_FD]
set_property LOC SLICE_X183Y297 [get_cells gtze2_inf_north/RXDATA366_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA366_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA365_LUT1A]
set_property LOC SLICE_X182Y297 [get_cells gtze2_inf_north/RXDATA365_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA365_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA365_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA365_LUT1B]
set_property LOC SLICE_X182Y297 [get_cells gtze2_inf_north/RXDATA365_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA365_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA365_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA365_FD]
set_property LOC SLICE_X183Y297 [get_cells gtze2_inf_north/RXDATA365_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA365_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA364_LUT1A]
set_property LOC SLICE_X182Y297 [get_cells gtze2_inf_north/RXDATA364_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA364_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA364_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA364_LUT1B]
set_property LOC SLICE_X182Y297 [get_cells gtze2_inf_north/RXDATA364_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA364_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA364_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA364_FD]
set_property LOC SLICE_X183Y297 [get_cells gtze2_inf_north/RXDATA364_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA364_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA363_LUT1A]
set_property LOC SLICE_X184Y262 [get_cells gtze2_inf_north/RXDATA363_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA363_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA363_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA363_LUT1B]
set_property LOC SLICE_X184Y262 [get_cells gtze2_inf_north/RXDATA363_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA363_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA363_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X185Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA363_FD]
set_property LOC SLICE_X185Y262 [get_cells gtze2_inf_north/RXDATA363_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA363_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA362_LUT1A]
set_property LOC SLICE_X184Y262 [get_cells gtze2_inf_north/RXDATA362_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA362_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA362_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA362_LUT1B]
set_property LOC SLICE_X184Y262 [get_cells gtze2_inf_north/RXDATA362_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA362_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA362_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA362_FD]
set_property LOC SLICE_X185Y262 [get_cells gtze2_inf_north/RXDATA362_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA362_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA361_LUT1A]
set_property LOC SLICE_X184Y262 [get_cells gtze2_inf_north/RXDATA361_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA361_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA361_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA361_LUT1B]
set_property LOC SLICE_X184Y262 [get_cells gtze2_inf_north/RXDATA361_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA361_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA361_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA361_FD]
set_property LOC SLICE_X185Y262 [get_cells gtze2_inf_north/RXDATA361_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA361_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3122_LUT1A]
set_property LOC SLICE_X180Y267 [get_cells gtze2_inf_north/RXDATA3122_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3122_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3122_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3122_LUT1B]
set_property LOC SLICE_X180Y267 [get_cells gtze2_inf_north/RXDATA3122_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3122_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3122_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y267/D5FF]
set_property PROHIBIT true [get_bels SLICE_X181Y267/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3122_FD]
set_property LOC SLICE_X181Y267 [get_cells gtze2_inf_north/RXDATA3122_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3122_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3121_LUT1A]
set_property LOC SLICE_X180Y267 [get_cells gtze2_inf_north/RXDATA3121_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3121_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3121_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3121_LUT1B]
set_property LOC SLICE_X180Y267 [get_cells gtze2_inf_north/RXDATA3121_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3121_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3121_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3121_FD]
set_property LOC SLICE_X181Y267 [get_cells gtze2_inf_north/RXDATA3121_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3121_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3120_LUT1A]
set_property LOC SLICE_X180Y267 [get_cells gtze2_inf_north/RXDATA3120_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3120_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3120_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3120_LUT1B]
set_property LOC SLICE_X180Y267 [get_cells gtze2_inf_north/RXDATA3120_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3120_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3120_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3120_FD]
set_property LOC SLICE_X181Y267 [get_cells gtze2_inf_north/RXDATA3120_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3120_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3119_LUT1A]
set_property LOC SLICE_X180Y272 [get_cells gtze2_inf_north/RXDATA3119_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3119_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3119_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3119_LUT1B]
set_property LOC SLICE_X180Y272 [get_cells gtze2_inf_north/RXDATA3119_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3119_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3119_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X181Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3119_FD]
set_property LOC SLICE_X181Y272 [get_cells gtze2_inf_north/RXDATA3119_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3119_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3118_LUT1A]
set_property LOC SLICE_X180Y272 [get_cells gtze2_inf_north/RXDATA3118_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3118_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3118_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3118_LUT1B]
set_property LOC SLICE_X180Y272 [get_cells gtze2_inf_north/RXDATA3118_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3118_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3118_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3118_FD]
set_property LOC SLICE_X181Y272 [get_cells gtze2_inf_north/RXDATA3118_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3118_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3117_LUT1A]
set_property LOC SLICE_X180Y272 [get_cells gtze2_inf_north/RXDATA3117_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3117_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3117_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3117_LUT1B]
set_property LOC SLICE_X180Y272 [get_cells gtze2_inf_north/RXDATA3117_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3117_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3117_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3117_FD]
set_property LOC SLICE_X181Y272 [get_cells gtze2_inf_north/RXDATA3117_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3117_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3116_LUT1A]
set_property LOC SLICE_X180Y272 [get_cells gtze2_inf_north/RXDATA3116_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3116_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3116_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3116_LUT1B]
set_property LOC SLICE_X180Y272 [get_cells gtze2_inf_north/RXDATA3116_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3116_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3116_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3116_FD]
set_property LOC SLICE_X181Y272 [get_cells gtze2_inf_north/RXDATA3116_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3116_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3115_LUT1A]
set_property LOC SLICE_X180Y277 [get_cells gtze2_inf_north/RXDATA3115_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3115_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3115_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3115_LUT1B]
set_property LOC SLICE_X180Y277 [get_cells gtze2_inf_north/RXDATA3115_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3115_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3115_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X181Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3115_FD]
set_property LOC SLICE_X181Y277 [get_cells gtze2_inf_north/RXDATA3115_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3115_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3114_LUT1A]
set_property LOC SLICE_X180Y277 [get_cells gtze2_inf_north/RXDATA3114_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3114_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3114_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3114_LUT1B]
set_property LOC SLICE_X180Y277 [get_cells gtze2_inf_north/RXDATA3114_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3114_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3114_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3114_FD]
set_property LOC SLICE_X181Y277 [get_cells gtze2_inf_north/RXDATA3114_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3114_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3113_LUT1A]
set_property LOC SLICE_X180Y277 [get_cells gtze2_inf_north/RXDATA3113_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3113_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3113_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3113_LUT1B]
set_property LOC SLICE_X180Y277 [get_cells gtze2_inf_north/RXDATA3113_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3113_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3113_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3113_FD]
set_property LOC SLICE_X181Y277 [get_cells gtze2_inf_north/RXDATA3113_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3113_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3112_LUT1A]
set_property LOC SLICE_X180Y277 [get_cells gtze2_inf_north/RXDATA3112_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3112_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3112_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3112_LUT1B]
set_property LOC SLICE_X180Y277 [get_cells gtze2_inf_north/RXDATA3112_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3112_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3112_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3112_FD]
set_property LOC SLICE_X181Y277 [get_cells gtze2_inf_north/RXDATA3112_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3112_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3111_LUT1A]
set_property LOC SLICE_X180Y282 [get_cells gtze2_inf_north/RXDATA3111_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3111_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3111_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3111_LUT1B]
set_property LOC SLICE_X180Y282 [get_cells gtze2_inf_north/RXDATA3111_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3111_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3111_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X181Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3111_FD]
set_property LOC SLICE_X181Y282 [get_cells gtze2_inf_north/RXDATA3111_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3111_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3110_LUT1A]
set_property LOC SLICE_X180Y282 [get_cells gtze2_inf_north/RXDATA3110_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3110_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3110_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3110_LUT1B]
set_property LOC SLICE_X180Y282 [get_cells gtze2_inf_north/RXDATA3110_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3110_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3110_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3110_FD]
set_property LOC SLICE_X181Y282 [get_cells gtze2_inf_north/RXDATA3110_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3110_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3109_LUT1A]
set_property LOC SLICE_X180Y282 [get_cells gtze2_inf_north/RXDATA3109_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3109_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3109_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3109_LUT1B]
set_property LOC SLICE_X180Y282 [get_cells gtze2_inf_north/RXDATA3109_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3109_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3109_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3109_FD]
set_property LOC SLICE_X181Y282 [get_cells gtze2_inf_north/RXDATA3109_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3109_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3108_LUT1A]
set_property LOC SLICE_X180Y282 [get_cells gtze2_inf_north/RXDATA3108_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3108_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3108_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3108_LUT1B]
set_property LOC SLICE_X180Y282 [get_cells gtze2_inf_north/RXDATA3108_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3108_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3108_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3108_FD]
set_property LOC SLICE_X181Y282 [get_cells gtze2_inf_north/RXDATA3108_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3108_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3107_LUT1A]
set_property LOC SLICE_X180Y287 [get_cells gtze2_inf_north/RXDATA3107_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3107_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3107_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3107_LUT1B]
set_property LOC SLICE_X180Y287 [get_cells gtze2_inf_north/RXDATA3107_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3107_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3107_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X181Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3107_FD]
set_property LOC SLICE_X181Y287 [get_cells gtze2_inf_north/RXDATA3107_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3107_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3106_LUT1A]
set_property LOC SLICE_X180Y287 [get_cells gtze2_inf_north/RXDATA3106_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3106_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3106_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3106_LUT1B]
set_property LOC SLICE_X180Y287 [get_cells gtze2_inf_north/RXDATA3106_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3106_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3106_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3106_FD]
set_property LOC SLICE_X181Y287 [get_cells gtze2_inf_north/RXDATA3106_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3106_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3105_LUT1A]
set_property LOC SLICE_X180Y287 [get_cells gtze2_inf_north/RXDATA3105_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3105_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3105_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3105_LUT1B]
set_property LOC SLICE_X180Y287 [get_cells gtze2_inf_north/RXDATA3105_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3105_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3105_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3105_FD]
set_property LOC SLICE_X181Y287 [get_cells gtze2_inf_north/RXDATA3105_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3105_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3104_LUT1A]
set_property LOC SLICE_X180Y287 [get_cells gtze2_inf_north/RXDATA3104_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3104_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3104_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3104_LUT1B]
set_property LOC SLICE_X180Y287 [get_cells gtze2_inf_north/RXDATA3104_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3104_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3104_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3104_FD]
set_property LOC SLICE_X181Y287 [get_cells gtze2_inf_north/RXDATA3104_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3104_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3103_LUT1A]
set_property LOC SLICE_X180Y292 [get_cells gtze2_inf_north/RXDATA3103_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3103_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3103_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3103_LUT1B]
set_property LOC SLICE_X180Y292 [get_cells gtze2_inf_north/RXDATA3103_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3103_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3103_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X181Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3103_FD]
set_property LOC SLICE_X181Y292 [get_cells gtze2_inf_north/RXDATA3103_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3103_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3102_LUT1A]
set_property LOC SLICE_X180Y292 [get_cells gtze2_inf_north/RXDATA3102_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3102_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3102_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3102_LUT1B]
set_property LOC SLICE_X180Y292 [get_cells gtze2_inf_north/RXDATA3102_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3102_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3102_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3102_FD]
set_property LOC SLICE_X181Y292 [get_cells gtze2_inf_north/RXDATA3102_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3102_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3101_LUT1A]
set_property LOC SLICE_X180Y292 [get_cells gtze2_inf_north/RXDATA3101_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3101_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3101_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3101_LUT1B]
set_property LOC SLICE_X180Y292 [get_cells gtze2_inf_north/RXDATA3101_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3101_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3101_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3101_FD]
set_property LOC SLICE_X181Y292 [get_cells gtze2_inf_north/RXDATA3101_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3101_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3100_LUT1A]
set_property LOC SLICE_X180Y292 [get_cells gtze2_inf_north/RXDATA3100_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3100_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3100_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3100_LUT1B]
set_property LOC SLICE_X180Y292 [get_cells gtze2_inf_north/RXDATA3100_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3100_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3100_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3100_FD]
set_property LOC SLICE_X181Y292 [get_cells gtze2_inf_north/RXDATA3100_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3100_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA399_LUT1A]
set_property LOC SLICE_X180Y297 [get_cells gtze2_inf_north/RXDATA399_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA399_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA399_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA399_LUT1B]
set_property LOC SLICE_X180Y297 [get_cells gtze2_inf_north/RXDATA399_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA399_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA399_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X181Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA399_FD]
set_property LOC SLICE_X181Y297 [get_cells gtze2_inf_north/RXDATA399_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA399_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA398_LUT1A]
set_property LOC SLICE_X180Y297 [get_cells gtze2_inf_north/RXDATA398_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA398_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA398_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA398_LUT1B]
set_property LOC SLICE_X180Y297 [get_cells gtze2_inf_north/RXDATA398_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA398_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA398_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA398_FD]
set_property LOC SLICE_X181Y297 [get_cells gtze2_inf_north/RXDATA398_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA398_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA397_LUT1A]
set_property LOC SLICE_X180Y297 [get_cells gtze2_inf_north/RXDATA397_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA397_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA397_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA397_LUT1B]
set_property LOC SLICE_X180Y297 [get_cells gtze2_inf_north/RXDATA397_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA397_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA397_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA397_FD]
set_property LOC SLICE_X181Y297 [get_cells gtze2_inf_north/RXDATA397_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA397_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA396_LUT1A]
set_property LOC SLICE_X180Y297 [get_cells gtze2_inf_north/RXDATA396_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA396_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA396_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA396_LUT1B]
set_property LOC SLICE_X180Y297 [get_cells gtze2_inf_north/RXDATA396_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA396_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA396_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA396_FD]
set_property LOC SLICE_X181Y297 [get_cells gtze2_inf_north/RXDATA396_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA396_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA395_LUT1A]
set_property LOC SLICE_X182Y262 [get_cells gtze2_inf_north/RXDATA395_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA395_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA395_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA395_LUT1B]
set_property LOC SLICE_X182Y262 [get_cells gtze2_inf_north/RXDATA395_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA395_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA395_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X183Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA395_FD]
set_property LOC SLICE_X183Y262 [get_cells gtze2_inf_north/RXDATA395_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA395_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA394_LUT1A]
set_property LOC SLICE_X182Y262 [get_cells gtze2_inf_north/RXDATA394_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA394_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA394_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA394_LUT1B]
set_property LOC SLICE_X182Y262 [get_cells gtze2_inf_north/RXDATA394_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA394_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA394_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA394_FD]
set_property LOC SLICE_X183Y262 [get_cells gtze2_inf_north/RXDATA394_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA394_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA393_LUT1A]
set_property LOC SLICE_X182Y262 [get_cells gtze2_inf_north/RXDATA393_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA393_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA393_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA393_LUT1B]
set_property LOC SLICE_X182Y262 [get_cells gtze2_inf_north/RXDATA393_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA393_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA393_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA393_FD]
set_property LOC SLICE_X183Y262 [get_cells gtze2_inf_north/RXDATA393_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA393_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA392_LUT1A]
set_property LOC SLICE_X182Y262 [get_cells gtze2_inf_north/RXDATA392_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA392_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA392_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA392_LUT1B]
set_property LOC SLICE_X182Y262 [get_cells gtze2_inf_north/RXDATA392_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA392_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA392_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA392_FD]
set_property LOC SLICE_X183Y262 [get_cells gtze2_inf_north/RXDATA392_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA392_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA391_LUT1A]
set_property LOC SLICE_X182Y267 [get_cells gtze2_inf_north/RXDATA391_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA391_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA391_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA391_LUT1B]
set_property LOC SLICE_X182Y267 [get_cells gtze2_inf_north/RXDATA391_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA391_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA391_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X183Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA391_FD]
set_property LOC SLICE_X183Y267 [get_cells gtze2_inf_north/RXDATA391_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA391_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3143_LUT1A]
set_property LOC SLICE_X178Y282 [get_cells gtze2_inf_north/RXDATA3143_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3143_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3143_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3143_LUT1B]
set_property LOC SLICE_X178Y282 [get_cells gtze2_inf_north/RXDATA3143_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X179Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3143_FD]
set_property LOC SLICE_X179Y282 [get_cells gtze2_inf_north/RXDATA3143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3143_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3142_LUT1A]
set_property LOC SLICE_X178Y282 [get_cells gtze2_inf_north/RXDATA3142_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3142_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3142_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3142_LUT1B]
set_property LOC SLICE_X178Y282 [get_cells gtze2_inf_north/RXDATA3142_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3142_FD]
set_property LOC SLICE_X179Y282 [get_cells gtze2_inf_north/RXDATA3142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3142_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3141_LUT1A]
set_property LOC SLICE_X178Y282 [get_cells gtze2_inf_north/RXDATA3141_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3141_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3141_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3141_LUT1B]
set_property LOC SLICE_X178Y282 [get_cells gtze2_inf_north/RXDATA3141_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3141_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3141_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3141_FD]
set_property LOC SLICE_X179Y282 [get_cells gtze2_inf_north/RXDATA3141_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3141_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3140_LUT1A]
set_property LOC SLICE_X178Y282 [get_cells gtze2_inf_north/RXDATA3140_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3140_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3140_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3140_LUT1B]
set_property LOC SLICE_X178Y282 [get_cells gtze2_inf_north/RXDATA3140_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3140_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3140_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3140_FD]
set_property LOC SLICE_X179Y282 [get_cells gtze2_inf_north/RXDATA3140_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3140_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3139_LUT1A]
set_property LOC SLICE_X178Y287 [get_cells gtze2_inf_north/RXDATA3139_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3139_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3139_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3139_LUT1B]
set_property LOC SLICE_X178Y287 [get_cells gtze2_inf_north/RXDATA3139_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3139_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3139_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X179Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3139_FD]
set_property LOC SLICE_X179Y287 [get_cells gtze2_inf_north/RXDATA3139_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3139_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3138_LUT1A]
set_property LOC SLICE_X178Y287 [get_cells gtze2_inf_north/RXDATA3138_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3138_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3138_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3138_LUT1B]
set_property LOC SLICE_X178Y287 [get_cells gtze2_inf_north/RXDATA3138_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3138_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3138_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3138_FD]
set_property LOC SLICE_X179Y287 [get_cells gtze2_inf_north/RXDATA3138_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3138_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3137_LUT1A]
set_property LOC SLICE_X178Y287 [get_cells gtze2_inf_north/RXDATA3137_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3137_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3137_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3137_LUT1B]
set_property LOC SLICE_X178Y287 [get_cells gtze2_inf_north/RXDATA3137_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3137_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3137_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3137_FD]
set_property LOC SLICE_X179Y287 [get_cells gtze2_inf_north/RXDATA3137_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3137_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3136_LUT1A]
set_property LOC SLICE_X178Y287 [get_cells gtze2_inf_north/RXDATA3136_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3136_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3136_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3136_LUT1B]
set_property LOC SLICE_X178Y287 [get_cells gtze2_inf_north/RXDATA3136_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3136_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3136_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3136_FD]
set_property LOC SLICE_X179Y287 [get_cells gtze2_inf_north/RXDATA3136_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3136_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3135_LUT1A]
set_property LOC SLICE_X178Y292 [get_cells gtze2_inf_north/RXDATA3135_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3135_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3135_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3135_LUT1B]
set_property LOC SLICE_X178Y292 [get_cells gtze2_inf_north/RXDATA3135_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3135_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3135_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X179Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3135_FD]
set_property LOC SLICE_X179Y292 [get_cells gtze2_inf_north/RXDATA3135_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3135_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3134_LUT1A]
set_property LOC SLICE_X178Y292 [get_cells gtze2_inf_north/RXDATA3134_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3134_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3134_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3134_LUT1B]
set_property LOC SLICE_X178Y292 [get_cells gtze2_inf_north/RXDATA3134_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3134_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3134_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3134_FD]
set_property LOC SLICE_X179Y292 [get_cells gtze2_inf_north/RXDATA3134_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3134_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3133_LUT1A]
set_property LOC SLICE_X178Y292 [get_cells gtze2_inf_north/RXDATA3133_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3133_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3133_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3133_LUT1B]
set_property LOC SLICE_X178Y292 [get_cells gtze2_inf_north/RXDATA3133_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3133_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3133_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3133_FD]
set_property LOC SLICE_X179Y292 [get_cells gtze2_inf_north/RXDATA3133_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3133_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3132_LUT1A]
set_property LOC SLICE_X178Y292 [get_cells gtze2_inf_north/RXDATA3132_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3132_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3132_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3132_LUT1B]
set_property LOC SLICE_X178Y292 [get_cells gtze2_inf_north/RXDATA3132_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3132_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3132_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3132_FD]
set_property LOC SLICE_X179Y292 [get_cells gtze2_inf_north/RXDATA3132_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3132_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3131_LUT1A]
set_property LOC SLICE_X178Y297 [get_cells gtze2_inf_north/RXDATA3131_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3131_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3131_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3131_LUT1B]
set_property LOC SLICE_X178Y297 [get_cells gtze2_inf_north/RXDATA3131_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3131_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3131_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X179Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3131_FD]
set_property LOC SLICE_X179Y297 [get_cells gtze2_inf_north/RXDATA3131_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3131_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3130_LUT1A]
set_property LOC SLICE_X178Y297 [get_cells gtze2_inf_north/RXDATA3130_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3130_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3130_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3130_LUT1B]
set_property LOC SLICE_X178Y297 [get_cells gtze2_inf_north/RXDATA3130_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3130_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3130_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3130_FD]
set_property LOC SLICE_X179Y297 [get_cells gtze2_inf_north/RXDATA3130_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3130_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3129_LUT1A]
set_property LOC SLICE_X178Y297 [get_cells gtze2_inf_north/RXDATA3129_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3129_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3129_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3129_LUT1B]
set_property LOC SLICE_X178Y297 [get_cells gtze2_inf_north/RXDATA3129_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3129_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3129_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3129_FD]
set_property LOC SLICE_X179Y297 [get_cells gtze2_inf_north/RXDATA3129_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3129_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3128_LUT1A]
set_property LOC SLICE_X178Y297 [get_cells gtze2_inf_north/RXDATA3128_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3128_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3128_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3128_LUT1B]
set_property LOC SLICE_X178Y297 [get_cells gtze2_inf_north/RXDATA3128_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3128_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3128_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3128_FD]
set_property LOC SLICE_X179Y297 [get_cells gtze2_inf_north/RXDATA3128_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3128_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3127_LUT1A]
set_property LOC SLICE_X180Y262 [get_cells gtze2_inf_north/RXDATA3127_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3127_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3127_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3127_LUT1B]
set_property LOC SLICE_X180Y262 [get_cells gtze2_inf_north/RXDATA3127_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3127_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3127_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X181Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3127_FD]
set_property LOC SLICE_X181Y262 [get_cells gtze2_inf_north/RXDATA3127_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3127_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3126_LUT1A]
set_property LOC SLICE_X180Y262 [get_cells gtze2_inf_north/RXDATA3126_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3126_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3126_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3126_LUT1B]
set_property LOC SLICE_X180Y262 [get_cells gtze2_inf_north/RXDATA3126_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3126_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3126_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3126_FD]
set_property LOC SLICE_X181Y262 [get_cells gtze2_inf_north/RXDATA3126_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3126_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3125_LUT1A]
set_property LOC SLICE_X180Y262 [get_cells gtze2_inf_north/RXDATA3125_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3125_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3125_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3125_LUT1B]
set_property LOC SLICE_X180Y262 [get_cells gtze2_inf_north/RXDATA3125_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3125_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3125_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3125_FD]
set_property LOC SLICE_X181Y262 [get_cells gtze2_inf_north/RXDATA3125_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3125_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3124_LUT1A]
set_property LOC SLICE_X180Y262 [get_cells gtze2_inf_north/RXDATA3124_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3124_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3124_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3124_LUT1B]
set_property LOC SLICE_X180Y262 [get_cells gtze2_inf_north/RXDATA3124_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3124_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3124_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3124_FD]
set_property LOC SLICE_X181Y262 [get_cells gtze2_inf_north/RXDATA3124_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3124_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3123_LUT1A]
set_property LOC SLICE_X180Y267 [get_cells gtze2_inf_north/RXDATA3123_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3123_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3123_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3123_LUT1B]
set_property LOC SLICE_X180Y267 [get_cells gtze2_inf_north/RXDATA3123_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3123_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3123_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X181Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3123_FD]
set_property LOC SLICE_X181Y267 [get_cells gtze2_inf_north/RXDATA3123_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3123_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA215_LUT1A]
set_property LOC SLICE_X166Y282 [get_cells gtze2_inf_north/RXDATA215_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA215_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA215_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA215_LUT1B]
set_property LOC SLICE_X166Y282 [get_cells gtze2_inf_north/RXDATA215_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA215_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA215_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X167Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA215_FD]
set_property LOC SLICE_X167Y282 [get_cells gtze2_inf_north/RXDATA215_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA215_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA214_LUT1A]
set_property LOC SLICE_X166Y282 [get_cells gtze2_inf_north/RXDATA214_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA214_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA214_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA214_LUT1B]
set_property LOC SLICE_X166Y282 [get_cells gtze2_inf_north/RXDATA214_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA214_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA214_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA214_FD]
set_property LOC SLICE_X167Y282 [get_cells gtze2_inf_north/RXDATA214_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA214_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA213_LUT1A]
set_property LOC SLICE_X166Y282 [get_cells gtze2_inf_north/RXDATA213_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA213_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA213_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA213_LUT1B]
set_property LOC SLICE_X166Y282 [get_cells gtze2_inf_north/RXDATA213_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA213_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA213_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA213_FD]
set_property LOC SLICE_X167Y282 [get_cells gtze2_inf_north/RXDATA213_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA213_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA212_LUT1A]
set_property LOC SLICE_X166Y282 [get_cells gtze2_inf_north/RXDATA212_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA212_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA212_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA212_LUT1B]
set_property LOC SLICE_X166Y282 [get_cells gtze2_inf_north/RXDATA212_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA212_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA212_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA212_FD]
set_property LOC SLICE_X167Y282 [get_cells gtze2_inf_north/RXDATA212_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA212_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA211_LUT1A]
set_property LOC SLICE_X166Y287 [get_cells gtze2_inf_north/RXDATA211_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA211_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA211_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA211_LUT1B]
set_property LOC SLICE_X166Y287 [get_cells gtze2_inf_north/RXDATA211_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA211_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA211_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X167Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA211_FD]
set_property LOC SLICE_X167Y287 [get_cells gtze2_inf_north/RXDATA211_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA211_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA210_LUT1A]
set_property LOC SLICE_X166Y287 [get_cells gtze2_inf_north/RXDATA210_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA210_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA210_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA210_LUT1B]
set_property LOC SLICE_X166Y287 [get_cells gtze2_inf_north/RXDATA210_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA210_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA210_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA210_FD]
set_property LOC SLICE_X167Y287 [get_cells gtze2_inf_north/RXDATA210_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA210_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA29_LUT1A]
set_property LOC SLICE_X166Y287 [get_cells gtze2_inf_north/RXDATA29_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA29_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA29_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA29_LUT1B]
set_property LOC SLICE_X166Y287 [get_cells gtze2_inf_north/RXDATA29_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA29_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA29_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA29_FD]
set_property LOC SLICE_X167Y287 [get_cells gtze2_inf_north/RXDATA29_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA29_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA28_LUT1A]
set_property LOC SLICE_X166Y287 [get_cells gtze2_inf_north/RXDATA28_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA28_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA28_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA28_LUT1B]
set_property LOC SLICE_X166Y287 [get_cells gtze2_inf_north/RXDATA28_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA28_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA28_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA28_FD]
set_property LOC SLICE_X167Y287 [get_cells gtze2_inf_north/RXDATA28_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA28_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA27_LUT1A]
set_property LOC SLICE_X166Y292 [get_cells gtze2_inf_north/RXDATA27_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA27_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA27_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA27_LUT1B]
set_property LOC SLICE_X166Y292 [get_cells gtze2_inf_north/RXDATA27_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA27_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA27_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X167Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA27_FD]
set_property LOC SLICE_X167Y292 [get_cells gtze2_inf_north/RXDATA27_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA27_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA26_LUT1A]
set_property LOC SLICE_X166Y292 [get_cells gtze2_inf_north/RXDATA26_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA26_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA26_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA26_LUT1B]
set_property LOC SLICE_X166Y292 [get_cells gtze2_inf_north/RXDATA26_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA26_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA26_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA26_FD]
set_property LOC SLICE_X167Y292 [get_cells gtze2_inf_north/RXDATA26_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA26_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA25_LUT1A]
set_property LOC SLICE_X166Y292 [get_cells gtze2_inf_north/RXDATA25_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA25_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA25_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA25_LUT1B]
set_property LOC SLICE_X166Y292 [get_cells gtze2_inf_north/RXDATA25_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA25_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA25_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA25_FD]
set_property LOC SLICE_X167Y292 [get_cells gtze2_inf_north/RXDATA25_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA25_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA24_LUT1A]
set_property LOC SLICE_X166Y292 [get_cells gtze2_inf_north/RXDATA24_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA24_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA24_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA24_LUT1B]
set_property LOC SLICE_X166Y292 [get_cells gtze2_inf_north/RXDATA24_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA24_FD]
set_property LOC SLICE_X167Y292 [get_cells gtze2_inf_north/RXDATA24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA24_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA23_LUT1A]
set_property LOC SLICE_X166Y297 [get_cells gtze2_inf_north/RXDATA23_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA23_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA23_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA23_LUT1B]
set_property LOC SLICE_X166Y297 [get_cells gtze2_inf_north/RXDATA23_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X167Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA23_FD]
set_property LOC SLICE_X167Y297 [get_cells gtze2_inf_north/RXDATA23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA23_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA22_LUT1A]
set_property LOC SLICE_X166Y297 [get_cells gtze2_inf_north/RXDATA22_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA22_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA22_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA22_LUT1B]
set_property LOC SLICE_X166Y297 [get_cells gtze2_inf_north/RXDATA22_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA22_FD]
set_property LOC SLICE_X167Y297 [get_cells gtze2_inf_north/RXDATA22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA22_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA21_LUT1A]
set_property LOC SLICE_X166Y297 [get_cells gtze2_inf_north/RXDATA21_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA21_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA21_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA21_LUT1B]
set_property LOC SLICE_X166Y297 [get_cells gtze2_inf_north/RXDATA21_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA21_FD]
set_property LOC SLICE_X167Y297 [get_cells gtze2_inf_north/RXDATA21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA21_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA20_LUT1A]
set_property LOC SLICE_X166Y297 [get_cells gtze2_inf_north/RXDATA20_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA20_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA20_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA20_LUT1B]
set_property LOC SLICE_X166Y297 [get_cells gtze2_inf_north/RXDATA20_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA20_FD]
set_property LOC SLICE_X167Y297 [get_cells gtze2_inf_north/RXDATA20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA20_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3159_LUT1A]
set_property LOC SLICE_X178Y262 [get_cells gtze2_inf_north/RXDATA3159_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3159_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3159_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3159_LUT1B]
set_property LOC SLICE_X178Y262 [get_cells gtze2_inf_north/RXDATA3159_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3159_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3159_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X179Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3159_FD]
set_property LOC SLICE_X179Y262 [get_cells gtze2_inf_north/RXDATA3159_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3159_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3158_LUT1A]
set_property LOC SLICE_X178Y262 [get_cells gtze2_inf_north/RXDATA3158_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3158_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3158_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3158_LUT1B]
set_property LOC SLICE_X178Y262 [get_cells gtze2_inf_north/RXDATA3158_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3158_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3158_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3158_FD]
set_property LOC SLICE_X179Y262 [get_cells gtze2_inf_north/RXDATA3158_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3158_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3157_LUT1A]
set_property LOC SLICE_X178Y262 [get_cells gtze2_inf_north/RXDATA3157_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3157_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3157_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3157_LUT1B]
set_property LOC SLICE_X178Y262 [get_cells gtze2_inf_north/RXDATA3157_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3157_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3157_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3157_FD]
set_property LOC SLICE_X179Y262 [get_cells gtze2_inf_north/RXDATA3157_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3157_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3156_LUT1A]
set_property LOC SLICE_X178Y262 [get_cells gtze2_inf_north/RXDATA3156_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3156_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3156_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3156_LUT1B]
set_property LOC SLICE_X178Y262 [get_cells gtze2_inf_north/RXDATA3156_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3156_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3156_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3156_FD]
set_property LOC SLICE_X179Y262 [get_cells gtze2_inf_north/RXDATA3156_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3156_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3155_LUT1A]
set_property LOC SLICE_X178Y267 [get_cells gtze2_inf_north/RXDATA3155_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3155_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3155_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3155_LUT1B]
set_property LOC SLICE_X178Y267 [get_cells gtze2_inf_north/RXDATA3155_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3155_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3155_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X179Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3155_FD]
set_property LOC SLICE_X179Y267 [get_cells gtze2_inf_north/RXDATA3155_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3155_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3154_LUT1A]
set_property LOC SLICE_X178Y267 [get_cells gtze2_inf_north/RXDATA3154_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3154_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3154_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3154_LUT1B]
set_property LOC SLICE_X178Y267 [get_cells gtze2_inf_north/RXDATA3154_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3154_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3154_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3154_FD]
set_property LOC SLICE_X179Y267 [get_cells gtze2_inf_north/RXDATA3154_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3154_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3153_LUT1A]
set_property LOC SLICE_X178Y267 [get_cells gtze2_inf_north/RXDATA3153_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3153_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3153_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3153_LUT1B]
set_property LOC SLICE_X178Y267 [get_cells gtze2_inf_north/RXDATA3153_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3153_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3153_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3153_FD]
set_property LOC SLICE_X179Y267 [get_cells gtze2_inf_north/RXDATA3153_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3153_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3152_LUT1A]
set_property LOC SLICE_X178Y267 [get_cells gtze2_inf_north/RXDATA3152_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3152_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3152_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3152_LUT1B]
set_property LOC SLICE_X178Y267 [get_cells gtze2_inf_north/RXDATA3152_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3152_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3152_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3152_FD]
set_property LOC SLICE_X179Y267 [get_cells gtze2_inf_north/RXDATA3152_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3152_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3151_LUT1A]
set_property LOC SLICE_X178Y272 [get_cells gtze2_inf_north/RXDATA3151_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3151_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3151_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3151_LUT1B]
set_property LOC SLICE_X178Y272 [get_cells gtze2_inf_north/RXDATA3151_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3151_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3151_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X179Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3151_FD]
set_property LOC SLICE_X179Y272 [get_cells gtze2_inf_north/RXDATA3151_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3151_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3150_LUT1A]
set_property LOC SLICE_X178Y272 [get_cells gtze2_inf_north/RXDATA3150_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3150_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3150_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3150_LUT1B]
set_property LOC SLICE_X178Y272 [get_cells gtze2_inf_north/RXDATA3150_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3150_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3150_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3150_FD]
set_property LOC SLICE_X179Y272 [get_cells gtze2_inf_north/RXDATA3150_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3150_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3149_LUT1A]
set_property LOC SLICE_X178Y272 [get_cells gtze2_inf_north/RXDATA3149_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3149_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3149_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3149_LUT1B]
set_property LOC SLICE_X178Y272 [get_cells gtze2_inf_north/RXDATA3149_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3149_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3149_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3149_FD]
set_property LOC SLICE_X179Y272 [get_cells gtze2_inf_north/RXDATA3149_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3149_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3148_LUT1A]
set_property LOC SLICE_X178Y272 [get_cells gtze2_inf_north/RXDATA3148_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3148_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3148_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3148_LUT1B]
set_property LOC SLICE_X178Y272 [get_cells gtze2_inf_north/RXDATA3148_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3148_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3148_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3148_FD]
set_property LOC SLICE_X179Y272 [get_cells gtze2_inf_north/RXDATA3148_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3148_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA3147_LUT1A]
set_property LOC SLICE_X178Y277 [get_cells gtze2_inf_north/RXDATA3147_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3147_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3147_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA3147_LUT1B]
set_property LOC SLICE_X178Y277 [get_cells gtze2_inf_north/RXDATA3147_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3147_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3147_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X179Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA3147_FD]
set_property LOC SLICE_X179Y277 [get_cells gtze2_inf_north/RXDATA3147_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3147_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA3146_LUT1A]
set_property LOC SLICE_X178Y277 [get_cells gtze2_inf_north/RXDATA3146_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3146_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3146_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA3146_LUT1B]
set_property LOC SLICE_X178Y277 [get_cells gtze2_inf_north/RXDATA3146_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3146_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3146_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA3146_FD]
set_property LOC SLICE_X179Y277 [get_cells gtze2_inf_north/RXDATA3146_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3146_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA3145_LUT1A]
set_property LOC SLICE_X178Y277 [get_cells gtze2_inf_north/RXDATA3145_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA3145_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3145_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA3145_LUT1B]
set_property LOC SLICE_X178Y277 [get_cells gtze2_inf_north/RXDATA3145_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA3145_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3145_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA3145_FD]
set_property LOC SLICE_X179Y277 [get_cells gtze2_inf_north/RXDATA3145_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3145_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA3144_LUT1A]
set_property LOC SLICE_X178Y277 [get_cells gtze2_inf_north/RXDATA3144_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA3144_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3144_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA3144_LUT1B]
set_property LOC SLICE_X178Y277 [get_cells gtze2_inf_north/RXDATA3144_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA3144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X179Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA3144_FD]
set_property LOC SLICE_X179Y277 [get_cells gtze2_inf_north/RXDATA3144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA3144_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA247_LUT1A]
set_property LOC SLICE_X164Y282 [get_cells gtze2_inf_north/RXDATA247_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA247_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA247_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA247_LUT1B]
set_property LOC SLICE_X164Y282 [get_cells gtze2_inf_north/RXDATA247_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA247_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA247_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X165Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA247_FD]
set_property LOC SLICE_X165Y282 [get_cells gtze2_inf_north/RXDATA247_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA247_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA246_LUT1A]
set_property LOC SLICE_X164Y282 [get_cells gtze2_inf_north/RXDATA246_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA246_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA246_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA246_LUT1B]
set_property LOC SLICE_X164Y282 [get_cells gtze2_inf_north/RXDATA246_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA246_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA246_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA246_FD]
set_property LOC SLICE_X165Y282 [get_cells gtze2_inf_north/RXDATA246_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA246_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA245_LUT1A]
set_property LOC SLICE_X164Y282 [get_cells gtze2_inf_north/RXDATA245_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA245_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA245_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA245_LUT1B]
set_property LOC SLICE_X164Y282 [get_cells gtze2_inf_north/RXDATA245_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA245_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA245_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA245_FD]
set_property LOC SLICE_X165Y282 [get_cells gtze2_inf_north/RXDATA245_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA245_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA244_LUT1A]
set_property LOC SLICE_X164Y282 [get_cells gtze2_inf_north/RXDATA244_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA244_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA244_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA244_LUT1B]
set_property LOC SLICE_X164Y282 [get_cells gtze2_inf_north/RXDATA244_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA244_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA244_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA244_FD]
set_property LOC SLICE_X165Y282 [get_cells gtze2_inf_north/RXDATA244_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA244_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA243_LUT1A]
set_property LOC SLICE_X164Y287 [get_cells gtze2_inf_north/RXDATA243_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA243_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA243_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA243_LUT1B]
set_property LOC SLICE_X164Y287 [get_cells gtze2_inf_north/RXDATA243_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA243_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA243_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X165Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA243_FD]
set_property LOC SLICE_X165Y287 [get_cells gtze2_inf_north/RXDATA243_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA243_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA242_LUT1A]
set_property LOC SLICE_X164Y287 [get_cells gtze2_inf_north/RXDATA242_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA242_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA242_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA242_LUT1B]
set_property LOC SLICE_X164Y287 [get_cells gtze2_inf_north/RXDATA242_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA242_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA242_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA242_FD]
set_property LOC SLICE_X165Y287 [get_cells gtze2_inf_north/RXDATA242_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA242_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA241_LUT1A]
set_property LOC SLICE_X164Y287 [get_cells gtze2_inf_north/RXDATA241_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA241_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA241_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA241_LUT1B]
set_property LOC SLICE_X164Y287 [get_cells gtze2_inf_north/RXDATA241_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA241_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA241_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA241_FD]
set_property LOC SLICE_X165Y287 [get_cells gtze2_inf_north/RXDATA241_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA241_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA240_LUT1A]
set_property LOC SLICE_X164Y287 [get_cells gtze2_inf_north/RXDATA240_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA240_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA240_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA240_LUT1B]
set_property LOC SLICE_X164Y287 [get_cells gtze2_inf_north/RXDATA240_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA240_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA240_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA240_FD]
set_property LOC SLICE_X165Y287 [get_cells gtze2_inf_north/RXDATA240_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA240_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA239_LUT1A]
set_property LOC SLICE_X164Y292 [get_cells gtze2_inf_north/RXDATA239_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA239_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA239_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA239_LUT1B]
set_property LOC SLICE_X164Y292 [get_cells gtze2_inf_north/RXDATA239_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA239_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA239_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X165Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA239_FD]
set_property LOC SLICE_X165Y292 [get_cells gtze2_inf_north/RXDATA239_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA239_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA238_LUT1A]
set_property LOC SLICE_X164Y292 [get_cells gtze2_inf_north/RXDATA238_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA238_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA238_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA238_LUT1B]
set_property LOC SLICE_X164Y292 [get_cells gtze2_inf_north/RXDATA238_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA238_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA238_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA238_FD]
set_property LOC SLICE_X165Y292 [get_cells gtze2_inf_north/RXDATA238_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA238_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA237_LUT1A]
set_property LOC SLICE_X164Y292 [get_cells gtze2_inf_north/RXDATA237_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA237_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA237_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA237_LUT1B]
set_property LOC SLICE_X164Y292 [get_cells gtze2_inf_north/RXDATA237_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA237_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA237_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA237_FD]
set_property LOC SLICE_X165Y292 [get_cells gtze2_inf_north/RXDATA237_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA237_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA236_LUT1A]
set_property LOC SLICE_X164Y292 [get_cells gtze2_inf_north/RXDATA236_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA236_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA236_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA236_LUT1B]
set_property LOC SLICE_X164Y292 [get_cells gtze2_inf_north/RXDATA236_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA236_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA236_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA236_FD]
set_property LOC SLICE_X165Y292 [get_cells gtze2_inf_north/RXDATA236_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA236_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA235_LUT1A]
set_property LOC SLICE_X164Y297 [get_cells gtze2_inf_north/RXDATA235_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA235_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA235_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA235_LUT1B]
set_property LOC SLICE_X164Y297 [get_cells gtze2_inf_north/RXDATA235_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA235_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA235_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X165Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA235_FD]
set_property LOC SLICE_X165Y297 [get_cells gtze2_inf_north/RXDATA235_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA235_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA234_LUT1A]
set_property LOC SLICE_X164Y297 [get_cells gtze2_inf_north/RXDATA234_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA234_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA234_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA234_LUT1B]
set_property LOC SLICE_X164Y297 [get_cells gtze2_inf_north/RXDATA234_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA234_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA234_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA234_FD]
set_property LOC SLICE_X165Y297 [get_cells gtze2_inf_north/RXDATA234_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA234_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA233_LUT1A]
set_property LOC SLICE_X164Y297 [get_cells gtze2_inf_north/RXDATA233_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA233_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA233_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA233_LUT1B]
set_property LOC SLICE_X164Y297 [get_cells gtze2_inf_north/RXDATA233_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA233_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA233_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA233_FD]
set_property LOC SLICE_X165Y297 [get_cells gtze2_inf_north/RXDATA233_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA233_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA232_LUT1A]
set_property LOC SLICE_X164Y297 [get_cells gtze2_inf_north/RXDATA232_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA232_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA232_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA232_LUT1B]
set_property LOC SLICE_X164Y297 [get_cells gtze2_inf_north/RXDATA232_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA232_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA232_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA232_FD]
set_property LOC SLICE_X165Y297 [get_cells gtze2_inf_north/RXDATA232_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA232_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA231_LUT1A]
set_property LOC SLICE_X166Y262 [get_cells gtze2_inf_north/RXDATA231_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA231_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA231_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA231_LUT1B]
set_property LOC SLICE_X166Y262 [get_cells gtze2_inf_north/RXDATA231_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA231_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA231_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X167Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA231_FD]
set_property LOC SLICE_X167Y262 [get_cells gtze2_inf_north/RXDATA231_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA231_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA230_LUT1A]
set_property LOC SLICE_X166Y262 [get_cells gtze2_inf_north/RXDATA230_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA230_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA230_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA230_LUT1B]
set_property LOC SLICE_X166Y262 [get_cells gtze2_inf_north/RXDATA230_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA230_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA230_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA230_FD]
set_property LOC SLICE_X167Y262 [get_cells gtze2_inf_north/RXDATA230_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA230_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA229_LUT1A]
set_property LOC SLICE_X166Y262 [get_cells gtze2_inf_north/RXDATA229_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA229_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA229_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA229_LUT1B]
set_property LOC SLICE_X166Y262 [get_cells gtze2_inf_north/RXDATA229_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA229_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA229_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA229_FD]
set_property LOC SLICE_X167Y262 [get_cells gtze2_inf_north/RXDATA229_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA229_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA228_LUT1A]
set_property LOC SLICE_X166Y262 [get_cells gtze2_inf_north/RXDATA228_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA228_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA228_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA228_LUT1B]
set_property LOC SLICE_X166Y262 [get_cells gtze2_inf_north/RXDATA228_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA228_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA228_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA228_FD]
set_property LOC SLICE_X167Y262 [get_cells gtze2_inf_north/RXDATA228_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA228_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA227_LUT1A]
set_property LOC SLICE_X166Y267 [get_cells gtze2_inf_north/RXDATA227_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA227_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA227_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA227_LUT1B]
set_property LOC SLICE_X166Y267 [get_cells gtze2_inf_north/RXDATA227_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA227_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA227_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X167Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA227_FD]
set_property LOC SLICE_X167Y267 [get_cells gtze2_inf_north/RXDATA227_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA227_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA226_LUT1A]
set_property LOC SLICE_X166Y267 [get_cells gtze2_inf_north/RXDATA226_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA226_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA226_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA226_LUT1B]
set_property LOC SLICE_X166Y267 [get_cells gtze2_inf_north/RXDATA226_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA226_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA226_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA226_FD]
set_property LOC SLICE_X167Y267 [get_cells gtze2_inf_north/RXDATA226_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA226_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA225_LUT1A]
set_property LOC SLICE_X166Y267 [get_cells gtze2_inf_north/RXDATA225_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA225_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA225_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA225_LUT1B]
set_property LOC SLICE_X166Y267 [get_cells gtze2_inf_north/RXDATA225_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA225_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA225_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA225_FD]
set_property LOC SLICE_X167Y267 [get_cells gtze2_inf_north/RXDATA225_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA225_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA224_LUT1A]
set_property LOC SLICE_X166Y267 [get_cells gtze2_inf_north/RXDATA224_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA224_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA224_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA224_LUT1B]
set_property LOC SLICE_X166Y267 [get_cells gtze2_inf_north/RXDATA224_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA224_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA224_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA224_FD]
set_property LOC SLICE_X167Y267 [get_cells gtze2_inf_north/RXDATA224_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA224_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA223_LUT1A]
set_property LOC SLICE_X166Y272 [get_cells gtze2_inf_north/RXDATA223_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA223_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA223_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA223_LUT1B]
set_property LOC SLICE_X166Y272 [get_cells gtze2_inf_north/RXDATA223_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA223_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA223_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X167Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA223_FD]
set_property LOC SLICE_X167Y272 [get_cells gtze2_inf_north/RXDATA223_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA223_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA222_LUT1A]
set_property LOC SLICE_X166Y272 [get_cells gtze2_inf_north/RXDATA222_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA222_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA222_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA222_LUT1B]
set_property LOC SLICE_X166Y272 [get_cells gtze2_inf_north/RXDATA222_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA222_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA222_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA222_FD]
set_property LOC SLICE_X167Y272 [get_cells gtze2_inf_north/RXDATA222_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA222_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA221_LUT1A]
set_property LOC SLICE_X166Y272 [get_cells gtze2_inf_north/RXDATA221_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA221_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA221_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA221_LUT1B]
set_property LOC SLICE_X166Y272 [get_cells gtze2_inf_north/RXDATA221_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA221_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA221_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA221_FD]
set_property LOC SLICE_X167Y272 [get_cells gtze2_inf_north/RXDATA221_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA221_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA220_LUT1A]
set_property LOC SLICE_X166Y272 [get_cells gtze2_inf_north/RXDATA220_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA220_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA220_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA220_LUT1B]
set_property LOC SLICE_X166Y272 [get_cells gtze2_inf_north/RXDATA220_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA220_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA220_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA220_FD]
set_property LOC SLICE_X167Y272 [get_cells gtze2_inf_north/RXDATA220_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA220_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA219_LUT1A]
set_property LOC SLICE_X166Y277 [get_cells gtze2_inf_north/RXDATA219_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA219_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA219_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA219_LUT1B]
set_property LOC SLICE_X166Y277 [get_cells gtze2_inf_north/RXDATA219_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA219_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA219_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X167Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA219_FD]
set_property LOC SLICE_X167Y277 [get_cells gtze2_inf_north/RXDATA219_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA219_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA218_LUT1A]
set_property LOC SLICE_X166Y277 [get_cells gtze2_inf_north/RXDATA218_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA218_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA218_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA218_LUT1B]
set_property LOC SLICE_X166Y277 [get_cells gtze2_inf_north/RXDATA218_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA218_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA218_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA218_FD]
set_property LOC SLICE_X167Y277 [get_cells gtze2_inf_north/RXDATA218_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA218_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA217_LUT1A]
set_property LOC SLICE_X166Y277 [get_cells gtze2_inf_north/RXDATA217_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA217_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA217_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA217_LUT1B]
set_property LOC SLICE_X166Y277 [get_cells gtze2_inf_north/RXDATA217_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA217_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA217_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA217_FD]
set_property LOC SLICE_X167Y277 [get_cells gtze2_inf_north/RXDATA217_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA217_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA216_LUT1A]
set_property LOC SLICE_X166Y277 [get_cells gtze2_inf_north/RXDATA216_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA216_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA216_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA216_LUT1B]
set_property LOC SLICE_X166Y277 [get_cells gtze2_inf_north/RXDATA216_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA216_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA216_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X167Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA216_FD]
set_property LOC SLICE_X167Y277 [get_cells gtze2_inf_north/RXDATA216_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA216_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA314_LUT1B]
set_property LOC SLICE_X177Y270 [get_cells gtze2_inf_north/TXDATA314_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA314_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA314_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA314_FD]
set_property LOC SLICE_X177Y270 [get_cells gtze2_inf_north/TXDATA314_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA314_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA260_LUT1A]
set_property LOC SLICE_X164Y262 [get_cells gtze2_inf_north/RXDATA260_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA260_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA260_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA260_LUT1B]
set_property LOC SLICE_X164Y262 [get_cells gtze2_inf_north/RXDATA260_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA260_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA260_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA260_FD]
set_property LOC SLICE_X165Y262 [get_cells gtze2_inf_north/RXDATA260_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA260_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA259_LUT1A]
set_property LOC SLICE_X164Y267 [get_cells gtze2_inf_north/RXDATA259_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA259_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA259_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA259_LUT1B]
set_property LOC SLICE_X164Y267 [get_cells gtze2_inf_north/RXDATA259_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA259_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA259_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X165Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA259_FD]
set_property LOC SLICE_X165Y267 [get_cells gtze2_inf_north/RXDATA259_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA259_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA258_LUT1A]
set_property LOC SLICE_X164Y267 [get_cells gtze2_inf_north/RXDATA258_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA258_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA258_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA258_LUT1B]
set_property LOC SLICE_X164Y267 [get_cells gtze2_inf_north/RXDATA258_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA258_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA258_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA258_FD]
set_property LOC SLICE_X165Y267 [get_cells gtze2_inf_north/RXDATA258_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA258_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA257_LUT1A]
set_property LOC SLICE_X164Y267 [get_cells gtze2_inf_north/RXDATA257_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA257_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA257_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA257_LUT1B]
set_property LOC SLICE_X164Y267 [get_cells gtze2_inf_north/RXDATA257_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA257_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA257_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA257_FD]
set_property LOC SLICE_X165Y267 [get_cells gtze2_inf_north/RXDATA257_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA257_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA256_LUT1A]
set_property LOC SLICE_X164Y267 [get_cells gtze2_inf_north/RXDATA256_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA256_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA256_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA256_LUT1B]
set_property LOC SLICE_X164Y267 [get_cells gtze2_inf_north/RXDATA256_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA256_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA256_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA256_FD]
set_property LOC SLICE_X165Y267 [get_cells gtze2_inf_north/RXDATA256_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA256_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA255_LUT1A]
set_property LOC SLICE_X164Y272 [get_cells gtze2_inf_north/RXDATA255_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA255_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA255_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA255_LUT1B]
set_property LOC SLICE_X164Y272 [get_cells gtze2_inf_north/RXDATA255_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA255_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA255_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X165Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA255_FD]
set_property LOC SLICE_X165Y272 [get_cells gtze2_inf_north/RXDATA255_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA255_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA254_LUT1A]
set_property LOC SLICE_X164Y272 [get_cells gtze2_inf_north/RXDATA254_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA254_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA254_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA254_LUT1B]
set_property LOC SLICE_X164Y272 [get_cells gtze2_inf_north/RXDATA254_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA254_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA254_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA254_FD]
set_property LOC SLICE_X165Y272 [get_cells gtze2_inf_north/RXDATA254_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA254_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA253_LUT1A]
set_property LOC SLICE_X164Y272 [get_cells gtze2_inf_north/RXDATA253_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA253_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA253_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA253_LUT1B]
set_property LOC SLICE_X164Y272 [get_cells gtze2_inf_north/RXDATA253_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA253_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA253_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA253_FD]
set_property LOC SLICE_X165Y272 [get_cells gtze2_inf_north/RXDATA253_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA253_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA252_LUT1A]
set_property LOC SLICE_X164Y272 [get_cells gtze2_inf_north/RXDATA252_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA252_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA252_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA252_LUT1B]
set_property LOC SLICE_X164Y272 [get_cells gtze2_inf_north/RXDATA252_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA252_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA252_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA252_FD]
set_property LOC SLICE_X165Y272 [get_cells gtze2_inf_north/RXDATA252_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA252_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA251_LUT1A]
set_property LOC SLICE_X164Y277 [get_cells gtze2_inf_north/RXDATA251_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA251_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA251_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA251_LUT1B]
set_property LOC SLICE_X164Y277 [get_cells gtze2_inf_north/RXDATA251_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA251_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA251_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X165Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA251_FD]
set_property LOC SLICE_X165Y277 [get_cells gtze2_inf_north/RXDATA251_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA251_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA250_LUT1A]
set_property LOC SLICE_X164Y277 [get_cells gtze2_inf_north/RXDATA250_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA250_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA250_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA250_LUT1B]
set_property LOC SLICE_X164Y277 [get_cells gtze2_inf_north/RXDATA250_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA250_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA250_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA250_FD]
set_property LOC SLICE_X165Y277 [get_cells gtze2_inf_north/RXDATA250_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA250_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA249_LUT1A]
set_property LOC SLICE_X164Y277 [get_cells gtze2_inf_north/RXDATA249_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA249_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA249_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA249_LUT1B]
set_property LOC SLICE_X164Y277 [get_cells gtze2_inf_north/RXDATA249_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA249_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA249_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA249_FD]
set_property LOC SLICE_X165Y277 [get_cells gtze2_inf_north/RXDATA249_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA249_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA248_LUT1A]
set_property LOC SLICE_X164Y277 [get_cells gtze2_inf_north/RXDATA248_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA248_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA248_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA248_LUT1B]
set_property LOC SLICE_X164Y277 [get_cells gtze2_inf_north/RXDATA248_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA248_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA248_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X165Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA248_FD]
set_property LOC SLICE_X165Y277 [get_cells gtze2_inf_north/RXDATA248_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA248_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA321_LUT1B]
set_property LOC SLICE_X177Y260 [get_cells gtze2_inf_north/TXDATA321_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA321_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA321_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA321_FD]
set_property LOC SLICE_X177Y260 [get_cells gtze2_inf_north/TXDATA321_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA321_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA320_LUT1B]
set_property LOC SLICE_X177Y260 [get_cells gtze2_inf_north/TXDATA320_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA320_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA320_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA320_FD]
set_property LOC SLICE_X177Y260 [get_cells gtze2_inf_north/TXDATA320_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA320_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA319_LUT1B]
set_property LOC SLICE_X177Y265 [get_cells gtze2_inf_north/TXDATA319_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA319_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA319_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA319_FD]
set_property LOC SLICE_X177Y265 [get_cells gtze2_inf_north/TXDATA319_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA319_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA318_LUT1B]
set_property LOC SLICE_X177Y265 [get_cells gtze2_inf_north/TXDATA318_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA318_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA318_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA318_FD]
set_property LOC SLICE_X177Y265 [get_cells gtze2_inf_north/TXDATA318_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA318_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA317_LUT1B]
set_property LOC SLICE_X177Y265 [get_cells gtze2_inf_north/TXDATA317_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA317_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA317_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA317_FD]
set_property LOC SLICE_X177Y265 [get_cells gtze2_inf_north/TXDATA317_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA317_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA316_LUT1B]
set_property LOC SLICE_X177Y265 [get_cells gtze2_inf_north/TXDATA316_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA316_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA316_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA316_FD]
set_property LOC SLICE_X177Y265 [get_cells gtze2_inf_north/TXDATA316_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA316_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA315_LUT1B]
set_property LOC SLICE_X177Y270 [get_cells gtze2_inf_north/TXDATA315_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA315_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA315_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y270/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA315_FD]
set_property LOC SLICE_X177Y270 [get_cells gtze2_inf_north/TXDATA315_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA315_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/CFGFORCESEUERRB1_LUT1B]
set_property LOC SLICE_X274Y250 [get_cells gtze2_inf_north/CFGFORCESEUERRB1_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/CFGFORCESEUERRB1_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/CFGFORCESEUERRB1_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X274Y250/D5FF]
set_property PROHIBIT true [get_bels SLICE_X274Y250/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/CFGFORCESEUERRB1_FD]
set_property LOC SLICE_X274Y250 [get_cells gtze2_inf_north/CFGFORCESEUERRB1_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/CFGFORCESEUERRB1_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/CFGFORCESEUERRB0_LUT1B]
set_property LOC SLICE_X272Y250 [get_cells gtze2_inf_north/CFGFORCESEUERRB0_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/CFGFORCESEUERRB0_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/CFGFORCESEUERRB0_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X272Y250/D5FF]
set_property PROHIBIT true [get_bels SLICE_X272Y250/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/CFGFORCESEUERRB0_FD]
set_property LOC SLICE_X272Y250 [get_cells gtze2_inf_north/CFGFORCESEUERRB0_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/CFGFORCESEUERRB0_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID14_LUT1A]
set_property LOC SLICE_X139Y277 [get_cells gtze2_inf_north/RXHEADERVALID14_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID14_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID14_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X138Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X138Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X138Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID14_LUT1B]
set_property LOC SLICE_X139Y277 [get_cells gtze2_inf_north/RXHEADERVALID14_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X138Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID14_FD]
set_property LOC SLICE_X138Y277 [get_cells gtze2_inf_north/RXHEADERVALID14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID14_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID13_LUT1A]
set_property LOC SLICE_X141Y277 [get_cells gtze2_inf_north/RXHEADERVALID13_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID13_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID13_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X140Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X140Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X140Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID13_LUT1B]
set_property LOC SLICE_X141Y277 [get_cells gtze2_inf_north/RXHEADERVALID13_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X140Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID13_FD]
set_property LOC SLICE_X140Y277 [get_cells gtze2_inf_north/RXHEADERVALID13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID13_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID12_LUT1A]
set_property LOC SLICE_X143Y277 [get_cells gtze2_inf_north/RXHEADERVALID12_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID12_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID12_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X142Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X142Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X142Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID12_LUT1B]
set_property LOC SLICE_X143Y277 [get_cells gtze2_inf_north/RXHEADERVALID12_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X142Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID12_FD]
set_property LOC SLICE_X142Y277 [get_cells gtze2_inf_north/RXHEADERVALID12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID12_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID11_LUT1A]
set_property LOC SLICE_X145Y277 [get_cells gtze2_inf_north/RXHEADERVALID11_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID11_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID11_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X144Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X144Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X144Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID11_LUT1B]
set_property LOC SLICE_X145Y277 [get_cells gtze2_inf_north/RXHEADERVALID11_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X144Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID11_FD]
set_property LOC SLICE_X144Y277 [get_cells gtze2_inf_north/RXHEADERVALID11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID11_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID10_LUT1A]
set_property LOC SLICE_X147Y277 [get_cells gtze2_inf_north/RXHEADERVALID10_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID10_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID10_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X146Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X146Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X146Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID10_LUT1B]
set_property LOC SLICE_X147Y277 [get_cells gtze2_inf_north/RXHEADERVALID10_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X146Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID10_FD]
set_property LOC SLICE_X146Y277 [get_cells gtze2_inf_north/RXHEADERVALID10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID10_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA058_LUT1B]
set_property LOC SLICE_X103Y255 [get_cells gtze2_inf_north/TXDATA058_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA058_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA058_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA058_FD]
set_property LOC SLICE_X103Y255 [get_cells gtze2_inf_north/TXDATA058_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA058_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA057_LUT1B]
set_property LOC SLICE_X103Y255 [get_cells gtze2_inf_north/TXDATA057_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA057_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA057_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA057_FD]
set_property LOC SLICE_X103Y255 [get_cells gtze2_inf_north/TXDATA057_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA057_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA056_LUT1B]
set_property LOC SLICE_X103Y255 [get_cells gtze2_inf_north/TXDATA056_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA056_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA056_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA056_FD]
set_property LOC SLICE_X103Y255 [get_cells gtze2_inf_north/TXDATA056_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA056_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA055_LUT1B]
set_property LOC SLICE_X103Y260 [get_cells gtze2_inf_north/TXDATA055_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA055_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA055_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X103Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA055_FD]
set_property LOC SLICE_X103Y260 [get_cells gtze2_inf_north/TXDATA055_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA055_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA054_LUT1B]
set_property LOC SLICE_X103Y260 [get_cells gtze2_inf_north/TXDATA054_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA054_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA054_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA054_FD]
set_property LOC SLICE_X103Y260 [get_cells gtze2_inf_north/TXDATA054_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA054_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA053_LUT1B]
set_property LOC SLICE_X103Y260 [get_cells gtze2_inf_north/TXDATA053_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA053_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA053_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA053_FD]
set_property LOC SLICE_X103Y260 [get_cells gtze2_inf_north/TXDATA053_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA053_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA052_LUT1B]
set_property LOC SLICE_X103Y260 [get_cells gtze2_inf_north/TXDATA052_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA052_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA052_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA052_FD]
set_property LOC SLICE_X103Y260 [get_cells gtze2_inf_north/TXDATA052_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA052_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA051_LUT1B]
set_property LOC SLICE_X103Y265 [get_cells gtze2_inf_north/TXDATA051_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA051_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA051_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X103Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA051_FD]
set_property LOC SLICE_X103Y265 [get_cells gtze2_inf_north/TXDATA051_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA051_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA050_LUT1B]
set_property LOC SLICE_X103Y265 [get_cells gtze2_inf_north/TXDATA050_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA050_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA050_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA050_FD]
set_property LOC SLICE_X103Y265 [get_cells gtze2_inf_north/TXDATA050_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA050_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPDI20_LUT1B]
set_property LOC SLICE_X271Y250 [get_cells gtze2_inf_north/DRPDI20_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y250/B5FF]
set_property PROHIBIT true [get_bels SLICE_X271Y250/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDI20_FD]
set_property LOC SLICE_X271Y250 [get_cells gtze2_inf_north/DRPDI20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI20_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDI19_LUT1B]
set_property LOC SLICE_X271Y255 [get_cells gtze2_inf_north/DRPDI19_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI19_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI19_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X271Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDI19_FD]
set_property LOC SLICE_X271Y255 [get_cells gtze2_inf_north/DRPDI19_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI19_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDI18_LUT1B]
set_property LOC SLICE_X271Y255 [get_cells gtze2_inf_north/DRPDI18_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI18_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI18_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPDI18_FD]
set_property LOC SLICE_X271Y255 [get_cells gtze2_inf_north/DRPDI18_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI18_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDI17_LUT1B]
set_property LOC SLICE_X271Y255 [get_cells gtze2_inf_north/DRPDI17_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI17_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI17_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDI17_FD]
set_property LOC SLICE_X271Y255 [get_cells gtze2_inf_north/DRPDI17_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI17_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPDI16_LUT1B]
set_property LOC SLICE_X271Y255 [get_cells gtze2_inf_north/DRPDI16_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI16_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI16_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDI16_FD]
set_property LOC SLICE_X271Y255 [get_cells gtze2_inf_north/DRPDI16_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI16_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDI15_LUT1B]
set_property LOC SLICE_X273Y250 [get_cells gtze2_inf_north/DRPDI15_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI15_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI15_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X273Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDI15_FD]
set_property LOC SLICE_X273Y250 [get_cells gtze2_inf_north/DRPDI15_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI15_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDI14_LUT1B]
set_property LOC SLICE_X273Y250 [get_cells gtze2_inf_north/DRPDI14_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPDI14_FD]
set_property LOC SLICE_X273Y250 [get_cells gtze2_inf_north/DRPDI14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI14_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDI13_LUT1B]
set_property LOC SLICE_X273Y250 [get_cells gtze2_inf_north/DRPDI13_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDI13_FD]
set_property LOC SLICE_X273Y250 [get_cells gtze2_inf_north/DRPDI13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI13_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPDI12_LUT1B]
set_property LOC SLICE_X273Y250 [get_cells gtze2_inf_north/DRPDI12_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDI12_FD]
set_property LOC SLICE_X273Y250 [get_cells gtze2_inf_north/DRPDI12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI12_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDI11_LUT1B]
set_property LOC SLICE_X273Y255 [get_cells gtze2_inf_north/DRPDI11_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X273Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDI11_FD]
set_property LOC SLICE_X273Y255 [get_cells gtze2_inf_north/DRPDI11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI11_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDI10_LUT1B]
set_property LOC SLICE_X273Y255 [get_cells gtze2_inf_north/DRPDI10_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPDI10_FD]
set_property LOC SLICE_X273Y255 [get_cells gtze2_inf_north/DRPDI10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI10_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDI9_LUT1B]
set_property LOC SLICE_X273Y255 [get_cells gtze2_inf_north/DRPDI9_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI9_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI9_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDI9_FD]
set_property LOC SLICE_X273Y255 [get_cells gtze2_inf_north/DRPDI9_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI9_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPDI8_LUT1B]
set_property LOC SLICE_X273Y255 [get_cells gtze2_inf_north/DRPDI8_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI8_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI8_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDI8_FD]
set_property LOC SLICE_X273Y255 [get_cells gtze2_inf_north/DRPDI8_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI8_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDI7_LUT1B]
set_property LOC SLICE_X275Y250 [get_cells gtze2_inf_north/DRPDI7_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI7_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI7_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X275Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDI7_FD]
set_property LOC SLICE_X275Y250 [get_cells gtze2_inf_north/DRPDI7_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI7_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDI6_LUT1B]
set_property LOC SLICE_X275Y250 [get_cells gtze2_inf_north/DRPDI6_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI6_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI6_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPDI6_FD]
set_property LOC SLICE_X275Y250 [get_cells gtze2_inf_north/DRPDI6_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI6_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDI5_LUT1B]
set_property LOC SLICE_X275Y250 [get_cells gtze2_inf_north/DRPDI5_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI5_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI5_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDI5_FD]
set_property LOC SLICE_X275Y250 [get_cells gtze2_inf_north/DRPDI5_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI5_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPDI4_LUT1B]
set_property LOC SLICE_X275Y250 [get_cells gtze2_inf_north/DRPDI4_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI4_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI4_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDI4_FD]
set_property LOC SLICE_X275Y250 [get_cells gtze2_inf_north/DRPDI4_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI4_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDI3_LUT1B]
set_property LOC SLICE_X275Y255 [get_cells gtze2_inf_north/DRPDI3_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI3_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI3_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X275Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDI3_FD]
set_property LOC SLICE_X275Y255 [get_cells gtze2_inf_north/DRPDI3_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI3_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDI2_LUT1B]
set_property LOC SLICE_X275Y255 [get_cells gtze2_inf_north/DRPDI2_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI2_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI2_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPDI2_FD]
set_property LOC SLICE_X275Y255 [get_cells gtze2_inf_north/DRPDI2_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI2_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDI1_LUT1B]
set_property LOC SLICE_X275Y255 [get_cells gtze2_inf_north/DRPDI1_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI1_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI1_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDI1_FD]
set_property LOC SLICE_X275Y255 [get_cells gtze2_inf_north/DRPDI1_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI1_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPDI0_LUT1B]
set_property LOC SLICE_X275Y255 [get_cells gtze2_inf_north/DRPDI0_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI0_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI0_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDI0_FD]
set_property LOC SLICE_X275Y255 [get_cells gtze2_inf_north/DRPDI0_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI0_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA220_LUT1B]
set_property LOC SLICE_X157Y260 [get_cells gtze2_inf_north/TXDATA220_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA220_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA220_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y260/B5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y260/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA220_FD]
set_property LOC SLICE_X157Y260 [get_cells gtze2_inf_north/TXDATA220_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA220_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA219_LUT1B]
set_property LOC SLICE_X157Y265 [get_cells gtze2_inf_north/TXDATA219_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA219_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA219_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA219_FD]
set_property LOC SLICE_X157Y265 [get_cells gtze2_inf_north/TXDATA219_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA219_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA218_LUT1B]
set_property LOC SLICE_X157Y265 [get_cells gtze2_inf_north/TXDATA218_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA218_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA218_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA218_FD]
set_property LOC SLICE_X157Y265 [get_cells gtze2_inf_north/TXDATA218_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA218_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA217_LUT1B]
set_property LOC SLICE_X157Y265 [get_cells gtze2_inf_north/TXDATA217_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA217_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA217_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA217_FD]
set_property LOC SLICE_X157Y265 [get_cells gtze2_inf_north/TXDATA217_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA217_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA216_LUT1B]
set_property LOC SLICE_X157Y265 [get_cells gtze2_inf_north/TXDATA216_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA216_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA216_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA216_FD]
set_property LOC SLICE_X157Y265 [get_cells gtze2_inf_north/TXDATA216_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA216_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA215_LUT1B]
set_property LOC SLICE_X157Y270 [get_cells gtze2_inf_north/TXDATA215_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA215_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA215_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA215_FD]
set_property LOC SLICE_X157Y270 [get_cells gtze2_inf_north/TXDATA215_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA215_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA214_LUT1B]
set_property LOC SLICE_X157Y270 [get_cells gtze2_inf_north/TXDATA214_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA214_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA214_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA214_FD]
set_property LOC SLICE_X157Y270 [get_cells gtze2_inf_north/TXDATA214_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA214_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA213_LUT1B]
set_property LOC SLICE_X157Y270 [get_cells gtze2_inf_north/TXDATA213_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA213_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA213_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA213_FD]
set_property LOC SLICE_X157Y270 [get_cells gtze2_inf_north/TXDATA213_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA213_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA212_LUT1B]
set_property LOC SLICE_X157Y270 [get_cells gtze2_inf_north/TXDATA212_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA212_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA212_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA212_FD]
set_property LOC SLICE_X157Y270 [get_cells gtze2_inf_north/TXDATA212_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA212_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA211_LUT1B]
set_property LOC SLICE_X157Y275 [get_cells gtze2_inf_north/TXDATA211_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA211_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA211_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA211_FD]
set_property LOC SLICE_X157Y275 [get_cells gtze2_inf_north/TXDATA211_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA211_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA210_LUT1B]
set_property LOC SLICE_X157Y275 [get_cells gtze2_inf_north/TXDATA210_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA210_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA210_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA210_FD]
set_property LOC SLICE_X157Y275 [get_cells gtze2_inf_north/TXDATA210_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA210_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA29_LUT1B]
set_property LOC SLICE_X157Y275 [get_cells gtze2_inf_north/TXDATA29_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA29_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA29_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA29_FD]
set_property LOC SLICE_X157Y275 [get_cells gtze2_inf_north/TXDATA29_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA29_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA28_LUT1B]
set_property LOC SLICE_X157Y275 [get_cells gtze2_inf_north/TXDATA28_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA28_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA28_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA28_FD]
set_property LOC SLICE_X157Y275 [get_cells gtze2_inf_north/TXDATA28_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA28_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA27_LUT1B]
set_property LOC SLICE_X157Y280 [get_cells gtze2_inf_north/TXDATA27_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA27_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA27_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA27_FD]
set_property LOC SLICE_X157Y280 [get_cells gtze2_inf_north/TXDATA27_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA27_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA26_LUT1B]
set_property LOC SLICE_X157Y280 [get_cells gtze2_inf_north/TXDATA26_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA26_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA26_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA26_FD]
set_property LOC SLICE_X157Y280 [get_cells gtze2_inf_north/TXDATA26_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA26_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA25_LUT1B]
set_property LOC SLICE_X157Y280 [get_cells gtze2_inf_north/TXDATA25_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA25_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA25_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA25_FD]
set_property LOC SLICE_X157Y280 [get_cells gtze2_inf_north/TXDATA25_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA25_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA24_LUT1B]
set_property LOC SLICE_X157Y280 [get_cells gtze2_inf_north/TXDATA24_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA24_FD]
set_property LOC SLICE_X157Y280 [get_cells gtze2_inf_north/TXDATA24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA24_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA23_LUT1B]
set_property LOC SLICE_X157Y285 [get_cells gtze2_inf_north/TXDATA23_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA23_FD]
set_property LOC SLICE_X157Y285 [get_cells gtze2_inf_north/TXDATA23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA23_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA22_LUT1B]
set_property LOC SLICE_X157Y285 [get_cells gtze2_inf_north/TXDATA22_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA22_FD]
set_property LOC SLICE_X157Y285 [get_cells gtze2_inf_north/TXDATA22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA22_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA21_LUT1B]
set_property LOC SLICE_X157Y285 [get_cells gtze2_inf_north/TXDATA21_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA21_FD]
set_property LOC SLICE_X157Y285 [get_cells gtze2_inf_north/TXDATA21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA21_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA20_LUT1B]
set_property LOC SLICE_X157Y285 [get_cells gtze2_inf_north/TXDATA20_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA20_FD]
set_property LOC SLICE_X157Y285 [get_cells gtze2_inf_north/TXDATA20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA20_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDI31_LUT1B]
set_property LOC SLICE_X269Y250 [get_cells gtze2_inf_north/DRPDI31_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X269Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDI31_FD]
set_property LOC SLICE_X269Y250 [get_cells gtze2_inf_north/DRPDI31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI31_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDI30_LUT1B]
set_property LOC SLICE_X269Y250 [get_cells gtze2_inf_north/DRPDI30_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPDI30_FD]
set_property LOC SLICE_X269Y250 [get_cells gtze2_inf_north/DRPDI30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI30_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDI29_LUT1B]
set_property LOC SLICE_X269Y250 [get_cells gtze2_inf_north/DRPDI29_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI29_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI29_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDI29_FD]
set_property LOC SLICE_X269Y250 [get_cells gtze2_inf_north/DRPDI29_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI29_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPDI28_LUT1B]
set_property LOC SLICE_X269Y250 [get_cells gtze2_inf_north/DRPDI28_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI28_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI28_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDI28_FD]
set_property LOC SLICE_X269Y250 [get_cells gtze2_inf_north/DRPDI28_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI28_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDI27_LUT1B]
set_property LOC SLICE_X269Y255 [get_cells gtze2_inf_north/DRPDI27_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI27_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI27_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X269Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDI27_FD]
set_property LOC SLICE_X269Y255 [get_cells gtze2_inf_north/DRPDI27_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI27_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDI26_LUT1B]
set_property LOC SLICE_X269Y255 [get_cells gtze2_inf_north/DRPDI26_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI26_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI26_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPDI26_FD]
set_property LOC SLICE_X269Y255 [get_cells gtze2_inf_north/DRPDI26_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI26_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDI25_LUT1B]
set_property LOC SLICE_X269Y255 [get_cells gtze2_inf_north/DRPDI25_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI25_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI25_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDI25_FD]
set_property LOC SLICE_X269Y255 [get_cells gtze2_inf_north/DRPDI25_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI25_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPDI24_LUT1B]
set_property LOC SLICE_X269Y255 [get_cells gtze2_inf_north/DRPDI24_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPDI24_FD]
set_property LOC SLICE_X269Y255 [get_cells gtze2_inf_north/DRPDI24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI24_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPDI23_LUT1B]
set_property LOC SLICE_X271Y250 [get_cells gtze2_inf_north/DRPDI23_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPDI23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y250/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/DRPDI23_FD]
set_property LOC SLICE_X271Y250 [get_cells gtze2_inf_north/DRPDI23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI23_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPDI22_LUT1B]
set_property LOC SLICE_X271Y250 [get_cells gtze2_inf_north/DRPDI22_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPDI22_FD]
set_property LOC SLICE_X271Y250 [get_cells gtze2_inf_north/DRPDI22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI22_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPDI21_LUT1B]
set_property LOC SLICE_X271Y250 [get_cells gtze2_inf_north/DRPDI21_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPDI21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPDI21_FD]
set_property LOC SLICE_X271Y250 [get_cells gtze2_inf_north/DRPDI21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPDI21_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA252_LUT1B]
set_property LOC SLICE_X155Y260 [get_cells gtze2_inf_north/TXDATA252_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA252_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA252_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y260/B5FF]
set_property PROHIBIT true [get_bels SLICE_X155Y260/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA252_FD]
set_property LOC SLICE_X155Y260 [get_cells gtze2_inf_north/TXDATA252_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA252_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA251_LUT1B]
set_property LOC SLICE_X155Y265 [get_cells gtze2_inf_north/TXDATA251_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA251_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA251_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X155Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA251_FD]
set_property LOC SLICE_X155Y265 [get_cells gtze2_inf_north/TXDATA251_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA251_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA250_LUT1B]
set_property LOC SLICE_X155Y265 [get_cells gtze2_inf_north/TXDATA250_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA250_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA250_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA250_FD]
set_property LOC SLICE_X155Y265 [get_cells gtze2_inf_north/TXDATA250_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA250_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA249_LUT1B]
set_property LOC SLICE_X155Y265 [get_cells gtze2_inf_north/TXDATA249_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA249_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA249_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA249_FD]
set_property LOC SLICE_X155Y265 [get_cells gtze2_inf_north/TXDATA249_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA249_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA248_LUT1B]
set_property LOC SLICE_X155Y265 [get_cells gtze2_inf_north/TXDATA248_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA248_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA248_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA248_FD]
set_property LOC SLICE_X155Y265 [get_cells gtze2_inf_north/TXDATA248_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA248_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA247_LUT1B]
set_property LOC SLICE_X155Y270 [get_cells gtze2_inf_north/TXDATA247_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA247_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA247_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X155Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA247_FD]
set_property LOC SLICE_X155Y270 [get_cells gtze2_inf_north/TXDATA247_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA247_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA246_LUT1B]
set_property LOC SLICE_X155Y270 [get_cells gtze2_inf_north/TXDATA246_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA246_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA246_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA246_FD]
set_property LOC SLICE_X155Y270 [get_cells gtze2_inf_north/TXDATA246_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA246_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA245_LUT1B]
set_property LOC SLICE_X155Y270 [get_cells gtze2_inf_north/TXDATA245_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA245_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA245_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA245_FD]
set_property LOC SLICE_X155Y270 [get_cells gtze2_inf_north/TXDATA245_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA245_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA244_LUT1B]
set_property LOC SLICE_X155Y270 [get_cells gtze2_inf_north/TXDATA244_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA244_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA244_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA244_FD]
set_property LOC SLICE_X155Y270 [get_cells gtze2_inf_north/TXDATA244_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA244_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA243_LUT1B]
set_property LOC SLICE_X155Y275 [get_cells gtze2_inf_north/TXDATA243_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA243_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA243_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X155Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA243_FD]
set_property LOC SLICE_X155Y275 [get_cells gtze2_inf_north/TXDATA243_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA243_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA242_LUT1B]
set_property LOC SLICE_X155Y275 [get_cells gtze2_inf_north/TXDATA242_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA242_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA242_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA242_FD]
set_property LOC SLICE_X155Y275 [get_cells gtze2_inf_north/TXDATA242_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA242_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA241_LUT1B]
set_property LOC SLICE_X155Y275 [get_cells gtze2_inf_north/TXDATA241_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA241_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA241_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA241_FD]
set_property LOC SLICE_X155Y275 [get_cells gtze2_inf_north/TXDATA241_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA241_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA240_LUT1B]
set_property LOC SLICE_X155Y275 [get_cells gtze2_inf_north/TXDATA240_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA240_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA240_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA240_FD]
set_property LOC SLICE_X155Y275 [get_cells gtze2_inf_north/TXDATA240_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA240_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA239_LUT1B]
set_property LOC SLICE_X155Y280 [get_cells gtze2_inf_north/TXDATA239_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA239_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA239_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X155Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA239_FD]
set_property LOC SLICE_X155Y280 [get_cells gtze2_inf_north/TXDATA239_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA239_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA238_LUT1B]
set_property LOC SLICE_X155Y280 [get_cells gtze2_inf_north/TXDATA238_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA238_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA238_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA238_FD]
set_property LOC SLICE_X155Y280 [get_cells gtze2_inf_north/TXDATA238_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA238_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA237_LUT1B]
set_property LOC SLICE_X155Y280 [get_cells gtze2_inf_north/TXDATA237_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA237_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA237_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA237_FD]
set_property LOC SLICE_X155Y280 [get_cells gtze2_inf_north/TXDATA237_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA237_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA236_LUT1B]
set_property LOC SLICE_X155Y280 [get_cells gtze2_inf_north/TXDATA236_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA236_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA236_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA236_FD]
set_property LOC SLICE_X155Y280 [get_cells gtze2_inf_north/TXDATA236_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA236_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA235_LUT1B]
set_property LOC SLICE_X155Y285 [get_cells gtze2_inf_north/TXDATA235_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA235_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA235_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X155Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA235_FD]
set_property LOC SLICE_X155Y285 [get_cells gtze2_inf_north/TXDATA235_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA235_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA234_LUT1B]
set_property LOC SLICE_X155Y285 [get_cells gtze2_inf_north/TXDATA234_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA234_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA234_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA234_FD]
set_property LOC SLICE_X155Y285 [get_cells gtze2_inf_north/TXDATA234_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA234_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA233_LUT1B]
set_property LOC SLICE_X155Y285 [get_cells gtze2_inf_north/TXDATA233_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA233_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA233_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA233_FD]
set_property LOC SLICE_X155Y285 [get_cells gtze2_inf_north/TXDATA233_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA233_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA232_LUT1B]
set_property LOC SLICE_X155Y285 [get_cells gtze2_inf_north/TXDATA232_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA232_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA232_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA232_FD]
set_property LOC SLICE_X155Y285 [get_cells gtze2_inf_north/TXDATA232_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA232_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA231_LUT1B]
set_property LOC SLICE_X157Y250 [get_cells gtze2_inf_north/TXDATA231_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA231_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA231_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA231_FD]
set_property LOC SLICE_X157Y250 [get_cells gtze2_inf_north/TXDATA231_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA231_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA230_LUT1B]
set_property LOC SLICE_X157Y250 [get_cells gtze2_inf_north/TXDATA230_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA230_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA230_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA230_FD]
set_property LOC SLICE_X157Y250 [get_cells gtze2_inf_north/TXDATA230_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA230_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA229_LUT1B]
set_property LOC SLICE_X157Y250 [get_cells gtze2_inf_north/TXDATA229_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA229_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA229_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA229_FD]
set_property LOC SLICE_X157Y250 [get_cells gtze2_inf_north/TXDATA229_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA229_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA228_LUT1B]
set_property LOC SLICE_X157Y250 [get_cells gtze2_inf_north/TXDATA228_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA228_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA228_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA228_FD]
set_property LOC SLICE_X157Y250 [get_cells gtze2_inf_north/TXDATA228_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA228_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA227_LUT1B]
set_property LOC SLICE_X157Y255 [get_cells gtze2_inf_north/TXDATA227_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA227_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA227_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X157Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA227_FD]
set_property LOC SLICE_X157Y255 [get_cells gtze2_inf_north/TXDATA227_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA227_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA226_LUT1B]
set_property LOC SLICE_X157Y255 [get_cells gtze2_inf_north/TXDATA226_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA226_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA226_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA226_FD]
set_property LOC SLICE_X157Y255 [get_cells gtze2_inf_north/TXDATA226_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA226_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA225_LUT1B]
set_property LOC SLICE_X157Y255 [get_cells gtze2_inf_north/TXDATA225_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA225_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA225_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA225_FD]
set_property LOC SLICE_X157Y255 [get_cells gtze2_inf_north/TXDATA225_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA225_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA224_LUT1B]
set_property LOC SLICE_X157Y255 [get_cells gtze2_inf_north/TXDATA224_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA224_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA224_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA224_FD]
set_property LOC SLICE_X157Y255 [get_cells gtze2_inf_north/TXDATA224_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA224_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA223_LUT1B]
set_property LOC SLICE_X157Y260 [get_cells gtze2_inf_north/TXDATA223_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA223_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA223_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA223_FD]
set_property LOC SLICE_X157Y260 [get_cells gtze2_inf_north/TXDATA223_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA223_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA222_LUT1B]
set_property LOC SLICE_X157Y260 [get_cells gtze2_inf_north/TXDATA222_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA222_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA222_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA222_FD]
set_property LOC SLICE_X157Y260 [get_cells gtze2_inf_north/TXDATA222_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA222_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA221_LUT1B]
set_property LOC SLICE_X157Y260 [get_cells gtze2_inf_north/TXDATA221_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA221_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA221_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X157Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA221_FD]
set_property LOC SLICE_X157Y260 [get_cells gtze2_inf_north/TXDATA221_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA221_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA273_LUT1B]
set_property LOC SLICE_X153Y275 [get_cells gtze2_inf_north/TXDATA273_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA273_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA273_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y275/A5FF]
set_property PROHIBIT true [get_bels SLICE_X153Y275/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA273_FD]
set_property LOC SLICE_X153Y275 [get_cells gtze2_inf_north/TXDATA273_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA273_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA272_LUT1B]
set_property LOC SLICE_X153Y275 [get_cells gtze2_inf_north/TXDATA272_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA272_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA272_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA272_FD]
set_property LOC SLICE_X153Y275 [get_cells gtze2_inf_north/TXDATA272_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA272_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA271_LUT1B]
set_property LOC SLICE_X153Y280 [get_cells gtze2_inf_north/TXDATA271_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA271_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA271_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X153Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA271_FD]
set_property LOC SLICE_X153Y280 [get_cells gtze2_inf_north/TXDATA271_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA271_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA270_LUT1B]
set_property LOC SLICE_X153Y280 [get_cells gtze2_inf_north/TXDATA270_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA270_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA270_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA270_FD]
set_property LOC SLICE_X153Y280 [get_cells gtze2_inf_north/TXDATA270_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA270_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA269_LUT1B]
set_property LOC SLICE_X153Y280 [get_cells gtze2_inf_north/TXDATA269_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA269_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA269_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA269_FD]
set_property LOC SLICE_X153Y280 [get_cells gtze2_inf_north/TXDATA269_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA269_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA268_LUT1B]
set_property LOC SLICE_X153Y280 [get_cells gtze2_inf_north/TXDATA268_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA268_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA268_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA268_FD]
set_property LOC SLICE_X153Y280 [get_cells gtze2_inf_north/TXDATA268_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA268_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA267_LUT1B]
set_property LOC SLICE_X153Y285 [get_cells gtze2_inf_north/TXDATA267_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA267_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA267_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X153Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA267_FD]
set_property LOC SLICE_X153Y285 [get_cells gtze2_inf_north/TXDATA267_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA267_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA266_LUT1B]
set_property LOC SLICE_X153Y285 [get_cells gtze2_inf_north/TXDATA266_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA266_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA266_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA266_FD]
set_property LOC SLICE_X153Y285 [get_cells gtze2_inf_north/TXDATA266_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA266_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA265_LUT1B]
set_property LOC SLICE_X153Y285 [get_cells gtze2_inf_north/TXDATA265_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA265_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA265_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA265_FD]
set_property LOC SLICE_X153Y285 [get_cells gtze2_inf_north/TXDATA265_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA265_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA264_LUT1B]
set_property LOC SLICE_X153Y285 [get_cells gtze2_inf_north/TXDATA264_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA264_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA264_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA264_FD]
set_property LOC SLICE_X153Y285 [get_cells gtze2_inf_north/TXDATA264_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA264_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA263_LUT1B]
set_property LOC SLICE_X155Y250 [get_cells gtze2_inf_north/TXDATA263_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA263_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA263_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X155Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA263_FD]
set_property LOC SLICE_X155Y250 [get_cells gtze2_inf_north/TXDATA263_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA263_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA262_LUT1B]
set_property LOC SLICE_X155Y250 [get_cells gtze2_inf_north/TXDATA262_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA262_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA262_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA262_FD]
set_property LOC SLICE_X155Y250 [get_cells gtze2_inf_north/TXDATA262_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA262_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA261_LUT1B]
set_property LOC SLICE_X155Y250 [get_cells gtze2_inf_north/TXDATA261_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA261_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA261_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA261_FD]
set_property LOC SLICE_X155Y250 [get_cells gtze2_inf_north/TXDATA261_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA261_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA260_LUT1B]
set_property LOC SLICE_X155Y250 [get_cells gtze2_inf_north/TXDATA260_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA260_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA260_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA260_FD]
set_property LOC SLICE_X155Y250 [get_cells gtze2_inf_north/TXDATA260_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA260_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA259_LUT1B]
set_property LOC SLICE_X155Y255 [get_cells gtze2_inf_north/TXDATA259_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA259_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA259_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X155Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA259_FD]
set_property LOC SLICE_X155Y255 [get_cells gtze2_inf_north/TXDATA259_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA259_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA258_LUT1B]
set_property LOC SLICE_X155Y255 [get_cells gtze2_inf_north/TXDATA258_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA258_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA258_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA258_FD]
set_property LOC SLICE_X155Y255 [get_cells gtze2_inf_north/TXDATA258_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA258_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA257_LUT1B]
set_property LOC SLICE_X155Y255 [get_cells gtze2_inf_north/TXDATA257_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA257_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA257_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA257_FD]
set_property LOC SLICE_X155Y255 [get_cells gtze2_inf_north/TXDATA257_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA257_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA256_LUT1B]
set_property LOC SLICE_X155Y255 [get_cells gtze2_inf_north/TXDATA256_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA256_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA256_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA256_FD]
set_property LOC SLICE_X155Y255 [get_cells gtze2_inf_north/TXDATA256_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA256_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA255_LUT1B]
set_property LOC SLICE_X155Y260 [get_cells gtze2_inf_north/TXDATA255_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA255_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA255_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA255_FD]
set_property LOC SLICE_X155Y260 [get_cells gtze2_inf_north/TXDATA255_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA255_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA254_LUT1B]
set_property LOC SLICE_X155Y260 [get_cells gtze2_inf_north/TXDATA254_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA254_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA254_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA254_FD]
set_property LOC SLICE_X155Y260 [get_cells gtze2_inf_north/TXDATA254_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA254_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA253_LUT1B]
set_property LOC SLICE_X155Y260 [get_cells gtze2_inf_north/TXDATA253_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA253_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA253_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X155Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA253_FD]
set_property LOC SLICE_X155Y260 [get_cells gtze2_inf_north/TXDATA253_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA253_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXOUTPUTEN3_LUT1B]
set_property LOC SLICE_X175Y252 [get_cells gtze2_inf_north/TXOUTPUTEN3_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXOUTPUTEN3_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXOUTPUTEN3_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y252/A5FF]
set_property PROHIBIT true [get_bels SLICE_X175Y252/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXOUTPUTEN3_FD]
set_property LOC SLICE_X175Y252 [get_cells gtze2_inf_north/TXOUTPUTEN3_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXOUTPUTEN3_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/NEARLOOPBACKEN1_LUT1B]
set_property LOC SLICE_X137Y252 [get_cells gtze2_inf_north/NEARLOOPBACKEN1_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/NEARLOOPBACKEN1_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/NEARLOOPBACKEN1_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y252/A5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y252/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/NEARLOOPBACKEN1_FD]
set_property LOC SLICE_X137Y252 [get_cells gtze2_inf_north/NEARLOOPBACKEN1_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/NEARLOOPBACKEN1_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/NEARLOOPBACKEN0_LUT1B]
set_property LOC SLICE_X117Y252 [get_cells gtze2_inf_north/NEARLOOPBACKEN0_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/NEARLOOPBACKEN0_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/NEARLOOPBACKEN0_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X117Y252/A5FF]
set_property PROHIBIT true [get_bels SLICE_X117Y252/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/NEARLOOPBACKEN0_FD]
set_property LOC SLICE_X117Y252 [get_cells gtze2_inf_north/NEARLOOPBACKEN0_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/NEARLOOPBACKEN0_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA288_LUT1B]
set_property LOC SLICE_X153Y255 [get_cells gtze2_inf_north/TXDATA288_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA288_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA288_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y255/B5FF]
set_property PROHIBIT true [get_bels SLICE_X153Y255/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA288_FD]
set_property LOC SLICE_X153Y255 [get_cells gtze2_inf_north/TXDATA288_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA288_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA287_LUT1B]
set_property LOC SLICE_X153Y260 [get_cells gtze2_inf_north/TXDATA287_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA287_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA287_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X153Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA287_FD]
set_property LOC SLICE_X153Y260 [get_cells gtze2_inf_north/TXDATA287_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA287_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA286_LUT1B]
set_property LOC SLICE_X153Y260 [get_cells gtze2_inf_north/TXDATA286_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA286_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA286_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA286_FD]
set_property LOC SLICE_X153Y260 [get_cells gtze2_inf_north/TXDATA286_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA286_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA285_LUT1B]
set_property LOC SLICE_X153Y260 [get_cells gtze2_inf_north/TXDATA285_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA285_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA285_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA285_FD]
set_property LOC SLICE_X153Y260 [get_cells gtze2_inf_north/TXDATA285_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA285_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA284_LUT1B]
set_property LOC SLICE_X153Y260 [get_cells gtze2_inf_north/TXDATA284_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA284_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA284_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA284_FD]
set_property LOC SLICE_X153Y260 [get_cells gtze2_inf_north/TXDATA284_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA284_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA283_LUT1B]
set_property LOC SLICE_X153Y265 [get_cells gtze2_inf_north/TXDATA283_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA283_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA283_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X153Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA283_FD]
set_property LOC SLICE_X153Y265 [get_cells gtze2_inf_north/TXDATA283_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA283_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA282_LUT1B]
set_property LOC SLICE_X153Y265 [get_cells gtze2_inf_north/TXDATA282_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA282_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA282_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA282_FD]
set_property LOC SLICE_X153Y265 [get_cells gtze2_inf_north/TXDATA282_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA282_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA281_LUT1B]
set_property LOC SLICE_X153Y265 [get_cells gtze2_inf_north/TXDATA281_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA281_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA281_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA281_FD]
set_property LOC SLICE_X153Y265 [get_cells gtze2_inf_north/TXDATA281_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA281_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA280_LUT1B]
set_property LOC SLICE_X153Y265 [get_cells gtze2_inf_north/TXDATA280_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA280_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA280_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA280_FD]
set_property LOC SLICE_X153Y265 [get_cells gtze2_inf_north/TXDATA280_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA280_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA279_LUT1B]
set_property LOC SLICE_X153Y270 [get_cells gtze2_inf_north/TXDATA279_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA279_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA279_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X153Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA279_FD]
set_property LOC SLICE_X153Y270 [get_cells gtze2_inf_north/TXDATA279_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA279_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA278_LUT1B]
set_property LOC SLICE_X153Y270 [get_cells gtze2_inf_north/TXDATA278_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA278_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA278_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA278_FD]
set_property LOC SLICE_X153Y270 [get_cells gtze2_inf_north/TXDATA278_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA278_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA277_LUT1B]
set_property LOC SLICE_X153Y270 [get_cells gtze2_inf_north/TXDATA277_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA277_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA277_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA277_FD]
set_property LOC SLICE_X153Y270 [get_cells gtze2_inf_north/TXDATA277_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA277_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA276_LUT1B]
set_property LOC SLICE_X153Y270 [get_cells gtze2_inf_north/TXDATA276_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA276_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA276_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA276_FD]
set_property LOC SLICE_X153Y270 [get_cells gtze2_inf_north/TXDATA276_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA276_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA275_LUT1B]
set_property LOC SLICE_X153Y275 [get_cells gtze2_inf_north/TXDATA275_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA275_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA275_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y275/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA275_FD]
set_property LOC SLICE_X153Y275 [get_cells gtze2_inf_north/TXDATA275_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA275_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA274_LUT1B]
set_property LOC SLICE_X153Y275 [get_cells gtze2_inf_north/TXDATA274_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA274_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA274_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA274_FD]
set_property LOC SLICE_X153Y275 [get_cells gtze2_inf_north/TXDATA274_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA274_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP00_LUT1B]
set_property LOC SLICE_X116Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP00_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP00_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP00_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X116Y290/D5FF]
set_property PROHIBIT true [get_bels SLICE_X116Y290/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/RXGEARBOXSLIP00_FD]
set_property LOC SLICE_X116Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP00_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP00_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER27_LUT1B]
set_property LOC SLICE_X150Y285 [get_cells gtze2_inf_north/TXHEADER27_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER27_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER27_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X150Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X150Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER27_FD]
set_property LOC SLICE_X150Y285 [get_cells gtze2_inf_north/TXHEADER27_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER27_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER26_LUT1B]
set_property LOC SLICE_X150Y280 [get_cells gtze2_inf_north/TXHEADER26_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER26_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER26_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X150Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X150Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER26_FD]
set_property LOC SLICE_X150Y280 [get_cells gtze2_inf_north/TXHEADER26_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER26_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER25_LUT1B]
set_property LOC SLICE_X152Y285 [get_cells gtze2_inf_north/TXHEADER25_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER25_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER25_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X152Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X152Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER25_FD]
set_property LOC SLICE_X152Y285 [get_cells gtze2_inf_north/TXHEADER25_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER25_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER24_LUT1B]
set_property LOC SLICE_X152Y280 [get_cells gtze2_inf_north/TXHEADER24_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X152Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X152Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER24_FD]
set_property LOC SLICE_X152Y280 [get_cells gtze2_inf_north/TXHEADER24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER24_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA271_LUT1A]
set_property LOC SLICE_X162Y292 [get_cells gtze2_inf_north/RXDATA271_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA271_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA271_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA271_LUT1B]
set_property LOC SLICE_X162Y292 [get_cells gtze2_inf_north/RXDATA271_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA271_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA271_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y292/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA271_FD]
set_property LOC SLICE_X163Y292 [get_cells gtze2_inf_north/RXDATA271_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA271_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA270_LUT1A]
set_property LOC SLICE_X162Y292 [get_cells gtze2_inf_north/RXDATA270_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA270_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA270_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA270_LUT1B]
set_property LOC SLICE_X162Y292 [get_cells gtze2_inf_north/RXDATA270_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA270_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA270_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA270_FD]
set_property LOC SLICE_X163Y292 [get_cells gtze2_inf_north/RXDATA270_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA270_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA269_LUT1A]
set_property LOC SLICE_X162Y292 [get_cells gtze2_inf_north/RXDATA269_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA269_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA269_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA269_LUT1B]
set_property LOC SLICE_X162Y292 [get_cells gtze2_inf_north/RXDATA269_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA269_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA269_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA269_FD]
set_property LOC SLICE_X163Y292 [get_cells gtze2_inf_north/RXDATA269_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA269_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER14_LUT1A]
set_property LOC SLICE_X143Y267 [get_cells gtze2_inf_north/RXHEADER14_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER14_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER14_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X142Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X142Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X142Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER14_LUT1B]
set_property LOC SLICE_X143Y267 [get_cells gtze2_inf_north/RXHEADER14_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X142Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER14_FD]
set_property LOC SLICE_X142Y267 [get_cells gtze2_inf_north/RXHEADER14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER14_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER13_LUT1A]
set_property LOC SLICE_X145Y262 [get_cells gtze2_inf_north/RXHEADER13_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER13_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER13_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X144Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X144Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X144Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER13_LUT1B]
set_property LOC SLICE_X145Y262 [get_cells gtze2_inf_north/RXHEADER13_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X144Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER13_FD]
set_property LOC SLICE_X144Y262 [get_cells gtze2_inf_north/RXHEADER13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER13_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER12_LUT1A]
set_property LOC SLICE_X145Y267 [get_cells gtze2_inf_north/RXHEADER12_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER12_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER12_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X144Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X144Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X144Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER12_LUT1B]
set_property LOC SLICE_X145Y267 [get_cells gtze2_inf_north/RXHEADER12_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X144Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER12_FD]
set_property LOC SLICE_X144Y267 [get_cells gtze2_inf_north/RXHEADER12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER12_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER11_LUT1A]
set_property LOC SLICE_X147Y262 [get_cells gtze2_inf_north/RXHEADER11_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER11_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER11_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X146Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X146Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X146Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER11_LUT1B]
set_property LOC SLICE_X147Y262 [get_cells gtze2_inf_north/RXHEADER11_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X146Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER11_FD]
set_property LOC SLICE_X146Y262 [get_cells gtze2_inf_north/RXHEADER11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER11_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER10_LUT1A]
set_property LOC SLICE_X147Y267 [get_cells gtze2_inf_north/RXHEADER10_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER10_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER10_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X146Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X146Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X146Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER10_LUT1B]
set_property LOC SLICE_X147Y267 [get_cells gtze2_inf_north/RXHEADER10_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X146Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER10_FD]
set_property LOC SLICE_X146Y267 [get_cells gtze2_inf_north/RXHEADER10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER10_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE16_LUT1B]
set_property LOC SLICE_X128Y265 [get_cells gtze2_inf_north/TXSEQUENCE16_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE16_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE16_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X128Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X128Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE16_FD]
set_property LOC SLICE_X128Y265 [get_cells gtze2_inf_north/TXSEQUENCE16_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE16_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE15_LUT1B]
set_property LOC SLICE_X130Y265 [get_cells gtze2_inf_north/TXSEQUENCE15_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE15_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE15_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X130Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X130Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE15_FD]
set_property LOC SLICE_X130Y265 [get_cells gtze2_inf_north/TXSEQUENCE15_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE15_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE14_LUT1B]
set_property LOC SLICE_X132Y265 [get_cells gtze2_inf_north/TXSEQUENCE14_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X132Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X132Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE14_FD]
set_property LOC SLICE_X132Y265 [get_cells gtze2_inf_north/TXSEQUENCE14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE14_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID23_LUT1A]
set_property LOC SLICE_X161Y272 [get_cells gtze2_inf_north/RXDATAVALID23_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID23_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID23_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X160Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X160Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X160Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID23_LUT1B]
set_property LOC SLICE_X161Y272 [get_cells gtze2_inf_north/RXDATAVALID23_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X160Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID23_FD]
set_property LOC SLICE_X160Y272 [get_cells gtze2_inf_north/RXDATAVALID23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID23_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID22_LUT1A]
set_property LOC SLICE_X163Y272 [get_cells gtze2_inf_north/RXDATAVALID22_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID22_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID22_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X162Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X162Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X162Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID22_LUT1B]
set_property LOC SLICE_X163Y272 [get_cells gtze2_inf_north/RXDATAVALID22_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X162Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID22_FD]
set_property LOC SLICE_X162Y272 [get_cells gtze2_inf_north/RXDATAVALID22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID22_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID21_LUT1A]
set_property LOC SLICE_X165Y272 [get_cells gtze2_inf_north/RXDATAVALID21_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID21_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID21_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X164Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X164Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X164Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID21_LUT1B]
set_property LOC SLICE_X165Y272 [get_cells gtze2_inf_north/RXDATAVALID21_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X164Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID21_FD]
set_property LOC SLICE_X164Y272 [get_cells gtze2_inf_north/RXDATAVALID21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID21_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID20_LUT1A]
set_property LOC SLICE_X167Y272 [get_cells gtze2_inf_north/RXDATAVALID20_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID20_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID20_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X166Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X166Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X166Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID20_LUT1B]
set_property LOC SLICE_X167Y272 [get_cells gtze2_inf_north/RXDATAVALID20_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X166Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID20_FD]
set_property LOC SLICE_X166Y272 [get_cells gtze2_inf_north/RXDATAVALID20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID20_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA379_LUT1B]
set_property LOC SLICE_X173Y270 [get_cells gtze2_inf_north/TXDATA379_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA379_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA379_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X173Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA379_FD]
set_property LOC SLICE_X173Y270 [get_cells gtze2_inf_north/TXDATA379_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA379_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA378_LUT1B]
set_property LOC SLICE_X173Y270 [get_cells gtze2_inf_north/TXDATA378_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA378_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA378_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA378_FD]
set_property LOC SLICE_X173Y270 [get_cells gtze2_inf_north/TXDATA378_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA378_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA383_LUT1B]
set_property LOC SLICE_X173Y265 [get_cells gtze2_inf_north/TXDATA383_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA383_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA383_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y265/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA383_FD]
set_property LOC SLICE_X173Y265 [get_cells gtze2_inf_north/TXDATA383_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA383_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA382_LUT1B]
set_property LOC SLICE_X173Y265 [get_cells gtze2_inf_north/TXDATA382_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA382_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA382_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA382_FD]
set_property LOC SLICE_X173Y265 [get_cells gtze2_inf_north/TXDATA382_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA382_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA276_LUT1A]
set_property LOC SLICE_X162Y282 [get_cells gtze2_inf_north/RXDATA276_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA276_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA276_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA276_LUT1B]
set_property LOC SLICE_X162Y282 [get_cells gtze2_inf_north/RXDATA276_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA276_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA276_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA276_FD]
set_property LOC SLICE_X163Y282 [get_cells gtze2_inf_north/RXDATA276_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA276_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA275_LUT1A]
set_property LOC SLICE_X162Y287 [get_cells gtze2_inf_north/RXDATA275_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA275_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA275_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA275_LUT1B]
set_property LOC SLICE_X162Y287 [get_cells gtze2_inf_north/RXDATA275_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA275_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA275_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X163Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA275_FD]
set_property LOC SLICE_X163Y287 [get_cells gtze2_inf_north/RXDATA275_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA275_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA274_LUT1A]
set_property LOC SLICE_X162Y287 [get_cells gtze2_inf_north/RXDATA274_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA274_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA274_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA274_LUT1B]
set_property LOC SLICE_X162Y287 [get_cells gtze2_inf_north/RXDATA274_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA274_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA274_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA274_FD]
set_property LOC SLICE_X163Y287 [get_cells gtze2_inf_north/RXDATA274_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA274_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA273_LUT1A]
set_property LOC SLICE_X162Y287 [get_cells gtze2_inf_north/RXDATA273_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA273_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA273_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA273_LUT1B]
set_property LOC SLICE_X162Y287 [get_cells gtze2_inf_north/RXDATA273_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA273_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA273_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA273_FD]
set_property LOC SLICE_X163Y287 [get_cells gtze2_inf_north/RXDATA273_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA273_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA272_LUT1A]
set_property LOC SLICE_X162Y287 [get_cells gtze2_inf_north/RXDATA272_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA272_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA272_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA272_LUT1B]
set_property LOC SLICE_X162Y287 [get_cells gtze2_inf_north/RXDATA272_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA272_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA272_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X163Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA272_FD]
set_property LOC SLICE_X163Y287 [get_cells gtze2_inf_north/RXDATA272_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA272_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA357_LUT1B]
set_property LOC SLICE_X175Y255 [get_cells gtze2_inf_north/TXDATA357_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA357_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA357_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y255/A5FF]
set_property PROHIBIT true [get_bels SLICE_X175Y255/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA357_FD]
set_property LOC SLICE_X175Y255 [get_cells gtze2_inf_north/TXDATA357_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA357_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA356_LUT1B]
set_property LOC SLICE_X175Y255 [get_cells gtze2_inf_north/TXDATA356_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA356_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA356_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA356_FD]
set_property LOC SLICE_X175Y255 [get_cells gtze2_inf_north/TXDATA356_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA356_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA355_LUT1B]
set_property LOC SLICE_X175Y260 [get_cells gtze2_inf_north/TXDATA355_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA355_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA355_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA355_FD]
set_property LOC SLICE_X175Y260 [get_cells gtze2_inf_north/TXDATA355_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA355_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA354_LUT1B]
set_property LOC SLICE_X175Y260 [get_cells gtze2_inf_north/TXDATA354_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA354_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA354_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA354_FD]
set_property LOC SLICE_X175Y260 [get_cells gtze2_inf_north/TXDATA354_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA354_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA377_LUT1B]
set_property LOC SLICE_X173Y270 [get_cells gtze2_inf_north/TXDATA377_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA377_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA377_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA377_FD]
set_property LOC SLICE_X173Y270 [get_cells gtze2_inf_north/TXDATA377_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA377_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA376_LUT1B]
set_property LOC SLICE_X173Y270 [get_cells gtze2_inf_north/TXDATA376_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA376_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA376_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA376_FD]
set_property LOC SLICE_X173Y270 [get_cells gtze2_inf_north/TXDATA376_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA376_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID03_LUT1A]
set_property LOC SLICE_X121Y272 [get_cells gtze2_inf_north/RXDATAVALID03_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID03_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID03_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X120Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X120Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X120Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID03_LUT1B]
set_property LOC SLICE_X121Y272 [get_cells gtze2_inf_north/RXDATAVALID03_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID03_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID03_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X120Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID03_FD]
set_property LOC SLICE_X120Y272 [get_cells gtze2_inf_north/RXDATAVALID03_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID03_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID02_LUT1A]
set_property LOC SLICE_X123Y272 [get_cells gtze2_inf_north/RXDATAVALID02_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID02_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID02_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X122Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X122Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X122Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID02_LUT1B]
set_property LOC SLICE_X123Y272 [get_cells gtze2_inf_north/RXDATAVALID02_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID02_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID02_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X122Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID02_FD]
set_property LOC SLICE_X122Y272 [get_cells gtze2_inf_north/RXDATAVALID02_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID02_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID01_LUT1A]
set_property LOC SLICE_X125Y272 [get_cells gtze2_inf_north/RXDATAVALID01_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID01_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID01_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X124Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X124Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X124Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID01_LUT1B]
set_property LOC SLICE_X125Y272 [get_cells gtze2_inf_north/RXDATAVALID01_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID01_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID01_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X124Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID01_FD]
set_property LOC SLICE_X124Y272 [get_cells gtze2_inf_north/RXDATAVALID01_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID01_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID00_LUT1A]
set_property LOC SLICE_X127Y272 [get_cells gtze2_inf_north/RXDATAVALID00_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID00_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID00_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X126Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X126Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X126Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID00_LUT1B]
set_property LOC SLICE_X127Y272 [get_cells gtze2_inf_north/RXDATAVALID00_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID00_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID00_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X126Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID00_FD]
set_property LOC SLICE_X126Y272 [get_cells gtze2_inf_north/RXDATAVALID00_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID00_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXOUTPUTEN1_LUT1B]
set_property LOC SLICE_X135Y252 [get_cells gtze2_inf_north/TXOUTPUTEN1_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXOUTPUTEN1_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXOUTPUTEN1_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X135Y252/A5FF]
set_property PROHIBIT true [get_bels SLICE_X135Y252/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXOUTPUTEN1_FD]
set_property LOC SLICE_X135Y252 [get_cells gtze2_inf_north/TXOUTPUTEN1_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXOUTPUTEN1_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA371_LUT1B]
set_property LOC SLICE_X173Y280 [get_cells gtze2_inf_north/TXDATA371_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA371_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA371_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X173Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA371_FD]
set_property LOC SLICE_X173Y280 [get_cells gtze2_inf_north/TXDATA371_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA371_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA370_LUT1B]
set_property LOC SLICE_X173Y280 [get_cells gtze2_inf_north/TXDATA370_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA370_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA370_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA370_FD]
set_property LOC SLICE_X173Y280 [get_cells gtze2_inf_north/TXDATA370_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA370_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA361_LUT1B]
set_property LOC SLICE_X175Y250 [get_cells gtze2_inf_north/TXDATA361_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA361_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA361_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y250/A5FF]
set_property PROHIBIT true [get_bels SLICE_X175Y250/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA361_FD]
set_property LOC SLICE_X175Y250 [get_cells gtze2_inf_north/TXDATA361_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA361_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA360_LUT1B]
set_property LOC SLICE_X175Y250 [get_cells gtze2_inf_north/TXDATA360_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA360_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA360_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA360_FD]
set_property LOC SLICE_X175Y250 [get_cells gtze2_inf_north/TXDATA360_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA360_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA359_LUT1B]
set_property LOC SLICE_X175Y255 [get_cells gtze2_inf_north/TXDATA359_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA359_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA359_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y255/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA359_FD]
set_property LOC SLICE_X175Y255 [get_cells gtze2_inf_north/TXDATA359_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA359_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA358_LUT1B]
set_property LOC SLICE_X175Y255 [get_cells gtze2_inf_north/TXDATA358_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA358_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA358_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA358_FD]
set_property LOC SLICE_X175Y255 [get_cells gtze2_inf_north/TXDATA358_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA358_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2102_LUT1B]
set_property LOC SLICE_X151Y280 [get_cells gtze2_inf_north/TXDATA2102_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2102_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2102_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X151Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2102_FD]
set_property LOC SLICE_X151Y280 [get_cells gtze2_inf_north/TXDATA2102_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2102_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2101_LUT1B]
set_property LOC SLICE_X151Y280 [get_cells gtze2_inf_north/TXDATA2101_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2101_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2101_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2101_FD]
set_property LOC SLICE_X151Y280 [get_cells gtze2_inf_north/TXDATA2101_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2101_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2100_LUT1B]
set_property LOC SLICE_X151Y280 [get_cells gtze2_inf_north/TXDATA2100_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2100_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2100_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2100_FD]
set_property LOC SLICE_X151Y280 [get_cells gtze2_inf_north/TXDATA2100_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2100_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA299_LUT1B]
set_property LOC SLICE_X151Y285 [get_cells gtze2_inf_north/TXDATA299_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA299_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA299_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X151Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA299_FD]
set_property LOC SLICE_X151Y285 [get_cells gtze2_inf_north/TXDATA299_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA299_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA298_LUT1B]
set_property LOC SLICE_X151Y285 [get_cells gtze2_inf_north/TXDATA298_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA298_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA298_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA298_FD]
set_property LOC SLICE_X151Y285 [get_cells gtze2_inf_north/TXDATA298_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA298_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA297_LUT1B]
set_property LOC SLICE_X151Y285 [get_cells gtze2_inf_north/TXDATA297_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA297_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA297_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA297_FD]
set_property LOC SLICE_X151Y285 [get_cells gtze2_inf_north/TXDATA297_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA297_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA296_LUT1B]
set_property LOC SLICE_X151Y285 [get_cells gtze2_inf_north/TXDATA296_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA296_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA296_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA296_FD]
set_property LOC SLICE_X151Y285 [get_cells gtze2_inf_north/TXDATA296_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA296_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA295_LUT1B]
set_property LOC SLICE_X153Y250 [get_cells gtze2_inf_north/TXDATA295_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA295_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA295_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X153Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA295_FD]
set_property LOC SLICE_X153Y250 [get_cells gtze2_inf_north/TXDATA295_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA295_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA294_LUT1B]
set_property LOC SLICE_X153Y250 [get_cells gtze2_inf_north/TXDATA294_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA294_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA294_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA294_FD]
set_property LOC SLICE_X153Y250 [get_cells gtze2_inf_north/TXDATA294_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA294_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA293_LUT1B]
set_property LOC SLICE_X153Y250 [get_cells gtze2_inf_north/TXDATA293_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA293_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA293_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA293_FD]
set_property LOC SLICE_X153Y250 [get_cells gtze2_inf_north/TXDATA293_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA293_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA292_LUT1B]
set_property LOC SLICE_X153Y250 [get_cells gtze2_inf_north/TXDATA292_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA292_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA292_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA292_FD]
set_property LOC SLICE_X153Y250 [get_cells gtze2_inf_north/TXDATA292_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA292_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA291_LUT1B]
set_property LOC SLICE_X153Y255 [get_cells gtze2_inf_north/TXDATA291_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA291_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA291_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y255/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA291_FD]
set_property LOC SLICE_X153Y255 [get_cells gtze2_inf_north/TXDATA291_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA291_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA290_LUT1B]
set_property LOC SLICE_X153Y255 [get_cells gtze2_inf_north/TXDATA290_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA290_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA290_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA290_FD]
set_property LOC SLICE_X153Y255 [get_cells gtze2_inf_north/TXDATA290_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA290_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA289_LUT1B]
set_property LOC SLICE_X153Y255 [get_cells gtze2_inf_north/TXDATA289_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA289_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA289_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X153Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA289_FD]
set_property LOC SLICE_X153Y255 [get_cells gtze2_inf_north/TXDATA289_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA289_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA085_LUT1B]
set_property LOC SLICE_X101Y260 [get_cells gtze2_inf_north/TXDATA085_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA085_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA085_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y260/A5FF]
set_property PROHIBIT true [get_bels SLICE_X101Y260/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA085_FD]
set_property LOC SLICE_X101Y260 [get_cells gtze2_inf_north/TXDATA085_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA085_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA084_LUT1B]
set_property LOC SLICE_X101Y260 [get_cells gtze2_inf_north/TXDATA084_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA084_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA084_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA084_FD]
set_property LOC SLICE_X101Y260 [get_cells gtze2_inf_north/TXDATA084_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA084_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA083_LUT1B]
set_property LOC SLICE_X101Y265 [get_cells gtze2_inf_north/TXDATA083_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA083_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA083_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X101Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA083_FD]
set_property LOC SLICE_X101Y265 [get_cells gtze2_inf_north/TXDATA083_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA083_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA082_LUT1B]
set_property LOC SLICE_X101Y265 [get_cells gtze2_inf_north/TXDATA082_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA082_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA082_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA082_FD]
set_property LOC SLICE_X101Y265 [get_cells gtze2_inf_north/TXDATA082_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA082_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA081_LUT1B]
set_property LOC SLICE_X101Y265 [get_cells gtze2_inf_north/TXDATA081_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA081_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA081_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA081_FD]
set_property LOC SLICE_X101Y265 [get_cells gtze2_inf_north/TXDATA081_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA081_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA080_LUT1B]
set_property LOC SLICE_X101Y265 [get_cells gtze2_inf_north/TXDATA080_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA080_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA080_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA080_FD]
set_property LOC SLICE_X101Y265 [get_cells gtze2_inf_north/TXDATA080_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA080_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA079_LUT1B]
set_property LOC SLICE_X101Y270 [get_cells gtze2_inf_north/TXDATA079_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA079_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA079_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X101Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA079_FD]
set_property LOC SLICE_X101Y270 [get_cells gtze2_inf_north/TXDATA079_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA079_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA078_LUT1B]
set_property LOC SLICE_X101Y270 [get_cells gtze2_inf_north/TXDATA078_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA078_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA078_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA078_FD]
set_property LOC SLICE_X101Y270 [get_cells gtze2_inf_north/TXDATA078_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA078_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA077_LUT1B]
set_property LOC SLICE_X101Y270 [get_cells gtze2_inf_north/TXDATA077_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA077_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA077_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA077_FD]
set_property LOC SLICE_X101Y270 [get_cells gtze2_inf_north/TXDATA077_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA077_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2123_LUT1B]
set_property LOC SLICE_X151Y255 [get_cells gtze2_inf_north/TXDATA2123_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2123_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2123_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X151Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2123_FD]
set_property LOC SLICE_X151Y255 [get_cells gtze2_inf_north/TXDATA2123_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2123_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2122_LUT1B]
set_property LOC SLICE_X151Y255 [get_cells gtze2_inf_north/TXDATA2122_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2122_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2122_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2122_FD]
set_property LOC SLICE_X151Y255 [get_cells gtze2_inf_north/TXDATA2122_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2122_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2121_LUT1B]
set_property LOC SLICE_X151Y255 [get_cells gtze2_inf_north/TXDATA2121_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2121_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2121_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2121_FD]
set_property LOC SLICE_X151Y255 [get_cells gtze2_inf_north/TXDATA2121_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2121_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2120_LUT1B]
set_property LOC SLICE_X151Y255 [get_cells gtze2_inf_north/TXDATA2120_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2120_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2120_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2120_FD]
set_property LOC SLICE_X151Y255 [get_cells gtze2_inf_north/TXDATA2120_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2120_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2119_LUT1B]
set_property LOC SLICE_X151Y260 [get_cells gtze2_inf_north/TXDATA2119_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2119_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2119_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X151Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2119_FD]
set_property LOC SLICE_X151Y260 [get_cells gtze2_inf_north/TXDATA2119_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2119_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2118_LUT1B]
set_property LOC SLICE_X151Y260 [get_cells gtze2_inf_north/TXDATA2118_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2118_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2118_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2118_FD]
set_property LOC SLICE_X151Y260 [get_cells gtze2_inf_north/TXDATA2118_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2118_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2117_LUT1B]
set_property LOC SLICE_X151Y260 [get_cells gtze2_inf_north/TXDATA2117_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2117_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2117_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2117_FD]
set_property LOC SLICE_X151Y260 [get_cells gtze2_inf_north/TXDATA2117_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2117_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2116_LUT1B]
set_property LOC SLICE_X151Y260 [get_cells gtze2_inf_north/TXDATA2116_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2116_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2116_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2116_FD]
set_property LOC SLICE_X151Y260 [get_cells gtze2_inf_north/TXDATA2116_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2116_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2115_LUT1B]
set_property LOC SLICE_X151Y265 [get_cells gtze2_inf_north/TXDATA2115_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2115_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2115_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X151Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2115_FD]
set_property LOC SLICE_X151Y265 [get_cells gtze2_inf_north/TXDATA2115_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2115_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2114_LUT1B]
set_property LOC SLICE_X151Y265 [get_cells gtze2_inf_north/TXDATA2114_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2114_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2114_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2114_FD]
set_property LOC SLICE_X151Y265 [get_cells gtze2_inf_north/TXDATA2114_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2114_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2113_LUT1B]
set_property LOC SLICE_X151Y265 [get_cells gtze2_inf_north/TXDATA2113_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2113_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2113_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2113_FD]
set_property LOC SLICE_X151Y265 [get_cells gtze2_inf_north/TXDATA2113_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2113_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2112_LUT1B]
set_property LOC SLICE_X151Y265 [get_cells gtze2_inf_north/TXDATA2112_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2112_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2112_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2112_FD]
set_property LOC SLICE_X151Y265 [get_cells gtze2_inf_north/TXDATA2112_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2112_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2111_LUT1B]
set_property LOC SLICE_X151Y270 [get_cells gtze2_inf_north/TXDATA2111_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2111_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2111_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X151Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2111_FD]
set_property LOC SLICE_X151Y270 [get_cells gtze2_inf_north/TXDATA2111_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2111_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2110_LUT1B]
set_property LOC SLICE_X151Y270 [get_cells gtze2_inf_north/TXDATA2110_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2110_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2110_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2110_FD]
set_property LOC SLICE_X151Y270 [get_cells gtze2_inf_north/TXDATA2110_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2110_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2109_LUT1B]
set_property LOC SLICE_X151Y270 [get_cells gtze2_inf_north/TXDATA2109_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2109_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2109_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2109_FD]
set_property LOC SLICE_X151Y270 [get_cells gtze2_inf_north/TXDATA2109_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2109_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2108_LUT1B]
set_property LOC SLICE_X151Y270 [get_cells gtze2_inf_north/TXDATA2108_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2108_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2108_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2108_FD]
set_property LOC SLICE_X151Y270 [get_cells gtze2_inf_north/TXDATA2108_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2108_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2107_LUT1B]
set_property LOC SLICE_X151Y275 [get_cells gtze2_inf_north/TXDATA2107_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2107_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2107_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X151Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2107_FD]
set_property LOC SLICE_X151Y275 [get_cells gtze2_inf_north/TXDATA2107_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2107_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2106_LUT1B]
set_property LOC SLICE_X151Y275 [get_cells gtze2_inf_north/TXDATA2106_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2106_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2106_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2106_FD]
set_property LOC SLICE_X151Y275 [get_cells gtze2_inf_north/TXDATA2106_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2106_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2105_LUT1B]
set_property LOC SLICE_X151Y275 [get_cells gtze2_inf_north/TXDATA2105_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2105_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2105_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2105_FD]
set_property LOC SLICE_X151Y275 [get_cells gtze2_inf_north/TXDATA2105_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2105_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2104_LUT1B]
set_property LOC SLICE_X151Y275 [get_cells gtze2_inf_north/TXDATA2104_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2104_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2104_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2104_FD]
set_property LOC SLICE_X151Y275 [get_cells gtze2_inf_north/TXDATA2104_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2104_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2103_LUT1B]
set_property LOC SLICE_X151Y280 [get_cells gtze2_inf_north/TXDATA2103_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2103_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2103_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y280/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2103_FD]
set_property LOC SLICE_X151Y280 [get_cells gtze2_inf_north/TXDATA2103_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2103_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2155_LUT1B]
set_property LOC SLICE_X149Y255 [get_cells gtze2_inf_north/TXDATA2155_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2155_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2155_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X149Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2155_FD]
set_property LOC SLICE_X149Y255 [get_cells gtze2_inf_north/TXDATA2155_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2155_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2154_LUT1B]
set_property LOC SLICE_X149Y255 [get_cells gtze2_inf_north/TXDATA2154_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2154_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2154_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2154_FD]
set_property LOC SLICE_X149Y255 [get_cells gtze2_inf_north/TXDATA2154_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2154_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2153_LUT1B]
set_property LOC SLICE_X149Y255 [get_cells gtze2_inf_north/TXDATA2153_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2153_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2153_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2153_FD]
set_property LOC SLICE_X149Y255 [get_cells gtze2_inf_north/TXDATA2153_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2153_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2152_LUT1B]
set_property LOC SLICE_X149Y255 [get_cells gtze2_inf_north/TXDATA2152_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2152_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2152_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2152_FD]
set_property LOC SLICE_X149Y255 [get_cells gtze2_inf_north/TXDATA2152_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2152_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2151_LUT1B]
set_property LOC SLICE_X149Y260 [get_cells gtze2_inf_north/TXDATA2151_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2151_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2151_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X149Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2151_FD]
set_property LOC SLICE_X149Y260 [get_cells gtze2_inf_north/TXDATA2151_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2151_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2150_LUT1B]
set_property LOC SLICE_X149Y260 [get_cells gtze2_inf_north/TXDATA2150_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2150_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2150_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2150_FD]
set_property LOC SLICE_X149Y260 [get_cells gtze2_inf_north/TXDATA2150_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2150_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2149_LUT1B]
set_property LOC SLICE_X149Y260 [get_cells gtze2_inf_north/TXDATA2149_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2149_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2149_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2149_FD]
set_property LOC SLICE_X149Y260 [get_cells gtze2_inf_north/TXDATA2149_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2149_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2148_LUT1B]
set_property LOC SLICE_X149Y260 [get_cells gtze2_inf_north/TXDATA2148_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2148_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2148_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2148_FD]
set_property LOC SLICE_X149Y260 [get_cells gtze2_inf_north/TXDATA2148_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2148_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2147_LUT1B]
set_property LOC SLICE_X149Y265 [get_cells gtze2_inf_north/TXDATA2147_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2147_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2147_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X149Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2147_FD]
set_property LOC SLICE_X149Y265 [get_cells gtze2_inf_north/TXDATA2147_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2147_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2146_LUT1B]
set_property LOC SLICE_X149Y265 [get_cells gtze2_inf_north/TXDATA2146_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2146_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2146_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2146_FD]
set_property LOC SLICE_X149Y265 [get_cells gtze2_inf_north/TXDATA2146_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2146_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2145_LUT1B]
set_property LOC SLICE_X149Y265 [get_cells gtze2_inf_north/TXDATA2145_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2145_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2145_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2145_FD]
set_property LOC SLICE_X149Y265 [get_cells gtze2_inf_north/TXDATA2145_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2145_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2144_LUT1B]
set_property LOC SLICE_X149Y265 [get_cells gtze2_inf_north/TXDATA2144_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2144_FD]
set_property LOC SLICE_X149Y265 [get_cells gtze2_inf_north/TXDATA2144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2144_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2143_LUT1B]
set_property LOC SLICE_X149Y270 [get_cells gtze2_inf_north/TXDATA2143_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X149Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2143_FD]
set_property LOC SLICE_X149Y270 [get_cells gtze2_inf_north/TXDATA2143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2143_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2142_LUT1B]
set_property LOC SLICE_X149Y270 [get_cells gtze2_inf_north/TXDATA2142_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2142_FD]
set_property LOC SLICE_X149Y270 [get_cells gtze2_inf_north/TXDATA2142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2142_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2141_LUT1B]
set_property LOC SLICE_X149Y270 [get_cells gtze2_inf_north/TXDATA2141_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2141_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2141_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2141_FD]
set_property LOC SLICE_X149Y270 [get_cells gtze2_inf_north/TXDATA2141_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2141_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2140_LUT1B]
set_property LOC SLICE_X149Y270 [get_cells gtze2_inf_north/TXDATA2140_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2140_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2140_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2140_FD]
set_property LOC SLICE_X149Y270 [get_cells gtze2_inf_north/TXDATA2140_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2140_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2139_LUT1B]
set_property LOC SLICE_X149Y275 [get_cells gtze2_inf_north/TXDATA2139_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2139_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2139_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X149Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2139_FD]
set_property LOC SLICE_X149Y275 [get_cells gtze2_inf_north/TXDATA2139_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2139_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2138_LUT1B]
set_property LOC SLICE_X149Y275 [get_cells gtze2_inf_north/TXDATA2138_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2138_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2138_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2138_FD]
set_property LOC SLICE_X149Y275 [get_cells gtze2_inf_north/TXDATA2138_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2138_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2137_LUT1B]
set_property LOC SLICE_X149Y275 [get_cells gtze2_inf_north/TXDATA2137_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2137_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2137_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2137_FD]
set_property LOC SLICE_X149Y275 [get_cells gtze2_inf_north/TXDATA2137_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2137_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2136_LUT1B]
set_property LOC SLICE_X149Y275 [get_cells gtze2_inf_north/TXDATA2136_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2136_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2136_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2136_FD]
set_property LOC SLICE_X149Y275 [get_cells gtze2_inf_north/TXDATA2136_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2136_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2135_LUT1B]
set_property LOC SLICE_X149Y280 [get_cells gtze2_inf_north/TXDATA2135_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2135_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2135_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X149Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2135_FD]
set_property LOC SLICE_X149Y280 [get_cells gtze2_inf_north/TXDATA2135_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2135_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2134_LUT1B]
set_property LOC SLICE_X149Y280 [get_cells gtze2_inf_north/TXDATA2134_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2134_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2134_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2134_FD]
set_property LOC SLICE_X149Y280 [get_cells gtze2_inf_north/TXDATA2134_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2134_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2133_LUT1B]
set_property LOC SLICE_X149Y280 [get_cells gtze2_inf_north/TXDATA2133_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2133_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2133_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2133_FD]
set_property LOC SLICE_X149Y280 [get_cells gtze2_inf_north/TXDATA2133_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2133_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2132_LUT1B]
set_property LOC SLICE_X149Y280 [get_cells gtze2_inf_north/TXDATA2132_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2132_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2132_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2132_FD]
set_property LOC SLICE_X149Y280 [get_cells gtze2_inf_north/TXDATA2132_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2132_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2131_LUT1B]
set_property LOC SLICE_X149Y285 [get_cells gtze2_inf_north/TXDATA2131_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2131_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2131_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X149Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2131_FD]
set_property LOC SLICE_X149Y285 [get_cells gtze2_inf_north/TXDATA2131_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2131_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2130_LUT1B]
set_property LOC SLICE_X149Y285 [get_cells gtze2_inf_north/TXDATA2130_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2130_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2130_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2130_FD]
set_property LOC SLICE_X149Y285 [get_cells gtze2_inf_north/TXDATA2130_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2130_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2129_LUT1B]
set_property LOC SLICE_X149Y285 [get_cells gtze2_inf_north/TXDATA2129_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2129_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2129_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2129_FD]
set_property LOC SLICE_X149Y285 [get_cells gtze2_inf_north/TXDATA2129_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2129_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2128_LUT1B]
set_property LOC SLICE_X149Y285 [get_cells gtze2_inf_north/TXDATA2128_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2128_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2128_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2128_FD]
set_property LOC SLICE_X149Y285 [get_cells gtze2_inf_north/TXDATA2128_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2128_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2127_LUT1B]
set_property LOC SLICE_X151Y250 [get_cells gtze2_inf_north/TXDATA2127_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2127_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2127_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X151Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2127_FD]
set_property LOC SLICE_X151Y250 [get_cells gtze2_inf_north/TXDATA2127_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2127_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2126_LUT1B]
set_property LOC SLICE_X151Y250 [get_cells gtze2_inf_north/TXDATA2126_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2126_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2126_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2126_FD]
set_property LOC SLICE_X151Y250 [get_cells gtze2_inf_north/TXDATA2126_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2126_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2125_LUT1B]
set_property LOC SLICE_X151Y250 [get_cells gtze2_inf_north/TXDATA2125_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2125_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2125_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2125_FD]
set_property LOC SLICE_X151Y250 [get_cells gtze2_inf_north/TXDATA2125_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2125_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2124_LUT1B]
set_property LOC SLICE_X151Y250 [get_cells gtze2_inf_north/TXDATA2124_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2124_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2124_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X151Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2124_FD]
set_property LOC SLICE_X151Y250 [get_cells gtze2_inf_north/TXDATA2124_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2124_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA2159_LUT1B]
set_property LOC SLICE_X149Y250 [get_cells gtze2_inf_north/TXDATA2159_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2159_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2159_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X149Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA2159_FD]
set_property LOC SLICE_X149Y250 [get_cells gtze2_inf_north/TXDATA2159_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2159_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA2158_LUT1B]
set_property LOC SLICE_X149Y250 [get_cells gtze2_inf_north/TXDATA2158_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2158_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2158_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA2158_FD]
set_property LOC SLICE_X149Y250 [get_cells gtze2_inf_north/TXDATA2158_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2158_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA2157_LUT1B]
set_property LOC SLICE_X149Y250 [get_cells gtze2_inf_north/TXDATA2157_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA2157_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2157_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA2157_FD]
set_property LOC SLICE_X149Y250 [get_cells gtze2_inf_north/TXDATA2157_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2157_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA2156_LUT1B]
set_property LOC SLICE_X149Y250 [get_cells gtze2_inf_north/TXDATA2156_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA2156_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2156_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X149Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA2156_FD]
set_property LOC SLICE_X149Y250 [get_cells gtze2_inf_north/TXDATA2156_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA2156_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA320_LUT1A]
set_property LOC SLICE_X186Y272 [get_cells gtze2_inf_north/RXDATA320_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA320_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA320_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA320_LUT1B]
set_property LOC SLICE_X186Y272 [get_cells gtze2_inf_north/RXDATA320_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA320_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA320_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y272/A5FF]
set_property PROHIBIT true [get_bels SLICE_X187Y272/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA320_FD]
set_property LOC SLICE_X187Y272 [get_cells gtze2_inf_north/RXDATA320_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA320_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA319_LUT1A]
set_property LOC SLICE_X186Y277 [get_cells gtze2_inf_north/RXDATA319_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA319_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA319_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA319_LUT1B]
set_property LOC SLICE_X186Y277 [get_cells gtze2_inf_north/RXDATA319_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA319_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA319_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X187Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA319_FD]
set_property LOC SLICE_X187Y277 [get_cells gtze2_inf_north/RXDATA319_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA319_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA318_LUT1A]
set_property LOC SLICE_X186Y277 [get_cells gtze2_inf_north/RXDATA318_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA318_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA318_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA318_LUT1B]
set_property LOC SLICE_X186Y277 [get_cells gtze2_inf_north/RXDATA318_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA318_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA318_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA318_FD]
set_property LOC SLICE_X187Y277 [get_cells gtze2_inf_north/RXDATA318_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA318_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA317_LUT1A]
set_property LOC SLICE_X186Y277 [get_cells gtze2_inf_north/RXDATA317_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA317_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA317_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA317_LUT1B]
set_property LOC SLICE_X186Y277 [get_cells gtze2_inf_north/RXDATA317_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA317_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA317_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA317_FD]
set_property LOC SLICE_X187Y277 [get_cells gtze2_inf_north/RXDATA317_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA317_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA316_LUT1A]
set_property LOC SLICE_X186Y277 [get_cells gtze2_inf_north/RXDATA316_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA316_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA316_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA316_LUT1B]
set_property LOC SLICE_X186Y277 [get_cells gtze2_inf_north/RXDATA316_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA316_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA316_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA316_FD]
set_property LOC SLICE_X187Y277 [get_cells gtze2_inf_north/RXDATA316_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA316_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA315_LUT1A]
set_property LOC SLICE_X186Y282 [get_cells gtze2_inf_north/RXDATA315_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA315_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA315_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA315_LUT1B]
set_property LOC SLICE_X186Y282 [get_cells gtze2_inf_north/RXDATA315_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA315_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA315_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X187Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA315_FD]
set_property LOC SLICE_X187Y282 [get_cells gtze2_inf_north/RXDATA315_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA315_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA314_LUT1A]
set_property LOC SLICE_X186Y282 [get_cells gtze2_inf_north/RXDATA314_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA314_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA314_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA314_LUT1B]
set_property LOC SLICE_X186Y282 [get_cells gtze2_inf_north/RXDATA314_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA314_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA314_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA314_FD]
set_property LOC SLICE_X187Y282 [get_cells gtze2_inf_north/RXDATA314_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA314_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA313_LUT1A]
set_property LOC SLICE_X186Y282 [get_cells gtze2_inf_north/RXDATA313_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA313_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA313_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA313_LUT1B]
set_property LOC SLICE_X186Y282 [get_cells gtze2_inf_north/RXDATA313_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA313_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA313_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA313_FD]
set_property LOC SLICE_X187Y282 [get_cells gtze2_inf_north/RXDATA313_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA313_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA312_LUT1A]
set_property LOC SLICE_X186Y282 [get_cells gtze2_inf_north/RXDATA312_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA312_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA312_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA312_LUT1B]
set_property LOC SLICE_X186Y282 [get_cells gtze2_inf_north/RXDATA312_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA312_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA312_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA312_FD]
set_property LOC SLICE_X187Y282 [get_cells gtze2_inf_north/RXDATA312_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA312_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA311_LUT1A]
set_property LOC SLICE_X186Y287 [get_cells gtze2_inf_north/RXDATA311_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA311_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA311_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA311_LUT1B]
set_property LOC SLICE_X186Y287 [get_cells gtze2_inf_north/RXDATA311_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA311_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA311_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X187Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA311_FD]
set_property LOC SLICE_X187Y287 [get_cells gtze2_inf_north/RXDATA311_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA311_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA310_LUT1A]
set_property LOC SLICE_X186Y287 [get_cells gtze2_inf_north/RXDATA310_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA310_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA310_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA310_LUT1B]
set_property LOC SLICE_X186Y287 [get_cells gtze2_inf_north/RXDATA310_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA310_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA310_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA310_FD]
set_property LOC SLICE_X187Y287 [get_cells gtze2_inf_north/RXDATA310_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA310_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA39_LUT1A]
set_property LOC SLICE_X186Y287 [get_cells gtze2_inf_north/RXDATA39_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA39_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA39_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA39_LUT1B]
set_property LOC SLICE_X186Y287 [get_cells gtze2_inf_north/RXDATA39_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA39_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA39_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA39_FD]
set_property LOC SLICE_X187Y287 [get_cells gtze2_inf_north/RXDATA39_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA39_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA38_LUT1A]
set_property LOC SLICE_X186Y287 [get_cells gtze2_inf_north/RXDATA38_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA38_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA38_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA38_LUT1B]
set_property LOC SLICE_X186Y287 [get_cells gtze2_inf_north/RXDATA38_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA38_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA38_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA38_FD]
set_property LOC SLICE_X187Y287 [get_cells gtze2_inf_north/RXDATA38_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA38_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA37_LUT1A]
set_property LOC SLICE_X186Y292 [get_cells gtze2_inf_north/RXDATA37_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA37_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA37_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA37_LUT1B]
set_property LOC SLICE_X186Y292 [get_cells gtze2_inf_north/RXDATA37_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA37_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA37_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X187Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA37_FD]
set_property LOC SLICE_X187Y292 [get_cells gtze2_inf_north/RXDATA37_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA37_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA36_LUT1A]
set_property LOC SLICE_X186Y292 [get_cells gtze2_inf_north/RXDATA36_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA36_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA36_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA36_LUT1B]
set_property LOC SLICE_X186Y292 [get_cells gtze2_inf_north/RXDATA36_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA36_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA36_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA36_FD]
set_property LOC SLICE_X187Y292 [get_cells gtze2_inf_north/RXDATA36_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA36_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA35_LUT1A]
set_property LOC SLICE_X186Y292 [get_cells gtze2_inf_north/RXDATA35_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA35_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA35_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA35_LUT1B]
set_property LOC SLICE_X186Y292 [get_cells gtze2_inf_north/RXDATA35_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA35_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA35_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA35_FD]
set_property LOC SLICE_X187Y292 [get_cells gtze2_inf_north/RXDATA35_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA35_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA34_LUT1A]
set_property LOC SLICE_X186Y292 [get_cells gtze2_inf_north/RXDATA34_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA34_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA34_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA34_LUT1B]
set_property LOC SLICE_X186Y292 [get_cells gtze2_inf_north/RXDATA34_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA34_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA34_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA34_FD]
set_property LOC SLICE_X187Y292 [get_cells gtze2_inf_north/RXDATA34_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA34_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA33_LUT1A]
set_property LOC SLICE_X186Y297 [get_cells gtze2_inf_north/RXDATA33_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA33_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA33_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA33_LUT1B]
set_property LOC SLICE_X186Y297 [get_cells gtze2_inf_north/RXDATA33_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA33_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA33_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X187Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA33_FD]
set_property LOC SLICE_X187Y297 [get_cells gtze2_inf_north/RXDATA33_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA33_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA32_LUT1A]
set_property LOC SLICE_X186Y297 [get_cells gtze2_inf_north/RXDATA32_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA32_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA32_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA32_LUT1B]
set_property LOC SLICE_X186Y297 [get_cells gtze2_inf_north/RXDATA32_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA32_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA32_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA32_FD]
set_property LOC SLICE_X187Y297 [get_cells gtze2_inf_north/RXDATA32_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA32_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA31_LUT1A]
set_property LOC SLICE_X186Y297 [get_cells gtze2_inf_north/RXDATA31_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA31_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA31_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA31_LUT1B]
set_property LOC SLICE_X186Y297 [get_cells gtze2_inf_north/RXDATA31_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA31_FD]
set_property LOC SLICE_X187Y297 [get_cells gtze2_inf_north/RXDATA31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA31_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA30_LUT1A]
set_property LOC SLICE_X186Y297 [get_cells gtze2_inf_north/RXDATA30_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA30_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA30_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA30_LUT1B]
set_property LOC SLICE_X186Y297 [get_cells gtze2_inf_north/RXDATA30_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA30_FD]
set_property LOC SLICE_X187Y297 [get_cells gtze2_inf_north/RXDATA30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA30_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA352_LUT1A]
set_property LOC SLICE_X184Y272 [get_cells gtze2_inf_north/RXDATA352_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA352_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA352_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA352_LUT1B]
set_property LOC SLICE_X184Y272 [get_cells gtze2_inf_north/RXDATA352_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA352_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA352_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y272/A5FF]
set_property PROHIBIT true [get_bels SLICE_X185Y272/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA352_FD]
set_property LOC SLICE_X185Y272 [get_cells gtze2_inf_north/RXDATA352_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA352_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA351_LUT1A]
set_property LOC SLICE_X184Y277 [get_cells gtze2_inf_north/RXDATA351_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA351_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA351_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA351_LUT1B]
set_property LOC SLICE_X184Y277 [get_cells gtze2_inf_north/RXDATA351_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA351_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA351_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X185Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA351_FD]
set_property LOC SLICE_X185Y277 [get_cells gtze2_inf_north/RXDATA351_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA351_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA350_LUT1A]
set_property LOC SLICE_X184Y277 [get_cells gtze2_inf_north/RXDATA350_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA350_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA350_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA350_LUT1B]
set_property LOC SLICE_X184Y277 [get_cells gtze2_inf_north/RXDATA350_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA350_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA350_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA350_FD]
set_property LOC SLICE_X185Y277 [get_cells gtze2_inf_north/RXDATA350_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA350_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA349_LUT1A]
set_property LOC SLICE_X184Y277 [get_cells gtze2_inf_north/RXDATA349_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA349_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA349_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA349_LUT1B]
set_property LOC SLICE_X184Y277 [get_cells gtze2_inf_north/RXDATA349_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA349_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA349_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA349_FD]
set_property LOC SLICE_X185Y277 [get_cells gtze2_inf_north/RXDATA349_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA349_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA348_LUT1A]
set_property LOC SLICE_X184Y277 [get_cells gtze2_inf_north/RXDATA348_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA348_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA348_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA348_LUT1B]
set_property LOC SLICE_X184Y277 [get_cells gtze2_inf_north/RXDATA348_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA348_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA348_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA348_FD]
set_property LOC SLICE_X185Y277 [get_cells gtze2_inf_north/RXDATA348_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA348_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA347_LUT1A]
set_property LOC SLICE_X184Y282 [get_cells gtze2_inf_north/RXDATA347_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA347_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA347_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA347_LUT1B]
set_property LOC SLICE_X184Y282 [get_cells gtze2_inf_north/RXDATA347_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA347_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA347_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X185Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA347_FD]
set_property LOC SLICE_X185Y282 [get_cells gtze2_inf_north/RXDATA347_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA347_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA346_LUT1A]
set_property LOC SLICE_X184Y282 [get_cells gtze2_inf_north/RXDATA346_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA346_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA346_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA346_LUT1B]
set_property LOC SLICE_X184Y282 [get_cells gtze2_inf_north/RXDATA346_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA346_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA346_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA346_FD]
set_property LOC SLICE_X185Y282 [get_cells gtze2_inf_north/RXDATA346_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA346_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA345_LUT1A]
set_property LOC SLICE_X184Y282 [get_cells gtze2_inf_north/RXDATA345_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA345_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA345_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA345_LUT1B]
set_property LOC SLICE_X184Y282 [get_cells gtze2_inf_north/RXDATA345_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA345_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA345_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA345_FD]
set_property LOC SLICE_X185Y282 [get_cells gtze2_inf_north/RXDATA345_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA345_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA344_LUT1A]
set_property LOC SLICE_X184Y282 [get_cells gtze2_inf_north/RXDATA344_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA344_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA344_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA344_LUT1B]
set_property LOC SLICE_X184Y282 [get_cells gtze2_inf_north/RXDATA344_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA344_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA344_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA344_FD]
set_property LOC SLICE_X185Y282 [get_cells gtze2_inf_north/RXDATA344_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA344_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA343_LUT1A]
set_property LOC SLICE_X184Y287 [get_cells gtze2_inf_north/RXDATA343_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA343_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA343_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA343_LUT1B]
set_property LOC SLICE_X184Y287 [get_cells gtze2_inf_north/RXDATA343_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA343_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA343_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X185Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA343_FD]
set_property LOC SLICE_X185Y287 [get_cells gtze2_inf_north/RXDATA343_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA343_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA342_LUT1A]
set_property LOC SLICE_X184Y287 [get_cells gtze2_inf_north/RXDATA342_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA342_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA342_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA342_LUT1B]
set_property LOC SLICE_X184Y287 [get_cells gtze2_inf_north/RXDATA342_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA342_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA342_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA342_FD]
set_property LOC SLICE_X185Y287 [get_cells gtze2_inf_north/RXDATA342_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA342_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA341_LUT1A]
set_property LOC SLICE_X184Y287 [get_cells gtze2_inf_north/RXDATA341_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA341_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA341_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA341_LUT1B]
set_property LOC SLICE_X184Y287 [get_cells gtze2_inf_north/RXDATA341_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA341_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA341_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA341_FD]
set_property LOC SLICE_X185Y287 [get_cells gtze2_inf_north/RXDATA341_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA341_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA340_LUT1A]
set_property LOC SLICE_X184Y287 [get_cells gtze2_inf_north/RXDATA340_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA340_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA340_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA340_LUT1B]
set_property LOC SLICE_X184Y287 [get_cells gtze2_inf_north/RXDATA340_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA340_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA340_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA340_FD]
set_property LOC SLICE_X185Y287 [get_cells gtze2_inf_north/RXDATA340_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA340_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA339_LUT1A]
set_property LOC SLICE_X184Y292 [get_cells gtze2_inf_north/RXDATA339_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA339_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA339_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA339_LUT1B]
set_property LOC SLICE_X184Y292 [get_cells gtze2_inf_north/RXDATA339_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA339_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA339_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X185Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA339_FD]
set_property LOC SLICE_X185Y292 [get_cells gtze2_inf_north/RXDATA339_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA339_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA338_LUT1A]
set_property LOC SLICE_X184Y292 [get_cells gtze2_inf_north/RXDATA338_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA338_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA338_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA338_LUT1B]
set_property LOC SLICE_X184Y292 [get_cells gtze2_inf_north/RXDATA338_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA338_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA338_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA338_FD]
set_property LOC SLICE_X185Y292 [get_cells gtze2_inf_north/RXDATA338_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA338_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA337_LUT1A]
set_property LOC SLICE_X184Y292 [get_cells gtze2_inf_north/RXDATA337_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA337_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA337_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA337_LUT1B]
set_property LOC SLICE_X184Y292 [get_cells gtze2_inf_north/RXDATA337_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA337_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA337_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA337_FD]
set_property LOC SLICE_X185Y292 [get_cells gtze2_inf_north/RXDATA337_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA337_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA336_LUT1A]
set_property LOC SLICE_X184Y292 [get_cells gtze2_inf_north/RXDATA336_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA336_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA336_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA336_LUT1B]
set_property LOC SLICE_X184Y292 [get_cells gtze2_inf_north/RXDATA336_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA336_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA336_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA336_FD]
set_property LOC SLICE_X185Y292 [get_cells gtze2_inf_north/RXDATA336_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA336_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA335_LUT1A]
set_property LOC SLICE_X184Y297 [get_cells gtze2_inf_north/RXDATA335_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA335_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA335_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA335_LUT1B]
set_property LOC SLICE_X184Y297 [get_cells gtze2_inf_north/RXDATA335_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA335_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA335_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X185Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA335_FD]
set_property LOC SLICE_X185Y297 [get_cells gtze2_inf_north/RXDATA335_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA335_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA334_LUT1A]
set_property LOC SLICE_X184Y297 [get_cells gtze2_inf_north/RXDATA334_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA334_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA334_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA334_LUT1B]
set_property LOC SLICE_X184Y297 [get_cells gtze2_inf_north/RXDATA334_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA334_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA334_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA334_FD]
set_property LOC SLICE_X185Y297 [get_cells gtze2_inf_north/RXDATA334_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA334_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA333_LUT1A]
set_property LOC SLICE_X184Y297 [get_cells gtze2_inf_north/RXDATA333_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA333_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA333_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA333_LUT1B]
set_property LOC SLICE_X184Y297 [get_cells gtze2_inf_north/RXDATA333_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA333_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA333_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA333_FD]
set_property LOC SLICE_X185Y297 [get_cells gtze2_inf_north/RXDATA333_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA333_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA332_LUT1A]
set_property LOC SLICE_X184Y297 [get_cells gtze2_inf_north/RXDATA332_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA332_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA332_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA332_LUT1B]
set_property LOC SLICE_X184Y297 [get_cells gtze2_inf_north/RXDATA332_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA332_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA332_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA332_FD]
set_property LOC SLICE_X185Y297 [get_cells gtze2_inf_north/RXDATA332_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA332_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA331_LUT1A]
set_property LOC SLICE_X186Y262 [get_cells gtze2_inf_north/RXDATA331_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA331_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA331_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA331_LUT1B]
set_property LOC SLICE_X186Y262 [get_cells gtze2_inf_north/RXDATA331_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA331_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA331_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X187Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA331_FD]
set_property LOC SLICE_X187Y262 [get_cells gtze2_inf_north/RXDATA331_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA331_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA330_LUT1A]
set_property LOC SLICE_X186Y262 [get_cells gtze2_inf_north/RXDATA330_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA330_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA330_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA330_LUT1B]
set_property LOC SLICE_X186Y262 [get_cells gtze2_inf_north/RXDATA330_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA330_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA330_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA330_FD]
set_property LOC SLICE_X187Y262 [get_cells gtze2_inf_north/RXDATA330_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA330_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA329_LUT1A]
set_property LOC SLICE_X186Y262 [get_cells gtze2_inf_north/RXDATA329_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA329_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA329_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA329_LUT1B]
set_property LOC SLICE_X186Y262 [get_cells gtze2_inf_north/RXDATA329_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA329_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA329_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA329_FD]
set_property LOC SLICE_X187Y262 [get_cells gtze2_inf_north/RXDATA329_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA329_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA328_LUT1A]
set_property LOC SLICE_X186Y262 [get_cells gtze2_inf_north/RXDATA328_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA328_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA328_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA328_LUT1B]
set_property LOC SLICE_X186Y262 [get_cells gtze2_inf_north/RXDATA328_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA328_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA328_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA328_FD]
set_property LOC SLICE_X187Y262 [get_cells gtze2_inf_north/RXDATA328_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA328_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA327_LUT1A]
set_property LOC SLICE_X186Y267 [get_cells gtze2_inf_north/RXDATA327_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA327_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA327_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA327_LUT1B]
set_property LOC SLICE_X186Y267 [get_cells gtze2_inf_north/RXDATA327_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA327_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA327_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X187Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA327_FD]
set_property LOC SLICE_X187Y267 [get_cells gtze2_inf_north/RXDATA327_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA327_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA326_LUT1A]
set_property LOC SLICE_X186Y267 [get_cells gtze2_inf_north/RXDATA326_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA326_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA326_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA326_LUT1B]
set_property LOC SLICE_X186Y267 [get_cells gtze2_inf_north/RXDATA326_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA326_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA326_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA326_FD]
set_property LOC SLICE_X187Y267 [get_cells gtze2_inf_north/RXDATA326_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA326_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA325_LUT1A]
set_property LOC SLICE_X186Y267 [get_cells gtze2_inf_north/RXDATA325_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA325_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA325_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA325_LUT1B]
set_property LOC SLICE_X186Y267 [get_cells gtze2_inf_north/RXDATA325_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA325_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA325_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA325_FD]
set_property LOC SLICE_X187Y267 [get_cells gtze2_inf_north/RXDATA325_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA325_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA324_LUT1A]
set_property LOC SLICE_X186Y267 [get_cells gtze2_inf_north/RXDATA324_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA324_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA324_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA324_LUT1B]
set_property LOC SLICE_X186Y267 [get_cells gtze2_inf_north/RXDATA324_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA324_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA324_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA324_FD]
set_property LOC SLICE_X187Y267 [get_cells gtze2_inf_north/RXDATA324_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA324_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA323_LUT1A]
set_property LOC SLICE_X186Y272 [get_cells gtze2_inf_north/RXDATA323_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA323_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA323_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA323_LUT1B]
set_property LOC SLICE_X186Y272 [get_cells gtze2_inf_north/RXDATA323_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA323_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA323_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA323_FD]
set_property LOC SLICE_X187Y272 [get_cells gtze2_inf_north/RXDATA323_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA323_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA322_LUT1A]
set_property LOC SLICE_X186Y272 [get_cells gtze2_inf_north/RXDATA322_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA322_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA322_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA322_LUT1B]
set_property LOC SLICE_X186Y272 [get_cells gtze2_inf_north/RXDATA322_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA322_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA322_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA322_FD]
set_property LOC SLICE_X187Y272 [get_cells gtze2_inf_north/RXDATA322_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA322_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA321_LUT1A]
set_property LOC SLICE_X186Y272 [get_cells gtze2_inf_north/RXDATA321_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA321_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA321_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA321_LUT1B]
set_property LOC SLICE_X186Y272 [get_cells gtze2_inf_north/RXDATA321_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA321_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA321_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X187Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA321_FD]
set_property LOC SLICE_X187Y272 [get_cells gtze2_inf_north/RXDATA321_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA321_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0118_LUT1B]
set_property LOC SLICE_X99Y260 [get_cells gtze2_inf_north/TXDATA0118_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0118_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0118_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X99Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0118_FD]
set_property LOC SLICE_X99Y260 [get_cells gtze2_inf_north/TXDATA0118_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0118_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0117_LUT1B]
set_property LOC SLICE_X99Y260 [get_cells gtze2_inf_north/TXDATA0117_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0117_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0117_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0117_FD]
set_property LOC SLICE_X99Y260 [get_cells gtze2_inf_north/TXDATA0117_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0117_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0116_LUT1B]
set_property LOC SLICE_X99Y260 [get_cells gtze2_inf_north/TXDATA0116_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0116_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0116_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0116_FD]
set_property LOC SLICE_X99Y260 [get_cells gtze2_inf_north/TXDATA0116_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0116_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0121_LUT1B]
set_property LOC SLICE_X99Y255 [get_cells gtze2_inf_north/TXDATA0121_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0121_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0121_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y255/A5FF]
set_property PROHIBIT true [get_bels SLICE_X99Y255/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0121_FD]
set_property LOC SLICE_X99Y255 [get_cells gtze2_inf_north/TXDATA0121_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0121_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0120_LUT1B]
set_property LOC SLICE_X99Y255 [get_cells gtze2_inf_north/TXDATA0120_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0120_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0120_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0120_FD]
set_property LOC SLICE_X99Y255 [get_cells gtze2_inf_north/TXDATA0120_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0120_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0119_LUT1B]
set_property LOC SLICE_X99Y260 [get_cells gtze2_inf_north/TXDATA0119_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0119_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0119_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0119_FD]
set_property LOC SLICE_X99Y260 [get_cells gtze2_inf_north/TXDATA0119_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0119_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA360_LUT1A]
set_property LOC SLICE_X184Y262 [get_cells gtze2_inf_north/RXDATA360_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA360_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA360_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA360_LUT1B]
set_property LOC SLICE_X184Y262 [get_cells gtze2_inf_north/RXDATA360_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA360_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA360_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA360_FD]
set_property LOC SLICE_X185Y262 [get_cells gtze2_inf_north/RXDATA360_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA360_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA359_LUT1A]
set_property LOC SLICE_X184Y267 [get_cells gtze2_inf_north/RXDATA359_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA359_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA359_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA359_LUT1B]
set_property LOC SLICE_X184Y267 [get_cells gtze2_inf_north/RXDATA359_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA359_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA359_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X185Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA359_FD]
set_property LOC SLICE_X185Y267 [get_cells gtze2_inf_north/RXDATA359_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA359_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA358_LUT1A]
set_property LOC SLICE_X184Y267 [get_cells gtze2_inf_north/RXDATA358_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA358_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA358_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA358_LUT1B]
set_property LOC SLICE_X184Y267 [get_cells gtze2_inf_north/RXDATA358_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA358_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA358_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA358_FD]
set_property LOC SLICE_X185Y267 [get_cells gtze2_inf_north/RXDATA358_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA358_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA357_LUT1A]
set_property LOC SLICE_X184Y267 [get_cells gtze2_inf_north/RXDATA357_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA357_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA357_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA357_LUT1B]
set_property LOC SLICE_X184Y267 [get_cells gtze2_inf_north/RXDATA357_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA357_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA357_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA357_FD]
set_property LOC SLICE_X185Y267 [get_cells gtze2_inf_north/RXDATA357_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA357_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA356_LUT1A]
set_property LOC SLICE_X184Y267 [get_cells gtze2_inf_north/RXDATA356_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA356_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA356_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA356_LUT1B]
set_property LOC SLICE_X184Y267 [get_cells gtze2_inf_north/RXDATA356_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA356_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA356_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA356_FD]
set_property LOC SLICE_X185Y267 [get_cells gtze2_inf_north/RXDATA356_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA356_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA355_LUT1A]
set_property LOC SLICE_X184Y272 [get_cells gtze2_inf_north/RXDATA355_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA355_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA355_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA355_LUT1B]
set_property LOC SLICE_X184Y272 [get_cells gtze2_inf_north/RXDATA355_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA355_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA355_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA355_FD]
set_property LOC SLICE_X185Y272 [get_cells gtze2_inf_north/RXDATA355_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA355_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA354_LUT1A]
set_property LOC SLICE_X184Y272 [get_cells gtze2_inf_north/RXDATA354_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA354_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA354_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA354_LUT1B]
set_property LOC SLICE_X184Y272 [get_cells gtze2_inf_north/RXDATA354_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA354_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA354_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA354_FD]
set_property LOC SLICE_X185Y272 [get_cells gtze2_inf_north/RXDATA354_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA354_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA353_LUT1A]
set_property LOC SLICE_X184Y272 [get_cells gtze2_inf_north/RXDATA353_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA353_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA353_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA353_LUT1B]
set_property LOC SLICE_X184Y272 [get_cells gtze2_inf_north/RXDATA353_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA353_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA353_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X185Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA353_FD]
set_property LOC SLICE_X185Y272 [get_cells gtze2_inf_north/RXDATA353_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA353_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA094_LUT1B]
set_property LOC SLICE_X101Y250 [get_cells gtze2_inf_north/TXDATA094_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA094_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA094_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y250/D5FF]
set_property PROHIBIT true [get_bels SLICE_X101Y250/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA094_FD]
set_property LOC SLICE_X101Y250 [get_cells gtze2_inf_north/TXDATA094_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA094_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA093_LUT1B]
set_property LOC SLICE_X101Y250 [get_cells gtze2_inf_north/TXDATA093_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA093_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA093_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA093_FD]
set_property LOC SLICE_X101Y250 [get_cells gtze2_inf_north/TXDATA093_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA093_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA092_LUT1B]
set_property LOC SLICE_X101Y250 [get_cells gtze2_inf_north/TXDATA092_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA092_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA092_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA092_FD]
set_property LOC SLICE_X101Y250 [get_cells gtze2_inf_north/TXDATA092_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA092_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA091_LUT1B]
set_property LOC SLICE_X101Y255 [get_cells gtze2_inf_north/TXDATA091_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA091_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA091_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X101Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA091_FD]
set_property LOC SLICE_X101Y255 [get_cells gtze2_inf_north/TXDATA091_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA091_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA090_LUT1B]
set_property LOC SLICE_X101Y255 [get_cells gtze2_inf_north/TXDATA090_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA090_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA090_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA090_FD]
set_property LOC SLICE_X101Y255 [get_cells gtze2_inf_north/TXDATA090_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA090_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA089_LUT1B]
set_property LOC SLICE_X101Y255 [get_cells gtze2_inf_north/TXDATA089_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA089_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA089_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA089_FD]
set_property LOC SLICE_X101Y255 [get_cells gtze2_inf_north/TXDATA089_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA089_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA088_LUT1B]
set_property LOC SLICE_X101Y255 [get_cells gtze2_inf_north/TXDATA088_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA088_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA088_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA088_FD]
set_property LOC SLICE_X101Y255 [get_cells gtze2_inf_north/TXDATA088_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA088_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA087_LUT1B]
set_property LOC SLICE_X101Y260 [get_cells gtze2_inf_north/TXDATA087_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA087_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA087_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA087_FD]
set_property LOC SLICE_X101Y260 [get_cells gtze2_inf_north/TXDATA087_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA087_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA086_LUT1B]
set_property LOC SLICE_X101Y260 [get_cells gtze2_inf_north/TXDATA086_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA086_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA086_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA086_FD]
set_property LOC SLICE_X101Y260 [get_cells gtze2_inf_north/TXDATA086_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA086_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID04_LUT1A]
set_property LOC SLICE_X119Y277 [get_cells gtze2_inf_north/RXHEADERVALID04_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID04_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID04_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X118Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X118Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X118Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID04_LUT1B]
set_property LOC SLICE_X119Y277 [get_cells gtze2_inf_north/RXHEADERVALID04_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID04_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID04_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X118Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID04_FD]
set_property LOC SLICE_X118Y277 [get_cells gtze2_inf_north/RXHEADERVALID04_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID04_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID03_LUT1A]
set_property LOC SLICE_X121Y277 [get_cells gtze2_inf_north/RXHEADERVALID03_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID03_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID03_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X120Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X120Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X120Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID03_LUT1B]
set_property LOC SLICE_X121Y277 [get_cells gtze2_inf_north/RXHEADERVALID03_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID03_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID03_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X120Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID03_FD]
set_property LOC SLICE_X120Y277 [get_cells gtze2_inf_north/RXHEADERVALID03_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID03_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID02_LUT1A]
set_property LOC SLICE_X123Y277 [get_cells gtze2_inf_north/RXHEADERVALID02_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID02_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID02_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X122Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X122Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X122Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID02_LUT1B]
set_property LOC SLICE_X123Y277 [get_cells gtze2_inf_north/RXHEADERVALID02_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID02_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID02_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X122Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID02_FD]
set_property LOC SLICE_X122Y277 [get_cells gtze2_inf_north/RXHEADERVALID02_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID02_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID01_LUT1A]
set_property LOC SLICE_X125Y277 [get_cells gtze2_inf_north/RXHEADERVALID01_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID01_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID01_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X124Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X124Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X124Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID01_LUT1B]
set_property LOC SLICE_X125Y277 [get_cells gtze2_inf_north/RXHEADERVALID01_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID01_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID01_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X124Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID01_FD]
set_property LOC SLICE_X124Y277 [get_cells gtze2_inf_north/RXHEADERVALID01_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID01_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID00_LUT1A]
set_property LOC SLICE_X127Y277 [get_cells gtze2_inf_north/RXHEADERVALID00_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID00_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID00_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X126Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X126Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X126Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID00_LUT1B]
set_property LOC SLICE_X127Y277 [get_cells gtze2_inf_north/RXHEADERVALID00_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID00_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID00_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X126Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID00_FD]
set_property LOC SLICE_X126Y277 [get_cells gtze2_inf_north/RXHEADERVALID00_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID00_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPADDR3_LUT1B]
set_property LOC SLICE_X275Y260 [get_cells gtze2_inf_north/DRPADDR3_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPADDR3_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR3_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X275Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPADDR3_FD]
set_property LOC SLICE_X275Y260 [get_cells gtze2_inf_north/DRPADDR3_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR3_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPADDR2_LUT1B]
set_property LOC SLICE_X275Y260 [get_cells gtze2_inf_north/DRPADDR2_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPADDR2_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR2_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPADDR2_FD]
set_property LOC SLICE_X275Y260 [get_cells gtze2_inf_north/DRPADDR2_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR2_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPADDR1_LUT1B]
set_property LOC SLICE_X275Y260 [get_cells gtze2_inf_north/DRPADDR1_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPADDR1_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR1_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPADDR1_FD]
set_property LOC SLICE_X275Y260 [get_cells gtze2_inf_north/DRPADDR1_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR1_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPADDR0_LUT1B]
set_property LOC SLICE_X275Y260 [get_cells gtze2_inf_north/DRPADDR0_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPADDR0_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR0_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X275Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPADDR0_FD]
set_property LOC SLICE_X275Y260 [get_cells gtze2_inf_north/DRPADDR0_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR0_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER29_LUT1A]
set_property LOC SLICE_X159Y262 [get_cells gtze2_inf_north/RXHEADER29_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER29_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER29_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X158Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X158Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X158Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER29_LUT1B]
set_property LOC SLICE_X159Y262 [get_cells gtze2_inf_north/RXHEADER29_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER29_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER29_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X158Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER29_FD]
set_property LOC SLICE_X158Y262 [get_cells gtze2_inf_north/RXHEADER29_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER29_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER28_LUT1A]
set_property LOC SLICE_X159Y267 [get_cells gtze2_inf_north/RXHEADER28_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER28_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER28_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X158Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X158Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X158Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER28_LUT1B]
set_property LOC SLICE_X159Y267 [get_cells gtze2_inf_north/RXHEADER28_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER28_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER28_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X158Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER28_FD]
set_property LOC SLICE_X158Y267 [get_cells gtze2_inf_north/RXHEADER28_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER28_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER27_LUT1A]
set_property LOC SLICE_X161Y262 [get_cells gtze2_inf_north/RXHEADER27_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER27_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER27_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X160Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X160Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X160Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER27_LUT1B]
set_property LOC SLICE_X161Y262 [get_cells gtze2_inf_north/RXHEADER27_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER27_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER27_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X160Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER27_FD]
set_property LOC SLICE_X160Y262 [get_cells gtze2_inf_north/RXHEADER27_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER27_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER26_LUT1A]
set_property LOC SLICE_X161Y267 [get_cells gtze2_inf_north/RXHEADER26_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER26_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER26_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X160Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X160Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X160Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER26_LUT1B]
set_property LOC SLICE_X161Y267 [get_cells gtze2_inf_north/RXHEADER26_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER26_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER26_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X160Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER26_FD]
set_property LOC SLICE_X160Y267 [get_cells gtze2_inf_north/RXHEADER26_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER26_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER25_LUT1A]
set_property LOC SLICE_X163Y262 [get_cells gtze2_inf_north/RXHEADER25_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER25_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER25_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X162Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X162Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X162Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER25_LUT1B]
set_property LOC SLICE_X163Y262 [get_cells gtze2_inf_north/RXHEADER25_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER25_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER25_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X162Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER25_FD]
set_property LOC SLICE_X162Y262 [get_cells gtze2_inf_north/RXHEADER25_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER25_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER24_LUT1A]
set_property LOC SLICE_X163Y267 [get_cells gtze2_inf_north/RXHEADER24_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER24_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER24_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X162Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X162Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X162Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER24_LUT1B]
set_property LOC SLICE_X163Y267 [get_cells gtze2_inf_north/RXHEADER24_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X162Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER24_FD]
set_property LOC SLICE_X162Y267 [get_cells gtze2_inf_north/RXHEADER24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER24_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER23_LUT1A]
set_property LOC SLICE_X165Y262 [get_cells gtze2_inf_north/RXHEADER23_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER23_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER23_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X164Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X164Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X164Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER23_LUT1B]
set_property LOC SLICE_X165Y262 [get_cells gtze2_inf_north/RXHEADER23_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X164Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER23_FD]
set_property LOC SLICE_X164Y262 [get_cells gtze2_inf_north/RXHEADER23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER23_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER22_LUT1A]
set_property LOC SLICE_X165Y267 [get_cells gtze2_inf_north/RXHEADER22_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER22_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER22_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X164Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X164Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X164Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER22_LUT1B]
set_property LOC SLICE_X165Y267 [get_cells gtze2_inf_north/RXHEADER22_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X164Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER22_FD]
set_property LOC SLICE_X164Y267 [get_cells gtze2_inf_north/RXHEADER22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER22_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER21_LUT1A]
set_property LOC SLICE_X167Y262 [get_cells gtze2_inf_north/RXHEADER21_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER21_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER21_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X166Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X166Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X166Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER21_LUT1B]
set_property LOC SLICE_X167Y262 [get_cells gtze2_inf_north/RXHEADER21_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X166Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER21_FD]
set_property LOC SLICE_X166Y262 [get_cells gtze2_inf_north/RXHEADER21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER21_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER20_LUT1A]
set_property LOC SLICE_X167Y267 [get_cells gtze2_inf_north/RXHEADER20_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER20_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER20_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X166Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X166Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X166Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER20_LUT1B]
set_property LOC SLICE_X167Y267 [get_cells gtze2_inf_north/RXHEADER20_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X166Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER20_FD]
set_property LOC SLICE_X166Y267 [get_cells gtze2_inf_north/RXHEADER20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER20_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPADDR15_LUT1B]
set_property LOC SLICE_X269Y260 [get_cells gtze2_inf_north/DRPADDR15_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPADDR15_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR15_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X269Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPADDR15_FD]
set_property LOC SLICE_X269Y260 [get_cells gtze2_inf_north/DRPADDR15_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR15_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPADDR14_LUT1B]
set_property LOC SLICE_X269Y260 [get_cells gtze2_inf_north/DRPADDR14_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPADDR14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPADDR14_FD]
set_property LOC SLICE_X269Y260 [get_cells gtze2_inf_north/DRPADDR14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR14_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPADDR13_LUT1B]
set_property LOC SLICE_X269Y260 [get_cells gtze2_inf_north/DRPADDR13_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPADDR13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPADDR13_FD]
set_property LOC SLICE_X269Y260 [get_cells gtze2_inf_north/DRPADDR13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR13_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPADDR12_LUT1B]
set_property LOC SLICE_X269Y260 [get_cells gtze2_inf_north/DRPADDR12_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPADDR12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X269Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPADDR12_FD]
set_property LOC SLICE_X269Y260 [get_cells gtze2_inf_north/DRPADDR12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR12_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPADDR11_LUT1B]
set_property LOC SLICE_X271Y260 [get_cells gtze2_inf_north/DRPADDR11_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPADDR11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X271Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPADDR11_FD]
set_property LOC SLICE_X271Y260 [get_cells gtze2_inf_north/DRPADDR11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR11_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPADDR10_LUT1B]
set_property LOC SLICE_X271Y260 [get_cells gtze2_inf_north/DRPADDR10_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPADDR10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPADDR10_FD]
set_property LOC SLICE_X271Y260 [get_cells gtze2_inf_north/DRPADDR10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR10_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPADDR9_LUT1B]
set_property LOC SLICE_X271Y260 [get_cells gtze2_inf_north/DRPADDR9_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPADDR9_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR9_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPADDR9_FD]
set_property LOC SLICE_X271Y260 [get_cells gtze2_inf_north/DRPADDR9_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR9_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPADDR8_LUT1B]
set_property LOC SLICE_X271Y260 [get_cells gtze2_inf_north/DRPADDR8_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPADDR8_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR8_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X271Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPADDR8_FD]
set_property LOC SLICE_X271Y260 [get_cells gtze2_inf_north/DRPADDR8_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR8_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/DRPADDR7_LUT1B]
set_property LOC SLICE_X273Y260 [get_cells gtze2_inf_north/DRPADDR7_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPADDR7_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR7_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X273Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/DRPADDR7_FD]
set_property LOC SLICE_X273Y260 [get_cells gtze2_inf_north/DRPADDR7_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR7_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPADDR6_LUT1B]
set_property LOC SLICE_X273Y260 [get_cells gtze2_inf_north/DRPADDR6_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPADDR6_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR6_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/DRPADDR6_FD]
set_property LOC SLICE_X273Y260 [get_cells gtze2_inf_north/DRPADDR6_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR6_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/DRPADDR5_LUT1B]
set_property LOC SLICE_X273Y260 [get_cells gtze2_inf_north/DRPADDR5_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPADDR5_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR5_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/DRPADDR5_FD]
set_property LOC SLICE_X273Y260 [get_cells gtze2_inf_north/DRPADDR5_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR5_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/DRPADDR4_LUT1B]
set_property LOC SLICE_X273Y260 [get_cells gtze2_inf_north/DRPADDR4_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/DRPADDR4_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR4_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X273Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/DRPADDR4_FD]
set_property LOC SLICE_X273Y260 [get_cells gtze2_inf_north/DRPADDR4_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPADDR4_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA113_LUT1A]
set_property LOC SLICE_X146Y282 [get_cells gtze2_inf_north/RXDATA113_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA113_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA113_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA113_LUT1B]
set_property LOC SLICE_X146Y282 [get_cells gtze2_inf_north/RXDATA113_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA113_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA113_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y282/B5FF]
set_property PROHIBIT true [get_bels SLICE_X147Y282/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA113_FD]
set_property LOC SLICE_X147Y282 [get_cells gtze2_inf_north/RXDATA113_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA113_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA112_LUT1A]
set_property LOC SLICE_X146Y282 [get_cells gtze2_inf_north/RXDATA112_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA112_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA112_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA112_LUT1B]
set_property LOC SLICE_X146Y282 [get_cells gtze2_inf_north/RXDATA112_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA112_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA112_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA112_FD]
set_property LOC SLICE_X147Y282 [get_cells gtze2_inf_north/RXDATA112_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA112_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA111_LUT1A]
set_property LOC SLICE_X146Y287 [get_cells gtze2_inf_north/RXDATA111_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA111_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA111_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA111_LUT1B]
set_property LOC SLICE_X146Y287 [get_cells gtze2_inf_north/RXDATA111_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA111_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA111_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X147Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA111_FD]
set_property LOC SLICE_X147Y287 [get_cells gtze2_inf_north/RXDATA111_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA111_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA110_LUT1A]
set_property LOC SLICE_X146Y287 [get_cells gtze2_inf_north/RXDATA110_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA110_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA110_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA110_LUT1B]
set_property LOC SLICE_X146Y287 [get_cells gtze2_inf_north/RXDATA110_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA110_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA110_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA110_FD]
set_property LOC SLICE_X147Y287 [get_cells gtze2_inf_north/RXDATA110_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA110_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA19_LUT1A]
set_property LOC SLICE_X146Y287 [get_cells gtze2_inf_north/RXDATA19_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA19_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA19_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA19_LUT1B]
set_property LOC SLICE_X146Y287 [get_cells gtze2_inf_north/RXDATA19_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA19_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA19_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA19_FD]
set_property LOC SLICE_X147Y287 [get_cells gtze2_inf_north/RXDATA19_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA19_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA18_LUT1A]
set_property LOC SLICE_X146Y287 [get_cells gtze2_inf_north/RXDATA18_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA18_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA18_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA18_LUT1B]
set_property LOC SLICE_X146Y287 [get_cells gtze2_inf_north/RXDATA18_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA18_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA18_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA18_FD]
set_property LOC SLICE_X147Y287 [get_cells gtze2_inf_north/RXDATA18_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA18_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA17_LUT1A]
set_property LOC SLICE_X146Y292 [get_cells gtze2_inf_north/RXDATA17_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA17_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA17_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA17_LUT1B]
set_property LOC SLICE_X146Y292 [get_cells gtze2_inf_north/RXDATA17_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA17_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA17_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X147Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA17_FD]
set_property LOC SLICE_X147Y292 [get_cells gtze2_inf_north/RXDATA17_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA17_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA16_LUT1A]
set_property LOC SLICE_X146Y292 [get_cells gtze2_inf_north/RXDATA16_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA16_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA16_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA16_LUT1B]
set_property LOC SLICE_X146Y292 [get_cells gtze2_inf_north/RXDATA16_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA16_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA16_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA16_FD]
set_property LOC SLICE_X147Y292 [get_cells gtze2_inf_north/RXDATA16_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA16_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA15_LUT1A]
set_property LOC SLICE_X146Y292 [get_cells gtze2_inf_north/RXDATA15_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA15_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA15_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA15_LUT1B]
set_property LOC SLICE_X146Y292 [get_cells gtze2_inf_north/RXDATA15_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA15_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA15_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA15_FD]
set_property LOC SLICE_X147Y292 [get_cells gtze2_inf_north/RXDATA15_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA15_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA14_LUT1A]
set_property LOC SLICE_X146Y292 [get_cells gtze2_inf_north/RXDATA14_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA14_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA14_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA14_LUT1B]
set_property LOC SLICE_X146Y292 [get_cells gtze2_inf_north/RXDATA14_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA14_FD]
set_property LOC SLICE_X147Y292 [get_cells gtze2_inf_north/RXDATA14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA14_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA13_LUT1A]
set_property LOC SLICE_X146Y297 [get_cells gtze2_inf_north/RXDATA13_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA13_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA13_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA13_LUT1B]
set_property LOC SLICE_X146Y297 [get_cells gtze2_inf_north/RXDATA13_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X147Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA13_FD]
set_property LOC SLICE_X147Y297 [get_cells gtze2_inf_north/RXDATA13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA13_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA12_LUT1A]
set_property LOC SLICE_X146Y297 [get_cells gtze2_inf_north/RXDATA12_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA12_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA12_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA12_LUT1B]
set_property LOC SLICE_X146Y297 [get_cells gtze2_inf_north/RXDATA12_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA12_FD]
set_property LOC SLICE_X147Y297 [get_cells gtze2_inf_north/RXDATA12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA12_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA11_LUT1A]
set_property LOC SLICE_X146Y297 [get_cells gtze2_inf_north/RXDATA11_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA11_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA11_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA11_LUT1B]
set_property LOC SLICE_X146Y297 [get_cells gtze2_inf_north/RXDATA11_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA11_FD]
set_property LOC SLICE_X147Y297 [get_cells gtze2_inf_north/RXDATA11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA11_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA10_LUT1A]
set_property LOC SLICE_X146Y297 [get_cells gtze2_inf_north/RXDATA10_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA10_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA10_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA10_LUT1B]
set_property LOC SLICE_X146Y297 [get_cells gtze2_inf_north/RXDATA10_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA10_FD]
set_property LOC SLICE_X147Y297 [get_cells gtze2_inf_north/RXDATA10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA10_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA145_LUT1A]
set_property LOC SLICE_X144Y282 [get_cells gtze2_inf_north/RXDATA145_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA145_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA145_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA145_LUT1B]
set_property LOC SLICE_X144Y282 [get_cells gtze2_inf_north/RXDATA145_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA145_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA145_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y282/B5FF]
set_property PROHIBIT true [get_bels SLICE_X145Y282/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA145_FD]
set_property LOC SLICE_X145Y282 [get_cells gtze2_inf_north/RXDATA145_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA145_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA144_LUT1A]
set_property LOC SLICE_X144Y282 [get_cells gtze2_inf_north/RXDATA144_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA144_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA144_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA144_LUT1B]
set_property LOC SLICE_X144Y282 [get_cells gtze2_inf_north/RXDATA144_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA144_FD]
set_property LOC SLICE_X145Y282 [get_cells gtze2_inf_north/RXDATA144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA144_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA143_LUT1A]
set_property LOC SLICE_X144Y287 [get_cells gtze2_inf_north/RXDATA143_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA143_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA143_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA143_LUT1B]
set_property LOC SLICE_X144Y287 [get_cells gtze2_inf_north/RXDATA143_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X145Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA143_FD]
set_property LOC SLICE_X145Y287 [get_cells gtze2_inf_north/RXDATA143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA143_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA142_LUT1A]
set_property LOC SLICE_X144Y287 [get_cells gtze2_inf_north/RXDATA142_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA142_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA142_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA142_LUT1B]
set_property LOC SLICE_X144Y287 [get_cells gtze2_inf_north/RXDATA142_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA142_FD]
set_property LOC SLICE_X145Y287 [get_cells gtze2_inf_north/RXDATA142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA142_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA141_LUT1A]
set_property LOC SLICE_X144Y287 [get_cells gtze2_inf_north/RXDATA141_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA141_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA141_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA141_LUT1B]
set_property LOC SLICE_X144Y287 [get_cells gtze2_inf_north/RXDATA141_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA141_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA141_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA141_FD]
set_property LOC SLICE_X145Y287 [get_cells gtze2_inf_north/RXDATA141_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA141_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA140_LUT1A]
set_property LOC SLICE_X144Y287 [get_cells gtze2_inf_north/RXDATA140_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA140_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA140_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA140_LUT1B]
set_property LOC SLICE_X144Y287 [get_cells gtze2_inf_north/RXDATA140_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA140_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA140_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA140_FD]
set_property LOC SLICE_X145Y287 [get_cells gtze2_inf_north/RXDATA140_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA140_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA139_LUT1A]
set_property LOC SLICE_X144Y292 [get_cells gtze2_inf_north/RXDATA139_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA139_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA139_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA139_LUT1B]
set_property LOC SLICE_X144Y292 [get_cells gtze2_inf_north/RXDATA139_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA139_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA139_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X145Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA139_FD]
set_property LOC SLICE_X145Y292 [get_cells gtze2_inf_north/RXDATA139_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA139_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA138_LUT1A]
set_property LOC SLICE_X144Y292 [get_cells gtze2_inf_north/RXDATA138_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA138_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA138_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA138_LUT1B]
set_property LOC SLICE_X144Y292 [get_cells gtze2_inf_north/RXDATA138_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA138_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA138_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA138_FD]
set_property LOC SLICE_X145Y292 [get_cells gtze2_inf_north/RXDATA138_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA138_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA137_LUT1A]
set_property LOC SLICE_X144Y292 [get_cells gtze2_inf_north/RXDATA137_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA137_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA137_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA137_LUT1B]
set_property LOC SLICE_X144Y292 [get_cells gtze2_inf_north/RXDATA137_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA137_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA137_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA137_FD]
set_property LOC SLICE_X145Y292 [get_cells gtze2_inf_north/RXDATA137_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA137_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA136_LUT1A]
set_property LOC SLICE_X144Y292 [get_cells gtze2_inf_north/RXDATA136_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA136_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA136_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA136_LUT1B]
set_property LOC SLICE_X144Y292 [get_cells gtze2_inf_north/RXDATA136_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA136_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA136_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA136_FD]
set_property LOC SLICE_X145Y292 [get_cells gtze2_inf_north/RXDATA136_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA136_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA135_LUT1A]
set_property LOC SLICE_X144Y297 [get_cells gtze2_inf_north/RXDATA135_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA135_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA135_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA135_LUT1B]
set_property LOC SLICE_X144Y297 [get_cells gtze2_inf_north/RXDATA135_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA135_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA135_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X145Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA135_FD]
set_property LOC SLICE_X145Y297 [get_cells gtze2_inf_north/RXDATA135_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA135_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA134_LUT1A]
set_property LOC SLICE_X144Y297 [get_cells gtze2_inf_north/RXDATA134_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA134_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA134_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA134_LUT1B]
set_property LOC SLICE_X144Y297 [get_cells gtze2_inf_north/RXDATA134_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA134_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA134_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA134_FD]
set_property LOC SLICE_X145Y297 [get_cells gtze2_inf_north/RXDATA134_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA134_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA133_LUT1A]
set_property LOC SLICE_X144Y297 [get_cells gtze2_inf_north/RXDATA133_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA133_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA133_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA133_LUT1B]
set_property LOC SLICE_X144Y297 [get_cells gtze2_inf_north/RXDATA133_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA133_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA133_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA133_FD]
set_property LOC SLICE_X145Y297 [get_cells gtze2_inf_north/RXDATA133_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA133_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA132_LUT1A]
set_property LOC SLICE_X144Y297 [get_cells gtze2_inf_north/RXDATA132_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA132_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA132_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA132_LUT1B]
set_property LOC SLICE_X144Y297 [get_cells gtze2_inf_north/RXDATA132_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA132_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA132_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA132_FD]
set_property LOC SLICE_X145Y297 [get_cells gtze2_inf_north/RXDATA132_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA132_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA131_LUT1A]
set_property LOC SLICE_X146Y262 [get_cells gtze2_inf_north/RXDATA131_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA131_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA131_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA131_LUT1B]
set_property LOC SLICE_X146Y262 [get_cells gtze2_inf_north/RXDATA131_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA131_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA131_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X147Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA131_FD]
set_property LOC SLICE_X147Y262 [get_cells gtze2_inf_north/RXDATA131_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA131_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA130_LUT1A]
set_property LOC SLICE_X146Y262 [get_cells gtze2_inf_north/RXDATA130_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA130_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA130_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA130_LUT1B]
set_property LOC SLICE_X146Y262 [get_cells gtze2_inf_north/RXDATA130_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA130_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA130_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA130_FD]
set_property LOC SLICE_X147Y262 [get_cells gtze2_inf_north/RXDATA130_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA130_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA129_LUT1A]
set_property LOC SLICE_X146Y262 [get_cells gtze2_inf_north/RXDATA129_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA129_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA129_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA129_LUT1B]
set_property LOC SLICE_X146Y262 [get_cells gtze2_inf_north/RXDATA129_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA129_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA129_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA129_FD]
set_property LOC SLICE_X147Y262 [get_cells gtze2_inf_north/RXDATA129_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA129_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA128_LUT1A]
set_property LOC SLICE_X146Y262 [get_cells gtze2_inf_north/RXDATA128_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA128_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA128_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA128_LUT1B]
set_property LOC SLICE_X146Y262 [get_cells gtze2_inf_north/RXDATA128_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA128_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA128_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA128_FD]
set_property LOC SLICE_X147Y262 [get_cells gtze2_inf_north/RXDATA128_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA128_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA127_LUT1A]
set_property LOC SLICE_X146Y267 [get_cells gtze2_inf_north/RXDATA127_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA127_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA127_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA127_LUT1B]
set_property LOC SLICE_X146Y267 [get_cells gtze2_inf_north/RXDATA127_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA127_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA127_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X147Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA127_FD]
set_property LOC SLICE_X147Y267 [get_cells gtze2_inf_north/RXDATA127_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA127_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA126_LUT1A]
set_property LOC SLICE_X146Y267 [get_cells gtze2_inf_north/RXDATA126_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA126_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA126_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA126_LUT1B]
set_property LOC SLICE_X146Y267 [get_cells gtze2_inf_north/RXDATA126_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA126_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA126_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA126_FD]
set_property LOC SLICE_X147Y267 [get_cells gtze2_inf_north/RXDATA126_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA126_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA125_LUT1A]
set_property LOC SLICE_X146Y267 [get_cells gtze2_inf_north/RXDATA125_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA125_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA125_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA125_LUT1B]
set_property LOC SLICE_X146Y267 [get_cells gtze2_inf_north/RXDATA125_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA125_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA125_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA125_FD]
set_property LOC SLICE_X147Y267 [get_cells gtze2_inf_north/RXDATA125_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA125_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA124_LUT1A]
set_property LOC SLICE_X146Y267 [get_cells gtze2_inf_north/RXDATA124_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA124_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA124_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA124_LUT1B]
set_property LOC SLICE_X146Y267 [get_cells gtze2_inf_north/RXDATA124_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA124_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA124_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA124_FD]
set_property LOC SLICE_X147Y267 [get_cells gtze2_inf_north/RXDATA124_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA124_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA123_LUT1A]
set_property LOC SLICE_X146Y272 [get_cells gtze2_inf_north/RXDATA123_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA123_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA123_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA123_LUT1B]
set_property LOC SLICE_X146Y272 [get_cells gtze2_inf_north/RXDATA123_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA123_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA123_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X147Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA123_FD]
set_property LOC SLICE_X147Y272 [get_cells gtze2_inf_north/RXDATA123_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA123_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA122_LUT1A]
set_property LOC SLICE_X146Y272 [get_cells gtze2_inf_north/RXDATA122_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA122_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA122_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA122_LUT1B]
set_property LOC SLICE_X146Y272 [get_cells gtze2_inf_north/RXDATA122_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA122_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA122_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA122_FD]
set_property LOC SLICE_X147Y272 [get_cells gtze2_inf_north/RXDATA122_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA122_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA121_LUT1A]
set_property LOC SLICE_X146Y272 [get_cells gtze2_inf_north/RXDATA121_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA121_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA121_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA121_LUT1B]
set_property LOC SLICE_X146Y272 [get_cells gtze2_inf_north/RXDATA121_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA121_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA121_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA121_FD]
set_property LOC SLICE_X147Y272 [get_cells gtze2_inf_north/RXDATA121_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA121_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA120_LUT1A]
set_property LOC SLICE_X146Y272 [get_cells gtze2_inf_north/RXDATA120_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA120_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA120_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA120_LUT1B]
set_property LOC SLICE_X146Y272 [get_cells gtze2_inf_north/RXDATA120_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA120_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA120_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA120_FD]
set_property LOC SLICE_X147Y272 [get_cells gtze2_inf_north/RXDATA120_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA120_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA119_LUT1A]
set_property LOC SLICE_X146Y277 [get_cells gtze2_inf_north/RXDATA119_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA119_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA119_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA119_LUT1B]
set_property LOC SLICE_X146Y277 [get_cells gtze2_inf_north/RXDATA119_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA119_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA119_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X147Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA119_FD]
set_property LOC SLICE_X147Y277 [get_cells gtze2_inf_north/RXDATA119_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA119_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA118_LUT1A]
set_property LOC SLICE_X146Y277 [get_cells gtze2_inf_north/RXDATA118_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA118_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA118_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA118_LUT1B]
set_property LOC SLICE_X146Y277 [get_cells gtze2_inf_north/RXDATA118_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA118_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA118_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA118_FD]
set_property LOC SLICE_X147Y277 [get_cells gtze2_inf_north/RXDATA118_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA118_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA117_LUT1A]
set_property LOC SLICE_X146Y277 [get_cells gtze2_inf_north/RXDATA117_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA117_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA117_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA117_LUT1B]
set_property LOC SLICE_X146Y277 [get_cells gtze2_inf_north/RXDATA117_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA117_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA117_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA117_FD]
set_property LOC SLICE_X147Y277 [get_cells gtze2_inf_north/RXDATA117_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA117_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA116_LUT1A]
set_property LOC SLICE_X146Y277 [get_cells gtze2_inf_north/RXDATA116_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA116_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA116_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA116_LUT1B]
set_property LOC SLICE_X146Y277 [get_cells gtze2_inf_north/RXDATA116_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA116_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA116_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA116_FD]
set_property LOC SLICE_X147Y277 [get_cells gtze2_inf_north/RXDATA116_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA116_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA115_LUT1A]
set_property LOC SLICE_X146Y282 [get_cells gtze2_inf_north/RXDATA115_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA115_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA115_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA115_LUT1B]
set_property LOC SLICE_X146Y282 [get_cells gtze2_inf_north/RXDATA115_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA115_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA115_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y282/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA115_FD]
set_property LOC SLICE_X147Y282 [get_cells gtze2_inf_north/RXDATA115_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA115_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA114_LUT1A]
set_property LOC SLICE_X146Y282 [get_cells gtze2_inf_north/RXDATA114_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA114_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA114_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA114_LUT1B]
set_property LOC SLICE_X146Y282 [get_cells gtze2_inf_north/RXDATA114_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA114_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA114_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X147Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA114_FD]
set_property LOC SLICE_X147Y282 [get_cells gtze2_inf_north/RXDATA114_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA114_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA177_LUT1A]
set_property LOC SLICE_X142Y282 [get_cells gtze2_inf_north/RXDATA177_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA177_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA177_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA177_LUT1B]
set_property LOC SLICE_X142Y282 [get_cells gtze2_inf_north/RXDATA177_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA177_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA177_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y282/B5FF]
set_property PROHIBIT true [get_bels SLICE_X143Y282/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA177_FD]
set_property LOC SLICE_X143Y282 [get_cells gtze2_inf_north/RXDATA177_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA177_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA176_LUT1A]
set_property LOC SLICE_X142Y282 [get_cells gtze2_inf_north/RXDATA176_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA176_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA176_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA176_LUT1B]
set_property LOC SLICE_X142Y282 [get_cells gtze2_inf_north/RXDATA176_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA176_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA176_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA176_FD]
set_property LOC SLICE_X143Y282 [get_cells gtze2_inf_north/RXDATA176_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA176_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA175_LUT1A]
set_property LOC SLICE_X142Y287 [get_cells gtze2_inf_north/RXDATA175_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA175_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA175_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA175_LUT1B]
set_property LOC SLICE_X142Y287 [get_cells gtze2_inf_north/RXDATA175_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA175_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA175_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X143Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA175_FD]
set_property LOC SLICE_X143Y287 [get_cells gtze2_inf_north/RXDATA175_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA175_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA174_LUT1A]
set_property LOC SLICE_X142Y287 [get_cells gtze2_inf_north/RXDATA174_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA174_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA174_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA174_LUT1B]
set_property LOC SLICE_X142Y287 [get_cells gtze2_inf_north/RXDATA174_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA174_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA174_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA174_FD]
set_property LOC SLICE_X143Y287 [get_cells gtze2_inf_north/RXDATA174_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA174_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA173_LUT1A]
set_property LOC SLICE_X142Y287 [get_cells gtze2_inf_north/RXDATA173_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA173_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA173_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA173_LUT1B]
set_property LOC SLICE_X142Y287 [get_cells gtze2_inf_north/RXDATA173_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA173_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA173_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA173_FD]
set_property LOC SLICE_X143Y287 [get_cells gtze2_inf_north/RXDATA173_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA173_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA172_LUT1A]
set_property LOC SLICE_X142Y287 [get_cells gtze2_inf_north/RXDATA172_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA172_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA172_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA172_LUT1B]
set_property LOC SLICE_X142Y287 [get_cells gtze2_inf_north/RXDATA172_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA172_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA172_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA172_FD]
set_property LOC SLICE_X143Y287 [get_cells gtze2_inf_north/RXDATA172_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA172_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA171_LUT1A]
set_property LOC SLICE_X142Y292 [get_cells gtze2_inf_north/RXDATA171_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA171_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA171_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA171_LUT1B]
set_property LOC SLICE_X142Y292 [get_cells gtze2_inf_north/RXDATA171_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA171_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA171_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X143Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA171_FD]
set_property LOC SLICE_X143Y292 [get_cells gtze2_inf_north/RXDATA171_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA171_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA170_LUT1A]
set_property LOC SLICE_X142Y292 [get_cells gtze2_inf_north/RXDATA170_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA170_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA170_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA170_LUT1B]
set_property LOC SLICE_X142Y292 [get_cells gtze2_inf_north/RXDATA170_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA170_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA170_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA170_FD]
set_property LOC SLICE_X143Y292 [get_cells gtze2_inf_north/RXDATA170_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA170_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA169_LUT1A]
set_property LOC SLICE_X142Y292 [get_cells gtze2_inf_north/RXDATA169_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA169_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA169_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA169_LUT1B]
set_property LOC SLICE_X142Y292 [get_cells gtze2_inf_north/RXDATA169_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA169_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA169_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA169_FD]
set_property LOC SLICE_X143Y292 [get_cells gtze2_inf_north/RXDATA169_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA169_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA168_LUT1A]
set_property LOC SLICE_X142Y292 [get_cells gtze2_inf_north/RXDATA168_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA168_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA168_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA168_LUT1B]
set_property LOC SLICE_X142Y292 [get_cells gtze2_inf_north/RXDATA168_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA168_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA168_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA168_FD]
set_property LOC SLICE_X143Y292 [get_cells gtze2_inf_north/RXDATA168_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA168_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA167_LUT1A]
set_property LOC SLICE_X142Y297 [get_cells gtze2_inf_north/RXDATA167_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA167_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA167_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA167_LUT1B]
set_property LOC SLICE_X142Y297 [get_cells gtze2_inf_north/RXDATA167_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA167_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA167_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y297/C5FF]
set_property PROHIBIT true [get_bels SLICE_X143Y297/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA167_FD]
set_property LOC SLICE_X143Y297 [get_cells gtze2_inf_north/RXDATA167_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA167_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA166_LUT1A]
set_property LOC SLICE_X142Y297 [get_cells gtze2_inf_north/RXDATA166_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA166_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA166_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA166_LUT1B]
set_property LOC SLICE_X142Y297 [get_cells gtze2_inf_north/RXDATA166_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA166_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA166_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y297/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA166_FD]
set_property LOC SLICE_X143Y297 [get_cells gtze2_inf_north/RXDATA166_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA166_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA165_LUT1A]
set_property LOC SLICE_X142Y297 [get_cells gtze2_inf_north/RXDATA165_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA165_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA165_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA165_LUT1B]
set_property LOC SLICE_X142Y297 [get_cells gtze2_inf_north/RXDATA165_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA165_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA165_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA165_FD]
set_property LOC SLICE_X143Y297 [get_cells gtze2_inf_north/RXDATA165_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA165_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA164_LUT1A]
set_property LOC SLICE_X142Y297 [get_cells gtze2_inf_north/RXDATA164_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA164_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA164_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA164_LUT1B]
set_property LOC SLICE_X142Y297 [get_cells gtze2_inf_north/RXDATA164_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA164_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA164_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA164_FD]
set_property LOC SLICE_X143Y297 [get_cells gtze2_inf_north/RXDATA164_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA164_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA163_LUT1A]
set_property LOC SLICE_X144Y262 [get_cells gtze2_inf_north/RXDATA163_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA163_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA163_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA163_LUT1B]
set_property LOC SLICE_X144Y262 [get_cells gtze2_inf_north/RXDATA163_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA163_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA163_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X145Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA163_FD]
set_property LOC SLICE_X145Y262 [get_cells gtze2_inf_north/RXDATA163_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA163_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA162_LUT1A]
set_property LOC SLICE_X144Y262 [get_cells gtze2_inf_north/RXDATA162_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA162_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA162_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA162_LUT1B]
set_property LOC SLICE_X144Y262 [get_cells gtze2_inf_north/RXDATA162_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA162_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA162_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA162_FD]
set_property LOC SLICE_X145Y262 [get_cells gtze2_inf_north/RXDATA162_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA162_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA161_LUT1A]
set_property LOC SLICE_X144Y262 [get_cells gtze2_inf_north/RXDATA161_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA161_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA161_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA161_LUT1B]
set_property LOC SLICE_X144Y262 [get_cells gtze2_inf_north/RXDATA161_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA161_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA161_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA161_FD]
set_property LOC SLICE_X145Y262 [get_cells gtze2_inf_north/RXDATA161_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA161_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA160_LUT1A]
set_property LOC SLICE_X144Y262 [get_cells gtze2_inf_north/RXDATA160_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA160_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA160_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA160_LUT1B]
set_property LOC SLICE_X144Y262 [get_cells gtze2_inf_north/RXDATA160_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA160_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA160_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA160_FD]
set_property LOC SLICE_X145Y262 [get_cells gtze2_inf_north/RXDATA160_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA160_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA159_LUT1A]
set_property LOC SLICE_X144Y267 [get_cells gtze2_inf_north/RXDATA159_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA159_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA159_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA159_LUT1B]
set_property LOC SLICE_X144Y267 [get_cells gtze2_inf_north/RXDATA159_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA159_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA159_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X145Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA159_FD]
set_property LOC SLICE_X145Y267 [get_cells gtze2_inf_north/RXDATA159_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA159_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA158_LUT1A]
set_property LOC SLICE_X144Y267 [get_cells gtze2_inf_north/RXDATA158_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA158_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA158_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA158_LUT1B]
set_property LOC SLICE_X144Y267 [get_cells gtze2_inf_north/RXDATA158_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA158_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA158_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA158_FD]
set_property LOC SLICE_X145Y267 [get_cells gtze2_inf_north/RXDATA158_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA158_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA157_LUT1A]
set_property LOC SLICE_X144Y267 [get_cells gtze2_inf_north/RXDATA157_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA157_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA157_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA157_LUT1B]
set_property LOC SLICE_X144Y267 [get_cells gtze2_inf_north/RXDATA157_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA157_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA157_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA157_FD]
set_property LOC SLICE_X145Y267 [get_cells gtze2_inf_north/RXDATA157_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA157_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA156_LUT1A]
set_property LOC SLICE_X144Y267 [get_cells gtze2_inf_north/RXDATA156_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA156_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA156_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA156_LUT1B]
set_property LOC SLICE_X144Y267 [get_cells gtze2_inf_north/RXDATA156_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA156_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA156_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA156_FD]
set_property LOC SLICE_X145Y267 [get_cells gtze2_inf_north/RXDATA156_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA156_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA155_LUT1A]
set_property LOC SLICE_X144Y272 [get_cells gtze2_inf_north/RXDATA155_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA155_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA155_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA155_LUT1B]
set_property LOC SLICE_X144Y272 [get_cells gtze2_inf_north/RXDATA155_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA155_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA155_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X145Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA155_FD]
set_property LOC SLICE_X145Y272 [get_cells gtze2_inf_north/RXDATA155_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA155_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA154_LUT1A]
set_property LOC SLICE_X144Y272 [get_cells gtze2_inf_north/RXDATA154_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA154_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA154_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA154_LUT1B]
set_property LOC SLICE_X144Y272 [get_cells gtze2_inf_north/RXDATA154_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA154_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA154_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA154_FD]
set_property LOC SLICE_X145Y272 [get_cells gtze2_inf_north/RXDATA154_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA154_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA153_LUT1A]
set_property LOC SLICE_X144Y272 [get_cells gtze2_inf_north/RXDATA153_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA153_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA153_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA153_LUT1B]
set_property LOC SLICE_X144Y272 [get_cells gtze2_inf_north/RXDATA153_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA153_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA153_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA153_FD]
set_property LOC SLICE_X145Y272 [get_cells gtze2_inf_north/RXDATA153_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA153_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA152_LUT1A]
set_property LOC SLICE_X144Y272 [get_cells gtze2_inf_north/RXDATA152_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA152_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA152_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA152_LUT1B]
set_property LOC SLICE_X144Y272 [get_cells gtze2_inf_north/RXDATA152_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA152_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA152_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA152_FD]
set_property LOC SLICE_X145Y272 [get_cells gtze2_inf_north/RXDATA152_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA152_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA151_LUT1A]
set_property LOC SLICE_X144Y277 [get_cells gtze2_inf_north/RXDATA151_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA151_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA151_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA151_LUT1B]
set_property LOC SLICE_X144Y277 [get_cells gtze2_inf_north/RXDATA151_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA151_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA151_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X145Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA151_FD]
set_property LOC SLICE_X145Y277 [get_cells gtze2_inf_north/RXDATA151_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA151_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA150_LUT1A]
set_property LOC SLICE_X144Y277 [get_cells gtze2_inf_north/RXDATA150_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA150_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA150_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA150_LUT1B]
set_property LOC SLICE_X144Y277 [get_cells gtze2_inf_north/RXDATA150_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA150_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA150_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA150_FD]
set_property LOC SLICE_X145Y277 [get_cells gtze2_inf_north/RXDATA150_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA150_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA149_LUT1A]
set_property LOC SLICE_X144Y277 [get_cells gtze2_inf_north/RXDATA149_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA149_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA149_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA149_LUT1B]
set_property LOC SLICE_X144Y277 [get_cells gtze2_inf_north/RXDATA149_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA149_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA149_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA149_FD]
set_property LOC SLICE_X145Y277 [get_cells gtze2_inf_north/RXDATA149_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA149_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA148_LUT1A]
set_property LOC SLICE_X144Y277 [get_cells gtze2_inf_north/RXDATA148_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA148_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA148_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA148_LUT1B]
set_property LOC SLICE_X144Y277 [get_cells gtze2_inf_north/RXDATA148_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA148_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA148_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA148_FD]
set_property LOC SLICE_X145Y277 [get_cells gtze2_inf_north/RXDATA148_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA148_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA147_LUT1A]
set_property LOC SLICE_X144Y282 [get_cells gtze2_inf_north/RXDATA147_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA147_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA147_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA147_LUT1B]
set_property LOC SLICE_X144Y282 [get_cells gtze2_inf_north/RXDATA147_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA147_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA147_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y282/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA147_FD]
set_property LOC SLICE_X145Y282 [get_cells gtze2_inf_north/RXDATA147_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA147_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA146_LUT1A]
set_property LOC SLICE_X144Y282 [get_cells gtze2_inf_north/RXDATA146_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA146_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA146_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA146_LUT1B]
set_property LOC SLICE_X144Y282 [get_cells gtze2_inf_north/RXDATA146_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA146_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA146_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X145Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA146_FD]
set_property LOC SLICE_X145Y282 [get_cells gtze2_inf_north/RXDATA146_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA146_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA198_LUT1A]
set_property LOC SLICE_X140Y297 [get_cells gtze2_inf_north/RXDATA198_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA198_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA198_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA198_LUT1B]
set_property LOC SLICE_X140Y297 [get_cells gtze2_inf_north/RXDATA198_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA198_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA198_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y297/D5FF]
set_property PROHIBIT true [get_bels SLICE_X141Y297/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA198_FD]
set_property LOC SLICE_X141Y297 [get_cells gtze2_inf_north/RXDATA198_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA198_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA197_LUT1A]
set_property LOC SLICE_X140Y297 [get_cells gtze2_inf_north/RXDATA197_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA197_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA197_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA197_LUT1B]
set_property LOC SLICE_X140Y297 [get_cells gtze2_inf_north/RXDATA197_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA197_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA197_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA197_FD]
set_property LOC SLICE_X141Y297 [get_cells gtze2_inf_north/RXDATA197_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA197_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA196_LUT1A]
set_property LOC SLICE_X140Y297 [get_cells gtze2_inf_north/RXDATA196_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA196_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA196_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA196_LUT1B]
set_property LOC SLICE_X140Y297 [get_cells gtze2_inf_north/RXDATA196_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA196_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA196_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA196_FD]
set_property LOC SLICE_X141Y297 [get_cells gtze2_inf_north/RXDATA196_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA196_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA195_LUT1A]
set_property LOC SLICE_X142Y262 [get_cells gtze2_inf_north/RXDATA195_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA195_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA195_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA195_LUT1B]
set_property LOC SLICE_X142Y262 [get_cells gtze2_inf_north/RXDATA195_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA195_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA195_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X143Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA195_FD]
set_property LOC SLICE_X143Y262 [get_cells gtze2_inf_north/RXDATA195_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA195_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA194_LUT1A]
set_property LOC SLICE_X142Y262 [get_cells gtze2_inf_north/RXDATA194_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA194_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA194_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA194_LUT1B]
set_property LOC SLICE_X142Y262 [get_cells gtze2_inf_north/RXDATA194_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA194_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA194_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA194_FD]
set_property LOC SLICE_X143Y262 [get_cells gtze2_inf_north/RXDATA194_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA194_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA193_LUT1A]
set_property LOC SLICE_X142Y262 [get_cells gtze2_inf_north/RXDATA193_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA193_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA193_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA193_LUT1B]
set_property LOC SLICE_X142Y262 [get_cells gtze2_inf_north/RXDATA193_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA193_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA193_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA193_FD]
set_property LOC SLICE_X143Y262 [get_cells gtze2_inf_north/RXDATA193_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA193_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA192_LUT1A]
set_property LOC SLICE_X142Y262 [get_cells gtze2_inf_north/RXDATA192_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA192_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA192_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA192_LUT1B]
set_property LOC SLICE_X142Y262 [get_cells gtze2_inf_north/RXDATA192_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA192_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA192_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA192_FD]
set_property LOC SLICE_X143Y262 [get_cells gtze2_inf_north/RXDATA192_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA192_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA191_LUT1A]
set_property LOC SLICE_X142Y267 [get_cells gtze2_inf_north/RXDATA191_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA191_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA191_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA191_LUT1B]
set_property LOC SLICE_X142Y267 [get_cells gtze2_inf_north/RXDATA191_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA191_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA191_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X143Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA191_FD]
set_property LOC SLICE_X143Y267 [get_cells gtze2_inf_north/RXDATA191_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA191_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA190_LUT1A]
set_property LOC SLICE_X142Y267 [get_cells gtze2_inf_north/RXDATA190_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA190_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA190_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA190_LUT1B]
set_property LOC SLICE_X142Y267 [get_cells gtze2_inf_north/RXDATA190_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA190_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA190_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA190_FD]
set_property LOC SLICE_X143Y267 [get_cells gtze2_inf_north/RXDATA190_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA190_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA189_LUT1A]
set_property LOC SLICE_X142Y267 [get_cells gtze2_inf_north/RXDATA189_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA189_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA189_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA189_LUT1B]
set_property LOC SLICE_X142Y267 [get_cells gtze2_inf_north/RXDATA189_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA189_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA189_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA189_FD]
set_property LOC SLICE_X143Y267 [get_cells gtze2_inf_north/RXDATA189_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA189_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA188_LUT1A]
set_property LOC SLICE_X142Y267 [get_cells gtze2_inf_north/RXDATA188_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA188_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA188_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA188_LUT1B]
set_property LOC SLICE_X142Y267 [get_cells gtze2_inf_north/RXDATA188_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA188_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA188_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA188_FD]
set_property LOC SLICE_X143Y267 [get_cells gtze2_inf_north/RXDATA188_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA188_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA187_LUT1A]
set_property LOC SLICE_X142Y272 [get_cells gtze2_inf_north/RXDATA187_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA187_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA187_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA187_LUT1B]
set_property LOC SLICE_X142Y272 [get_cells gtze2_inf_north/RXDATA187_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA187_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA187_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X143Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA187_FD]
set_property LOC SLICE_X143Y272 [get_cells gtze2_inf_north/RXDATA187_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA187_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA186_LUT1A]
set_property LOC SLICE_X142Y272 [get_cells gtze2_inf_north/RXDATA186_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA186_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA186_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA186_LUT1B]
set_property LOC SLICE_X142Y272 [get_cells gtze2_inf_north/RXDATA186_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA186_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA186_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA186_FD]
set_property LOC SLICE_X143Y272 [get_cells gtze2_inf_north/RXDATA186_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA186_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA185_LUT1A]
set_property LOC SLICE_X142Y272 [get_cells gtze2_inf_north/RXDATA185_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA185_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA185_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA185_LUT1B]
set_property LOC SLICE_X142Y272 [get_cells gtze2_inf_north/RXDATA185_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA185_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA185_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA185_FD]
set_property LOC SLICE_X143Y272 [get_cells gtze2_inf_north/RXDATA185_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA185_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA184_LUT1A]
set_property LOC SLICE_X142Y272 [get_cells gtze2_inf_north/RXDATA184_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA184_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA184_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA184_LUT1B]
set_property LOC SLICE_X142Y272 [get_cells gtze2_inf_north/RXDATA184_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA184_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA184_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA184_FD]
set_property LOC SLICE_X143Y272 [get_cells gtze2_inf_north/RXDATA184_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA184_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA183_LUT1A]
set_property LOC SLICE_X142Y277 [get_cells gtze2_inf_north/RXDATA183_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA183_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA183_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA183_LUT1B]
set_property LOC SLICE_X142Y277 [get_cells gtze2_inf_north/RXDATA183_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA183_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA183_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X143Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA183_FD]
set_property LOC SLICE_X143Y277 [get_cells gtze2_inf_north/RXDATA183_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA183_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA182_LUT1A]
set_property LOC SLICE_X142Y277 [get_cells gtze2_inf_north/RXDATA182_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA182_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA182_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA182_LUT1B]
set_property LOC SLICE_X142Y277 [get_cells gtze2_inf_north/RXDATA182_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA182_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA182_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA182_FD]
set_property LOC SLICE_X143Y277 [get_cells gtze2_inf_north/RXDATA182_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA182_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA181_LUT1A]
set_property LOC SLICE_X142Y277 [get_cells gtze2_inf_north/RXDATA181_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA181_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA181_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA181_LUT1B]
set_property LOC SLICE_X142Y277 [get_cells gtze2_inf_north/RXDATA181_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA181_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA181_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA181_FD]
set_property LOC SLICE_X143Y277 [get_cells gtze2_inf_north/RXDATA181_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA181_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA180_LUT1A]
set_property LOC SLICE_X142Y277 [get_cells gtze2_inf_north/RXDATA180_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA180_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA180_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA180_LUT1B]
set_property LOC SLICE_X142Y277 [get_cells gtze2_inf_north/RXDATA180_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA180_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA180_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA180_FD]
set_property LOC SLICE_X143Y277 [get_cells gtze2_inf_north/RXDATA180_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA180_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA179_LUT1A]
set_property LOC SLICE_X142Y282 [get_cells gtze2_inf_north/RXDATA179_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA179_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA179_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA179_LUT1B]
set_property LOC SLICE_X142Y282 [get_cells gtze2_inf_north/RXDATA179_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA179_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA179_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y282/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA179_FD]
set_property LOC SLICE_X143Y282 [get_cells gtze2_inf_north/RXDATA179_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA179_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA178_LUT1A]
set_property LOC SLICE_X142Y282 [get_cells gtze2_inf_north/RXDATA178_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA178_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA178_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA178_LUT1B]
set_property LOC SLICE_X142Y282 [get_cells gtze2_inf_north/RXDATA178_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA178_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA178_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X143Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA178_FD]
set_property LOC SLICE_X143Y282 [get_cells gtze2_inf_north/RXDATA178_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA178_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1130_LUT1A]
set_property LOC SLICE_X138Y297 [get_cells gtze2_inf_north/RXDATA1130_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1130_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1130_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1130_LUT1B]
set_property LOC SLICE_X138Y297 [get_cells gtze2_inf_north/RXDATA1130_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1130_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1130_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y297/D5FF]
set_property PROHIBIT true [get_bels SLICE_X139Y297/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1130_FD]
set_property LOC SLICE_X139Y297 [get_cells gtze2_inf_north/RXDATA1130_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1130_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1129_LUT1A]
set_property LOC SLICE_X138Y297 [get_cells gtze2_inf_north/RXDATA1129_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1129_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1129_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1129_LUT1B]
set_property LOC SLICE_X138Y297 [get_cells gtze2_inf_north/RXDATA1129_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1129_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1129_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y297/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1129_FD]
set_property LOC SLICE_X139Y297 [get_cells gtze2_inf_north/RXDATA1129_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1129_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1128_LUT1A]
set_property LOC SLICE_X138Y297 [get_cells gtze2_inf_north/RXDATA1128_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1128_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1128_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1128_LUT1B]
set_property LOC SLICE_X138Y297 [get_cells gtze2_inf_north/RXDATA1128_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1128_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1128_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y297/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1128_FD]
set_property LOC SLICE_X139Y297 [get_cells gtze2_inf_north/RXDATA1128_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1128_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1127_LUT1A]
set_property LOC SLICE_X140Y262 [get_cells gtze2_inf_north/RXDATA1127_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1127_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1127_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1127_LUT1B]
set_property LOC SLICE_X140Y262 [get_cells gtze2_inf_north/RXDATA1127_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1127_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1127_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y262/C5FF]
set_property PROHIBIT true [get_bels SLICE_X141Y262/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1127_FD]
set_property LOC SLICE_X141Y262 [get_cells gtze2_inf_north/RXDATA1127_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1127_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1126_LUT1A]
set_property LOC SLICE_X140Y262 [get_cells gtze2_inf_north/RXDATA1126_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1126_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1126_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1126_LUT1B]
set_property LOC SLICE_X140Y262 [get_cells gtze2_inf_north/RXDATA1126_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1126_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1126_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1126_FD]
set_property LOC SLICE_X141Y262 [get_cells gtze2_inf_north/RXDATA1126_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1126_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1125_LUT1A]
set_property LOC SLICE_X140Y262 [get_cells gtze2_inf_north/RXDATA1125_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1125_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1125_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1125_LUT1B]
set_property LOC SLICE_X140Y262 [get_cells gtze2_inf_north/RXDATA1125_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1125_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1125_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1125_FD]
set_property LOC SLICE_X141Y262 [get_cells gtze2_inf_north/RXDATA1125_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1125_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1124_LUT1A]
set_property LOC SLICE_X140Y262 [get_cells gtze2_inf_north/RXDATA1124_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1124_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1124_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1124_LUT1B]
set_property LOC SLICE_X140Y262 [get_cells gtze2_inf_north/RXDATA1124_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1124_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1124_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1124_FD]
set_property LOC SLICE_X141Y262 [get_cells gtze2_inf_north/RXDATA1124_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1124_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1123_LUT1A]
set_property LOC SLICE_X140Y267 [get_cells gtze2_inf_north/RXDATA1123_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1123_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1123_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1123_LUT1B]
set_property LOC SLICE_X140Y267 [get_cells gtze2_inf_north/RXDATA1123_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1123_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1123_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X141Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1123_FD]
set_property LOC SLICE_X141Y267 [get_cells gtze2_inf_north/RXDATA1123_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1123_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1122_LUT1A]
set_property LOC SLICE_X140Y267 [get_cells gtze2_inf_north/RXDATA1122_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1122_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1122_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1122_LUT1B]
set_property LOC SLICE_X140Y267 [get_cells gtze2_inf_north/RXDATA1122_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1122_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1122_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1122_FD]
set_property LOC SLICE_X141Y267 [get_cells gtze2_inf_north/RXDATA1122_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1122_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1121_LUT1A]
set_property LOC SLICE_X140Y267 [get_cells gtze2_inf_north/RXDATA1121_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1121_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1121_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1121_LUT1B]
set_property LOC SLICE_X140Y267 [get_cells gtze2_inf_north/RXDATA1121_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1121_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1121_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1121_FD]
set_property LOC SLICE_X141Y267 [get_cells gtze2_inf_north/RXDATA1121_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1121_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1120_LUT1A]
set_property LOC SLICE_X140Y267 [get_cells gtze2_inf_north/RXDATA1120_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1120_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1120_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1120_LUT1B]
set_property LOC SLICE_X140Y267 [get_cells gtze2_inf_north/RXDATA1120_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1120_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1120_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1120_FD]
set_property LOC SLICE_X141Y267 [get_cells gtze2_inf_north/RXDATA1120_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1120_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1119_LUT1A]
set_property LOC SLICE_X140Y272 [get_cells gtze2_inf_north/RXDATA1119_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1119_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1119_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1119_LUT1B]
set_property LOC SLICE_X140Y272 [get_cells gtze2_inf_north/RXDATA1119_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1119_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1119_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X141Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1119_FD]
set_property LOC SLICE_X141Y272 [get_cells gtze2_inf_north/RXDATA1119_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1119_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1118_LUT1A]
set_property LOC SLICE_X140Y272 [get_cells gtze2_inf_north/RXDATA1118_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1118_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1118_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1118_LUT1B]
set_property LOC SLICE_X140Y272 [get_cells gtze2_inf_north/RXDATA1118_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1118_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1118_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1118_FD]
set_property LOC SLICE_X141Y272 [get_cells gtze2_inf_north/RXDATA1118_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1118_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1117_LUT1A]
set_property LOC SLICE_X140Y272 [get_cells gtze2_inf_north/RXDATA1117_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1117_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1117_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1117_LUT1B]
set_property LOC SLICE_X140Y272 [get_cells gtze2_inf_north/RXDATA1117_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1117_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1117_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1117_FD]
set_property LOC SLICE_X141Y272 [get_cells gtze2_inf_north/RXDATA1117_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1117_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1116_LUT1A]
set_property LOC SLICE_X140Y272 [get_cells gtze2_inf_north/RXDATA1116_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1116_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1116_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1116_LUT1B]
set_property LOC SLICE_X140Y272 [get_cells gtze2_inf_north/RXDATA1116_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1116_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1116_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1116_FD]
set_property LOC SLICE_X141Y272 [get_cells gtze2_inf_north/RXDATA1116_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1116_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1115_LUT1A]
set_property LOC SLICE_X140Y277 [get_cells gtze2_inf_north/RXDATA1115_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1115_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1115_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1115_LUT1B]
set_property LOC SLICE_X140Y277 [get_cells gtze2_inf_north/RXDATA1115_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1115_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1115_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X141Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1115_FD]
set_property LOC SLICE_X141Y277 [get_cells gtze2_inf_north/RXDATA1115_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1115_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1114_LUT1A]
set_property LOC SLICE_X140Y277 [get_cells gtze2_inf_north/RXDATA1114_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1114_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1114_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1114_LUT1B]
set_property LOC SLICE_X140Y277 [get_cells gtze2_inf_north/RXDATA1114_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1114_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1114_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1114_FD]
set_property LOC SLICE_X141Y277 [get_cells gtze2_inf_north/RXDATA1114_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1114_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1113_LUT1A]
set_property LOC SLICE_X140Y277 [get_cells gtze2_inf_north/RXDATA1113_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1113_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1113_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1113_LUT1B]
set_property LOC SLICE_X140Y277 [get_cells gtze2_inf_north/RXDATA1113_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1113_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1113_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1113_FD]
set_property LOC SLICE_X141Y277 [get_cells gtze2_inf_north/RXDATA1113_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1113_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1112_LUT1A]
set_property LOC SLICE_X140Y277 [get_cells gtze2_inf_north/RXDATA1112_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1112_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1112_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1112_LUT1B]
set_property LOC SLICE_X140Y277 [get_cells gtze2_inf_north/RXDATA1112_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1112_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1112_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1112_FD]
set_property LOC SLICE_X141Y277 [get_cells gtze2_inf_north/RXDATA1112_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1112_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1111_LUT1A]
set_property LOC SLICE_X140Y282 [get_cells gtze2_inf_north/RXDATA1111_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1111_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1111_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1111_LUT1B]
set_property LOC SLICE_X140Y282 [get_cells gtze2_inf_north/RXDATA1111_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1111_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1111_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X141Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1111_FD]
set_property LOC SLICE_X141Y282 [get_cells gtze2_inf_north/RXDATA1111_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1111_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1110_LUT1A]
set_property LOC SLICE_X140Y282 [get_cells gtze2_inf_north/RXDATA1110_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1110_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1110_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1110_LUT1B]
set_property LOC SLICE_X140Y282 [get_cells gtze2_inf_north/RXDATA1110_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1110_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1110_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1110_FD]
set_property LOC SLICE_X141Y282 [get_cells gtze2_inf_north/RXDATA1110_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1110_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1109_LUT1A]
set_property LOC SLICE_X140Y282 [get_cells gtze2_inf_north/RXDATA1109_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1109_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1109_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1109_LUT1B]
set_property LOC SLICE_X140Y282 [get_cells gtze2_inf_north/RXDATA1109_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1109_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1109_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1109_FD]
set_property LOC SLICE_X141Y282 [get_cells gtze2_inf_north/RXDATA1109_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1109_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1108_LUT1A]
set_property LOC SLICE_X140Y282 [get_cells gtze2_inf_north/RXDATA1108_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1108_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1108_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1108_LUT1B]
set_property LOC SLICE_X140Y282 [get_cells gtze2_inf_north/RXDATA1108_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1108_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1108_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1108_FD]
set_property LOC SLICE_X141Y282 [get_cells gtze2_inf_north/RXDATA1108_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1108_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1107_LUT1A]
set_property LOC SLICE_X140Y287 [get_cells gtze2_inf_north/RXDATA1107_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1107_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1107_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1107_LUT1B]
set_property LOC SLICE_X140Y287 [get_cells gtze2_inf_north/RXDATA1107_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1107_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1107_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X141Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1107_FD]
set_property LOC SLICE_X141Y287 [get_cells gtze2_inf_north/RXDATA1107_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1107_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1106_LUT1A]
set_property LOC SLICE_X140Y287 [get_cells gtze2_inf_north/RXDATA1106_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1106_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1106_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1106_LUT1B]
set_property LOC SLICE_X140Y287 [get_cells gtze2_inf_north/RXDATA1106_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1106_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1106_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1106_FD]
set_property LOC SLICE_X141Y287 [get_cells gtze2_inf_north/RXDATA1106_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1106_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1105_LUT1A]
set_property LOC SLICE_X140Y287 [get_cells gtze2_inf_north/RXDATA1105_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1105_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1105_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1105_LUT1B]
set_property LOC SLICE_X140Y287 [get_cells gtze2_inf_north/RXDATA1105_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1105_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1105_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1105_FD]
set_property LOC SLICE_X141Y287 [get_cells gtze2_inf_north/RXDATA1105_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1105_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1104_LUT1A]
set_property LOC SLICE_X140Y287 [get_cells gtze2_inf_north/RXDATA1104_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1104_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1104_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1104_LUT1B]
set_property LOC SLICE_X140Y287 [get_cells gtze2_inf_north/RXDATA1104_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1104_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1104_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1104_FD]
set_property LOC SLICE_X141Y287 [get_cells gtze2_inf_north/RXDATA1104_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1104_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1103_LUT1A]
set_property LOC SLICE_X140Y292 [get_cells gtze2_inf_north/RXDATA1103_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1103_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1103_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1103_LUT1B]
set_property LOC SLICE_X140Y292 [get_cells gtze2_inf_north/RXDATA1103_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1103_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1103_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X141Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1103_FD]
set_property LOC SLICE_X141Y292 [get_cells gtze2_inf_north/RXDATA1103_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1103_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1102_LUT1A]
set_property LOC SLICE_X140Y292 [get_cells gtze2_inf_north/RXDATA1102_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1102_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1102_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1102_LUT1B]
set_property LOC SLICE_X140Y292 [get_cells gtze2_inf_north/RXDATA1102_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1102_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1102_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1102_FD]
set_property LOC SLICE_X141Y292 [get_cells gtze2_inf_north/RXDATA1102_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1102_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1101_LUT1A]
set_property LOC SLICE_X140Y292 [get_cells gtze2_inf_north/RXDATA1101_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1101_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1101_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1101_LUT1B]
set_property LOC SLICE_X140Y292 [get_cells gtze2_inf_north/RXDATA1101_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1101_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1101_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1101_FD]
set_property LOC SLICE_X141Y292 [get_cells gtze2_inf_north/RXDATA1101_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1101_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1100_LUT1A]
set_property LOC SLICE_X140Y292 [get_cells gtze2_inf_north/RXDATA1100_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1100_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1100_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1100_LUT1B]
set_property LOC SLICE_X140Y292 [get_cells gtze2_inf_north/RXDATA1100_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1100_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1100_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1100_FD]
set_property LOC SLICE_X141Y292 [get_cells gtze2_inf_north/RXDATA1100_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1100_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA199_LUT1A]
set_property LOC SLICE_X140Y297 [get_cells gtze2_inf_north/RXDATA199_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA199_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA199_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA199_LUT1B]
set_property LOC SLICE_X140Y297 [get_cells gtze2_inf_north/RXDATA199_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA199_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA199_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X141Y297/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA199_FD]
set_property LOC SLICE_X141Y297 [get_cells gtze2_inf_north/RXDATA199_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA199_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1156_LUT1A]
set_property LOC SLICE_X138Y262 [get_cells gtze2_inf_north/RXDATA1156_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1156_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1156_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1156_LUT1B]
set_property LOC SLICE_X138Y262 [get_cells gtze2_inf_north/RXDATA1156_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1156_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1156_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y262/A5FF]
set_property PROHIBIT true [get_bels SLICE_X139Y262/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1156_FD]
set_property LOC SLICE_X139Y262 [get_cells gtze2_inf_north/RXDATA1156_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1156_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1155_LUT1A]
set_property LOC SLICE_X138Y267 [get_cells gtze2_inf_north/RXDATA1155_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1155_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1155_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1155_LUT1B]
set_property LOC SLICE_X138Y267 [get_cells gtze2_inf_north/RXDATA1155_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1155_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1155_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X139Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1155_FD]
set_property LOC SLICE_X139Y267 [get_cells gtze2_inf_north/RXDATA1155_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1155_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1154_LUT1A]
set_property LOC SLICE_X138Y267 [get_cells gtze2_inf_north/RXDATA1154_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1154_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1154_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1154_LUT1B]
set_property LOC SLICE_X138Y267 [get_cells gtze2_inf_north/RXDATA1154_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1154_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1154_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1154_FD]
set_property LOC SLICE_X139Y267 [get_cells gtze2_inf_north/RXDATA1154_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1154_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1153_LUT1A]
set_property LOC SLICE_X138Y267 [get_cells gtze2_inf_north/RXDATA1153_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1153_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1153_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1153_LUT1B]
set_property LOC SLICE_X138Y267 [get_cells gtze2_inf_north/RXDATA1153_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1153_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1153_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1153_FD]
set_property LOC SLICE_X139Y267 [get_cells gtze2_inf_north/RXDATA1153_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1153_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1152_LUT1A]
set_property LOC SLICE_X138Y267 [get_cells gtze2_inf_north/RXDATA1152_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1152_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1152_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1152_LUT1B]
set_property LOC SLICE_X138Y267 [get_cells gtze2_inf_north/RXDATA1152_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1152_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1152_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1152_FD]
set_property LOC SLICE_X139Y267 [get_cells gtze2_inf_north/RXDATA1152_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1152_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1151_LUT1A]
set_property LOC SLICE_X138Y272 [get_cells gtze2_inf_north/RXDATA1151_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1151_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1151_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1151_LUT1B]
set_property LOC SLICE_X138Y272 [get_cells gtze2_inf_north/RXDATA1151_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1151_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1151_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X139Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1151_FD]
set_property LOC SLICE_X139Y272 [get_cells gtze2_inf_north/RXDATA1151_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1151_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1150_LUT1A]
set_property LOC SLICE_X138Y272 [get_cells gtze2_inf_north/RXDATA1150_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1150_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1150_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1150_LUT1B]
set_property LOC SLICE_X138Y272 [get_cells gtze2_inf_north/RXDATA1150_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1150_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1150_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1150_FD]
set_property LOC SLICE_X139Y272 [get_cells gtze2_inf_north/RXDATA1150_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1150_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1149_LUT1A]
set_property LOC SLICE_X138Y272 [get_cells gtze2_inf_north/RXDATA1149_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1149_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1149_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1149_LUT1B]
set_property LOC SLICE_X138Y272 [get_cells gtze2_inf_north/RXDATA1149_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1149_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1149_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1149_FD]
set_property LOC SLICE_X139Y272 [get_cells gtze2_inf_north/RXDATA1149_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1149_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1148_LUT1A]
set_property LOC SLICE_X138Y272 [get_cells gtze2_inf_north/RXDATA1148_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1148_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1148_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1148_LUT1B]
set_property LOC SLICE_X138Y272 [get_cells gtze2_inf_north/RXDATA1148_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1148_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1148_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1148_FD]
set_property LOC SLICE_X139Y272 [get_cells gtze2_inf_north/RXDATA1148_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1148_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1147_LUT1A]
set_property LOC SLICE_X138Y277 [get_cells gtze2_inf_north/RXDATA1147_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1147_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1147_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1147_LUT1B]
set_property LOC SLICE_X138Y277 [get_cells gtze2_inf_north/RXDATA1147_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1147_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1147_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y277/C5FF]
set_property PROHIBIT true [get_bels SLICE_X139Y277/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1147_FD]
set_property LOC SLICE_X139Y277 [get_cells gtze2_inf_north/RXDATA1147_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1147_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1146_LUT1A]
set_property LOC SLICE_X138Y277 [get_cells gtze2_inf_north/RXDATA1146_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1146_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1146_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1146_LUT1B]
set_property LOC SLICE_X138Y277 [get_cells gtze2_inf_north/RXDATA1146_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1146_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1146_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1146_FD]
set_property LOC SLICE_X139Y277 [get_cells gtze2_inf_north/RXDATA1146_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1146_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1145_LUT1A]
set_property LOC SLICE_X138Y277 [get_cells gtze2_inf_north/RXDATA1145_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1145_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1145_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1145_LUT1B]
set_property LOC SLICE_X138Y277 [get_cells gtze2_inf_north/RXDATA1145_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1145_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1145_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1145_FD]
set_property LOC SLICE_X139Y277 [get_cells gtze2_inf_north/RXDATA1145_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1145_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1144_LUT1A]
set_property LOC SLICE_X138Y277 [get_cells gtze2_inf_north/RXDATA1144_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1144_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1144_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1144_LUT1B]
set_property LOC SLICE_X138Y277 [get_cells gtze2_inf_north/RXDATA1144_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y277/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1144_FD]
set_property LOC SLICE_X139Y277 [get_cells gtze2_inf_north/RXDATA1144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1144_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1143_LUT1A]
set_property LOC SLICE_X138Y282 [get_cells gtze2_inf_north/RXDATA1143_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1143_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1143_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1143_LUT1B]
set_property LOC SLICE_X138Y282 [get_cells gtze2_inf_north/RXDATA1143_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y282/C5FF]
set_property PROHIBIT true [get_bels SLICE_X139Y282/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1143_FD]
set_property LOC SLICE_X139Y282 [get_cells gtze2_inf_north/RXDATA1143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1143_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1142_LUT1A]
set_property LOC SLICE_X138Y282 [get_cells gtze2_inf_north/RXDATA1142_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1142_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1142_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1142_LUT1B]
set_property LOC SLICE_X138Y282 [get_cells gtze2_inf_north/RXDATA1142_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1142_FD]
set_property LOC SLICE_X139Y282 [get_cells gtze2_inf_north/RXDATA1142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1142_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1141_LUT1A]
set_property LOC SLICE_X138Y282 [get_cells gtze2_inf_north/RXDATA1141_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1141_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1141_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1141_LUT1B]
set_property LOC SLICE_X138Y282 [get_cells gtze2_inf_north/RXDATA1141_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1141_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1141_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1141_FD]
set_property LOC SLICE_X139Y282 [get_cells gtze2_inf_north/RXDATA1141_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1141_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1140_LUT1A]
set_property LOC SLICE_X138Y282 [get_cells gtze2_inf_north/RXDATA1140_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1140_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1140_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1140_LUT1B]
set_property LOC SLICE_X138Y282 [get_cells gtze2_inf_north/RXDATA1140_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1140_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1140_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y282/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1140_FD]
set_property LOC SLICE_X139Y282 [get_cells gtze2_inf_north/RXDATA1140_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1140_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1139_LUT1A]
set_property LOC SLICE_X138Y287 [get_cells gtze2_inf_north/RXDATA1139_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1139_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1139_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1139_LUT1B]
set_property LOC SLICE_X138Y287 [get_cells gtze2_inf_north/RXDATA1139_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1139_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1139_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y287/C5FF]
set_property PROHIBIT true [get_bels SLICE_X139Y287/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1139_FD]
set_property LOC SLICE_X139Y287 [get_cells gtze2_inf_north/RXDATA1139_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1139_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1138_LUT1A]
set_property LOC SLICE_X138Y287 [get_cells gtze2_inf_north/RXDATA1138_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1138_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1138_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1138_LUT1B]
set_property LOC SLICE_X138Y287 [get_cells gtze2_inf_north/RXDATA1138_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1138_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1138_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y287/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1138_FD]
set_property LOC SLICE_X139Y287 [get_cells gtze2_inf_north/RXDATA1138_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1138_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1137_LUT1A]
set_property LOC SLICE_X138Y287 [get_cells gtze2_inf_north/RXDATA1137_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1137_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1137_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1137_LUT1B]
set_property LOC SLICE_X138Y287 [get_cells gtze2_inf_north/RXDATA1137_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1137_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1137_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y287/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1137_FD]
set_property LOC SLICE_X139Y287 [get_cells gtze2_inf_north/RXDATA1137_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1137_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1136_LUT1A]
set_property LOC SLICE_X138Y287 [get_cells gtze2_inf_north/RXDATA1136_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1136_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1136_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1136_LUT1B]
set_property LOC SLICE_X138Y287 [get_cells gtze2_inf_north/RXDATA1136_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1136_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1136_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y287/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1136_FD]
set_property LOC SLICE_X139Y287 [get_cells gtze2_inf_north/RXDATA1136_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1136_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1135_LUT1A]
set_property LOC SLICE_X138Y292 [get_cells gtze2_inf_north/RXDATA1135_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1135_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1135_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1135_LUT1B]
set_property LOC SLICE_X138Y292 [get_cells gtze2_inf_north/RXDATA1135_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1135_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1135_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y292/C5FF]
set_property PROHIBIT true [get_bels SLICE_X139Y292/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1135_FD]
set_property LOC SLICE_X139Y292 [get_cells gtze2_inf_north/RXDATA1135_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1135_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1134_LUT1A]
set_property LOC SLICE_X138Y292 [get_cells gtze2_inf_north/RXDATA1134_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1134_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1134_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1134_LUT1B]
set_property LOC SLICE_X138Y292 [get_cells gtze2_inf_north/RXDATA1134_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1134_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1134_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y292/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1134_FD]
set_property LOC SLICE_X139Y292 [get_cells gtze2_inf_north/RXDATA1134_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1134_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1133_LUT1A]
set_property LOC SLICE_X138Y292 [get_cells gtze2_inf_north/RXDATA1133_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1133_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1133_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1133_LUT1B]
set_property LOC SLICE_X138Y292 [get_cells gtze2_inf_north/RXDATA1133_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1133_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1133_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y292/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1133_FD]
set_property LOC SLICE_X139Y292 [get_cells gtze2_inf_north/RXDATA1133_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1133_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA1132_LUT1A]
set_property LOC SLICE_X138Y292 [get_cells gtze2_inf_north/RXDATA1132_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA1132_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1132_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA1132_LUT1B]
set_property LOC SLICE_X138Y292 [get_cells gtze2_inf_north/RXDATA1132_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1132_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1132_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y292/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA1132_FD]
set_property LOC SLICE_X139Y292 [get_cells gtze2_inf_north/RXDATA1132_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1132_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1131_LUT1A]
set_property LOC SLICE_X138Y297 [get_cells gtze2_inf_north/RXDATA1131_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1131_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1131_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1131_LUT1B]
set_property LOC SLICE_X138Y297 [get_cells gtze2_inf_north/RXDATA1131_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1131_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1131_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y297/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1131_FD]
set_property LOC SLICE_X139Y297 [get_cells gtze2_inf_north/RXDATA1131_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1131_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER32_LUT1A]
set_property LOC SLICE_X185Y267 [get_cells gtze2_inf_north/RXHEADER32_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER32_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER32_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X184Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X184Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X184Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER32_LUT1B]
set_property LOC SLICE_X185Y267 [get_cells gtze2_inf_north/RXHEADER32_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER32_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER32_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X184Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER32_FD]
set_property LOC SLICE_X184Y267 [get_cells gtze2_inf_north/RXHEADER32_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER32_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER31_LUT1A]
set_property LOC SLICE_X187Y262 [get_cells gtze2_inf_north/RXHEADER31_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER31_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER31_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X186Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X186Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X186Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER31_LUT1B]
set_property LOC SLICE_X187Y262 [get_cells gtze2_inf_north/RXHEADER31_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X186Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER31_FD]
set_property LOC SLICE_X186Y262 [get_cells gtze2_inf_north/RXHEADER31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER31_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER30_LUT1A]
set_property LOC SLICE_X187Y267 [get_cells gtze2_inf_north/RXHEADER30_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER30_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER30_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X186Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X186Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X186Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER30_LUT1B]
set_property LOC SLICE_X187Y267 [get_cells gtze2_inf_north/RXHEADER30_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X186Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER30_FD]
set_property LOC SLICE_X186Y267 [get_cells gtze2_inf_north/RXHEADER30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER30_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID04_LUT1A]
set_property LOC SLICE_X119Y272 [get_cells gtze2_inf_north/RXDATAVALID04_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID04_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID04_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X118Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X118Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X118Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID04_LUT1B]
set_property LOC SLICE_X119Y272 [get_cells gtze2_inf_north/RXDATAVALID04_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID04_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID04_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X118Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID04_FD]
set_property LOC SLICE_X118Y272 [get_cells gtze2_inf_north/RXDATAVALID04_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID04_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA076_LUT1B]
set_property LOC SLICE_X101Y270 [get_cells gtze2_inf_north/TXDATA076_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA076_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA076_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA076_FD]
set_property LOC SLICE_X101Y270 [get_cells gtze2_inf_north/TXDATA076_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA076_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA075_LUT1B]
set_property LOC SLICE_X101Y275 [get_cells gtze2_inf_north/TXDATA075_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA075_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA075_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X101Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA075_FD]
set_property LOC SLICE_X101Y275 [get_cells gtze2_inf_north/TXDATA075_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA075_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA074_LUT1B]
set_property LOC SLICE_X101Y275 [get_cells gtze2_inf_north/TXDATA074_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA074_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA074_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA074_FD]
set_property LOC SLICE_X101Y275 [get_cells gtze2_inf_north/TXDATA074_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA074_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA073_LUT1B]
set_property LOC SLICE_X101Y275 [get_cells gtze2_inf_north/TXDATA073_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA073_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA073_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA073_FD]
set_property LOC SLICE_X101Y275 [get_cells gtze2_inf_north/TXDATA073_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA073_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA072_LUT1B]
set_property LOC SLICE_X101Y275 [get_cells gtze2_inf_north/TXDATA072_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA072_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA072_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA072_FD]
set_property LOC SLICE_X101Y275 [get_cells gtze2_inf_north/TXDATA072_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA072_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA071_LUT1B]
set_property LOC SLICE_X101Y280 [get_cells gtze2_inf_north/TXDATA071_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA071_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA071_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X101Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA071_FD]
set_property LOC SLICE_X101Y280 [get_cells gtze2_inf_north/TXDATA071_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA071_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA070_LUT1B]
set_property LOC SLICE_X101Y280 [get_cells gtze2_inf_north/TXDATA070_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA070_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA070_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA070_FD]
set_property LOC SLICE_X101Y280 [get_cells gtze2_inf_north/TXDATA070_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA070_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA069_LUT1B]
set_property LOC SLICE_X101Y280 [get_cells gtze2_inf_north/TXDATA069_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA069_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA069_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA069_FD]
set_property LOC SLICE_X101Y280 [get_cells gtze2_inf_north/TXDATA069_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA069_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA068_LUT1B]
set_property LOC SLICE_X101Y280 [get_cells gtze2_inf_north/TXDATA068_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA068_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA068_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA068_FD]
set_property LOC SLICE_X101Y280 [get_cells gtze2_inf_north/TXDATA068_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA068_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP20_LUT1B]
set_property LOC SLICE_X156Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP20_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X156Y290/D5FF]
set_property PROHIBIT true [get_bels SLICE_X156Y290/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/RXGEARBOXSLIP20_FD]
set_property LOC SLICE_X156Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP20_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA369_LUT1B]
set_property LOC SLICE_X173Y280 [get_cells gtze2_inf_north/TXDATA369_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA369_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA369_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA369_FD]
set_property LOC SLICE_X173Y280 [get_cells gtze2_inf_north/TXDATA369_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA369_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA368_LUT1B]
set_property LOC SLICE_X173Y280 [get_cells gtze2_inf_north/TXDATA368_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA368_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA368_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA368_FD]
set_property LOC SLICE_X173Y280 [get_cells gtze2_inf_north/TXDATA368_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA368_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA367_LUT1B]
set_property LOC SLICE_X173Y285 [get_cells gtze2_inf_north/TXDATA367_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA367_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA367_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X173Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA367_FD]
set_property LOC SLICE_X173Y285 [get_cells gtze2_inf_north/TXDATA367_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA367_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA366_LUT1B]
set_property LOC SLICE_X173Y285 [get_cells gtze2_inf_north/TXDATA366_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA366_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA366_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA366_FD]
set_property LOC SLICE_X173Y285 [get_cells gtze2_inf_north/TXDATA366_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA366_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA365_LUT1B]
set_property LOC SLICE_X173Y285 [get_cells gtze2_inf_north/TXDATA365_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA365_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA365_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA365_FD]
set_property LOC SLICE_X173Y285 [get_cells gtze2_inf_north/TXDATA365_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA365_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA364_LUT1B]
set_property LOC SLICE_X173Y285 [get_cells gtze2_inf_north/TXDATA364_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA364_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA364_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA364_FD]
set_property LOC SLICE_X173Y285 [get_cells gtze2_inf_north/TXDATA364_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA364_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA363_LUT1B]
set_property LOC SLICE_X175Y250 [get_cells gtze2_inf_north/TXDATA363_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA363_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA363_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y250/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA363_FD]
set_property LOC SLICE_X175Y250 [get_cells gtze2_inf_north/TXDATA363_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA363_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA362_LUT1B]
set_property LOC SLICE_X175Y250 [get_cells gtze2_inf_north/TXDATA362_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA362_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA362_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X175Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA362_FD]
set_property LOC SLICE_X175Y250 [get_cells gtze2_inf_north/TXDATA362_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA362_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0141_LUT1B]
set_property LOC SLICE_X97Y270 [get_cells gtze2_inf_north/TXDATA0141_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0141_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0141_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0141_FD]
set_property LOC SLICE_X97Y270 [get_cells gtze2_inf_north/TXDATA0141_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0141_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0140_LUT1B]
set_property LOC SLICE_X97Y270 [get_cells gtze2_inf_north/TXDATA0140_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0140_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0140_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0140_FD]
set_property LOC SLICE_X97Y270 [get_cells gtze2_inf_north/TXDATA0140_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0140_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0139_LUT1B]
set_property LOC SLICE_X97Y275 [get_cells gtze2_inf_north/TXDATA0139_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0139_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0139_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y275/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0139_FD]
set_property LOC SLICE_X97Y275 [get_cells gtze2_inf_north/TXDATA0139_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0139_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0138_LUT1B]
set_property LOC SLICE_X97Y275 [get_cells gtze2_inf_north/TXDATA0138_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0138_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0138_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0138_FD]
set_property LOC SLICE_X97Y275 [get_cells gtze2_inf_north/TXDATA0138_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0138_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0137_LUT1B]
set_property LOC SLICE_X97Y275 [get_cells gtze2_inf_north/TXDATA0137_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0137_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0137_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0137_FD]
set_property LOC SLICE_X97Y275 [get_cells gtze2_inf_north/TXDATA0137_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0137_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER35_LUT1A]
set_property LOC SLICE_X183Y262 [get_cells gtze2_inf_north/RXHEADER35_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER35_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER35_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X182Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X182Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X182Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER35_LUT1B]
set_property LOC SLICE_X183Y262 [get_cells gtze2_inf_north/RXHEADER35_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER35_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER35_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X182Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER35_FD]
set_property LOC SLICE_X182Y262 [get_cells gtze2_inf_north/RXHEADER35_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER35_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER34_LUT1A]
set_property LOC SLICE_X183Y267 [get_cells gtze2_inf_north/RXHEADER34_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER34_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER34_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X182Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X182Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X182Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER34_LUT1B]
set_property LOC SLICE_X183Y267 [get_cells gtze2_inf_north/RXHEADER34_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER34_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER34_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X182Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER34_FD]
set_property LOC SLICE_X182Y267 [get_cells gtze2_inf_north/RXHEADER34_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER34_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER33_LUT1A]
set_property LOC SLICE_X185Y262 [get_cells gtze2_inf_north/RXHEADER33_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER33_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER33_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X184Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X184Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X184Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER33_LUT1B]
set_property LOC SLICE_X185Y262 [get_cells gtze2_inf_north/RXHEADER33_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER33_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER33_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X184Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER33_FD]
set_property LOC SLICE_X184Y262 [get_cells gtze2_inf_north/RXHEADER33_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER33_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1150_LUT1B]
set_property LOC SLICE_X129Y260 [get_cells gtze2_inf_north/TXDATA1150_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1150_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1150_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X129Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1150_FD]
set_property LOC SLICE_X129Y260 [get_cells gtze2_inf_north/TXDATA1150_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1150_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1149_LUT1B]
set_property LOC SLICE_X129Y260 [get_cells gtze2_inf_north/TXDATA1149_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1149_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1149_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1149_FD]
set_property LOC SLICE_X129Y260 [get_cells gtze2_inf_north/TXDATA1149_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1149_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1148_LUT1B]
set_property LOC SLICE_X129Y260 [get_cells gtze2_inf_north/TXDATA1148_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1148_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1148_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1148_FD]
set_property LOC SLICE_X129Y260 [get_cells gtze2_inf_north/TXDATA1148_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1148_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1147_LUT1B]
set_property LOC SLICE_X129Y265 [get_cells gtze2_inf_north/TXDATA1147_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1147_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1147_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X129Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1147_FD]
set_property LOC SLICE_X129Y265 [get_cells gtze2_inf_north/TXDATA1147_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1147_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1146_LUT1B]
set_property LOC SLICE_X129Y265 [get_cells gtze2_inf_north/TXDATA1146_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1146_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1146_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1146_FD]
set_property LOC SLICE_X129Y265 [get_cells gtze2_inf_north/TXDATA1146_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1146_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1145_LUT1B]
set_property LOC SLICE_X129Y265 [get_cells gtze2_inf_north/TXDATA1145_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1145_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1145_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1145_FD]
set_property LOC SLICE_X129Y265 [get_cells gtze2_inf_north/TXDATA1145_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1145_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1144_LUT1B]
set_property LOC SLICE_X129Y265 [get_cells gtze2_inf_north/TXDATA1144_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1144_FD]
set_property LOC SLICE_X129Y265 [get_cells gtze2_inf_north/TXDATA1144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1144_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1143_LUT1B]
set_property LOC SLICE_X129Y270 [get_cells gtze2_inf_north/TXDATA1143_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X129Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1143_FD]
set_property LOC SLICE_X129Y270 [get_cells gtze2_inf_north/TXDATA1143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1143_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1142_LUT1B]
set_property LOC SLICE_X129Y270 [get_cells gtze2_inf_north/TXDATA1142_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1142_FD]
set_property LOC SLICE_X129Y270 [get_cells gtze2_inf_north/TXDATA1142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1142_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1141_LUT1B]
set_property LOC SLICE_X129Y270 [get_cells gtze2_inf_north/TXDATA1141_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1141_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1141_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1141_FD]
set_property LOC SLICE_X129Y270 [get_cells gtze2_inf_north/TXDATA1141_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1141_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1140_LUT1B]
set_property LOC SLICE_X129Y270 [get_cells gtze2_inf_north/TXDATA1140_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1140_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1140_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1140_FD]
set_property LOC SLICE_X129Y270 [get_cells gtze2_inf_north/TXDATA1140_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1140_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1139_LUT1B]
set_property LOC SLICE_X129Y275 [get_cells gtze2_inf_north/TXDATA1139_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1139_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1139_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X129Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1139_FD]
set_property LOC SLICE_X129Y275 [get_cells gtze2_inf_north/TXDATA1139_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1139_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1138_LUT1B]
set_property LOC SLICE_X129Y275 [get_cells gtze2_inf_north/TXDATA1138_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1138_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1138_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1138_FD]
set_property LOC SLICE_X129Y275 [get_cells gtze2_inf_north/TXDATA1138_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1138_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1137_LUT1B]
set_property LOC SLICE_X129Y275 [get_cells gtze2_inf_north/TXDATA1137_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1137_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1137_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1137_FD]
set_property LOC SLICE_X129Y275 [get_cells gtze2_inf_north/TXDATA1137_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1137_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1136_LUT1B]
set_property LOC SLICE_X129Y275 [get_cells gtze2_inf_north/TXDATA1136_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1136_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1136_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1136_FD]
set_property LOC SLICE_X129Y275 [get_cells gtze2_inf_north/TXDATA1136_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1136_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1135_LUT1B]
set_property LOC SLICE_X129Y280 [get_cells gtze2_inf_north/TXDATA1135_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1135_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1135_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y280/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1135_FD]
set_property LOC SLICE_X129Y280 [get_cells gtze2_inf_north/TXDATA1135_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1135_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1134_LUT1B]
set_property LOC SLICE_X129Y280 [get_cells gtze2_inf_north/TXDATA1134_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1134_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1134_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1134_FD]
set_property LOC SLICE_X129Y280 [get_cells gtze2_inf_north/TXDATA1134_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1134_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0159_LUT1B]
set_property LOC SLICE_X97Y250 [get_cells gtze2_inf_north/TXDATA0159_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0159_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0159_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y250/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0159_FD]
set_property LOC SLICE_X97Y250 [get_cells gtze2_inf_north/TXDATA0159_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0159_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0158_LUT1B]
set_property LOC SLICE_X97Y250 [get_cells gtze2_inf_north/TXDATA0158_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0158_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0158_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0158_FD]
set_property LOC SLICE_X97Y250 [get_cells gtze2_inf_north/TXDATA0158_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0158_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0157_LUT1B]
set_property LOC SLICE_X97Y250 [get_cells gtze2_inf_north/TXDATA0157_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0157_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0157_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0157_FD]
set_property LOC SLICE_X97Y250 [get_cells gtze2_inf_north/TXDATA0157_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0157_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1159_LUT1B]
set_property LOC SLICE_X129Y250 [get_cells gtze2_inf_north/TXDATA1159_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1159_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1159_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X129Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1159_FD]
set_property LOC SLICE_X129Y250 [get_cells gtze2_inf_north/TXDATA1159_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1159_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1158_LUT1B]
set_property LOC SLICE_X129Y250 [get_cells gtze2_inf_north/TXDATA1158_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1158_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1158_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1158_FD]
set_property LOC SLICE_X129Y250 [get_cells gtze2_inf_north/TXDATA1158_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1158_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1157_LUT1B]
set_property LOC SLICE_X129Y250 [get_cells gtze2_inf_north/TXDATA1157_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1157_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1157_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1157_FD]
set_property LOC SLICE_X129Y250 [get_cells gtze2_inf_north/TXDATA1157_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1157_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1156_LUT1B]
set_property LOC SLICE_X129Y250 [get_cells gtze2_inf_north/TXDATA1156_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1156_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1156_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1156_FD]
set_property LOC SLICE_X129Y250 [get_cells gtze2_inf_north/TXDATA1156_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1156_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1155_LUT1B]
set_property LOC SLICE_X129Y255 [get_cells gtze2_inf_north/TXDATA1155_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1155_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1155_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X129Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1155_FD]
set_property LOC SLICE_X129Y255 [get_cells gtze2_inf_north/TXDATA1155_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1155_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA1154_LUT1B]
set_property LOC SLICE_X129Y255 [get_cells gtze2_inf_north/TXDATA1154_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1154_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1154_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA1154_FD]
set_property LOC SLICE_X129Y255 [get_cells gtze2_inf_north/TXDATA1154_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1154_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA1153_LUT1B]
set_property LOC SLICE_X129Y255 [get_cells gtze2_inf_north/TXDATA1153_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA1153_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1153_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA1153_FD]
set_property LOC SLICE_X129Y255 [get_cells gtze2_inf_north/TXDATA1153_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1153_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA1152_LUT1B]
set_property LOC SLICE_X129Y255 [get_cells gtze2_inf_north/TXDATA1152_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1152_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1152_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA1152_FD]
set_property LOC SLICE_X129Y255 [get_cells gtze2_inf_north/TXDATA1152_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1152_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA1151_LUT1B]
set_property LOC SLICE_X129Y260 [get_cells gtze2_inf_north/TXDATA1151_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA1151_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1151_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X129Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA1151_FD]
set_property LOC SLICE_X129Y260 [get_cells gtze2_inf_north/TXDATA1151_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA1151_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER32_LUT1B]
set_property LOC SLICE_X174Y280 [get_cells gtze2_inf_north/TXHEADER32_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER32_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER32_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X174Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X174Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER32_FD]
set_property LOC SLICE_X174Y280 [get_cells gtze2_inf_north/TXHEADER32_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER32_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER31_LUT1B]
set_property LOC SLICE_X176Y285 [get_cells gtze2_inf_north/TXHEADER31_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X176Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X176Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER31_FD]
set_property LOC SLICE_X176Y285 [get_cells gtze2_inf_north/TXHEADER31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER31_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER30_LUT1B]
set_property LOC SLICE_X176Y280 [get_cells gtze2_inf_north/TXHEADER30_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X176Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X176Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER30_FD]
set_property LOC SLICE_X176Y280 [get_cells gtze2_inf_north/TXHEADER30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER30_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE36_LUT1B]
set_property LOC SLICE_X168Y265 [get_cells gtze2_inf_north/TXSEQUENCE36_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE36_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE36_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X168Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X168Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE36_FD]
set_property LOC SLICE_X168Y265 [get_cells gtze2_inf_north/TXSEQUENCE36_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE36_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE35_LUT1B]
set_property LOC SLICE_X170Y265 [get_cells gtze2_inf_north/TXSEQUENCE35_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE35_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE35_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X170Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X170Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE35_FD]
set_property LOC SLICE_X170Y265 [get_cells gtze2_inf_north/TXSEQUENCE35_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE35_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE34_LUT1B]
set_property LOC SLICE_X172Y265 [get_cells gtze2_inf_north/TXSEQUENCE34_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE34_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE34_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X172Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X172Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE34_FD]
set_property LOC SLICE_X172Y265 [get_cells gtze2_inf_north/TXSEQUENCE34_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE34_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE33_LUT1B]
set_property LOC SLICE_X174Y265 [get_cells gtze2_inf_north/TXSEQUENCE33_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE33_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE33_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X174Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X174Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE33_FD]
set_property LOC SLICE_X174Y265 [get_cells gtze2_inf_north/TXSEQUENCE33_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE33_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE32_LUT1B]
set_property LOC SLICE_X176Y265 [get_cells gtze2_inf_north/TXSEQUENCE32_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE32_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE32_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X176Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X176Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE32_FD]
set_property LOC SLICE_X176Y265 [get_cells gtze2_inf_north/TXSEQUENCE32_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE32_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE31_LUT1B]
set_property LOC SLICE_X168Y260 [get_cells gtze2_inf_north/TXSEQUENCE31_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X168Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X168Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE31_FD]
set_property LOC SLICE_X168Y260 [get_cells gtze2_inf_north/TXSEQUENCE31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE31_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE30_LUT1B]
set_property LOC SLICE_X170Y260 [get_cells gtze2_inf_north/TXSEQUENCE30_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X170Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X170Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE30_FD]
set_property LOC SLICE_X170Y260 [get_cells gtze2_inf_north/TXSEQUENCE30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE30_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER09_LUT1B]
set_property LOC SLICE_X96Y285 [get_cells gtze2_inf_north/TXHEADER09_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER09_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER09_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X96Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X96Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER09_FD]
set_property LOC SLICE_X96Y285 [get_cells gtze2_inf_north/TXHEADER09_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER09_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER08_LUT1B]
set_property LOC SLICE_X96Y280 [get_cells gtze2_inf_north/TXHEADER08_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER08_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER08_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X96Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X96Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER08_FD]
set_property LOC SLICE_X96Y280 [get_cells gtze2_inf_north/TXHEADER08_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER08_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER07_LUT1B]
set_property LOC SLICE_X98Y285 [get_cells gtze2_inf_north/TXHEADER07_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER07_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER07_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X98Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X98Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER07_FD]
set_property LOC SLICE_X98Y285 [get_cells gtze2_inf_north/TXHEADER07_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER07_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER06_LUT1B]
set_property LOC SLICE_X98Y280 [get_cells gtze2_inf_north/TXHEADER06_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER06_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER06_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X98Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X98Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER06_FD]
set_property LOC SLICE_X98Y280 [get_cells gtze2_inf_north/TXHEADER06_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER06_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER05_LUT1B]
set_property LOC SLICE_X100Y285 [get_cells gtze2_inf_north/TXHEADER05_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER05_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER05_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X100Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X100Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER05_FD]
set_property LOC SLICE_X100Y285 [get_cells gtze2_inf_north/TXHEADER05_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER05_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER04_LUT1B]
set_property LOC SLICE_X100Y280 [get_cells gtze2_inf_north/TXHEADER04_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER04_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER04_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X100Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X100Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER04_FD]
set_property LOC SLICE_X100Y280 [get_cells gtze2_inf_north/TXHEADER04_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER04_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER03_LUT1B]
set_property LOC SLICE_X102Y285 [get_cells gtze2_inf_north/TXHEADER03_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER03_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER03_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X102Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X102Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER03_FD]
set_property LOC SLICE_X102Y285 [get_cells gtze2_inf_north/TXHEADER03_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER03_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER02_LUT1B]
set_property LOC SLICE_X102Y280 [get_cells gtze2_inf_north/TXHEADER02_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER02_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER02_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X102Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X102Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER02_FD]
set_property LOC SLICE_X102Y280 [get_cells gtze2_inf_north/TXHEADER02_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER02_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER01_LUT1B]
set_property LOC SLICE_X116Y285 [get_cells gtze2_inf_north/TXHEADER01_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER01_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER01_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X116Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X116Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER01_FD]
set_property LOC SLICE_X116Y285 [get_cells gtze2_inf_north/TXHEADER01_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER01_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER00_LUT1B]
set_property LOC SLICE_X116Y280 [get_cells gtze2_inf_north/TXHEADER00_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER00_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER00_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X116Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X116Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER00_FD]
set_property LOC SLICE_X116Y280 [get_cells gtze2_inf_north/TXHEADER00_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER00_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER39_LUT1B]
set_property LOC SLICE_X168Y285 [get_cells gtze2_inf_north/TXHEADER39_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER39_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER39_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X168Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X168Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER39_FD]
set_property LOC SLICE_X168Y285 [get_cells gtze2_inf_north/TXHEADER39_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER39_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER38_LUT1B]
set_property LOC SLICE_X168Y280 [get_cells gtze2_inf_north/TXHEADER38_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER38_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER38_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X168Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X168Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER38_FD]
set_property LOC SLICE_X168Y280 [get_cells gtze2_inf_north/TXHEADER38_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER38_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER37_LUT1B]
set_property LOC SLICE_X170Y285 [get_cells gtze2_inf_north/TXHEADER37_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER37_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER37_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X170Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X170Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER37_FD]
set_property LOC SLICE_X170Y285 [get_cells gtze2_inf_north/TXHEADER37_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER37_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER36_LUT1B]
set_property LOC SLICE_X170Y280 [get_cells gtze2_inf_north/TXHEADER36_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER36_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER36_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X170Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X170Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER36_FD]
set_property LOC SLICE_X170Y280 [get_cells gtze2_inf_north/TXHEADER36_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER36_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER35_LUT1B]
set_property LOC SLICE_X172Y285 [get_cells gtze2_inf_north/TXHEADER35_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER35_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER35_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X172Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X172Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER35_FD]
set_property LOC SLICE_X172Y285 [get_cells gtze2_inf_north/TXHEADER35_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER35_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER34_LUT1B]
set_property LOC SLICE_X172Y280 [get_cells gtze2_inf_north/TXHEADER34_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER34_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER34_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X172Y280/D5FF]
set_property PROHIBIT true [get_bels SLICE_X172Y280/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER34_FD]
set_property LOC SLICE_X172Y280 [get_cells gtze2_inf_north/TXHEADER34_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER34_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXHEADER33_LUT1B]
set_property LOC SLICE_X174Y285 [get_cells gtze2_inf_north/TXHEADER33_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXHEADER33_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER33_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X174Y285/D5FF]
set_property PROHIBIT true [get_bels SLICE_X174Y285/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXHEADER33_FD]
set_property LOC SLICE_X174Y285 [get_cells gtze2_inf_north/TXHEADER33_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXHEADER33_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA049_LUT1B]
set_property LOC SLICE_X103Y265 [get_cells gtze2_inf_north/TXDATA049_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA049_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA049_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA049_FD]
set_property LOC SLICE_X103Y265 [get_cells gtze2_inf_north/TXDATA049_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA049_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA048_LUT1B]
set_property LOC SLICE_X103Y265 [get_cells gtze2_inf_north/TXDATA048_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA048_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA048_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA048_FD]
set_property LOC SLICE_X103Y265 [get_cells gtze2_inf_north/TXDATA048_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA048_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA047_LUT1B]
set_property LOC SLICE_X103Y270 [get_cells gtze2_inf_north/TXDATA047_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA047_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA047_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X103Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA047_FD]
set_property LOC SLICE_X103Y270 [get_cells gtze2_inf_north/TXDATA047_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA047_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA046_LUT1B]
set_property LOC SLICE_X103Y270 [get_cells gtze2_inf_north/TXDATA046_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA046_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA046_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA046_FD]
set_property LOC SLICE_X103Y270 [get_cells gtze2_inf_north/TXDATA046_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA046_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA045_LUT1B]
set_property LOC SLICE_X103Y270 [get_cells gtze2_inf_north/TXDATA045_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA045_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA045_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA045_FD]
set_property LOC SLICE_X103Y270 [get_cells gtze2_inf_north/TXDATA045_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA045_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA044_LUT1B]
set_property LOC SLICE_X103Y270 [get_cells gtze2_inf_north/TXDATA044_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA044_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA044_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA044_FD]
set_property LOC SLICE_X103Y270 [get_cells gtze2_inf_north/TXDATA044_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA044_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA043_LUT1B]
set_property LOC SLICE_X103Y275 [get_cells gtze2_inf_north/TXDATA043_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA043_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA043_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y275/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA043_FD]
set_property LOC SLICE_X103Y275 [get_cells gtze2_inf_north/TXDATA043_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA043_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA042_LUT1B]
set_property LOC SLICE_X103Y275 [get_cells gtze2_inf_north/TXDATA042_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA042_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA042_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA042_FD]
set_property LOC SLICE_X103Y275 [get_cells gtze2_inf_north/TXDATA042_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA042_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA041_LUT1B]
set_property LOC SLICE_X103Y275 [get_cells gtze2_inf_north/TXDATA041_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA041_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA041_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X103Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA041_FD]
set_property LOC SLICE_X103Y275 [get_cells gtze2_inf_north/TXDATA041_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA041_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0130_LUT1B]
set_property LOC SLICE_X97Y285 [get_cells gtze2_inf_north/TXDATA0130_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0130_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0130_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0130_FD]
set_property LOC SLICE_X97Y285 [get_cells gtze2_inf_north/TXDATA0130_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0130_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0129_LUT1B]
set_property LOC SLICE_X97Y285 [get_cells gtze2_inf_north/TXDATA0129_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0129_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0129_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0129_FD]
set_property LOC SLICE_X97Y285 [get_cells gtze2_inf_north/TXDATA0129_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0129_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0128_LUT1B]
set_property LOC SLICE_X97Y285 [get_cells gtze2_inf_north/TXDATA0128_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0128_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0128_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X97Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0128_FD]
set_property LOC SLICE_X97Y285 [get_cells gtze2_inf_north/TXDATA0128_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0128_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE06_LUT1B]
set_property LOC SLICE_X96Y265 [get_cells gtze2_inf_north/TXSEQUENCE06_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE06_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE06_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X96Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X96Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE06_FD]
set_property LOC SLICE_X96Y265 [get_cells gtze2_inf_north/TXSEQUENCE06_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE06_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE05_LUT1B]
set_property LOC SLICE_X98Y265 [get_cells gtze2_inf_north/TXSEQUENCE05_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE05_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE05_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X98Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X98Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE05_FD]
set_property LOC SLICE_X98Y265 [get_cells gtze2_inf_north/TXSEQUENCE05_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE05_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE04_LUT1B]
set_property LOC SLICE_X100Y265 [get_cells gtze2_inf_north/TXSEQUENCE04_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE04_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE04_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X100Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X100Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE04_FD]
set_property LOC SLICE_X100Y265 [get_cells gtze2_inf_north/TXSEQUENCE04_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE04_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE03_LUT1B]
set_property LOC SLICE_X102Y265 [get_cells gtze2_inf_north/TXSEQUENCE03_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE03_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE03_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X102Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X102Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE03_FD]
set_property LOC SLICE_X102Y265 [get_cells gtze2_inf_north/TXSEQUENCE03_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE03_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE02_LUT1B]
set_property LOC SLICE_X116Y265 [get_cells gtze2_inf_north/TXSEQUENCE02_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE02_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE02_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X116Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X116Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE02_FD]
set_property LOC SLICE_X116Y265 [get_cells gtze2_inf_north/TXSEQUENCE02_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE02_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE01_LUT1B]
set_property LOC SLICE_X96Y260 [get_cells gtze2_inf_north/TXSEQUENCE01_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE01_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE01_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X96Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X96Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE01_FD]
set_property LOC SLICE_X96Y260 [get_cells gtze2_inf_north/TXSEQUENCE01_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE01_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE00_LUT1B]
set_property LOC SLICE_X98Y260 [get_cells gtze2_inf_north/TXSEQUENCE00_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE00_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE00_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X98Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X98Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE00_FD]
set_property LOC SLICE_X98Y260 [get_cells gtze2_inf_north/TXSEQUENCE00_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE00_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATAVALID24_LUT1A]
set_property LOC SLICE_X159Y272 [get_cells gtze2_inf_north/RXDATAVALID24_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATAVALID24_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID24_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X158Y272/BFF]
set_property PROHIBIT true [get_bels SLICE_X158Y272/B5FF]
set_property PROHIBIT true [get_bels SLICE_X158Y272/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATAVALID24_LUT1B]
set_property LOC SLICE_X159Y272 [get_cells gtze2_inf_north/RXDATAVALID24_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATAVALID24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X158Y272/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATAVALID24_FD]
set_property LOC SLICE_X158Y272 [get_cells gtze2_inf_north/RXDATAVALID24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATAVALID24_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2112_LUT1A]
set_property LOC SLICE_X160Y277 [get_cells gtze2_inf_north/RXDATA2112_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2112_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2112_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2112_LUT1B]
set_property LOC SLICE_X160Y277 [get_cells gtze2_inf_north/RXDATA2112_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2112_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2112_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y277/A5FF]
set_property PROHIBIT true [get_bels SLICE_X161Y277/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2112_FD]
set_property LOC SLICE_X161Y277 [get_cells gtze2_inf_north/RXDATA2112_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2112_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2111_LUT1A]
set_property LOC SLICE_X160Y282 [get_cells gtze2_inf_north/RXDATA2111_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2111_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2111_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2111_LUT1B]
set_property LOC SLICE_X160Y282 [get_cells gtze2_inf_north/RXDATA2111_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2111_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2111_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y282/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2111_FD]
set_property LOC SLICE_X161Y282 [get_cells gtze2_inf_north/RXDATA2111_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2111_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2110_LUT1A]
set_property LOC SLICE_X160Y282 [get_cells gtze2_inf_north/RXDATA2110_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2110_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2110_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2110_LUT1B]
set_property LOC SLICE_X160Y282 [get_cells gtze2_inf_north/RXDATA2110_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2110_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2110_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y282/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2110_FD]
set_property LOC SLICE_X161Y282 [get_cells gtze2_inf_north/RXDATA2110_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2110_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2109_LUT1A]
set_property LOC SLICE_X160Y282 [get_cells gtze2_inf_north/RXDATA2109_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2109_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2109_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2109_LUT1B]
set_property LOC SLICE_X160Y282 [get_cells gtze2_inf_north/RXDATA2109_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2109_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2109_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y282/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2109_FD]
set_property LOC SLICE_X161Y282 [get_cells gtze2_inf_north/RXDATA2109_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2109_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2124_LUT1A]
set_property LOC SLICE_X160Y262 [get_cells gtze2_inf_north/RXDATA2124_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2124_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2124_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2124_LUT1B]
set_property LOC SLICE_X160Y262 [get_cells gtze2_inf_north/RXDATA2124_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2124_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2124_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y262/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2124_FD]
set_property LOC SLICE_X161Y262 [get_cells gtze2_inf_north/RXDATA2124_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2124_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2123_LUT1A]
set_property LOC SLICE_X160Y267 [get_cells gtze2_inf_north/RXDATA2123_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2123_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2123_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2123_LUT1B]
set_property LOC SLICE_X160Y267 [get_cells gtze2_inf_north/RXDATA2123_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2123_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2123_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y267/C5FF]
set_property PROHIBIT true [get_bels SLICE_X161Y267/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2123_FD]
set_property LOC SLICE_X161Y267 [get_cells gtze2_inf_north/RXDATA2123_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2123_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2122_LUT1A]
set_property LOC SLICE_X160Y267 [get_cells gtze2_inf_north/RXDATA2122_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2122_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2122_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2122_LUT1B]
set_property LOC SLICE_X160Y267 [get_cells gtze2_inf_north/RXDATA2122_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2122_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2122_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y267/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2122_FD]
set_property LOC SLICE_X161Y267 [get_cells gtze2_inf_north/RXDATA2122_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2122_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2121_LUT1A]
set_property LOC SLICE_X160Y267 [get_cells gtze2_inf_north/RXDATA2121_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2121_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2121_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2121_LUT1B]
set_property LOC SLICE_X160Y267 [get_cells gtze2_inf_north/RXDATA2121_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2121_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2121_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y267/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2121_FD]
set_property LOC SLICE_X161Y267 [get_cells gtze2_inf_north/RXDATA2121_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2121_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2120_LUT1A]
set_property LOC SLICE_X160Y267 [get_cells gtze2_inf_north/RXDATA2120_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2120_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2120_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2120_LUT1B]
set_property LOC SLICE_X160Y267 [get_cells gtze2_inf_north/RXDATA2120_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2120_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2120_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y267/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2120_FD]
set_property LOC SLICE_X161Y267 [get_cells gtze2_inf_north/RXDATA2120_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2120_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2119_LUT1A]
set_property LOC SLICE_X160Y272 [get_cells gtze2_inf_north/RXDATA2119_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2119_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2119_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2119_LUT1B]
set_property LOC SLICE_X160Y272 [get_cells gtze2_inf_north/RXDATA2119_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2119_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2119_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y272/C5FF]
set_property PROHIBIT true [get_bels SLICE_X161Y272/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2119_FD]
set_property LOC SLICE_X161Y272 [get_cells gtze2_inf_north/RXDATA2119_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2119_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2118_LUT1A]
set_property LOC SLICE_X160Y272 [get_cells gtze2_inf_north/RXDATA2118_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2118_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2118_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2118_LUT1B]
set_property LOC SLICE_X160Y272 [get_cells gtze2_inf_north/RXDATA2118_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2118_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2118_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y272/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2118_FD]
set_property LOC SLICE_X161Y272 [get_cells gtze2_inf_north/RXDATA2118_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2118_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2117_LUT1A]
set_property LOC SLICE_X160Y272 [get_cells gtze2_inf_north/RXDATA2117_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2117_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2117_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2117_LUT1B]
set_property LOC SLICE_X160Y272 [get_cells gtze2_inf_north/RXDATA2117_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2117_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2117_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y272/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2117_FD]
set_property LOC SLICE_X161Y272 [get_cells gtze2_inf_north/RXDATA2117_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2117_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3105_LUT1B]
set_property LOC SLICE_X171Y275 [get_cells gtze2_inf_north/TXDATA3105_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3105_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3105_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y275/A5FF]
set_property PROHIBIT true [get_bels SLICE_X171Y275/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3105_FD]
set_property LOC SLICE_X171Y275 [get_cells gtze2_inf_north/TXDATA3105_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3105_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3104_LUT1B]
set_property LOC SLICE_X171Y275 [get_cells gtze2_inf_north/TXDATA3104_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3104_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3104_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3104_FD]
set_property LOC SLICE_X171Y275 [get_cells gtze2_inf_north/TXDATA3104_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3104_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3103_LUT1B]
set_property LOC SLICE_X171Y280 [get_cells gtze2_inf_north/TXDATA3103_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3103_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3103_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X171Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3103_FD]
set_property LOC SLICE_X171Y280 [get_cells gtze2_inf_north/TXDATA3103_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3103_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3102_LUT1B]
set_property LOC SLICE_X171Y280 [get_cells gtze2_inf_north/TXDATA3102_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3102_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3102_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3102_FD]
set_property LOC SLICE_X171Y280 [get_cells gtze2_inf_north/TXDATA3102_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3102_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3101_LUT1B]
set_property LOC SLICE_X171Y280 [get_cells gtze2_inf_north/TXDATA3101_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3101_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3101_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3101_FD]
set_property LOC SLICE_X171Y280 [get_cells gtze2_inf_north/TXDATA3101_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3101_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3100_LUT1B]
set_property LOC SLICE_X171Y280 [get_cells gtze2_inf_north/TXDATA3100_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3100_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3100_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3100_FD]
set_property LOC SLICE_X171Y280 [get_cells gtze2_inf_north/TXDATA3100_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3100_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA399_LUT1B]
set_property LOC SLICE_X171Y285 [get_cells gtze2_inf_north/TXDATA399_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA399_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA399_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X171Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA399_FD]
set_property LOC SLICE_X171Y285 [get_cells gtze2_inf_north/TXDATA399_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA399_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA398_LUT1B]
set_property LOC SLICE_X171Y285 [get_cells gtze2_inf_north/TXDATA398_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA398_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA398_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA398_FD]
set_property LOC SLICE_X171Y285 [get_cells gtze2_inf_north/TXDATA398_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA398_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA397_LUT1B]
set_property LOC SLICE_X171Y285 [get_cells gtze2_inf_north/TXDATA397_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA397_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA397_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA397_FD]
set_property LOC SLICE_X171Y285 [get_cells gtze2_inf_north/TXDATA397_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA397_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA396_LUT1B]
set_property LOC SLICE_X171Y285 [get_cells gtze2_inf_north/TXDATA396_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA396_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA396_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA396_FD]
set_property LOC SLICE_X171Y285 [get_cells gtze2_inf_north/TXDATA396_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA396_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA395_LUT1B]
set_property LOC SLICE_X173Y250 [get_cells gtze2_inf_north/TXDATA395_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA395_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA395_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y250/C5FF]
set_property PROHIBIT true [get_bels SLICE_X173Y250/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA395_FD]
set_property LOC SLICE_X173Y250 [get_cells gtze2_inf_north/TXDATA395_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA395_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA394_LUT1B]
set_property LOC SLICE_X173Y250 [get_cells gtze2_inf_north/TXDATA394_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA394_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA394_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y250/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA394_FD]
set_property LOC SLICE_X173Y250 [get_cells gtze2_inf_north/TXDATA394_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA394_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA393_LUT1B]
set_property LOC SLICE_X173Y250 [get_cells gtze2_inf_north/TXDATA393_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA393_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA393_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA393_FD]
set_property LOC SLICE_X173Y250 [get_cells gtze2_inf_north/TXDATA393_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA393_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA392_LUT1B]
set_property LOC SLICE_X173Y250 [get_cells gtze2_inf_north/TXDATA392_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA392_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA392_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA392_FD]
set_property LOC SLICE_X173Y250 [get_cells gtze2_inf_north/TXDATA392_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA392_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA391_LUT1B]
set_property LOC SLICE_X173Y255 [get_cells gtze2_inf_north/TXDATA391_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA391_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA391_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X173Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA391_FD]
set_property LOC SLICE_X173Y255 [get_cells gtze2_inf_north/TXDATA391_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA391_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA390_LUT1B]
set_property LOC SLICE_X173Y255 [get_cells gtze2_inf_north/TXDATA390_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA390_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA390_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA390_FD]
set_property LOC SLICE_X173Y255 [get_cells gtze2_inf_north/TXDATA390_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA390_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA389_LUT1B]
set_property LOC SLICE_X173Y255 [get_cells gtze2_inf_north/TXDATA389_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA389_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA389_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA389_FD]
set_property LOC SLICE_X173Y255 [get_cells gtze2_inf_north/TXDATA389_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA389_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA388_LUT1B]
set_property LOC SLICE_X173Y255 [get_cells gtze2_inf_north/TXDATA388_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA388_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA388_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA388_FD]
set_property LOC SLICE_X173Y255 [get_cells gtze2_inf_north/TXDATA388_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA388_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA387_LUT1B]
set_property LOC SLICE_X173Y260 [get_cells gtze2_inf_north/TXDATA387_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA387_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA387_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y260/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA387_FD]
set_property LOC SLICE_X173Y260 [get_cells gtze2_inf_north/TXDATA387_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA387_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA386_LUT1B]
set_property LOC SLICE_X173Y260 [get_cells gtze2_inf_north/TXDATA386_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA386_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA386_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X173Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA386_FD]
set_property LOC SLICE_X173Y260 [get_cells gtze2_inf_north/TXDATA386_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA386_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXRESETDONE3_LUT1A]
set_property LOC SLICE_X181Y287 [get_cells gtze2_inf_north/RXRESETDONE3_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXRESETDONE3_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE3_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X180Y287/BFF]
set_property PROHIBIT true [get_bels SLICE_X180Y287/B5FF]
set_property PROHIBIT true [get_bels SLICE_X180Y287/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXRESETDONE3_LUT1B]
set_property LOC SLICE_X181Y287 [get_cells gtze2_inf_north/RXRESETDONE3_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXRESETDONE3_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE3_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X180Y287/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXRESETDONE3_FD]
set_property LOC SLICE_X180Y287 [get_cells gtze2_inf_north/RXRESETDONE3_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXRESETDONE3_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA2116_LUT1A]
set_property LOC SLICE_X160Y272 [get_cells gtze2_inf_north/RXDATA2116_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA2116_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2116_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA2116_LUT1B]
set_property LOC SLICE_X160Y272 [get_cells gtze2_inf_north/RXDATA2116_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2116_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2116_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y272/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA2116_FD]
set_property LOC SLICE_X161Y272 [get_cells gtze2_inf_north/RXDATA2116_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2116_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA2115_LUT1A]
set_property LOC SLICE_X160Y277 [get_cells gtze2_inf_north/RXDATA2115_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2115_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2115_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA2115_LUT1B]
set_property LOC SLICE_X160Y277 [get_cells gtze2_inf_north/RXDATA2115_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2115_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2115_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA2115_FD]
set_property LOC SLICE_X161Y277 [get_cells gtze2_inf_north/RXDATA2115_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2115_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA2114_LUT1A]
set_property LOC SLICE_X160Y277 [get_cells gtze2_inf_north/RXDATA2114_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2114_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2114_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA2114_LUT1B]
set_property LOC SLICE_X160Y277 [get_cells gtze2_inf_north/RXDATA2114_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA2114_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2114_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y277/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA2114_FD]
set_property LOC SLICE_X161Y277 [get_cells gtze2_inf_north/RXDATA2114_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2114_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA2113_LUT1A]
set_property LOC SLICE_X160Y277 [get_cells gtze2_inf_north/RXDATA2113_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA2113_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2113_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA2113_LUT1B]
set_property LOC SLICE_X160Y277 [get_cells gtze2_inf_north/RXDATA2113_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA2113_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2113_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X161Y277/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA2113_FD]
set_property LOC SLICE_X161Y277 [get_cells gtze2_inf_north/RXDATA2113_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA2113_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3126_LUT1B]
set_property LOC SLICE_X171Y250 [get_cells gtze2_inf_north/TXDATA3126_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3126_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3126_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y250/D5FF]
set_property PROHIBIT true [get_bels SLICE_X171Y250/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3126_FD]
set_property LOC SLICE_X171Y250 [get_cells gtze2_inf_north/TXDATA3126_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3126_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3125_LUT1B]
set_property LOC SLICE_X171Y250 [get_cells gtze2_inf_north/TXDATA3125_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3125_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3125_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3125_FD]
set_property LOC SLICE_X171Y250 [get_cells gtze2_inf_north/TXDATA3125_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3125_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3124_LUT1B]
set_property LOC SLICE_X171Y250 [get_cells gtze2_inf_north/TXDATA3124_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3124_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3124_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3124_FD]
set_property LOC SLICE_X171Y250 [get_cells gtze2_inf_north/TXDATA3124_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3124_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3123_LUT1B]
set_property LOC SLICE_X171Y255 [get_cells gtze2_inf_north/TXDATA3123_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3123_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3123_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X171Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3123_FD]
set_property LOC SLICE_X171Y255 [get_cells gtze2_inf_north/TXDATA3123_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3123_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3122_LUT1B]
set_property LOC SLICE_X171Y255 [get_cells gtze2_inf_north/TXDATA3122_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3122_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3122_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3122_FD]
set_property LOC SLICE_X171Y255 [get_cells gtze2_inf_north/TXDATA3122_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3122_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3121_LUT1B]
set_property LOC SLICE_X171Y255 [get_cells gtze2_inf_north/TXDATA3121_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3121_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3121_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3121_FD]
set_property LOC SLICE_X171Y255 [get_cells gtze2_inf_north/TXDATA3121_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3121_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3120_LUT1B]
set_property LOC SLICE_X171Y255 [get_cells gtze2_inf_north/TXDATA3120_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3120_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3120_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3120_FD]
set_property LOC SLICE_X171Y255 [get_cells gtze2_inf_north/TXDATA3120_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3120_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3119_LUT1B]
set_property LOC SLICE_X171Y260 [get_cells gtze2_inf_north/TXDATA3119_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3119_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3119_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X171Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3119_FD]
set_property LOC SLICE_X171Y260 [get_cells gtze2_inf_north/TXDATA3119_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3119_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3118_LUT1B]
set_property LOC SLICE_X171Y260 [get_cells gtze2_inf_north/TXDATA3118_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3118_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3118_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3118_FD]
set_property LOC SLICE_X171Y260 [get_cells gtze2_inf_north/TXDATA3118_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3118_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3117_LUT1B]
set_property LOC SLICE_X171Y260 [get_cells gtze2_inf_north/TXDATA3117_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3117_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3117_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3117_FD]
set_property LOC SLICE_X171Y260 [get_cells gtze2_inf_north/TXDATA3117_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3117_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3116_LUT1B]
set_property LOC SLICE_X171Y260 [get_cells gtze2_inf_north/TXDATA3116_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3116_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3116_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3116_FD]
set_property LOC SLICE_X171Y260 [get_cells gtze2_inf_north/TXDATA3116_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3116_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3115_LUT1B]
set_property LOC SLICE_X171Y265 [get_cells gtze2_inf_north/TXDATA3115_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3115_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3115_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X171Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3115_FD]
set_property LOC SLICE_X171Y265 [get_cells gtze2_inf_north/TXDATA3115_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3115_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3114_LUT1B]
set_property LOC SLICE_X171Y265 [get_cells gtze2_inf_north/TXDATA3114_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3114_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3114_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3114_FD]
set_property LOC SLICE_X171Y265 [get_cells gtze2_inf_north/TXDATA3114_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3114_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3113_LUT1B]
set_property LOC SLICE_X171Y265 [get_cells gtze2_inf_north/TXDATA3113_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3113_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3113_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3113_FD]
set_property LOC SLICE_X171Y265 [get_cells gtze2_inf_north/TXDATA3113_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3113_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3112_LUT1B]
set_property LOC SLICE_X171Y265 [get_cells gtze2_inf_north/TXDATA3112_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3112_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3112_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3112_FD]
set_property LOC SLICE_X171Y265 [get_cells gtze2_inf_north/TXDATA3112_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3112_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3111_LUT1B]
set_property LOC SLICE_X171Y270 [get_cells gtze2_inf_north/TXDATA3111_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3111_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3111_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X171Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3111_FD]
set_property LOC SLICE_X171Y270 [get_cells gtze2_inf_north/TXDATA3111_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3111_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3110_LUT1B]
set_property LOC SLICE_X171Y270 [get_cells gtze2_inf_north/TXDATA3110_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3110_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3110_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3110_FD]
set_property LOC SLICE_X171Y270 [get_cells gtze2_inf_north/TXDATA3110_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3110_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3109_LUT1B]
set_property LOC SLICE_X171Y270 [get_cells gtze2_inf_north/TXDATA3109_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3109_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3109_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3109_FD]
set_property LOC SLICE_X171Y270 [get_cells gtze2_inf_north/TXDATA3109_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3109_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3108_LUT1B]
set_property LOC SLICE_X171Y270 [get_cells gtze2_inf_north/TXDATA3108_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3108_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3108_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3108_FD]
set_property LOC SLICE_X171Y270 [get_cells gtze2_inf_north/TXDATA3108_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3108_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3107_LUT1B]
set_property LOC SLICE_X171Y275 [get_cells gtze2_inf_north/TXDATA3107_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3107_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3107_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y275/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3107_FD]
set_property LOC SLICE_X171Y275 [get_cells gtze2_inf_north/TXDATA3107_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3107_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3106_LUT1B]
set_property LOC SLICE_X171Y275 [get_cells gtze2_inf_north/TXDATA3106_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3106_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3106_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3106_FD]
set_property LOC SLICE_X171Y275 [get_cells gtze2_inf_north/TXDATA3106_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3106_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3158_LUT1B]
set_property LOC SLICE_X169Y250 [get_cells gtze2_inf_north/TXDATA3158_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3158_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3158_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y250/D5FF]
set_property PROHIBIT true [get_bels SLICE_X169Y250/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3158_FD]
set_property LOC SLICE_X169Y250 [get_cells gtze2_inf_north/TXDATA3158_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3158_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3157_LUT1B]
set_property LOC SLICE_X169Y250 [get_cells gtze2_inf_north/TXDATA3157_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3157_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3157_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y250/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3157_FD]
set_property LOC SLICE_X169Y250 [get_cells gtze2_inf_north/TXDATA3157_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3157_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3156_LUT1B]
set_property LOC SLICE_X169Y250 [get_cells gtze2_inf_north/TXDATA3156_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3156_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3156_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3156_FD]
set_property LOC SLICE_X169Y250 [get_cells gtze2_inf_north/TXDATA3156_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3156_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3155_LUT1B]
set_property LOC SLICE_X169Y255 [get_cells gtze2_inf_north/TXDATA3155_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3155_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3155_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y255/C5FF]
set_property PROHIBIT true [get_bels SLICE_X169Y255/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3155_FD]
set_property LOC SLICE_X169Y255 [get_cells gtze2_inf_north/TXDATA3155_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3155_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3154_LUT1B]
set_property LOC SLICE_X169Y255 [get_cells gtze2_inf_north/TXDATA3154_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3154_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3154_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3154_FD]
set_property LOC SLICE_X169Y255 [get_cells gtze2_inf_north/TXDATA3154_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3154_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3153_LUT1B]
set_property LOC SLICE_X169Y255 [get_cells gtze2_inf_north/TXDATA3153_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3153_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3153_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y255/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3153_FD]
set_property LOC SLICE_X169Y255 [get_cells gtze2_inf_north/TXDATA3153_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3153_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3152_LUT1B]
set_property LOC SLICE_X169Y255 [get_cells gtze2_inf_north/TXDATA3152_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3152_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3152_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y255/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3152_FD]
set_property LOC SLICE_X169Y255 [get_cells gtze2_inf_north/TXDATA3152_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3152_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3151_LUT1B]
set_property LOC SLICE_X169Y260 [get_cells gtze2_inf_north/TXDATA3151_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3151_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3151_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y260/C5FF]
set_property PROHIBIT true [get_bels SLICE_X169Y260/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3151_FD]
set_property LOC SLICE_X169Y260 [get_cells gtze2_inf_north/TXDATA3151_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3151_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3150_LUT1B]
set_property LOC SLICE_X169Y260 [get_cells gtze2_inf_north/TXDATA3150_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3150_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3150_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y260/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3150_FD]
set_property LOC SLICE_X169Y260 [get_cells gtze2_inf_north/TXDATA3150_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3150_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3149_LUT1B]
set_property LOC SLICE_X169Y260 [get_cells gtze2_inf_north/TXDATA3149_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3149_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3149_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y260/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3149_FD]
set_property LOC SLICE_X169Y260 [get_cells gtze2_inf_north/TXDATA3149_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3149_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3148_LUT1B]
set_property LOC SLICE_X169Y260 [get_cells gtze2_inf_north/TXDATA3148_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3148_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3148_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y260/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3148_FD]
set_property LOC SLICE_X169Y260 [get_cells gtze2_inf_north/TXDATA3148_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3148_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3147_LUT1B]
set_property LOC SLICE_X169Y265 [get_cells gtze2_inf_north/TXDATA3147_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3147_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3147_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y265/C5FF]
set_property PROHIBIT true [get_bels SLICE_X169Y265/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3147_FD]
set_property LOC SLICE_X169Y265 [get_cells gtze2_inf_north/TXDATA3147_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3147_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3146_LUT1B]
set_property LOC SLICE_X169Y265 [get_cells gtze2_inf_north/TXDATA3146_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3146_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3146_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y265/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3146_FD]
set_property LOC SLICE_X169Y265 [get_cells gtze2_inf_north/TXDATA3146_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3146_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3145_LUT1B]
set_property LOC SLICE_X169Y265 [get_cells gtze2_inf_north/TXDATA3145_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3145_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3145_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y265/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3145_FD]
set_property LOC SLICE_X169Y265 [get_cells gtze2_inf_north/TXDATA3145_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3145_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3144_LUT1B]
set_property LOC SLICE_X169Y265 [get_cells gtze2_inf_north/TXDATA3144_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y265/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3144_FD]
set_property LOC SLICE_X169Y265 [get_cells gtze2_inf_north/TXDATA3144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3144_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3143_LUT1B]
set_property LOC SLICE_X169Y270 [get_cells gtze2_inf_north/TXDATA3143_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y270/C5FF]
set_property PROHIBIT true [get_bels SLICE_X169Y270/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3143_FD]
set_property LOC SLICE_X169Y270 [get_cells gtze2_inf_north/TXDATA3143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3143_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3142_LUT1B]
set_property LOC SLICE_X169Y270 [get_cells gtze2_inf_north/TXDATA3142_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y270/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3142_FD]
set_property LOC SLICE_X169Y270 [get_cells gtze2_inf_north/TXDATA3142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3142_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3141_LUT1B]
set_property LOC SLICE_X169Y270 [get_cells gtze2_inf_north/TXDATA3141_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3141_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3141_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y270/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3141_FD]
set_property LOC SLICE_X169Y270 [get_cells gtze2_inf_north/TXDATA3141_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3141_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3140_LUT1B]
set_property LOC SLICE_X169Y270 [get_cells gtze2_inf_north/TXDATA3140_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3140_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3140_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y270/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3140_FD]
set_property LOC SLICE_X169Y270 [get_cells gtze2_inf_north/TXDATA3140_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3140_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3139_LUT1B]
set_property LOC SLICE_X169Y275 [get_cells gtze2_inf_north/TXDATA3139_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3139_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3139_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y275/C5FF]
set_property PROHIBIT true [get_bels SLICE_X169Y275/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3139_FD]
set_property LOC SLICE_X169Y275 [get_cells gtze2_inf_north/TXDATA3139_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3139_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3138_LUT1B]
set_property LOC SLICE_X169Y275 [get_cells gtze2_inf_north/TXDATA3138_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3138_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3138_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y275/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3138_FD]
set_property LOC SLICE_X169Y275 [get_cells gtze2_inf_north/TXDATA3138_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3138_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3137_LUT1B]
set_property LOC SLICE_X169Y275 [get_cells gtze2_inf_north/TXDATA3137_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3137_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3137_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y275/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3137_FD]
set_property LOC SLICE_X169Y275 [get_cells gtze2_inf_north/TXDATA3137_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3137_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3136_LUT1B]
set_property LOC SLICE_X169Y275 [get_cells gtze2_inf_north/TXDATA3136_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3136_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3136_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y275/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3136_FD]
set_property LOC SLICE_X169Y275 [get_cells gtze2_inf_north/TXDATA3136_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3136_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3135_LUT1B]
set_property LOC SLICE_X169Y280 [get_cells gtze2_inf_north/TXDATA3135_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3135_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3135_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X169Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3135_FD]
set_property LOC SLICE_X169Y280 [get_cells gtze2_inf_north/TXDATA3135_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3135_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3134_LUT1B]
set_property LOC SLICE_X169Y280 [get_cells gtze2_inf_north/TXDATA3134_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3134_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3134_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3134_FD]
set_property LOC SLICE_X169Y280 [get_cells gtze2_inf_north/TXDATA3134_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3134_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3133_LUT1B]
set_property LOC SLICE_X169Y280 [get_cells gtze2_inf_north/TXDATA3133_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3133_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3133_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3133_FD]
set_property LOC SLICE_X169Y280 [get_cells gtze2_inf_north/TXDATA3133_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3133_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3132_LUT1B]
set_property LOC SLICE_X169Y280 [get_cells gtze2_inf_north/TXDATA3132_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3132_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3132_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3132_FD]
set_property LOC SLICE_X169Y280 [get_cells gtze2_inf_north/TXDATA3132_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3132_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3131_LUT1B]
set_property LOC SLICE_X169Y285 [get_cells gtze2_inf_north/TXDATA3131_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3131_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3131_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X169Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3131_FD]
set_property LOC SLICE_X169Y285 [get_cells gtze2_inf_north/TXDATA3131_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3131_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA3130_LUT1B]
set_property LOC SLICE_X169Y285 [get_cells gtze2_inf_north/TXDATA3130_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3130_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3130_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA3130_FD]
set_property LOC SLICE_X169Y285 [get_cells gtze2_inf_north/TXDATA3130_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3130_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA3129_LUT1B]
set_property LOC SLICE_X169Y285 [get_cells gtze2_inf_north/TXDATA3129_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA3129_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3129_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA3129_FD]
set_property LOC SLICE_X169Y285 [get_cells gtze2_inf_north/TXDATA3129_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3129_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA3128_LUT1B]
set_property LOC SLICE_X169Y285 [get_cells gtze2_inf_north/TXDATA3128_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3128_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3128_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA3128_FD]
set_property LOC SLICE_X169Y285 [get_cells gtze2_inf_north/TXDATA3128_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3128_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3127_LUT1B]
set_property LOC SLICE_X171Y250 [get_cells gtze2_inf_north/TXDATA3127_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3127_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3127_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X171Y250/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3127_FD]
set_property LOC SLICE_X171Y250 [get_cells gtze2_inf_north/TXDATA3127_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3127_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID34_LUT1A]
set_property LOC SLICE_X179Y277 [get_cells gtze2_inf_north/RXHEADERVALID34_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID34_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID34_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X178Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X178Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X178Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID34_LUT1B]
set_property LOC SLICE_X179Y277 [get_cells gtze2_inf_north/RXHEADERVALID34_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID34_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID34_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X178Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID34_FD]
set_property LOC SLICE_X178Y277 [get_cells gtze2_inf_north/RXHEADERVALID34_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID34_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID33_LUT1A]
set_property LOC SLICE_X181Y277 [get_cells gtze2_inf_north/RXHEADERVALID33_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID33_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID33_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X180Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X180Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X180Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID33_LUT1B]
set_property LOC SLICE_X181Y277 [get_cells gtze2_inf_north/RXHEADERVALID33_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID33_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID33_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X180Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID33_FD]
set_property LOC SLICE_X180Y277 [get_cells gtze2_inf_north/RXHEADERVALID33_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID33_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID32_LUT1A]
set_property LOC SLICE_X183Y277 [get_cells gtze2_inf_north/RXHEADERVALID32_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID32_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID32_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X182Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X182Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X182Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID32_LUT1B]
set_property LOC SLICE_X183Y277 [get_cells gtze2_inf_north/RXHEADERVALID32_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID32_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID32_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X182Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID32_FD]
set_property LOC SLICE_X182Y277 [get_cells gtze2_inf_north/RXHEADERVALID32_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID32_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID31_LUT1A]
set_property LOC SLICE_X185Y277 [get_cells gtze2_inf_north/RXHEADERVALID31_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID31_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID31_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X184Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X184Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X184Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID31_LUT1B]
set_property LOC SLICE_X185Y277 [get_cells gtze2_inf_north/RXHEADERVALID31_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID31_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID31_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X184Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID31_FD]
set_property LOC SLICE_X184Y277 [get_cells gtze2_inf_north/RXHEADERVALID31_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID31_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADERVALID30_LUT1A]
set_property LOC SLICE_X187Y277 [get_cells gtze2_inf_north/RXHEADERVALID30_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADERVALID30_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID30_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X186Y277/BFF]
set_property PROHIBIT true [get_bels SLICE_X186Y277/B5FF]
set_property PROHIBIT true [get_bels SLICE_X186Y277/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADERVALID30_LUT1B]
set_property LOC SLICE_X187Y277 [get_cells gtze2_inf_north/RXHEADERVALID30_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADERVALID30_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID30_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X186Y277/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADERVALID30_FD]
set_property LOC SLICE_X186Y277 [get_cells gtze2_inf_north/RXHEADERVALID30_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADERVALID30_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA3159_LUT1B]
set_property LOC SLICE_X169Y250 [get_cells gtze2_inf_north/TXDATA3159_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA3159_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3159_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X169Y250/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA3159_FD]
set_property LOC SLICE_X169Y250 [get_cells gtze2_inf_north/TXDATA3159_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA3159_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE26_LUT1B]
set_property LOC SLICE_X148Y265 [get_cells gtze2_inf_north/TXSEQUENCE26_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE26_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE26_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X148Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X148Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE26_FD]
set_property LOC SLICE_X148Y265 [get_cells gtze2_inf_north/TXSEQUENCE26_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE26_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE25_LUT1B]
set_property LOC SLICE_X150Y265 [get_cells gtze2_inf_north/TXSEQUENCE25_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE25_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE25_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X150Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X150Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE25_FD]
set_property LOC SLICE_X150Y265 [get_cells gtze2_inf_north/TXSEQUENCE25_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE25_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE24_LUT1B]
set_property LOC SLICE_X152Y265 [get_cells gtze2_inf_north/TXSEQUENCE24_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE24_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE24_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X152Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X152Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE24_FD]
set_property LOC SLICE_X152Y265 [get_cells gtze2_inf_north/TXSEQUENCE24_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE24_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE23_LUT1B]
set_property LOC SLICE_X154Y265 [get_cells gtze2_inf_north/TXSEQUENCE23_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE23_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE23_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X154Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X154Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE23_FD]
set_property LOC SLICE_X154Y265 [get_cells gtze2_inf_north/TXSEQUENCE23_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE23_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE22_LUT1B]
set_property LOC SLICE_X156Y265 [get_cells gtze2_inf_north/TXSEQUENCE22_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE22_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE22_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X156Y265/D5FF]
set_property PROHIBIT true [get_bels SLICE_X156Y265/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE22_FD]
set_property LOC SLICE_X156Y265 [get_cells gtze2_inf_north/TXSEQUENCE22_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE22_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE21_LUT1B]
set_property LOC SLICE_X148Y260 [get_cells gtze2_inf_north/TXSEQUENCE21_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE21_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE21_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X148Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X148Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE21_FD]
set_property LOC SLICE_X148Y260 [get_cells gtze2_inf_north/TXSEQUENCE21_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE21_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXSEQUENCE20_LUT1B]
set_property LOC SLICE_X150Y260 [get_cells gtze2_inf_north/TXSEQUENCE20_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXSEQUENCE20_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE20_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X150Y260/D5FF]
set_property PROHIBIT true [get_bels SLICE_X150Y260/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/TXSEQUENCE20_FD]
set_property LOC SLICE_X150Y260 [get_cells gtze2_inf_north/TXSEQUENCE20_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXSEQUENCE20_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP14_LUT1B]
set_property LOC SLICE_X137Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP14_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXGEARBOXSLIP14_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP14_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y290/B5FF]
set_property PROHIBIT true [get_bels SLICE_X137Y290/CARRY4]
set_property BEL BFF [get_cells gtze2_inf_north/RXGEARBOXSLIP14_FD]
set_property LOC SLICE_X137Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP14_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP14_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP13_LUT1B]
set_property LOC SLICE_X137Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP13_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP13_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP13_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y290/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/RXGEARBOXSLIP13_FD]
set_property LOC SLICE_X137Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP13_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP13_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP12_LUT1B]
set_property LOC SLICE_X137Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP12_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP12_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP12_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y290/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXGEARBOXSLIP12_FD]
set_property LOC SLICE_X137Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP12_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP12_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP11_LUT1B]
set_property LOC SLICE_X137Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP11_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXGEARBOXSLIP11_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP11_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X137Y290/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXGEARBOXSLIP11_FD]
set_property LOC SLICE_X137Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP11_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP11_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXGEARBOXSLIP10_LUT1B]
set_property LOC SLICE_X136Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP10_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/RXGEARBOXSLIP10_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP10_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X136Y290/D5FF]
set_property PROHIBIT true [get_bels SLICE_X136Y290/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/RXGEARBOXSLIP10_FD]
set_property LOC SLICE_X136Y290 [get_cells gtze2_inf_north/RXGEARBOXSLIP10_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXGEARBOXSLIP10_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER04_LUT1A]
set_property LOC SLICE_X123Y267 [get_cells gtze2_inf_north/RXHEADER04_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER04_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER04_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X122Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X122Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X122Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER04_LUT1B]
set_property LOC SLICE_X123Y267 [get_cells gtze2_inf_north/RXHEADER04_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER04_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER04_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X122Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER04_FD]
set_property LOC SLICE_X122Y267 [get_cells gtze2_inf_north/RXHEADER04_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER04_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER03_LUT1A]
set_property LOC SLICE_X125Y262 [get_cells gtze2_inf_north/RXHEADER03_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER03_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER03_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X124Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X124Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X124Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER03_LUT1B]
set_property LOC SLICE_X125Y262 [get_cells gtze2_inf_north/RXHEADER03_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER03_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER03_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X124Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER03_FD]
set_property LOC SLICE_X124Y262 [get_cells gtze2_inf_north/RXHEADER03_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER03_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER02_LUT1A]
set_property LOC SLICE_X125Y267 [get_cells gtze2_inf_north/RXHEADER02_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER02_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER02_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X124Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X124Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X124Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER02_LUT1B]
set_property LOC SLICE_X125Y267 [get_cells gtze2_inf_north/RXHEADER02_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER02_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER02_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X124Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER02_FD]
set_property LOC SLICE_X124Y267 [get_cells gtze2_inf_north/RXHEADER02_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER02_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER01_LUT1A]
set_property LOC SLICE_X127Y262 [get_cells gtze2_inf_north/RXHEADER01_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER01_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER01_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X126Y262/BFF]
set_property PROHIBIT true [get_bels SLICE_X126Y262/B5FF]
set_property PROHIBIT true [get_bels SLICE_X126Y262/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER01_LUT1B]
set_property LOC SLICE_X127Y262 [get_cells gtze2_inf_north/RXHEADER01_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER01_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER01_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X126Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER01_FD]
set_property LOC SLICE_X126Y262 [get_cells gtze2_inf_north/RXHEADER01_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER01_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXHEADER00_LUT1A]
set_property LOC SLICE_X127Y267 [get_cells gtze2_inf_north/RXHEADER00_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXHEADER00_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER00_LUT1A]
set_property PROHIBIT true [get_bels SLICE_X126Y267/BFF]
set_property PROHIBIT true [get_bels SLICE_X126Y267/B5FF]
set_property PROHIBIT true [get_bels SLICE_X126Y267/CARRY4]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXHEADER00_LUT1B]
set_property LOC SLICE_X127Y267 [get_cells gtze2_inf_north/RXHEADER00_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXHEADER00_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER00_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X126Y267/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXHEADER00_FD]
set_property LOC SLICE_X126Y267 [get_cells gtze2_inf_north/RXHEADER00_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXHEADER00_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0124_LUT1B]
set_property LOC SLICE_X99Y250 [get_cells gtze2_inf_north/TXDATA0124_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0124_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0124_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y250/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0124_FD]
set_property LOC SLICE_X99Y250 [get_cells gtze2_inf_north/TXDATA0124_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0124_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0123_LUT1B]
set_property LOC SLICE_X99Y255 [get_cells gtze2_inf_north/TXDATA0123_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0123_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0123_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y255/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0123_FD]
set_property LOC SLICE_X99Y255 [get_cells gtze2_inf_north/TXDATA0123_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0123_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0122_LUT1B]
set_property LOC SLICE_X99Y255 [get_cells gtze2_inf_north/TXDATA0122_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0122_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0122_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y255/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0122_FD]
set_property LOC SLICE_X99Y255 [get_cells gtze2_inf_north/TXDATA0122_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0122_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA35_LUT1B]
set_property LOC SLICE_X177Y280 [get_cells gtze2_inf_north/TXDATA35_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA35_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA35_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA35_FD]
set_property LOC SLICE_X177Y280 [get_cells gtze2_inf_north/TXDATA35_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA35_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA34_LUT1B]
set_property LOC SLICE_X177Y280 [get_cells gtze2_inf_north/TXDATA34_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA34_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA34_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA34_FD]
set_property LOC SLICE_X177Y280 [get_cells gtze2_inf_north/TXDATA34_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA34_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA33_LUT1B]
set_property LOC SLICE_X177Y285 [get_cells gtze2_inf_north/TXDATA33_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA33_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA33_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y285/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA33_FD]
set_property LOC SLICE_X177Y285 [get_cells gtze2_inf_north/TXDATA33_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA33_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA32_LUT1B]
set_property LOC SLICE_X177Y285 [get_cells gtze2_inf_north/TXDATA32_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA32_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA32_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA32_FD]
set_property LOC SLICE_X177Y285 [get_cells gtze2_inf_north/TXDATA32_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA32_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA1159_LUT1A]
set_property LOC SLICE_X138Y262 [get_cells gtze2_inf_north/RXDATA1159_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1159_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1159_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA1159_LUT1B]
set_property LOC SLICE_X138Y262 [get_cells gtze2_inf_north/RXDATA1159_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1159_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1159_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y262/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA1159_FD]
set_property LOC SLICE_X139Y262 [get_cells gtze2_inf_north/RXDATA1159_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1159_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA1158_LUT1A]
set_property LOC SLICE_X138Y262 [get_cells gtze2_inf_north/RXDATA1158_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1158_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1158_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA1158_LUT1B]
set_property LOC SLICE_X138Y262 [get_cells gtze2_inf_north/RXDATA1158_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA1158_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1158_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y262/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA1158_FD]
set_property LOC SLICE_X139Y262 [get_cells gtze2_inf_north/RXDATA1158_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1158_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA1157_LUT1A]
set_property LOC SLICE_X138Y262 [get_cells gtze2_inf_north/RXDATA1157_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA1157_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1157_LUT1A]
set_property BEL D5LUT [get_cells gtze2_inf_north/RXDATA1157_LUT1B]
set_property LOC SLICE_X138Y262 [get_cells gtze2_inf_north/RXDATA1157_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA1157_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1157_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X139Y262/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/RXDATA1157_FD]
set_property LOC SLICE_X139Y262 [get_cells gtze2_inf_north/RXDATA1157_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA1157_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/NEARLOOPBACKEN3_LUT1B]
set_property LOC SLICE_X177Y252 [get_cells gtze2_inf_north/NEARLOOPBACKEN3_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/NEARLOOPBACKEN3_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/NEARLOOPBACKEN3_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X177Y252/A5FF]
set_property PROHIBIT true [get_bels SLICE_X177Y252/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/NEARLOOPBACKEN3_FD]
set_property LOC SLICE_X177Y252 [get_cells gtze2_inf_north/NEARLOOPBACKEN3_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/NEARLOOPBACKEN3_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/DRPEN_LUT1B]
set_property LOC SLICE_X268Y250 [get_cells gtze2_inf_north/DRPEN_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/DRPEN_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPEN_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X268Y250/D5FF]
set_property PROHIBIT true [get_bels SLICE_X268Y250/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/DRPEN_FD]
set_property LOC SLICE_X268Y250 [get_cells gtze2_inf_north/DRPEN_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/DRPEN_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA0103_LUT1B]
set_property LOC SLICE_X99Y280 [get_cells gtze2_inf_north/TXDATA0103_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0103_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0103_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y280/C5FF]
set_property PROHIBIT true [get_bels SLICE_X99Y280/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA0103_FD]
set_property LOC SLICE_X99Y280 [get_cells gtze2_inf_north/TXDATA0103_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0103_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA0102_LUT1B]
set_property LOC SLICE_X99Y280 [get_cells gtze2_inf_north/TXDATA0102_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0102_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0102_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y280/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA0102_FD]
set_property LOC SLICE_X99Y280 [get_cells gtze2_inf_north/TXDATA0102_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0102_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA0101_LUT1B]
set_property LOC SLICE_X99Y280 [get_cells gtze2_inf_north/TXDATA0101_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA0101_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0101_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y280/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA0101_FD]
set_property LOC SLICE_X99Y280 [get_cells gtze2_inf_north/TXDATA0101_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0101_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA0100_LUT1B]
set_property LOC SLICE_X99Y280 [get_cells gtze2_inf_north/TXDATA0100_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA0100_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0100_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y280/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA0100_FD]
set_property LOC SLICE_X99Y280 [get_cells gtze2_inf_north/TXDATA0100_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA0100_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA099_LUT1B]
set_property LOC SLICE_X99Y285 [get_cells gtze2_inf_north/TXDATA099_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA099_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA099_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y285/C5FF]
set_property PROHIBIT true [get_bels SLICE_X99Y285/CARRY4]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA099_FD]
set_property LOC SLICE_X99Y285 [get_cells gtze2_inf_north/TXDATA099_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA099_FD]
set_property BEL D5LUT [get_cells gtze2_inf_north/TXDATA098_LUT1B]
set_property LOC SLICE_X99Y285 [get_cells gtze2_inf_north/TXDATA098_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA098_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA098_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y285/D5FF]
set_property BEL DFF [get_cells gtze2_inf_north/TXDATA098_FD]
set_property LOC SLICE_X99Y285 [get_cells gtze2_inf_north/TXDATA098_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA098_FD]
set_property BEL A5LUT [get_cells gtze2_inf_north/TXDATA097_LUT1B]
set_property LOC SLICE_X99Y285 [get_cells gtze2_inf_north/TXDATA097_LUT1B]
set_property LOCK_PINS {I0:A3} [get_cells gtze2_inf_north/TXDATA097_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA097_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y285/A5FF]
set_property BEL AFF [get_cells gtze2_inf_north/TXDATA097_FD]
set_property LOC SLICE_X99Y285 [get_cells gtze2_inf_north/TXDATA097_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA097_FD]
set_property BEL B5LUT [get_cells gtze2_inf_north/TXDATA096_LUT1B]
set_property LOC SLICE_X99Y285 [get_cells gtze2_inf_north/TXDATA096_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA096_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA096_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X99Y285/B5FF]
set_property BEL BFF [get_cells gtze2_inf_north/TXDATA096_FD]
set_property LOC SLICE_X99Y285 [get_cells gtze2_inf_north/TXDATA096_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA096_FD]
set_property BEL C5LUT [get_cells gtze2_inf_north/TXDATA095_LUT1B]
set_property LOC SLICE_X101Y250 [get_cells gtze2_inf_north/TXDATA095_LUT1B]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/TXDATA095_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA095_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X101Y250/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/TXDATA095_FD]
set_property LOC SLICE_X101Y250 [get_cells gtze2_inf_north/TXDATA095_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/TXDATA095_FD]
set_property BEL B6LUT [get_cells gtze2_inf_north/RXDATA0142_LUT1A]
set_property LOC SLICE_X118Y282 [get_cells gtze2_inf_north/RXDATA0142_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA0142_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA0142_LUT1A]
set_property BEL B5LUT [get_cells gtze2_inf_north/RXDATA0142_LUT1B]
set_property LOC SLICE_X118Y282 [get_cells gtze2_inf_north/RXDATA0142_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA0142_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA0142_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X119Y282/D5FF]
set_property PROHIBIT true [get_bels SLICE_X119Y282/CARRY4]
set_property BEL DFF [get_cells gtze2_inf_north/RXDATA0142_FD]
set_property LOC SLICE_X119Y282 [get_cells gtze2_inf_north/RXDATA0142_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA0142_FD]
set_property BEL A6LUT [get_cells gtze2_inf_north/RXDATA0143_LUT1A]
set_property LOC SLICE_X118Y282 [get_cells gtze2_inf_north/RXDATA0143_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA0143_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA0143_LUT1A]
set_property BEL A5LUT [get_cells gtze2_inf_north/RXDATA0143_LUT1B]
set_property LOC SLICE_X118Y282 [get_cells gtze2_inf_north/RXDATA0143_LUT1B]
set_property LOCK_PINS {I0:A5} [get_cells gtze2_inf_north/RXDATA0143_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA0143_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X119Y282/C5FF]
set_property BEL CFF [get_cells gtze2_inf_north/RXDATA0143_FD]
set_property LOC SLICE_X119Y282 [get_cells gtze2_inf_north/RXDATA0143_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA0143_FD]
set_property BEL C6LUT [get_cells gtze2_inf_north/RXDATA0144_LUT1A]
set_property LOC SLICE_X118Y277 [get_cells gtze2_inf_north/RXDATA0144_LUT1A]
set_property LOCK_PINS {I0:A2} [get_cells gtze2_inf_north/RXDATA0144_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA0144_LUT1A]
set_property BEL C5LUT [get_cells gtze2_inf_north/RXDATA0144_LUT1B]
set_property LOC SLICE_X118Y277 [get_cells gtze2_inf_north/RXDATA0144_LUT1B]
set_property LOCK_PINS {I0:A4} [get_cells gtze2_inf_north/RXDATA0144_LUT1B]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA0144_LUT1B]
set_property PROHIBIT true [get_bels SLICE_X119Y277/A5FF]
set_property PROHIBIT true [get_bels SLICE_X119Y277/CARRY4]
set_property BEL AFF [get_cells gtze2_inf_north/RXDATA0144_FD]
set_property LOC SLICE_X119Y277 [get_cells gtze2_inf_north/RXDATA0144_FD]
set_property DONT_TOUCH true [get_cells gtze2_inf_north/RXDATA0144_FD]
set_property BEL D6LUT [get_cells gtze2_inf_north/RXDATA0145_LUT1A]
set_property LOC SLICE_X118Y277 [get_cells gtze2_inf_north/RXDATA0145_LUT1A]
set_property LOCK_PINS {I0:A1} [get_cells gtze2_inf_north/RXDATA0145_LUT1A]
set_property DONT_TOUCH true [get_cells gtze2_inf_nort