///////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   /
// /___/  \  /    Vendor: Xilinx
// \   \   \/     Version : 3.0
//  \   \         Application : 7 Series FPGAs Transceivers Wizard
//  /   /         Filename : gtz_caui4_v3_0_init.v
// /___/   /\     
// \   \  /  \ 
//  \___\/\___\
//
//
// Module gtz_caui4_v3_0_init
// Generated by Xilinx 7 Series FPGAs Transceivers Wizard
// 
// 
// (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
// 
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
// 
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
// 
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
// 
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES. 


`default_nettype wire

`timescale 1ns / 1ps
`define DLY #1

//***************************** Entity Declaration ****************************

(* CORE_GENERATION_INFO = "gtz_caui4_v3_0,gtwizard_v3_0,{protocol_file=Start_from_scratch}" *) module gtz_caui4_v3_0_init #
(
    // Simulation attributes
    parameter   SIM_GTZRESET_SPEEDUP     =  "TRUE",       // Set to "TRUE" to speed up sim reset;
    parameter   SIM_VERSION              =  "1.0",
    parameter   EXAMPLE_SIMULATION       =  0
)
(
    input       sysclk_in,
    input       soft_reset_in,

    input       rxusrclk0_in,
    input       rxusrclk1_in,
    input       rxusrclk2_in,
    input       rxusrclk3_in,
    input       rxusrclk4_in,
    input       rxusrclk5_in,
    input       rxusrclk6_in,
    input       rxusrclk7_in,
    input       mmcm_locked, // RX MMCM is locked
    output      mmcm_reset,  // reset the RX MMCM

    input       txusrclk0_in,
    input       txusrclk1_in,
    input       txusrclk2_in,
    input       txusrclk3_in,
    input       txusrclk4_in,
    input       txusrclk5_in,
    input       txusrclk6_in,
    input       txusrclk7_in,

    input       drpclk0_in,
    input       drpclk1_in,
    input       drpclk_in,

    
    //_________________________________________________________________________
    //----------------------- REFCLK Ports -------------------------------
    input       oct0_gtrefclk0p_in,
    input       oct0_gtrefclk0n_in,
    input       oct0_gtrefclk1p_in,
    input       oct0_gtrefclk1n_in,
    input       oct0_drpclksel_in,

    output      oct0_rxcoreclk0_out,
    output      oct0_rxcoreclk1_out,
    output      oct0_rxcoreclk2_out,
    output      oct0_rxcoreclk3_out,
    output      oct0_txcoreclk0_out,
    output      oct0_txcoreclk1_out,
	
    //-------------------------------- Serial Ports ---------------------------------
    output      oct0_gtztxp0_out,
    output      oct0_gtztxn0_out,
    input       oct0_gtzrxp0_in,
    input       oct0_gtzrxn0_in,
    output      oct0_gtztxp1_out,
    output      oct0_gtztxn1_out,
    input       oct0_gtzrxp1_in,
    input       oct0_gtzrxn1_in,
    output      oct0_gtztxp2_out,
    output      oct0_gtztxn2_out,
    input       oct0_gtzrxp2_in,
    input       oct0_gtzrxn2_in,
    output      oct0_gtztxp3_out,
    output      oct0_gtztxn3_out,
    input       oct0_gtzrxp3_in,
    input       oct0_gtzrxn3_in,
    //-- RX/TX serial ports polarity
    input   [3:0]   oct0_gtzrxpolarity_in,
    input   [3:0]   oct0_gtztxpolarity_in,
    //-------------------------- CTLE tuning ---------------------------
    input [3:0] oct0_chan_id_in,
    input 	    oct0_redo_ch_tuning,
    					 
    //----------------------------- BitSlip Ports ------------------------------
    input   [4:0]   oct0_rxgearboxslip0_in,
    input   [4:0]   oct0_rxgearboxslip1_in,
    input   [4:0]   oct0_rxgearboxslip2_in,
    input   [4:0]   oct0_rxgearboxslip3_in,
    //----------------------------- Clocking Ports -----------------------------
    input           oct0_refclksel0_in,
    input           oct0_refclksel1_in,
    input           oct0_refclksel2_in,
    input           oct0_refclksel3_in,
    output          oct0_rxoutclk0_out,
    output          oct0_rxoutclk1_out,
    output          oct0_rxoutclk2_out,
    output          oct0_rxoutclk3_out,
    output          oct0_txoutclk0_out,
    output          oct0_txoutclk1_out,
    //-------------------------- Configuration Ports ---------------------------
    input           oct0_gtzinit_in,
    output          oct0_gtzinitdoneb_out,
    //------------------------------- DRP Ports --------------------------------
    input           oct0_drpsel_in, // Must be '1' to take control of the DRP
    input   [15:0]  oct0_drpaddr_in,
    input   [31:0]  oct0_drpdi_in,
    output  [31:0]  oct0_drpdo_out,
    input           oct0_drpen_in,
    output          oct0_drprdy_out,
    output  [2:0]   oct0_drpstatus_out,
    output          oct0_drpwdterr_out,
    input           oct0_drpwe_in,
    //-------------------------- Latency clock Ports ---------------------------
    input           oct0_rxlatclk_in,
    input           oct0_txlatclk_in,
    //------------------------------- Loopbacks --------------------------------
    input           oct0_farloopbacken0_in,
    input           oct0_farloopbacken1_in,
    input           oct0_farloopbacken2_in,
    input           oct0_farloopbacken3_in,
    input           oct0_nearloopbacken0_in,
    input           oct0_nearloopbacken1_in,
    input           oct0_nearloopbacken2_in,
    input           oct0_nearloopbacken3_in,
    //------------------------------- PRBS Ports -------------------------------
    input           oct0_rxprbsen0_in,
    input           oct0_rxprbsen1_in,
    input           oct0_rxprbsen2_in,
    input           oct0_rxprbsen3_in,
    output          oct0_rxprbspass0_out,
    output          oct0_rxprbspass1_out,
    output          oct0_rxprbspass2_out,
    output          oct0_rxprbspass3_out,
    input   [2:0]   oct0_rxprbssel0_in,
    input   [2:0]   oct0_rxprbssel1_in,
    input   [2:0]   oct0_rxprbssel2_in,
    input   [2:0]   oct0_rxprbssel3_in,
    input           oct0_txprbsen0_in,
    input           oct0_txprbsen1_in,
    input           oct0_txprbsen2_in,
    input           oct0_txprbsen3_in,
    input   [2:0]   oct0_txprbssel0_in,
    input   [2:0]   oct0_txprbssel1_in,
    input   [2:0]   oct0_txprbssel2_in,
    input   [2:0]   oct0_txprbssel3_in,
    //-------------------------- Rx Fabric Interface ---------------------------
    output  [159:0] oct0_rxdata0_out,
    output  [159:0] oct0_rxdata1_out,
    output  [159:0] oct0_rxdata2_out,
    output  [159:0] oct0_rxdata3_out,
    output  [4:0]   oct0_rxdatavalid0_out,
    output  [4:0]   oct0_rxdatavalid1_out,
    output  [4:0]   oct0_rxdatavalid2_out,
    output  [4:0]   oct0_rxdatavalid3_out,
    output  [9:0]   oct0_rxheader0_out,
    output  [9:0]   oct0_rxheader1_out,
    output  [9:0]   oct0_rxheader2_out,
    output  [9:0]   oct0_rxheader3_out,
    output  [4:0]   oct0_rxheadervalid0_out,
    output  [4:0]   oct0_rxheadervalid1_out,
    output  [4:0]   oct0_rxheadervalid2_out,
    output  [4:0]   oct0_rxheadervalid3_out,
    //-------------------------- Rx Reset Controller ---------------------------
    input           oct0_gtzrxreset0_in,
    input           oct0_gtzrxreset1_in,
    input           oct0_gtzrxreset2_in,
    input           oct0_gtzrxreset3_in,
    output          oct0_rxrdy0_out,
    output          oct0_rxrdy1_out,
    output          oct0_rxrdy2_out,
    output          oct0_rxrdy3_out,
    output          oct0_rxresetdone0_out,
    output          oct0_rxresetdone1_out,
    output          oct0_rxresetdone2_out,
    output          oct0_rxresetdone3_out,
    input           oct0_rxok0_in, // RX ok = received data are valid (=block lock ok etc.)
    input           oct0_rxok1_in, 
    input           oct0_rxok2_in,
    input           oct0_rxok3_in,
    //-------------------------- Tx Fabric Interface ---------------------------
    input   [159:0] oct0_txdata0_in,
    input   [159:0] oct0_txdata1_in,
    input   [159:0] oct0_txdata2_in,
    input   [159:0] oct0_txdata3_in,
    input   [9:0]   oct0_txheader0_in,
    input   [9:0]   oct0_txheader1_in,
    input   [9:0]   oct0_txheader2_in,
    input   [9:0]   oct0_txheader3_in,
    //-------------------------- Tx Reset Controller ---------------------------
    input           oct0_gtztxreset0_in,
    input           oct0_gtztxreset1_in,
    input           oct0_gtztxreset2_in,
    input           oct0_gtztxreset3_in,
    output          oct0_txrdy0_out,
    output          oct0_txrdy1_out,
    output          oct0_txrdy2_out,
    output          oct0_txrdy3_out,
    output          oct0_txresetdone0_out,
    output          oct0_txresetdone1_out,
    output          oct0_txresetdone2_out,
    output          oct0_txresetdone3_out,
    //--------------------------- Tx sequence Ports ----------------------------
    input   [6:0]   oct0_txsequence0_in,
    input   [6:0]   oct0_txsequence1_in,
    input   [6:0]   oct0_txsequence2_in,
    input   [6:0]   oct0_txsequence3_in,
    //
    output [31:0] dbg_state
    
					    
     );
     
   (*keep= "true"*) wire  [159:0] oct0_rxdata0;
   (*keep= "true"*) wire  [159:0] oct0_rxdata1;
   (*keep= "true"*) wire  [159:0] oct0_rxdata2;
   wire  [159:0] oct0_rxdata3;
   (*keep= "true"*) wire  [9:0]   oct0_rxheader0;
   (*keep= "true"*) wire  [9:0]   oct0_rxheader1;
   (*keep= "true"*) wire  [9:0]   oct0_rxheader2;
   (*keep= "true"*) wire  [9:0]   oct0_rxheader3;
   wire  [4:0]   oct0_rxheadervalid0;
   wire  [4:0]   oct0_rxheadervalid1;
   wire  [4:0]   oct0_rxheadervalid2;
   wire  [4:0]   oct0_rxheadervalid3;   
   
   wire  [4:0] oct0_rxdatavalid0;
   wire  [4:0] oct0_rxdatavalid1;
   wire  [4:0] oct0_rxdatavalid2;
   wire  [4:0] oct0_rxdatavalid3;      
   
   wire          oct0_txrdy0;
   wire          oct0_txrdy1;
   wire          oct0_txrdy2;
   wire          oct0_txrdy3;
   
   (*keep= "true"*) wire 	   [511:0] probe0;
   (*keep= "true"*) wire 	   [63:0] probe1;          
   (*keep= "true"*) wire 	   [31:0] probe2;
   (*keep= "true"*) wire 	   [31:0] drp_probe;
   wire 	   [15:0] vio_out;
   
   wire 	   oct0_gt0_rxreset;
   wire 	   gt0_rxreset;
   wire 	   oct0_gt0_rxresetdone;
   wire 	   oct0_gt0_rxrdy;
   wire 	   oct0_gt0_rxfibreset;
   wire 	   oct0_gt0_ctle_tuning_done;
   wire 	   oct0_txreset0;
   wire 	   oct0_txresetdone0;
   wire 	   txfsm_reset_done0;
				   
   wire 	   oct0_gt1_rxreset;
   wire 	   gt1_rxreset;
   wire 	   oct0_gt1_rxresetdone;
   wire 	   oct0_gt1_rxrdy;
   wire 	   oct0_gt1_rxfibreset;
   wire 	   oct0_gt1_ctle_tuning_done;
   wire 	   oct0_txreset1;
   wire 	   oct0_txresetdone1;
   wire 	   txfsm_reset_done1;
				   
   wire 	   oct0_gt2_rxreset;
   wire 	   gt2_rxreset;
   wire 	   oct0_gt2_rxresetdone;
   wire 	   oct0_gt2_rxrdy;
   wire 	   oct0_gt2_rxfibreset;
   wire 	   oct0_gt2_ctle_tuning_done;
   wire 	   oct0_txreset2;
   wire 	   oct0_txresetdone2;
   wire 	   txfsm_reset_done2;
				   
   wire 	   oct0_gt3_rxreset;
   wire 	   gt3_rxreset;
   wire 	   oct0_gt3_rxresetdone;
   wire 	   oct0_gt3_rxrdy;
   wire 	   oct0_gt3_rxfibreset;
   wire 	   oct0_gt3_ctle_tuning_done;
   wire 	   oct0_txreset3;
   wire 	   oct0_txresetdone3;
   wire 	   txfsm_reset_done3;
   //---------------------- DRP interface ----------------------------------
   wire [31:0]  oct0_drpdo;
   wire [31:0]  oct0_drpdi;
   wire [15:0]  oct0_drpaddr;
   wire         oct0_drpen;
   wire         oct0_drpwe;
   wire [2:0]   oct0_drpstatus;
   wire         oct0_drpwdterr;
   
   wire [31:0]  oct0_ctle_drpdi;
   wire [15:0]  oct0_ctle_drpaddr;
   wire         oct0_ctle_drpen;
   wire         oct0_ctle_drpwe;
   
   wire oct0_pllrecalen0;
   wire oct0_pllrecalen1;
   wire oct0_pllrecalen2;
   wire oct0_pllrecalen3;
   wire oct0_txen0;
   wire oct0_txen1;
   wire oct0_txen2;
   wire oct0_txen3;
   wire oct0_rxen0;
   wire oct0_rxen1;
   wire oct0_rxen2;
   wire oct0_rxen3;
   wire tx_startup_fsm0_reset;
   wire tx_startup_fsm1_reset;
   wire tx_startup_fsm2_reset;
   wire tx_startup_fsm3_reset;
   
   //--------------------- Chipscope Signals ---------------------------------  x   
   wire [7:0] 	oct0_ctle_tuning_done;
   wire 	oct0_ctle_tuning_reset;
   wire     oct0_gt0_tuning_en;
   wire     oct0_gt1_tuning_en;
   wire     oct0_gt2_tuning_en;
   wire     oct0_gt3_tuning_en;
   wire     oct0_gt0_init_en;
   wire     oct0_gt1_init_en;
   wire     oct0_gt2_init_en;
   wire     oct0_gt3_init_en;   
   wire 	oct0_ctle_tuning_en;
   wire 	oct0_ctle_init_en;
 
   wire [3:0] 	oct0_chan_id;
   wire [7:0] 	oct0_nearend_lpbk_en_i;
   wire [7:0]   oct0_ctle_tune_ch;
   (*keep= "true"*) wire [8:0] 	ctle_tuning_state;
   (*keep= "true"*) wire [7:0] 	rx_startup_state0;
   (*keep= "true"*) wire [7:0] 	rx_startup_state1;
   (*keep= "true"*) wire [7:0] 	rx_startup_state2;
   (*keep= "true"*) wire [7:0] 	rx_startup_state3;
   (*keep= "true"*) wire [7:0] 	tx_startup_state0;   
   (*keep= "true"*) wire [7:0] 	tx_startup_state1;   
   (*keep= "true"*) wire [7:0] 	tx_startup_state2;   
   (*keep= "true"*) wire [7:0] 	tx_startup_state3;   
   wire [3:0] 	ctle_chan_id;
   wire 		soft_reset;
   wire 		oct0_gtzinitdoneb;
   
   
   
   // Assign GTZ DRP ports
   assign oct0_drpdi   = (oct0_drpsel_in == 1) ? oct0_drpdi_in   : oct0_ctle_drpdi;
   assign oct0_drpaddr = (oct0_drpsel_in == 1) ? oct0_drpaddr_in : oct0_ctle_drpaddr;
   assign oct0_drpen   = (oct0_drpsel_in == 1) ? oct0_drpen_in   : oct0_ctle_drpen;
   assign oct0_drpwe   = (oct0_drpsel_in == 1) ? oct0_drpwe_in   : oct0_ctle_drpwe;
   assign oct0_drpdo_out = oct0_drpdo;
   assign oct0_drprdy_out = oct0_drprdy;
   assign oct0_drpstatus_out = oct0_drpstatus;
   assign oct0_drpwdterr_out = oct0_drpwdterr;

   assign tied_to_ground_i             = 1'b0;
   assign tied_to_ground_vec_i         = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   assign tied_to_vcc_i                = 1'b1;
   assign tied_to_vcc_vec_i            = 8'hff;
   
   assign oct0_rxdata0_out = oct0_rxdata0;
   assign oct0_rxdata1_out = oct0_rxdata1;
   assign oct0_rxdata2_out = oct0_rxdata2;
   assign oct0_rxdata3_out = oct0_rxdata3;
   
   assign oct0_rxheader0_out = oct0_rxheader0;
   assign oct0_rxheader1_out = oct0_rxheader1;
   assign oct0_rxheader2_out = oct0_rxheader2;
   assign oct0_rxheader3_out = oct0_rxheader3;
   
   assign oct0_rxheadervalid0_out = oct0_rxheadervalid0;
   assign oct0_rxheadervalid1_out = oct0_rxheadervalid1;
   assign oct0_rxheadervalid2_out = oct0_rxheadervalid2;
   assign oct0_rxheadervalid3_out = oct0_rxheadervalid3;
   
   assign oct0_rxdatavalid0_out = oct0_rxdatavalid0;
   assign oct0_rxdatavalid1_out = oct0_rxdatavalid1;
   assign oct0_rxdatavalid2_out = oct0_rxdatavalid2;
   assign oct0_rxdatavalid3_out = oct0_rxdatavalid3;   
   
   assign oct0_txrdy0_out = oct0_txrdy0;
   assign oct0_txrdy1_out = oct0_txrdy1;
   assign oct0_txrdy2_out = oct0_txrdy2;
   assign oct0_txrdy3_out = oct0_txrdy3;
   
   assign soft_reset = (soft_reset_in | vio_out[0]);
   
   assign oct0_gtzinitdoneb_out = oct0_gtzinitdoneb;
   
     gtz_caui4 gtz_caui4_i 
     (
    
					
      //-------------------------------- TX Reset Controller Ports ---------------------------------
      .oct0_gtztxreset0_in(oct0_txreset0),      
      .oct0_txresetdone0_out(oct0_txresetdone0),      
      .oct0_txrdy0_out(oct0_txrdy0),
      
      //-------------------------------- RX Reset Controller Ports ---------------------------------
      .oct0_gtzrxreset0_in(oct0_gt0_rxreset),      
      .oct0_rxresetdone0_out(oct0_gt0_rxresetdone),
      .oct0_rxrdy0_out(oct0_gt0_rxrdy),
      
      //-------------------------------- Serial Ports ---------------------------------
      .oct0_gtztxp0_out(oct0_gtztxp0_out),
      .oct0_gtztxn0_out(oct0_gtztxn0_out),
      .oct0_gtzrxp0_in(oct0_gtzrxp0_in),
      .oct0_gtzrxn0_in(oct0_gtzrxn0_in),
      
      //-------------------------------- Rx Fabric Interface Ports ---------------------------------
      .oct0_rxdata0_out(oct0_rxdata0),
								
      .oct0_rxdatavalid0_out(oct0_rxdatavalid0),
      .oct0_rxheader0_out(oct0_rxheader0),
      .oct0_rxheadervalid0_out(oct0_rxheadervalid0),
      
      //-------------------------------- Tx Fabric Interface Ports ---------------------------------
      .oct0_txdata0_in(oct0_txdata0_in),					
								
      .oct0_txheader0_in(oct0_txheader0_in),
            
      //---------------------------- PCS Ports ---------------------------------
								
      .oct0_rxgearboxslip0_in(oct0_rxgearboxslip0_in),
      .oct0_txsequence0_in(oct0_txsequence0_in),
	  
      .oct0_refclksel0_in(oct0_refclksel0_in),

      //--------------------------- Optional Ports ------------------------------
      .oct0_rxfibreset0_in(oct0_gt0_rxfibreset),
      .oct0_nearloopbacken0_in(oct0_nearloopbacken0_in), 
					
      //-------------------------------- TX Reset Controller Ports ---------------------------------
      .oct0_gtztxreset1_in(oct0_txreset1),      
      .oct0_txresetdone1_out(oct0_txresetdone1),      
      .oct0_txrdy1_out(oct0_txrdy1),
      
      //-------------------------------- RX Reset Controller Ports ---------------------------------
      .oct0_gtzrxreset1_in(oct0_gt1_rxreset),      
      .oct0_rxresetdone1_out(oct0_gt1_rxresetdone),
      .oct0_rxrdy1_out(oct0_gt1_rxrdy),
      
      //-------------------------------- Serial Ports ---------------------------------
      .oct0_gtztxp1_out(oct0_gtztxp1_out),
      .oct0_gtztxn1_out(oct0_gtztxn1_out),
      .oct0_gtzrxp1_in(oct0_gtzrxp1_in),
      .oct0_gtzrxn1_in(oct0_gtzrxn1_in),
      
      //-------------------------------- Rx Fabric Interface Ports ---------------------------------
      .oct0_rxdata1_out(oct0_rxdata1),
								
      .oct0_rxdatavalid1_out(oct0_rxdatavalid1),
      .oct0_rxheader1_out(oct0_rxheader1),
      .oct0_rxheadervalid1_out(oct0_rxheadervalid1),
      
      //-------------------------------- Tx Fabric Interface Ports ---------------------------------
      .oct0_txdata1_in(oct0_txdata1_in),					
								
      .oct0_txheader1_in(oct0_txheader1_in),
            
      //---------------------------- PCS Ports ---------------------------------
								
      .oct0_rxgearboxslip1_in(oct0_rxgearboxslip1_in),
      .oct0_txsequence1_in(oct0_txsequence1_in),
	  
      .oct0_refclksel1_in(oct0_refclksel1_in),

      //--------------------------- Optional Ports ------------------------------
      .oct0_rxfibreset1_in(oct0_gt1_rxfibreset),
      .oct0_nearloopbacken1_in(oct0_nearloopbacken1_in),
					
      //-------------------------------- TX Reset Controller Ports ---------------------------------
      .oct0_gtztxreset2_in(oct0_txreset1),      
      .oct0_txresetdone2_out(oct0_txresetdone2),      
      .oct0_txrdy2_out(oct0_txrdy2),
      
      //-------------------------------- RX Reset Controller Ports ---------------------------------
      .oct0_gtzrxreset2_in(oct0_gt2_rxreset),      
      .oct0_rxresetdone2_out(oct0_gt2_rxresetdone),
      .oct0_rxrdy2_out(oct0_gt2_rxrdy),
      
      //-------------------------------- Serial Ports ---------------------------------
      .oct0_gtztxp2_out(oct0_gtztxp2_out),
      .oct0_gtztxn2_out(oct0_gtztxn2_out),
      .oct0_gtzrxp2_in(oct0_gtzrxp2_in),
      .oct0_gtzrxn2_in(oct0_gtzrxn2_in),
      
      //-------------------------------- Rx Fabric Interface Ports ---------------------------------
      .oct0_rxdata2_out(oct0_rxdata2),
								
      .oct0_rxdatavalid2_out(oct0_rxdatavalid2),
      .oct0_rxheader2_out(oct0_rxheader2),
      .oct0_rxheadervalid2_out(oct0_rxheadervalid2),
      
      //-------------------------------- Tx Fabric Interface Ports ---------------------------------
      .oct0_txdata2_in(oct0_txdata2_in),					
								
      .oct0_txheader2_in(oct0_txheader2_in),
            
      //---------------------------- PCS Ports ---------------------------------
								
      .oct0_rxgearboxslip2_in(oct0_rxgearboxslip2_in),
      .oct0_txsequence2_in(oct0_txsequence2_in),
	  
      .oct0_refclksel2_in(oct0_refclksel2_in),

      //--------------------------- Optional Ports ------------------------------
      .oct0_rxfibreset2_in(oct0_gt2_rxfibreset),
      .oct0_nearloopbacken2_in(oct0_nearloopbacken2_in),
					
      //-------------------------------- TX Reset Controller Ports ---------------------------------
      .oct0_gtztxreset3_in(oct0_txreset3),      
      .oct0_txresetdone3_out(oct0_txresetdone3),      
      .oct0_txrdy3_out(oct0_txrdy3),
      
      //-------------------------------- RX Reset Controller Ports ---------------------------------
      .oct0_gtzrxreset3_in(oct0_gt3_rxreset),      
      .oct0_rxresetdone3_out(oct0_gt3_rxresetdone),
      .oct0_rxrdy3_out(oct0_gt3_rxrdy),
      
      //-------------------------------- Serial Ports ---------------------------------
      .oct0_gtztxp3_out(oct0_gtztxp3_out),
      .oct0_gtztxn3_out(oct0_gtztxn3_out),
      .oct0_gtzrxp3_in(oct0_gtzrxp3_in),
      .oct0_gtzrxn3_in(oct0_gtzrxn3_in),
      
      .oct0_gtzrxpolarity_in(oct0_gtzrxpolarity_in),
      .oct0_gtztxpolarity_in(oct0_gtztxpolarity_in),      
      
      //-------------------------------- Rx Fabric Interface Ports ---------------------------------
      .oct0_rxdata3_out(oct0_rxdata3),
								
      .oct0_rxdatavalid3_out(oct0_rxdatavalid3),
      .oct0_rxheader3_out(oct0_rxheader3),
      .oct0_rxheadervalid3_out(oct0_rxheadervalid3),
      
      //-------------------------------- Tx Fabric Interface Ports ---------------------------------
      .oct0_txdata3_in(oct0_txdata3_in),					
								
      .oct0_txheader3_in(oct0_txheader3_in),
            
      //---------------------------- PCS Ports ---------------------------------
								
      .oct0_rxgearboxslip3_in(oct0_rxgearboxslip3_in),
      .oct0_txsequence3_in(oct0_txsequence3_in),
	  
      .oct0_refclksel3_in(oct0_refclksel3_in),

      //--------------------------- Optional Ports ------------------------------
      .oct0_rxfibreset3_in(oct0_gt3_rxfibreset),
      .oct0_nearloopbacken3_in(oct0_nearloopbacken3_in),

      //--------------------------- Clocking Ports ------------------------------
      
      .oct0_txoutclk0_out(oct0_txoutclk0_out),
      .oct0_txoutclk1_out(oct0_txoutclk1_out),      
      .oct0_rxoutclk0_out(oct0_rxoutclk0_out),
      .oct0_rxoutclk1_out(oct0_rxoutclk1_out),
      .oct0_rxoutclk2_out(oct0_rxoutclk2_out),
      .oct0_rxoutclk3_out(oct0_rxoutclk3_out),

      .oct0_txcoreclk0_out(oct0_txcoreclk0_out),
      .oct0_txcoreclk1_out(oct0_txcoreclk1_out),
      .oct0_rxcoreclk0_out(oct0_rxcoreclk0_out),
      .oct0_rxcoreclk1_out(oct0_rxcoreclk1_out),
      .oct0_rxcoreclk2_out(oct0_rxcoreclk2_out),
      .oct0_rxcoreclk3_out(oct0_rxcoreclk3_out),
				   
      .oct0_gtzinit_in(oct0_gtzinit_in),
      .oct0_gtzinitdoneb_out(oct0_gtzinitdoneb),
      // PLL calibration
      .oct0_pllrecalen0_in(oct0_pllrecalen0),
      .oct0_pllrecalen1_in(oct0_pllrecalen1),
      .oct0_pllrecalen2_in(oct0_pllrecalen2),
      .oct0_pllrecalen3_in(oct0_pllrecalen3),
      .oct0_txen0_in(oct0_txen0),
      .oct0_txen1_in(oct0_txen1),
      .oct0_txen2_in(oct0_txen2),
      .oct0_txen3_in(oct0_txen3),
      .oct0_rxen0_in(oct0_rxen0),
      .oct0_rxen1_in(oct0_rxen1),
      .oct0_rxen2_in(oct0_rxen2),
      .oct0_rxen3_in(oct0_rxen3),      
      
      .oct0_txlatclk_in(oct0_txlatclk_in),
      .oct0_rxlatclk_in(oct0_rxlatclk_in),

      .oct0_drpen_in(oct0_drpen),
      .oct0_drpwe_in(oct0_drpwe),
      .oct0_drpdi_in(oct0_drpdi),
      .oct0_drpaddr_in(oct0_drpaddr),
      .oct0_drpdo_out(oct0_drpdo),
      .oct0_drprdy_out(oct0_drprdy),
      .oct0_drpstatus_out(oct0_drpstatus),
      .oct0_drpwdterr_out(oct0_drpwdterr),
      .oct0_gtrefclk0p_in(oct0_gtrefclk0p_in),
      .oct0_gtrefclk0n_in(oct0_gtrefclk0n_in),
      .oct0_gtrefclk1p_in(oct0_gtrefclk1p_in),
      .oct0_gtrefclk1n_in(oct0_gtrefclk1n_in),
      .oct0_drpclksel_in(oct0_drpclksel_in),
				   
    
      .drpclk0_in(drpclk0_in),
      .drpclk1_in(drpclk1_in),
      
      .txusrclk0_in(txusrclk0_in),
      .txusrclk1_in(txusrclk1_in),
      .txusrclk2_in(txusrclk2_in),
      .txusrclk3_in(txusrclk3_in),
      .txusrclk4_in(txusrclk4_in),
      .txusrclk5_in(txusrclk5_in),
      .txusrclk6_in(txusrclk6_in),
      .txusrclk7_in(txusrclk7_in),
      .rxusrclk0_in(rxusrclk0_in),
      .rxusrclk1_in(rxusrclk1_in),
      .rxusrclk2_in(rxusrclk2_in),
      .rxusrclk3_in(rxusrclk3_in),
      .rxusrclk4_in(rxusrclk4_in),
      .rxusrclk5_in(rxusrclk5_in),
      .rxusrclk6_in(rxusrclk6_in),
      .rxusrclk7_in(rxusrclk7_in)
      );
      

   assign tx_startup_fsm0_reset = soft_reset;
   
   gtz_tx_startup_fsm tx_startup_gt0_i (
        .CLK(drpclk_in),
        .RESET(tx_startup_fsm0_reset),
        .TXRDY_I(oct0_txrdy0),
        .RXRDY_I(oct0_gt0_rxrdy),
        .TXRESETDONE(oct0_txresetdone0),
        .PLLRECALEN_O(oct0_pllrecalen0),
        .MMCM_RESET_O(mmcm_reset),
        .MMCM_LOCKED_I(mmcm_locked),        
        .TXEN_O(oct0_txen0),
        .RXEN_O(oct0_rxen0),
        .TXRESET_O(oct0_txreset0),
        .RESET_DONE(txfsm_reset_done0),
        .STATE_O(tx_startup_state0)
      );
      
   assign tx_startup_fsm1_reset = !txfsm_reset_done0;
   
   gtz_tx_startup_fsm tx_startup_gt1_i (
        .CLK(drpclk_in),
        .RESET(tx_startup_fsm1_reset),
        .TXRDY_I(oct0_txrdy1),
        .RXRDY_I(oct0_gt1_rxrdy),
        .TXRESETDONE(oct0_txresetdone1),
        .PLLRECALEN_O(oct0_pllrecalen1),
        .TXEN_O(oct0_txen1),
        .RXEN_O(oct0_rxen1),
        .MMCM_LOCKED_I(mmcm_locked),
        .TXRESET_O(oct0_txreset1),
        .RESET_DONE(txfsm_reset_done1),
        .STATE_O(tx_startup_state1)
      );      
      
      
   assign tx_startup_fsm2_reset = !txfsm_reset_done1;
   
   gtz_tx_startup_fsm tx_startup_gt2_i (
        .CLK(drpclk_in),
        .RESET(tx_startup_fsm2_reset),
        .TXRDY_I(oct0_txrdy2),
        .RXRDY_I(oct0_gt2_rxrdy),
        .TXRESETDONE(oct0_txresetdone2),
        .PLLRECALEN_O(oct0_pllrecalen2),
        .TXEN_O(oct0_txen2),
        .RXEN_O(oct0_rxen2),
        .MMCM_LOCKED_I(mmcm_locked),        
        .TXRESET_O(oct0_txreset2),
        .RESET_DONE(txfsm_reset_done2),
        .STATE_O(tx_startup_state2)
      );
      
   assign tx_startup_fsm3_reset = !txfsm_reset_done2;
   
   gtz_tx_startup_fsm tx_startup_gt3_i (
        .CLK(drpclk_in),
        .RESET(tx_startup_fsm3_reset),
        .TXRDY_I(oct0_txrdy3),
        .RXRDY_I(oct0_gt3_rxrdy),
        .TXRESETDONE(oct0_txresetdone3),
        .PLLRECALEN_O(oct0_pllrecalen3),
        .TXEN_O(oct0_txen3),
        .RXEN_O(oct0_rxen3),
        .MMCM_LOCKED_I(mmcm_locked),        
        .TXRESET_O(oct0_txreset3),
        .RESET_DONE(txfsm_reset_done3),
        .STATE_O(tx_startup_state3)
      );                  

      
assign oct0_ctle_tuning_reset = gt0_rxreset;


assign oct0_ctle_tuning_en = (oct0_gt0_tuning_en) || 
                             (oct0_gt1_tuning_en) || 
                             (oct0_gt2_tuning_en) || 
                             (oct0_gt3_tuning_en);
                             
assign oct0_ctle_init_en = (oct0_gt0_init_en) || 
                           (oct0_gt1_init_en) || 
                           (oct0_gt2_init_en) || 
                           (oct0_gt3_init_en);
                                
assign oct0_ctle_tune_ch = { 4'b0000,
                             oct0_gt3_tuning_en|oct0_gt3_init_en,
                             oct0_gt2_tuning_en|oct0_gt2_init_en,
                             oct0_gt1_tuning_en|oct0_gt1_init_en,
                             oct0_gt0_tuning_en|oct0_gt0_init_en };

   assign oct0_nearend_lpbk_en_i = {
                                1'b0,
                                1'b0,
                                1'b0,
                                1'b0,
                                oct0_nearloopbacken3_in,
                                oct0_nearloopbacken2_in,
                                oct0_nearloopbacken1_in,
                                oct0_nearloopbacken0_in};
   
   gtz_ctle_tuning tuning_oct0_i (
				       .nearendloopbacken_i(oct0_nearend_lpbk_en_i),
				       .redo_channel_tuning_i(oct0_redo_ch_tuning),
				       .octal_ctle_tuning_reset_i(oct0_ctle_tuning_reset),
				       .octal_ctle_tuning_enable_i(oct0_ctle_tuning_en),			       
				       .octal_ctle_init_enable_i(oct0_ctle_init_en),			       
				       .chan_id_i(oct0_ctle_tune_ch), // channels to be tunned				       
				       .ctle_tuning_state_o(ctle_tuning_state[7:0]), //debug
				       .channel_ctle_tuning_done_o(oct0_ctle_tuning_done),
				       //
				       .drpclk_i(drpclk_in),
				       .drpdo_i(oct0_drpdo),
				       .drpdi_o(oct0_ctle_drpdi),
				       .drpaddr_o(oct0_ctle_drpaddr),
				       .drprdy_i(oct0_drprdy),
				       .drpen_o(oct0_ctle_drpen),
				       .drpwe_o(oct0_ctle_drpwe)
				       );
				   
   
assign oct0_gt0_ctle_tuning_done = (EXAMPLE_SIMULATION == 1) ? 1'b1 : oct0_ctle_tuning_done[0];
     
   gtz_caui4_v3_0_rx_startup_fsm reset_fsm_oct0_gt0_i (
						      .SYSCLK_IN(sysclk_in),
						      .RESET_IN(gt0_rxreset),
						      .RXRDY_IN(oct0_gt0_rxrdy),
						      .MMCM_LOCKED(mmcm_locked),
						      .RXRESETDONE_IN(oct0_gt0_rxresetdone),
						      .DATA_OK_IN(oct0_rxok0_in),
						      .CTLE_TUNING_DONE_IN(oct0_gt0_ctle_tuning_done),
						      .GTRXRESET_OUT(oct0_gt0_rxreset),
						      .CTLE_EN_OUT(oct0_gt0_tuning_en),
						      .CTLE_INIT_OUT(oct0_gt0_init_en),
						      .RXFIBRESET_OUT(oct0_gt0_rxfibreset),
						      .RESETFSMDONE_OUT(oct0_gt0_rxresetdone_w),
						      .fsm_state(rx_startup_state0)//debug
						      );
						      
   assign gt0_rxreset = (oct0_gtzrxreset0_in || !txfsm_reset_done0);
   assign oct0_rxresetdone0_out = oct0_gt0_rxresetdone_w;
   assign oct0_rxrdy0_out       = oct0_gt0_rxrdy;	
   assign oct0_txresetdone0_out = txfsm_reset_done0;
					
assign oct0_gt1_ctle_tuning_done = (EXAMPLE_SIMULATION == 1) ? 1'b1 : oct0_ctle_tuning_done[1];
     
   gtz_caui4_v3_0_rx_startup_fsm reset_fsm_oct0_gt1_i (
						      .SYSCLK_IN(sysclk_in),
						      .RESET_IN(gt1_rxreset),
						      .RXRDY_IN(oct0_gt1_rxrdy),
						      .MMCM_LOCKED(mmcm_locked),
						      .RXRESETDONE_IN(oct0_gt1_rxresetdone),
						      .DATA_OK_IN(oct0_rxok1_in),
						      .CTLE_TUNING_DONE_IN(oct0_gt1_ctle_tuning_done),
						      .GTRXRESET_OUT(oct0_gt1_rxreset),
						      .CTLE_EN_OUT(oct0_gt1_tuning_en),
						      .CTLE_INIT_OUT(oct0_gt1_init_en),
						      .RXFIBRESET_OUT(oct0_gt1_rxfibreset),
						      .RESETFSMDONE_OUT(oct0_gt1_rxresetdone_w),
						      .fsm_state(rx_startup_state1)//debug
						      );
						      
   assign gt1_rxreset = (oct0_gtzrxreset1_in || !txfsm_reset_done1);
   assign oct0_rxresetdone1_out = oct0_gt1_rxresetdone_w;
   assign oct0_rxrdy1_out       = oct0_gt1_rxrdy;	
   assign oct0_txresetdone1_out = txfsm_reset_done1;
					
assign oct0_gt2_ctle_tuning_done = (EXAMPLE_SIMULATION == 1) ? 1'b1 : oct0_ctle_tuning_done[2];
     
   gtz_caui4_v3_0_rx_startup_fsm reset_fsm_oct0_gt2_i (
						      .SYSCLK_IN(sysclk_in),
						      .RESET_IN(gt2_rxreset),
						      .RXRDY_IN(oct0_gt2_rxrdy),
						      .MMCM_LOCKED(mmcm_locked),
						      .RXRESETDONE_IN(oct0_gt2_rxresetdone),
						      .DATA_OK_IN(oct0_rxok2_in),
						      .CTLE_TUNING_DONE_IN(oct0_gt2_ctle_tuning_done),
						      .GTRXRESET_OUT(oct0_gt2_rxreset),
						      .CTLE_EN_OUT(oct0_gt2_tuning_en),
						      .CTLE_INIT_OUT(oct0_gt2_init_en),
						      .RXFIBRESET_OUT(oct0_gt2_rxfibreset),
						      .RESETFSMDONE_OUT(oct0_gt2_rxresetdone_w),
						      .fsm_state(rx_startup_state2)//debug
						      );

   assign gt2_rxreset = (oct0_gtzrxreset2_in || !txfsm_reset_done2);
   assign oct0_rxresetdone2_out = oct0_gt2_rxresetdone_w;
   assign oct0_rxrdy2_out       = oct0_gt2_rxrdy;	
   assign oct0_txresetdone2_out = txfsm_reset_done2;
   					
assign oct0_gt3_ctle_tuning_done = (EXAMPLE_SIMULATION == 1) ? 1'b1 : oct0_ctle_tuning_done[3];
     
   gtz_caui4_v3_0_rx_startup_fsm reset_fsm_oct0_gt3_i (
						      .SYSCLK_IN(sysclk_in),
						      .RESET_IN(gt3_rxreset),
						      .RXRDY_IN(oct0_gt3_rxrdy),
						      .MMCM_LOCKED(mmcm_locked),
						      .RXRESETDONE_IN(oct0_gt3_rxresetdone),
						      .DATA_OK_IN(oct0_rxok3_in),
						      .CTLE_TUNING_DONE_IN(oct0_gt3_ctle_tuning_done),
						      .GTRXRESET_OUT(oct0_gt3_rxreset),
						      .CTLE_EN_OUT(oct0_gt3_tuning_en),
						      .CTLE_INIT_OUT(oct0_gt3_init_en),
						      .RXFIBRESET_OUT(oct0_gt3_rxfibreset),
						      .RESETFSMDONE_OUT(oct0_gt3_rxresetdone_w),
						      .fsm_state(rx_startup_state3)//debug
						      );

   assign gt3_rxreset = (oct0_gtzrxreset3_in || !txfsm_reset_done3);
   assign oct0_rxresetdone3_out = oct0_gt3_rxresetdone_w;
   assign oct0_rxrdy3_out       = oct0_gt3_rxrdy;	
   assign oct0_txresetdone3_out = txfsm_reset_done3;

   assign dbg_state = {ctle_tuning_state[7:0], // 31:24
                       rx_startup_state3[3:0], // 23:20
                       rx_startup_state2[3:0], // 19:16
                       rx_startup_state1[3:0], // 15:12
                       rx_startup_state0[3:0], // 11:8
                       tx_startup_state1[3:0], // 7:4
                       tx_startup_state0[3:0]};// 3:0
                       
/////////////////////////////////////////////////////////////////////////////////
// Chipscope
/////////////////////////////////////////////////////////////////////////////////

//  cgmii_ila ILA (
//     .clk(rxusrclk1_in),           //txusrclk0_in), 
//     .probe0(probe0),
//     .probe1(probe1),
//     .probe2(probe2)
//   );
 

 assign probe0 = { 32'h00000000,
 //                   oct0_txdata2_in,
 //                   oct0_txdata1_in,
 //                   oct0_txdata0_in };
                   160'h0000000000000000000000000000000000000000,
                   oct0_rxdata1,
                   oct0_rxdata0  };  // Data blocks
                   
 assign probe1 = { 4'b0000,             // 63:60
                   oct0_rxdatavalid1,   // 55:59
                   oct0_rxdatavalid0,   // 50:54
                   oct0_rxheadervalid1, // 45:49
                   oct0_rxheadervalid0, // 40:44
                   10'b0,               // 30:39
                   10'b0,               // 20:29
                   oct0_rxheader1,      // 10:19
                   oct0_rxheader0 };    // 00:00 Sync headers
 
 // assign probe1 = { 28'h0000000,
 //                   oct0_txheader2_in,
 //                   oct0_txheader1_in,
 //                   oct0_txheader0_in }; // Sync headers
 
  assign probe2 = 32'h00000000;
 
//                   
// assign probe2 = {  
//    oct0_gtzinitdoneb, // 31
//    oct0_ctle_tuning_reset, //30
//    // oct0_txresetdone2,
//    oct0_txresetdone1,
//    oct0_txresetdone0, // 28
//    oct0_gt3_rxresetdone,
//    oct0_gt2_rxresetdone,
//    oct0_gt1_rxresetdone,
//    oct0_gt0_rxresetdone, // 24
//    oct0_gt3_rxresetdone_w,
//    oct0_gt2_rxresetdone_w,
//    oct0_gt1_rxresetdone_w,
//    oct0_gt0_rxresetdone_w, // 20
//    oct0_gt3_rxfibreset,
//    oct0_gt2_rxfibreset,
//    oct0_gt1_rxfibreset,
//    oct0_gt0_rxfibreset, // 16
//    oct0_gt3_rxreset,  
//    oct0_gt2_rxreset,
//    oct0_gt1_rxreset, 
//    oct0_gt0_rxreset, // 12
//    oct0_txreset3,
//    oct0_txreset2,
//    oct0_txreset1,
//    oct0_txreset0,
//    // soft_reset_in, 
//    // oct0_txen0_in,  // = rxen,..
//    oct0_gt3_rxrdy, // 7
//    oct0_gt2_rxrdy,
//    oct0_gt1_rxrdy,
//    oct0_gt0_rxrdy,
//    oct0_txrdy3, // 3
//    oct0_txrdy2,
//    oct0_txrdy1,
//    oct0_txrdy0
// };  

// drpila DRP_ILA (
//    .clk(sysclk_in),           //txusrclk0_in), 
//    .probe0(drp_probe)
//  );
   
//   assign drp_probe = {
//                   oct0_gt3_rxrdy,            // 31
//                   oct0_gt2_rxrdy,            // 30 
//                   oct0_gt1_rxrdy,            // 29
//                   oct0_gt0_rxrdy,            // 28
//                   oct0_gt3_rxresetdone_w,    // 27                    
//                   oct0_gt2_rxresetdone_w,    // 26 
//                   oct0_gt1_rxresetdone_w,    // 25 
//                   oct0_gt0_rxresetdone_w,    // 24
//                   oct0_gt3_rxreset,          // 23
//                   oct0_gt2_rxreset,          // 22
//                   oct0_gt1_rxreset,          // 21
//                   oct0_gt0_rxreset,          // 20
//                   ctle_tuning_state[6:0],    // 19:13 
//                   gt3_rxreset,               // 12 
//                   gt2_rxreset,               // 11 
//                   gt1_rxreset,               // 10 
//                   gt0_rxreset,               // 9 
//                   oct0_gt3_rxresetdone,      // 8 
//                   oct0_gt2_rxresetdone,      // 7 
//                   oct0_gt1_rxresetdone,      // 6 
//                   oct0_gt0_rxresetdone,      // 5 
//                   mmcm_locked,               // 4 
//                   oct0_gt3_ctle_tuning_done, // 3 
//                   oct0_gt2_ctle_tuning_done, // 2
//                   oct0_gt1_ctle_tuning_done, // 1 
//                   oct0_gt0_ctle_tuning_done  // 0 
//               };

 assign drp_probe = {  
    oct0_gtzinitdoneb, // 31
    soft_reset, //30
    oct0_txresetdone1,
    oct0_txresetdone0, // 28
    oct0_gt3_rxresetdone,
    oct0_gt2_rxresetdone,
    oct0_gt1_rxresetdone,
    oct0_gt0_rxresetdone, // 24
    oct0_gt3_rxresetdone_w,
    oct0_gt2_rxresetdone_w,
    oct0_gt1_rxresetdone_w,
    oct0_gt0_rxresetdone_w, // 20
    oct0_gt3_rxfibreset,
    oct0_gt2_rxfibreset,
    oct0_gt1_rxfibreset,
    oct0_gt0_rxfibreset, // 16
    oct0_gt3_rxreset,  
    oct0_gt2_rxreset,
    oct0_gt1_rxreset, 
    oct0_gt0_rxreset, // 12
    oct0_txreset3,
    oct0_txreset2,
    oct0_txreset1,
    oct0_txreset0,
    oct0_gt3_rxrdy, // 7
    oct0_gt2_rxrdy,
    oct0_gt1_rxrdy,
    oct0_gt0_rxrdy,
    oct0_txrdy3, // 3
    oct0_txrdy2,
    oct0_txrdy1,
    oct0_txrdy0
 };  
 
//   assign drp_probe = {ctle_tuning_state[7:0], // 31:24
//                       rx_startup_state3[3:0], // 23:20
//                       rx_startup_state2[3:0], // 19:16
//                       rx_startup_state1[3:0], // 15:12
//                       rx_startup_state0[3:0], // 11:8
//                       oct0_ctle_tuning_done
//                      };


endmodule

