`default_nettype wire
`timescale 1ns / 1ps
`define DLY #1


//***************************** Entity Declaration ****************************

module gtz_caui4_v3_0_tx_interface 
   (
    tx_usrclk_in,
    tx_system_reset_in,
    tx_data_in,
    tx_dataready_in,
    tx_data_out,   
    tx_header_out,
    tx_dataready_out
    );
   
   input tx_usrclk_in;
   input tx_system_reset_in;
   
   input [329:0]  tx_data_in;
   input          tx_dataready_in;
   
   output [159:0] tx_data_out;
   output [9:0]   tx_header_out; 
   output [4:0]   tx_dataready_out;
   
  function [31:0] reverse32(input [31:0] forward);
    integer i;
    for (i=0; i<=31; i=i+1)
      reverse32[31-i] = forward[i];
  endfunction   
   
   reg  switch = 1'b1;
   wire ready;

   wire [1:0] 	     txheaderA_i;
   wire [1:0] 	     txheaderB_i;
   wire [1:0] 	     txheaderC_i;
   wire [1:0] 	     txheaderD_i;
   wire [1:0] 	     txheaderE_i;

   wire [31:0]       txdataA_H_i;
   wire [31:0]       txdataB_H_i;
   wire [31:0]       txdataC_H_i;
   wire [31:0]       txdataD_H_i;
   wire [31:0]       txdataE_H_i;
   
   wire [31:0]       txdataA_L_i;
   wire [31:0]       txdataB_L_i;
   wire [31:0]       txdataC_L_i;
   wire [31:0]       txdataD_L_i;
   wire [31:0]       txdataE_L_i;   
   
   reg  [31:0]       txdataA_L_r;
   reg  [31:0]       txdataB_L_r;
   reg  [31:0]       txdataC_L_r;
   reg  [31:0]       txdataD_L_r;
   reg  [31:0]       txdataE_L_r;
   
   reg  [31:0]       txdataA_H_r;
   reg  [31:0]       txdataB_H_r;
   reg  [31:0]       txdataC_H_r;
   reg  [31:0]       txdataD_H_r;
   reg  [31:0]       txdataE_H_r;   
   
   always @(posedge tx_usrclk_in)
    begin
       if (tx_system_reset_in | !tx_dataready_in)
         switch <= 1'b0;
       else // if (tx_dataready_in)
         switch <= `DLY !switch;
    end
    
    assign  ready = tx_dataready_in & switch;
   
    assign  txheaderA_i = {tx_data_in[0], tx_data_in[1]};
    assign  txheaderB_i = {tx_data_in[66], tx_data_in[67]};
    assign  txheaderC_i = {tx_data_in[132], tx_data_in[133]};
    assign  txheaderD_i = {tx_data_in[198], tx_data_in[199]};
    assign  txheaderE_i = {tx_data_in[264], tx_data_in[265]};

                              
    assign  txdataA_H_i = reverse32(tx_data_in[65:34]);
    assign  txdataB_H_i = reverse32(tx_data_in[131:100]);
    assign  txdataC_H_i = reverse32(tx_data_in[197:166]);
    assign  txdataD_H_i = reverse32(tx_data_in[263:232]);
    assign  txdataE_H_i = reverse32(tx_data_in[329:298]);
                          
    assign  txdataA_L_i = reverse32(tx_data_in[33:2]);
    assign  txdataB_L_i = reverse32(tx_data_in[99:68]);
    assign  txdataC_L_i = reverse32(tx_data_in[165:134]);
    assign  txdataD_L_i = reverse32(tx_data_in[231:200]);
    assign  txdataE_L_i = reverse32(tx_data_in[297:266]);        
    
    always @(posedge tx_usrclk_in)
     begin
       if (ready)
        begin
           txdataA_L_r <= `DLY txdataA_L_i;
           txdataB_L_r <= `DLY txdataB_L_i;
           txdataC_L_r <= `DLY txdataC_L_i;
           txdataD_L_r <= `DLY txdataD_L_i;
           txdataE_L_r <= `DLY txdataE_L_i;
           
           txdataA_H_r <= `DLY txdataA_H_i;
           txdataB_H_r <= `DLY txdataB_H_i;
           txdataC_H_r <= `DLY txdataC_H_i;
           txdataD_H_r <= `DLY txdataD_H_i;
           txdataE_H_r <= `DLY txdataE_H_i;
        end
     end 
     
     assign  tx_header_out = {txheaderE_i,txheaderD_i,txheaderC_i,txheaderB_i,txheaderA_i};
     
     assign  tx_data_out = switch ?
                            {txdataE_L_i,txdataD_L_i,txdataC_L_i,txdataB_L_i,txdataA_L_i} :
                            {txdataE_H_r,txdataD_H_r,txdataC_H_r,txdataB_H_r,txdataA_H_r};                            
                           
    assign  tx_dataready_out = {ready,ready,ready,ready,ready};
       
endmodule     

