`default_nettype wire
`timescale 1ns / 1ps
`define DLY #1


//***************************** Entity Declaration ****************************

module gtz_caui4_v3_0_rx_interface 
   (
    rx_usrclk_in,
    rx_header_in,
    rx_headervalid_in,
    rx_data_in,
    rx_datavalid_in,
    rx_data_out,   
    rx_datavalid_out
    );
   
   input rx_usrclk_in;
   
   input [9:0]   rx_header_in; 
   input [4:0]   rx_headervalid_in;
   input [159:0] rx_data_in;
   input [4:0]   rx_datavalid_in;
   
   output [329:0]  rx_data_out;
   output [4:0]    rx_datavalid_out;
   
  function [31:0] reverse32(input [31:0] forward);
    integer i;                                    
    for (i=0; i<=31; i=i+1)                       
      reverse32[31-i] = forward[i];               
  endfunction                                     
   
   reg [4:0] switch = 5'b0;
   wire ready;

   reg [1:0] 	     rxheaderA_r;
   reg [1:0] 	     rxheaderB_r;
   reg [1:0] 	     rxheaderC_r;
   reg [1:0] 	     rxheaderD_r;
   reg [1:0] 	     rxheaderE_r;

   reg [31:0]        rxdataA_L_r;
   reg [31:0]        rxdataB_L_r;
   reg [31:0]        rxdataC_L_r;
   reg [31:0]        rxdataD_L_r;
   reg [31:0]        rxdataE_L_r;
   
   wire [31:0]       rxdataA_H_i;
   wire [31:0]       rxdataB_H_i;
   wire [31:0]       rxdataC_H_i;
   wire [31:0]       rxdataD_H_i;
   wire [31:0]       rxdataE_H_i;
   
   wire [1:0]        rxheaderA_i;
   wire [1:0]        rxheaderB_i;
   wire [1:0]        rxheaderC_i;
   wire [1:0]        rxheaderD_i;
   wire [1:0]        rxheaderE_i;
   
   assign  rxheaderA_i = {rx_header_in[0], rx_header_in[1]}; 
   assign  rxheaderB_i = {rx_header_in[2], rx_header_in[3]}; 
   assign  rxheaderC_i = {rx_header_in[4], rx_header_in[5]}; 
   assign  rxheaderD_i = {rx_header_in[6], rx_header_in[7]}; 
   assign  rxheaderE_i = {rx_header_in[8], rx_header_in[9]};
   
   assign  rxdataA_H_i = reverse32(rx_data_in[31:0]);
   assign  rxdataB_H_i = reverse32(rx_data_in[63:32]);
   assign  rxdataC_H_i = reverse32(rx_data_in[95:64]);
   assign  rxdataD_H_i = reverse32(rx_data_in[127:96]);
   assign  rxdataE_H_i = reverse32(rx_data_in[159:128]);
    
   always @(posedge rx_usrclk_in)
    begin
      if (rx_headervalid_in[0])
       begin
          rxheaderA_r <= rxheaderA_i;
       end
       
      if (rx_datavalid_in[0])
        begin
           rxdataA_L_r <= rxdataA_H_i;
        end       
       
       if (!rx_datavalid_in[0] && !rx_headervalid_in[0])
          switch[0] <= 1'b0;
       else if (rx_datavalid_in[0])
          switch[0] <= !switch[0];
       
    end 
   
   always @(posedge rx_usrclk_in)
    begin
      if (rx_headervalid_in[1])
       begin
          rxheaderB_r <= rxheaderB_i;
       end
       
      if (rx_datavalid_in[1])
        begin
           rxdataB_L_r <= rxdataB_H_i;
        end       
       
       if (!rx_datavalid_in[1] && !rx_headervalid_in[1])
           switch[1] <= 1'b0;
        else if (rx_datavalid_in[1])
           switch[1] <= !switch[1];
       
    end
     
   always @(posedge rx_usrclk_in)
    begin
      if (rx_headervalid_in[2])
       begin
          rxheaderC_r <= rxheaderC_i;
       end
       
      if (rx_datavalid_in[2])
        begin
           rxdataC_L_r <= rxdataC_H_i;
        end       
       
       if (!rx_datavalid_in[2] && !rx_headervalid_in[2])
           switch[2] <= 1'b0;
        else if (rx_datavalid_in[2])
           switch[2] <= !switch[2];
    end
      
   always @(posedge rx_usrclk_in)
    begin
      if (rx_headervalid_in[3])
       begin
          rxheaderD_r <= rxheaderD_i;
       end
       
      if (rx_datavalid_in[3])
        begin
           rxdataD_L_r <= rxdataD_H_i;
        end       
       
       if (!rx_datavalid_in[3] && !rx_headervalid_in[3])
           switch[3] <= 1'b0;
        else if (rx_datavalid_in[3])
           switch[3] <= !switch[3];
    end
       
   always @(posedge rx_usrclk_in)
    begin
      if (rx_headervalid_in[4])
       begin
          rxheaderE_r <= rxheaderE_i;
       end
       
      if (rx_datavalid_in[4])
        begin
           rxdataE_L_r <= rxdataE_H_i;
        end       
       
       if (!rx_datavalid_in[4] && !rx_headervalid_in[4])
           switch[4] <= 1'b0;
        else if (rx_datavalid_in[4])
           switch[4] <= !switch[4];
    end 
    
 
    assign  rx_data_out = {rxdataE_H_i,rxdataE_L_r,rxheaderE_r,
                           rxdataD_H_i,rxdataD_L_r,rxheaderD_r,
                           rxdataC_H_i,rxdataC_L_r,rxheaderC_r,
                           rxdataB_H_i,rxdataB_L_r,rxheaderB_r,
                           rxdataA_H_i,rxdataA_L_r,rxheaderA_r};
                               
    assign  rx_datavalid_out = switch & rx_datavalid_in;
    
endmodule     
