///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor: Xilinx
// \   \   \/     Version : 3.0
//  \   \         Application : 7 Series FPGAs Transceivers  Wizard
//  /   /         Filename : gtz_caui4_v3_0_gt_usrclk_source.v
// /___/   /\
// \   \  /  \
//  \___\/\___\
//
//
// Module gtz_caui4_v3_0_GT_USRCLK_SOURCE (for use with GTs)
// Generated by Xilinx 7 Series FPGAs Transceivers Wizard
//
//
// (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.


`timescale 1ns / 1ps
`define DLY #1

//***********************************Entity Declaration*******************************
module gtz_caui4_v3_0_GT_USRCLK_SOURCE
(
 //deskew ports
 input 	PSCLK,//tie to DRPCLK
 output PSDONE,
 output MMCM_LOCKED,
 input 	DISABLE_PHASE_ADJUSTMENT,
 input 	RESETDONE,
 output PHASE_SHIFT_DONE,
 input   MMCM_RST,

 input   OCTAL0_TXOUTCLK0,
 input   OCTAL0_TXOUTCLK1,
 input   OCTAL0_RXOUTCLK0,
 input   OCTAL0_RXOUTCLK1,
 input   OCTAL0_RXOUTCLK2,
 input   OCTAL0_RXOUTCLK3,

 output TXUSRCLK0,
 output TXUSRCLK1,
 output TXUSRCLK2,
 output TXUSRCLK3,
 output TXUSRCLK4,
 output TXUSRCLK5,
 output TXUSRCLK6,
 output TXUSRCLK7,

 output RXINTCLK,

 output RXUSRCLK0,
 output RXUSRCLK1,
 output RXUSRCLK2,
 output RXUSRCLK3,
 output RXUSRCLK4,
 output RXUSRCLK5,
 output RXUSRCLK6,
 output RXUSRCLK7

);


   parameter integer SHIFT_COUNT          = 156;

   //deskew regs n wires
   reg 	psen_reg;
   reg 	psincdec_reg;
   reg [3:0] p_state;
   reg [3:0] n_state;
   reg [2:0] psdone_reg;
   reg [15:0] count;

   parameter [3:0] START_PHASE_ADJUSTMENT = 4'b0000;
   parameter [3:0] ASSERT_PSEN            = 4'b0001;
   parameter [3:0] WAIT_FOR_PSDONE        = 4'b0010;
   parameter [3:0] SHIFT_DONE             = 4'b0100;
   parameter [3:0] END                    = 4'b1000;


// DISABLE_ input resets the Soft logic around the MMCM
    //

reg softip_rst_b;


    // Reset logic to avoid glitches
    // de-assertion of RESETDONE and DISABLing of soft_ip
    // brings the softIP to reset, but MMCM should work
    // as normal.
    //
    // MMCM needs to reset whenever rxresetdone deasserts
    // this will undo the previous phase shift made by the fsm
    //
    always @( posedge PSCLK or posedge MMCM_RST ) begin
       if( MMCM_RST ) begin
         softip_rst_b <= `DLY 1'b0;
       end else begin
         softip_rst_b <= `DLY ~( DISABLE_PHASE_ADJUSTMENT | ( ~DISABLE_PHASE_ADJUSTMENT & ~RESETDONE ));
       end
    end


  assign RXUSRCLK0 = 1'b0;//unused clock
  wire mmcm_fb_out_rx1;
  wire mmcm_fb_in_rx1;
  wire mmcm_clk_out_rx1;
  wire mmcm_clk_out_rxint;
  wire RXBUFH1;

  BUFH clkbufhrx1 (.I(OCTAL0_RXOUTCLK0), .O(RXBUFH1));

  BUFG mmcm_fb_buf_rx1
    (
     .I(mmcm_fb_out_rx1),
     .O(mmcm_fb_in_rx1));

  BUFG mmcm_out_rx1
    (
     .I(mmcm_clk_out_rx1),
     .O(RXUSRCLK1));

  BUFG mmcm_out_rxclkint
    (
     .I(mmcm_clk_out_rxint),
     .O(RXINTCLK));

  MMCME2_ADV
  #(.BANDWIDTH            ("OPTIMIZED"),
    .CLKOUT4_CASCADE      ("FALSE"),
    .COMPENSATION         ("BUF_IN"),
    .STARTUP_WAIT         ("FALSE"),
    .DIVCLK_DIVIDE        (1),
    .CLKFBOUT_MULT_F      (5.0),
    .CLKFBOUT_PHASE       (0.000),
    .CLKFBOUT_USE_FINE_PS ("FALSE"),
    .CLKOUT0_DIVIDE_F     (4.000),
    .CLKOUT0_PHASE        (0.000),
    .CLKOUT0_DUTY_CYCLE   (0.500),
    .CLKOUT0_USE_FINE_PS  ("FALSE"),
    .CLKIN1_PERIOD        (6.206),
    .CLKOUT1_DIVIDE       (5),
    .CLKOUT1_PHASE        (0.000),
    .CLKOUT1_DUTY_CYCLE   (0.500),
    .CLKOUT1_USE_FINE_PS  ("TRUE"),
    .CLKOUT2_DIVIDE       (1),
    .CLKOUT2_PHASE        (0.000),
    .CLKOUT2_DUTY_CYCLE   (0.500),
    .CLKOUT2_USE_FINE_PS  ("FALSE"),
    .CLKOUT3_DIVIDE       (1),
    .CLKOUT3_PHASE        (0.000),
    .CLKOUT3_DUTY_CYCLE   (0.500),
    .CLKOUT3_USE_FINE_PS  ("FALSE"),
    .REF_JITTER1          (0.010),
    .REF_JITTER2          (0.010))

  mmcm_adv_inst_rx1
    // Output clocks
   (.CLKFBOUT            (mmcm_fb_out_rx1),
    .CLKFBOUTB           (),
    .CLKOUT0             (mmcm_clk_out_rxint),
    .CLKOUT0B            (),
    .CLKOUT1             (mmcm_clk_out_rx1),
    .CLKOUT1B            (),
    .CLKOUT2             (),
    .CLKOUT2B            (),
    .CLKOUT3             (),
    .CLKOUT3B            (),
    .CLKOUT4             (),
    .CLKOUT5             (),
    .CLKOUT6             (),
     // Input clock control
    .CLKFBIN             (mmcm_fb_in_rx1),
    .CLKIN1              (RXBUFH1),
    .CLKIN2              (1'b0),
     // Tied to always select the primary input clock
    .CLKINSEL            (1'b1),
    // Ports for dynamic reconfiguration
    .DADDR               (7'h0),
    .DCLK                (1'b0),
    .DEN                 (1'b0),
    .DI                  (16'h0),
    .DO                  (),
    .DRDY                (),
    .DWE                 (1'b0),
    // Ports for dynamic phase shift
    .PSCLK               (PSCLK),
    .PSEN                (psen_reg),
    .PSINCDEC            (psincdec_reg),
    .PSDONE              (PSDONE),
    // Other control and status signals
    .LOCKED              (MMCM_LOCKED),
    .CLKINSTOPPED        (),
    .CLKFBSTOPPED        (),
    .PWRDWN              (1'b0),
    .RST                 (MMCM_RST));

  assign RXUSRCLK2 = 1'b0;//unused clock
  assign RXUSRCLK3 = 1'b0;//unused clock
  assign RXUSRCLK4 = 1'b0;//unused clock
  assign RXUSRCLK5 = 1'b0;//unused clock
  assign RXUSRCLK6 = 1'b0;//unused clock
  assign RXUSRCLK7 = 1'b0;//unused clock



  assign TXUSRCLK0 = 1'b0;//will be driven by BUFG_LB in beachfront
  assign TXUSRCLK1 = 1'b0;//unused clock
  assign TXUSRCLK2 = 1'b0;//unused clock
  assign TXUSRCLK3 = 1'b0;//unused clock
  assign TXUSRCLK4 = 1'b0;//unused clock
  assign TXUSRCLK5 = 1'b0;//unused clock
  assign TXUSRCLK6 = 1'b0;//unused clock
  assign TXUSRCLK7 = 1'b0;//unused clock

//deskew logic
// FSM sequentional block
    // PSDONE is pipelined to delay the next PSEN assertion
    //
    always @ (posedge PSCLK or negedge softip_rst_b ) begin // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      if ( !softip_rst_b ) begin
        p_state    <= `DLY START_PHASE_ADJUSTMENT;
        psdone_reg <= `DLY 3'b0;
      end else begin
        p_state <= `DLY n_state;
        psdone_reg <= `DLY {psdone_reg[1:0],PSDONE};
      end
    end

   wire  phase_shift_done = ( count == SHIFT_COUNT );

    // FSM  combination NS logic
    //
    always @ (*) begin
      case ( p_state )
        START_PHASE_ADJUSTMENT : n_state = ( MMCM_LOCKED      ) ?  ASSERT_PSEN : START_PHASE_ADJUSTMENT;
        ASSERT_PSEN            : n_state =   WAIT_FOR_PSDONE;
        WAIT_FOR_PSDONE        : n_state = ( psdone_reg[2]    ) ?  SHIFT_DONE  : WAIT_FOR_PSDONE;
        SHIFT_DONE             : n_state = ( phase_shift_done ) ?  END         : ASSERT_PSEN;
        END                    : n_state =  END;
        default : n_state = START_PHASE_ADJUSTMENT;
      endcase
    end

    assign PHASE_SHIFT_DONE  = p_state[3];
    assign PSEN              = p_state[0];
    //assign TEST_PSDONE       = ( PHASE_SHIFT_DONE ) ? PSDONE : 1'b0;

    // Count logic
    // 1 count = 13.1ps or the resolution set by MMCM
    // variables.
    //
    always @ (posedge PSCLK or negedge softip_rst_b ) begin // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      if ( !softip_rst_b ) begin
        count    <= `DLY  16'd0;
        psen_reg <= `DLY  1'b0;
        psincdec_reg <= `DLY  1'b0;
      end else begin
        psen_reg     <= `DLY PHASE_SHIFT_DONE ? 1'b0 : PSEN;
        psincdec_reg <= `DLY 1'b0;
        if ( PSDONE & ~PHASE_SHIFT_DONE ) begin
            count <= `DLY count + 16'd1;
        end
      end
    end


endmodule


