////////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   / 
// /___/  \  /    Vendor: Xilinx 
// \   \   \/     Version : 3.2
//  \   \         Application : 7 Series FPGAs Transceivers Wizard 
//  /   /         Filename : gtz_caui4_octal0.v
// /___/   /\     
// \   \  /  \ 
//  \___\/\___\ 
//
//
// Module gtz_caui4_OCTAL0 (GTZ wrapper for the South (bottom) octal)
// Generated by Xilinx 7 Series FPGAs Transceivers Wizard      
// 
// 
// (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
// 
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
// 
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
// 
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
// 
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES. 


`default_nettype wire

`timescale 1ns / 1ps


//***************************** Entity Declaration ****************************

module gtz_caui4_OCTAL0_main #
      (
       // Simulation attributes
       parameter   SIM_GTZRESET_SPEEDUP     =   "TRUE",       // Set to 1 to speed up sim reset;
       parameter   RXUSRCLK_LANE0_VAR       =  "RXUSRCLK1",
       parameter   RXUSRCLK_LANE1_VAR       =  "RXUSRCLK1",
       parameter   RXUSRCLK_LANE2_VAR       =  "RXUSRCLK1",
       parameter   RXUSRCLK_LANE3_VAR       =  "RXUSRCLK1",
       parameter   RXUSRCLK_LANE4_VAR       =  "RXUSRCLK0",
       parameter   RXUSRCLK_LANE5_VAR       =  "RXUSRCLK0",
       parameter   RXUSRCLK_LANE6_VAR       =  "RXUSRCLK0",
       parameter   RXUSRCLK_LANE7_VAR       =  "RXUSRCLK0",
       parameter   TXUSRCLK_LANE0_VAR       =  "TXUSRCLK0",
       parameter   TXUSRCLK_LANE1_VAR       =  "TXUSRCLK0",
       parameter   TXUSRCLK_LANE2_VAR       =  "TXUSRCLK0",
       parameter   TXUSRCLK_LANE3_VAR       =  "TXUSRCLK0",
       parameter   TXUSRCLK_LANE4_VAR       =  "TXUSRCLK0",
       parameter   TXUSRCLK_LANE5_VAR       =  "TXUSRCLK0",
       parameter   TXUSRCLK_LANE6_VAR       =  "TXUSRCLK0",
       parameter   TXUSRCLK_LANE7_VAR       =  "TXUSRCLK0",
       parameter   SIM_VERSION              =  "1.0"
       )
      (
       //----------------------- REFCLK Ports -------------------------------
       input gtrefclk0p_in,
       input gtrefclk0n_in,
       input gtrefclk1p_in,
       input gtrefclk1n_in,

       output rxcoreclk0_out,
       output rxcoreclk1_out,
       output rxcoreclk2_out,
       output rxcoreclk3_out,
       output txcoreclk0_out,
       output txcoreclk1_out,

       input rxusrclk0_in,
       input rxusrclk1_in,
       input rxusrclk2_in,
       input rxusrclk3_in,
       input rxusrclk4_in,
       input rxusrclk5_in,
       input rxusrclk6_in,
       input rxusrclk7_in,

       input txusrclk0_in,
       input txusrclk1_in,
       input txusrclk2_in,
       input txusrclk3_in,
       input txusrclk4_in,
       input txusrclk5_in,
       input txusrclk6_in,
       input txusrclk7_in,

       input drpclk0_in,
       input drpclk1_in,
       input drpclksel_in,

	 //-------------------------------- Serial Ports ---------------------------------
						
       output gtztxp0_out,
       output gtztxn0_out,
       input gtzrxp0_in,
       input gtzrxn0_in,
			      
						
       output gtztxp1_out,
       output gtztxn1_out,
       input gtzrxp1_in,
       input gtzrxn1_in,
			      
						
       output gtztxp2_out,
       output gtztxn2_out,
       input gtzrxp2_in,
       input gtzrxn2_in,
			      
						
       output gtztxp3_out,
       output gtztxn3_out,
       input gtzrxp3_in,
       input gtzrxn3_in,
			      
    // ---------------------------- RX/TX polarity control -------------------
       input   [3:0]   oct0_gtzrxpolarity_in,
       input   [3:0]   oct0_gtztxpolarity_in,			      
      
    //----------------------------- BitSlip Ports ------------------------------
    input   [4:0]   rxgearboxslip0_in,
    input   [4:0]   rxgearboxslip1_in,
    input   [4:0]   rxgearboxslip2_in,
    input   [4:0]   rxgearboxslip3_in,
    //----------------------------- Clocking Ports -----------------------------
    input           refclksel0_in,
    input           refclksel1_in,
    input           refclksel2_in,
    input           refclksel3_in,
    output          rxoutclk0_out,
    output          rxoutclk1_out,
    output          rxoutclk2_out,
    output          rxoutclk3_out,
    output          txoutclk0_out,
    output          txoutclk1_out,
    //-------------------------- Configuration Ports ---------------------------
    input           gtzinit_in,
    output          gtzinitdoneb_out,
    input           pllrecalen0_in,
    input           pllrecalen1_in,
    input           pllrecalen2_in,
    input           pllrecalen3_in,    
    input           txen0_in,    
    input           txen1_in,    
    input           txen2_in,    
    input           txen3_in,
    input           rxen0_in,    
    input           rxen1_in,    
    input           rxen2_in,    
    input           rxen3_in,
    //------------------------------- DRP Ports --------------------------------
    input   [15:0]  drpaddr_in,
    input   [31:0]  drpdi_in,
    output  [31:0]  drpdo_out,
    input           drpen_in,
    output          drprdy_out,
    output  [2:0]   drpstatus_out,
    output          drpwdterr_out,
    input           drpwe_in,
    //---------------------------- FIB Reset Ports -----------------------------
    input           rxfibreset0_in,
    input           rxfibreset1_in,
    input           rxfibreset2_in,
    input           rxfibreset3_in,
    //-------------------------- Latency clock Ports ---------------------------
    input           rxlatclk_in,
    input           txlatclk_in,
    //------------------------------- Loopbacks --------------------------------
    input           nearloopbacken0_in,
    input           nearloopbacken1_in,
    input           nearloopbacken2_in,
    input           nearloopbacken3_in,
    //-------------------------- Rx Fabric Interface ---------------------------
    output  [159:0] rxdata0_out,
    output  [159:0] rxdata1_out,
    output  [159:0] rxdata2_out,
    output  [159:0] rxdata3_out,
    output  [4:0]   rxdatavalid0_out,
    output  [4:0]   rxdatavalid1_out,
    output  [4:0]   rxdatavalid2_out,
    output  [4:0]   rxdatavalid3_out,
    output  [9:0]   rxheader0_out,
    output  [9:0]   rxheader1_out,
    output  [9:0]   rxheader2_out,
    output  [9:0]   rxheader3_out,
    output  [4:0]   rxheadervalid0_out,
    output  [4:0]   rxheadervalid1_out,
    output  [4:0]   rxheadervalid2_out,
    output  [4:0]   rxheadervalid3_out,
    //-------------------------- Rx Reset Controller ---------------------------
    input           gtzrxreset0_in,
    input           gtzrxreset1_in,
    input           gtzrxreset2_in,
    input           gtzrxreset3_in,
    output          rxrdy0_out,
    output          rxrdy1_out,
    output          rxrdy2_out,
    output          rxrdy3_out,
    output          rxresetdone0_out,
    output          rxresetdone1_out,
    output          rxresetdone2_out,
    output          rxresetdone3_out,
    //-------------------------- Tx Fabric Interface ---------------------------
    input   [159:0] txdata0_in,
    input   [159:0] txdata1_in,
    input   [159:0] txdata2_in,
    input   [159:0] txdata3_in,
    input   [9:0]   txheader0_in,
    input   [9:0]   txheader1_in,
    input   [9:0]   txheader2_in,
    input   [9:0]   txheader3_in,
    //-------------------------- Tx Reset Controller ---------------------------
    input           gtztxreset0_in,
    input           gtztxreset1_in,
    input           gtztxreset2_in,
    input           gtztxreset3_in,
    output          txrdy0_out,
    output          txrdy1_out,
    output          txrdy2_out,
    output          txrdy3_out,
    output          txresetdone0_out,
    output          txresetdone1_out,
    output          txresetdone2_out,
    output          txresetdone3_out,
    //--------------------------- Tx sequence Ports ----------------------------
    input   [6:0]   txsequence0_in,
    input   [6:0]   txsequence1_in,
    input   [6:0]   txsequence2_in,
    input   [6:0]   txsequence3_in


);


//***************************** Wire Declarations *****************************

    // ground and vcc signals
wire            tied_to_ground_i;
wire    [159:0] tied_to_ground_vec_i;
wire            tied_to_vcc_i;
wire    [159:0] tied_to_vcc_vec_i;

    //----------------------------- BitSlip Ports ------------------------------
    wire             B2M_RXBITSLIP0;
    wire             B2M_RXBITSLIP1;
    wire             B2M_RXBITSLIP2;
    wire             B2M_RXBITSLIP3;
    wire             B2M_RXBITSLIP4;
    wire             B2M_RXBITSLIP5;
    wire             B2M_RXBITSLIP6;
    wire             B2M_RXBITSLIP7;
    wire     [4:0]   B2M_RXGEARBOXSLIP0;
    wire     [4:0]   B2M_RXGEARBOXSLIP1;
    wire     [4:0]   B2M_RXGEARBOXSLIP2;
    wire     [4:0]   B2M_RXGEARBOXSLIP3;
    wire     [4:0]   B2M_RXGEARBOXSLIP4;
    wire     [4:0]   B2M_RXGEARBOXSLIP5;
    wire     [4:0]   B2M_RXGEARBOXSLIP6;
    wire     [4:0]   B2M_RXGEARBOXSLIP7;
    //----------------------------- Clocking Ports -----------------------------
    wire             B2M_REFCLKSEL0;
    wire             B2M_REFCLKSEL1;
    wire             B2M_REFCLKSEL2;
    wire             B2M_REFCLKSEL3;
    wire             B2M_REFCLKSEL4;
    wire             B2M_REFCLKSEL5;
    wire             B2M_REFCLKSEL6;
    wire             B2M_REFCLKSEL7;
    wire             M2B_RXOUTCLK0;
    wire             M2B_RXOUTCLK1;
    wire             M2B_RXOUTCLK2;
    wire             M2B_RXOUTCLK3;
    wire             M2B_TXOUTCLK0;
    wire             M2B_TXOUTCLK1;
    //-------------------------- Configuration Ports ---------------------------
    wire             M2B_CFGBADVERSIONB;
    wire             B2M_CFGCLK;
    wire     [1:0]   M2B_CFGCRCERRB;
    wire     [31:0]  B2M_CFGDATA;
    wire             B2M_CFGDATAVALID;
    wire     [2:0]   B2M_CFGDEBUGMODEB;
    wire     [1:0]   B2M_CFGFORCESEUERRB;
    wire             M2B_CFGGTZDONEB;
    wire             B2M_CFGREADBACKB;
    wire     [1:0]   M2B_CFGSEUERRB;
    wire             B2M_GTZINIT;
    wire             M2B_GTZINITDONEB;
    //------------------------------- DRP Ports --------------------------------
    wire     [15:0]  B2M_DRPADDR;
    wire     [31:0]  B2M_DRPDI;
    wire     [31:0]  M2B_DRPDO;
    wire             B2M_DRPEN;
    wire             M2B_DRPRDY;
    wire     [2:0]   M2B_DRPSTATUS;
    wire             M2B_DRPWDTERR;
    wire             B2M_DRPWE;
    //---------------------------- FIB Reset Ports -----------------------------
    wire             B2M_RXFIBRESET0;
    wire             B2M_RXFIBRESET1;
    wire             B2M_RXFIBRESET2;
    wire             B2M_RXFIBRESET3;
    wire             B2M_RXFIBRESET4;
    wire             B2M_RXFIBRESET5;
    wire             B2M_RXFIBRESET6;
    wire             B2M_RXFIBRESET7;
    wire             B2M_TXFIBRESET0;
    wire             B2M_TXFIBRESET1;
    wire             B2M_TXFIBRESET2;
    wire             B2M_TXFIBRESET3;
    wire             B2M_TXFIBRESET4;
    wire             B2M_TXFIBRESET5;
    wire             B2M_TXFIBRESET6;
    wire             B2M_TXFIBRESET7;
    //------------------------------- FIFO Ports -------------------------------
    wire     [1:0]   M2B_RXFIFOSTATUS0;
    wire     [1:0]   M2B_RXFIFOSTATUS1;
    wire     [1:0]   M2B_RXFIFOSTATUS2;
    wire     [1:0]   M2B_RXFIFOSTATUS3;
    wire     [1:0]   M2B_RXFIFOSTATUS4;
    wire     [1:0]   M2B_RXFIFOSTATUS5;
    wire     [1:0]   M2B_RXFIFOSTATUS6;
    wire     [1:0]   M2B_RXFIFOSTATUS7;
    wire     [1:0]   M2B_TXFIFOSTATUS0;
    wire     [1:0]   M2B_TXFIFOSTATUS1;
    wire     [1:0]   M2B_TXFIFOSTATUS2;
    wire     [1:0]   M2B_TXFIFOSTATUS3;
    wire     [1:0]   M2B_TXFIFOSTATUS4;
    wire     [1:0]   M2B_TXFIFOSTATUS5;
    wire     [1:0]   M2B_TXFIFOSTATUS6;
    wire     [1:0]   M2B_TXFIFOSTATUS7;
    //-------------------------- Latency clock Ports ---------------------------
    wire             B2M_RXLATCLK;
    wire             B2M_TXLATCLK;
    //------------------------------- Loopbacks --------------------------------
    wire             B2M_FARLOOPBACKEN0;
    wire             B2M_FARLOOPBACKEN1;
    wire             B2M_FARLOOPBACKEN2;
    wire             B2M_FARLOOPBACKEN3;
    wire             B2M_FARLOOPBACKEN4;
    wire             B2M_FARLOOPBACKEN5;
    wire             B2M_FARLOOPBACKEN6;
    wire             B2M_FARLOOPBACKEN7;
    wire             B2M_NEARLOOPBACKEN0;
    wire             B2M_NEARLOOPBACKEN1;
    wire             B2M_NEARLOOPBACKEN2;
    wire             B2M_NEARLOOPBACKEN3;
    wire             B2M_NEARLOOPBACKEN4;
    wire             B2M_NEARLOOPBACKEN5;
    wire             B2M_NEARLOOPBACKEN6;
    wire             B2M_NEARLOOPBACKEN7;
    //------------------------ PLL Recalibration Ports -------------------------
    wire             B2M_PLLRECALEN0;
    wire             B2M_PLLRECALEN1;
    wire             B2M_PLLRECALEN2;
    wire             B2M_PLLRECALEN3;
    wire             B2M_PLLRECALEN4;
    wire             B2M_PLLRECALEN5;
    wire             B2M_PLLRECALEN6;
    wire             B2M_PLLRECALEN7;
    //------------------------------ PLL Settings ------------------------------
    wire     [15:0]  B2M_CORECNTL0;
    wire     [15:0]  B2M_CORECNTL1;
    wire     [15:0]  B2M_CORECNTL2;
    wire     [15:0]  B2M_CORECNTL3;
    wire     [15:0]  B2M_CORECNTL4;
    wire     [15:0]  B2M_CORECNTL5;
    wire     [15:0]  B2M_CORECNTL6;
    wire     [15:0]  B2M_CORECNTL7;
    wire     [7:0]   B2M_REFSEL0;
    wire     [7:0]   B2M_REFSEL1;
    wire     [7:0]   B2M_REFSEL2;
    wire     [7:0]   B2M_REFSEL3;
    wire     [7:0]   B2M_REFSEL4;
    wire     [7:0]   B2M_REFSEL5;
    wire     [7:0]   B2M_REFSEL6;
    wire     [7:0]   B2M_REFSEL7;
    wire     [8:0]   B2M_RXRATESEL0;
    wire     [8:0]   B2M_RXRATESEL1;
    wire     [8:0]   B2M_RXRATESEL2;
    wire     [8:0]   B2M_RXRATESEL3;
    wire     [8:0]   B2M_RXRATESEL4;
    wire     [8:0]   B2M_RXRATESEL5;
    wire     [8:0]   B2M_RXRATESEL6;
    wire     [8:0]   B2M_RXRATESEL7;
    wire     [8:0]   B2M_TXRATESEL0;
    wire     [8:0]   B2M_TXRATESEL1;
    wire     [8:0]   B2M_TXRATESEL2;
    wire     [8:0]   B2M_TXRATESEL3;
    wire     [8:0]   B2M_TXRATESEL4;
    wire     [8:0]   B2M_TXRATESEL5;
    wire     [8:0]   B2M_TXRATESEL6;
    wire     [8:0]   B2M_TXRATESEL7;
    //---------------------------- PMA Enable Ports ----------------------------
    wire             B2M_RXEN0;
    wire             B2M_RXEN1;
    wire             B2M_RXEN2;
    wire             B2M_RXEN3;
    wire             B2M_RXEN4;
    wire             B2M_RXEN5;
    wire             B2M_RXEN6;
    wire             B2M_RXEN7;
    wire             B2M_TXEN0;
    wire             B2M_TXEN1;
    wire             B2M_TXEN2;
    wire             B2M_TXEN3;
    wire             B2M_TXEN4;
    wire             B2M_TXEN5;
    wire             B2M_TXEN6;
    wire             B2M_TXEN7;
    //------------------------------- PRBS Ports -------------------------------
    wire             B2M_RXPRBSEN0;
    wire             B2M_RXPRBSEN1;
    wire             B2M_RXPRBSEN2;
    wire             B2M_RXPRBSEN3;
    wire             B2M_RXPRBSEN4;
    wire             B2M_RXPRBSEN5;
    wire             B2M_RXPRBSEN6;
    wire             B2M_RXPRBSEN7;
    wire             M2B_RXPRBSPASS0;
    wire             M2B_RXPRBSPASS1;
    wire             M2B_RXPRBSPASS2;
    wire             M2B_RXPRBSPASS3;
    wire             M2B_RXPRBSPASS4;
    wire             M2B_RXPRBSPASS5;
    wire             M2B_RXPRBSPASS6;
    wire             M2B_RXPRBSPASS7;
    wire     [2:0]   B2M_RXPRBSSEL0;
    wire     [2:0]   B2M_RXPRBSSEL1;
    wire     [2:0]   B2M_RXPRBSSEL2;
    wire     [2:0]   B2M_RXPRBSSEL3;
    wire     [2:0]   B2M_RXPRBSSEL4;
    wire     [2:0]   B2M_RXPRBSSEL5;
    wire     [2:0]   B2M_RXPRBSSEL6;
    wire     [2:0]   B2M_RXPRBSSEL7;
    wire             B2M_TXPRBSEN0;
    wire             B2M_TXPRBSEN1;
    wire             B2M_TXPRBSEN2;
    wire             B2M_TXPRBSEN3;
    wire             B2M_TXPRBSEN4;
    wire             B2M_TXPRBSEN5;
    wire             B2M_TXPRBSEN6;
    wire             B2M_TXPRBSEN7;
    wire     [2:0]   B2M_TXPRBSSEL0;
    wire     [2:0]   B2M_TXPRBSSEL1;
    wire     [2:0]   B2M_TXPRBSSEL2;
    wire     [2:0]   B2M_TXPRBSSEL3;
    wire     [2:0]   B2M_TXPRBSSEL4;
    wire     [2:0]   B2M_TXPRBSSEL5;
    wire     [2:0]   B2M_TXPRBSSEL6;
    wire     [2:0]   B2M_TXPRBSSEL7;
    //------------------------ Polarity Inversion Ports ------------------------
    wire             B2M_RXPOLARITY0;
    wire             B2M_RXPOLARITY1;
    wire             B2M_RXPOLARITY2;
    wire             B2M_RXPOLARITY3;
    wire             B2M_RXPOLARITY4;
    wire             B2M_RXPOLARITY5;
    wire             B2M_RXPOLARITY6;
    wire             B2M_RXPOLARITY7;
    wire             B2M_TXPOLARITY0;
    wire             B2M_TXPOLARITY1;
    wire             B2M_TXPOLARITY2;
    wire             B2M_TXPOLARITY3;
    wire             B2M_TXPOLARITY4;
    wire             B2M_TXPOLARITY5;
    wire             B2M_TXPOLARITY6;
    wire             B2M_TXPOLARITY7;
    //--------------------------- RX SIGNAL OK Ports ---------------------------
    wire             M2B_RXSIGNALOK0;
    wire             M2B_RXSIGNALOK1;
    wire             M2B_RXSIGNALOK2;
    wire             M2B_RXSIGNALOK3;
    wire             M2B_RXSIGNALOK4;
    wire             M2B_RXSIGNALOK5;
    wire             M2B_RXSIGNALOK6;
    wire             M2B_RXSIGNALOK7;
    //----------------------------- Reserved Ports -----------------------------
    wire     [15:0]  M2B_RSVDOUT;
    wire     [2:0]   B2M_FIBRSVDIN1;
    wire     [2:0]   B2M_FIBRSVDIN2;
    wire     [2:0]   B2M_FIBRSVDIN3;
    wire     [2:0]   B2M_FIBRSVDIN4;
    wire     [2:0]   B2M_FIBRSVDIN5;
    wire     [2:0]   B2M_FIBRSVDIN6;
    wire     [2:0]   B2M_FIBRSVDIN7;
    wire     [3:0]   M2B_FIBRSVDOUT0;
    wire     [3:0]   M2B_FIBRSVDOUT1;
    wire     [3:0]   M2B_FIBRSVDOUT2;
    wire     [3:0]   M2B_FIBRSVDOUT3;
    wire     [3:0]   M2B_FIBRSVDOUT4;
    wire     [3:0]   M2B_FIBRSVDOUT5;
    wire     [3:0]   M2B_FIBRSVDOUT6;
    wire     [3:0]   M2B_FIBRSVDOUT7;
    //-------------------------- Rx Fabric Interface ---------------------------
    wire     [159:0] M2B_RXDATA0;
    wire     [159:0] M2B_RXDATA1;
    wire     [159:0] M2B_RXDATA2;
    wire     [159:0] M2B_RXDATA3;
    wire     [159:0] M2B_RXDATA4;
    wire     [159:0] M2B_RXDATA5;
    wire     [159:0] M2B_RXDATA6;
    wire     [159:0] M2B_RXDATA7;
    wire     [4:0]   M2B_RXDATAVALID0;
    wire     [4:0]   M2B_RXDATAVALID1;
    wire     [4:0]   M2B_RXDATAVALID2;
    wire     [4:0]   M2B_RXDATAVALID3;
    wire     [4:0]   M2B_RXDATAVALID4;
    wire     [4:0]   M2B_RXDATAVALID5;
    wire     [4:0]   M2B_RXDATAVALID6;
    wire     [4:0]   M2B_RXDATAVALID7;
    wire     [1:0]   B2M_RXDATAWIDTH0;
    wire     [1:0]   B2M_RXDATAWIDTH1;
    wire     [1:0]   B2M_RXDATAWIDTH2;
    wire     [1:0]   B2M_RXDATAWIDTH3;
    wire     [1:0]   B2M_RXDATAWIDTH4;
    wire     [1:0]   B2M_RXDATAWIDTH5;
    wire     [1:0]   B2M_RXDATAWIDTH6;
    wire     [1:0]   B2M_RXDATAWIDTH7;
    wire     [9:0]   M2B_RXHEADER0;
    wire     [9:0]   M2B_RXHEADER1;
    wire     [9:0]   M2B_RXHEADER2;
    wire     [9:0]   M2B_RXHEADER3;
    wire     [9:0]   M2B_RXHEADER4;
    wire     [9:0]   M2B_RXHEADER5;
    wire     [9:0]   M2B_RXHEADER6;
    wire     [9:0]   M2B_RXHEADER7;
    wire     [4:0]   M2B_RXHEADERVALID0;
    wire     [4:0]   M2B_RXHEADERVALID1;
    wire     [4:0]   M2B_RXHEADERVALID2;
    wire     [4:0]   M2B_RXHEADERVALID3;
    wire     [4:0]   M2B_RXHEADERVALID4;
    wire     [4:0]   M2B_RXHEADERVALID5;
    wire     [4:0]   M2B_RXHEADERVALID6;
    wire     [4:0]   M2B_RXHEADERVALID7;
    //-------------------------- Rx Reset Controller ---------------------------
    wire             B2M_GTZRXRESET0;
    wire             B2M_GTZRXRESET1;
    wire             B2M_GTZRXRESET2;
    wire             B2M_GTZRXRESET3;
    wire             B2M_GTZRXRESET4;
    wire             B2M_GTZRXRESET5;
    wire             B2M_GTZRXRESET6;
    wire             B2M_GTZRXRESET7;
    wire             M2B_RXRDY0;
    wire             M2B_RXRDY1;
    wire             M2B_RXRDY2;
    wire             M2B_RXRDY3;
    wire             M2B_RXRDY4;
    wire             M2B_RXRDY5;
    wire             M2B_RXRDY6;
    wire             M2B_RXRDY7;
    wire             M2B_RXRESETDONE0;
    wire             M2B_RXRESETDONE1;
    wire             M2B_RXRESETDONE2;
    wire             M2B_RXRESETDONE3;
    wire             M2B_RXRESETDONE4;
    wire             M2B_RXRESETDONE5;
    wire             M2B_RXRESETDONE6;
    wire             M2B_RXRESETDONE7;
    //------------------------------- SBUS Ports -------------------------------
    wire             B2M_SBUSCLKSEL;
    wire             B2M_SBUSRESETB;
    wire     [7:0]   B2M_SPARESBUSCOMMAND;
    wire     [31:0]  B2M_SPARESBUSDATA;
    wire     [7:0]   B2M_SPARESBUSDATAADDR;
    wire     [31:0]  M2B_SPARESBUSDATAOUT;
    wire             M2B_SPARESBUSDONE;
    wire             B2M_SPARESBUSEXECUTEB;
    wire             M2B_SPARESBUSRCVDATAVALID;
    wire             B2M_SPARESBUSRCVDATAVALIDSEL;
    wire     [7:0]   B2M_SPARESBUSRECADDR;
    wire     [2:0]   M2B_SPARESBUSRESULTCODE;
    //-------------------------- Tx Fabric Interface ---------------------------
    wire     [159:0] B2M_TXDATA0;
    wire     [159:0] B2M_TXDATA1;
    wire     [159:0] B2M_TXDATA2;
    wire     [159:0] B2M_TXDATA3;
    wire     [159:0] B2M_TXDATA4;
    wire     [159:0] B2M_TXDATA5;
    wire     [159:0] B2M_TXDATA6;
    wire     [159:0] B2M_TXDATA7;
    wire     [1:0]   B2M_TXDATAWIDTH0;
    wire     [1:0]   B2M_TXDATAWIDTH1;
    wire     [1:0]   B2M_TXDATAWIDTH2;
    wire     [1:0]   B2M_TXDATAWIDTH3;
    wire     [1:0]   B2M_TXDATAWIDTH4;
    wire     [1:0]   B2M_TXDATAWIDTH5;
    wire     [1:0]   B2M_TXDATAWIDTH6;
    wire     [1:0]   B2M_TXDATAWIDTH7;
    wire     [9:0]   B2M_TXHEADER0;
    wire     [9:0]   B2M_TXHEADER1;
    wire     [9:0]   B2M_TXHEADER2;
    wire     [9:0]   B2M_TXHEADER3;
    wire     [9:0]   B2M_TXHEADER4;
    wire     [9:0]   B2M_TXHEADER5;
    wire     [9:0]   B2M_TXHEADER6;
    wire     [9:0]   B2M_TXHEADER7;
    //-------------------------- Tx Reset Controller ---------------------------
    wire             B2M_GTZTXRESET0;
    wire             B2M_GTZTXRESET1;
    wire             B2M_GTZTXRESET2;
    wire             B2M_GTZTXRESET3;
    wire             B2M_GTZTXRESET4;
    wire             B2M_GTZTXRESET5;
    wire             B2M_GTZTXRESET6;
    wire             B2M_GTZTXRESET7;
    wire             M2B_TXRDY0;
    wire             M2B_TXRDY1;
    wire             M2B_TXRDY2;
    wire             M2B_TXRDY3;
    wire             M2B_TXRDY4;
    wire             M2B_TXRDY5;
    wire             M2B_TXRDY6;
    wire             M2B_TXRDY7;
    wire             M2B_TXRESETDONE0;
    wire             M2B_TXRESETDONE1;
    wire             M2B_TXRESETDONE2;
    wire             M2B_TXRESETDONE3;
    wire             M2B_TXRESETDONE4;
    wire             M2B_TXRESETDONE5;
    wire             M2B_TXRESETDONE6;
    wire             M2B_TXRESETDONE7;
    //---------------------------- Tx driver Ports -----------------------------
    wire     [7:0]   B2M_TXATTNCTRL0;
    wire     [7:0]   B2M_TXATTNCTRL1;
    wire     [7:0]   B2M_TXATTNCTRL2;
    wire     [7:0]   B2M_TXATTNCTRL3;
    wire     [7:0]   B2M_TXATTNCTRL4;
    wire     [7:0]   B2M_TXATTNCTRL5;
    wire     [7:0]   B2M_TXATTNCTRL6;
    wire     [7:0]   B2M_TXATTNCTRL7;
    wire     [7:0]   B2M_TXEQPOSTCTRL0;
    wire     [7:0]   B2M_TXEQPOSTCTRL1;
    wire     [7:0]   B2M_TXEQPOSTCTRL2;
    wire     [7:0]   B2M_TXEQPOSTCTRL3;
    wire     [7:0]   B2M_TXEQPOSTCTRL4;
    wire     [7:0]   B2M_TXEQPOSTCTRL5;
    wire     [7:0]   B2M_TXEQPOSTCTRL6;
    wire     [7:0]   B2M_TXEQPOSTCTRL7;
    wire     [3:0]   B2M_TXEQPRECTRL0;
    wire     [3:0]   B2M_TXEQPRECTRL1;
    wire     [3:0]   B2M_TXEQPRECTRL2;
    wire     [3:0]   B2M_TXEQPRECTRL3;
    wire     [3:0]   B2M_TXEQPRECTRL4;
    wire     [3:0]   B2M_TXEQPRECTRL5;
    wire     [3:0]   B2M_TXEQPRECTRL6;
    wire     [3:0]   B2M_TXEQPRECTRL7;
    wire             B2M_TXOUTPUTEN0;
    wire             B2M_TXOUTPUTEN1;
    wire             B2M_TXOUTPUTEN2;
    wire             B2M_TXOUTPUTEN3;
    wire             B2M_TXOUTPUTEN4;
    wire             B2M_TXOUTPUTEN5;
    wire             B2M_TXOUTPUTEN6;
    wire             B2M_TXOUTPUTEN7;
    wire     [1:0]   B2M_TXSLEWCTRL0;
    wire     [1:0]   B2M_TXSLEWCTRL1;
    wire     [1:0]   B2M_TXSLEWCTRL2;
    wire     [1:0]   B2M_TXSLEWCTRL3;
    wire     [1:0]   B2M_TXSLEWCTRL4;
    wire     [1:0]   B2M_TXSLEWCTRL5;
    wire     [1:0]   B2M_TXSLEWCTRL6;
    wire     [1:0]   B2M_TXSLEWCTRL7;
    //--------------------------- Tx override Ports ----------------------------
    wire             B2M_TXOVERRIDEEN0;
    wire             B2M_TXOVERRIDEEN1;
    wire             B2M_TXOVERRIDEEN2;
    wire             B2M_TXOVERRIDEEN3;
    wire             B2M_TXOVERRIDEEN4;
    wire             B2M_TXOVERRIDEEN5;
    wire             B2M_TXOVERRIDEEN6;
    wire             B2M_TXOVERRIDEEN7;
    wire             B2M_TXOVERRIDEIN0;
    wire             B2M_TXOVERRIDEIN1;
    wire             B2M_TXOVERRIDEIN2;
    wire             B2M_TXOVERRIDEIN3;
    wire             B2M_TXOVERRIDEIN4;
    wire             B2M_TXOVERRIDEIN5;
    wire             B2M_TXOVERRIDEIN6;
    wire             B2M_TXOVERRIDEIN7;
    //--------------------------- Tx phase cal Ports ---------------------------
    wire             B2M_TXPHASECALEN0;
    wire             B2M_TXPHASECALEN1;
    wire             B2M_TXPHASECALEN2;
    wire             B2M_TXPHASECALEN3;
    wire             B2M_TXPHASECALEN4;
    wire             B2M_TXPHASECALEN5;
    wire             B2M_TXPHASECALEN6;
    wire             B2M_TXPHASECALEN7;
    wire             B2M_TXPHASESLIP0;
    wire             B2M_TXPHASESLIP1;
    wire             B2M_TXPHASESLIP2;
    wire             B2M_TXPHASESLIP3;
    wire             B2M_TXPHASESLIP4;
    wire             B2M_TXPHASESLIP5;
    wire             B2M_TXPHASESLIP6;
    wire             B2M_TXPHASESLIP7;
    //--------------------------- Tx phase out Ports ---------------------------
    wire     [4:0]   M2B_TXPHASEOUT0;
    wire     [4:0]   M2B_TXPHASEOUT1;
    wire     [4:0]   M2B_TXPHASEOUT2;
    wire     [4:0]   M2B_TXPHASEOUT3;
    wire     [4:0]   M2B_TXPHASEOUT4;
    wire     [4:0]   M2B_TXPHASEOUT5;
    wire     [4:0]   M2B_TXPHASEOUT6;
    wire     [4:0]   M2B_TXPHASEOUT7;
    //--------------------------- Tx sequence Ports ----------------------------
    wire     [6:0]   B2M_TXSEQUENCE0;
    wire     [6:0]   B2M_TXSEQUENCE1;
    wire     [6:0]   B2M_TXSEQUENCE2;
    wire     [6:0]   B2M_TXSEQUENCE3;
    wire     [6:0]   B2M_TXSEQUENCE4;
    wire     [6:0]   B2M_TXSEQUENCE5;
    wire     [6:0]   B2M_TXSEQUENCE6;
    wire     [6:0]   B2M_TXSEQUENCE7;
    //----------------------------- reserved Ports -----------------------------
    wire     [2:0]   B2M_FIBRSVDIN0;

    wire    [14:0] B2M_RSVDIN;
    wire     B2M_RXUSRCLK0;      
    wire     B2M_RXUSRCLK1;      
    wire     B2M_RXUSRCLK2;      
    wire     B2M_RXUSRCLK3;      
    wire     B2M_RXUSRCLK4;      
    wire     B2M_RXUSRCLK5;      
    wire     B2M_RXUSRCLK6;      
    wire     B2M_RXUSRCLK7;      
    wire     B2M_TXUSRCLK0;      
    wire     B2M_TXUSRCLK1;      
    wire     B2M_TXUSRCLK2;      
    wire     B2M_TXUSRCLK3;      
    wire     B2M_TXUSRCLK4;      
    wire     B2M_TXUSRCLK5;      
    wire     B2M_TXUSRCLK6;      
    wire     B2M_TXUSRCLK7;      
    wire     B2M_DRPCLK0;      
    wire     B2M_DRPCLK1;      
    wire     B2M_DRPCLKSEL;  

    wire     drpclksel_i;

    assign drpclksel_i = B2M_DRPCLKSEL;
 
      
// 
//********************************* Main Body of Code**************************
                       
    //-------------------------  Static signal Assigments ---------------------   

    assign tied_to_ground_i             = 1'b0;
    assign tied_to_ground_vec_i         = 160'd0;
    assign tied_to_vcc_i                = 1'b1;
    assign tied_to_vcc_vec_i            = 160'hffffffffffffffffffffffffffffffffffffffff;
  

    //------------------------- GT Instantiations  --------------------------
        GTZE2_OCTAL #
        (
            //_______________________ Simulation-Only Attributes __________________
    
            .SIM_GTZRESET_SPEEDUP       (SIM_GTZRESET_SPEEDUP),
            .SIM_VERSION                (SIM_VERSION),
            .TXUSRCLK_SEL_LANE0         (TXUSRCLK_LANE0_VAR),
            .RXUSRCLK_SEL_LANE0         (RXUSRCLK_LANE0_VAR),
            .TXUSRCLK_SEL_LANE1         (TXUSRCLK_LANE1_VAR),
            .RXUSRCLK_SEL_LANE1         (RXUSRCLK_LANE1_VAR),
            .TXUSRCLK_SEL_LANE2         (TXUSRCLK_LANE2_VAR),
            .RXUSRCLK_SEL_LANE2         (RXUSRCLK_LANE2_VAR),
            .TXUSRCLK_SEL_LANE3         (TXUSRCLK_LANE3_VAR),
            .RXUSRCLK_SEL_LANE3         (RXUSRCLK_LANE3_VAR),
            .TXUSRCLK_SEL_LANE4         (TXUSRCLK_LANE4_VAR),
            .RXUSRCLK_SEL_LANE4         (RXUSRCLK_LANE4_VAR),
            .TXUSRCLK_SEL_LANE5         (TXUSRCLK_LANE5_VAR),
            .RXUSRCLK_SEL_LANE5         (RXUSRCLK_LANE5_VAR),
            .TXUSRCLK_SEL_LANE6         (TXUSRCLK_LANE6_VAR),
            .RXUSRCLK_SEL_LANE6         (RXUSRCLK_LANE6_VAR),
            .TXUSRCLK_SEL_LANE7         (TXUSRCLK_LANE7_VAR),
            .RXUSRCLK_SEL_LANE7         (RXUSRCLK_LANE7_VAR),
            
            .MULTI_LANE_MODE                        (5'b10001),
            .SBUS_CLK_DIV                           (4'b0100),
            .SBUS_CLK_DIV_NON_2N_EN                 (1'b0),
            .SBUS_CLK_DIV_NON_2N_RESET_VAL          (12'hFFF),
            .BROADCAST_CTRL_LANE0                   (32'h00000000),
            .BROADCAST_CTRL_LANE1                   (32'h00000000),
            .BROADCAST_CTRL_LANE2                   (32'h00000000),
            .BROADCAST_CTRL_LANE3                   (32'h00000000),
            .BROADCAST_CTRL_LANE4                   (32'h00000000),
            .BROADCAST_CTRL_LANE5                   (32'h00000000),
            .BROADCAST_CTRL_LANE6                   (32'h00000000),
            .BROADCAST_CTRL_LANE7                   (32'h00000000),
            .FIB_IGNORE_BROADCAST_LANE0             ("FALSE"),
            .FIB_IGNORE_BROADCAST_LANE1             ("FALSE"),
            .FIB_IGNORE_BROADCAST_LANE2             ("FALSE"),
            .FIB_IGNORE_BROADCAST_LANE3             ("FALSE"),
            .FIB_IGNORE_BROADCAST_LANE4             ("FALSE"),
            .FIB_IGNORE_BROADCAST_LANE5             ("FALSE"),
            .FIB_IGNORE_BROADCAST_LANE6             ("FALSE"),
            .FIB_IGNORE_BROADCAST_LANE7             ("FALSE"),
            .FIB_MULTICAST_GROUP_ID_LANE0           (8'h00),
            .FIB_MULTICAST_GROUP_ID_LANE1           (8'h00),
            .FIB_MULTICAST_GROUP_ID_LANE2           (8'h00),
            .FIB_MULTICAST_GROUP_ID_LANE3           (8'h00),
            .FIB_MULTICAST_GROUP_ID_LANE4           (8'h00),
            .FIB_MULTICAST_GROUP_ID_LANE5           (8'h00),
            .FIB_MULTICAST_GROUP_ID_LANE6           (8'h00),
            .FIB_MULTICAST_GROUP_ID_LANE7           (8'h00),
            .FIB_ASYNC_CTRL_LANE0                   (17'h0fdff),
            .FIB_ASYNC_CTRL_LANE1                   (17'h0fdff),
            .FIB_ASYNC_CTRL_LANE2                   (17'h0fdff),
            .FIB_ASYNC_CTRL_LANE3                   (17'h0fdff),
            .FIB_ASYNC_CTRL_LANE4                   (17'h0fdff),
            .FIB_ASYNC_CTRL_LANE5                   (17'h0fdff),
            .FIB_ASYNC_CTRL_LANE6                   (17'h0fdff),
            .FIB_ASYNC_CTRL_LANE7                   (17'h0fdff),
            .FIB_LOOPBACK_SEL_LANE0                 ("NORMAL"),
            .FIB_LOOPBACK_SEL_LANE1                 ("NORMAL"),
            .FIB_LOOPBACK_SEL_LANE2                 ("NORMAL"),
            .FIB_LOOPBACK_SEL_LANE3                 ("NORMAL"),
            .FIB_LOOPBACK_SEL_LANE4                 ("NORMAL"),
            .FIB_LOOPBACK_SEL_LANE5                 ("NORMAL"),
            .FIB_LOOPBACK_SEL_LANE6                 ("NORMAL"),
            .FIB_LOOPBACK_SEL_LANE7                 ("NORMAL"),
            .FIB_NEAREND_LPBK_CLK_SEL_LANE0         ("TXOUTCLKPMA"),
            .FIB_NEAREND_LPBK_CLK_SEL_LANE1         ("TXOUTCLKPMA"),
            .FIB_NEAREND_LPBK_CLK_SEL_LANE2         ("TXOUTCLKPMA"),
            .FIB_NEAREND_LPBK_CLK_SEL_LANE3         ("TXOUTCLKPMA"),
            .FIB_NEAREND_LPBK_CLK_SEL_LANE4         ("TXOUTCLKPMA"),
            .FIB_NEAREND_LPBK_CLK_SEL_LANE5         ("TXOUTCLKPMA"),
            .FIB_NEAREND_LPBK_CLK_SEL_LANE6         ("TXOUTCLKPMA"),
            .FIB_NEAREND_LPBK_CLK_SEL_LANE7         ("TXOUTCLKPMA"),
            .RX_FAR_LPBK_CTRL_LANE0                 (32'h00000000),
            .RX_FAR_LPBK_CTRL_LANE1                 (32'h00000000),
            .RX_FAR_LPBK_CTRL_LANE2                 (32'h00000000),
            .RX_FAR_LPBK_CTRL_LANE3                 (32'h00000000),
            .RX_FAR_LPBK_CTRL_LANE4                 (32'h00000000),
            .RX_FAR_LPBK_CTRL_LANE5                 (32'h00000000),
            .RX_FAR_LPBK_CTRL_LANE6                 (32'h00000000),
            .RX_FAR_LPBK_CTRL_LANE7                 (32'h00000000),
            .GTZ_POWER_UP_LANE0                     (1'b1),
            .GTZ_POWER_UP_LANE1                     (1'b1),
            .GTZ_POWER_UP_LANE2                     (1'b1),
            .GTZ_POWER_UP_LANE3                     (1'b1),
            .GTZ_POWER_UP_LANE4                     (1'b0),
            .GTZ_POWER_UP_LANE5                     (1'b0),
            .GTZ_POWER_UP_LANE6                     (1'b0),
            .GTZ_POWER_UP_LANE7                     (1'b0),
            .RXFIFO_RESET_ON_BITSLIP_LANE0          ("TRUE"),
            .RXFIFO_RESET_ON_BITSLIP_LANE1          ("TRUE"),
            .RXFIFO_RESET_ON_BITSLIP_LANE2          ("TRUE"),
            .RXFIFO_RESET_ON_BITSLIP_LANE3          ("TRUE"),
            .RXFIFO_RESET_ON_BITSLIP_LANE4          ("TRUE"),
            .RXFIFO_RESET_ON_BITSLIP_LANE5          ("TRUE"),
            .RXFIFO_RESET_ON_BITSLIP_LANE6          ("TRUE"),
            .RXFIFO_RESET_ON_BITSLIP_LANE7          ("TRUE"),
            .RXFIFO_BITSLIP_RESET_TIME_LANE0        (6'b010110),
            .RXFIFO_BITSLIP_RESET_TIME_LANE1        (6'b010110),
            .RXFIFO_BITSLIP_RESET_TIME_LANE2        (6'b010110),
            .RXFIFO_BITSLIP_RESET_TIME_LANE3        (6'b010110),
            .RXFIFO_BITSLIP_RESET_TIME_LANE4        (6'b010110),
            .RXFIFO_BITSLIP_RESET_TIME_LANE5        (6'b010110),
            .RXFIFO_BITSLIP_RESET_TIME_LANE6        (6'b010110),
            .RXFIFO_BITSLIP_RESET_TIME_LANE7        (6'b010110),
            .TX_GAIN_CTRL_LANE0                     (32'h000000D5),
            .TX_GAIN_CTRL_LANE1                     (32'h000000D5),
            .TX_GAIN_CTRL_LANE2                     (32'h000000D5),
            .TX_GAIN_CTRL_LANE3                     (32'h000000D5),
            .TX_GAIN_CTRL_LANE4                     (32'h000000D5),
            .TX_GAIN_CTRL_LANE5                     (32'h000000D5),
            .TX_GAIN_CTRL_LANE6                     (32'h000000D5),
            .TX_GAIN_CTRL_LANE7                     (32'h000000D5),
            .RX_GAIN_CTRL_LANE0                     (32'h0000013F),
            .RX_GAIN_CTRL_LANE1                     (32'h0000013F),
            .RX_GAIN_CTRL_LANE2                     (32'h0000013F),
            .RX_GAIN_CTRL_LANE3                     (32'h0000013F),
            .RX_GAIN_CTRL_LANE4                     (32'h0000013F),
            .RX_GAIN_CTRL_LANE5                     (32'h0000013F),
            .RX_GAIN_CTRL_LANE6                     (32'h0000013F),
            .RX_GAIN_CTRL_LANE7                     (32'h0000013F),
            .RX_DFE_PHASE_CTRL_LANE0                (32'h0000001F),
            .RX_DFE_PHASE_CTRL_LANE1                (32'h0000001F),
            .RX_DFE_PHASE_CTRL_LANE2                (32'h0000001F),
            .RX_DFE_PHASE_CTRL_LANE3                (32'h0000001F),
            .RX_DFE_PHASE_CTRL_LANE4                (32'h0000001F),
            .RX_DFE_PHASE_CTRL_LANE5                (32'h0000001F),
            .RX_DFE_PHASE_CTRL_LANE6                (32'h0000001F),
            .RX_DFE_PHASE_CTRL_LANE7                (32'h0000001F),
            .RXOUTCLK0_LANE_SEL                     ("LANE0"),
            .RXOUTCLK1_LANE_SEL                     ("LANE0"),
            .RXOUTCLK2_LANE_SEL                     ("LANE0"),
            .RXOUTCLK3_LANE_SEL                     ("LANE0"),
            .RXOUTCLK_SEL_LANE0                     ("RXRECCLKPMA_DIV4"),
            .RXOUTCLK_SEL_LANE1                     ("RXRECCLKPMA_DIV4"),
            .RXOUTCLK_SEL_LANE2                     ("RXRECCLKPMA_DIV4"),
            .RXOUTCLK_SEL_LANE3                     ("RXRECCLKPMA_DIV4"),
            .RXOUTCLK_SEL_LANE4                     ("RXRECCLKPMA_DIV4"),
            .RXOUTCLK_SEL_LANE5                     ("RXRECCLKPMA_DIV4"),
            .RXOUTCLK_SEL_LANE6                     ("RXRECCLKPMA_DIV4"),
            .RXOUTCLK_SEL_LANE7                     ("RXRECCLKPMA_DIV4"),
            .TXOUTCLK0_LANE_SEL                     ("LANE0"),
            .TXOUTCLK1_LANE_SEL                     ("LANE0"),
            .TXOUTCLK_SEL_LANE0                     ("REFCLK_DIV2"), //("TXOUTCLKPMA_DIV4"),
            .TXOUTCLK_SEL_LANE1                     ("REFCLK_DIV2"), //("TXOUTCLKPMA_DIV4"),
            .TXOUTCLK_SEL_LANE2                     ("REFCLK_DIV2"), //("TXOUTCLKPMA_DIV4"),
            .TXOUTCLK_SEL_LANE3                     ("REFCLK_DIV2"), //("TXOUTCLKPMA_DIV4"),
            .TXOUTCLK_SEL_LANE4                     ("REFCLK_DIV2"), //("TXOUTCLKPMA_DIV4"),
            .TXOUTCLK_SEL_LANE5                     ("REFCLK_DIV2"), //("TXOUTCLKPMA_DIV4"),
            .TXOUTCLK_SEL_LANE6                     ("REFCLK_DIV2"), //("TXOUTCLKPMA_DIV4"),
            .TXOUTCLK_SEL_LANE7                     ("REFCLK_DIV2"), //("TXOUTCLKPMA_DIV4"),
            .TX_MODE_SEL_LANE0                      ("GB_100GBASE_R4"),
            .TX_MODE_SEL_LANE1                      ("GB_100GBASE_R4"),
            .TX_MODE_SEL_LANE2                      ("GB_100GBASE_R4"),
            .TX_MODE_SEL_LANE3                      ("GB_100GBASE_R4"),
            .TX_MODE_SEL_LANE4                      ("GB_100GBASE_R4"),
            .TX_MODE_SEL_LANE5                      ("GB_100GBASE_R4"),
            .TX_MODE_SEL_LANE6                      ("GB_100GBASE_R4"),
            .TX_MODE_SEL_LANE7                      ("GB_100GBASE_R4"),
            .RX_MODE_SEL_LANE0                      ("GB_100GBASE_R4"),
            .RX_MODE_SEL_LANE1                      ("GB_100GBASE_R4"),
            .RX_MODE_SEL_LANE2                      ("GB_100GBASE_R4"),
            .RX_MODE_SEL_LANE3                      ("GB_100GBASE_R4"),
            .RX_MODE_SEL_LANE4                      ("GB_100GBASE_R4"),
            .RX_MODE_SEL_LANE5                      ("GB_100GBASE_R4"),
            .RX_MODE_SEL_LANE6                      ("GB_100GBASE_R4"),
            .RX_MODE_SEL_LANE7                      ("GB_100GBASE_R4")

            
        )
	gtze2_octal_north
        (
         //----------------------- REFCLK Ports -------------------------------
	 .GTREFCLK0P                   (gtrefclk0p_in),
	 .GTREFCLK0N                   (gtrefclk0n_in),
	 .GTREFCLK1P                   (gtrefclk1p_in),
	 .GTREFCLK1N                   (gtrefclk1n_in),

	  .RXUSRCLK0(B2M_RXUSRCLK0),
          .RXUSRCLK1(B2M_RXUSRCLK1),
          .RXUSRCLK2(B2M_RXUSRCLK2),
          .RXUSRCLK3(B2M_RXUSRCLK3),
          .RXUSRCLK4(B2M_RXUSRCLK4),
          .RXUSRCLK5(B2M_RXUSRCLK5),
          .RXUSRCLK6(B2M_RXUSRCLK6),
          .RXUSRCLK7(B2M_RXUSRCLK7),
	  
          .TXUSRCLK0(B2M_TXUSRCLK0),
          .TXUSRCLK1(B2M_TXUSRCLK1),
          .TXUSRCLK2(B2M_TXUSRCLK2),
          .TXUSRCLK3(B2M_TXUSRCLK3),
          .TXUSRCLK4(B2M_TXUSRCLK4),
          .TXUSRCLK5(B2M_TXUSRCLK5),
          .TXUSRCLK6(B2M_TXUSRCLK6),
          .TXUSRCLK7(B2M_TXUSRCLK7),
	  
	  .DRPCLK0(B2M_DRPCLK0),
          .DRPCLK1(B2M_DRPCLK1),
          .DRPCLKSEL(drpclksel_i),

	 //-------------------------------- Serial Ports ---------------------------------
	 .GTZTXP0                (gtztxp0_out),
	 .GTZTXN0                (gtztxn0_out),
	 .GTZRXP0                (gtzrxp0_in),
	 .GTZRXN0                (gtzrxn0_in),
	 .GTZTXP1                (gtztxp1_out),
	 .GTZTXN1                (gtztxn1_out),
	 .GTZRXP1                (gtzrxp1_in),
	 .GTZRXN1                (gtzrxn1_in),
	 .GTZTXP2                (gtztxp2_out),
	 .GTZTXN2                (gtztxn2_out),
	 .GTZRXP2                (gtzrxp2_in),
	 .GTZRXN2                (gtzrxn2_in),
	 .GTZTXP3                (gtztxp3_out),
	 .GTZTXN3                (gtztxn3_out),
	 .GTZRXP3                (gtzrxp3_in),
	 .GTZRXN3                (gtzrxn3_in),
	 .GTZTXP4                (),
	 .GTZTXN4                (),			
	 .GTZRXP4                (tied_to_ground_i),
	 .GTZRXN4                (tied_to_vcc_i),		
	 .GTZTXP5                (),
	 .GTZTXN5                (),			
	 .GTZRXP5                (tied_to_ground_i),
	 .GTZRXN5                (tied_to_vcc_i),		
	 .GTZTXP6                (),
	 .GTZTXN6                (),			
	 .GTZRXP6                (tied_to_ground_i),
	 .GTZRXN6                (tied_to_vcc_i),		
	 .GTZTXP7                (),
	 .GTZTXN7                (),			
	 .GTZRXP7                (tied_to_ground_i),
	 .GTZRXN7                (tied_to_vcc_i),		
	 
	 //----------------------- Test Ports -----------------------------
	 .TSTRSVD0                     (tied_to_vcc_i),
	 .TSTRSVD1                     (tied_to_vcc_i),
	 .TSTRSVD2                     (tied_to_vcc_i),
	 .TSTRSVD3                     (tied_to_vcc_i),
	 .TSTRSVD4                     (tied_to_vcc_vec_i[9:0]),

	 .RSVDIN                       (B2M_RSVDIN),
	 
        //----------------------------- BitSlip Ports ------------------------------
        .RXBITSLIP0                     (B2M_RXBITSLIP0),
        .RXBITSLIP1                     (B2M_RXBITSLIP1),
        .RXBITSLIP2                     (B2M_RXBITSLIP2),
        .RXBITSLIP3                     (B2M_RXBITSLIP3),
        .RXBITSLIP4                     (B2M_RXBITSLIP4),
        .RXBITSLIP5                     (B2M_RXBITSLIP5),
        .RXBITSLIP6                     (B2M_RXBITSLIP6),
        .RXBITSLIP7                     (B2M_RXBITSLIP7),
        .RXGEARBOXSLIP0                 (B2M_RXGEARBOXSLIP0),
        .RXGEARBOXSLIP1                 (B2M_RXGEARBOXSLIP1),
        .RXGEARBOXSLIP2                 (B2M_RXGEARBOXSLIP2),
        .RXGEARBOXSLIP3                 (B2M_RXGEARBOXSLIP3),
        .RXGEARBOXSLIP4                 (B2M_RXGEARBOXSLIP4),
        .RXGEARBOXSLIP5                 (B2M_RXGEARBOXSLIP5),
        .RXGEARBOXSLIP6                 (B2M_RXGEARBOXSLIP6),
        .RXGEARBOXSLIP7                 (B2M_RXGEARBOXSLIP7),
        //----------------------------- Clocking Ports -----------------------------
        .REFCLKSEL0                     (B2M_REFCLKSEL0),
        .REFCLKSEL1                     (B2M_REFCLKSEL1),
        .REFCLKSEL2                     (B2M_REFCLKSEL2),
        .REFCLKSEL3                     (B2M_REFCLKSEL3),
        .REFCLKSEL4                     (B2M_REFCLKSEL4),
        .REFCLKSEL5                     (B2M_REFCLKSEL5),
        .REFCLKSEL6                     (B2M_REFCLKSEL6),
        .REFCLKSEL7                     (B2M_REFCLKSEL7),
        .RXOUTCLK0                      (M2B_RXOUTCLK0),
        .RXOUTCLK1                      (M2B_RXOUTCLK1),
        .RXOUTCLK2                      (M2B_RXOUTCLK2),
        .RXOUTCLK3                      (M2B_RXOUTCLK3),
        .TXOUTCLK0                      (M2B_TXOUTCLK0),
        .TXOUTCLK1                      (M2B_TXOUTCLK1),
        //-------------------------- Configuration Ports ---------------------------
        .CFGBADVERSIONB                 (M2B_CFGBADVERSIONB),
        .CFGCLK                         (B2M_CFGCLK),
        .CFGCRCERRB                     (M2B_CFGCRCERRB),
        .CFGDATA                        (B2M_CFGDATA),
        .CFGDATAVALID                   (B2M_CFGDATAVALID),
        .CFGDEBUGMODEB                  (B2M_CFGDEBUGMODEB),
        .CFGFORCESEUERRB                (B2M_CFGFORCESEUERRB),
        .CFGGTZDONEB                    (M2B_CFGGTZDONEB),
        .CFGREADBACKB                   (B2M_CFGREADBACKB),
        .CFGSEUERRB                     (M2B_CFGSEUERRB),
        .GTZINIT                        (B2M_GTZINIT),
        .GTZINITDONEB                   (M2B_GTZINITDONEB),
        //------------------------------- DRP Ports --------------------------------
        .DRPADDR                        (B2M_DRPADDR),
        .DRPDI                          (B2M_DRPDI),
        .DRPDO                          (M2B_DRPDO),
        .DRPEN                          (B2M_DRPEN),
        .DRPRDY                         (M2B_DRPRDY),
        .DRPSTATUS                      (M2B_DRPSTATUS),
        .DRPWDTERR                      (M2B_DRPWDTERR),
        .DRPWE                          (B2M_DRPWE),
        //---------------------------- FIB Reset Ports -----------------------------
        .RXFIBRESET0                    (B2M_RXFIBRESET0),
        .RXFIBRESET1                    (B2M_RXFIBRESET1),
        .RXFIBRESET2                    (B2M_RXFIBRESET2),
        .RXFIBRESET3                    (B2M_RXFIBRESET3),
        .RXFIBRESET4                    (B2M_RXFIBRESET4),
        .RXFIBRESET5                    (B2M_RXFIBRESET5),
        .RXFIBRESET6                    (B2M_RXFIBRESET6),
        .RXFIBRESET7                    (B2M_RXFIBRESET7),
        .TXFIBRESET0                    (B2M_TXFIBRESET0),
        .TXFIBRESET1                    (B2M_TXFIBRESET1),
        .TXFIBRESET2                    (B2M_TXFIBRESET2),
        .TXFIBRESET3                    (B2M_TXFIBRESET3),
        .TXFIBRESET4                    (B2M_TXFIBRESET4),
        .TXFIBRESET5                    (B2M_TXFIBRESET5),
        .TXFIBRESET6                    (B2M_TXFIBRESET6),
        .TXFIBRESET7                    (B2M_TXFIBRESET7),
        //------------------------------- FIFO Ports -------------------------------
        .RXFIFOSTATUS0                  (M2B_RXFIFOSTATUS0),
        .RXFIFOSTATUS1                  (M2B_RXFIFOSTATUS1),
        .RXFIFOSTATUS2                  (M2B_RXFIFOSTATUS2),
        .RXFIFOSTATUS3                  (M2B_RXFIFOSTATUS3),
        .RXFIFOSTATUS4                  (M2B_RXFIFOSTATUS4),
        .RXFIFOSTATUS5                  (M2B_RXFIFOSTATUS5),
        .RXFIFOSTATUS6                  (M2B_RXFIFOSTATUS6),
        .RXFIFOSTATUS7                  (M2B_RXFIFOSTATUS7),
        .TXFIFOSTATUS0                  (M2B_TXFIFOSTATUS0),
        .TXFIFOSTATUS1                  (M2B_TXFIFOSTATUS1),
        .TXFIFOSTATUS2                  (M2B_TXFIFOSTATUS2),
        .TXFIFOSTATUS3                  (M2B_TXFIFOSTATUS3),
        .TXFIFOSTATUS4                  (M2B_TXFIFOSTATUS4),
        .TXFIFOSTATUS5                  (M2B_TXFIFOSTATUS5),
        .TXFIFOSTATUS6                  (M2B_TXFIFOSTATUS6),
        .TXFIFOSTATUS7                  (M2B_TXFIFOSTATUS7),
        //-------------------------- Latency clock Ports ---------------------------
        .RXLATCLK                       (B2M_RXLATCLK),
        .TXLATCLK                       (B2M_TXLATCLK),
        //------------------------------- Loopbacks --------------------------------
        .FARLOOPBACKEN0                 (B2M_FARLOOPBACKEN0),
        .FARLOOPBACKEN1                 (B2M_FARLOOPBACKEN1),
        .FARLOOPBACKEN2                 (B2M_FARLOOPBACKEN2),
        .FARLOOPBACKEN3                 (B2M_FARLOOPBACKEN3),
        .FARLOOPBACKEN4                 (B2M_FARLOOPBACKEN4),
        .FARLOOPBACKEN5                 (B2M_FARLOOPBACKEN5),
        .FARLOOPBACKEN6                 (B2M_FARLOOPBACKEN6),
        .FARLOOPBACKEN7                 (B2M_FARLOOPBACKEN7),
        .NEARLOOPBACKEN0                (B2M_NEARLOOPBACKEN0),
        .NEARLOOPBACKEN1                (B2M_NEARLOOPBACKEN1),
        .NEARLOOPBACKEN2                (B2M_NEARLOOPBACKEN2),
        .NEARLOOPBACKEN3                (B2M_NEARLOOPBACKEN3),
        .NEARLOOPBACKEN4                (B2M_NEARLOOPBACKEN4),
        .NEARLOOPBACKEN5                (B2M_NEARLOOPBACKEN5),
        .NEARLOOPBACKEN6                (B2M_NEARLOOPBACKEN6),
        .NEARLOOPBACKEN7                (B2M_NEARLOOPBACKEN7),
        //------------------------ PLL Recalibration Ports -------------------------
        .PLLRECALEN0                    (B2M_PLLRECALEN0),
        .PLLRECALEN1                    (B2M_PLLRECALEN1),
        .PLLRECALEN2                    (B2M_PLLRECALEN2),
        .PLLRECALEN3                    (B2M_PLLRECALEN3),
        .PLLRECALEN4                    (B2M_PLLRECALEN4),
        .PLLRECALEN5                    (B2M_PLLRECALEN5),
        .PLLRECALEN6                    (B2M_PLLRECALEN6),
        .PLLRECALEN7                    (B2M_PLLRECALEN7),
        //------------------------------ PLL Settings ------------------------------
        .CORECNTL0                      (B2M_CORECNTL0),
        .CORECNTL1                      (B2M_CORECNTL1),
        .CORECNTL2                      (B2M_CORECNTL2),
        .CORECNTL3                      (B2M_CORECNTL3),
        .CORECNTL4                      (B2M_CORECNTL4),
        .CORECNTL5                      (B2M_CORECNTL5),
        .CORECNTL6                      (B2M_CORECNTL6),
        .CORECNTL7                      (B2M_CORECNTL7),
        .REFSEL0                        (B2M_REFSEL0),
        .REFSEL1                        (B2M_REFSEL1),
        .REFSEL2                        (B2M_REFSEL2),
        .REFSEL3                        (B2M_REFSEL3),
        .REFSEL4                        (B2M_REFSEL4),
        .REFSEL5                        (B2M_REFSEL5),
        .REFSEL6                        (B2M_REFSEL6),
        .REFSEL7                        (B2M_REFSEL7),
        .RXRATESEL0                     (B2M_RXRATESEL0),
        .RXRATESEL1                     (B2M_RXRATESEL1),
        .RXRATESEL2                     (B2M_RXRATESEL2),
        .RXRATESEL3                     (B2M_RXRATESEL3),
        .RXRATESEL4                     (B2M_RXRATESEL4),
        .RXRATESEL5                     (B2M_RXRATESEL5),
        .RXRATESEL6                     (B2M_RXRATESEL6),
        .RXRATESEL7                     (B2M_RXRATESEL7),
        .TXRATESEL0                     (B2M_TXRATESEL0),
        .TXRATESEL1                     (B2M_TXRATESEL1),
        .TXRATESEL2                     (B2M_TXRATESEL2),
        .TXRATESEL3                     (B2M_TXRATESEL3),
        .TXRATESEL4                     (B2M_TXRATESEL4),
        .TXRATESEL5                     (B2M_TXRATESEL5),
        .TXRATESEL6                     (B2M_TXRATESEL6),
        .TXRATESEL7                     (B2M_TXRATESEL7),
        //---------------------------- PMA Enable Ports ----------------------------
        .RXEN0                          (B2M_RXEN0),
        .RXEN1                          (B2M_RXEN1),
        .RXEN2                          (B2M_RXEN2),
        .RXEN3                          (B2M_RXEN3),
        .RXEN4                          (B2M_RXEN4),
        .RXEN5                          (B2M_RXEN5),
        .RXEN6                          (B2M_RXEN6),
        .RXEN7                          (B2M_RXEN7),
        .TXEN0                          (B2M_TXEN0),
        .TXEN1                          (B2M_TXEN1),
        .TXEN2                          (B2M_TXEN2),
        .TXEN3                          (B2M_TXEN3),
        .TXEN4                          (B2M_TXEN4),
        .TXEN5                          (B2M_TXEN5),
        .TXEN6                          (B2M_TXEN6),
        .TXEN7                          (B2M_TXEN7),
        //------------------------------- PRBS Ports -------------------------------
        .RXPRBSEN0                      (B2M_RXPRBSEN0),
        .RXPRBSEN1                      (B2M_RXPRBSEN1),
        .RXPRBSEN2                      (B2M_RXPRBSEN2),
        .RXPRBSEN3                      (B2M_RXPRBSEN3),
        .RXPRBSEN4                      (B2M_RXPRBSEN4),
        .RXPRBSEN5                      (B2M_RXPRBSEN5),
        .RXPRBSEN6                      (B2M_RXPRBSEN6),
        .RXPRBSEN7                      (B2M_RXPRBSEN7),
        .RXPRBSPASS0                    (M2B_RXPRBSPASS0),
        .RXPRBSPASS1                    (M2B_RXPRBSPASS1),
        .RXPRBSPASS2                    (M2B_RXPRBSPASS2),
        .RXPRBSPASS3                    (M2B_RXPRBSPASS3),
        .RXPRBSPASS4                    (M2B_RXPRBSPASS4),
        .RXPRBSPASS5                    (M2B_RXPRBSPASS5),
        .RXPRBSPASS6                    (M2B_RXPRBSPASS6),
        .RXPRBSPASS7                    (M2B_RXPRBSPASS7),
        .RXPRBSSEL0                     (B2M_RXPRBSSEL0),
        .RXPRBSSEL1                     (B2M_RXPRBSSEL1),
        .RXPRBSSEL2                     (B2M_RXPRBSSEL2),
        .RXPRBSSEL3                     (B2M_RXPRBSSEL3),
        .RXPRBSSEL4                     (B2M_RXPRBSSEL4),
        .RXPRBSSEL5                     (B2M_RXPRBSSEL5),
        .RXPRBSSEL6                     (B2M_RXPRBSSEL6),
        .RXPRBSSEL7                     (B2M_RXPRBSSEL7),
        .TXPRBSEN0                      (B2M_TXPRBSEN0),
        .TXPRBSEN1                      (B2M_TXPRBSEN1),
        .TXPRBSEN2                      (B2M_TXPRBSEN2),
        .TXPRBSEN3                      (B2M_TXPRBSEN3),
        .TXPRBSEN4                      (B2M_TXPRBSEN4),
        .TXPRBSEN5                      (B2M_TXPRBSEN5),
        .TXPRBSEN6                      (B2M_TXPRBSEN6),
        .TXPRBSEN7                      (B2M_TXPRBSEN7),
        .TXPRBSSEL0                     (B2M_TXPRBSSEL0),
        .TXPRBSSEL1                     (B2M_TXPRBSSEL1),
        .TXPRBSSEL2                     (B2M_TXPRBSSEL2),
        .TXPRBSSEL3                     (B2M_TXPRBSSEL3),
        .TXPRBSSEL4                     (B2M_TXPRBSSEL4),
        .TXPRBSSEL5                     (B2M_TXPRBSSEL5),
        .TXPRBSSEL6                     (B2M_TXPRBSSEL6),
        .TXPRBSSEL7                     (B2M_TXPRBSSEL7),
        //------------------------ Polarity Inversion Ports ------------------------
        .RXPOLARITY0                    (B2M_RXPOLARITY0),
        .RXPOLARITY1                    (B2M_RXPOLARITY1),
        .RXPOLARITY2                    (B2M_RXPOLARITY2),
        .RXPOLARITY3                    (B2M_RXPOLARITY3),
        .RXPOLARITY4                    (B2M_RXPOLARITY4),
        .RXPOLARITY5                    (B2M_RXPOLARITY5),
        .RXPOLARITY6                    (B2M_RXPOLARITY6),
        .RXPOLARITY7                    (B2M_RXPOLARITY7),
        .TXPOLARITY0                    (B2M_TXPOLARITY0),
        .TXPOLARITY1                    (B2M_TXPOLARITY1),
        .TXPOLARITY2                    (B2M_TXPOLARITY2),
        .TXPOLARITY3                    (B2M_TXPOLARITY3),
        .TXPOLARITY4                    (B2M_TXPOLARITY4),
        .TXPOLARITY5                    (B2M_TXPOLARITY5),
        .TXPOLARITY6                    (B2M_TXPOLARITY6),
        .TXPOLARITY7                    (B2M_TXPOLARITY7),
        //--------------------------- RX SIGNAL OK Ports ---------------------------
        .RXSIGNALOK0                    (M2B_RXSIGNALOK0),
        .RXSIGNALOK1                    (M2B_RXSIGNALOK1),
        .RXSIGNALOK2                    (M2B_RXSIGNALOK2),
        .RXSIGNALOK3                    (M2B_RXSIGNALOK3),
        .RXSIGNALOK4                    (M2B_RXSIGNALOK4),
        .RXSIGNALOK5                    (M2B_RXSIGNALOK5),
        .RXSIGNALOK6                    (M2B_RXSIGNALOK6),
        .RXSIGNALOK7                    (M2B_RXSIGNALOK7),
        //----------------------------- Reserved Ports -----------------------------
        .RSVDOUT                        (M2B_RSVDOUT),
        .FIBRSVDIN1                     (B2M_FIBRSVDIN1),
        .FIBRSVDIN2                     (B2M_FIBRSVDIN2),
        .FIBRSVDIN3                     (B2M_FIBRSVDIN3),
        .FIBRSVDIN4                     (B2M_FIBRSVDIN4),
        .FIBRSVDIN5                     (B2M_FIBRSVDIN5),
        .FIBRSVDIN6                     (B2M_FIBRSVDIN6),
        .FIBRSVDIN7                     (B2M_FIBRSVDIN7),
        .FIBRSVDOUT0                    (M2B_FIBRSVDOUT0),
        .FIBRSVDOUT1                    (M2B_FIBRSVDOUT1),
        .FIBRSVDOUT2                    (M2B_FIBRSVDOUT2),
        .FIBRSVDOUT3                    (M2B_FIBRSVDOUT3),
        .FIBRSVDOUT4                    (M2B_FIBRSVDOUT4),
        .FIBRSVDOUT5                    (M2B_FIBRSVDOUT5),
        .FIBRSVDOUT6                    (M2B_FIBRSVDOUT6),
        .FIBRSVDOUT7                    (M2B_FIBRSVDOUT7),
        //-------------------------- Rx Fabric Interface ---------------------------
        .RXDATA0                        (M2B_RXDATA0),
        .RXDATA1                        (M2B_RXDATA1),
        .RXDATA2                        (M2B_RXDATA2),
        .RXDATA3                        (M2B_RXDATA3),
        .RXDATA4                        (M2B_RXDATA4),
        .RXDATA5                        (M2B_RXDATA5),
        .RXDATA6                        (M2B_RXDATA6),
        .RXDATA7                        (M2B_RXDATA7),
        .RXDATAVALID0                   (M2B_RXDATAVALID0),
        .RXDATAVALID1                   (M2B_RXDATAVALID1),
        .RXDATAVALID2                   (M2B_RXDATAVALID2),
        .RXDATAVALID3                   (M2B_RXDATAVALID3),
        .RXDATAVALID4                   (M2B_RXDATAVALID4),
        .RXDATAVALID5                   (M2B_RXDATAVALID5),
        .RXDATAVALID6                   (M2B_RXDATAVALID6),
        .RXDATAVALID7                   (M2B_RXDATAVALID7),
        .RXDATAWIDTH0                   (B2M_RXDATAWIDTH0),
        .RXDATAWIDTH1                   (B2M_RXDATAWIDTH1),
        .RXDATAWIDTH2                   (B2M_RXDATAWIDTH2),
        .RXDATAWIDTH3                   (B2M_RXDATAWIDTH3),
        .RXDATAWIDTH4                   (B2M_RXDATAWIDTH4),
        .RXDATAWIDTH5                   (B2M_RXDATAWIDTH5),
        .RXDATAWIDTH6                   (B2M_RXDATAWIDTH6),
        .RXDATAWIDTH7                   (B2M_RXDATAWIDTH7),
        .RXHEADER0                      (M2B_RXHEADER0),
        .RXHEADER1                      (M2B_RXHEADER1),
        .RXHEADER2                      (M2B_RXHEADER2),
        .RXHEADER3                      (M2B_RXHEADER3),
        .RXHEADER4                      (M2B_RXHEADER4),
        .RXHEADER5                      (M2B_RXHEADER5),
        .RXHEADER6                      (M2B_RXHEADER6),
        .RXHEADER7                      (M2B_RXHEADER7),
        .RXHEADERVALID0                 (M2B_RXHEADERVALID0),
        .RXHEADERVALID1                 (M2B_RXHEADERVALID1),
        .RXHEADERVALID2                 (M2B_RXHEADERVALID2),
        .RXHEADERVALID3                 (M2B_RXHEADERVALID3),
        .RXHEADERVALID4                 (M2B_RXHEADERVALID4),
        .RXHEADERVALID5                 (M2B_RXHEADERVALID5),
        .RXHEADERVALID6                 (M2B_RXHEADERVALID6),
        .RXHEADERVALID7                 (M2B_RXHEADERVALID7),
        //-------------------------- Rx Reset Controller ---------------------------
        .GTZRXRESET0                    (B2M_GTZRXRESET0),
        .GTZRXRESET1                    (B2M_GTZRXRESET1),
        .GTZRXRESET2                    (B2M_GTZRXRESET2),
        .GTZRXRESET3                    (B2M_GTZRXRESET3),
        .GTZRXRESET4                    (B2M_GTZRXRESET4),
        .GTZRXRESET5                    (B2M_GTZRXRESET5),
        .GTZRXRESET6                    (B2M_GTZRXRESET6),
        .GTZRXRESET7                    (B2M_GTZRXRESET7),
        .RXRDY0                         (M2B_RXRDY0),
        .RXRDY1                         (M2B_RXRDY1),
        .RXRDY2                         (M2B_RXRDY2),
        .RXRDY3                         (M2B_RXRDY3),
        .RXRDY4                         (M2B_RXRDY4),
        .RXRDY5                         (M2B_RXRDY5),
        .RXRDY6                         (M2B_RXRDY6),
        .RXRDY7                         (M2B_RXRDY7),
        .RXRESETDONE0                   (M2B_RXRESETDONE0),
        .RXRESETDONE1                   (M2B_RXRESETDONE1),
        .RXRESETDONE2                   (M2B_RXRESETDONE2),
        .RXRESETDONE3                   (M2B_RXRESETDONE3),
        .RXRESETDONE4                   (M2B_RXRESETDONE4),
        .RXRESETDONE5                   (M2B_RXRESETDONE5),
        .RXRESETDONE6                   (M2B_RXRESETDONE6),
        .RXRESETDONE7                   (M2B_RXRESETDONE7),
        
        //------------------------------- SBUS Ports -------------------------------
        .SBUSCLKSEL                     (B2M_SBUSCLKSEL),
        .SBUSRESETB                     (B2M_SBUSRESETB),
        .SPARESBUSCOMMAND               (B2M_SPARESBUSCOMMAND),
        .SPARESBUSDATA                  (B2M_SPARESBUSDATA),
        .SPARESBUSDATAADDR              (B2M_SPARESBUSDATAADDR),
        .SPARESBUSDATAOUT               (M2B_SPARESBUSDATAOUT),
        .SPARESBUSDONE                  (M2B_SPARESBUSDONE),
        .SPARESBUSEXECUTEB              (B2M_SPARESBUSEXECUTEB),
        .SPARESBUSRCVDATAVALID          (M2B_SPARESBUSRCVDATAVALID),
        .SPARESBUSRCVDATAVALIDSEL       (B2M_SPARESBUSRCVDATAVALIDSEL),
        .SPARESBUSRECADDR               (B2M_SPARESBUSRECADDR),
        .SPARESBUSRESULTCODE            (M2B_SPARESBUSRESULTCODE),
        //-------------------------- Tx Fabric Interface ---------------------------
        .TXDATA0                        (B2M_TXDATA0),
        .TXDATA1                        (B2M_TXDATA1),
        .TXDATA2                        (B2M_TXDATA2),
        .TXDATA3                        (B2M_TXDATA3),
        .TXDATA4                        (B2M_TXDATA4),
        .TXDATA5                        (B2M_TXDATA5),
        .TXDATA6                        (B2M_TXDATA6),
        .TXDATA7                        (B2M_TXDATA7),
        .TXDATAWIDTH0                   (B2M_TXDATAWIDTH0),
        .TXDATAWIDTH1                   (B2M_TXDATAWIDTH1),
        .TXDATAWIDTH2                   (B2M_TXDATAWIDTH2),
        .TXDATAWIDTH3                   (B2M_TXDATAWIDTH3),
        .TXDATAWIDTH4                   (B2M_TXDATAWIDTH4),
        .TXDATAWIDTH5                   (B2M_TXDATAWIDTH5),
        .TXDATAWIDTH6                   (B2M_TXDATAWIDTH6),
        .TXDATAWIDTH7                   (B2M_TXDATAWIDTH7),
        .TXHEADER0                      (B2M_TXHEADER0),
        .TXHEADER1                      (B2M_TXHEADER1),
        .TXHEADER2                      (B2M_TXHEADER2),
        .TXHEADER3                      (B2M_TXHEADER3),
        .TXHEADER4                      (B2M_TXHEADER4),
        .TXHEADER5                      (B2M_TXHEADER5),
        .TXHEADER6                      (B2M_TXHEADER6),
        .TXHEADER7                      (B2M_TXHEADER7),
        //-------------------------- Tx Reset Controller ---------------------------
        .GTZTXRESET0                    (B2M_GTZTXRESET0),
        .GTZTXRESET1                    (B2M_GTZTXRESET1),
        .GTZTXRESET2                    (B2M_GTZTXRESET2),
        .GTZTXRESET3                    (B2M_GTZTXRESET3),
        .GTZTXRESET4                    (B2M_GTZTXRESET4),
        .GTZTXRESET5                    (B2M_GTZTXRESET5),
        .GTZTXRESET6                    (B2M_GTZTXRESET6),
        .GTZTXRESET7                    (B2M_GTZTXRESET7),
        .TXRDY0                         (M2B_TXRDY0),
        .TXRDY1                         (M2B_TXRDY1),
        .TXRDY2                         (M2B_TXRDY2),
        .TXRDY3                         (M2B_TXRDY3),
        .TXRDY4                         (M2B_TXRDY4),
        .TXRDY5                         (M2B_TXRDY5),
        .TXRDY6                         (M2B_TXRDY6),
        .TXRDY7                         (M2B_TXRDY7),
        .TXRESETDONE0                   (M2B_TXRESETDONE0),
        .TXRESETDONE1                   (M2B_TXRESETDONE1),
        .TXRESETDONE2                   (M2B_TXRESETDONE2),
        .TXRESETDONE3                   (M2B_TXRESETDONE3),
        .TXRESETDONE4                   (M2B_TXRESETDONE4),
        .TXRESETDONE5                   (M2B_TXRESETDONE5),
        .TXRESETDONE6                   (M2B_TXRESETDONE6),
        .TXRESETDONE7                   (M2B_TXRESETDONE7),
        //---------------------------- Tx driver Ports -----------------------------
        .TXATTNCTRL0                    (B2M_TXATTNCTRL0),
        .TXATTNCTRL1                    (B2M_TXATTNCTRL1),
        .TXATTNCTRL2                    (B2M_TXATTNCTRL2),
        .TXATTNCTRL3                    (B2M_TXATTNCTRL3),
        .TXATTNCTRL4                    (B2M_TXATTNCTRL4),
        .TXATTNCTRL5                    (B2M_TXATTNCTRL5),
        .TXATTNCTRL6                    (B2M_TXATTNCTRL6),
        .TXATTNCTRL7                    (B2M_TXATTNCTRL7),
        .TXEQPOSTCTRL0                  (B2M_TXEQPOSTCTRL0),
        .TXEQPOSTCTRL1                  (B2M_TXEQPOSTCTRL1),
        .TXEQPOSTCTRL2                  (B2M_TXEQPOSTCTRL2),
        .TXEQPOSTCTRL3                  (B2M_TXEQPOSTCTRL3),
        .TXEQPOSTCTRL4                  (B2M_TXEQPOSTCTRL4),
        .TXEQPOSTCTRL5                  (B2M_TXEQPOSTCTRL5),
        .TXEQPOSTCTRL6                  (B2M_TXEQPOSTCTRL6),
        .TXEQPOSTCTRL7                  (B2M_TXEQPOSTCTRL7),
        .TXEQPRECTRL0                   (B2M_TXEQPRECTRL0),
        .TXEQPRECTRL1                   (B2M_TXEQPRECTRL1),
        .TXEQPRECTRL2                   (B2M_TXEQPRECTRL2),
        .TXEQPRECTRL3                   (B2M_TXEQPRECTRL3),
        .TXEQPRECTRL4                   (B2M_TXEQPRECTRL4),
        .TXEQPRECTRL5                   (B2M_TXEQPRECTRL5),
        .TXEQPRECTRL6                   (B2M_TXEQPRECTRL6),
        .TXEQPRECTRL7                   (B2M_TXEQPRECTRL7),
        .TXOUTPUTEN0                    (B2M_TXOUTPUTEN0),
        .TXOUTPUTEN1                    (B2M_TXOUTPUTEN1),
        .TXOUTPUTEN2                    (B2M_TXOUTPUTEN2),
        .TXOUTPUTEN3                    (B2M_TXOUTPUTEN3),
        .TXOUTPUTEN4                    (B2M_TXOUTPUTEN4),
        .TXOUTPUTEN5                    (B2M_TXOUTPUTEN5),
        .TXOUTPUTEN6                    (B2M_TXOUTPUTEN6),
        .TXOUTPUTEN7                    (B2M_TXOUTPUTEN7),
        .TXSLEWCTRL0                    (B2M_TXSLEWCTRL0),
        .TXSLEWCTRL1                    (B2M_TXSLEWCTRL1),
        .TXSLEWCTRL2                    (B2M_TXSLEWCTRL2),
        .TXSLEWCTRL3                    (B2M_TXSLEWCTRL3),
        .TXSLEWCTRL4                    (B2M_TXSLEWCTRL4),
        .TXSLEWCTRL5                    (B2M_TXSLEWCTRL5),
        .TXSLEWCTRL6                    (B2M_TXSLEWCTRL6),
        .TXSLEWCTRL7                    (B2M_TXSLEWCTRL7),
        //--------------------------- Tx override Ports ----------------------------
        .TXOVERRIDEEN0                  (B2M_TXOVERRIDEEN0),
        .TXOVERRIDEEN1                  (B2M_TXOVERRIDEEN1),
        .TXOVERRIDEEN2                  (B2M_TXOVERRIDEEN2),
        .TXOVERRIDEEN3                  (B2M_TXOVERRIDEEN3),
        .TXOVERRIDEEN4                  (B2M_TXOVERRIDEEN4),
        .TXOVERRIDEEN5                  (B2M_TXOVERRIDEEN5),
        .TXOVERRIDEEN6                  (B2M_TXOVERRIDEEN6),
        .TXOVERRIDEEN7                  (B2M_TXOVERRIDEEN7),
        .TXOVERRIDEIN0                  (B2M_TXOVERRIDEIN0),
        .TXOVERRIDEIN1                  (B2M_TXOVERRIDEIN1),
        .TXOVERRIDEIN2                  (B2M_TXOVERRIDEIN2),
        .TXOVERRIDEIN3                  (B2M_TXOVERRIDEIN3),
        .TXOVERRIDEIN4                  (B2M_TXOVERRIDEIN4),
        .TXOVERRIDEIN5                  (B2M_TXOVERRIDEIN5),
        .TXOVERRIDEIN6                  (B2M_TXOVERRIDEIN6),
        .TXOVERRIDEIN7                  (B2M_TXOVERRIDEIN7),
        //--------------------------- Tx phase cal Ports ---------------------------
        .TXPHASECALEN0                  (B2M_TXPHASECALEN0),
        .TXPHASECALEN1                  (B2M_TXPHASECALEN1),
        .TXPHASECALEN2                  (B2M_TXPHASECALEN2),
        .TXPHASECALEN3                  (B2M_TXPHASECALEN3),
        .TXPHASECALEN4                  (B2M_TXPHASECALEN4),
        .TXPHASECALEN5                  (B2M_TXPHASECALEN5),
        .TXPHASECALEN6                  (B2M_TXPHASECALEN6),
        .TXPHASECALEN7                  (B2M_TXPHASECALEN7),
        .TXPHASESLIP0                   (B2M_TXPHASESLIP0),
        .TXPHASESLIP1                   (B2M_TXPHASESLIP1),
        .TXPHASESLIP2                   (B2M_TXPHASESLIP2),
        .TXPHASESLIP3                   (B2M_TXPHASESLIP3),
        .TXPHASESLIP4                   (B2M_TXPHASESLIP4),
        .TXPHASESLIP5                   (B2M_TXPHASESLIP5),
        .TXPHASESLIP6                   (B2M_TXPHASESLIP6),
        .TXPHASESLIP7                   (B2M_TXPHASESLIP7),
        //--------------------------- Tx phase out Ports ---------------------------
        .TXPHASEOUT0                    (M2B_TXPHASEOUT0),
        .TXPHASEOUT1                    (M2B_TXPHASEOUT1),
        .TXPHASEOUT2                    (M2B_TXPHASEOUT2),
        .TXPHASEOUT3                    (M2B_TXPHASEOUT3),
        .TXPHASEOUT4                    (M2B_TXPHASEOUT4),
        .TXPHASEOUT5                    (M2B_TXPHASEOUT5),
        .TXPHASEOUT6                    (M2B_TXPHASEOUT6),
        .TXPHASEOUT7                    (M2B_TXPHASEOUT7),
        //--------------------------- Tx sequence Ports ----------------------------
        .TXSEQUENCE0                    (B2M_TXSEQUENCE0),
        .TXSEQUENCE1                    (B2M_TXSEQUENCE1),
        .TXSEQUENCE2                    (B2M_TXSEQUENCE2),
        .TXSEQUENCE3                    (B2M_TXSEQUENCE3),
        .TXSEQUENCE4                    (B2M_TXSEQUENCE4),
        .TXSEQUENCE5                    (B2M_TXSEQUENCE5),
        .TXSEQUENCE6                    (B2M_TXSEQUENCE6),
        .TXSEQUENCE7                    (B2M_TXSEQUENCE7),
        //----------------------------- reserved Ports -----------------------------
        .FIBRSVDIN0                     (B2M_FIBRSVDIN0)

        );

      gtwizard_v3_2_beachfront #
      (
       .GTZ_POWER_UP_LANE0    (1'b1),
       .TXUSRCLK_SEL_LANE0    (TXUSRCLK_LANE0_VAR),
       .RXUSRCLK_SEL_LANE0    (RXUSRCLK_LANE0_VAR),
       .FIB_ASYNC_CTRL_LANE0  (17'h0fdff),
       .GTZ_POWER_UP_LANE1    (1'b1),
       .TXUSRCLK_SEL_LANE1    (TXUSRCLK_LANE1_VAR),
       .RXUSRCLK_SEL_LANE1    (RXUSRCLK_LANE1_VAR),
       .FIB_ASYNC_CTRL_LANE1  (17'h0fdff),
       .GTZ_POWER_UP_LANE2    (1'b1),
       .TXUSRCLK_SEL_LANE2    (TXUSRCLK_LANE2_VAR),
       .RXUSRCLK_SEL_LANE2    (RXUSRCLK_LANE2_VAR),
       .FIB_ASYNC_CTRL_LANE2  (17'h0fdff),
       .GTZ_POWER_UP_LANE3    (1'b1),
       .TXUSRCLK_SEL_LANE3    (TXUSRCLK_LANE3_VAR),
       .RXUSRCLK_SEL_LANE3    (RXUSRCLK_LANE3_VAR),
       .FIB_ASYNC_CTRL_LANE3  (17'h0fdff),
       .GTZ_POWER_UP_LANE4    (1'b0),
       .TXUSRCLK_SEL_LANE4    (TXUSRCLK_LANE4_VAR),
       .RXUSRCLK_SEL_LANE4    (RXUSRCLK_LANE4_VAR),
       .FIB_ASYNC_CTRL_LANE4  (17'h0fdff),
       .GTZ_POWER_UP_LANE5    (1'b0),
       .TXUSRCLK_SEL_LANE5    (TXUSRCLK_LANE5_VAR),
       .RXUSRCLK_SEL_LANE5    (RXUSRCLK_LANE5_VAR),
       .FIB_ASYNC_CTRL_LANE5  (17'h0fdff),
       .GTZ_POWER_UP_LANE6    (1'b0),
       .TXUSRCLK_SEL_LANE6    (TXUSRCLK_LANE6_VAR),
       .RXUSRCLK_SEL_LANE6    (RXUSRCLK_LANE6_VAR),
       .FIB_ASYNC_CTRL_LANE6  (17'h0fdff),
       .GTZ_POWER_UP_LANE7    (1'b0),
       .TXUSRCLK_SEL_LANE7    (TXUSRCLK_LANE7_VAR),
       .RXUSRCLK_SEL_LANE7    (RXUSRCLK_LANE7_VAR),
       .FIB_ASYNC_CTRL_LANE7  (17'h0fdff),

       .RXUSRCLK_SEL_MUX0 ("RXUSRCLK0"),
       .RXUSRCLK_SEL_MUX1 ("RXUSRCLK1"),
       .RXUSRCLK_SEL_MUX2 ("RXUSRCLK2"),
       .RXUSRCLK_SEL_MUX3 ("RXUSRCLK3"),
       .TXUSRCLK_SEL_MUX0 ("TXCORECLK0"), // TXOUTCLK0 -> BUFG_LB (inside beachfront) -> TXUSRCLK0
       .TXUSRCLK_SEL_MUX1 ("TXUSRCLK1")
       ) 
      gtze2_inf_north
      (
       //-----------------------User clocks--------------------------
       .RXCORECLK0(rxcoreclk0_out),
       .RXCORECLK1(rxcoreclk1_out),
       .RXCORECLK2(rxcoreclk2_out),
       .RXCORECLK3(rxcoreclk3_out),
       .TXCORECLK0(txcoreclk0_out),
       .TXCORECLK1(txcoreclk1_out),

       .RXUSRCLK0(rxusrclk0_in),
       .B2M_RXUSRCLK0(B2M_RXUSRCLK0),
       .RXUSRCLK1(rxusrclk1_in),
       .B2M_RXUSRCLK1(B2M_RXUSRCLK1),
       .RXUSRCLK2(rxusrclk2_in),
       .B2M_RXUSRCLK2(B2M_RXUSRCLK2),
       .RXUSRCLK3(rxusrclk3_in),
       .B2M_RXUSRCLK3(B2M_RXUSRCLK3),
       .RXUSRCLK4(rxusrclk4_in),
       .B2M_RXUSRCLK4(B2M_RXUSRCLK4),
       .RXUSRCLK5(rxusrclk5_in),
       .B2M_RXUSRCLK5(B2M_RXUSRCLK5),
       .RXUSRCLK6(rxusrclk6_in),
       .B2M_RXUSRCLK6(B2M_RXUSRCLK6),
       .RXUSRCLK7(rxusrclk7_in),
       .B2M_RXUSRCLK7(B2M_RXUSRCLK7),

       .TXUSRCLK0(txusrclk0_in),
       .B2M_TXUSRCLK0(B2M_TXUSRCLK0),
       .TXUSRCLK1(txusrclk1_in),
       .B2M_TXUSRCLK1(B2M_TXUSRCLK1),
       .TXUSRCLK2(txusrclk2_in),
       .B2M_TXUSRCLK2(B2M_TXUSRCLK2),
       .TXUSRCLK3(txusrclk3_in),
       .B2M_TXUSRCLK3(B2M_TXUSRCLK3),
       .TXUSRCLK4(txusrclk4_in),
       .B2M_TXUSRCLK4(B2M_TXUSRCLK4),
       .TXUSRCLK5(txusrclk5_in),
       .B2M_TXUSRCLK5(B2M_TXUSRCLK5),
       .TXUSRCLK6(txusrclk6_in),
       .B2M_TXUSRCLK6(B2M_TXUSRCLK6),
       .TXUSRCLK7(txusrclk7_in),
       .B2M_TXUSRCLK7(B2M_TXUSRCLK7),

       .DRPCLK0(drpclk0_in),
       .B2M_DRPCLK0(B2M_DRPCLK0),
       .DRPCLK1(drpclk1_in),
       .B2M_DRPCLK1(B2M_DRPCLK1),
       .DRPCLKSEL(drpclksel_in),
       .B2M_DRPCLKSEL(B2M_DRPCLKSEL),

       .B2M_RSVDIN(B2M_RSVDIN),
       
        //----------------------------- BitSlip Ports ------------------------------
        .RXBITSLIP0                     (tied_to_ground_i),
        .B2M_RXBITSLIP0                 (B2M_RXBITSLIP0),
        .RXBITSLIP1                     (tied_to_ground_i),
        .B2M_RXBITSLIP1                 (B2M_RXBITSLIP1),
        .RXBITSLIP2                     (tied_to_ground_i),
        .B2M_RXBITSLIP2                 (B2M_RXBITSLIP2),
        .RXBITSLIP3                     (tied_to_ground_i),
        .B2M_RXBITSLIP3                 (B2M_RXBITSLIP3),
        .RXBITSLIP4                     (tied_to_ground_i),
        .B2M_RXBITSLIP4                 (B2M_RXBITSLIP4),
        .RXBITSLIP5                     (tied_to_ground_i),
        .B2M_RXBITSLIP5                 (B2M_RXBITSLIP5),
        .RXBITSLIP6                     (tied_to_ground_i),
        .B2M_RXBITSLIP6                 (B2M_RXBITSLIP6),
        .RXBITSLIP7                     (tied_to_ground_i),
        .B2M_RXBITSLIP7                 (B2M_RXBITSLIP7),
        .RXGEARBOXSLIP0                 (rxgearboxslip0_in),
        .B2M_RXGEARBOXSLIP0             (B2M_RXGEARBOXSLIP0),
        .RXGEARBOXSLIP1                 (rxgearboxslip1_in),
        .B2M_RXGEARBOXSLIP1             (B2M_RXGEARBOXSLIP1),
        .RXGEARBOXSLIP2                 (rxgearboxslip2_in),
        .B2M_RXGEARBOXSLIP2             (B2M_RXGEARBOXSLIP2),
        .RXGEARBOXSLIP3                 (rxgearboxslip3_in),
        .B2M_RXGEARBOXSLIP3             (B2M_RXGEARBOXSLIP3),
        .RXGEARBOXSLIP4                 (tied_to_ground_vec_i[4:0]),
        .B2M_RXGEARBOXSLIP4             (B2M_RXGEARBOXSLIP4),
        .RXGEARBOXSLIP5                 (tied_to_ground_vec_i[4:0]),
        .B2M_RXGEARBOXSLIP5             (B2M_RXGEARBOXSLIP5),
        .RXGEARBOXSLIP6                 (tied_to_ground_vec_i[4:0]),
        .B2M_RXGEARBOXSLIP6             (B2M_RXGEARBOXSLIP6),
        .RXGEARBOXSLIP7                 (tied_to_ground_vec_i[4:0]),
        .B2M_RXGEARBOXSLIP7             (B2M_RXGEARBOXSLIP7),
        //----------------------------- Clocking Ports -----------------------------
        .REFCLKSEL0                     (refclksel0_in),
        .B2M_REFCLKSEL0                 (B2M_REFCLKSEL0),
        .REFCLKSEL1                     (refclksel1_in),
        .B2M_REFCLKSEL1                 (B2M_REFCLKSEL1),
        .REFCLKSEL2                     (refclksel2_in),
        .B2M_REFCLKSEL2                 (B2M_REFCLKSEL2),
        .REFCLKSEL3                     (refclksel3_in),
        .B2M_REFCLKSEL3                 (B2M_REFCLKSEL3),
        .REFCLKSEL4                     (1'b0),
        .B2M_REFCLKSEL4                 (B2M_REFCLKSEL4),
        .REFCLKSEL5                     (1'b0),
        .B2M_REFCLKSEL5                 (B2M_REFCLKSEL5),
        .REFCLKSEL6                     (1'b0),
        .B2M_REFCLKSEL6                 (B2M_REFCLKSEL6),
        .REFCLKSEL7                     (1'b0),
        .B2M_REFCLKSEL7                 (B2M_REFCLKSEL7),
        .RXOUTCLK0                      (rxoutclk0_out),
        .M2B_RXOUTCLK0                  (M2B_RXOUTCLK0),
        .RXOUTCLK1                      (rxoutclk1_out),
        .M2B_RXOUTCLK1                  (M2B_RXOUTCLK1),
        .RXOUTCLK2                      (rxoutclk2_out),
        .M2B_RXOUTCLK2                  (M2B_RXOUTCLK2),
        .RXOUTCLK3                      (rxoutclk3_out),
        .M2B_RXOUTCLK3                  (M2B_RXOUTCLK3),
        .TXOUTCLK0                      (txoutclk0_out),
        .M2B_TXOUTCLK0                  (M2B_TXOUTCLK0),
        .TXOUTCLK1                      (txoutclk1_out),
        .M2B_TXOUTCLK1                  (M2B_TXOUTCLK1),
        //-------------------------- Configuration Ports ---------------------------
        .CFGBADVERSIONB                 (),
        .M2B_CFGBADVERSIONB             (M2B_CFGBADVERSIONB),
        .CFGCLK                         (tied_to_ground_i),
        .B2M_CFGCLK                     (B2M_CFGCLK),
        .CFGCRCERRB                     (),
        .M2B_CFGCRCERRB                 (M2B_CFGCRCERRB),
        .CFGDATA                        (tied_to_ground_vec_i[31:0]),
        .B2M_CFGDATA                    (B2M_CFGDATA),
        .CFGDATAVALID                   (tied_to_ground_i),
        .B2M_CFGDATAVALID               (B2M_CFGDATAVALID),
        .CFGDEBUGMODEB                  (3'b111),
        .B2M_CFGDEBUGMODEB              (B2M_CFGDEBUGMODEB),
        .CFGFORCESEUERRB                (2'b11),
        .B2M_CFGFORCESEUERRB            (B2M_CFGFORCESEUERRB),
        .CFGGTZDONEB                    (),
        .M2B_CFGGTZDONEB                (M2B_CFGGTZDONEB),
        .CFGREADBACKB                   (1'b1),
        .B2M_CFGREADBACKB               (B2M_CFGREADBACKB),
        .CFGSEUERRB                     (),
        .M2B_CFGSEUERRB                 (M2B_CFGSEUERRB),
        .GTZINIT                        (gtzinit_in),
        .B2M_GTZINIT                    (B2M_GTZINIT),
        .GTZINITDONEB                   (gtzinitdoneb_out),
        .M2B_GTZINITDONEB               (M2B_GTZINITDONEB),
        //------------------------------- DRP Ports --------------------------------
        .DRPADDR                        (drpaddr_in),
        .B2M_DRPADDR                    (B2M_DRPADDR),
        .DRPDI                          (drpdi_in),
        .B2M_DRPDI                      (B2M_DRPDI),
        .DRPDO                          (drpdo_out),
        .M2B_DRPDO                      (M2B_DRPDO),
        .DRPEN                          (drpen_in),
        .B2M_DRPEN                      (B2M_DRPEN),
        .DRPRDY                         (drprdy_out),
        .M2B_DRPRDY                     (M2B_DRPRDY),
        .DRPSTATUS                      (drpstatus_out),
        .M2B_DRPSTATUS                  (M2B_DRPSTATUS),
        .DRPWDTERR                      (drpwdterr_out),
        .M2B_DRPWDTERR                  (M2B_DRPWDTERR),
        .DRPWE                          (drpwe_in),
        .B2M_DRPWE                      (B2M_DRPWE),
        //---------------------------- FIB Reset Ports -----------------------------
        .RXFIBRESET0                    (rxfibreset0_in),
        .B2M_RXFIBRESET0                (B2M_RXFIBRESET0),
        .RXFIBRESET1                    (rxfibreset1_in),
        .B2M_RXFIBRESET1                (B2M_RXFIBRESET1),
        .RXFIBRESET2                    (rxfibreset2_in),
        .B2M_RXFIBRESET2                (B2M_RXFIBRESET2),
        .RXFIBRESET3                    (rxfibreset3_in),
        .B2M_RXFIBRESET3                (B2M_RXFIBRESET3),
        .RXFIBRESET4                    (1'b1),
        .B2M_RXFIBRESET4                (B2M_RXFIBRESET4),
        .RXFIBRESET5                    (1'b1),
        .B2M_RXFIBRESET5                (B2M_RXFIBRESET5),
        .RXFIBRESET6                    (1'b1),
        .B2M_RXFIBRESET6                (B2M_RXFIBRESET6),
        .RXFIBRESET7                    (1'b1),
        .B2M_RXFIBRESET7                (B2M_RXFIBRESET7),
        .TXFIBRESET0                    (1'b0),
        .B2M_TXFIBRESET0                (B2M_TXFIBRESET0),
        .TXFIBRESET1                    (1'b0),
        .B2M_TXFIBRESET1                (B2M_TXFIBRESET1),
        .TXFIBRESET2                    (1'b0),
        .B2M_TXFIBRESET2                (B2M_TXFIBRESET2),
        .TXFIBRESET3                    (1'b0),
        .B2M_TXFIBRESET3                (B2M_TXFIBRESET3),
        .TXFIBRESET4                    (1'b1),
        .B2M_TXFIBRESET4                (B2M_TXFIBRESET4),
        .TXFIBRESET5                    (1'b1),
        .B2M_TXFIBRESET5                (B2M_TXFIBRESET5),
        .TXFIBRESET6                    (1'b1),
        .B2M_TXFIBRESET6                (B2M_TXFIBRESET6),
        .TXFIBRESET7                    (1'b1),
        .B2M_TXFIBRESET7                (B2M_TXFIBRESET7),
        //------------------------------- FIFO Ports -------------------------------
        .RXFIFOSTATUS0                  (),
        .M2B_RXFIFOSTATUS0              (M2B_RXFIFOSTATUS0),
        .RXFIFOSTATUS1                  (),
        .M2B_RXFIFOSTATUS1              (M2B_RXFIFOSTATUS1),
        .RXFIFOSTATUS2                  (),
        .M2B_RXFIFOSTATUS2              (M2B_RXFIFOSTATUS2),
        .RXFIFOSTATUS3                  (),
        .M2B_RXFIFOSTATUS3              (M2B_RXFIFOSTATUS3),
        .RXFIFOSTATUS4                  (),
        .M2B_RXFIFOSTATUS4              (M2B_RXFIFOSTATUS4),
        .RXFIFOSTATUS5                  (),
        .M2B_RXFIFOSTATUS5              (M2B_RXFIFOSTATUS5),
        .RXFIFOSTATUS6                  (),
        .M2B_RXFIFOSTATUS6              (M2B_RXFIFOSTATUS6),
        .RXFIFOSTATUS7                  (),
        .M2B_RXFIFOSTATUS7              (M2B_RXFIFOSTATUS7),
        .TXFIFOSTATUS0                  (),
        .M2B_TXFIFOSTATUS0              (M2B_TXFIFOSTATUS0),
        .TXFIFOSTATUS1                  (),
        .M2B_TXFIFOSTATUS1              (M2B_TXFIFOSTATUS1),
        .TXFIFOSTATUS2                  (),
        .M2B_TXFIFOSTATUS2              (M2B_TXFIFOSTATUS2),
        .TXFIFOSTATUS3                  (),
        .M2B_TXFIFOSTATUS3              (M2B_TXFIFOSTATUS3),
        .TXFIFOSTATUS4                  (),
        .M2B_TXFIFOSTATUS4              (M2B_TXFIFOSTATUS4),
        .TXFIFOSTATUS5                  (),
        .M2B_TXFIFOSTATUS5              (M2B_TXFIFOSTATUS5),
        .TXFIFOSTATUS6                  (),
        .M2B_TXFIFOSTATUS6              (M2B_TXFIFOSTATUS6),
        .TXFIFOSTATUS7                  (),
        .M2B_TXFIFOSTATUS7              (M2B_TXFIFOSTATUS7),
        //-------------------------- Latency clock Ports ---------------------------
        .RXLATCLK                       (rxlatclk_in),
        .B2M_RXLATCLK                   (B2M_RXLATCLK),
        .TXLATCLK                       (txlatclk_in),
        .B2M_TXLATCLK                   (B2M_TXLATCLK),
        //------------------------------- Loopbacks --------------------------------
        .FARLOOPBACKEN0                 (tied_to_ground_i),
        .B2M_FARLOOPBACKEN0             (B2M_FARLOOPBACKEN0),
        .FARLOOPBACKEN1                 (tied_to_ground_i),
        .B2M_FARLOOPBACKEN1             (B2M_FARLOOPBACKEN1),
        .FARLOOPBACKEN2                 (tied_to_ground_i),
        .B2M_FARLOOPBACKEN2             (B2M_FARLOOPBACKEN2),
        .FARLOOPBACKEN3                 (tied_to_ground_i),
        .B2M_FARLOOPBACKEN3             (B2M_FARLOOPBACKEN3),
        .FARLOOPBACKEN4                 (tied_to_ground_i),
        .B2M_FARLOOPBACKEN4             (B2M_FARLOOPBACKEN4),
        .FARLOOPBACKEN5                 (tied_to_ground_i),
        .B2M_FARLOOPBACKEN5             (B2M_FARLOOPBACKEN5),
        .FARLOOPBACKEN6                 (tied_to_ground_i),
        .B2M_FARLOOPBACKEN6             (B2M_FARLOOPBACKEN6),
        .FARLOOPBACKEN7                 (tied_to_ground_i),
        .B2M_FARLOOPBACKEN7             (B2M_FARLOOPBACKEN7),
        .NEARLOOPBACKEN0                (nearloopbacken0_in),
        .B2M_NEARLOOPBACKEN0            (B2M_NEARLOOPBACKEN0),
        .NEARLOOPBACKEN1                (nearloopbacken1_in),
        .B2M_NEARLOOPBACKEN1            (B2M_NEARLOOPBACKEN1),
        .NEARLOOPBACKEN2                (nearloopbacken2_in),
        .B2M_NEARLOOPBACKEN2            (B2M_NEARLOOPBACKEN2),
        .NEARLOOPBACKEN3                (nearloopbacken3_in),
        .B2M_NEARLOOPBACKEN3            (B2M_NEARLOOPBACKEN3),
        .NEARLOOPBACKEN4                (tied_to_ground_i),
        .B2M_NEARLOOPBACKEN4            (B2M_NEARLOOPBACKEN4),
        .NEARLOOPBACKEN5                (tied_to_ground_i),
        .B2M_NEARLOOPBACKEN5            (B2M_NEARLOOPBACKEN5),
        .NEARLOOPBACKEN6                (tied_to_ground_i),
        .B2M_NEARLOOPBACKEN6            (B2M_NEARLOOPBACKEN6),
        .NEARLOOPBACKEN7                (tied_to_ground_i),
        .B2M_NEARLOOPBACKEN7            (B2M_NEARLOOPBACKEN7),
        //------------------------ PLL Recalibration Ports -------------------------
        .PLLRECALEN0                    (pllrecalen0_in),
        .B2M_PLLRECALEN0                (B2M_PLLRECALEN0),
        .PLLRECALEN1                    (pllrecalen1_in),
        .B2M_PLLRECALEN1                (B2M_PLLRECALEN1),
        .PLLRECALEN2                    (pllrecalen2_in),
        .B2M_PLLRECALEN2                (B2M_PLLRECALEN2),
        .PLLRECALEN3                    (pllrecalen3_in),
        .B2M_PLLRECALEN3                (B2M_PLLRECALEN3),
        .PLLRECALEN4                    (tied_to_ground_i),
        .B2M_PLLRECALEN4                (B2M_PLLRECALEN4),
        .PLLRECALEN5                    (tied_to_ground_i),
        .B2M_PLLRECALEN5                (B2M_PLLRECALEN5),
        .PLLRECALEN6                    (tied_to_ground_i),
        .B2M_PLLRECALEN6                (B2M_PLLRECALEN6),
        .PLLRECALEN7                    (tied_to_ground_i),
        .B2M_PLLRECALEN7                (B2M_PLLRECALEN7),
        //------------------------------ PLL Settings ------------------------------
        .CORECNTL0                      (16'b1111101010101010),
        .B2M_CORECNTL0                  (B2M_CORECNTL0),
        .CORECNTL1                      (16'b1111101010101010),
        .B2M_CORECNTL1                  (B2M_CORECNTL1),
        .CORECNTL2                      (16'b1111101010101010),
        .B2M_CORECNTL2                  (B2M_CORECNTL2),
        .CORECNTL3                      (16'b1111101010101010),
        .B2M_CORECNTL3                  (B2M_CORECNTL3),
        .CORECNTL4                      (16'b1111101010101010),
        .B2M_CORECNTL4                  (B2M_CORECNTL4),
        .CORECNTL5                      (16'b1111101010101010),
        .B2M_CORECNTL5                  (B2M_CORECNTL5),
        .CORECNTL6                      (16'b1111101010101010),
        .B2M_CORECNTL6                  (B2M_CORECNTL6),
        .CORECNTL7                      (16'b1111101010101010),
        .B2M_CORECNTL7                  (B2M_CORECNTL7),
        .REFSEL0                        (8'b00001101),
        .B2M_REFSEL0                    (B2M_REFSEL0),
        .REFSEL1                        (8'b00001101),
        .B2M_REFSEL1                    (B2M_REFSEL1),
        .REFSEL2                        (8'b00001101),
        .B2M_REFSEL2                    (B2M_REFSEL2),
        .REFSEL3                        (8'b00001101),
        .B2M_REFSEL3                    (B2M_REFSEL3),
        .REFSEL4                        (8'b00001101),
        .B2M_REFSEL4                    (B2M_REFSEL4),
        .REFSEL5                        (8'b00001101),
        .B2M_REFSEL5                    (B2M_REFSEL5),
        .REFSEL6                        (8'b00001101),
        .B2M_REFSEL6                    (B2M_REFSEL6),
        .REFSEL7                        (8'b00001101),
        .B2M_REFSEL7                    (B2M_REFSEL7),
        .RXRATESEL0                     (9'b011100000),
        .B2M_RXRATESEL0                 (B2M_RXRATESEL0),
        .RXRATESEL1                     (9'b011100000),
        .B2M_RXRATESEL1                 (B2M_RXRATESEL1),
        .RXRATESEL2                     (9'b011100000),
        .B2M_RXRATESEL2                 (B2M_RXRATESEL2),
        .RXRATESEL3                     (9'b011100000),
        .B2M_RXRATESEL3                 (B2M_RXRATESEL3),
        .RXRATESEL4                     (9'b011100000),
        .B2M_RXRATESEL4                 (B2M_RXRATESEL4),
        .RXRATESEL5                     (9'b011100000),
        .B2M_RXRATESEL5                 (B2M_RXRATESEL5),
        .RXRATESEL6                     (9'b011100000),
        .B2M_RXRATESEL6                 (B2M_RXRATESEL6),
        .RXRATESEL7                     (9'b011100000),
        .B2M_RXRATESEL7                 (B2M_RXRATESEL7),
        .TXRATESEL0                     (9'b011100000),
        .B2M_TXRATESEL0                 (B2M_TXRATESEL0),
        .TXRATESEL1                     (9'b011100000),
        .B2M_TXRATESEL1                 (B2M_TXRATESEL1),
        .TXRATESEL2                     (9'b011100000),
        .B2M_TXRATESEL2                 (B2M_TXRATESEL2),
        .TXRATESEL3                     (9'b011100000),
        .B2M_TXRATESEL3                 (B2M_TXRATESEL3),
        .TXRATESEL4                     (9'b011100000),
        .B2M_TXRATESEL4                 (B2M_TXRATESEL4),
        .TXRATESEL5                     (9'b011100000),
        .B2M_TXRATESEL5                 (B2M_TXRATESEL5),
        .TXRATESEL6                     (9'b011100000),
        .B2M_TXRATESEL6                 (B2M_TXRATESEL6),
        .TXRATESEL7                     (9'b011100000),
        .B2M_TXRATESEL7                 (B2M_TXRATESEL7),
        //---------------------------- PMA Enable Ports ----------------------------
        .RXEN0                          (rxen0_in),
        .B2M_RXEN0                      (B2M_RXEN0),
        .RXEN1                          (rxen1_in),
        .B2M_RXEN1                      (B2M_RXEN1),
        .RXEN2                          (rxen2_in),
        .B2M_RXEN2                      (B2M_RXEN2),
        .RXEN3                          (rxen3_in),
        .B2M_RXEN3                      (B2M_RXEN3),
        .RXEN4                          (1'b0),
        .B2M_RXEN4                      (B2M_RXEN4),
        .RXEN5                          (1'b0),
        .B2M_RXEN5                      (B2M_RXEN5),
        .RXEN6                          (1'b0),
        .B2M_RXEN6                      (B2M_RXEN6),
        .RXEN7                          (1'b0),
        .B2M_RXEN7                      (B2M_RXEN7),
        .TXEN0                          (txen0_in),
        .B2M_TXEN0                      (B2M_TXEN0),
        .TXEN1                          (txen1_in),
        .B2M_TXEN1                      (B2M_TXEN1),
        .TXEN2                          (txen2_in),
        .B2M_TXEN2                      (B2M_TXEN2),
        .TXEN3                          (txen3_in),
        .B2M_TXEN3                      (B2M_TXEN3),
        .TXEN4                          (1'b0),
        .B2M_TXEN4                      (B2M_TXEN4),
        .TXEN5                          (1'b0),
        .B2M_TXEN5                      (B2M_TXEN5),
        .TXEN6                          (1'b0),
        .B2M_TXEN6                      (B2M_TXEN6),
        .TXEN7                          (1'b0),
        .B2M_TXEN7                      (B2M_TXEN7),
        //------------------------------- PRBS Ports -------------------------------
        .RXPRBSEN0                      (tied_to_ground_i),
        .B2M_RXPRBSEN0                  (B2M_RXPRBSEN0),
        .RXPRBSEN1                      (tied_to_ground_i),
        .B2M_RXPRBSEN1                  (B2M_RXPRBSEN1),
        .RXPRBSEN2                      (tied_to_ground_i),
        .B2M_RXPRBSEN2                  (B2M_RXPRBSEN2),
        .RXPRBSEN3                      (tied_to_ground_i),
        .B2M_RXPRBSEN3                  (B2M_RXPRBSEN3),
        .RXPRBSEN4                      (tied_to_ground_i),
        .B2M_RXPRBSEN4                  (B2M_RXPRBSEN4),
        .RXPRBSEN5                      (tied_to_ground_i),
        .B2M_RXPRBSEN5                  (B2M_RXPRBSEN5),
        .RXPRBSEN6                      (tied_to_ground_i),
        .B2M_RXPRBSEN6                  (B2M_RXPRBSEN6),
        .RXPRBSEN7                      (tied_to_ground_i),
        .B2M_RXPRBSEN7                  (B2M_RXPRBSEN7),
        .RXPRBSPASS0                    (),
        .M2B_RXPRBSPASS0                (M2B_RXPRBSPASS0),
        .RXPRBSPASS1                    (),
        .M2B_RXPRBSPASS1                (M2B_RXPRBSPASS1),
        .RXPRBSPASS2                    (),
        .M2B_RXPRBSPASS2                (M2B_RXPRBSPASS2),
        .RXPRBSPASS3                    (),
        .M2B_RXPRBSPASS3                (M2B_RXPRBSPASS3),
        .RXPRBSPASS4                    (),
        .M2B_RXPRBSPASS4                (M2B_RXPRBSPASS4),
        .RXPRBSPASS5                    (),
        .M2B_RXPRBSPASS5                (M2B_RXPRBSPASS5),
        .RXPRBSPASS6                    (),
        .M2B_RXPRBSPASS6                (M2B_RXPRBSPASS6),
        .RXPRBSPASS7                    (),
        .M2B_RXPRBSPASS7                (M2B_RXPRBSPASS7),
        .RXPRBSSEL0                     (tied_to_ground_vec_i[2:0]),
        .B2M_RXPRBSSEL0                 (B2M_RXPRBSSEL0),
        .RXPRBSSEL1                     (tied_to_ground_vec_i[2:0]),
        .B2M_RXPRBSSEL1                 (B2M_RXPRBSSEL1),
        .RXPRBSSEL2                     (tied_to_ground_vec_i[2:0]),
        .B2M_RXPRBSSEL2                 (B2M_RXPRBSSEL2),
        .RXPRBSSEL3                     (tied_to_ground_vec_i[2:0]),
        .B2M_RXPRBSSEL3                 (B2M_RXPRBSSEL3),
        .RXPRBSSEL4                     (tied_to_ground_vec_i[2:0]),
        .B2M_RXPRBSSEL4                 (B2M_RXPRBSSEL4),
        .RXPRBSSEL5                     (tied_to_ground_vec_i[2:0]),
        .B2M_RXPRBSSEL5                 (B2M_RXPRBSSEL5),
        .RXPRBSSEL6                     (tied_to_ground_vec_i[2:0]),
        .B2M_RXPRBSSEL6                 (B2M_RXPRBSSEL6),
        .RXPRBSSEL7                     (tied_to_ground_vec_i[2:0]),
        .B2M_RXPRBSSEL7                 (B2M_RXPRBSSEL7),
        .TXPRBSEN0                      (tied_to_ground_i),
        .B2M_TXPRBSEN0                  (B2M_TXPRBSEN0),
        .TXPRBSEN1                      (tied_to_ground_i),
        .B2M_TXPRBSEN1                  (B2M_TXPRBSEN1),
        .TXPRBSEN2                      (tied_to_ground_i),
        .B2M_TXPRBSEN2                  (B2M_TXPRBSEN2),
        .TXPRBSEN3                      (tied_to_ground_i),
        .B2M_TXPRBSEN3                  (B2M_TXPRBSEN3),
        .TXPRBSEN4                      (tied_to_ground_i),
        .B2M_TXPRBSEN4                  (B2M_TXPRBSEN4),
        .TXPRBSEN5                      (tied_to_ground_i),
        .B2M_TXPRBSEN5                  (B2M_TXPRBSEN5),
        .TXPRBSEN6                      (tied_to_ground_i),
        .B2M_TXPRBSEN6                  (B2M_TXPRBSEN6),
        .TXPRBSEN7                      (tied_to_ground_i),
        .B2M_TXPRBSEN7                  (B2M_TXPRBSEN7),
        .TXPRBSSEL0                     (tied_to_ground_vec_i[2:0]),
        .B2M_TXPRBSSEL0                 (B2M_TXPRBSSEL0),
        .TXPRBSSEL1                     (tied_to_ground_vec_i[2:0]),
        .B2M_TXPRBSSEL1                 (B2M_TXPRBSSEL1),
        .TXPRBSSEL2                     (tied_to_ground_vec_i[2:0]),
        .B2M_TXPRBSSEL2                 (B2M_TXPRBSSEL2),
        .TXPRBSSEL3                     (tied_to_ground_vec_i[2:0]),
        .B2M_TXPRBSSEL3                 (B2M_TXPRBSSEL3),
        .TXPRBSSEL4                     (tied_to_ground_vec_i[2:0]),
        .B2M_TXPRBSSEL4                 (B2M_TXPRBSSEL4),
        .TXPRBSSEL5                     (tied_to_ground_vec_i[2:0]),
        .B2M_TXPRBSSEL5                 (B2M_TXPRBSSEL5),
        .TXPRBSSEL6                     (tied_to_ground_vec_i[2:0]),
        .B2M_TXPRBSSEL6                 (B2M_TXPRBSSEL6),
        .TXPRBSSEL7                     (tied_to_ground_vec_i[2:0]),
        .B2M_TXPRBSSEL7                 (B2M_TXPRBSSEL7),
        //------------------------ Polarity Inversion Ports ------------------------
        .RXPOLARITY0                    (oct0_gtzrxpolarity_in[0]),
        .B2M_RXPOLARITY0                (B2M_RXPOLARITY0),
        .RXPOLARITY1                    (oct0_gtzrxpolarity_in[1]),
        .B2M_RXPOLARITY1                (B2M_RXPOLARITY1),
        .RXPOLARITY2                    (oct0_gtzrxpolarity_in[2]),
        .B2M_RXPOLARITY2                (B2M_RXPOLARITY2),
        .RXPOLARITY3                    (oct0_gtzrxpolarity_in[3]),
        .B2M_RXPOLARITY3                (B2M_RXPOLARITY3),
        .RXPOLARITY4                    (tied_to_ground_i),
        .B2M_RXPOLARITY4                (B2M_RXPOLARITY4),
        .RXPOLARITY5                    (tied_to_ground_i),
        .B2M_RXPOLARITY5                (B2M_RXPOLARITY5),
        .RXPOLARITY6                    (tied_to_ground_i),
        .B2M_RXPOLARITY6                (B2M_RXPOLARITY6),
        .RXPOLARITY7                    (tied_to_ground_i),
        .B2M_RXPOLARITY7                (B2M_RXPOLARITY7),
        .TXPOLARITY0                    (oct0_gtztxpolarity_in[0]),
        .B2M_TXPOLARITY0                (B2M_TXPOLARITY0),
        .TXPOLARITY1                    (oct0_gtztxpolarity_in[1]),
        .B2M_TXPOLARITY1                (B2M_TXPOLARITY1),
        .TXPOLARITY2                    (oct0_gtztxpolarity_in[2]),
        .B2M_TXPOLARITY2                (B2M_TXPOLARITY2),
        .TXPOLARITY3                    (oct0_gtztxpolarity_in[3]),
        .B2M_TXPOLARITY3                (B2M_TXPOLARITY3),
        .TXPOLARITY4                    (tied_to_ground_i),
        .B2M_TXPOLARITY4                (B2M_TXPOLARITY4),
        .TXPOLARITY5                    (tied_to_ground_i),
        .B2M_TXPOLARITY5                (B2M_TXPOLARITY5),
        .TXPOLARITY6                    (tied_to_ground_i),
        .B2M_TXPOLARITY6                (B2M_TXPOLARITY6),
        .TXPOLARITY7                    (tied_to_ground_i),
        .B2M_TXPOLARITY7                (B2M_TXPOLARITY7),
        //--------------------------- RX SIGNAL OK Ports ---------------------------
        .RXSIGNALOK0                    (),
        .M2B_RXSIGNALOK0                (M2B_RXSIGNALOK0),
        .RXSIGNALOK1                    (),
        .M2B_RXSIGNALOK1                (M2B_RXSIGNALOK1),
        .RXSIGNALOK2                    (),
        .M2B_RXSIGNALOK2                (M2B_RXSIGNALOK2),
        .RXSIGNALOK3                    (),
        .M2B_RXSIGNALOK3                (M2B_RXSIGNALOK3),
        .RXSIGNALOK4                    (),
        .M2B_RXSIGNALOK4                (M2B_RXSIGNALOK4),
        .RXSIGNALOK5                    (),
        .M2B_RXSIGNALOK5                (M2B_RXSIGNALOK5),
        .RXSIGNALOK6                    (),
        .M2B_RXSIGNALOK6                (M2B_RXSIGNALOK6),
        .RXSIGNALOK7                    (),
        .M2B_RXSIGNALOK7                (M2B_RXSIGNALOK7),
        //----------------------------- Reserved Ports -----------------------------
        .RSVDOUT                        (),
        .M2B_RSVDOUT                    (M2B_RSVDOUT),
        .FIBRSVDIN1                     (tied_to_ground_vec_i[2:0]),
        .B2M_FIBRSVDIN1                 (B2M_FIBRSVDIN1),
        .FIBRSVDIN2                     (tied_to_ground_vec_i[2:0]),
        .B2M_FIBRSVDIN2                 (B2M_FIBRSVDIN2),
        .FIBRSVDIN3                     (tied_to_ground_vec_i[2:0]),
        .B2M_FIBRSVDIN3                 (B2M_FIBRSVDIN3),
        .FIBRSVDIN4                     (tied_to_ground_vec_i[2:0]),
        .B2M_FIBRSVDIN4                 (B2M_FIBRSVDIN4),
        .FIBRSVDIN5                     (tied_to_ground_vec_i[2:0]),
        .B2M_FIBRSVDIN5                 (B2M_FIBRSVDIN5),
        .FIBRSVDIN6                     (tied_to_ground_vec_i[2:0]),
        .B2M_FIBRSVDIN6                 (B2M_FIBRSVDIN6),
        .FIBRSVDIN7                     (tied_to_ground_vec_i[2:0]),
        .B2M_FIBRSVDIN7                 (B2M_FIBRSVDIN7),
        .FIBRSVDOUT0                    (),
        .M2B_FIBRSVDOUT0                (M2B_FIBRSVDOUT0),
        .FIBRSVDOUT1                    (),
        .M2B_FIBRSVDOUT1                (M2B_FIBRSVDOUT1),
        .FIBRSVDOUT2                    (),
        .M2B_FIBRSVDOUT2                (M2B_FIBRSVDOUT2),
        .FIBRSVDOUT3                    (),
        .M2B_FIBRSVDOUT3                (M2B_FIBRSVDOUT3),
        .FIBRSVDOUT4                    (),
        .M2B_FIBRSVDOUT4                (M2B_FIBRSVDOUT4),
        .FIBRSVDOUT5                    (),
        .M2B_FIBRSVDOUT5                (M2B_FIBRSVDOUT5),
        .FIBRSVDOUT6                    (),
        .M2B_FIBRSVDOUT6                (M2B_FIBRSVDOUT6),
        .FIBRSVDOUT7                    (),
        .M2B_FIBRSVDOUT7                (M2B_FIBRSVDOUT7),
        //-------------------------- Rx Fabric Interface ---------------------------
        .RXDATA0                        (rxdata0_out),
        .M2B_RXDATA0                    (M2B_RXDATA0),
        .RXDATA1                        (rxdata1_out),
        .M2B_RXDATA1                    (M2B_RXDATA1),
        .RXDATA2                        (rxdata2_out),
        .M2B_RXDATA2                    (M2B_RXDATA2),
        .RXDATA3                        (rxdata3_out),
        .M2B_RXDATA3                    (M2B_RXDATA3),
        .RXDATA4                        (),
        .M2B_RXDATA4                    (M2B_RXDATA4),
        .RXDATA5                        (),
        .M2B_RXDATA5                    (M2B_RXDATA5),
        .RXDATA6                        (),
        .M2B_RXDATA6                    (M2B_RXDATA6),
        .RXDATA7                        (),
        .M2B_RXDATA7                    (M2B_RXDATA7),
        .RXDATAVALID0                   (rxdatavalid0_out),
        .M2B_RXDATAVALID0               (M2B_RXDATAVALID0),
        .RXDATAVALID1                   (rxdatavalid1_out),
        .M2B_RXDATAVALID1               (M2B_RXDATAVALID1),
        .RXDATAVALID2                   (rxdatavalid2_out),
        .M2B_RXDATAVALID2               (M2B_RXDATAVALID2),
        .RXDATAVALID3                   (rxdatavalid3_out),
        .M2B_RXDATAVALID3               (M2B_RXDATAVALID3),
        .RXDATAVALID4                   (),
        .M2B_RXDATAVALID4               (M2B_RXDATAVALID4),
        .RXDATAVALID5                   (),
        .M2B_RXDATAVALID5               (M2B_RXDATAVALID5),
        .RXDATAVALID6                   (),
        .M2B_RXDATAVALID6               (M2B_RXDATAVALID6),
        .RXDATAVALID7                   (),
        .M2B_RXDATAVALID7               (M2B_RXDATAVALID7),
        .RXDATAWIDTH0                   (2'b11),
        .B2M_RXDATAWIDTH0               (B2M_RXDATAWIDTH0),
        .RXDATAWIDTH1                   (2'b11),
        .B2M_RXDATAWIDTH1               (B2M_RXDATAWIDTH1),
        .RXDATAWIDTH2                   (2'b11),
        .B2M_RXDATAWIDTH2               (B2M_RXDATAWIDTH2),
        .RXDATAWIDTH3                   (2'b11),
        .B2M_RXDATAWIDTH3               (B2M_RXDATAWIDTH3),
        .RXDATAWIDTH4                   (2'b11),
        .B2M_RXDATAWIDTH4               (B2M_RXDATAWIDTH4),
        .RXDATAWIDTH5                   (2'b11),
        .B2M_RXDATAWIDTH5               (B2M_RXDATAWIDTH5),
        .RXDATAWIDTH6                   (2'b11),
        .B2M_RXDATAWIDTH6               (B2M_RXDATAWIDTH6),
        .RXDATAWIDTH7                   (2'b11),
        .B2M_RXDATAWIDTH7               (B2M_RXDATAWIDTH7),
        .RXHEADER0                      (rxheader0_out),
        .M2B_RXHEADER0                  (M2B_RXHEADER0),
        .RXHEADER1                      (rxheader1_out),
        .M2B_RXHEADER1                  (M2B_RXHEADER1),
        .RXHEADER2                      (rxheader2_out),
        .M2B_RXHEADER2                  (M2B_RXHEADER2),
        .RXHEADER3                      (rxheader3_out),
        .M2B_RXHEADER3                  (M2B_RXHEADER3),
        .RXHEADER4                      (),
        .M2B_RXHEADER4                  (M2B_RXHEADER4),
        .RXHEADER5                      (),
        .M2B_RXHEADER5                  (M2B_RXHEADER5),
        .RXHEADER6                      (),
        .M2B_RXHEADER6                  (M2B_RXHEADER6),
        .RXHEADER7                      (),
        .M2B_RXHEADER7                  (M2B_RXHEADER7),
        .RXHEADERVALID0                 (rxheadervalid0_out),
        .M2B_RXHEADERVALID0             (M2B_RXHEADERVALID0),
        .RXHEADERVALID1                 (rxheadervalid1_out),
        .M2B_RXHEADERVALID1             (M2B_RXHEADERVALID1),
        .RXHEADERVALID2                 (rxheadervalid2_out),
        .M2B_RXHEADERVALID2             (M2B_RXHEADERVALID2),
        .RXHEADERVALID3                 (rxheadervalid3_out),
        .M2B_RXHEADERVALID3             (M2B_RXHEADERVALID3),
        .RXHEADERVALID4                 (),
        .M2B_RXHEADERVALID4             (M2B_RXHEADERVALID4),
        .RXHEADERVALID5                 (),
        .M2B_RXHEADERVALID5             (M2B_RXHEADERVALID5),
        .RXHEADERVALID6                 (),
        .M2B_RXHEADERVALID6             (M2B_RXHEADERVALID6),
        .RXHEADERVALID7                 (),
        .M2B_RXHEADERVALID7             (M2B_RXHEADERVALID7),
        //-------------------------- Rx Reset Controller ---------------------------
        .GTZRXRESET0                    (gtzrxreset0_in),
        .B2M_GTZRXRESET0                (B2M_GTZRXRESET0),
        .GTZRXRESET1                    (gtzrxreset1_in),
        .B2M_GTZRXRESET1                (B2M_GTZRXRESET1),
        .GTZRXRESET2                    (gtzrxreset2_in),
        .B2M_GTZRXRESET2                (B2M_GTZRXRESET2),
        .GTZRXRESET3                    (gtzrxreset3_in),
        .B2M_GTZRXRESET3                (B2M_GTZRXRESET3),
        .GTZRXRESET4                    (tied_to_ground_i),
        .B2M_GTZRXRESET4                (B2M_GTZRXRESET4),
        .GTZRXRESET5                    (tied_to_ground_i),
        .B2M_GTZRXRESET5                (B2M_GTZRXRESET5),
        .GTZRXRESET6                    (tied_to_ground_i),
        .B2M_GTZRXRESET6                (B2M_GTZRXRESET6),
        .GTZRXRESET7                    (tied_to_ground_i),
        .B2M_GTZRXRESET7                (B2M_GTZRXRESET7),
        .RXRDY0                         (rxrdy0_out),
        .M2B_RXRDY0                     (M2B_RXRDY0),
        .RXRDY1                         (rxrdy1_out),
        .M2B_RXRDY1                     (M2B_RXRDY1),
        .RXRDY2                         (rxrdy2_out),
        .M2B_RXRDY2                     (M2B_RXRDY2),
        .RXRDY3                         (rxrdy3_out),
        .M2B_RXRDY3                     (M2B_RXRDY3),
        .RXRDY4                         (),
        .M2B_RXRDY4                     (M2B_RXRDY4),
        .RXRDY5                         (),
        .M2B_RXRDY5                     (M2B_RXRDY5),
        .RXRDY6                         (),
        .M2B_RXRDY6                     (M2B_RXRDY6),
        .RXRDY7                         (),
        .M2B_RXRDY7                     (M2B_RXRDY7),
        .RXRESETDONE0                   (rxresetdone0_out),
        .M2B_RXRESETDONE0               (M2B_RXRESETDONE0),
        .RXRESETDONE1                   (rxresetdone1_out),
        .M2B_RXRESETDONE1               (M2B_RXRESETDONE1),
        .RXRESETDONE2                   (rxresetdone2_out),
        .M2B_RXRESETDONE2               (M2B_RXRESETDONE2),
        .RXRESETDONE3                   (rxresetdone3_out),
        .M2B_RXRESETDONE3               (M2B_RXRESETDONE3),
        .RXRESETDONE4                   (),
        .M2B_RXRESETDONE4               (M2B_RXRESETDONE4),
        .RXRESETDONE5                   (),
        .M2B_RXRESETDONE5               (M2B_RXRESETDONE5),
        .RXRESETDONE6                   (),
        .M2B_RXRESETDONE6               (M2B_RXRESETDONE6),
        .RXRESETDONE7                   (),
        .M2B_RXRESETDONE7               (M2B_RXRESETDONE7),
        //------------------------------- SBUS Ports -------------------------------
        .SBUSCLKSEL                     (1'b0),
        .B2M_SBUSCLKSEL                 (B2M_SBUSCLKSEL),
        .SBUSRESETB                     (1'b1),
        .B2M_SBUSRESETB                 (B2M_SBUSRESETB),
        .SPARESBUSCOMMAND               (tied_to_ground_vec_i[7:0]),
        .B2M_SPARESBUSCOMMAND           (B2M_SPARESBUSCOMMAND),
        .SPARESBUSDATA                  (tied_to_ground_vec_i[31:0]),
        .B2M_SPARESBUSDATA              (B2M_SPARESBUSDATA),
        .SPARESBUSDATAADDR              (tied_to_ground_vec_i[7:0]),
        .B2M_SPARESBUSDATAADDR          (B2M_SPARESBUSDATAADDR),
        .SPARESBUSDATAOUT               (),
        .M2B_SPARESBUSDATAOUT           (M2B_SPARESBUSDATAOUT),
        .SPARESBUSDONE                  (),
        .M2B_SPARESBUSDONE              (M2B_SPARESBUSDONE),
        .SPARESBUSEXECUTEB              (1'b1),
        .B2M_SPARESBUSEXECUTEB          (B2M_SPARESBUSEXECUTEB),
        .SPARESBUSRCVDATAVALID          (),
        .M2B_SPARESBUSRCVDATAVALID      (M2B_SPARESBUSRCVDATAVALID),
        .SPARESBUSRCVDATAVALIDSEL       (tied_to_ground_i),
        .B2M_SPARESBUSRCVDATAVALIDSEL   (B2M_SPARESBUSRCVDATAVALIDSEL),
        .SPARESBUSRECADDR               (tied_to_ground_vec_i[7:0]),
        .B2M_SPARESBUSRECADDR           (B2M_SPARESBUSRECADDR),
        .SPARESBUSRESULTCODE            (),
        .M2B_SPARESBUSRESULTCODE        (M2B_SPARESBUSRESULTCODE),
        //-------------------------- Tx Fabric Interface ---------------------------
        .TXDATA0                        (txdata0_in),
        .B2M_TXDATA0                    (B2M_TXDATA0),
        .TXDATA1                        (txdata1_in),
        .B2M_TXDATA1                    (B2M_TXDATA1),
        .TXDATA2                        (txdata2_in),
        .B2M_TXDATA2                    (B2M_TXDATA2),
        .TXDATA3                        (txdata3_in),
        .B2M_TXDATA3                    (B2M_TXDATA3),
        .TXDATA4                        (tied_to_ground_vec_i[159:0]),
        .B2M_TXDATA4                    (B2M_TXDATA4),
        .TXDATA5                        (tied_to_ground_vec_i[159:0]),
        .B2M_TXDATA5                    (B2M_TXDATA5),
        .TXDATA6                        (tied_to_ground_vec_i[159:0]),
        .B2M_TXDATA6                    (B2M_TXDATA6),
        .TXDATA7                        (tied_to_ground_vec_i[159:0]),
        .B2M_TXDATA7                    (B2M_TXDATA7),
        .TXDATAWIDTH0                   (2'b11),
        .B2M_TXDATAWIDTH0               (B2M_TXDATAWIDTH0),
        .TXDATAWIDTH1                   (2'b11),
        .B2M_TXDATAWIDTH1               (B2M_TXDATAWIDTH1),
        .TXDATAWIDTH2                   (2'b11),
        .B2M_TXDATAWIDTH2               (B2M_TXDATAWIDTH2),
        .TXDATAWIDTH3                   (2'b11),
        .B2M_TXDATAWIDTH3               (B2M_TXDATAWIDTH3),
        .TXDATAWIDTH4                   (2'b11),
        .B2M_TXDATAWIDTH4               (B2M_TXDATAWIDTH4),
        .TXDATAWIDTH5                   (2'b11),
        .B2M_TXDATAWIDTH5               (B2M_TXDATAWIDTH5),
        .TXDATAWIDTH6                   (2'b11),
        .B2M_TXDATAWIDTH6               (B2M_TXDATAWIDTH6),
        .TXDATAWIDTH7                   (2'b11),
        .B2M_TXDATAWIDTH7               (B2M_TXDATAWIDTH7),
        .TXHEADER0                      (txheader0_in),
        .B2M_TXHEADER0                  (B2M_TXHEADER0),
        .TXHEADER1                      (txheader1_in),
        .B2M_TXHEADER1                  (B2M_TXHEADER1),
        .TXHEADER2                      (txheader2_in),
        .B2M_TXHEADER2                  (B2M_TXHEADER2),
        .TXHEADER3                      (txheader3_in),
        .B2M_TXHEADER3                  (B2M_TXHEADER3),
        .TXHEADER4                      (tied_to_ground_vec_i[9:0]),
        .B2M_TXHEADER4                  (B2M_TXHEADER4),
        .TXHEADER5                      (tied_to_ground_vec_i[9:0]),
        .B2M_TXHEADER5                  (B2M_TXHEADER5),
        .TXHEADER6                      (tied_to_ground_vec_i[9:0]),
        .B2M_TXHEADER6                  (B2M_TXHEADER6),
        .TXHEADER7                      (tied_to_ground_vec_i[9:0]),
        .B2M_TXHEADER7                  (B2M_TXHEADER7),
        //-------------------------- Tx Reset Controller ---------------------------
        .GTZTXRESET0                    (gtztxreset0_in),
        .B2M_GTZTXRESET0                (B2M_GTZTXRESET0),
        .GTZTXRESET1                    (gtztxreset1_in),
        .B2M_GTZTXRESET1                (B2M_GTZTXRESET1),
        .GTZTXRESET2                    (gtztxreset2_in),
        .B2M_GTZTXRESET2                (B2M_GTZTXRESET2),
        .GTZTXRESET3                    (gtztxreset3_in),
        .B2M_GTZTXRESET3                (B2M_GTZTXRESET3),
        .GTZTXRESET4                    (tied_to_ground_i),
        .B2M_GTZTXRESET4                (B2M_GTZTXRESET4),
        .GTZTXRESET5                    (tied_to_ground_i),
        .B2M_GTZTXRESET5                (B2M_GTZTXRESET5),
        .GTZTXRESET6                    (tied_to_ground_i),
        .B2M_GTZTXRESET6                (B2M_GTZTXRESET6),
        .GTZTXRESET7                    (tied_to_ground_i),
        .B2M_GTZTXRESET7                (B2M_GTZTXRESET7),
        .TXRDY0                         (txrdy0_out),
        .M2B_TXRDY0                     (M2B_TXRDY0),
        .TXRDY1                         (txrdy1_out),
        .M2B_TXRDY1                     (M2B_TXRDY1),
        .TXRDY2                         (txrdy2_out),
        .M2B_TXRDY2                     (M2B_TXRDY2),
        .TXRDY3                         (txrdy3_out),
        .M2B_TXRDY3                     (M2B_TXRDY3),
        .TXRDY4                         (),
        .M2B_TXRDY4                     (M2B_TXRDY4),
        .TXRDY5                         (),
        .M2B_TXRDY5                     (M2B_TXRDY5),
        .TXRDY6                         (),
        .M2B_TXRDY6                     (M2B_TXRDY6),
        .TXRDY7                         (),
        .M2B_TXRDY7                     (M2B_TXRDY7),
        .TXRESETDONE0                   (txresetdone0_out),
        .M2B_TXRESETDONE0               (M2B_TXRESETDONE0),
        .TXRESETDONE1                   (txresetdone1_out),
        .M2B_TXRESETDONE1               (M2B_TXRESETDONE1),
        .TXRESETDONE2                   (txresetdone2_out),
        .M2B_TXRESETDONE2               (M2B_TXRESETDONE2),
        .TXRESETDONE3                   (txresetdone3_out),
        .M2B_TXRESETDONE3               (M2B_TXRESETDONE3),
        .TXRESETDONE4                   (),
        .M2B_TXRESETDONE4               (M2B_TXRESETDONE4),
        .TXRESETDONE5                   (),
        .M2B_TXRESETDONE5               (M2B_TXRESETDONE5),
        .TXRESETDONE6                   (),
        .M2B_TXRESETDONE6               (M2B_TXRESETDONE6),
        .TXRESETDONE7                   (),
        .M2B_TXRESETDONE7               (M2B_TXRESETDONE7),
        //---------------------------- Tx driver Ports -----------------------------
        .TXATTNCTRL0                    (tied_to_ground_vec_i[7:0]),
        .B2M_TXATTNCTRL0                (B2M_TXATTNCTRL0),
        .TXATTNCTRL1                    (tied_to_ground_vec_i[7:0]),
        .B2M_TXATTNCTRL1                (B2M_TXATTNCTRL1),
        .TXATTNCTRL2                    (tied_to_ground_vec_i[7:0]),
        .B2M_TXATTNCTRL2                (B2M_TXATTNCTRL2),
        .TXATTNCTRL3                    (tied_to_ground_vec_i[7:0]),
        .B2M_TXATTNCTRL3                (B2M_TXATTNCTRL3),
        .TXATTNCTRL4                    (tied_to_ground_vec_i[7:0]),
        .B2M_TXATTNCTRL4                (B2M_TXATTNCTRL4),
        .TXATTNCTRL5                    (tied_to_ground_vec_i[7:0]),
        .B2M_TXATTNCTRL5                (B2M_TXATTNCTRL5),
        .TXATTNCTRL6                    (tied_to_ground_vec_i[7:0]),
        .B2M_TXATTNCTRL6                (B2M_TXATTNCTRL6),
        .TXATTNCTRL7                    (tied_to_ground_vec_i[7:0]),
        .B2M_TXATTNCTRL7                (B2M_TXATTNCTRL7),
        .TXEQPOSTCTRL0                  (tied_to_ground_vec_i[7:0]),
        .B2M_TXEQPOSTCTRL0              (B2M_TXEQPOSTCTRL0),
        .TXEQPOSTCTRL1                  (tied_to_ground_vec_i[7:0]),
        .B2M_TXEQPOSTCTRL1              (B2M_TXEQPOSTCTRL1),
        .TXEQPOSTCTRL2                  (tied_to_ground_vec_i[7:0]),
        .B2M_TXEQPOSTCTRL2              (B2M_TXEQPOSTCTRL2),
        .TXEQPOSTCTRL3                  (tied_to_ground_vec_i[7:0]),
        .B2M_TXEQPOSTCTRL3              (B2M_TXEQPOSTCTRL3),
        .TXEQPOSTCTRL4                  (tied_to_ground_vec_i[7:0]),
        .B2M_TXEQPOSTCTRL4              (B2M_TXEQPOSTCTRL4),
        .TXEQPOSTCTRL5                  (tied_to_ground_vec_i[7:0]),
        .B2M_TXEQPOSTCTRL5              (B2M_TXEQPOSTCTRL5),
        .TXEQPOSTCTRL6                  (tied_to_ground_vec_i[7:0]),
        .B2M_TXEQPOSTCTRL6              (B2M_TXEQPOSTCTRL6),
        .TXEQPOSTCTRL7                  (tied_to_ground_vec_i[7:0]),
        .B2M_TXEQPOSTCTRL7              (B2M_TXEQPOSTCTRL7),
        .TXEQPRECTRL0                   (tied_to_ground_vec_i[3:0]),
        .B2M_TXEQPRECTRL0               (B2M_TXEQPRECTRL0),
        .TXEQPRECTRL1                   (tied_to_ground_vec_i[3:0]),
        .B2M_TXEQPRECTRL1               (B2M_TXEQPRECTRL1),
        .TXEQPRECTRL2                   (tied_to_ground_vec_i[3:0]),
        .B2M_TXEQPRECTRL2               (B2M_TXEQPRECTRL2),
        .TXEQPRECTRL3                   (tied_to_ground_vec_i[3:0]),
        .B2M_TXEQPRECTRL3               (B2M_TXEQPRECTRL3),
        .TXEQPRECTRL4                   (tied_to_ground_vec_i[3:0]),
        .B2M_TXEQPRECTRL4               (B2M_TXEQPRECTRL4),
        .TXEQPRECTRL5                   (tied_to_ground_vec_i[3:0]),
        .B2M_TXEQPRECTRL5               (B2M_TXEQPRECTRL5),
        .TXEQPRECTRL6                   (tied_to_ground_vec_i[3:0]),
        .B2M_TXEQPRECTRL6               (B2M_TXEQPRECTRL6),
        .TXEQPRECTRL7                   (tied_to_ground_vec_i[3:0]),
        .B2M_TXEQPRECTRL7               (B2M_TXEQPRECTRL7),
        .TXOUTPUTEN0                    (1'b1),
        .B2M_TXOUTPUTEN0                (B2M_TXOUTPUTEN0),
        .TXOUTPUTEN1                    (1'b1),
        .B2M_TXOUTPUTEN1                (B2M_TXOUTPUTEN1),
        .TXOUTPUTEN2                    (1'b1),
        .B2M_TXOUTPUTEN2                (B2M_TXOUTPUTEN2),
        .TXOUTPUTEN3                    (1'b1),
        .B2M_TXOUTPUTEN3                (B2M_TXOUTPUTEN3),
        .TXOUTPUTEN4                    (1'b1),
        .B2M_TXOUTPUTEN4                (B2M_TXOUTPUTEN4),
        .TXOUTPUTEN5                    (1'b1),
        .B2M_TXOUTPUTEN5                (B2M_TXOUTPUTEN5),
        .TXOUTPUTEN6                    (1'b1),
        .B2M_TXOUTPUTEN6                (B2M_TXOUTPUTEN6),
        .TXOUTPUTEN7                    (1'b1),
        .B2M_TXOUTPUTEN7                (B2M_TXOUTPUTEN7),
        .TXSLEWCTRL0                    (tied_to_ground_vec_i[1:0]),
        .B2M_TXSLEWCTRL0                (B2M_TXSLEWCTRL0),
        .TXSLEWCTRL1                    (tied_to_ground_vec_i[1:0]),
        .B2M_TXSLEWCTRL1                (B2M_TXSLEWCTRL1),
        .TXSLEWCTRL2                    (tied_to_ground_vec_i[1:0]),
        .B2M_TXSLEWCTRL2                (B2M_TXSLEWCTRL2),
        .TXSLEWCTRL3                    (tied_to_ground_vec_i[1:0]),
        .B2M_TXSLEWCTRL3                (B2M_TXSLEWCTRL3),
        .TXSLEWCTRL4                    (tied_to_ground_vec_i[1:0]),
        .B2M_TXSLEWCTRL4                (B2M_TXSLEWCTRL4),
        .TXSLEWCTRL5                    (tied_to_ground_vec_i[1:0]),
        .B2M_TXSLEWCTRL5                (B2M_TXSLEWCTRL5),
        .TXSLEWCTRL6                    (tied_to_ground_vec_i[1:0]),
        .B2M_TXSLEWCTRL6                (B2M_TXSLEWCTRL6),
        .TXSLEWCTRL7                    (tied_to_ground_vec_i[1:0]),
        .B2M_TXSLEWCTRL7                (B2M_TXSLEWCTRL7),
        //--------------------------- Tx override Ports ----------------------------
        .TXOVERRIDEEN0                  (tied_to_ground_i),
        .B2M_TXOVERRIDEEN0              (B2M_TXOVERRIDEEN0),
        .TXOVERRIDEEN1                  (tied_to_ground_i),
        .B2M_TXOVERRIDEEN1              (B2M_TXOVERRIDEEN1),
        .TXOVERRIDEEN2                  (tied_to_ground_i),
        .B2M_TXOVERRIDEEN2              (B2M_TXOVERRIDEEN2),
        .TXOVERRIDEEN3                  (tied_to_ground_i),
        .B2M_TXOVERRIDEEN3              (B2M_TXOVERRIDEEN3),
        .TXOVERRIDEEN4                  (tied_to_ground_i),
        .B2M_TXOVERRIDEEN4              (B2M_TXOVERRIDEEN4),
        .TXOVERRIDEEN5                  (tied_to_ground_i),
        .B2M_TXOVERRIDEEN5              (B2M_TXOVERRIDEEN5),
        .TXOVERRIDEEN6                  (tied_to_ground_i),
        .B2M_TXOVERRIDEEN6              (B2M_TXOVERRIDEEN6),
        .TXOVERRIDEEN7                  (tied_to_ground_i),
        .B2M_TXOVERRIDEEN7              (B2M_TXOVERRIDEEN7),
        .TXOVERRIDEIN0                  (tied_to_ground_i),
        .B2M_TXOVERRIDEIN0              (B2M_TXOVERRIDEIN0),
        .TXOVERRIDEIN1                  (tied_to_ground_i),
        .B2M_TXOVERRIDEIN1              (B2M_TXOVERRIDEIN1),
        .TXOVERRIDEIN2                  (tied_to_ground_i),
        .B2M_TXOVERRIDEIN2              (B2M_TXOVERRIDEIN2),
        .TXOVERRIDEIN3                  (tied_to_ground_i),
        .B2M_TXOVERRIDEIN3              (B2M_TXOVERRIDEIN3),
        .TXOVERRIDEIN4                  (tied_to_ground_i),
        .B2M_TXOVERRIDEIN4              (B2M_TXOVERRIDEIN4),
        .TXOVERRIDEIN5                  (tied_to_ground_i),
        .B2M_TXOVERRIDEIN5              (B2M_TXOVERRIDEIN5),
        .TXOVERRIDEIN6                  (tied_to_ground_i),
        .B2M_TXOVERRIDEIN6              (B2M_TXOVERRIDEIN6),
        .TXOVERRIDEIN7                  (tied_to_ground_i),
        .B2M_TXOVERRIDEIN7              (B2M_TXOVERRIDEIN7),
        //--------------------------- Tx phase cal Ports ---------------------------
        .TXPHASECALEN0                  (tied_to_vcc_i),
        .B2M_TXPHASECALEN0              (B2M_TXPHASECALEN0),
        .TXPHASECALEN1                  (tied_to_vcc_i),
        .B2M_TXPHASECALEN1              (B2M_TXPHASECALEN1),
        .TXPHASECALEN2                  (tied_to_vcc_i),
        .B2M_TXPHASECALEN2              (B2M_TXPHASECALEN2),
        .TXPHASECALEN3                  (tied_to_vcc_i),
        .B2M_TXPHASECALEN3              (B2M_TXPHASECALEN3),
        .TXPHASECALEN4                  (tied_to_vcc_i),
        .B2M_TXPHASECALEN4              (B2M_TXPHASECALEN4),
        .TXPHASECALEN5                  (tied_to_vcc_i),
        .B2M_TXPHASECALEN5              (B2M_TXPHASECALEN5),
        .TXPHASECALEN6                  (tied_to_vcc_i),
        .B2M_TXPHASECALEN6              (B2M_TXPHASECALEN6),
        .TXPHASECALEN7                  (tied_to_vcc_i),
        .B2M_TXPHASECALEN7              (B2M_TXPHASECALEN7),
        .TXPHASESLIP0                   (tied_to_ground_i),
        .B2M_TXPHASESLIP0               (B2M_TXPHASESLIP0),
        .TXPHASESLIP1                   (tied_to_ground_i),
        .B2M_TXPHASESLIP1               (B2M_TXPHASESLIP1),
        .TXPHASESLIP2                   (tied_to_ground_i),
        .B2M_TXPHASESLIP2               (B2M_TXPHASESLIP2),
        .TXPHASESLIP3                   (tied_to_ground_i),
        .B2M_TXPHASESLIP3               (B2M_TXPHASESLIP3),
        .TXPHASESLIP4                   (tied_to_ground_i),
        .B2M_TXPHASESLIP4               (B2M_TXPHASESLIP4),
        .TXPHASESLIP5                   (tied_to_ground_i),
        .B2M_TXPHASESLIP5               (B2M_TXPHASESLIP5),
        .TXPHASESLIP6                   (tied_to_ground_i),
        .B2M_TXPHASESLIP6               (B2M_TXPHASESLIP6),
        .TXPHASESLIP7                   (tied_to_ground_i),
        .B2M_TXPHASESLIP7               (B2M_TXPHASESLIP7),
        //--------------------------- Tx phase out Ports ---------------------------
        .TXPHASEOUT0                    (),
        .M2B_TXPHASEOUT0                (M2B_TXPHASEOUT0),
        .TXPHASEOUT1                    (),
        .M2B_TXPHASEOUT1                (M2B_TXPHASEOUT1),
        .TXPHASEOUT2                    (),
        .M2B_TXPHASEOUT2                (M2B_TXPHASEOUT2),
        .TXPHASEOUT3                    (),
        .M2B_TXPHASEOUT3                (M2B_TXPHASEOUT3),
        .TXPHASEOUT4                    (),
        .M2B_TXPHASEOUT4                (M2B_TXPHASEOUT4),
        .TXPHASEOUT5                    (),
        .M2B_TXPHASEOUT5                (M2B_TXPHASEOUT5),
        .TXPHASEOUT6                    (),
        .M2B_TXPHASEOUT6                (M2B_TXPHASEOUT6),
        .TXPHASEOUT7                    (),
        .M2B_TXPHASEOUT7                (M2B_TXPHASEOUT7),
        //--------------------------- Tx sequence Ports ----------------------------
        .TXSEQUENCE0                    (txsequence0_in),
        .B2M_TXSEQUENCE0                (B2M_TXSEQUENCE0),
        .TXSEQUENCE1                    (txsequence1_in),
        .B2M_TXSEQUENCE1                (B2M_TXSEQUENCE1),
        .TXSEQUENCE2                    (txsequence2_in),
        .B2M_TXSEQUENCE2                (B2M_TXSEQUENCE2),
        .TXSEQUENCE3                    (txsequence3_in),
        .B2M_TXSEQUENCE3                (B2M_TXSEQUENCE3),
        .TXSEQUENCE4                    (tied_to_ground_vec_i[6:0]),
        .B2M_TXSEQUENCE4                (B2M_TXSEQUENCE4),
        .TXSEQUENCE5                    (tied_to_ground_vec_i[6:0]),
        .B2M_TXSEQUENCE5                (B2M_TXSEQUENCE5),
        .TXSEQUENCE6                    (tied_to_ground_vec_i[6:0]),
        .B2M_TXSEQUENCE6                (B2M_TXSEQUENCE6),
        .TXSEQUENCE7                    (tied_to_ground_vec_i[6:0]),
        .B2M_TXSEQUENCE7                (B2M_TXSEQUENCE7),
        //----------------------------- reserved Ports -----------------------------
        .FIBRSVDIN0                     (tied_to_ground_vec_i[2:0]),
        .B2M_FIBRSVDIN0                 (B2M_FIBRSVDIN0)

       
       );
     
endmodule     

