library ieee;
use ieee.std_logic_1164.all;

entity crc32_fast64_tab is

	port (
		DI : in std_logic_vector(63 downto 0);
		DO : out std_logic_vector(31 downto 0)
	);

end entity;

architecture structural of crc32_fast64_tab is

	signal out1 : std_logic_vector(135 downto 0);

	signal out2 : std_logic_vector(146 downto 0);

	signal out3 : std_logic_vector(111 downto 0);

	signal out4 : std_logic_vector(65 downto 0);

	signal out5 : std_logic_vector(33 downto 0);

	signal out6 : std_logic_vector(31 downto 0);

begin

	out1(0) <= DI(11) XOR DI(32);
	out1(1) <= DI(6) XOR DI(16);
	out1(2) <= DI(4) XOR DI(39);
	out1(3) <= DI(9) XOR DI(38);
	out1(4) <= DI(36) XOR DI(54);
	out1(5) <= DI(1) XOR DI(14);
	out1(6) <= DI(19) XOR DI(34);
	out1(7) <= DI(33) XOR DI(58);
	out1(8) <= DI(30) XOR DI(55);
	out1(9) <= DI(20) XOR DI(40);
	out1(10) <= DI(3) XOR DI(27);
	out1(11) <= DI(10) XOR DI(17);
	out1(12) <= DI(35) XOR DI(52);
	out1(13) <= DI(48);
	out1(14) <= DI(10) XOR DI(56);
	out1(15) <= DI(7) XOR DI(12);
	out1(16) <= DI(0) XOR DI(35);
	out1(17) <= DI(2) XOR DI(59);
	out1(18) <= DI(5) XOR DI(15);
	out1(19) <= DI(17) XOR DI(37);
	out1(20) <= DI(21) XOR DI(41);
	out1(21) <= DI(28) XOR DI(34);
	out1(22) <= DI(18) XOR DI(53);
	out1(23) <= DI(11) XOR DI(55);
	out1(24) <= DI(31) XOR DI(36);
	out1(25) <= DI(33) XOR DI(49);
	out1(26) <= DI(50) XOR DI(57);
	out1(27) <= DI(12) XOR DI(60);
	out1(28) <= DI(22) XOR DI(42);
	out1(29) <= DI(3) XOR DI(13);
	out1(30) <= DI(8) XOR DI(37);
	out1(31) <= DI(18) XOR DI(38);
	out1(32) <= DI(1) XOR DI(56);
	out1(33) <= DI(5) XOR DI(29);
	out1(34) <= DI(40);
	out1(35) <= DI(23) XOR DI(43);
	out1(36) <= DI(13) XOR DI(51);
	out1(37) <= DI(6) XOR DI(19);
	out1(38) <= DI(57) XOR DI(61);
	out1(39) <= DI(2) XOR DI(36);
	out1(40) <= DI(20) XOR DI(41);
	out1(41) <= DI(24) XOR DI(44);
	out1(42) <= DI(21) XOR DI(62);
	out1(43) <= DI(0) XOR DI(52);
	out1(44) <= DI(39) XOR DI(58);
	out1(45) <= DI(7) XOR DI(42);
	out1(46) <= DI(34);
	out1(47) <= DI(25) XOR DI(45);
	out1(48) <= DI(35) XOR DI(40);
	out1(49) <= DI(53) XOR DI(57);
	out1(50) <= DI(22) XOR DI(63);
	out1(51) <= DI(3) XOR DI(15);
	out1(52) <= DI(19) XOR DI(43);
	out1(53) <= DI(60);
	out1(54) <= DI(48) XOR DI(60);
	out1(55) <= DI(26) XOR DI(46);
	out1(56) <= DI(27) XOR DI(41);
	out1(57) <= DI(2) XOR DI(23);
	out1(58) <= DI(6) XOR DI(44);
	out1(59) <= DI(61);
	out1(60) <= DI(31) XOR DI(61);
	out1(61) <= DI(49) XOR DI(62);
	out1(62) <= DI(27) XOR DI(47);
	out1(63) <= DI(24) XOR DI(33);
	out1(64) <= DI(8) XOR DI(20);
	out1(65) <= DI(45) XOR DI(53);
	out1(66) <= DI(15) XOR DI(28);
	out1(67) <= DI(42) XOR DI(56);
	out1(68) <= DI(17) XOR DI(63);
	out1(69) <= DI(16) XOR DI(25);
	out1(70) <= DI(4) XOR DI(7);
	out1(71) <= DI(9) XOR DI(43);
	out1(72) <= DI(29) XOR DI(32);
	out1(73) <= DI(46) XOR DI(48);
	out1(74) <= DI(29) XOR DI(51);
	out1(75) <= DI(28) XOR DI(52);
	out1(76) <= DI(1) XOR DI(44);
	out1(77) <= DI(2) XOR DI(26);
	out1(78) <= DI(3) XOR DI(18);
	out1(79) <= DI(39) XOR DI(49);
	out1(80) <= DI(37) XOR DI(50);
	out1(81) <= DI(10) XOR DI(29);
	out1(82) <= DI(12) XOR DI(54);
	out1(83) <= DI(11) XOR DI(46);
	out1(84) <= DI(15) XOR DI(38);
	out1(85) <= DI(47) XOR DI(56);
	out1(86) <= DI(12) XOR DI(14);
	out1(87) <= DI(41) XOR DI(52);
	out1(88) <= DI(13) XOR DI(14);
	out1(89) <= DI(26) XOR DI(42);
	out1(90) <= DI(48) XOR DI(49);
	out1(91) <= DI(14) XOR DI(30);
	out1(92) <= DI(40) XOR DI(43);
	out1(93) <= DI(31) XOR DI(39);
	out1(94) <= DI(41) XOR DI(42);
	out1(95) <= DI(44) XOR DI(51);
	out1(96) <= DI(55) XOR DI(59);
	out1(97) <= DI(18) XOR DI(59);
	out1(98) <= DI(8) XOR DI(11);
	out1(99) <= DI(45) XOR DI(47);
	out1(100) <= DI(4) XOR DI(14);
	out1(101) <= DI(44) XOR DI(49);
	out1(102) <= DI(57);
	out1(103) <= DI(35) XOR DI(47);
	out1(104) <= DI(58);
	out1(105) <= DI(0) XOR DI(9);
	out1(106) <= DI(10) XOR DI(14);
	out1(107) <= DI(45) XOR DI(61);
	out1(108) <= DI(19) XOR DI(20);
	out1(109) <= DI(30) XOR DI(32);
	out1(110) <= DI(35) XOR DI(46);
	out1(111) <= DI(54) XOR DI(63);
	out1(112) <= DI(5) XOR DI(30);
	out1(113) <= DI(1) XOR DI(21);
	out1(114) <= DI(23) XOR DI(49);
	out1(115) <= DI(50) XOR DI(58);
	out1(116) <= DI(16) XOR DI(22);
	out1(117) <= DI(24) XOR DI(50);
	out1(118) <= DI(62);
	out1(119) <= DI(4) XOR DI(6);
	out1(120) <= DI(9) XOR DI(23);
	out1(121) <= DI(25) XOR DI(31);
	out1(122) <= DI(59) XOR DI(62);
	out1(123) <= DI(24) XOR DI(26);
	out1(124) <= DI(34) XOR DI(35);
	out1(125) <= DI(34) XOR DI(52);
	out1(126) <= DI(8) XOR DI(9);
	out1(127) <= DI(26) XOR DI(53);
	out1(128) <= DI(32) XOR DI(33);
	out1(129) <= DI(22) XOR DI(59);
	out1(130) <= DI(5) XOR DI(23);
	out1(131) <= DI(5) XOR DI(28);
	out1(132) <= DI(55) XOR DI(63);
	out1(133) <= DI(19) XOR DI(47);
	out1(134) <= DI(10) XOR DI(16);
	out1(135) <= DI(47) XOR DI(57);

	out2(0) <= out1(0) XOR out1(1);
	out2(1) <= out1(2) XOR out1(3);
	out2(2) <= out1(4) XOR out1(5);
	out2(3) <= out1(6) XOR out1(7);
	out2(4) <= out1(8) XOR out1(9);
	out2(5) <= out1(10) XOR out1(11);
	out2(6) <= out1(12) XOR out1(13);
	out2(7) <= out1(2) XOR out1(14);
	out2(8) <= out1(15) XOR out1(16);
	out2(9) <= out1(9) XOR out1(17);
	out2(10) <= out1(18) XOR out1(19);
	out2(11) <= out1(20) XOR out1(21);
	out2(12) <= out1(22) XOR out1(23);
	out2(13) <= out1(24) XOR out1(25);
	out2(14) <= out1(4) XOR out1(26);
	out2(15) <= out1(16) XOR out1(27);
	out2(16) <= out1(6) XOR out1(28);
	out2(17) <= out1(29) XOR out1(30);
	out2(18) <= out1(20) XOR out1(31);
	out2(19) <= out1(32) XOR out1(33);
	out2(20) <= out1(34);
	out2(21) <= out1(35) XOR out1(36);
	out2(22) <= out1(15) XOR out1(28);
	out2(23) <= out1(7) XOR out1(37);
	out2(24) <= out1(8) XOR out1(5);
	out2(25) <= out1(16) XOR out1(19);
	out2(26) <= out1(38) XOR out1(39);
	out2(27) <= out1(40);
	out2(28) <= out1(41) XOR out1(42);
	out2(29) <= out1(18) XOR out1(14);
	out2(30) <= out1(35) XOR out1(24);
	out2(31) <= out1(31) XOR out1(43);
	out2(32) <= out1(5) XOR out1(44);
	out2(33) <= out1(45) XOR out1(46);
	out2(34) <= out1(30) XOR out1(47);
	out2(35) <= out1(17) XOR out1(48);
	out2(36) <= out1(41) XOR out1(49);
	out2(37) <= out1(5) XOR out1(20);
	out2(38) <= out1(50) XOR out1(51);
	out2(39) <= out1(52) XOR out1(53);
	out2(40) <= out1(8) XOR out1(54);
	out2(41) <= out1(18) XOR out1(6);
	out2(42) <= out1(0) XOR out1(55);
	out2(43) <= out1(47) XOR out1(56);
	out2(44) <= out1(5) XOR out1(12);
	out2(45) <= out1(57) XOR out1(58);
	out2(46) <= out1(59);
	out2(47) <= out1(60) XOR out1(61);
	out2(48) <= out1(62) XOR out1(63);
	out2(49) <= out1(29) XOR out1(55);
	out2(50) <= out1(35) XOR out1(64);
	out2(51) <= out1(1) XOR out1(65);
	out2(52) <= out1(39) XOR out1(66);
	out2(53) <= out1(67);
	out2(54) <= out1(26) XOR out1(68);
	out2(55) <= out1(62) XOR out1(21);
	out2(56) <= out1(69) XOR out1(70);
	out2(57) <= out1(71) XOR out1(72);
	out2(58) <= out1(73);
	out2(59) <= out1(74) XOR out1(75);
	out2(60) <= out1(4) XOR out1(62);
	out2(61) <= out1(9) XOR out1(50);
	out2(62) <= out1(76) XOR out1(77);
	out2(63) <= out1(78) XOR out1(79);
	out2(64) <= out1(15) XOR out1(80);
	out2(65) <= out1(44) XOR out1(65);
	out2(66) <= out1(57) XOR out1(81);
	out2(67) <= out1(8) XOR out1(28);
	out2(68) <= out1(74) XOR out1(82);
	out2(69) <= out1(83) XOR out1(84);
	out2(70) <= out1(29) XOR out1(21);
	out2(71) <= out1(69) XOR out1(85);
	out2(72) <= out1(86) XOR out1(87);
	out2(73) <= out1(60) XOR out1(48);
	out2(74) <= out1(72) XOR out1(88);
	out2(75) <= out1(89) XOR out1(90);
	out2(76) <= out1(18) XOR out1(61);
	out2(77) <= out1(7) XOR out1(31);
	out2(78) <= out1(91) XOR out1(92);
	out2(79) <= out1(1) XOR out1(68);
	out2(80) <= out1(55) XOR out1(66);
	out2(81) <= out1(93) XOR out1(94);
	out2(82) <= out1(95) XOR out1(96);
	out2(83) <= out1(29) XOR out1(74);
	out2(84) <= out1(71) XOR out1(97);
	out2(85) <= out1(45) XOR out1(98);
	out2(86) <= out1(99);
	out2(87) <= out1(15) XOR out1(30);
	out2(88) <= out1(14) XOR out1(60);
	out2(89) <= out1(43) XOR out1(71);
	out2(90) <= out1(83) XOR out1(100);
	out2(91) <= out1(101) XOR out1(102);
	out2(92) <= out1(29) XOR out1(20);
	out2(93) <= out1(3) XOR out1(26);
	out2(94) <= out1(27) XOR out1(64);
	out2(95) <= out1(65) XOR out1(76);
	out2(96) <= out1(103) XOR out1(104);
	out2(97) <= out1(2) XOR out1(4);
	out2(98) <= out1(17) XOR out1(7);
	out2(99) <= out1(36) XOR out1(42);
	out2(100) <= out1(73) XOR out1(105);
	out2(101) <= out1(106) XOR out1(107);
	out2(102) <= out1(1) XOR out1(54);
	out2(103) <= out1(50) XOR out1(97);
	out2(104) <= out1(108) XOR out1(109);
	out2(105) <= out1(110);
	out2(106) <= out1(16) XOR out1(111);
	out2(107) <= out1(60) XOR out1(112);
	out2(108) <= out1(41) XOR out1(70);
	out2(109) <= out1(0) XOR out1(113);
	out2(110) <= out1(114) XOR out1(115);
	out2(111) <= out1(53);
	out2(112) <= out1(6) XOR out1(47);
	out2(113) <= out1(44) XOR out1(82);
	out2(114) <= out1(98) XOR out1(116);
	out2(115) <= out1(117) XOR out1(118);
	out2(116) <= out1(68) XOR out1(22);
	out2(117) <= out1(119) XOR out1(120);
	out2(118) <= out1(121) XOR out1(122);
	out2(119) <= out1(3) XOR out1(22);
	out2(120) <= out1(60) XOR out1(9);
	out2(121) <= out1(54) XOR out1(44);
	out2(122) <= out1(23) XOR out1(33);
	out2(123) <= out1(85) XOR out1(123);
	out2(124) <= out1(124);
	out2(125) <= out1(3) XOR out1(7);
	out2(126) <= out1(61) XOR out1(69);
	out2(127) <= out1(23) XOR out1(38);
	out2(128) <= out1(97) XOR out1(32);
	out2(129) <= out1(125);
	out2(130) <= out1(17) XOR out1(35);
	out2(131) <= out1(88) XOR out1(126);
	out2(132) <= out1(127) XOR out1(104);
	out2(133) <= out1(2) XOR out1(41);
	out2(134) <= out1(47) XOR out1(38);
	out2(135) <= out1(128) XOR out1(129);
	out2(136) <= out1(4) XOR out1(14);
	out2(137) <= out1(47) XOR out1(10);
	out2(138) <= out1(130);
	out2(139) <= out1(26) XOR out1(37);
	out2(140) <= out1(82) XOR out1(131);
	out2(141) <= out1(132);
	out2(142) <= out1(69) XOR out1(112);
	out2(143) <= out1(133) XOR out1(118);
	out2(144) <= out1(74) XOR out1(77);
	out2(145) <= out1(93) XOR out1(128);
	out2(146) <= out1(134) XOR out1(135);

	out3(0) <= out2(0) XOR out2(1);
	out3(1) <= out2(2) XOR out2(3);
	out3(2) <= out2(4) XOR out2(5);
	out3(3) <= out2(6);
	out3(4) <= out2(7) XOR out2(8);
	out3(5) <= out2(9) XOR out2(10);
	out3(6) <= out2(11) XOR out2(12);
	out3(7) <= out2(13);
	out3(8) <= out2(0) XOR out2(14);
	out3(9) <= out2(15) XOR out2(16);
	out3(10) <= out2(17) XOR out2(18);
	out3(11) <= out2(19) XOR out2(20);
	out3(12) <= out2(1) XOR out2(21);
	out3(13) <= out2(22) XOR out2(23);
	out3(14) <= out2(24) XOR out2(25);
	out3(15) <= out2(26) XOR out2(27);
	out3(16) <= out2(17) XOR out2(28);
	out3(17) <= out2(9) XOR out2(29);
	out3(18) <= out2(30) XOR out2(31);
	out3(19) <= out2(32) XOR out2(33);
	out3(20) <= out2(34) XOR out2(35);
	out3(21) <= out2(36) XOR out2(37);
	out3(22) <= out2(38) XOR out2(39);
	out3(23) <= out2(40) XOR out2(41);
	out3(24) <= out2(22) XOR out2(42);
	out3(25) <= out2(43) XOR out2(44);
	out3(26) <= out2(45) XOR out2(46);
	out3(27) <= out2(47) XOR out2(48);
	out3(28) <= out2(8) XOR out2(49);
	out3(29) <= out2(50) XOR out2(51);
	out3(30) <= out2(52) XOR out2(53);
	out3(31) <= out2(2) XOR out2(54);
	out3(32) <= out2(55) XOR out2(56);
	out3(33) <= out2(57) XOR out2(58);
	out3(34) <= out2(0) XOR out2(41);
	out3(35) <= out2(59) XOR out2(34);
	out3(36) <= out2(60) XOR out2(61);
	out3(37) <= out2(62) XOR out2(63);
	out3(38) <= out2(2) XOR out2(42);
	out3(39) <= out2(11) XOR out2(64);
	out3(40) <= out2(65) XOR out2(66);
	out3(41) <= out2(17) XOR out2(48);
	out3(42) <= out2(35) XOR out2(67);
	out3(43) <= out2(68) XOR out2(69);
	out3(44) <= out2(40) XOR out2(1);
	out3(45) <= out2(30) XOR out2(70);
	out3(46) <= out2(71) XOR out2(72);
	out3(47) <= out2(7) XOR out2(10);
	out3(48) <= out2(36) XOR out2(73);
	out3(49) <= out2(74) XOR out2(75);
	out3(50) <= out2(43) XOR out2(76);
	out3(51) <= out2(77) XOR out2(78);
	out3(52) <= out2(79) XOR out2(3);
	out3(53) <= out2(64) XOR out2(80);
	out3(54) <= out2(81) XOR out2(82);
	out3(55) <= out2(7) XOR out2(40);
	out3(56) <= out2(2) XOR out2(23);
	out3(57) <= out2(83) XOR out2(84);
	out3(58) <= out2(85) XOR out2(86);
	out3(59) <= out2(9) XOR out2(87);
	out3(60) <= out2(88) XOR out2(89);
	out3(61) <= out2(90) XOR out2(91);
	out3(62) <= out2(0) XOR out2(47);
	out3(63) <= out2(92) XOR out2(29);
	out3(64) <= out2(93) XOR out2(94);
	out3(65) <= out2(95) XOR out2(96);
	out3(66) <= out2(0) XOR out2(22);
	out3(67) <= out2(54) XOR out2(97);
	out3(68) <= out2(98) XOR out2(99);
	out3(69) <= out2(100) XOR out2(101);
	out3(70) <= out2(60) XOR out2(76);
	out3(71) <= out2(87) XOR out2(102);
	out3(72) <= out2(103) XOR out2(104);
	out3(73) <= out2(105);
	out3(74) <= out2(17) XOR out2(106);
	out3(75) <= out2(55) XOR out2(107);
	out3(76) <= out2(108) XOR out2(109);
	out3(77) <= out2(110) XOR out2(111);
	out3(78) <= out2(9) XOR out2(59);
	out3(79) <= out2(5) XOR out2(107);
	out3(80) <= out2(112) XOR out2(113);
	out3(81) <= out2(114) XOR out2(115);
	out3(82) <= out2(42) XOR out2(59);
	out3(83) <= out2(92) XOR out2(15);
	out3(84) <= out2(4) XOR out2(116);
	out3(85) <= out2(117) XOR out2(118);
	out3(86) <= out2(22) XOR out2(92);
	out3(87) <= out2(79) XOR out2(119);
	out3(88) <= out2(120) XOR out2(121);
	out3(89) <= out2(122) XOR out2(123);
	out3(90) <= out2(124);
	out3(91) <= out2(50) XOR out2(125);
	out3(92) <= out2(126) XOR out2(127);
	out3(93) <= out2(128) XOR out2(129);
	out3(94) <= out2(7) XOR out2(54);
	out3(95) <= out2(28) XOR out2(130);
	out3(96) <= out2(131) XOR out2(132);
	out3(97) <= out2(21) XOR out2(79);
	out3(98) <= out2(31) XOR out2(133);
	out3(99) <= out2(134) XOR out2(135);
	out3(100) <= out2(40) XOR out2(42);
	out3(101) <= out2(47) XOR out2(119);
	out3(102) <= out2(108) XOR out2(136);
	out3(103) <= out2(137) XOR out2(138);
	out3(104) <= out2(7) XOR out2(42);
	out3(105) <= out2(34) XOR out2(139);
	out3(106) <= out2(140) XOR out2(141);
	out3(107) <= out2(59) XOR out2(49);
	out3(108) <= out2(142) XOR out2(143);
	out3(109) <= out2(41) XOR out2(119);
	out3(110) <= out2(144) XOR out2(145);
	out3(111) <= out2(146);

	out4(0) <= out3(0) XOR out3(1);
	out4(1) <= out3(2) XOR out3(3);
	out4(2) <= out3(4) XOR out3(5);
	out4(3) <= out3(6) XOR out3(7);
	out4(4) <= out3(8) XOR out3(9);
	out4(5) <= out3(10) XOR out3(11);
	out4(6) <= out3(12) XOR out3(13);
	out4(7) <= out3(14) XOR out3(15);
	out4(8) <= out3(16) XOR out3(17);
	out4(9) <= out3(18) XOR out3(19);
	out4(10) <= out3(0) XOR out3(20);
	out4(11) <= out3(21) XOR out3(22);
	out4(12) <= out3(23) XOR out3(24);
	out4(13) <= out3(25) XOR out3(26);
	out4(14) <= out3(27) XOR out3(28);
	out4(15) <= out3(29) XOR out3(30);
	out4(16) <= out3(16) XOR out3(31);
	out4(17) <= out3(32) XOR out3(33);
	out4(18) <= out3(34) XOR out3(35);
	out4(19) <= out3(36) XOR out3(37);
	out4(20) <= out3(38) XOR out3(39);
	out4(21) <= out3(40);
	out4(22) <= out3(41) XOR out3(42);
	out4(23) <= out3(43);
	out4(24) <= out3(44) XOR out3(45);
	out4(25) <= out3(46);
	out4(26) <= out3(47) XOR out3(48);
	out4(27) <= out3(49);
	out4(28) <= out3(8) XOR out3(50);
	out4(29) <= out3(51);
	out4(30) <= out3(52) XOR out3(53);
	out4(31) <= out3(54);
	out4(32) <= out3(55) XOR out3(56);
	out4(33) <= out3(57) XOR out3(58);
	out4(34) <= out3(23) XOR out3(59);
	out4(35) <= out3(60) XOR out3(61);
	out4(36) <= out3(62) XOR out3(63);
	out4(37) <= out3(64) XOR out3(65);
	out4(38) <= out3(66) XOR out3(67);
	out4(39) <= out3(68) XOR out3(69);
	out4(40) <= out3(12) XOR out3(70);
	out4(41) <= out3(71) XOR out3(72);
	out4(42) <= out3(73);
	out4(43) <= out3(74) XOR out3(75);
	out4(44) <= out3(76) XOR out3(77);
	out4(45) <= out3(78) XOR out3(79);
	out4(46) <= out3(80) XOR out3(81);
	out4(47) <= out3(82) XOR out3(83);
	out4(48) <= out3(84) XOR out3(85);
	out4(49) <= out3(86) XOR out3(87);
	out4(50) <= out3(88) XOR out3(89);
	out4(51) <= out3(90);
	out4(52) <= out3(86) XOR out3(91);
	out4(53) <= out3(92) XOR out3(93);
	out4(54) <= out3(9) XOR out3(94);
	out4(55) <= out3(95) XOR out3(96);
	out4(56) <= out3(23) XOR out3(97);
	out4(57) <= out3(98) XOR out3(99);
	out4(58) <= out3(100) XOR out3(101);
	out4(59) <= out3(102) XOR out3(103);
	out4(60) <= out3(27) XOR out3(104);
	out4(61) <= out3(105) XOR out3(106);
	out4(62) <= out3(4) XOR out3(31);
	out4(63) <= out3(107) XOR out3(108);
	out4(64) <= out3(74) XOR out3(109);
	out4(65) <= out3(110) XOR out3(111);

	out5(0) <= out4(0) XOR out4(1);
	out5(1) <= out4(2) XOR out4(3);
	out5(2) <= out4(4) XOR out4(5);
	out5(3) <= out4(6) XOR out4(7);
	out5(4) <= out4(8) XOR out4(9);
	out5(5) <= out4(10) XOR out4(11);
	out5(6) <= out4(12) XOR out4(13);
	out5(7) <= out4(14) XOR out4(15);
	out5(8) <= out4(16) XOR out4(17);
	out5(9) <= out4(18) XOR out4(19);
	out5(10) <= out4(20) XOR out4(21);
	out5(11) <= out4(22) XOR out4(23);
	out5(12) <= out4(24) XOR out4(25);
	out5(13) <= out4(26) XOR out4(27);
	out5(14) <= out4(28) XOR out4(29);
	out5(15) <= out4(30) XOR out4(31);
	out5(16) <= out4(32) XOR out4(33);
	out5(17) <= out4(34) XOR out4(35);
	out5(18) <= out4(36) XOR out4(37);
	out5(19) <= out4(38) XOR out4(39);
	out5(20) <= out4(40) XOR out4(41);
	out5(21) <= out4(42);
	out5(22) <= out4(43) XOR out4(44);
	out5(23) <= out4(45) XOR out4(46);
	out5(24) <= out4(47) XOR out4(48);
	out5(25) <= out4(49) XOR out4(50);
	out5(26) <= out4(51);
	out5(27) <= out4(52) XOR out4(53);
	out5(28) <= out4(54) XOR out4(55);
	out5(29) <= out4(56) XOR out4(57);
	out5(30) <= out4(58) XOR out4(59);
	out5(31) <= out4(60) XOR out4(61);
	out5(32) <= out4(62) XOR out4(63);
	out5(33) <= out4(64) XOR out4(65);

	out6(0) <= out5(0);
	out6(1) <= out5(1);
	out6(2) <= out5(2);
	out6(3) <= out5(3);
	out6(4) <= out5(4);
	out6(5) <= out5(5);
	out6(6) <= out5(6);
	out6(7) <= out5(7);
	out6(8) <= out5(8);
	out6(9) <= out5(9);
	out6(10) <= out5(10);
	out6(11) <= out5(11);
	out6(12) <= out5(12);
	out6(13) <= out5(13);
	out6(14) <= out5(14);
	out6(15) <= out5(15);
	out6(16) <= out5(16);
	out6(17) <= out5(17);
	out6(18) <= out5(18);
	out6(19) <= out5(19);
	out6(20) <= out5(20) XOR out5(21);
	out6(21) <= out5(22);
	out6(22) <= out5(23);
	out6(23) <= out5(24);
	out6(24) <= out5(25) XOR out5(26);
	out6(25) <= out5(27);
	out6(26) <= out5(28);
	out6(27) <= out5(29);
	out6(28) <= out5(30);
	out6(29) <= out5(31);
	out6(30) <= out5(32);
	out6(31) <= out5(33);

	DO(0) <= out6(0);
	DO(1) <= out6(1);
	DO(2) <= out6(2);
	DO(3) <= out6(3);
	DO(4) <= out6(4);
	DO(5) <= out6(5);
	DO(6) <= out6(6);
	DO(7) <= out6(7);
	DO(8) <= out6(8);
	DO(9) <= out6(9);
	DO(10) <= out6(10);
	DO(11) <= out6(11);
	DO(12) <= out6(12);
	DO(13) <= out6(13);
	DO(14) <= out6(14);
	DO(15) <= out6(15);
	DO(16) <= out6(16);
	DO(17) <= out6(17);
	DO(18) <= out6(18);
	DO(19) <= out6(19);
	DO(20) <= out6(20);
	DO(21) <= out6(21);
	DO(22) <= out6(22);
	DO(23) <= out6(23);
	DO(24) <= out6(24);
	DO(25) <= out6(25);
	DO(26) <= out6(26);
	DO(27) <= out6(27);
	DO(28) <= out6(28);
	DO(29) <= out6(29);
	DO(30) <= out6(30);
	DO(31) <= out6(31);

end architecture;
