library ieee;
use ieee.std_logic_1164.all;

entity crc32_fast24_tab is

	port (
		DI : in std_logic_vector(23 downto 0);
		DO : out std_logic_vector(31 downto 0)
	);

end entity;

architecture structural of crc32_fast24_tab is

	signal out1 : std_logic_vector(60 downto 0);

	signal out2 : std_logic_vector(66 downto 0);

	signal out3 : std_logic_vector(54 downto 0);

	signal out4 : std_logic_vector(31 downto 0);

begin

	out1(0) <= DI(8) XOR DI(15);
	out1(1) <= DI(0) XOR DI(12);
	out1(2) <= DI(14) XOR DI(18);
	out1(3) <= DI(1) XOR DI(13);
	out1(4) <= DI(0) XOR DI(19);
	out1(5) <= DI(9) XOR DI(16);
	out1(6) <= DI(15);
	out1(7) <= DI(10) XOR DI(14);
	out1(8) <= DI(16) XOR DI(20);
	out1(9) <= DI(0) XOR DI(2);
	out1(10) <= DI(1) XOR DI(17);
	out1(11) <= DI(2) XOR DI(18);
	out1(12) <= DI(1) XOR DI(15);
	out1(13) <= DI(3) XOR DI(17);
	out1(14) <= DI(11) XOR DI(21);
	out1(15) <= DI(19) XOR DI(22);
	out1(16) <= DI(3) XOR DI(4);
	out1(17) <= DI(16);
	out1(18) <= DI(4) XOR DI(20);
	out1(19) <= DI(5) XOR DI(23);
	out1(20) <= DI(5) XOR DI(21);
	out1(21) <= DI(1) XOR DI(12);
	out1(22) <= DI(2) XOR DI(6);
	out1(23) <= DI(6) XOR DI(22);
	out1(24) <= DI(3) XOR DI(7);
	out1(25) <= DI(2) XOR DI(13);
	out1(26) <= DI(7) XOR DI(23);
	out1(27) <= DI(4) XOR DI(8);
	out1(28) <= DI(11) XOR DI(14);
	out1(29) <= DI(5) XOR DI(9);
	out1(30) <= DI(4);
	out1(31) <= DI(5) XOR DI(6);
	out1(32) <= DI(18);
	out1(33) <= DI(11) XOR DI(19);
	out1(34) <= DI(6) XOR DI(7);
	out1(35) <= DI(14) XOR DI(15);
	out1(36) <= DI(13) XOR DI(17);
	out1(37) <= DI(21);
	out1(38) <= DI(18) XOR DI(22);
	out1(39) <= DI(0) XOR DI(1);
	out1(40) <= DI(10) XOR DI(23);
	out1(41) <= DI(4) XOR DI(6);
	out1(42) <= DI(5) XOR DI(14);
	out1(43) <= DI(6) XOR DI(19);
	out1(44) <= DI(7) XOR DI(10);
	out1(45) <= DI(17);
	out1(46) <= DI(8) XOR DI(17);
	out1(47) <= DI(23);
	out1(48) <= DI(3) XOR DI(8);
	out1(49) <= DI(9) XOR DI(14);
	out1(50) <= DI(20);
	out1(51) <= DI(9) XOR DI(18);
	out1(52) <= DI(15) XOR DI(20);
	out1(53) <= DI(0) XOR DI(21);
	out1(54) <= DI(12) XOR DI(21);
	out1(55) <= DI(13) XOR DI(16);
	out1(56) <= DI(12) XOR DI(23);
	out1(57) <= DI(13) XOR DI(14);
	out1(58) <= DI(15) XOR DI(17);
	out1(59) <= DI(11) XOR DI(12);
	out1(60) <= DI(16) XOR DI(17);

	out2(0) <= out1(0) XOR out1(1);
	out2(1) <= out1(2);
	out2(2) <= out1(3) XOR out1(4);
	out2(3) <= out1(5) XOR out1(6);
	out2(4) <= out1(7) XOR out1(8);
	out2(5) <= out1(9) XOR out1(10);
	out2(6) <= out1(11) XOR out1(12);
	out2(7) <= out1(13) XOR out1(14);
	out2(8) <= out1(11) XOR out1(15);
	out2(9) <= out1(1) XOR out1(16);
	out2(10) <= out1(17);
	out2(11) <= out1(13) XOR out1(18);
	out2(12) <= out1(19);
	out2(13) <= out1(0) XOR out1(18);
	out2(14) <= out1(20) XOR out1(21);
	out2(15) <= out1(22);
	out2(16) <= out1(5) XOR out1(20);
	out2(17) <= out1(23) XOR out1(24);
	out2(18) <= out1(25);
	out2(19) <= out1(7) XOR out1(23);
	out2(20) <= out1(13) XOR out1(26);
	out2(21) <= out1(27);
	out2(22) <= out1(26) XOR out1(28);
	out2(23) <= out1(1) XOR out1(29);
	out2(24) <= out1(30);
	out2(25) <= out1(7) XOR out1(3);
	out2(26) <= out1(31) XOR out1(32);
	out2(27) <= out1(33) XOR out1(9);
	out2(28) <= out1(34) XOR out1(35);
	out2(29) <= out1(0) XOR out1(8);
	out2(30) <= out1(24) XOR out1(21);
	out2(31) <= out1(5) XOR out1(9);
	out2(32) <= out1(27) XOR out1(36);
	out2(33) <= out1(37);
	out2(34) <= out1(7) XOR out1(38);
	out2(35) <= out1(13) XOR out1(29);
	out2(36) <= out1(39);
	out2(37) <= out1(33) XOR out1(40);
	out2(38) <= out1(41);
	out2(39) <= out1(11) XOR out1(33);
	out2(40) <= out1(24) XOR out1(42);
	out2(41) <= out1(5) XOR out1(43);
	out2(42) <= out1(18) XOR out1(3);
	out2(43) <= out1(38) XOR out1(44);
	out2(44) <= out1(45);
	out2(45) <= out1(20) XOR out1(33);
	out2(46) <= out1(11) XOR out1(46);
	out2(47) <= out1(47);
	out2(48) <= out1(23) XOR out1(33);
	out2(49) <= out1(26) XOR out1(48);
	out2(50) <= out1(49) XOR out1(50);
	out2(51) <= out1(7) XOR out1(18);
	out2(52) <= out1(26) XOR out1(51);
	out2(53) <= out1(1);
	out2(54) <= out1(1) XOR out1(3);
	out2(55) <= out1(52) XOR out1(47);
	out2(56) <= out1(11) XOR out1(26);
	out2(57) <= out1(3) XOR out1(53);
	out2(58) <= out1(5) XOR out1(13);
	out2(59) <= out1(15) XOR out1(54);
	out2(60) <= out1(40) XOR out1(55);
	out2(61) <= out1(0) XOR out1(56);
	out2(62) <= out1(23) XOR out1(57);
	out2(63) <= out1(26) XOR out1(58);
	out2(64) <= out1(26) XOR out1(59);
	out2(65) <= out1(60);
	out2(66) <= out1(36);

	out3(0) <= out2(0) XOR out2(1);
	out3(1) <= out2(2) XOR out2(3);
	out3(2) <= out2(4) XOR out2(5);
	out3(3) <= out2(6) XOR out2(7);
	out3(4) <= out2(8) XOR out2(9);
	out3(5) <= out2(10);
	out3(6) <= out2(11) XOR out2(2);
	out3(7) <= out2(12);
	out3(8) <= out2(13) XOR out2(14);
	out3(9) <= out2(15);
	out3(10) <= out2(16) XOR out2(17);
	out3(11) <= out2(18);
	out3(12) <= out2(19) XOR out2(20);
	out3(13) <= out2(21);
	out3(14) <= out2(22) XOR out2(23);
	out3(15) <= out2(24);
	out3(16) <= out2(25) XOR out2(26);
	out3(17) <= out2(27) XOR out2(28);
	out3(18) <= out2(29) XOR out2(30);
	out3(19) <= out2(31) XOR out2(32);
	out3(20) <= out2(33);
	out3(21) <= out2(34) XOR out2(35);
	out3(22) <= out2(36);
	out3(23) <= out2(6) XOR out2(37);
	out3(24) <= out2(38);
	out3(25) <= out2(29) XOR out2(39);
	out3(26) <= out2(40);
	out3(27) <= out2(11) XOR out2(0);
	out3(28) <= out2(41) XOR out2(33);
	out3(29) <= out2(16) XOR out2(42);
	out3(30) <= out2(43) XOR out2(44);
	out3(31) <= out2(19) XOR out2(45);
	out3(32) <= out2(46) XOR out2(47);
	out3(33) <= out2(48) XOR out2(49);
	out3(34) <= out2(50);
	out3(35) <= out2(51) XOR out2(52);
	out3(36) <= out2(45) XOR out2(34);
	out3(37) <= out2(53);
	out3(38) <= out2(48) XOR out2(54);
	out3(39) <= out2(55);
	out3(40) <= out2(29) XOR out2(56);
	out3(41) <= out2(57);
	out3(42) <= out2(6) XOR out2(58);
	out3(43) <= out2(59);
	out3(44) <= out2(11) XOR out2(8);
	out3(45) <= out2(60);
	out3(46) <= out2(11) XOR out2(45);
	out3(47) <= out2(61);
	out3(48) <= out2(16) XOR out2(13);
	out3(49) <= out2(62);
	out3(50) <= out2(16) XOR out2(19);
	out3(51) <= out2(63);
	out3(52) <= out2(19) XOR out2(64);
	out3(53) <= out2(65);
	out3(54) <= out2(22) XOR out2(66);

	out4(0) <= out3(0);
	out4(1) <= out3(1);
	out4(2) <= out3(2);
	out4(3) <= out3(3);
	out4(4) <= out3(4) XOR out3(5);
	out4(5) <= out3(6) XOR out3(7);
	out4(6) <= out3(8) XOR out3(9);
	out4(7) <= out3(10) XOR out3(11);
	out4(8) <= out3(12) XOR out3(13);
	out4(9) <= out3(14) XOR out3(15);
	out4(10) <= out3(16);
	out4(11) <= out3(17);
	out4(12) <= out3(18);
	out4(13) <= out3(19) XOR out3(20);
	out4(14) <= out3(21) XOR out3(22);
	out4(15) <= out3(23) XOR out3(24);
	out4(16) <= out3(25) XOR out3(26);
	out4(17) <= out3(27) XOR out3(28);
	out4(18) <= out3(29) XOR out3(30);
	out4(19) <= out3(31) XOR out3(32);
	out4(20) <= out3(33) XOR out3(34);
	out4(21) <= out3(35) XOR out3(20);
	out4(22) <= out3(36) XOR out3(37);
	out4(23) <= out3(38) XOR out3(39);
	out4(24) <= out3(40) XOR out3(41);
	out4(25) <= out3(42) XOR out3(43);
	out4(26) <= out3(44) XOR out3(45);
	out4(27) <= out3(46) XOR out3(47);
	out4(28) <= out3(48) XOR out3(49);
	out4(29) <= out3(50) XOR out3(51);
	out4(30) <= out3(52) XOR out3(53);
	out4(31) <= out3(54);

	DO(0) <= out4(0);
	DO(1) <= out4(1);
	DO(2) <= out4(2);
	DO(3) <= out4(3);
	DO(4) <= out4(4);
	DO(5) <= out4(5);
	DO(6) <= out4(6);
	DO(7) <= out4(7);
	DO(8) <= out4(8);
	DO(9) <= out4(9);
	DO(10) <= out4(10);
	DO(11) <= out4(11);
	DO(12) <= out4(12);
	DO(13) <= out4(13);
	DO(14) <= out4(14);
	DO(15) <= out4(15);
	DO(16) <= out4(16);
	DO(17) <= out4(17);
	DO(18) <= out4(18);
	DO(19) <= out4(19);
	DO(20) <= out4(20);
	DO(21) <= out4(21);
	DO(22) <= out4(22);
	DO(23) <= out4(23);
	DO(24) <= out4(24);
	DO(25) <= out4(25);
	DO(26) <= out4(26);
	DO(27) <= out4(27);
	DO(28) <= out4(28);
	DO(29) <= out4(29);
	DO(30) <= out4(30);
	DO(31) <= out4(31);

end architecture;
