-- check_ent.vhd: Check unit of CGMII Input buffer - entity declaration
-- Copyright (C) 2012 CESNET
-- Author(s): Jan Kucera <xkucer73@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--

library IEEE;
use IEEE.std_logic_1164.all;

-- ----------------------------------------------------------------------------
--                           Entity declaration
-- ----------------------------------------------------------------------------

entity check is
   generic(
      -- Number of MAC addresses that can be placed into CAM (at most 16)
      MAC_COUNT         : integer := 16;
      -- Remove FCS from the packet (false -> remove, true -> don't remove)
      INBANDFCS         : boolean := true;
      -- Synthesise design without resets, default values of registers are set
      -- by initialization of signals
      RESET_BY_INIT       : boolean := false
   );
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal
      CLK            : in std_logic;
      -- Synchronous reset, active in '1'
      RESET          : in std_logic;

      -- Datapath input -------------------------------------------------------
      -- Packet data
      RX_DATA        : in std_logic_vector(511 downto 0);
      -- Start of the packet, active in '1'
      RX_SOP         : in std_logic;
      -- Position of the start of the packet, valid only if SOP is set to '1'.
      RX_SOP_POS     : in std_logic_vector(2 downto 0);
      -- End of the packet, active in '1'.
      RX_EOP         : in std_logic;
      -- Position of the end of the packet, valid only if EOP is set to '1'.
      RX_EOP_POS     : in std_logic_vector(5 downto 0);
      -- Error inside the packet was detected, active in '1'.
      RX_ERR         : in std_logic;

      -- Datapath output ------------------------------------------------------
      -- Packet data
      TX_DATA        : out std_logic_vector(511 downto 0);
      -- Start of the packet, active in '1'
      TX_SOP         : out std_logic;
      -- Position of the start of the packet, valid only if SOP is set to '1'.
      TX_SOP_POS     : out std_logic_vector(2 downto 0);
      -- End of the packet, active in '1'.
      TX_EOP         : out std_logic;
      -- Position of the end of the packet, valid only if EOP is set to '1'.
      TX_EOP_POS     : out std_logic_vector(5 downto 0);

      -- Statistics (valid when TX_EOP = '1') ---------------------------------
      -- MAC address is not accepted
      MAC_ERR        : out std_logic;
      -- Frame does not have minimal length
      MINTU_ERR      : out std_logic;
      -- Frame is longer than maximal length
      MTU_ERR        : out std_logic;
      -- Discard the frame
      SAU_ERR        : out std_logic;
      -- Frame has bad CRC
      CRC_ERR        : out std_logic;
      -- CRC removing error
      CRC_REM_ERR    : out std_logic;
      -- Error inside the packet was detected
      FRAME_ERR      : out std_logic;
      -- Frame length
      FRAME_LEN      : out std_logic_vector(15 downto 0);
      -- Multicast MAC address detected
      MAC_MCAST      : out std_logic;
      -- Broadcast MAC address detected
      MAC_BCAST      : out std_logic;
      
      -- CAM connection -------------------------------------------------------
      -- MAC address to be searched
      CAM_DI            : out std_logic_vector(63 downto 0);
      -- MAC address search enable
      CAM_MATCH_EN      : out std_logic;
      -- CAM match reset
      CAM_MATCH_RST	   : out std_logic;
      -- Addresses found in CAM
      CAM_MATCH_BUS     : in std_logic_vector(MAC_COUNT-1 downto 0);
      -- CAM_MATCH_BUS is valid, active in '1'
      CAM_MATCH_BUS_VLD : in std_logic;

      -- Registers connection -------------------------------------------------
      -- Minimal length of frame
      MIN_FRAME_LEN  : in std_logic_vector(15 downto 0);
      -- Maximal length of frame
      MAX_FRAME_LEN  : in std_logic_vector(15 downto 0);
      -- MAC address checking
      -- 0x0: promiscuous
      -- 0x1: accept only MACs from CAM
      -- 0x2: mode1 + broadcast
      -- 0x3: mode2 + multicast
      MAC_CHECK_MODE : in std_logic_vector(1 downto 0);

      -- Sampling unit interface, signals active in '1' -----------------------
      -- Clock signal for sampling inteface
      SAU_CLK        : out std_logic;
      -- Synchronous reset for SAU_CLK domain
      SAU_RESET      : out std_logic;
      -- Request for sampling information
      SAU_REQ        : out std_logic;
      -- Accept incoming frame
      SAU_ACCEPT     : in std_logic;
      -- SAU_ACCEPT is valid
      SAU_DV         : in std_logic
   );
end entity check;

