-- cgmii_dec_pdec.vhd: Priority decoder for CGMII_dec unit of CGMII Input
--                     buffer
-- Copyright (C) 2012 CESNET
-- Author(s): Jan Kucera <xkucer73@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;


-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------

entity cgmii_dec_pdec is
   generic(
      -- Width of component ports
      DATA_WIDTH : integer
   );
   port(
      -- Input interface ------------------------------------------------------
      DI             : in  std_logic_vector(DATA_WIDTH-1 downto 0);

      -- Output interface -----------------------------------------------------
      -- Position of the first non-zero bit (one hot)
      FIRST_POS      : out std_logic_vector(DATA_WIDTH-1 downto 0);
      -- '1' at all positions after the first non-zero bit
      FIRST_NEXT_POS : out std_logic_vector(DATA_WIDTH-1 downto 0);
      -- '1' at all positions before the first non-zero bit
      FIRST_PREV_POS	: out std_logic_vector(DATA_WIDTH-1 downto 0);

      -- Position of the last non-zero bit (one hot)
      LAST_POS	      : out std_logic_vector(DATA_WIDTH-1 downto 0);
      -- '1' at all positions after the last non-zero bit
      LAST_NEXT_POS : out std_logic_vector(DATA_WIDTH-1 downto 0);
      -- '1' at all positions before the last non-zero bit
      LAST_PREV_POS	: out std_logic_vector(DATA_WIDTH-1 downto 0)
   );
end entity cgmii_dec_pdec;


-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------

architecture cgmii_dec_pdec_arch of cgmii_dec_pdec is

begin

   first_pos_priority_decoder_p : process(DI)
   begin
      FIRST_POS      <= (others => '0');
      FIRST_NEXT_POS <= (others => '0');
      FIRST_PREV_POS <= (others => '0');

      for i in 0 to DATA_WIDTH-1 loop
         if (DI(i) = '1') then
            FIRST_POS(i) <= '1';

            if (i < DATA_WIDTH-1) then
               FIRST_NEXT_POS(DATA_WIDTH-1 downto i+1) <= (others => '1');
            end if;

            if (i > 0) then
               FIRST_PREV_POS(i-1 downto 0) <= (others => '1');    
            end if;

            exit;
         end if;
      end loop;
   end process first_pos_priority_decoder_p;

   last_pos_priority_decoder_p : process(DI)
   begin
      LAST_POS      <= (others => '0');
      LAST_NEXT_POS <= (others => '0');
      LAST_PREV_POS <= (others => '0');

      for i in DATA_WIDTH-1 downto 0 loop
         if (DI(i) = '1') then
            LAST_POS(i) <= '1';

            if (i < DATA_WIDTH-1) then
               LAST_NEXT_POS(DATA_WIDTH-1 downto i+1) <= (others => '1');
            end if;

            if (i > 0) then
               LAST_PREV_POS(i-1 downto 0) <= (others => '1');    
            end if;

            exit;
         end if;
      end loop;
   end process last_pos_priority_decoder_p;

end architecture cgmii_dec_pdec_arch;

