--!
--! bus_handshake_wrapper.vhd: Wrapper for bus handshake synchronizer.
--! Copyright (C) 2014 CESNET
--! Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!
--! $Id$
--!
--! TODO:


library IEEE;	
use IEEE.std_logic_1164.all;	
use IEEE.std_logic_unsigned.all;	
use IEEE.std_logic_arith.all;


-- -----------------------------------------------------------------------------
--                          Entity declaration
-- ----------------------------------------------------------------------------

entity ASYNC_BUS_HANDSHAKE is
generic (
   DATA_WIDTH : integer := 32  --! Data BUS width
); 
port ( 
   --! A clock domain
   ACLK       : in  STD_LOGIC; --! Source clock
   ARST       : in  STD_LOGIC; --! Source reset
   ADATAIN    : in  STD_LOGIC_VECTOR(DATA_WIDTH-1 downto 0); --! Data in
   ASEND      : in  STD_LOGIC; --! Data send signal
   AREADY     : out STD_LOGIC; --! Ready signal
  
   --! B clock domain
   BCLK       : in  STD_LOGIC; --! Target clock
   BRST       : in  STD_LOGIC; --! Target reset
   BDATAOUT   : out STD_LOGIC_VECTOR(DATA_WIDTH-1 downto 0) := (others => '0'); --! Data out     
   BLOAD      : in  STD_LOGIC; --! Data load signal
   BVALID     : out STD_LOGIC  --! Data valid signal
);
end ASYNC_BUS_HANDSHAKE;


-- ----------------------------------------------------------------------------
--                          Architecture declaration
-- ----------------------------------------------------------------------------

architecture FULL of ASYNC_BUS_HANDSHAKE is  
   
begin

   async_bus_handshake_i : entity work.ASYNC_BUS_HANDSHAKE_TOP
   generic map (
      DATA_WIDTH => DATA_WIDTH
   ) 
   port map ( 
      --! A clock domain
      ACLK       => ACLK,
      ARST       => ARST,
      ADATAIN    => ADATAIN,
      ASEND      => ASEND,
      AREADY     => AREADY,
     
      --! B clock domain
      BCLK       => BCLK,
      BRST       => BRST,
      BDATAOUT   => BDATAOUT,
      BLOAD      => BLOAD,
      BVALID     => BVALID
   );

end architecture FULL;
