----------------------------------------------------
--  
--      VHDL code generated by Visual Elite
--
--  Design Unit:
--  ------------
--      Unit    Name  :  RX_FSM
--      Library Name  :  PCS_verilog
--  
--      Creation Date :  Tue Jul 13 11:21:53 2004
--      Version       :  3.5.1 build 43. Date: Feb 22 2004. License: 2004.2
--  
--  Options Used:
--  -------------
--      Target
--         Language   :  VHDL
--         Purpose    :  Synthesis
--         Vendor     :  Design Compiler
--  
--      Style
--         Use tasks                      :  No
--         Code Destination               :  1 File per Unit
--         Attach Packages                :  No
--         Generate Entity                :  Yes
--         Attach Directives              :  Yes
--         Structural                     :  No
--         Preserve spacing for free text :  Yes
--         Declaration alignment          :  No
--
----------------------------------------------------
----------------------------------------------------
--  
--  Library Name :  PCS_verilog
--  Unit    Name :  RX_FSM
--  Unit    Type :  Text Unit
--  
------------------------------------------------------
 
-- ---------------- Xilinx, CTD Systems & Apps  ------------------------
--  FileName: RX_FSM.v
--  Start of Coding Date: MON May 14 2001 ( 1:00 pm)
--  File Name : RX_FSM.v
--  Description: This file has the code for the Receive State Machine it is
--               part of the decoding function
--   Disclaimer: LIMITED WARRANTY AND DISCLAMER. These designs are
--               provided to you "as is". Xilinx and its licensors make, and you
--               receive no warranties or conditions, express, implied,
--               statutory or otherwise, and Xilinx specifically disclaims any
--               implied warranties of merchantability, non-infringement, or
--               fitness for a particular purpose. Xilinx does not warrant that
--               the functions contained in these designs will meet your
--               requirements, or that the operation of these designs will be
--               uninterrupted or error free, or that defects in the Designs
--               will be corrected. Furthermore, Xilinx does not warrant or
--               make any representations regarding use or the results of the
--               use of the designs in terms of correctness, accuracy,
--               reliability, or otherwise.
--               LIMITATION OF LIABILITY. In no event will Xilinx or its
--               licensors be liable for any loss of data, lost profits, cost
--               or procurement of substitute goods or services, or for any
--               special, incidental, consequential, or indirect damages
--               arising from the use or operation of the designs or
--               accompanying documentation, however caused and on any theory
--               of liability. This limitation will apply even if Xilinx
--               has been advised of the possibility of such damage. This
--               limitation shall apply not-withstanding the failure of the
--               essential purpose of any limited remedies herein.
--   Copyright  2002 Xilinx, Inc.
--   All rights reserved
--                        Revision History
-- -----------------------------------------------------------------
--  Date Modified             User Name            Full Name
--         Descrition of Changes
-- -----------------------------------------------------------------
--  $Log$
-- -----------------------------------------------------------------
--  NOTES:
-- -----------------------------------------------------------------
-- -----------------------------------------------------------------

--library SYNOPSYS;
--use SYNOPSYS.ATTRIBUTES.ALL;
 
 
library ieee;
use ieee.STD_LOGIC_1164.all;
use ieee.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_MISC.all;
use ieee.STD_LOGIC_UNSIGNED.all;
 
 
entity RX_FSM is
  generic (
        STATE_SIMPLIFIED : boolean := true
  );
  port (
        clk156           : in STD_LOGIC;
        rstb156          : in STD_LOGIC;
        errd_blks        : out STD_LOGIC_VECTOR(7 downto 0 );
        lpbk             : in STD_LOGIC;
        clear_errblk     : in STD_LOGIC;
        hi_ber           : in STD_LOGIC;
        blk_lock         : in STD_LOGIC;
        bypass_66decoder : in STD_LOGIC;
        rx_data          : in STD_LOGIC_VECTOR(63 downto 0 ); -- Decoded data
        rx_control       : in STD_LOGIC_VECTOR(7 downto 0 );
        rxcontrol        : out STD_LOGIC_VECTOR(7 downto 0 );
        rxdata           : out STD_LOGIC_VECTOR(63 downto 0 );
        R_TYPE           : in STD_LOGIC_VECTOR(2 downto 0 );
        DeScr_RXD        : in STD_LOGIC_VECTOR(63 downto 0 );
        STATE_PREV       : in STD_LOGIC_VECTOR(2 downto 0 );
        STATE            : out STD_LOGIC_VECTOR(2 downto 0 );
        rxlf             : out STD_LOGIC;
        DEC_ERROR        : out STD_LOGIC; -- Block decode error
        SEQ_ERROR        : out STD_LOGIC; -- Block sequencing error
        STATE_O          : out std_logic_vector(2 downto 0)
  );
end RX_FSM;


architecture RX_FSM of RX_FSM is

  -- Decoder states
  constant INIT  : std_logic_vector(2 downto 0):= "000";
  constant IDLE  : std_logic_vector(2 downto 0):= "001";
  constant START : std_logic_vector(2 downto 0):= "010";
  constant DATA  : std_logic_vector(2 downto 0):= "011"; 
  constant TERM  : std_logic_vector(2 downto 0):= "100";
  constant ERROR : std_logic_vector(2 downto 0):= "101";
  
  -- Block types
  constant T_SEQ   : std_logic_vector(2 downto 0) := "000";
  constant T_START : std_logic_vector(2 downto 0) := "001";
  constant T_DATA  : std_logic_vector(2 downto 0) := "011";
  constant T_TERM  : std_logic_vector(2 downto 0) := "010";
  constant T_ERROR : std_logic_vector(2 downto 0) := "100";
 
  signal visual_0_errd_blks : STD_LOGIC_VECTOR(7 downto 0 );--    ----- created for output which is read, or net with declaration delay.
 
  signal Current_state  : STD_LOGIC_VECTOR(2 downto 0 ) := INIT;
  signal Next_state     : STD_LOGIC_VECTOR(2 downto 0 );
  
  signal Code           : STD_LOGIC_VECTOR(63 downto 0 );
  signal next_Code      : STD_LOGIC_VECTOR(63 downto 0 );
  signal Control        : STD_LOGIC_VECTOR(7 downto 0 );
  signal next_control   : STD_LOGIC_VECTOR(7 downto 0 );
  signal next_TYPE      : STD_LOGIC_VECTOR(2 downto 0 );
  signal state_i        : std_logic_vector(2 downto 0 );

begin
 
  errd_blks <= visual_0_errd_blks;
 
  process (clk156, rstb156)
  begin
 
    if (rstb156 = '0') then
      rxlf <= transport '0';
    elsif (clk156'event and clk156 = '1') then
      if Current_state = INIT then
        rxlf <= transport '1';
      else
        rxlf <= transport '0';
      end if ;
    end if ;
  end process ;
  
 
  process (clk156)
  begin
    if (clk156'event and clk156 = '1') then

--      if (hi_ber = '1') and (lpbk = '0') then -- Won't work in Vivado (unable to generate...)
      if (hi_ber = '1')  then 
        if (lpbk = '0' ) then
          Code          <= transport X"0707070707070707"; -- IDLE
          Control       <= transport "11111111";
          next_TYPE     <= transport T_SEQ;
          next_Code     <= transport X"0707070707070707";
          next_control  <= transport "11111111";
          rxdata        <= transport X"000000000100009C";
          rxcontrol     <= transport "00000001";
        end if;
       end if;
--       else -- Won't work in Vivado
       if (hi_ber = '0') or (lpbk = '1') then 
         if (blk_lock = '0' ) and (lpbk = '0' ) then  --  For Encoder
            Code          <= transport X"0707070707070707";
            Control       <= transport "11111111";
            next_TYPE     <= transport T_SEQ;
            next_Code     <= transport X"0707070707070707";
            next_control  <= transport "11111111";
            rxdata        <= transport X"000000000100009C";
            rxcontrol     <= transport "00000001";
         else
          if (bypass_66decoder = '0') then
            Code          <= transport next_Code;
            Control       <= transport next_control;
            next_TYPE     <= transport R_TYPE;
            next_Code     <= transport rx_data;
            next_control  <= transport rx_control;
            if (current_state = ERROR) then -- if (Next_state = ERROR) then
              rxdata    <= transport X"FEFEFEFEFEFEFEFE";
              rxcontrol <= transport "11111111";
            else
              rxdata    <= transport Code;
              rxcontrol <= transport Control;
 
            end if ;


          else
            rxdata    <= transport DeScr_RXD(63 downto 0);
            rxcontrol <= transport "00000000";
 
          end if ;
        end if;
      end if ;
    end if ;
  end process ;
  
  
  process (clk156, rstb156)
  begin
    if (rstb156 = '0') then
      Current_state <= transport INIT;
    elsif (clk156'event and clk156 = '1') then
      if (hi_ber) = '1'  and (lpbk = '0' ) then
        Current_state <= transport INIT;
      else
        if (blk_lock = '0' ) and (lpbk = '0' ) then  --  For Encoder
          Current_state <= transport IDLE;
        else
          if (bypass_66decoder = '0') then
            Current_state <= transport Next_state;
          end if ;
        end if ;
      end if ;
    end if ;
  end process ;  
 
  process (clk156, rstb156)
  begin
 
    if (rstb156 = '0') then
      visual_0_errd_blks <= transport "00000000";
    elsif (clk156'event and clk156 = '1') then
      if ((bypass_66decoder = '0' )) and (((hi_ber = '0' ) or (lpbk) = '1' ))
         and (((blk_lock) = '1'  or (lpbk) = '1' )) then
        if (clear_errblk = '0') then
          if (current_state = ERROR) and (visual_0_errd_blks /= "11111111") then --((Next_state = ERROR) or (Next_state = SKIP)) and (visual_0_errd_blks /= "11111111") then
            visual_0_errd_blks <= transport ext(visual_0_errd_blks + 1,abs(7-0)+1);
          end if ;
 
        else
          visual_0_errd_blks <= transport "00000000";
        end if ;
 
      end if ;
    end if ;
  end process ;
 

  -- Note for next_state decoder: in this implementation, an DATA block preceded 
  -- by an ERROR state results in ERROR. (When an error occurs within a frame, 
  -- the whole frame until the TERM block is errored.) 
  -- This behaviour not IEEE compliant, but allows to deal with "data like" 
  -- patterns generated by the GTZ transceivers when the line is down. 
  -- This type of error is supposted to be an decode error (DEC_ERROR asserted)
  --
  next_state <= IDLE  when ((next_type = T_SEQ)   and (STATE_PREV = IDLE or STATE_PREV = TERM  or STATE_PREV = ERROR)) else -- 
                START when ((next_type = T_START) and (STATE_PREV = IDLE or STATE_PREV = TERM                       )) else
                DATA  when ((next_type = T_DATA)  and (STATE_PREV = START or STATE_PREV = DATA)) else -- or STATE_PREV = ERROR)) else
                TERM  when ((next_type = T_TERM)  and (STATE_PREV = DATA                       or STATE_PREV = ERROR)) else
                ERROR;
    
  state_i <= IDLE  when (next_type = T_SEQ) else
             START when (next_type = T_START) else -- (next_type = T_START) and (STATE_PREV /= ERROR) else
             DATA  when (next_type = T_DATA) and (STATE_PREV /= ERROR) else
             TERM  when (next_type = T_TERM) else
             ERROR;

  STATE_SIMPLIFIED_GEN: if (STATE_SIMPLIFIED = true) generate
    STATE     <= state_i;
  end generate;           


  STATE_NOT_SIMPLIFIED_GEN: if (STATE_SIMPLIFIED = false) generate
    STATE     <= next_state;
  end generate;           

  DEC_ERROR <= '1' when state_i = ERROR else '0';
  SEQ_ERROR <= '1' when ((((next_type = T_SEQ)   and (STATE_PREV /= IDLE  and STATE_PREV /= TERM)) or
                          ((next_type = T_START) and (STATE_PREV /= IDLE  and STATE_PREV /= TERM))) or
                         (((next_type = T_DATA)  and (STATE_PREV /= START and STATE_PREV /= DATA)) or
                          ((next_type = T_TERM)  and (STATE_PREV /= DATA)))) and (STATE_PREV /= ERROR)
               else '0';

  DEBUG_OUT: process(Current_state)
  begin
     case Current_state is
        when INIT   => STATE_O <= "000";
        when IDLE   => STATE_O <= "001";
        when DATA   => STATE_O <= "010";
        when TERM   => STATE_O <= "011";
        when ERROR  => STATE_O <= "100";
        when others => STATE_O <= "111";
     end case;
  end process;
 
end ;

