-- fb100g1_const.vhd : Package with constants for NetCOPE@FB1CG
--!
--! \file
--! \brief NetCOPE@FB1CG constants
--! \author Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--! \date 2014
--!
--! \section License
--!
--! Copyright (C) 2014 CESNET
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                            Package declaration
-- ----------------------------------------------------------------------------

package fb100g1_const is

--! NetCOPE version numbers
constant NETCOPE_MAJOR     : std_logic_vector(7 downto 0) := X"01";
constant NETCOPE_MINOR     : std_logic_vector(7 downto 0) := X"00";

--! PCIe BARs base addresses
constant BAR0_BASE_ADDR    : std_logic_vector := X"00000000";
constant BAR1_BASE_ADDR    : std_logic_vector := X"02000000";
constant BAR2_BASE_ADDR    : std_logic_vector := X"03000000";
constant BAR3_BASE_ADDR    : std_logic_vector := X"04000000";
constant BAR4_BASE_ADDR    : std_logic_vector := X"04000000";
constant BAR5_BASE_ADDR    : std_logic_vector := X"05000000";
constant EXP_ROM_BASE_ADDR : std_logic_vector := X"01000000";

--! Size of FIFO in AXI2MI component
constant AXI2MI_FIFO_SIZE  : integer := 16;

end package fb100g1_const;


-- ----------------------------------------------------------------------------
--                               Package body
-- ----------------------------------------------------------------------------

package body fb100g1_const is
end package body fb100g1_const;
