-- axi2mi_ent.vhd: AXI2MI - entity declaration
-- Copyright (C) 2013 CESNET
-- Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------

entity axi2mi is
   generic(
      -- BAR0 base address for PCIE->MI32 transalation
      BAR0_BASE_ADDR      : std_logic_vector(31 downto 0) := X"01000000";
      -- BAR1 base address for PCIE->MI32 transalation
      BAR1_BASE_ADDR      : std_logic_vector(31 downto 0) := X"02000000";
      -- BAR2 base address for PCIE->MI32 transalation
      BAR2_BASE_ADDR      : std_logic_vector(31 downto 0) := X"03000000";
      -- BAR3 base address for PCIE->MI32 transalation
      BAR3_BASE_ADDR      : std_logic_vector(31 downto 0) := X"04000000";
      -- BAR4 base address for PCIE->MI32 transalation
      BAR4_BASE_ADDR      : std_logic_vector(31 downto 0) := X"05000000";
      -- BAR5 base address for PCIE->MI32 transalation
      BAR5_BASE_ADDR      : std_logic_vector(31 downto 0) := X"06000000";
      -- Expansion ROM base address for PCIE->MI32 transalation
      EXP_ROM_BASE_ADDR   : std_logic_vector(31 downto 0) := X"0A000000";

      -- Number of items in FIFO for data read from FPGA
      FIFO_SIZE           : integer := 16;

      -- Pipe component on AXI interfaces (CQ, CC)
      AXI_PIPE            : boolean := true;
      -- Use output registers in AXI pipe components
      -- (applied only when AXI_PIPE = true)
      AXI_PIPE_USE_OUTREG : boolean := true;
      -- Pipe component on MI32 interface
      MI_PIPE             : boolean := true;
      -- Use output registers in MI pipe component
      -- (applied only when MI_PIPE = true)
      MI_PIPE_USE_OUTREG  : boolean := true
   );
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal
      CLK               : in std_logic;
      -- Synchronous reset
      RESET             : in  std_logic;

      -- Completer Request Interface (CQ) -------------------------------------
      -- Data bus
      CQ_DATA           : in std_logic_vector(255 downto 0);
      -- Set of signals with sideband information about trasferred transaction
      CQ_USER           : in std_logic_vector(84 downto 0);
      -- Indication of the last word of a transaction
      CQ_LAST           : in std_logic;
      -- Indication of valid data
      -- each bit determines validity of different Dword (1 Dword = 4 Bytes)
      CQ_KEEP           : in std_logic_vector(7 downto 0);
      -- Indication of valid data
      -- i.e. completer is ready to send a transaction
      CQ_VALID          : in std_logic;
      -- User application is ready to receive a transaction
      CQ_READY          : out std_logic;
      -- Request of Non-Posted transaction delivery
      CQ_NP_REQ         : out std_logic;
      -- Current number of credits for Non-Posted transactions
      CQ_NP_REQ_COUNT   : in std_logic_vector(5 downto 0);

      -- Completer Completion Interface (CC) ----------------------------------
      -- Data bus
      CC_DATA           : out std_logic_vector(255 downto 0);
      -- Set of signals with sideband information about trasferred transaction
      CC_USER           : out std_logic_vector(32 downto 0);
      -- Indication of the last word of a transaction
      CC_LAST           : out std_logic;
      -- Indication of valid data
      -- each bit determines validity of different Dword (1 Dword = 4 Bytes)
      CC_KEEP           : out std_logic_vector(7 downto 0);
      -- Indication of valid data
      -- i.e. user application is ready to send a transaction
      CC_VALID          : out std_logic;
      -- Completer is ready to receive a transaction
      CC_READY          : in std_logic;

      -- Configuration Status Interface ---------------------------------------
      -- Maximum allowed size of completion payload
      MAX_PAYLOAD_SIZE  : in std_logic_vector(2 downto 0);

      -- MI32 interface -------------------------------------------------------
      -- Output data
      MI_DWR            : out std_logic_vector(31 downto 0);
      -- Address bus
      MI_ADDR           : out std_logic_vector(31 downto 0);
      -- Byte enable signals      
      MI_BE             : out std_logic_vector(3 downto 0);
      -- Read request
      MI_RD             : out std_logic;
      -- Write request
      MI_WR             : out std_logic;
      -- Input data
      MI_DRD            : in  std_logic_vector(31 downto 0);
      -- Address ready
      MI_ARDY           : in  std_logic;
      -- Input data ready
      MI_DRDY           : in  std_logic
   );
end entity axi2mi;

