
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/filter_core_v1_0.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  set Component_Name  [  ipgui::add_param $IPINST -name "Component_Name" -display_name {Component Name}]
  set_property tooltip {Component Name} ${Component_Name}
  #Adding Page
  set Page_0  [  ipgui::add_page $IPINST -name "Page 0" -display_name {Page 0}]
  set_property tooltip {Page 0} ${Page_0}
  set HDR_WIDTH  [  ipgui::add_param $IPINST -name "HDR_WIDTH" -parent ${Page_0} -display_name {HDR_WIDTH}]
  set_property tooltip {HDR_WIDTH} ${HDR_WIDTH}
  set RULES_DATA_WIDTH  [  ipgui::add_param $IPINST -name "RULES_DATA_WIDTH" -parent ${Page_0} -display_name {RULES_DATA_WIDTH}]
  set_property tooltip {RULES_DATA_WIDTH} ${RULES_DATA_WIDTH}


}

proc update_PARAM_VALUE.RX_HDATA_WIDTH { PARAM_VALUE.RX_HDATA_WIDTH PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to update RX_HDATA_WIDTH when any of the dependent parameters in the arguments change
	
	set RX_HDATA_WIDTH ${PARAM_VALUE.RX_HDATA_WIDTH}
	set HDR_WIDTH ${PARAM_VALUE.HDR_WIDTH}
	set values(HDR_WIDTH) [get_property value $HDR_WIDTH]
	set_property value [gen_USERPARAMETER_RX_HDATA_WIDTH_VALUE $values(HDR_WIDTH)] $RX_HDATA_WIDTH
}

proc validate_PARAM_VALUE.RX_HDATA_WIDTH { PARAM_VALUE.RX_HDATA_WIDTH } {
	# Procedure called to validate RX_HDATA_WIDTH
	return true
}

proc update_PARAM_VALUE.RX_HREM_WIDTH { PARAM_VALUE.RX_HREM_WIDTH PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to update RX_HREM_WIDTH when any of the dependent parameters in the arguments change
	
	set RX_HREM_WIDTH ${PARAM_VALUE.RX_HREM_WIDTH}
	set HDR_WIDTH ${PARAM_VALUE.HDR_WIDTH}
	set values(HDR_WIDTH) [get_property value $HDR_WIDTH]
	set_property value [gen_USERPARAMETER_RX_HREM_WIDTH_VALUE $values(HDR_WIDTH)] $RX_HREM_WIDTH
}

proc validate_PARAM_VALUE.RX_HREM_WIDTH { PARAM_VALUE.RX_HREM_WIDTH } {
	# Procedure called to validate RX_HREM_WIDTH
	return true
}

proc update_PARAM_VALUE.RULES_DATA_WIDTH { PARAM_VALUE.RULES_DATA_WIDTH } {
	# Procedure called to update RULES_DATA_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.RULES_DATA_WIDTH { PARAM_VALUE.RULES_DATA_WIDTH } {
	# Procedure called to validate RULES_DATA_WIDTH
	return true
}

proc update_PARAM_VALUE.HEADER_FIFO_ITEMS { PARAM_VALUE.HEADER_FIFO_ITEMS } {
	# Procedure called to update HEADER_FIFO_ITEMS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.HEADER_FIFO_ITEMS { PARAM_VALUE.HEADER_FIFO_ITEMS } {
	# Procedure called to validate HEADER_FIFO_ITEMS
	return true
}

proc update_PARAM_VALUE.PACKET_FIFO_ITEMS { PARAM_VALUE.PACKET_FIFO_ITEMS } {
	# Procedure called to update PACKET_FIFO_ITEMS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.PACKET_FIFO_ITEMS { PARAM_VALUE.PACKET_FIFO_ITEMS } {
	# Procedure called to validate PACKET_FIFO_ITEMS
	return true
}

proc update_PARAM_VALUE.HDR_WIDTH { PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to update HDR_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.HDR_WIDTH { PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to validate HDR_WIDTH
	return true
}


proc update_MODELPARAM_VALUE.HDR_WIDTH { MODELPARAM_VALUE.HDR_WIDTH PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.HDR_WIDTH}] ${MODELPARAM_VALUE.HDR_WIDTH}
}

proc update_MODELPARAM_VALUE.PACKET_FIFO_ITEMS { MODELPARAM_VALUE.PACKET_FIFO_ITEMS PARAM_VALUE.PACKET_FIFO_ITEMS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.PACKET_FIFO_ITEMS}] ${MODELPARAM_VALUE.PACKET_FIFO_ITEMS}
}

proc update_MODELPARAM_VALUE.HEADER_FIFO_ITEMS { MODELPARAM_VALUE.HEADER_FIFO_ITEMS PARAM_VALUE.HEADER_FIFO_ITEMS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.HEADER_FIFO_ITEMS}] ${MODELPARAM_VALUE.HEADER_FIFO_ITEMS}
}

proc update_MODELPARAM_VALUE.RULES_DATA_WIDTH { MODELPARAM_VALUE.RULES_DATA_WIDTH PARAM_VALUE.RULES_DATA_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.RULES_DATA_WIDTH}] ${MODELPARAM_VALUE.RULES_DATA_WIDTH}
}

