-- crc16_296.vhd: A 16-bit CRC table for processing 296 bits in parallel
-- Copyright (C) 2012 Brno University of Technology
-- Author(s): Lukas Kekely <xkekel00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: crc16_296.vhd 4531 2013-12-20 16:29:12Z xkekel00 $
--
-- TODO:
--
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;
use WORK.math_pack.all;
-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity crc16_296 is
   port(
      DI    : in  std_logic_vector(296-1 downto 0);
      DO    : out std_logic_vector(15 downto 0)
   );
end entity;

-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ansi of crc16_296 is
begin
-- 16-bit CRC equations processing 296 bits in parallel (VHDL code)
-- Generator polynomial: 0x18005
   DO(0) <= DI(85) XOR DI(56) XOR DI(81) XOR DI(73) XOR DI(193) XOR DI(77) XOR DI(113) XOR DI(105) XOR DI(141) XOR DI(133) XOR DI(169) XOR DI(197) XOR DI(1) XOR DI(225) XOR DI(29) XOR DI(253) XOR DI(41) XOR DI(58) XOR DI(98) XOR DI(90) XOR DI(154) XOR DI(210) XOR DI(14) XOR DI(26) XOR DI(83) XOR DI(75) XOR DI(139) XOR DI(195) XOR DI(11) XOR DI(124) XOR DI(109) XOR DI(94) XOR DI(79) XOR DI(101) XOR DI(116) XOR DI(131) XOR DI(146) XOR DI(161) XOR DI(176) XOR DI(191) XOR DI(206) XOR DI(221) XOR DI(236) XOR DI(251) XOR DI(266) XOR DI(281) XOR DI(55) XOR DI(72) XOR DI(112) XOR DI(104) XOR DI(168) XOR DI(224) XOR DI(28) XOR DI(40) XOR DI(97) XOR DI(89) XOR DI(153) XOR DI(209) XOR DI(25) XOR DI(138) XOR DI(10) XOR DI(123) XOR DI(108) XOR DI(93) XOR DI(115) XOR DI(130) XOR DI(145) XOR DI(160) XOR DI(175) XOR DI(190) XOR DI(205) XOR DI(220) XOR DI(235) XOR DI(250) XOR DI(265) XOR DI(280) XOR DI(54) XOR DI(111) XOR DI(103) XOR DI(167) XOR DI(223) XOR DI(39) XOR DI(152) XOR DI(24) XOR DI(137) XOR DI(9) XOR DI(122) XOR DI(107) XOR DI(129) XOR DI(144) XOR DI(159) XOR DI(174) XOR DI(189) XOR DI(204) XOR DI(219) XOR DI(234) XOR DI(249) XOR DI(264) XOR DI(279) XOR DI(53) XOR DI(166) XOR DI(38) XOR DI(151) XOR DI(23) XOR DI(136) XOR DI(8) XOR DI(121) XOR DI(143) XOR DI(158) XOR DI(173) XOR DI(188) XOR DI(203) XOR DI(218) XOR DI(233) XOR DI(248) XOR DI(263) XOR DI(278) XOR DI(52) XOR DI(165) XOR DI(37) XOR DI(150) XOR DI(22) XOR DI(135) XOR DI(7) XOR DI(157) XOR DI(172) XOR DI(187) XOR DI(202) XOR DI(217) XOR DI(232) XOR DI(247) XOR DI(262) XOR DI(277) XOR DI(51) XOR DI(164) XOR DI(36) XOR DI(149) XOR DI(21) XOR DI(6) XOR DI(171) XOR DI(186) XOR DI(201) XOR DI(216) XOR DI(231) XOR DI(246) XOR DI(261) XOR DI(276) XOR DI(50) XOR DI(163) XOR DI(35) XOR DI(20) XOR DI(5) XOR DI(185) XOR DI(200) XOR DI(215) XOR DI(230) XOR DI(245) XOR DI(260) XOR DI(275) XOR DI(49) XOR DI(34) XOR DI(19) XOR DI(4) XOR DI(199) XOR DI(214) XOR DI(229) XOR DI(244) XOR DI(259) XOR DI(274) XOR DI(48) XOR DI(33) XOR DI(18) XOR DI(3) XOR DI(213) XOR DI(228) XOR DI(243) XOR DI(258) XOR DI(273) XOR DI(47) XOR DI(32) XOR DI(17) XOR DI(227) XOR DI(242) XOR DI(257) XOR DI(272) XOR DI(46) XOR DI(31) XOR DI(241) XOR DI(256) XOR DI(271) XOR DI(45) XOR DI(255) XOR DI(270) XOR DI(269) XOR DI(283) XOR DI(284) XOR DI(285) XOR DI(286) XOR DI(287) XOR DI(288) XOR DI(289) XOR DI(290) XOR DI(291) XOR DI(292) XOR DI(293) XOR DI(294) XOR DI(295);
   DO(1) <= DI(58) XOR DI(14) XOR DI(83) XOR DI(75) XOR DI(195) XOR DI(79) XOR DI(86) XOR DI(101) XOR DI(57) XOR DI(97) XOR DI(89) XOR DI(209) XOR DI(82) XOR DI(74) XOR DI(194) XOR DI(93) XOR DI(78) XOR DI(115) XOR DI(107) XOR DI(114) XOR DI(129) XOR DI(121) XOR DI(106) XOR DI(143) XOR DI(135) XOR DI(142) XOR DI(157) XOR DI(149) XOR DI(134) XOR DI(171) XOR DI(170) XOR DI(185) XOR DI(199) XOR DI(3) XOR DI(198) XOR DI(213) XOR DI(17) XOR DI(2) XOR DI(227) XOR DI(31) XOR DI(226) XOR DI(241) XOR DI(30) XOR DI(255) XOR DI(254) XOR DI(269) XOR DI(72) XOR DI(28) XOR DI(45) XOR DI(85) XOR DI(77) XOR DI(141) XOR DI(197) XOR DI(1) XOR DI(111) XOR DI(81) XOR DI(103) XOR DI(133) XOR DI(163) XOR DI(193) XOR DI(223) XOR DI(253) XOR DI(42) XOR DI(59) XOR DI(99) XOR DI(91) XOR DI(155) XOR DI(211) XOR DI(15) XOR DI(27) XOR DI(84) XOR DI(76) XOR DI(140) XOR DI(196) XOR DI(12) XOR DI(125) XOR DI(110) XOR DI(95) XOR DI(80) XOR DI(102) XOR DI(117) XOR DI(132) XOR DI(147) XOR DI(162) XOR DI(177) XOR DI(192) XOR DI(207) XOR DI(222) XOR DI(237) XOR DI(252) XOR DI(267) XOR DI(282) XOR DI(283);
   DO(2) <= DI(59) XOR DI(15) XOR DI(84) XOR DI(76) XOR DI(196) XOR DI(0) XOR DI(80) XOR DI(87) XOR DI(102) XOR DI(58) XOR DI(98) XOR DI(90) XOR DI(210) XOR DI(83) XOR DI(75) XOR DI(195) XOR DI(94) XOR DI(79) XOR DI(116) XOR DI(108) XOR DI(115) XOR DI(130) XOR DI(122) XOR DI(107) XOR DI(144) XOR DI(136) XOR DI(143) XOR DI(158) XOR DI(150) XOR DI(135) XOR DI(172) XOR DI(171) XOR DI(186) XOR DI(200) XOR DI(4) XOR DI(199) XOR DI(214) XOR DI(18) XOR DI(3) XOR DI(228) XOR DI(32) XOR DI(227) XOR DI(242) XOR DI(31) XOR DI(256) XOR DI(255) XOR DI(270) XOR DI(73) XOR DI(29) XOR DI(46) XOR DI(86) XOR DI(78) XOR DI(142) XOR DI(198) XOR DI(2) XOR DI(112) XOR DI(82) XOR DI(104) XOR DI(134) XOR DI(164) XOR DI(194) XOR DI(224) XOR DI(254) XOR DI(43) XOR DI(60) XOR DI(100) XOR DI(92) XOR DI(156) XOR DI(212) XOR DI(16) XOR DI(28) XOR DI(85) XOR DI(77) XOR DI(141) XOR DI(197) XOR DI(13) XOR DI(126) XOR DI(111) XOR DI(96) XOR DI(81) XOR DI(103) XOR DI(118) XOR DI(133) XOR DI(148) XOR DI(163) XOR DI(178) XOR DI(193) XOR DI(208) XOR DI(223) XOR DI(238) XOR DI(253) XOR DI(268) XOR DI(283) XOR DI(284);
   DO(3) <= DI(60) XOR DI(16) XOR DI(85) XOR DI(77) XOR DI(197) XOR DI(1) XOR DI(81) XOR DI(88) XOR DI(103) XOR DI(59) XOR DI(99) XOR DI(91) XOR DI(211) XOR DI(84) XOR DI(76) XOR DI(196) XOR DI(95) XOR DI(80) XOR DI(117) XOR DI(109) XOR DI(116) XOR DI(131) XOR DI(123) XOR DI(108) XOR DI(145) XOR DI(137) XOR DI(144) XOR DI(159) XOR DI(151) XOR DI(136) XOR DI(173) XOR DI(172) XOR DI(187) XOR DI(201) XOR DI(5) XOR DI(200) XOR DI(215) XOR DI(19) XOR DI(4) XOR DI(229) XOR DI(33) XOR DI(228) XOR DI(243) XOR DI(32) XOR DI(257) XOR DI(256) XOR DI(271) XOR DI(74) XOR DI(30) XOR DI(47) XOR DI(87) XOR DI(79) XOR DI(143) XOR DI(199) XOR DI(3) XOR DI(0) XOR DI(113) XOR DI(83) XOR DI(105) XOR DI(135) XOR DI(165) XOR DI(195) XOR DI(225) XOR DI(255) XOR DI(44) XOR DI(61) XOR DI(101) XOR DI(93) XOR DI(157) XOR DI(213) XOR DI(17) XOR DI(29) XOR DI(86) XOR DI(78) XOR DI(142) XOR DI(198) XOR DI(14) XOR DI(127) XOR DI(112) XOR DI(97) XOR DI(82) XOR DI(104) XOR DI(119) XOR DI(134) XOR DI(149) XOR DI(164) XOR DI(179) XOR DI(194) XOR DI(209) XOR DI(224) XOR DI(239) XOR DI(254) XOR DI(269) XOR DI(284) XOR DI(285);
   DO(4) <= DI(61) XOR DI(17) XOR DI(86) XOR DI(78) XOR DI(198) XOR DI(2) XOR DI(82) XOR DI(89) XOR DI(104) XOR DI(60) XOR DI(100) XOR DI(92) XOR DI(212) XOR DI(85) XOR DI(77) XOR DI(197) XOR DI(96) XOR DI(81) XOR DI(118) XOR DI(110) XOR DI(117) XOR DI(132) XOR DI(124) XOR DI(109) XOR DI(146) XOR DI(138) XOR DI(145) XOR DI(160) XOR DI(152) XOR DI(137) XOR DI(174) XOR DI(173) XOR DI(188) XOR DI(202) XOR DI(6) XOR DI(201) XOR DI(216) XOR DI(20) XOR DI(5) XOR DI(230) XOR DI(34) XOR DI(229) XOR DI(244) XOR DI(33) XOR DI(258) XOR DI(257) XOR DI(272) XOR DI(75) XOR DI(31) XOR DI(48) XOR DI(88) XOR DI(80) XOR DI(144) XOR DI(200) XOR DI(4) XOR DI(1) XOR DI(114) XOR DI(84) XOR DI(106) XOR DI(136) XOR DI(166) XOR DI(196) XOR DI(226) XOR DI(256) XOR DI(45) XOR DI(62) XOR DI(102) XOR DI(94) XOR DI(158) XOR DI(214) XOR DI(18) XOR DI(30) XOR DI(87) XOR DI(79) XOR DI(143) XOR DI(199) XOR DI(15) XOR DI(128) XOR DI(0) XOR DI(113) XOR DI(98) XOR DI(83) XOR DI(105) XOR DI(120) XOR DI(135) XOR DI(150) XOR DI(165) XOR DI(180) XOR DI(195) XOR DI(210) XOR DI(225) XOR DI(240) XOR DI(255) XOR DI(270) XOR DI(285) XOR DI(286);
   DO(5) <= DI(62) XOR DI(18) XOR DI(87) XOR DI(79) XOR DI(199) XOR DI(3) XOR DI(83) XOR DI(90) XOR DI(105) XOR DI(61) XOR DI(101) XOR DI(93) XOR DI(213) XOR DI(86) XOR DI(78) XOR DI(198) XOR DI(97) XOR DI(82) XOR DI(119) XOR DI(111) XOR DI(118) XOR DI(133) XOR DI(125) XOR DI(110) XOR DI(147) XOR DI(139) XOR DI(146) XOR DI(161) XOR DI(153) XOR DI(138) XOR DI(175) XOR DI(174) XOR DI(189) XOR DI(203) XOR DI(7) XOR DI(202) XOR DI(217) XOR DI(21) XOR DI(6) XOR DI(231) XOR DI(35) XOR DI(230) XOR DI(245) XOR DI(34) XOR DI(259) XOR DI(258) XOR DI(273) XOR DI(76) XOR DI(32) XOR DI(49) XOR DI(89) XOR DI(81) XOR DI(145) XOR DI(201) XOR DI(5) XOR DI(2) XOR DI(115) XOR DI(85) XOR DI(107) XOR DI(137) XOR DI(167) XOR DI(197) XOR DI(227) XOR DI(257) XOR DI(46) XOR DI(63) XOR DI(103) XOR DI(95) XOR DI(159) XOR DI(215) XOR DI(19) XOR DI(31) XOR DI(88) XOR DI(80) XOR DI(144) XOR DI(200) XOR DI(16) XOR DI(129) XOR DI(1) XOR DI(114) XOR DI(99) XOR DI(84) XOR DI(106) XOR DI(121) XOR DI(136) XOR DI(151) XOR DI(166) XOR DI(181) XOR DI(196) XOR DI(211) XOR DI(226) XOR DI(241) XOR DI(256) XOR DI(271) XOR DI(286) XOR DI(287);
   DO(6) <= DI(63) XOR DI(19) XOR DI(88) XOR DI(80) XOR DI(200) XOR DI(4) XOR DI(84) XOR DI(91) XOR DI(106) XOR DI(62) XOR DI(102) XOR DI(94) XOR DI(214) XOR DI(87) XOR DI(79) XOR DI(199) XOR DI(98) XOR DI(83) XOR DI(120) XOR DI(112) XOR DI(119) XOR DI(134) XOR DI(126) XOR DI(111) XOR DI(148) XOR DI(140) XOR DI(147) XOR DI(162) XOR DI(154) XOR DI(139) XOR DI(176) XOR DI(175) XOR DI(190) XOR DI(204) XOR DI(8) XOR DI(203) XOR DI(218) XOR DI(22) XOR DI(7) XOR DI(232) XOR DI(36) XOR DI(231) XOR DI(246) XOR DI(35) XOR DI(260) XOR DI(259) XOR DI(274) XOR DI(77) XOR DI(33) XOR DI(50) XOR DI(90) XOR DI(82) XOR DI(146) XOR DI(202) XOR DI(6) XOR DI(3) XOR DI(116) XOR DI(86) XOR DI(108) XOR DI(138) XOR DI(168) XOR DI(198) XOR DI(228) XOR DI(258) XOR DI(47) XOR DI(64) XOR DI(104) XOR DI(96) XOR DI(160) XOR DI(216) XOR DI(20) XOR DI(32) XOR DI(89) XOR DI(81) XOR DI(145) XOR DI(201) XOR DI(17) XOR DI(130) XOR DI(2) XOR DI(115) XOR DI(100) XOR DI(85) XOR DI(107) XOR DI(122) XOR DI(137) XOR DI(152) XOR DI(167) XOR DI(182) XOR DI(197) XOR DI(212) XOR DI(227) XOR DI(242) XOR DI(257) XOR DI(272) XOR DI(287) XOR DI(288);
   DO(7) <= DI(64) XOR DI(20) XOR DI(89) XOR DI(81) XOR DI(201) XOR DI(5) XOR DI(85) XOR DI(92) XOR DI(107) XOR DI(63) XOR DI(103) XOR DI(95) XOR DI(215) XOR DI(88) XOR DI(80) XOR DI(200) XOR DI(99) XOR DI(84) XOR DI(121) XOR DI(113) XOR DI(120) XOR DI(135) XOR DI(127) XOR DI(112) XOR DI(149) XOR DI(141) XOR DI(148) XOR DI(163) XOR DI(155) XOR DI(140) XOR DI(177) XOR DI(176) XOR DI(191) XOR DI(205) XOR DI(9) XOR DI(204) XOR DI(219) XOR DI(23) XOR DI(8) XOR DI(233) XOR DI(37) XOR DI(232) XOR DI(247) XOR DI(36) XOR DI(261) XOR DI(260) XOR DI(275) XOR DI(78) XOR DI(34) XOR DI(51) XOR DI(91) XOR DI(83) XOR DI(147) XOR DI(203) XOR DI(7) XOR DI(4) XOR DI(117) XOR DI(87) XOR DI(109) XOR DI(139) XOR DI(169) XOR DI(199) XOR DI(229) XOR DI(259) XOR DI(48) XOR DI(65) XOR DI(105) XOR DI(97) XOR DI(161) XOR DI(217) XOR DI(21) XOR DI(33) XOR DI(90) XOR DI(82) XOR DI(146) XOR DI(202) XOR DI(18) XOR DI(131) XOR DI(3) XOR DI(116) XOR DI(101) XOR DI(86) XOR DI(108) XOR DI(123) XOR DI(138) XOR DI(153) XOR DI(168) XOR DI(183) XOR DI(198) XOR DI(213) XOR DI(228) XOR DI(243) XOR DI(258) XOR DI(273) XOR DI(288) XOR DI(289);
   DO(8) <= DI(65) XOR DI(21) XOR DI(90) XOR DI(82) XOR DI(202) XOR DI(6) XOR DI(86) XOR DI(93) XOR DI(108) XOR DI(64) XOR DI(104) XOR DI(96) XOR DI(216) XOR DI(89) XOR DI(81) XOR DI(201) XOR DI(100) XOR DI(85) XOR DI(122) XOR DI(114) XOR DI(121) XOR DI(136) XOR DI(128) XOR DI(113) XOR DI(150) XOR DI(142) XOR DI(149) XOR DI(164) XOR DI(156) XOR DI(141) XOR DI(178) XOR DI(177) XOR DI(192) XOR DI(206) XOR DI(10) XOR DI(205) XOR DI(220) XOR DI(24) XOR DI(9) XOR DI(234) XOR DI(38) XOR DI(233) XOR DI(248) XOR DI(37) XOR DI(262) XOR DI(261) XOR DI(276) XOR DI(79) XOR DI(35) XOR DI(52) XOR DI(92) XOR DI(84) XOR DI(148) XOR DI(204) XOR DI(8) XOR DI(5) XOR DI(118) XOR DI(88) XOR DI(110) XOR DI(140) XOR DI(170) XOR DI(200) XOR DI(230) XOR DI(260) XOR DI(49) XOR DI(66) XOR DI(106) XOR DI(98) XOR DI(162) XOR DI(218) XOR DI(22) XOR DI(34) XOR DI(91) XOR DI(83) XOR DI(147) XOR DI(203) XOR DI(19) XOR DI(132) XOR DI(4) XOR DI(117) XOR DI(102) XOR DI(87) XOR DI(109) XOR DI(124) XOR DI(139) XOR DI(154) XOR DI(169) XOR DI(184) XOR DI(199) XOR DI(214) XOR DI(229) XOR DI(244) XOR DI(259) XOR DI(274) XOR DI(289) XOR DI(290);
   DO(9) <= DI(66) XOR DI(22) XOR DI(91) XOR DI(83) XOR DI(203) XOR DI(7) XOR DI(87) XOR DI(94) XOR DI(109) XOR DI(65) XOR DI(105) XOR DI(97) XOR DI(217) XOR DI(90) XOR DI(82) XOR DI(202) XOR DI(101) XOR DI(86) XOR DI(123) XOR DI(115) XOR DI(122) XOR DI(137) XOR DI(129) XOR DI(114) XOR DI(151) XOR DI(143) XOR DI(150) XOR DI(165) XOR DI(157) XOR DI(142) XOR DI(179) XOR DI(178) XOR DI(193) XOR DI(207) XOR DI(11) XOR DI(206) XOR DI(221) XOR DI(25) XOR DI(10) XOR DI(235) XOR DI(39) XOR DI(234) XOR DI(249) XOR DI(38) XOR DI(263) XOR DI(262) XOR DI(277) XOR DI(80) XOR DI(36) XOR DI(53) XOR DI(93) XOR DI(85) XOR DI(149) XOR DI(205) XOR DI(9) XOR DI(6) XOR DI(119) XOR DI(89) XOR DI(111) XOR DI(141) XOR DI(171) XOR DI(201) XOR DI(231) XOR DI(261) XOR DI(50) XOR DI(67) XOR DI(107) XOR DI(99) XOR DI(163) XOR DI(219) XOR DI(23) XOR DI(35) XOR DI(92) XOR DI(84) XOR DI(148) XOR DI(204) XOR DI(20) XOR DI(133) XOR DI(5) XOR DI(118) XOR DI(103) XOR DI(88) XOR DI(110) XOR DI(125) XOR DI(140) XOR DI(155) XOR DI(170) XOR DI(185) XOR DI(200) XOR DI(215) XOR DI(230) XOR DI(245) XOR DI(260) XOR DI(275) XOR DI(290) XOR DI(291);
   DO(10) <= DI(67) XOR DI(23) XOR DI(92) XOR DI(84) XOR DI(204) XOR DI(8) XOR DI(88) XOR DI(95) XOR DI(110) XOR DI(66) XOR DI(106) XOR DI(98) XOR DI(218) XOR DI(91) XOR DI(83) XOR DI(203) XOR DI(102) XOR DI(87) XOR DI(124) XOR DI(116) XOR DI(123) XOR DI(138) XOR DI(130) XOR DI(115) XOR DI(152) XOR DI(144) XOR DI(151) XOR DI(166) XOR DI(158) XOR DI(143) XOR DI(180) XOR DI(179) XOR DI(194) XOR DI(208) XOR DI(12) XOR DI(207) XOR DI(222) XOR DI(26) XOR DI(11) XOR DI(236) XOR DI(40) XOR DI(235) XOR DI(250) XOR DI(39) XOR DI(264) XOR DI(263) XOR DI(278) XOR DI(81) XOR DI(37) XOR DI(54) XOR DI(94) XOR DI(86) XOR DI(150) XOR DI(206) XOR DI(10) XOR DI(7) XOR DI(120) XOR DI(90) XOR DI(112) XOR DI(142) XOR DI(172) XOR DI(202) XOR DI(232) XOR DI(262) XOR DI(51) XOR DI(68) XOR DI(108) XOR DI(100) XOR DI(164) XOR DI(220) XOR DI(24) XOR DI(36) XOR DI(93) XOR DI(85) XOR DI(149) XOR DI(205) XOR DI(21) XOR DI(134) XOR DI(6) XOR DI(119) XOR DI(104) XOR DI(89) XOR DI(111) XOR DI(126) XOR DI(141) XOR DI(156) XOR DI(171) XOR DI(186) XOR DI(201) XOR DI(216) XOR DI(231) XOR DI(246) XOR DI(261) XOR DI(276) XOR DI(291) XOR DI(292);
   DO(11) <= DI(68) XOR DI(24) XOR DI(93) XOR DI(85) XOR DI(205) XOR DI(9) XOR DI(89) XOR DI(96) XOR DI(111) XOR DI(67) XOR DI(107) XOR DI(99) XOR DI(219) XOR DI(92) XOR DI(84) XOR DI(204) XOR DI(103) XOR DI(88) XOR DI(125) XOR DI(117) XOR DI(124) XOR DI(139) XOR DI(131) XOR DI(116) XOR DI(153) XOR DI(145) XOR DI(152) XOR DI(167) XOR DI(159) XOR DI(144) XOR DI(181) XOR DI(180) XOR DI(195) XOR DI(209) XOR DI(13) XOR DI(208) XOR DI(223) XOR DI(27) XOR DI(12) XOR DI(237) XOR DI(41) XOR DI(236) XOR DI(251) XOR DI(40) XOR DI(265) XOR DI(264) XOR DI(279) XOR DI(82) XOR DI(38) XOR DI(55) XOR DI(95) XOR DI(87) XOR DI(151) XOR DI(207) XOR DI(11) XOR DI(8) XOR DI(121) XOR DI(91) XOR DI(113) XOR DI(143) XOR DI(173) XOR DI(203) XOR DI(233) XOR DI(263) XOR DI(52) XOR DI(69) XOR DI(109) XOR DI(101) XOR DI(165) XOR DI(221) XOR DI(25) XOR DI(37) XOR DI(94) XOR DI(86) XOR DI(150) XOR DI(206) XOR DI(22) XOR DI(135) XOR DI(7) XOR DI(120) XOR DI(105) XOR DI(90) XOR DI(112) XOR DI(127) XOR DI(142) XOR DI(157) XOR DI(172) XOR DI(187) XOR DI(202) XOR DI(217) XOR DI(232) XOR DI(247) XOR DI(262) XOR DI(277) XOR DI(292) XOR DI(293);
   DO(12) <= DI(69) XOR DI(25) XOR DI(94) XOR DI(86) XOR DI(206) XOR DI(10) XOR DI(90) XOR DI(97) XOR DI(112) XOR DI(68) XOR DI(108) XOR DI(100) XOR DI(220) XOR DI(93) XOR DI(85) XOR DI(205) XOR DI(104) XOR DI(89) XOR DI(126) XOR DI(118) XOR DI(125) XOR DI(140) XOR DI(132) XOR DI(117) XOR DI(154) XOR DI(146) XOR DI(153) XOR DI(168) XOR DI(160) XOR DI(145) XOR DI(182) XOR DI(181) XOR DI(196) XOR DI(0) XOR DI(210) XOR DI(14) XOR DI(209) XOR DI(224) XOR DI(28) XOR DI(13) XOR DI(238) XOR DI(42) XOR DI(237) XOR DI(252) XOR DI(41) XOR DI(266) XOR DI(265) XOR DI(280) XOR DI(83) XOR DI(39) XOR DI(56) XOR DI(96) XOR DI(88) XOR DI(152) XOR DI(208) XOR DI(12) XOR DI(9) XOR DI(122) XOR DI(92) XOR DI(114) XOR DI(144) XOR DI(174) XOR DI(204) XOR DI(234) XOR DI(264) XOR DI(53) XOR DI(70) XOR DI(110) XOR DI(102) XOR DI(166) XOR DI(222) XOR DI(26) XOR DI(38) XOR DI(95) XOR DI(87) XOR DI(151) XOR DI(207) XOR DI(23) XOR DI(136) XOR DI(8) XOR DI(121) XOR DI(106) XOR DI(91) XOR DI(113) XOR DI(128) XOR DI(143) XOR DI(158) XOR DI(173) XOR DI(188) XOR DI(203) XOR DI(218) XOR DI(233) XOR DI(248) XOR DI(263) XOR DI(278) XOR DI(293) XOR DI(294);
   DO(13) <= DI(70) XOR DI(26) XOR DI(95) XOR DI(87) XOR DI(207) XOR DI(11) XOR DI(91) XOR DI(98) XOR DI(113) XOR DI(69) XOR DI(109) XOR DI(101) XOR DI(221) XOR DI(94) XOR DI(86) XOR DI(206) XOR DI(105) XOR DI(90) XOR DI(127) XOR DI(119) XOR DI(126) XOR DI(141) XOR DI(133) XOR DI(118) XOR DI(155) XOR DI(147) XOR DI(154) XOR DI(169) XOR DI(161) XOR DI(146) XOR DI(183) XOR DI(182) XOR DI(197) XOR DI(1) XOR DI(211) XOR DI(15) XOR DI(210) XOR DI(225) XOR DI(29) XOR DI(14) XOR DI(239) XOR DI(43) XOR DI(238) XOR DI(253) XOR DI(42) XOR DI(267) XOR DI(266) XOR DI(281) XOR DI(84) XOR DI(40) XOR DI(57) XOR DI(97) XOR DI(89) XOR DI(153) XOR DI(209) XOR DI(13) XOR DI(10) XOR DI(123) XOR DI(93) XOR DI(115) XOR DI(145) XOR DI(175) XOR DI(205) XOR DI(235) XOR DI(265) XOR DI(54) XOR DI(71) XOR DI(111) XOR DI(103) XOR DI(167) XOR DI(223) XOR DI(27) XOR DI(39) XOR DI(96) XOR DI(88) XOR DI(152) XOR DI(208) XOR DI(24) XOR DI(137) XOR DI(9) XOR DI(122) XOR DI(107) XOR DI(92) XOR DI(114) XOR DI(129) XOR DI(144) XOR DI(159) XOR DI(174) XOR DI(189) XOR DI(204) XOR DI(219) XOR DI(234) XOR DI(249) XOR DI(264) XOR DI(279) XOR DI(294) XOR DI(295);
   DO(14) <= DI(83) XOR DI(54) XOR DI(79) XOR DI(71) XOR DI(191) XOR DI(75) XOR DI(111) XOR DI(103) XOR DI(139) XOR DI(131) XOR DI(167) XOR DI(195) XOR DI(223) XOR DI(27) XOR DI(251) XOR DI(39) XOR DI(56) XOR DI(96) XOR DI(88) XOR DI(152) XOR DI(208) XOR DI(12) XOR DI(24) XOR DI(81) XOR DI(73) XOR DI(137) XOR DI(193) XOR DI(9) XOR DI(122) XOR DI(107) XOR DI(92) XOR DI(77) XOR DI(99) XOR DI(114) XOR DI(129) XOR DI(144) XOR DI(159) XOR DI(174) XOR DI(189) XOR DI(204) XOR DI(219) XOR DI(234) XOR DI(249) XOR DI(264) XOR DI(279) XOR DI(53) XOR DI(70) XOR DI(110) XOR DI(102) XOR DI(166) XOR DI(222) XOR DI(26) XOR DI(38) XOR DI(95) XOR DI(87) XOR DI(151) XOR DI(207) XOR DI(23) XOR DI(136) XOR DI(8) XOR DI(121) XOR DI(106) XOR DI(91) XOR DI(113) XOR DI(128) XOR DI(143) XOR DI(158) XOR DI(173) XOR DI(188) XOR DI(203) XOR DI(218) XOR DI(233) XOR DI(248) XOR DI(263) XOR DI(278) XOR DI(52) XOR DI(109) XOR DI(101) XOR DI(165) XOR DI(221) XOR DI(37) XOR DI(150) XOR DI(22) XOR DI(135) XOR DI(7) XOR DI(120) XOR DI(105) XOR DI(127) XOR DI(142) XOR DI(157) XOR DI(172) XOR DI(187) XOR DI(202) XOR DI(217) XOR DI(232) XOR DI(247) XOR DI(262) XOR DI(277) XOR DI(51) XOR DI(164) XOR DI(36) XOR DI(149) XOR DI(21) XOR DI(134) XOR DI(6) XOR DI(119) XOR DI(141) XOR DI(156) XOR DI(171) XOR DI(186) XOR DI(201) XOR DI(216) XOR DI(231) XOR DI(246) XOR DI(261) XOR DI(276) XOR DI(50) XOR DI(163) XOR DI(35) XOR DI(148) XOR DI(20) XOR DI(133) XOR DI(5) XOR DI(155) XOR DI(170) XOR DI(185) XOR DI(200) XOR DI(215) XOR DI(230) XOR DI(245) XOR DI(260) XOR DI(275) XOR DI(49) XOR DI(162) XOR DI(34) XOR DI(147) XOR DI(19) XOR DI(4) XOR DI(169) XOR DI(184) XOR DI(199) XOR DI(214) XOR DI(229) XOR DI(244) XOR DI(259) XOR DI(274) XOR DI(48) XOR DI(161) XOR DI(33) XOR DI(18) XOR DI(3) XOR DI(183) XOR DI(198) XOR DI(213) XOR DI(228) XOR DI(243) XOR DI(258) XOR DI(273) XOR DI(47) XOR DI(32) XOR DI(17) XOR DI(2) XOR DI(197) XOR DI(212) XOR DI(227) XOR DI(242) XOR DI(257) XOR DI(272) XOR DI(46) XOR DI(31) XOR DI(16) XOR DI(1) XOR DI(211) XOR DI(226) XOR DI(241) XOR DI(256) XOR DI(271) XOR DI(45) XOR DI(30) XOR DI(15) XOR DI(225) XOR DI(240) XOR DI(255) XOR DI(270) XOR DI(44) XOR DI(29) XOR DI(239) XOR DI(254) XOR DI(269) XOR DI(43) XOR DI(253) XOR DI(268) XOR DI(267) XOR DI(281) XOR DI(282) XOR DI(283) XOR DI(284) XOR DI(285) XOR DI(286) XOR DI(287) XOR DI(288) XOR DI(289) XOR DI(290) XOR DI(291) XOR DI(292) XOR DI(293) XOR DI(294);
   DO(15) <= DI(84) XOR DI(55) XOR DI(80) XOR DI(72) XOR DI(192) XOR DI(76) XOR DI(112) XOR DI(104) XOR DI(140) XOR DI(132) XOR DI(168) XOR DI(196) XOR DI(0) XOR DI(224) XOR DI(28) XOR DI(252) XOR DI(40) XOR DI(57) XOR DI(97) XOR DI(89) XOR DI(153) XOR DI(209) XOR DI(13) XOR DI(25) XOR DI(82) XOR DI(74) XOR DI(138) XOR DI(194) XOR DI(10) XOR DI(123) XOR DI(108) XOR DI(93) XOR DI(78) XOR DI(100) XOR DI(115) XOR DI(130) XOR DI(145) XOR DI(160) XOR DI(175) XOR DI(190) XOR DI(205) XOR DI(220) XOR DI(235) XOR DI(250) XOR DI(265) XOR DI(280) XOR DI(54) XOR DI(71) XOR DI(111) XOR DI(103) XOR DI(167) XOR DI(223) XOR DI(27) XOR DI(39) XOR DI(96) XOR DI(88) XOR DI(152) XOR DI(208) XOR DI(24) XOR DI(137) XOR DI(9) XOR DI(122) XOR DI(107) XOR DI(92) XOR DI(114) XOR DI(129) XOR DI(144) XOR DI(159) XOR DI(174) XOR DI(189) XOR DI(204) XOR DI(219) XOR DI(234) XOR DI(249) XOR DI(264) XOR DI(279) XOR DI(53) XOR DI(110) XOR DI(102) XOR DI(166) XOR DI(222) XOR DI(38) XOR DI(151) XOR DI(23) XOR DI(136) XOR DI(8) XOR DI(121) XOR DI(106) XOR DI(128) XOR DI(143) XOR DI(158) XOR DI(173) XOR DI(188) XOR DI(203) XOR DI(218) XOR DI(233) XOR DI(248) XOR DI(263) XOR DI(278) XOR DI(52) XOR DI(165) XOR DI(37) XOR DI(150) XOR DI(22) XOR DI(135) XOR DI(7) XOR DI(120) XOR DI(142) XOR DI(157) XOR DI(172) XOR DI(187) XOR DI(202) XOR DI(217) XOR DI(232) XOR DI(247) XOR DI(262) XOR DI(277) XOR DI(51) XOR DI(164) XOR DI(36) XOR DI(149) XOR DI(21) XOR DI(134) XOR DI(6) XOR DI(156) XOR DI(171) XOR DI(186) XOR DI(201) XOR DI(216) XOR DI(231) XOR DI(246) XOR DI(261) XOR DI(276) XOR DI(50) XOR DI(163) XOR DI(35) XOR DI(148) XOR DI(20) XOR DI(5) XOR DI(170) XOR DI(185) XOR DI(200) XOR DI(215) XOR DI(230) XOR DI(245) XOR DI(260) XOR DI(275) XOR DI(49) XOR DI(162) XOR DI(34) XOR DI(19) XOR DI(4) XOR DI(184) XOR DI(199) XOR DI(214) XOR DI(229) XOR DI(244) XOR DI(259) XOR DI(274) XOR DI(48) XOR DI(33) XOR DI(18) XOR DI(3) XOR DI(198) XOR DI(213) XOR DI(228) XOR DI(243) XOR DI(258) XOR DI(273) XOR DI(47) XOR DI(32) XOR DI(17) XOR DI(2) XOR DI(212) XOR DI(227) XOR DI(242) XOR DI(257) XOR DI(272) XOR DI(46) XOR DI(31) XOR DI(16) XOR DI(226) XOR DI(241) XOR DI(256) XOR DI(271) XOR DI(45) XOR DI(30) XOR DI(240) XOR DI(255) XOR DI(270) XOR DI(44) XOR DI(254) XOR DI(269) XOR DI(268) XOR DI(282) XOR DI(283) XOR DI(284) XOR DI(285) XOR DI(286) XOR DI(287) XOR DI(288) XOR DI(289) XOR DI(290) XOR DI(291) XOR DI(292) XOR DI(293) XOR DI(294) XOR DI(295);
     
end architecture;




-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ccitt of crc16_296 is
begin
-- 16-bit CRC equations processing 296 bits in parallel (VHDL code)
-- Generator polynomial: 0x11021
   DO(0) <= DI(200) XOR DI(216) XOR DI(157) XOR DI(231) XOR DI(198) XOR DI(74) XOR DI(245) XOR DI(232) XOR DI(238) XOR DI(34) XOR DI(77) XOR DI(173) XOR DI(16) XOR DI(68) XOR DI(247) XOR DI(96) XOR DI(43) XOR DI(214) XOR DI(159) XOR DI(90) XOR DI(261) XOR DI(269) XOR DI(118) XOR DI(6) XOR DI(248) XOR DI(254) XOR DI(138) XOR DI(125) XOR DI(192) XOR DI(50) XOR DI(135) XOR DI(224) XOR DI(26) XOR DI(8) XOR DI(49) XOR DI(93) XOR DI(132) XOR DI(268) XOR DI(276) XOR DI(189) XOR DI(187) XOR DI(221) XOR DI(32) XOR DI(181) XOR DI(82) XOR DI(178) XOR DI(21) XOR DI(71) XOR DI(84) XOR DI(263) XOR DI(190) XOR DI(219) XOR DI(112) XOR DI(164) XOR DI(95) XOR DI(274) XOR DI(201) XOR DI(59) XOR DI(230) XOR DI(158) XOR DI(233) XOR DI(123) XOR DI(120) XOR DI(11) XOR DI(56) XOR DI(175) XOR DI(44) XOR DI(106) XOR DI(31) XOR DI(13) XOR DI(145) XOR DI(126) XOR DI(277) XOR DI(285) XOR DI(212) XOR DI(153) XOR DI(70) XOR DI(241) XOR DI(73) XOR DI(169) XOR DI(64) XOR DI(39) XOR DI(210) XOR DI(155) XOR DI(244) XOR DI(134) XOR DI(121) XOR DI(188) XOR DI(46) XOR DI(131) XOR DI(22) XOR DI(4) XOR DI(89) XOR DI(264) XOR DI(183) XOR DI(28) XOR DI(67) XOR DI(186) XOR DI(215) XOR DI(108) XOR DI(160) XOR DI(270) XOR DI(55) XOR DI(226) XOR DI(154) XOR DI(229) XOR DI(7) XOR DI(102) XOR DI(9) XOR DI(141) XOR DI(208) XOR DI(66) XOR DI(69) XOR DI(151) XOR DI(240) XOR DI(117) XOR DI(42) XOR DI(0) XOR DI(24) XOR DI(156) XOR DI(222) XOR DI(150) XOR DI(3) XOR DI(5) XOR DI(137) XOR DI(65) XOR DI(113) XOR DI(152) XOR DI(1) XOR DI(109) XOR DI(148) XOR DI(144) XOR DI(140) XOR DI(284) XOR DI(288) XOR DI(292);
   DO(1) <= DI(201) XOR DI(217) XOR DI(158) XOR DI(232) XOR DI(199) XOR DI(75) XOR DI(246) XOR DI(233) XOR DI(239) XOR DI(35) XOR DI(78) XOR DI(174) XOR DI(17) XOR DI(69) XOR DI(248) XOR DI(97) XOR DI(44) XOR DI(215) XOR DI(160) XOR DI(91) XOR DI(262) XOR DI(270) XOR DI(119) XOR DI(7) XOR DI(249) XOR DI(255) XOR DI(139) XOR DI(126) XOR DI(193) XOR DI(51) XOR DI(136) XOR DI(225) XOR DI(27) XOR DI(9) XOR DI(50) XOR DI(94) XOR DI(133) XOR DI(269) XOR DI(277) XOR DI(190) XOR DI(188) XOR DI(222) XOR DI(33) XOR DI(182) XOR DI(83) XOR DI(179) XOR DI(22) XOR DI(72) XOR DI(85) XOR DI(264) XOR DI(191) XOR DI(220) XOR DI(113) XOR DI(165) XOR DI(96) XOR DI(275) XOR DI(202) XOR DI(60) XOR DI(231) XOR DI(159) XOR DI(234) XOR DI(124) XOR DI(121) XOR DI(12) XOR DI(57) XOR DI(176) XOR DI(45) XOR DI(107) XOR DI(32) XOR DI(14) XOR DI(146) XOR DI(127) XOR DI(278) XOR DI(286) XOR DI(213) XOR DI(154) XOR DI(71) XOR DI(242) XOR DI(74) XOR DI(170) XOR DI(65) XOR DI(40) XOR DI(211) XOR DI(156) XOR DI(245) XOR DI(135) XOR DI(122) XOR DI(189) XOR DI(47) XOR DI(132) XOR DI(23) XOR DI(5) XOR DI(90) XOR DI(265) XOR DI(184) XOR DI(29) XOR DI(68) XOR DI(187) XOR DI(216) XOR DI(109) XOR DI(161) XOR DI(271) XOR DI(56) XOR DI(227) XOR DI(155) XOR DI(230) XOR DI(8) XOR DI(103) XOR DI(10) XOR DI(142) XOR DI(209) XOR DI(67) XOR DI(70) XOR DI(152) XOR DI(241) XOR DI(118) XOR DI(43) XOR DI(1) XOR DI(25) XOR DI(157) XOR DI(223) XOR DI(151) XOR DI(4) XOR DI(6) XOR DI(138) XOR DI(66) XOR DI(114) XOR DI(153) XOR DI(0) XOR DI(2) XOR DI(110) XOR DI(149) XOR DI(145) XOR DI(141) XOR DI(285) XOR DI(289) XOR DI(293);
   DO(2) <= DI(202) XOR DI(218) XOR DI(159) XOR DI(233) XOR DI(200) XOR DI(76) XOR DI(247) XOR DI(234) XOR DI(240) XOR DI(36) XOR DI(79) XOR DI(175) XOR DI(18) XOR DI(70) XOR DI(249) XOR DI(98) XOR DI(45) XOR DI(216) XOR DI(161) XOR DI(92) XOR DI(263) XOR DI(271) XOR DI(120) XOR DI(8) XOR DI(250) XOR DI(256) XOR DI(140) XOR DI(127) XOR DI(194) XOR DI(52) XOR DI(137) XOR DI(226) XOR DI(28) XOR DI(10) XOR DI(51) XOR DI(95) XOR DI(134) XOR DI(270) XOR DI(278) XOR DI(191) XOR DI(189) XOR DI(223) XOR DI(34) XOR DI(183) XOR DI(84) XOR DI(180) XOR DI(23) XOR DI(73) XOR DI(86) XOR DI(265) XOR DI(192) XOR DI(221) XOR DI(114) XOR DI(166) XOR DI(97) XOR DI(276) XOR DI(203) XOR DI(61) XOR DI(232) XOR DI(160) XOR DI(235) XOR DI(125) XOR DI(122) XOR DI(13) XOR DI(58) XOR DI(177) XOR DI(46) XOR DI(0) XOR DI(108) XOR DI(33) XOR DI(15) XOR DI(147) XOR DI(128) XOR DI(279) XOR DI(287) XOR DI(214) XOR DI(155) XOR DI(72) XOR DI(243) XOR DI(75) XOR DI(171) XOR DI(66) XOR DI(41) XOR DI(212) XOR DI(157) XOR DI(246) XOR DI(136) XOR DI(123) XOR DI(190) XOR DI(48) XOR DI(133) XOR DI(24) XOR DI(6) XOR DI(91) XOR DI(266) XOR DI(185) XOR DI(30) XOR DI(69) XOR DI(188) XOR DI(217) XOR DI(110) XOR DI(162) XOR DI(272) XOR DI(57) XOR DI(228) XOR DI(156) XOR DI(231) XOR DI(9) XOR DI(104) XOR DI(11) XOR DI(143) XOR DI(210) XOR DI(68) XOR DI(71) XOR DI(153) XOR DI(242) XOR DI(119) XOR DI(44) XOR DI(2) XOR DI(26) XOR DI(158) XOR DI(224) XOR DI(152) XOR DI(5) XOR DI(7) XOR DI(139) XOR DI(67) XOR DI(115) XOR DI(154) XOR DI(1) XOR DI(3) XOR DI(111) XOR DI(150) XOR DI(146) XOR DI(142) XOR DI(286) XOR DI(290) XOR DI(294);
   DO(3) <= DI(203) XOR DI(219) XOR DI(160) XOR DI(234) XOR DI(201) XOR DI(77) XOR DI(248) XOR DI(235) XOR DI(241) XOR DI(37) XOR DI(80) XOR DI(176) XOR DI(19) XOR DI(71) XOR DI(250) XOR DI(99) XOR DI(46) XOR DI(217) XOR DI(162) XOR DI(93) XOR DI(264) XOR DI(272) XOR DI(121) XOR DI(9) XOR DI(251) XOR DI(257) XOR DI(141) XOR DI(128) XOR DI(195) XOR DI(53) XOR DI(138) XOR DI(227) XOR DI(29) XOR DI(11) XOR DI(52) XOR DI(96) XOR DI(135) XOR DI(271) XOR DI(279) XOR DI(192) XOR DI(190) XOR DI(224) XOR DI(35) XOR DI(184) XOR DI(85) XOR DI(181) XOR DI(24) XOR DI(74) XOR DI(87) XOR DI(266) XOR DI(193) XOR DI(222) XOR DI(115) XOR DI(167) XOR DI(98) XOR DI(277) XOR DI(204) XOR DI(62) XOR DI(233) XOR DI(161) XOR DI(236) XOR DI(126) XOR DI(123) XOR DI(14) XOR DI(59) XOR DI(178) XOR DI(47) XOR DI(1) XOR DI(109) XOR DI(34) XOR DI(16) XOR DI(148) XOR DI(129) XOR DI(280) XOR DI(288) XOR DI(215) XOR DI(156) XOR DI(73) XOR DI(244) XOR DI(76) XOR DI(172) XOR DI(67) XOR DI(42) XOR DI(213) XOR DI(158) XOR DI(247) XOR DI(137) XOR DI(124) XOR DI(191) XOR DI(49) XOR DI(134) XOR DI(25) XOR DI(7) XOR DI(92) XOR DI(267) XOR DI(186) XOR DI(31) XOR DI(70) XOR DI(189) XOR DI(218) XOR DI(111) XOR DI(163) XOR DI(273) XOR DI(58) XOR DI(229) XOR DI(157) XOR DI(232) XOR DI(10) XOR DI(105) XOR DI(12) XOR DI(144) XOR DI(211) XOR DI(69) XOR DI(72) XOR DI(154) XOR DI(243) XOR DI(120) XOR DI(45) XOR DI(3) XOR DI(27) XOR DI(159) XOR DI(225) XOR DI(153) XOR DI(6) XOR DI(8) XOR DI(140) XOR DI(68) XOR DI(116) XOR DI(155) XOR DI(2) XOR DI(4) XOR DI(112) XOR DI(151) XOR DI(0) XOR DI(147) XOR DI(143) XOR DI(287) XOR DI(291) XOR DI(295);
   DO(4) <= DI(188) XOR DI(204) XOR DI(186) XOR DI(220) XOR DI(22) XOR DI(65) XOR DI(161) XOR DI(56) XOR DI(235) XOR DI(84) XOR DI(31) XOR DI(202) XOR DI(78) XOR DI(249) XOR DI(236) XOR DI(242) XOR DI(126) XOR DI(38) XOR DI(123) XOR DI(81) XOR DI(120) XOR DI(264) XOR DI(177) XOR DI(175) XOR DI(20) XOR DI(169) XOR DI(72) XOR DI(251) XOR DI(178) XOR DI(100) XOR DI(189) XOR DI(47) XOR DI(218) XOR DI(221) XOR DI(108) XOR DI(44) XOR DI(163) XOR DI(94) XOR DI(265) XOR DI(273) XOR DI(200) XOR DI(229) XOR DI(198) XOR DI(232) XOR DI(122) XOR DI(109) XOR DI(34) XOR DI(10) XOR DI(252) XOR DI(16) XOR DI(55) XOR DI(96) XOR DI(258) XOR DI(142) XOR DI(90) XOR DI(129) XOR DI(196) XOR DI(54) XOR DI(139) XOR DI(228) XOR DI(30) XOR DI(12) XOR DI(210) XOR DI(53) XOR DI(140) XOR DI(97) XOR DI(136) XOR DI(132) XOR DI(272) XOR DI(276) XOR DI(280) XOR DI(284) XOR DI(193) XOR DI(150) XOR DI(224) XOR DI(191) XOR DI(67) XOR DI(238) XOR DI(225) XOR DI(231) XOR DI(240) XOR DI(89) XOR DI(36) XOR DI(254) XOR DI(241) XOR DI(247) XOR DI(131) XOR DI(118) XOR DI(185) XOR DI(42) XOR DI(86) XOR DI(261) XOR DI(269) XOR DI(182) XOR DI(25) XOR DI(75) XOR DI(64) XOR DI(183) XOR DI(88) XOR DI(267) XOR DI(194) XOR DI(223) XOR DI(151) XOR DI(116) XOR DI(49) XOR DI(168) XOR DI(99) XOR DI(24) XOR DI(6) XOR DI(270) XOR DI(278) XOR DI(205) XOR DI(63) XOR DI(234) XOR DI(66) XOR DI(162) XOR DI(237) XOR DI(127) XOR DI(181) XOR DI(39) XOR DI(124) XOR DI(15) XOR DI(82) XOR DI(21) XOR DI(60) XOR DI(179) XOR DI(208) XOR DI(153) XOR DI(263) XOR DI(48) XOR DI(222) XOR DI(0) XOR DI(95) XOR DI(2) XOR DI(134) XOR DI(201) XOR DI(110) XOR DI(35) XOR DI(17) XOR DI(149) XOR DI(215) XOR DI(130) XOR DI(102) XOR DI(137) XOR DI(277) XOR DI(281) XOR DI(285) XOR DI(289);
   DO(5) <= DI(189) XOR DI(205) XOR DI(187) XOR DI(221) XOR DI(23) XOR DI(66) XOR DI(162) XOR DI(57) XOR DI(236) XOR DI(85) XOR DI(32) XOR DI(203) XOR DI(79) XOR DI(250) XOR DI(237) XOR DI(243) XOR DI(127) XOR DI(39) XOR DI(124) XOR DI(82) XOR DI(121) XOR DI(265) XOR DI(178) XOR DI(176) XOR DI(21) XOR DI(170) XOR DI(73) XOR DI(252) XOR DI(179) XOR DI(101) XOR DI(190) XOR DI(48) XOR DI(219) XOR DI(222) XOR DI(109) XOR DI(45) XOR DI(164) XOR DI(95) XOR DI(266) XOR DI(274) XOR DI(201) XOR DI(230) XOR DI(199) XOR DI(233) XOR DI(123) XOR DI(110) XOR DI(35) XOR DI(11) XOR DI(253) XOR DI(17) XOR DI(56) XOR DI(97) XOR DI(259) XOR DI(143) XOR DI(91) XOR DI(130) XOR DI(197) XOR DI(55) XOR DI(140) XOR DI(229) XOR DI(31) XOR DI(13) XOR DI(211) XOR DI(54) XOR DI(141) XOR DI(98) XOR DI(137) XOR DI(133) XOR DI(273) XOR DI(277) XOR DI(281) XOR DI(285) XOR DI(194) XOR DI(151) XOR DI(225) XOR DI(192) XOR DI(68) XOR DI(239) XOR DI(226) XOR DI(232) XOR DI(241) XOR DI(90) XOR DI(37) XOR DI(255) XOR DI(242) XOR DI(248) XOR DI(132) XOR DI(119) XOR DI(186) XOR DI(43) XOR DI(87) XOR DI(262) XOR DI(270) XOR DI(183) XOR DI(26) XOR DI(76) XOR DI(65) XOR DI(184) XOR DI(89) XOR DI(268) XOR DI(195) XOR DI(224) XOR DI(152) XOR DI(117) XOR DI(50) XOR DI(169) XOR DI(100) XOR DI(25) XOR DI(7) XOR DI(271) XOR DI(279) XOR DI(206) XOR DI(64) XOR DI(235) XOR DI(67) XOR DI(163) XOR DI(238) XOR DI(128) XOR DI(182) XOR DI(40) XOR DI(125) XOR DI(16) XOR DI(83) XOR DI(22) XOR DI(61) XOR DI(180) XOR DI(209) XOR DI(154) XOR DI(264) XOR DI(49) XOR DI(223) XOR DI(1) XOR DI(96) XOR DI(3) XOR DI(135) XOR DI(202) XOR DI(111) XOR DI(36) XOR DI(18) XOR DI(150) XOR DI(216) XOR DI(131) XOR DI(103) XOR DI(138) XOR DI(278) XOR DI(282) XOR DI(286) XOR DI(290);
   DO(6) <= DI(190) XOR DI(206) XOR DI(188) XOR DI(222) XOR DI(24) XOR DI(67) XOR DI(163) XOR DI(58) XOR DI(237) XOR DI(86) XOR DI(33) XOR DI(204) XOR DI(80) XOR DI(251) XOR DI(238) XOR DI(244) XOR DI(128) XOR DI(40) XOR DI(125) XOR DI(83) XOR DI(122) XOR DI(266) XOR DI(179) XOR DI(177) XOR DI(22) XOR DI(171) XOR DI(74) XOR DI(253) XOR DI(180) XOR DI(102) XOR DI(191) XOR DI(49) XOR DI(220) XOR DI(223) XOR DI(110) XOR DI(46) XOR DI(165) XOR DI(96) XOR DI(267) XOR DI(275) XOR DI(202) XOR DI(231) XOR DI(200) XOR DI(234) XOR DI(124) XOR DI(111) XOR DI(36) XOR DI(12) XOR DI(254) XOR DI(18) XOR DI(57) XOR DI(98) XOR DI(260) XOR DI(144) XOR DI(92) XOR DI(131) XOR DI(198) XOR DI(56) XOR DI(141) XOR DI(230) XOR DI(32) XOR DI(14) XOR DI(212) XOR DI(55) XOR DI(142) XOR DI(99) XOR DI(138) XOR DI(134) XOR DI(274) XOR DI(278) XOR DI(282) XOR DI(286) XOR DI(195) XOR DI(152) XOR DI(226) XOR DI(193) XOR DI(69) XOR DI(240) XOR DI(227) XOR DI(233) XOR DI(242) XOR DI(91) XOR DI(38) XOR DI(256) XOR DI(243) XOR DI(249) XOR DI(133) XOR DI(120) XOR DI(187) XOR DI(44) XOR DI(88) XOR DI(263) XOR DI(271) XOR DI(184) XOR DI(27) XOR DI(77) XOR DI(66) XOR DI(185) XOR DI(90) XOR DI(269) XOR DI(196) XOR DI(225) XOR DI(153) XOR DI(118) XOR DI(51) XOR DI(170) XOR DI(101) XOR DI(26) XOR DI(8) XOR DI(272) XOR DI(280) XOR DI(207) XOR DI(65) XOR DI(236) XOR DI(68) XOR DI(164) XOR DI(239) XOR DI(129) XOR DI(183) XOR DI(41) XOR DI(126) XOR DI(17) XOR DI(84) XOR DI(23) XOR DI(62) XOR DI(181) XOR DI(210) XOR DI(155) XOR DI(265) XOR DI(50) XOR DI(224) XOR DI(2) XOR DI(97) XOR DI(4) XOR DI(136) XOR DI(203) XOR DI(112) XOR DI(37) XOR DI(19) XOR DI(151) XOR DI(217) XOR DI(0) XOR DI(132) XOR DI(104) XOR DI(139) XOR DI(279) XOR DI(283) XOR DI(287) XOR DI(291);
   DO(7) <= DI(191) XOR DI(207) XOR DI(189) XOR DI(223) XOR DI(25) XOR DI(68) XOR DI(164) XOR DI(59) XOR DI(238) XOR DI(87) XOR DI(34) XOR DI(205) XOR DI(81) XOR DI(252) XOR DI(239) XOR DI(245) XOR DI(129) XOR DI(41) XOR DI(126) XOR DI(84) XOR DI(123) XOR DI(267) XOR DI(180) XOR DI(178) XOR DI(23) XOR DI(172) XOR DI(75) XOR DI(254) XOR DI(181) XOR DI(103) XOR DI(192) XOR DI(50) XOR DI(221) XOR DI(224) XOR DI(111) XOR DI(47) XOR DI(166) XOR DI(97) XOR DI(268) XOR DI(276) XOR DI(203) XOR DI(232) XOR DI(201) XOR DI(235) XOR DI(125) XOR DI(112) XOR DI(37) XOR DI(13) XOR DI(255) XOR DI(19) XOR DI(58) XOR DI(99) XOR DI(261) XOR DI(145) XOR DI(93) XOR DI(132) XOR DI(199) XOR DI(57) XOR DI(142) XOR DI(231) XOR DI(33) XOR DI(15) XOR DI(213) XOR DI(56) XOR DI(143) XOR DI(100) XOR DI(139) XOR DI(135) XOR DI(275) XOR DI(279) XOR DI(283) XOR DI(287) XOR DI(196) XOR DI(153) XOR DI(227) XOR DI(194) XOR DI(70) XOR DI(241) XOR DI(228) XOR DI(234) XOR DI(243) XOR DI(92) XOR DI(39) XOR DI(257) XOR DI(244) XOR DI(250) XOR DI(134) XOR DI(121) XOR DI(188) XOR DI(45) XOR DI(89) XOR DI(264) XOR DI(272) XOR DI(185) XOR DI(28) XOR DI(78) XOR DI(67) XOR DI(186) XOR DI(91) XOR DI(270) XOR DI(197) XOR DI(226) XOR DI(154) XOR DI(119) XOR DI(52) XOR DI(171) XOR DI(102) XOR DI(27) XOR DI(9) XOR DI(273) XOR DI(281) XOR DI(208) XOR DI(66) XOR DI(237) XOR DI(69) XOR DI(165) XOR DI(240) XOR DI(130) XOR DI(184) XOR DI(42) XOR DI(127) XOR DI(18) XOR DI(85) XOR DI(24) XOR DI(63) XOR DI(182) XOR DI(211) XOR DI(156) XOR DI(266) XOR DI(51) XOR DI(225) XOR DI(3) XOR DI(98) XOR DI(5) XOR DI(137) XOR DI(204) XOR DI(113) XOR DI(38) XOR DI(20) XOR DI(152) XOR DI(218) XOR DI(1) XOR DI(133) XOR DI(105) XOR DI(140) XOR DI(280) XOR DI(284) XOR DI(288) XOR DI(292);
   DO(8) <= DI(192) XOR DI(208) XOR DI(190) XOR DI(224) XOR DI(26) XOR DI(69) XOR DI(165) XOR DI(60) XOR DI(239) XOR DI(88) XOR DI(35) XOR DI(206) XOR DI(82) XOR DI(253) XOR DI(240) XOR DI(246) XOR DI(130) XOR DI(42) XOR DI(127) XOR DI(85) XOR DI(124) XOR DI(268) XOR DI(181) XOR DI(179) XOR DI(24) XOR DI(173) XOR DI(76) XOR DI(255) XOR DI(182) XOR DI(104) XOR DI(193) XOR DI(51) XOR DI(222) XOR DI(225) XOR DI(112) XOR DI(48) XOR DI(167) XOR DI(98) XOR DI(269) XOR DI(277) XOR DI(204) XOR DI(233) XOR DI(202) XOR DI(236) XOR DI(126) XOR DI(113) XOR DI(38) XOR DI(14) XOR DI(256) XOR DI(20) XOR DI(59) XOR DI(100) XOR DI(262) XOR DI(146) XOR DI(94) XOR DI(133) XOR DI(200) XOR DI(58) XOR DI(143) XOR DI(232) XOR DI(34) XOR DI(16) XOR DI(214) XOR DI(57) XOR DI(144) XOR DI(101) XOR DI(140) XOR DI(136) XOR DI(276) XOR DI(280) XOR DI(284) XOR DI(288) XOR DI(197) XOR DI(154) XOR DI(228) XOR DI(195) XOR DI(71) XOR DI(242) XOR DI(229) XOR DI(235) XOR DI(244) XOR DI(93) XOR DI(40) XOR DI(258) XOR DI(245) XOR DI(251) XOR DI(135) XOR DI(122) XOR DI(189) XOR DI(46) XOR DI(90) XOR DI(265) XOR DI(273) XOR DI(186) XOR DI(29) XOR DI(79) XOR DI(68) XOR DI(187) XOR DI(92) XOR DI(271) XOR DI(198) XOR DI(227) XOR DI(155) XOR DI(120) XOR DI(53) XOR DI(172) XOR DI(103) XOR DI(28) XOR DI(10) XOR DI(274) XOR DI(282) XOR DI(209) XOR DI(67) XOR DI(238) XOR DI(70) XOR DI(166) XOR DI(241) XOR DI(131) XOR DI(185) XOR DI(43) XOR DI(128) XOR DI(19) XOR DI(86) XOR DI(25) XOR DI(64) XOR DI(183) XOR DI(212) XOR DI(157) XOR DI(267) XOR DI(52) XOR DI(226) XOR DI(4) XOR DI(99) XOR DI(6) XOR DI(138) XOR DI(205) XOR DI(114) XOR DI(39) XOR DI(21) XOR DI(153) XOR DI(219) XOR DI(2) XOR DI(134) XOR DI(106) XOR DI(141) XOR DI(281) XOR DI(285) XOR DI(289) XOR DI(293);
   DO(9) <= DI(193) XOR DI(209) XOR DI(191) XOR DI(225) XOR DI(27) XOR DI(70) XOR DI(166) XOR DI(61) XOR DI(240) XOR DI(89) XOR DI(36) XOR DI(207) XOR DI(83) XOR DI(254) XOR DI(241) XOR DI(247) XOR DI(131) XOR DI(43) XOR DI(128) XOR DI(86) XOR DI(125) XOR DI(269) XOR DI(182) XOR DI(180) XOR DI(25) XOR DI(174) XOR DI(77) XOR DI(256) XOR DI(183) XOR DI(105) XOR DI(194) XOR DI(52) XOR DI(223) XOR DI(226) XOR DI(113) XOR DI(49) XOR DI(168) XOR DI(99) XOR DI(270) XOR DI(278) XOR DI(205) XOR DI(234) XOR DI(203) XOR DI(237) XOR DI(127) XOR DI(114) XOR DI(39) XOR DI(15) XOR DI(257) XOR DI(21) XOR DI(60) XOR DI(101) XOR DI(263) XOR DI(147) XOR DI(0) XOR DI(95) XOR DI(134) XOR DI(201) XOR DI(59) XOR DI(144) XOR DI(233) XOR DI(35) XOR DI(17) XOR DI(215) XOR DI(58) XOR DI(145) XOR DI(102) XOR DI(141) XOR DI(137) XOR DI(277) XOR DI(281) XOR DI(285) XOR DI(289) XOR DI(198) XOR DI(155) XOR DI(229) XOR DI(196) XOR DI(72) XOR DI(243) XOR DI(230) XOR DI(236) XOR DI(245) XOR DI(94) XOR DI(41) XOR DI(259) XOR DI(246) XOR DI(252) XOR DI(136) XOR DI(123) XOR DI(190) XOR DI(47) XOR DI(91) XOR DI(266) XOR DI(274) XOR DI(187) XOR DI(30) XOR DI(80) XOR DI(69) XOR DI(188) XOR DI(93) XOR DI(272) XOR DI(199) XOR DI(228) XOR DI(156) XOR DI(121) XOR DI(54) XOR DI(173) XOR DI(104) XOR DI(29) XOR DI(11) XOR DI(275) XOR DI(283) XOR DI(210) XOR DI(68) XOR DI(239) XOR DI(71) XOR DI(167) XOR DI(242) XOR DI(132) XOR DI(186) XOR DI(44) XOR DI(129) XOR DI(20) XOR DI(87) XOR DI(26) XOR DI(65) XOR DI(184) XOR DI(213) XOR DI(158) XOR DI(268) XOR DI(53) XOR DI(227) XOR DI(5) XOR DI(100) XOR DI(7) XOR DI(139) XOR DI(206) XOR DI(115) XOR DI(40) XOR DI(22) XOR DI(154) XOR DI(220) XOR DI(3) XOR DI(135) XOR DI(107) XOR DI(142) XOR DI(282) XOR DI(286) XOR DI(290) XOR DI(294);
   DO(10) <= DI(194) XOR DI(210) XOR DI(192) XOR DI(226) XOR DI(28) XOR DI(71) XOR DI(167) XOR DI(62) XOR DI(241) XOR DI(90) XOR DI(37) XOR DI(208) XOR DI(84) XOR DI(255) XOR DI(242) XOR DI(248) XOR DI(132) XOR DI(44) XOR DI(129) XOR DI(87) XOR DI(126) XOR DI(270) XOR DI(183) XOR DI(181) XOR DI(26) XOR DI(175) XOR DI(78) XOR DI(257) XOR DI(184) XOR DI(106) XOR DI(195) XOR DI(53) XOR DI(224) XOR DI(227) XOR DI(114) XOR DI(50) XOR DI(169) XOR DI(100) XOR DI(271) XOR DI(279) XOR DI(206) XOR DI(235) XOR DI(204) XOR DI(238) XOR DI(128) XOR DI(115) XOR DI(40) XOR DI(16) XOR DI(258) XOR DI(22) XOR DI(61) XOR DI(102) XOR DI(264) XOR DI(148) XOR DI(1) XOR DI(96) XOR DI(135) XOR DI(202) XOR DI(60) XOR DI(145) XOR DI(234) XOR DI(36) XOR DI(18) XOR DI(216) XOR DI(59) XOR DI(146) XOR DI(103) XOR DI(142) XOR DI(138) XOR DI(278) XOR DI(282) XOR DI(286) XOR DI(290) XOR DI(199) XOR DI(156) XOR DI(230) XOR DI(197) XOR DI(73) XOR DI(244) XOR DI(231) XOR DI(237) XOR DI(246) XOR DI(95) XOR DI(42) XOR DI(260) XOR DI(247) XOR DI(253) XOR DI(137) XOR DI(124) XOR DI(191) XOR DI(48) XOR DI(92) XOR DI(267) XOR DI(275) XOR DI(188) XOR DI(31) XOR DI(81) XOR DI(70) XOR DI(189) XOR DI(94) XOR DI(273) XOR DI(200) XOR DI(229) XOR DI(157) XOR DI(122) XOR DI(55) XOR DI(174) XOR DI(105) XOR DI(30) XOR DI(12) XOR DI(276) XOR DI(284) XOR DI(211) XOR DI(69) XOR DI(240) XOR DI(72) XOR DI(168) XOR DI(243) XOR DI(133) XOR DI(187) XOR DI(45) XOR DI(130) XOR DI(21) XOR DI(88) XOR DI(27) XOR DI(66) XOR DI(185) XOR DI(214) XOR DI(159) XOR DI(269) XOR DI(54) XOR DI(228) XOR DI(6) XOR DI(101) XOR DI(8) XOR DI(140) XOR DI(207) XOR DI(116) XOR DI(41) XOR DI(23) XOR DI(155) XOR DI(221) XOR DI(4) XOR DI(136) XOR DI(108) XOR DI(143) XOR DI(283) XOR DI(287) XOR DI(291) XOR DI(295);
   DO(11) <= DI(195) XOR DI(211) XOR DI(152) XOR DI(226) XOR DI(193) XOR DI(69) XOR DI(240) XOR DI(227) XOR DI(233) XOR DI(29) XOR DI(72) XOR DI(168) XOR DI(11) XOR DI(63) XOR DI(242) XOR DI(91) XOR DI(38) XOR DI(209) XOR DI(154) XOR DI(85) XOR DI(256) XOR DI(264) XOR DI(113) XOR DI(1) XOR DI(243) XOR DI(249) XOR DI(133) XOR DI(120) XOR DI(187) XOR DI(45) XOR DI(130) XOR DI(219) XOR DI(21) XOR DI(3) XOR DI(44) XOR DI(88) XOR DI(127) XOR DI(263) XOR DI(271) XOR DI(184) XOR DI(182) XOR DI(216) XOR DI(27) XOR DI(176) XOR DI(77) XOR DI(173) XOR DI(16) XOR DI(66) XOR DI(79) XOR DI(258) XOR DI(185) XOR DI(214) XOR DI(107) XOR DI(159) XOR DI(90) XOR DI(269) XOR DI(196) XOR DI(54) XOR DI(225) XOR DI(153) XOR DI(228) XOR DI(118) XOR DI(115) XOR DI(6) XOR DI(51) XOR DI(170) XOR DI(39) XOR DI(101) XOR DI(26) XOR DI(8) XOR DI(140) XOR DI(121) XOR DI(272) XOR DI(280) XOR DI(207) XOR DI(148) XOR DI(65) XOR DI(236) XOR DI(68) XOR DI(164) XOR DI(59) XOR DI(34) XOR DI(205) XOR DI(150) XOR DI(239) XOR DI(129) XOR DI(116) XOR DI(183) XOR DI(41) XOR DI(126) XOR DI(17) XOR DI(84) XOR DI(259) XOR DI(178) XOR DI(23) XOR DI(62) XOR DI(181) XOR DI(210) XOR DI(103) XOR DI(155) XOR DI(265) XOR DI(50) XOR DI(221) XOR DI(149) XOR DI(224) XOR DI(2) XOR DI(97) XOR DI(4) XOR DI(136) XOR DI(203) XOR DI(61) XOR DI(64) XOR DI(146) XOR DI(235) XOR DI(112) XOR DI(37) XOR DI(19) XOR DI(151) XOR DI(217) XOR DI(145) XOR DI(0) XOR DI(132) XOR DI(60) XOR DI(108) XOR DI(147) XOR DI(104) XOR DI(143) XOR DI(139) XOR DI(135) XOR DI(279) XOR DI(283) XOR DI(287) XOR DI(291);
   DO(12) <= DI(196) XOR DI(212) XOR DI(153) XOR DI(227) XOR DI(194) XOR DI(70) XOR DI(241) XOR DI(228) XOR DI(234) XOR DI(30) XOR DI(73) XOR DI(169) XOR DI(12) XOR DI(64) XOR DI(243) XOR DI(92) XOR DI(39) XOR DI(210) XOR DI(155) XOR DI(86) XOR DI(257) XOR DI(265) XOR DI(114) XOR DI(2) XOR DI(244) XOR DI(250) XOR DI(134) XOR DI(121) XOR DI(188) XOR DI(46) XOR DI(131) XOR DI(220) XOR DI(22) XOR DI(4) XOR DI(45) XOR DI(89) XOR DI(128) XOR DI(264) XOR DI(272) XOR DI(185) XOR DI(183) XOR DI(217) XOR DI(28) XOR DI(177) XOR DI(78) XOR DI(174) XOR DI(17) XOR DI(67) XOR DI(80) XOR DI(259) XOR DI(186) XOR DI(215) XOR DI(108) XOR DI(160) XOR DI(91) XOR DI(270) XOR DI(197) XOR DI(55) XOR DI(226) XOR DI(154) XOR DI(229) XOR DI(119) XOR DI(116) XOR DI(7) XOR DI(52) XOR DI(171) XOR DI(40) XOR DI(102) XOR DI(27) XOR DI(9) XOR DI(141) XOR DI(122) XOR DI(273) XOR DI(281) XOR DI(208) XOR DI(149) XOR DI(66) XOR DI(237) XOR DI(69) XOR DI(165) XOR DI(60) XOR DI(35) XOR DI(206) XOR DI(151) XOR DI(240) XOR DI(130) XOR DI(117) XOR DI(184) XOR DI(42) XOR DI(127) XOR DI(18) XOR DI(0) XOR DI(85) XOR DI(260) XOR DI(179) XOR DI(24) XOR DI(63) XOR DI(182) XOR DI(211) XOR DI(104) XOR DI(156) XOR DI(266) XOR DI(51) XOR DI(222) XOR DI(150) XOR DI(225) XOR DI(3) XOR DI(98) XOR DI(5) XOR DI(137) XOR DI(204) XOR DI(62) XOR DI(65) XOR DI(147) XOR DI(236) XOR DI(113) XOR DI(38) XOR DI(20) XOR DI(152) XOR DI(218) XOR DI(146) XOR DI(1) XOR DI(133) XOR DI(61) XOR DI(109) XOR DI(148) XOR DI(105) XOR DI(144) XOR DI(140) XOR DI(136) XOR DI(280) XOR DI(284) XOR DI(288) XOR DI(292);
   DO(13) <= DI(197) XOR DI(213) XOR DI(154) XOR DI(228) XOR DI(195) XOR DI(71) XOR DI(242) XOR DI(229) XOR DI(235) XOR DI(31) XOR DI(74) XOR DI(170) XOR DI(13) XOR DI(65) XOR DI(244) XOR DI(93) XOR DI(40) XOR DI(211) XOR DI(156) XOR DI(87) XOR DI(258) XOR DI(266) XOR DI(115) XOR DI(3) XOR DI(245) XOR DI(251) XOR DI(135) XOR DI(122) XOR DI(189) XOR DI(47) XOR DI(132) XOR DI(221) XOR DI(23) XOR DI(5) XOR DI(46) XOR DI(90) XOR DI(129) XOR DI(265) XOR DI(273) XOR DI(186) XOR DI(184) XOR DI(218) XOR DI(29) XOR DI(178) XOR DI(79) XOR DI(175) XOR DI(18) XOR DI(68) XOR DI(81) XOR DI(260) XOR DI(187) XOR DI(216) XOR DI(109) XOR DI(161) XOR DI(92) XOR DI(271) XOR DI(198) XOR DI(56) XOR DI(227) XOR DI(155) XOR DI(230) XOR DI(120) XOR DI(117) XOR DI(8) XOR DI(53) XOR DI(172) XOR DI(41) XOR DI(103) XOR DI(28) XOR DI(10) XOR DI(142) XOR DI(123) XOR DI(274) XOR DI(282) XOR DI(209) XOR DI(150) XOR DI(67) XOR DI(238) XOR DI(70) XOR DI(166) XOR DI(61) XOR DI(36) XOR DI(207) XOR DI(152) XOR DI(241) XOR DI(131) XOR DI(118) XOR DI(185) XOR DI(43) XOR DI(128) XOR DI(19) XOR DI(1) XOR DI(86) XOR DI(261) XOR DI(180) XOR DI(25) XOR DI(64) XOR DI(183) XOR DI(212) XOR DI(105) XOR DI(157) XOR DI(267) XOR DI(52) XOR DI(223) XOR DI(151) XOR DI(226) XOR DI(4) XOR DI(99) XOR DI(6) XOR DI(138) XOR DI(205) XOR DI(63) XOR DI(66) XOR DI(148) XOR DI(237) XOR DI(114) XOR DI(39) XOR DI(21) XOR DI(153) XOR DI(219) XOR DI(147) XOR DI(0) XOR DI(2) XOR DI(134) XOR DI(62) XOR DI(110) XOR DI(149) XOR DI(106) XOR DI(145) XOR DI(141) XOR DI(137) XOR DI(281) XOR DI(285) XOR DI(289) XOR DI(293);
   DO(14) <= DI(198) XOR DI(214) XOR DI(155) XOR DI(229) XOR DI(196) XOR DI(72) XOR DI(243) XOR DI(230) XOR DI(236) XOR DI(32) XOR DI(75) XOR DI(171) XOR DI(14) XOR DI(66) XOR DI(245) XOR DI(94) XOR DI(41) XOR DI(212) XOR DI(157) XOR DI(88) XOR DI(259) XOR DI(267) XOR DI(116) XOR DI(4) XOR DI(246) XOR DI(252) XOR DI(136) XOR DI(123) XOR DI(190) XOR DI(48) XOR DI(133) XOR DI(222) XOR DI(24) XOR DI(6) XOR DI(47) XOR DI(91) XOR DI(130) XOR DI(266) XOR DI(274) XOR DI(187) XOR DI(185) XOR DI(219) XOR DI(30) XOR DI(179) XOR DI(80) XOR DI(176) XOR DI(19) XOR DI(69) XOR DI(82) XOR DI(261) XOR DI(188) XOR DI(217) XOR DI(110) XOR DI(162) XOR DI(93) XOR DI(272) XOR DI(199) XOR DI(57) XOR DI(228) XOR DI(156) XOR DI(231) XOR DI(121) XOR DI(118) XOR DI(9) XOR DI(54) XOR DI(173) XOR DI(42) XOR DI(104) XOR DI(29) XOR DI(11) XOR DI(143) XOR DI(124) XOR DI(275) XOR DI(283) XOR DI(210) XOR DI(151) XOR DI(68) XOR DI(239) XOR DI(71) XOR DI(167) XOR DI(62) XOR DI(37) XOR DI(208) XOR DI(153) XOR DI(242) XOR DI(132) XOR DI(119) XOR DI(186) XOR DI(44) XOR DI(129) XOR DI(20) XOR DI(2) XOR DI(87) XOR DI(262) XOR DI(181) XOR DI(26) XOR DI(65) XOR DI(184) XOR DI(213) XOR DI(106) XOR DI(158) XOR DI(268) XOR DI(53) XOR DI(224) XOR DI(152) XOR DI(227) XOR DI(5) XOR DI(100) XOR DI(7) XOR DI(139) XOR DI(206) XOR DI(64) XOR DI(67) XOR DI(149) XOR DI(238) XOR DI(115) XOR DI(40) XOR DI(22) XOR DI(154) XOR DI(220) XOR DI(148) XOR DI(1) XOR DI(3) XOR DI(135) XOR DI(63) XOR DI(111) XOR DI(150) XOR DI(107) XOR DI(146) XOR DI(142) XOR DI(138) XOR DI(282) XOR DI(286) XOR DI(290) XOR DI(294);
   DO(15) <= DI(199) XOR DI(215) XOR DI(156) XOR DI(230) XOR DI(197) XOR DI(73) XOR DI(244) XOR DI(231) XOR DI(237) XOR DI(33) XOR DI(76) XOR DI(172) XOR DI(15) XOR DI(67) XOR DI(246) XOR DI(95) XOR DI(42) XOR DI(213) XOR DI(158) XOR DI(89) XOR DI(260) XOR DI(268) XOR DI(117) XOR DI(5) XOR DI(247) XOR DI(253) XOR DI(137) XOR DI(124) XOR DI(191) XOR DI(49) XOR DI(134) XOR DI(223) XOR DI(25) XOR DI(7) XOR DI(48) XOR DI(92) XOR DI(131) XOR DI(267) XOR DI(275) XOR DI(188) XOR DI(186) XOR DI(220) XOR DI(31) XOR DI(180) XOR DI(81) XOR DI(177) XOR DI(20) XOR DI(70) XOR DI(83) XOR DI(262) XOR DI(189) XOR DI(218) XOR DI(111) XOR DI(163) XOR DI(94) XOR DI(273) XOR DI(200) XOR DI(58) XOR DI(229) XOR DI(157) XOR DI(232) XOR DI(122) XOR DI(119) XOR DI(10) XOR DI(55) XOR DI(174) XOR DI(43) XOR DI(105) XOR DI(30) XOR DI(12) XOR DI(144) XOR DI(125) XOR DI(276) XOR DI(284) XOR DI(211) XOR DI(152) XOR DI(69) XOR DI(240) XOR DI(72) XOR DI(168) XOR DI(63) XOR DI(38) XOR DI(209) XOR DI(154) XOR DI(243) XOR DI(133) XOR DI(120) XOR DI(187) XOR DI(45) XOR DI(130) XOR DI(21) XOR DI(3) XOR DI(88) XOR DI(263) XOR DI(182) XOR DI(27) XOR DI(66) XOR DI(185) XOR DI(214) XOR DI(107) XOR DI(159) XOR DI(269) XOR DI(54) XOR DI(225) XOR DI(153) XOR DI(228) XOR DI(6) XOR DI(101) XOR DI(8) XOR DI(140) XOR DI(207) XOR DI(65) XOR DI(68) XOR DI(150) XOR DI(239) XOR DI(116) XOR DI(41) XOR DI(23) XOR DI(155) XOR DI(221) XOR DI(149) XOR DI(2) XOR DI(4) XOR DI(136) XOR DI(64) XOR DI(112) XOR DI(151) XOR DI(0) XOR DI(108) XOR DI(147) XOR DI(143) XOR DI(139) XOR DI(283) XOR DI(287) XOR DI(291) XOR DI(295);
  
end architecture;