///////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   /
// /___/  \  /    Vendor: Xilinx
// \   \   \/     Version : 3.0
//  \   \         Application : GT Wizard
//  /   /         Filename : gtz_caui4_v3_0_rx_block_sync.v
// /___/   /\     
// \   \  /  \ 
//  \___\/\___\
//
//
// Module gtz_caui4_v3_0_rx_block_sync
// Generated by Xilinx GT Wizard
// 
// 
// (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
// 
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
// 
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
// 
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
// 
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES. 


`default_nettype wire
`timescale 1ns / 1ps
`define DLY #1


//***************************** Entity Declaration ****************************

module gtz_caui4_v3_0_rx_block_sync #
   (
       parameter SH_CNT_MAX         = 1024,
       parameter SH_INVALID_CNT_MAX = 65 
   )
   (
    rx_usrclk_in,
    rx_system_reset_in,
    rx_header_in,
    rx_headervalid_in,
    rx_gearboxslip_out,   
    rx_block_lock_out
    );
   
   input rx_usrclk_in;
   input rx_system_reset_in;
   
   input  [9:0] rx_header_in; 
   input  [4:0] rx_headervalid_in;
   
   output [4:0] rx_gearboxslip_out;
   output [4:0] rx_block_lock_out;

   wire [1:0] 	     rxheaderA_i;
   wire [1:0] 	     rxheaderB_i;
   wire [1:0] 	     rxheaderC_i;
   wire [1:0] 	     rxheaderD_i;
   wire [1:0] 	     rxheaderE_i;

   wire 	     rxheadervalidA_i;
   wire 	     rxheadervalidB_i;
   wire 	     rxheadervalidC_i;
   wire 	     rxheadervalidD_i;
   wire 	     rxheadervalidE_i;

   wire 	     rxgearboxslipA_o;
   wire 	     rxgearboxslipB_o;
   wire 	     rxgearboxslipC_o;
   wire 	     rxgearboxslipD_o;
   wire 	     rxgearboxslipE_o;
   
   wire 	     block_lockA_i;
   wire 	     block_lockB_i;
   wire 	     block_lockC_i;
   wire 	     block_lockD_i;
   wire 	     block_lockE_i;


   assign  {rxheaderE_i,rxheaderD_i,rxheaderC_i,rxheaderB_i,rxheaderA_i} = rx_header_in;
   assign  {rxheadervalidE_i,rxheadervalidD_i,rxheadervalidC_i,rxheadervalidB_i,rxheadervalidA_i} = rx_headervalid_in;

   assign rx_gearboxslip_out = {rxgearboxslipE_o , rxgearboxslipD_o , rxgearboxslipC_o , rxgearboxslipB_o , rxgearboxslipA_o};
   assign rx_block_lock_out = {block_lockE_i , block_lockD_i , block_lockC_i , block_lockB_i , block_lockA_i};
   
   //________________________ Block Sync State Machine _______________________
			   
   gtz_caui4_v3_0_BLOCK_SYNC_SM #
     (
      .SH_CNT_MAX(SH_CNT_MAX),    
      .SH_INVALID_CNT_MAX(SH_INVALID_CNT_MAX)    
      )
   block_sync_smA_i
     (
      // User Interface
      .BLOCKSYNC_OUT        (block_lockA_i),
      .RXGEARBOXSLIP_OUT    (rxgearboxslipA_o),
      .RXHEADER_IN          (rxheaderA_i),
      .RXHEADERVALID_IN     (rxheadervalidA_i),

      // System Interface
      .USER_CLK             (rx_usrclk_in),
      .SYSTEM_RESET         (rx_system_reset_in)
      );

   gtz_caui4_v3_0_BLOCK_SYNC_SM #
     (
      .SH_CNT_MAX(SH_CNT_MAX),    
      .SH_INVALID_CNT_MAX(SH_INVALID_CNT_MAX)    
      )
   block_sync_smB_i
     (
      // User Interface
      .BLOCKSYNC_OUT        (block_lockB_i),
      .RXGEARBOXSLIP_OUT    (rxgearboxslipB_o),
      .RXHEADER_IN          (rxheaderB_i),
      .RXHEADERVALID_IN     (rxheadervalidB_i),

      // System Interface
      .USER_CLK             (rx_usrclk_in),
      .SYSTEM_RESET         (rx_system_reset_in)
      );

   gtz_caui4_v3_0_BLOCK_SYNC_SM #
     (
      .SH_CNT_MAX(SH_CNT_MAX),    
      .SH_INVALID_CNT_MAX(SH_INVALID_CNT_MAX)    
      )
   block_sync_smC_i
     (
      // User Interface
      .BLOCKSYNC_OUT        (block_lockC_i),
      .RXGEARBOXSLIP_OUT    (rxgearboxslipC_o),
      .RXHEADER_IN          (rxheaderC_i),
      .RXHEADERVALID_IN     (rxheadervalidC_i),

      // System Interface
      .USER_CLK             (rx_usrclk_in),
      .SYSTEM_RESET         (rx_system_reset_in)
      );

   gtz_caui4_v3_0_BLOCK_SYNC_SM #
     (
      .SH_CNT_MAX(SH_CNT_MAX),    
      .SH_INVALID_CNT_MAX(SH_INVALID_CNT_MAX)    
      )
   block_sync_smD_i
     (
      // User Interface
      .BLOCKSYNC_OUT        (block_lockD_i),
      .RXGEARBOXSLIP_OUT    (rxgearboxslipD_o),
      .RXHEADER_IN          (rxheaderD_i),
      .RXHEADERVALID_IN     (rxheadervalidD_i),

      // System Interface
      .USER_CLK             (rx_usrclk_in),
      .SYSTEM_RESET         (rx_system_reset_in)
      );

   gtz_caui4_v3_0_BLOCK_SYNC_SM #
     (
      .SH_CNT_MAX(SH_CNT_MAX),    
      .SH_INVALID_CNT_MAX(SH_INVALID_CNT_MAX)    
      )
   block_sync_smE_i
     (
      // User Interface
      .BLOCKSYNC_OUT        (block_lockE_i),
      .RXGEARBOXSLIP_OUT    (rxgearboxslipE_o),
      .RXHEADER_IN          (rxheaderE_i),
      .RXHEADERVALID_IN     (rxheadervalidE_i),

      // System Interface
      .USER_CLK             (rx_usrclk_in),
      .SYSTEM_RESET         (rx_system_reset_in)
      );
			   
endmodule     

