-- cgmii_pkg.vhd: CGMII protocol constants
-- Copyright (C) 2012 CESNET
-- Author(s): Jan Kucera <xkucer73@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--

library IEEE;
use IEEE.std_logic_1164.all;

package CGMII_PKG is

   -- Constant declaration ----------------------------------------------------
   -- Common control characters
   constant C_CGMII_IDLE        : std_logic_vector := X"07";
   constant C_CGMII_SEQUENCE    : std_logic_vector := X"9C";
   constant C_CGMII_START       : std_logic_vector := X"FB";
   constant C_CGMII_TERMINATE   : std_logic_vector := X"FD";
   constant C_CGMII_ERROR       : std_logic_vector := X"FE";

   -- Local fault sequence in data and control
   constant C_CGMII_LOCFAULT_D   : std_logic_vector(63 downto 0) :=
         X"00000000010000" & C_CGMII_SEQUENCE;
   constant C_CGMII_LOCFAULT_C   : std_logic_vector(7 downto 0) :=
         "00000001";

   -- Preamble pattern in data and control
   constant C_CGMII_PREAMBLE_D       : std_logic_vector(63 downto 0) :=
         X"D5555555555555" & C_CGMII_START;
   constant C_CGMII_PREAMBLE_C       : std_logic_vector(7 downto 0) :=
         "00000001";

end CGMII_PKG;

package body CGMII_PKG is
end CGMII_PKG;

