# cfp2.xdc: Constraints for CFP2 transceiver ports
# Copyright (C) 2014 CESNET
# Author: Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the Company nor the names of its contributors
#    may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# This software is provided ``as is'', and any express or implied
# warranties, including, but not limited to, the implied warranties of
# merchantability and fitness for a particular purpose are disclaimed.
# In no event shall the company or contributors be liable for any
# direct, indirect, incidental, special, exemplary, or consequential
# damages (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether
# in contract, strict liability, or tort (including negligence or
# otherwise) arising in any way out of the use of this software, even
# if advised of the possibility of such damage.
#
# $Id$
#


# CFP2 transceiver ports placement
###############################################################################

# Reference clocks (4x25G mode)
# set_property PACKAGE_PIN E21      [get_ports {CFP2_GTZ_REFCLK_P}]
# set_property PACKAGE_PIN E20      [get_ports {CFP2_GTZ_REFCLK_N}]

# Data ports (4x25G mode)
# set_property PACKAGE_PIN A24      [get_ports {CFP2_RX0_RX1_P}]
# set_property PACKAGE_PIN A25      [get_ports {CFP2_RX0_RX1_N}]
# set_property PACKAGE_PIN A31      [get_ports {CFP2_TX0_TX1_P}]
# set_property PACKAGE_PIN A32      [get_ports {CFP2_TX0_TX1_N}]
# set_property PACKAGE_PIN C25      [get_ports {CFP2_RX1_RX2_P}]
# set_property PACKAGE_PIN C26      [get_ports {CFP2_RX1_RX2_N}]
# set_property PACKAGE_PIN C32      [get_ports {CFP2_TX1_TX2_P}]
# set_property PACKAGE_PIN C33      [get_ports {CFP2_TX1_TX2_N}]
# set_property PACKAGE_PIN A27      [get_ports {CFP2_RX2_RX5_P}]
# set_property PACKAGE_PIN A28      [get_ports {CFP2_RX2_RX5_N}]
# set_property PACKAGE_PIN A34      [get_ports {CFP2_TX2_TX5_P}]
# set_property PACKAGE_PIN A35      [get_ports {CFP2_TX2_TX5_N}]
# set_property PACKAGE_PIN C28      [get_ports {CFP2_RX3_RX6_P}]
# set_property PACKAGE_PIN C29      [get_ports {CFP2_RX3_RX6_N}]
# set_property PACKAGE_PIN C35      [get_ports {CFP2_TX3_TX6_P}]
# set_property PACKAGE_PIN C36      [get_ports {CFP2_TX3_TX6_N}]

# Reference clocks (10x10G mode)
# set_property PACKAGE_PIN J39      [get_ports {CFP2_GTH_REFCLK_P}]
# set_property PACKAGE_PIN J40      [get_ports {CFP2_GTH_REFCLK_N}]

# Data ports (10x10G mode)
# set_property PACKAGE_PIN H42      [get_ports {CFP2_RX0_P}]
# set_property PACKAGE_PIN H41      [get_ports {CFP2_RX0_N}]
# set_property PACKAGE_PIN J44      [get_ports {CFP2_TX0_P}]
# set_property PACKAGE_PIN J43      [get_ports {CFP2_TX0_N}]
# set_property PACKAGE_PIN F42      [get_ports {CFP2_RX3_P}]
# set_property PACKAGE_PIN F41      [get_ports {CFP2_RX3_N}]
# set_property PACKAGE_PIN G44      [get_ports {CFP2_TX3_P}]
# set_property PACKAGE_PIN G43      [get_ports {CFP2_TX3_N}]
# set_property PACKAGE_PIN G40      [get_ports {CFP2_RX4_P}]
# set_property PACKAGE_PIN G39      [get_ports {CFP2_RX4_N}]
# set_property PACKAGE_PIN E44      [get_ports {CFP2_TX4_P}]
# set_property PACKAGE_PIN E43      [get_ports {CFP2_TX4_N}]
# set_property PACKAGE_PIN E39      [get_ports {CFP2_RX7_P}]
# set_property PACKAGE_PIN E40      [get_ports {CFP2_RX7_N}]
# set_property PACKAGE_PIN C43      [get_ports {CFP2_TX7_P}]
# set_property PACKAGE_PIN C44      [get_ports {CFP2_TX7_N}]
# set_property PACKAGE_PIN M42      [get_ports {CFP2_RX8_P}]
# set_property PACKAGE_PIN M41      [get_ports {CFP2_RX8_N}]
# set_property PACKAGE_PIN N44      [get_ports {CFP2_TX8_P}]
# set_property PACKAGE_PIN N43      [get_ports {CFP2_TX8_N}]
# set_property PACKAGE_PIN K42      [get_ports {CFP2_RX9_P}]
# set_property PACKAGE_PIN K41      [get_ports {CFP2_RX9_N}]
# set_property PACKAGE_PIN L44      [get_ports {CFP2_TX9_P}]
# set_property PACKAGE_PIN L43      [get_ports {CFP2_TX9_N}]

# Control ports
set_property PACKAGE_PIN R36      [get_ports {CFP2_GLB_ALRM_N}]
set_property PACKAGE_PIN T8       [get_ports {CFP2_MOD_ABS}]
set_property PACKAGE_PIN Y34      [get_ports {CFP2_MOD_LOPWR}]
set_property PACKAGE_PIN Y32      [get_ports {CFP2_MOD_RST_N}]
set_property PACKAGE_PIN W10      [get_ports {CFP2_PRG_ALRM1}]
set_property PACKAGE_PIN W9       [get_ports {CFP2_PRG_ALRM2}]
set_property PACKAGE_PIN V8       [get_ports {CFP2_PRG_ALRM3}]
set_property PACKAGE_PIN P35      [get_ports {CFP2_PRG_CNTL1}]
set_property PACKAGE_PIN V34      [get_ports {CFP2_PRG_CNTL2}]
set_property PACKAGE_PIN R34      [get_ports {CFP2_PRG_CNTL3}]
set_property PACKAGE_PIN U8       [get_ports {CFP2_RX_LOS}]
set_property PACKAGE_PIN R33      [get_ports {CFP2_TX_DIS}]
set_property PACKAGE_PIN AN18     [get_ports {CFP2_MDC}]
set_property PACKAGE_PIN AK16     [get_ports {CFP2_MDIO}]


# CFP2 transceiver ports I/O standard
###############################################################################

# Control ports
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_GLB_ALRM_N}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_MOD_ABS}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_MOD_LOPWR}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_MOD_RST_N}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_PRG_ALRM1}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_PRG_ALRM2}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_PRG_ALRM3}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_PRG_CNTL1}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_PRG_CNTL2}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_PRG_CNTL3}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_RX_LOS}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_TX_DIS}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_MDC}]
set_property IOSTANDARD  LVCMOS12 [get_ports {CFP2_MDIO}]


# CFP2 transceiver ports DRIVE
###############################################################################

# Control ports
set_property DRIVE       8        [get_ports {CFP2_GLB_ALRM_N}]
set_property DRIVE       8        [get_ports {CFP2_MOD_ABS}]
set_property DRIVE       8        [get_ports {CFP2_MOD_LOPWR}]
set_property DRIVE       8        [get_ports {CFP2_MOD_RST_N}]
set_property DRIVE       8        [get_ports {CFP2_PRG_ALRM1}]
set_property DRIVE       8        [get_ports {CFP2_PRG_ALRM2}]
set_property DRIVE       8        [get_ports {CFP2_PRG_ALRM3}]
set_property DRIVE       8        [get_ports {CFP2_PRG_CNTL1}]
set_property DRIVE       8        [get_ports {CFP2_PRG_CNTL2}]
set_property DRIVE       8        [get_ports {CFP2_PRG_CNTL3}]
set_property DRIVE       8        [get_ports {CFP2_RX_LOS}]
set_property DRIVE       8        [get_ports {CFP2_TX_DIS}]
set_property DRIVE       8        [get_ports {CFP2_MDC}]
set_property DRIVE       8        [get_ports {CFP2_MDIO}]
