/*! Copyright (C) 2011 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#include <err.h>
#include <fcntl.h>

#include <libsze2.h>
#include <commlbr.h>

#define POLL_TIMEOUT 1000000

int main(int argc, char *argv[]) {
	short events;
	int r = 0;
	int ret = 0;
	unsigned short interface = 0;		/*!< TX interface number */
	char *sze_dev = "/dev/szedataII0";	/*!< path to device */
	unsigned int rx = 0x00, tx = 0xFF;
	struct szedata *sze = NULL;
	bool flag_ok; /* auxiliary for printings */

	unsigned char test_packet[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()";

	int pkt_cnt = 0;
	const int PKT_CNT = 2 * (1 << 20); /* send 2 mega packets */

	SZE2_BURST_WRITE_SIZE = 10000; /* set burst size to 10 K */

	/* initialize szedata */
	sze = szedata_open(sze_dev);
	if (sze == NULL)
		errx(3, "szedata_open failed");

	ret = szedata_subscribe3(sze, &rx, &tx);
	if (ret)
		errx(3, "szedata_subscribe failed");

	ret = szedata_start(sze);
	if (ret)
		errx(3, "szedata_start failed");

	MSG(CL_VERBOSE_ADVANCED, "Szedata initialized");
	int i;
	for(i = 0; i < PKT_CNT; i++) {
		flag_ok = true;
		do {
			r = szedata_burst_write_next(sze, NULL, 0, test_packet, 64, interface);

			if(r < 0) {
				errx(1, "szedata_prepare_and_try_write_next error");
			} else if(r == 1) {
				/* wait */
				MSG(CL_VERBOSE_OFF, "polling after %d packets", pkt_cnt);
				events = SZEDATA_POLLTX;
				ret = szedata_poll(sze, &events, POLL_TIMEOUT);
				if (ret < 0)
					errx(1, "szedata_poll error");
				flag_ok = false;
			} else if(r == 0) {
				pkt_cnt++;
				if(!(pkt_cnt % 10000))
					MSG(CL_VERBOSE_OFF, "%d packets sent so far", pkt_cnt);
				if(!flag_ok)
					MSG(CL_VERBOSE_OFF, "%d packets sent so far", pkt_cnt);
			}

		} while(r == 1);
	}

	return 0;
}
