
#ifdef __linux__

/* Missing getprogname() function. */

extern const char *__progname;
#define getprogname() __progname

/* Missing strlcpy() function. */

size_t strlcpy(char *dst, const char *src, size_t siz)
{
	char *d = dst;
	const char *s = src;
	size_t n = siz;

	if (n != 0 && --n != 0) {
		do {
			if ((*d++ = *s++) == 0)
				break;
		} while (--n != 0);
	}

	if (n == 0) {
		if (siz != 0)
			*d = '\0';
		while (*s++)
			;
	}

	return(s - src - 1);
}

#endif /* __linux__ */

