/*!
 * \file 	ssramctrl.h
 * \brief 	Functions and registers for controlling ssram_ctrl
 * \author 	Andrej Hank <xhanka00@liberouter.org>
 * \date 	2006, 2007
 */
/*
 * Copyright (C) 2006, 2007 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_SSRAMCTRL_H_
#define _LIBEROUTER_SSRAMCTRL_H_

#include <stdio.h>

#include "../combosix.h"

/*!
 * \defgroup ssram_ctrl_component SSRAM_CTRL component
 * \ingroup components
 * \brief ssram ctrl component control. 
 *  
 * \{
 */

/* Registers */
#define CS_SSRAM_CTRL_REG       0x0000
#define CS_SSRAM_STAT_REG       0x0004
#define CS_SSRAM_BASEADDR_REG   0x1FFC
#define CS_SSRAM_MEM            0x2000

/* Masks */
#define CS_SSRAM_ROW_SEGMENT_MASK 0xFFC00
#define CS_SSRAM_ROW_OFFSET_MASK 0x003FF

/*! Structure for ssram row */
typedef struct cs_ssramctrl_row {
	u_int32_t low; /*!< low 32 bits */
	u_int32_t high; /*!< high 4 bits */
} cs_ssramctrl_row_t;

void cs_ssramctrl_get_unit_control (cs_device_t * dev, cs_space_t * space);
	
void cs_ssramctrl_give_unit_control (cs_device_t * dev, cs_space_t * space);
	
int cs_ssramctrl_get_row_from_string (char *buffer, cs_ssramctrl_row_t *row);

cs_ssramctrl_row_t cs_ssramctrl_read_row (cs_device_t * dev, cs_space_t * space, u_int32_t addr);

void cs_ssramctrl_print_row (cs_ssramctrl_row_t row, FILE *output);

void cs_ssramctrl_write_file (cs_device_t * dev, cs_space_t * space, u_int32_t addr, char *src_file_name);

void cs_ssramctrl_write_byte_write_select (cs_device_t * dev, cs_space_t * space, u_int32_t byte_write_sel);

void cs_ssramctrl_set_base_addr (cs_device_t * dev, cs_space_t * space, u_int32_t rw_base);

void cs_ssramctrl_write_row (cs_device_t * dev, cs_space_t * space, cs_ssramctrl_row_t row, u_int32_t addr);

/*! \}*/

#endif
