/*!
 * \file microwire.h
 * \brief Microwire protocol read/write routines.
 * \author Miroslav Vadkerti <thrix@liberouter.org>
 * \date 2006, 2007
 */

/*
 * Copyright (C) 2003, 2006, 2007 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'', AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COMPANY OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_MICROWIRE_H_
#define _LIBEROUTER_MICROWIRE_H_

/* combo include */
#include "../combosix.h"

/*!
 *
 * \defgroup microwire_component Microwire bus component
 * \ingroup components
 * 
 * \brief This module implements basic routines for reading/writing registers
 * of devices connected with Microwire protocol. 
 *
 * The default address of the register with attached Microwire signals
 * can be overrided with the function cs_microwire_set_reg.
 * 
 * \{
 */
 
void 
cs_microwire_set_reg(u_int32_t);

int
cs_microwire_write_enable(cs_device_t *, cs_space_t *);

int
cs_microwire_write(cs_device_t *, cs_space_t *, u_int32_t, u_int32_t);

int
cs_microwire_read(cs_device_t *, cs_space_t *, u_int32_t, u_int32_t *);

/*! \} */

#endif /* _LIBEROUTER_MICROWIRE_H_ */

