/*!
 * \file flwatch.h
 * \brief Functions for controlling FLWATCH component.
 * \author Petr Springl <xsprin01@liberouter.org>
 * \author Peter Stranak <stranak@liberouter.org>
 * \date 2010
 */

/*
 * Copyright (C) 2007 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_FLWATCH_H_
#define _LIBEROUTER_FLWATCH_H_

#include "../combosix.h"

/*!
 * \defgroup flwatch_component FLWATCH component
 * \ingroup components
 *
 * \brief FLWATCH (FrameLink Watch) component control for reading status of framelink packets.
 *
 * \{
 */

/* deprecated code, left just for compatibility reasons */

/*!
 * \def CS_FLWATCH_MAX_LEN
 * \brief CNTR_WIDTH component constant (must be max 4 bytes)
 * \deprecated Use this macro is valid only if you use #cs_flwatch_component_t.
 */
#define CS_FLWATCH_MAX_LEN 4

/*!
 * \typedef cs_flwatch_component_t
 * \brief Structure for FLWATCH component
 * \deprecated See #cs_flwatch_t
 */
typedef struct {
	/*! Number of interfaces */
	int num_interfaces;
	/*! Counter(s) width */
	int cntr_width;
	/*! Frame counters */
	uint32_t *frames[CS_FLWATCH_MAX_LEN];
	/*! Invalid frame counters */
	uint32_t *invalid_frames[CS_FLWATCH_MAX_LEN];
	/*! Source ready(s) */
	int *src_rdy;
	/*! Destination ready(s) */
	int *dst_rdy;
} cs_flwatch_component_t;

/* Function prototypes */
void cs_flwatch_read(cs_device_t *dev, cs_space_t *space, int num_interfaces,
		int cntr_width, cs_flwatch_component_t *fl_component)
		__attribute__((deprecated));
void cs_flwatch_free(const cs_flwatch_component_t *fl_component)
		__attribute__((deprecated));

/* end of deprecated code */


/*!
 * \typedef cs_flwatch_t
 * \brief Structure for storing data from FLWATCH
 */
typedef struct {
	/*! number of watched interfaces */
	int interfaces;
	/*! width of each counter in bits */
	int cntr_width;
	/*! data from control register */
	u_int32_t control_reg;
	/*! array of structures for each interface */
	struct flwatch_ifc {
		/*! number of frames stored as an array */
		u_int32_t *frames;
		/*! number of invalid frames stored as an array */
		u_int32_t *invalid_frames;
		/*! source ready flag */
		char src;
		/*! destination ready flag */
		char dst;
	} *flwatch_ifc;
} cs_flwatch_t;

u_int32_t cs_flwatch_read_control(cs_device_t *dev, cs_space_t *space);
void cs_flwatch_enable(cs_device_t *dev, cs_space_t *space, int enable);
void cs_flwatch_reset(cs_device_t *dev, cs_space_t *space);
void cs_flwatch_sampling_enable(cs_device_t *dev, cs_space_t *space, int enable);
void cs_flwatch_sample(cs_device_t *dev, cs_space_t *space);

int cs_flwatch_is_enabled(u_int32_t control);
int cs_flwatch_is_sampling_enabled(u_int32_t control);
int cs_flwatch_is_sampling_available(u_int32_t control);

int cs_flwatch_read_data(cs_device_t *dev, cs_space_t *space,
		int num_interfaces, int cntr_width, cs_flwatch_t *fl_comp);
void cs_flwatch_free_data(cs_flwatch_t *fl_comp);

/*! \} */

#endif /* _LIBEROUTER_FLWATCH_H_ */
