/**
 * \file crypto.h
 * \brief Basic communication with cryptochips.
 * \author Jakub Bezak <xbezak00@liberouter.org>
 * \author Matus Holec <xholec00@liberouter.org>
 * \date 2009
 */

/*
 * Copyright (C) 2009  CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_CRYPTO_H_
#define _LIBEROUTER_CRYPTO_H_

#include "../combosix.h"

/*!
 * \defgroup i2c_component I2C component
 * \ingroup components 
 * \{
 *
 * \brief This module implements basic routines for reading/writing data 
 * into the cryptochips.
 *
 *
 */

int
cs_crypto_write_data(cs_device_t * dev, cs_space_t * i2c, int zone, u_int16_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_read_data(cs_device_t * dev, cs_space_t * i2c, int zone, u_int16_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_unlock_conf_memory(cs_device_t * dev, cs_space_t * i2c, u_int8_t address1, u_int8_t* data);

int
cs_crypto_read_config_memory(cs_device_t * dev, cs_space_t * i2c, u_int8_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_write_config_memory_data(cs_device_t * dev, cs_space_t * i2c, u_int8_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_write_config_memory_codes(cs_device_t * dev, cs_space_t * i2c, u_int8_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_write_config_memory_id_number(cs_device_t * dev, cs_space_t * i2c, u_int8_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_write_config_memory_registers(cs_device_t * dev, cs_space_t * i2c, u_int8_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_write_config_memory_secret_seeds(cs_device_t * dev, cs_space_t * i2c, u_int8_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_write_config_memory_issuer_code(cs_device_t * dev, cs_space_t * i2c, u_int8_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_write_config_memory_cryptogram_N(cs_device_t * dev, cs_space_t * i2c, u_int8_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_write_config_memory_session_encryption_key(cs_device_t * dev, cs_space_t * i2c, u_int8_t address, u_int8_t data_size, u_int8_t *data);

int
cs_crypto_read_fuse_byte(cs_device_t * dev, cs_space_t * i2c, u_int8_t *data);

/*! \} */

#endif /* _LIBEROUTER_CRYPTO_H_ */
