/*!
 * \file cam.h
 * \brief Function prototypes for loading cam
 * \author Andrej Hank <xhanka00@liberouter.org>
 * \date 2006, 2007
 */
/* 
 * Copyright (C) 2006, 2007 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_CAM_H_
#define _LIBEROUTER_CAM_H_

#include "../combosix.h"

/*!
 * \defgroup cam_component CAM component
 * \ingroup components
 * 
 * \brief CAM loading  
 *  
 * \{*/

/*! Command register address */
#define CS_CAM_CMD_REG 	        0x0000
/*! Status register address */
#define CS_CAM_STAT_REG 	0x0040
/*! Mask register address */
#define CS_CAM_MASK_REG	        0x0080
/*! Data register address */
#define CS_CAM_DATA_REG	        0x00C0
/*! Address register address */
#define CS_CAM_ADR_REG		0x0100
/*! Write command */
#define CS_CAM_WRT_CMD		0x0140	

/*! Cam row, generic width because of strings */
typedef struct cs_cam_row {
	char * data; /*!< data */
	char * mask; /*!< mask */
} cs_cam_row_t;

int cs_cam_read_rows_from_file (char * src_file_name, cs_cam_row_t ** rows);

void cs_cam_write_row(cs_device_t * dev, cs_space_t * cam, cs_cam_row_t row, int cam_count);

int cam_fill_reg(cs_device_t *, cs_space_t *, u_int32_t, char *);

int cs_cam_fill(cs_device_t * dev, cs_space_t * cam, cs_cam_row_t * rows, int rows_count);

void cs_cam_free_rows(cs_cam_row_t *rows, int count);

int cs_cam_fill_from_file(cs_device_t * dev, cs_space_t * cam, char * src_file_name);

/*! \}*/

#endif
