/*!
 * \file cs_local.h:
 *
 * \brief Local (private to library) Combo6 interface
 *
 * \author Jachym Holecek <freza@liberouter.org>,
 * \author Jaroslav Kysela <perex@perex.cz>
 */
 /*
 * Copyright (C) 2003,2004 CESNET
 *  
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL) version 2 or later, in which case the provisions
 * of the GPL apply INSTEAD OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_CS_LOCAL_H_
#define _LIBEROUTER_CS_LOCAL_H_

#define LIBCOMBO_UNUSED_PARAMETER(x) (void *)libcombo_unused_parameter__##x = &x

#define CHIP_XCV3000	"xcv3000"
#define CHIP_XCVP50	"xcvp50"
#define CHIP_LX110T	"xc5vlx110t"
#define CHIP_LX155T	"xc5vlx155t"
#define CHIP_FX100T	"xc5vfx100t"
#define CHIP_LX240T	"xc6vlx240t"
#define CHIP_TX240T	"xc5vtx240t"
#define CHIP_HX365T	"xc6vhx365t"
#define CHIP_VX690T	"xc7vx690t"
#define CHIP_VH580T	"xc7vh580t"

/* all supported types of FPGA chips defined in file id.c */
extern const char *cs_available_chips[];

/*!
 * Maximum size of design ASCII ID including '\0'
 */
#define CS_DESIGN_STRID_SIZE	32

/*!
 * Handle to given device instance.
 */
struct cs_device {
	volatile u_int32_t 	*dv_mmap;
	int			dv_file;
	int			dv_flag;
	u_int32_t		dv_msiz;	/*!< Address window size */
	cs_target_t		dv_bussel;	/*!< Who is on local bus now */
	u_int32_t		dv_id;		/*!< Unique 32-bit design ID */
	u_int32_t		dv_id_hw;	/*!< 32-bit design hardware ID */
	u_int8_t		dv_strid[CS_DESIGN_STRID_SIZE];	/*!< ASCII ID (not unique) */
	cs_component_t		* first;	/*!< First component */
	char			* name;		/*!< Design name */
	u_int32_t		ver_major;	/*!< Design version - major */
	u_int32_t		ver_minor;	/*!< Design version - minor */
	time_t			timestamp;	/*!< Design creation timestamp */

	/* New card identification - CV2 card family */
	char			*dv_board;	/*!< Main board */
	char			*dv_board_subtype; /*!< Main board subtype */
	char			*dv_if0_card;	/*!< Addon board in iface connector 0 */
	char			*dv_if0_chip;	/*!< Chip of addon board */
	char			*dv_if1_card;	/*!< Addon board in iface connector 1 */
	char			*dv_if1_chip;	/*!< Chip of addon board */

	/* Obsolote - old card (C6 and C6X) identification was */
#if 0 
	char			*dv_board;	/*!< Main board */
	char			*dv_card;	/*!< Addon card */
	char			*dv_chip;	/*!< Addon chip */
#endif


};

/*!
 * Handle to region of address space for low-level access.
 */
struct cs_space {
	cs_addr_t		sp_base;	/*!< Base offset of space */
	cs_size_t		sp_size;	/*!< Size of mapping */
	cs_target_t		sp_type;	/*!< Mapping's target space */
	u_int32_t		sp_flag;
};

/*!
 * Handle component.
 */
struct cs_component {
	const char		* name;		/*!< ASCII name */
	cs_cidx_t		index;		/*!< index (instance) */
	cs_cver_t		version;	/*!< component version */
	cs_space_t		* space;	/*!< space for i/o */
	cs_component_t		* parent;	/*!< parent in component tree */
	cs_component_t		* child;	/*!< first child in component tree */
	cs_component_t		* next;		/*!< next child (same level) */
	void			* priv_data;	/*!< private data */
	void (* priv_free)(void *);		/*!< free private_data */
	void			* upriv_data;	/*!< user private data */
	void (* upriv_free)(void *);		/*!< free user private data */
};

/*!
 * XML file structure
 */
struct cs_xml {
	int			fd;		/*!< file descriptor */
	const char		* data;		/*!< mmaped file context */
	size_t			size;		/*!< size of file in bytes */
	cs_xml_tag_t		* root;		/*!< root xml tag */
};

/*!
 * XML tag structure
 */
struct cs_xml_tag {
	const char		* name;		/*!< tag name */
	size_t			name_size;	/*!< tag name size */
	size_t			attr_size;	/*!< tag attr size */
	const char		* body;		/*!< tag body */
	size_t			body_size;	/*!< tag body size */
	cs_xml_tag_t		* parent;	/*!< parent tag */
	cs_xml_tag_t		* child;	/*!< child tag */
	cs_xml_tag_t		* next;		/*!< next tag */
};

#endif /* _LIBEROUTER_CS_LOCAL_H_ */
