#ifndef __COMBO6REG_H
#define __COMBO6REG_H

/*
 * CPLD's register, used to boot FPGA. There are 128 base locations
 * (ie. possible FPGAs).
 */
#define COMBO6_CPLD_BASE(n)     ((n) << 9)

#define COMBO6_CPLD_CONF	0x00
#define CONF_FSPROG		0x00000001
#define CONF_MSPROG		0x00000002
#define CONF_IO44		0x00000004
#define CONF_IO45		0x00000008
#define CONF_IO46		0x00000010
#define CONF_FSINIT	     0x00000002
#define CONF_FSDONE	     0x00000001


#define COMBO6_CPLD_DATA	0x04

/*
 * COMBO6_CPLD_CONF bitmask on FPGA9, used for daughter identification.
 */
#define COMBO6_ADDON_CARD(val)	(((val) >> 5) & 0x07)
#define COMBO6_ADDON_CHIP(val)	(((val) >> 2) & 0x07)

/* Values used for CPLD addon detection */
#define ADDON_PATTERN		0x5b		/* arbitrary */
#define ADDON_MASK		0xfc

#define COMBO6_ADDON_CARD_UNK		0
#define COMBO6_ADDON_CARD_SFP		1
#define COMBO6_ADDON_CARD_MTX		2
#define COMBO6_ADDON_CARD_XFP		3
#define COMBO6_ADDON_CARD_SFPRO		4
#define COMBO6_ADDON_CARD_XFPRO		5
#define COMBO6_ADDON_CARD_XFP2_0	6
#define COMBO6_ADDON_CARD_XFP2		7
#define COMBO6_ADDON_CARD_XFP2_2	8
#define COMBO6_ADDON_CARD_LAST		8

#define COMBO6_ADDON_CARD_GET(cpld_val, ccpld_val) \
	((cpld_val) < 3 ? (cpld_val) : \
	 ((cpld_val) == 3 ? \
	   ((ccpld_val) == 2 ? COMBO6_ADDON_CARD_XFP2_0 : \
	    ((ccpld_val) == 3 ? COMBO6_ADDON_CARD_XFP2 : \
	    ((ccpld_val) == 4 ? COMBO6_ADDON_CARD_XFP2_2 : \
				COMBO6_ADDON_CARD_XFP))) : \
	 ((cpld_val) == 5 ? COMBO6_ADDON_CARD_SFPRO : \
	  ((cpld_val) == 7 ? COMBO6_ADDON_CARD_XFPRO : \
	  COMBO6_ADDON_CARD_UNK))))

#define COMBO6_ADDON_CHIP_UNK		0
#define COMBO6_ADDON_CHIP_XCV1000	1
#define COMBO6_ADDON_CHIP_XCV2000	2
#define COMBO6_ADDON_CHIP_XC2VP20	3
#define COMBO6_ADDON_CHIP_XC2VPX20	4
#define COMBO6_ADDON_CHIP_XC2VP30	5
#define COMBO6_ADDON_CHIP_LAST		5

#define COMBO6_ADDON_CHIP_GET(card, cpld_val) \
	( \
	  ((card) == COMBO6_ADDON_CARD_XFP || \
	   (card) == COMBO6_ADDON_CARD_SFPRO || \
	   (card) == COMBO6_ADDON_CARD_XFPRO || \
	   (card) == COMBO6_ADDON_CARD_XFP2_0 || \
	   (card) == COMBO6_ADDON_CARD_XFP2 || \
	   (card) == COMBO6_ADDON_CARD_XFP2_2) ? \
	    ( \
	      (cpld_val) == 1 ? COMBO6_ADDON_CHIP_XC2VP20 : \
	      ( \
		((cpld_val) >= 2 || (cpld_val) <= 4) ? \
		  COMBO6_ADDON_CHIP_XC2VP30 : \
		( \
		  (cpld_val) == 5 ? COMBO6_ADDON_CHIP_XC2VPX20 : \
		  COMBO6_ADDON_CHIP_UNK \
		) \
	      ) \
	    ) : \
	    ( \
	      (cpld_val) < 3 ? (cpld_val) : COMBO6_ADDON_CHIP_UNK \
	    ) \
	)

#define COMBO6_ADDON_INTERFACES_GET(card, chip) \
	( \
	  (card) == COMBO6_ADDON_CARD_SFP ? 4 : \
	  (card) == COMBO6_ADDON_CARD_MTX ? 4 : \
	  (card) == COMBO6_ADDON_CARD_XFP ? 2 : \
	  (card) == COMBO6_ADDON_CARD_SFPRO ? 4 : \
	  (card) == COMBO6_ADDON_CARD_XFPRO ? 2 : \
	  (card) == COMBO6_ADDON_CARD_XFP2_0 ? 3 : \
	  (card) == COMBO6_ADDON_CARD_XFP2 ? 3 : \
	  (card) == COMBO6_ADDON_CARD_XFP2_2 ? 3 : \
	  -1 \
	)

#endif
