#ifndef __SZE2_H__
#define __SZE2_H__

#include <linux/wait.h>

#define SZEDATA2_MAX_MINORS	8

#define SZE2_WAKE_REASON_RX	1
#define SZE2_WAKE_REASON_TX	2
#define SZE2_WAKE_REASON_ERR	3

struct szedata2_app {
	struct szedata2 *sd;
	struct list_head list; /* entry in sd->app_list */
	wait_queue_head_t poll_wait;
	unsigned long wake_reason;
	struct sze2_instance_info *status_page;
	u32 *write_size;
	unsigned long started[2];
	struct {
		struct {
			unsigned long head;
			unsigned long tail;
		} rx;
		struct {
			__u32 size;
		} tx;
	} ptrs[0];
};

extern int szedata2_char_init(void);
extern void szedata2_char_exit(void);
extern int szedata2_char_add(struct szedata2 *sd, int minor);
extern void szedata2_char_remove(struct szedata2 *sd);

extern struct szedata2_app *szedata2_open(struct szedata2 *sd,
		unsigned int idx);
extern int szedata2_subscribe_area(struct szedata2_app *app,
		struct sze2_subscribe_area *sub);
extern int szedata2_start_devices(struct szedata2_app *app);
extern void szedata2_stop_devices(struct szedata2_app *app);
extern int szedata2_rxlock_data(struct szedata2_app *app, unsigned long areas);
extern void szedata2_rxunlock_data(struct szedata2_app *app);
extern int szedata2_txlock_data(struct szedata2_app *app,
		struct sze2_tx_lock *tx);
extern int szedata2_txunlock_data(struct szedata2_app *app,
		struct sze2_tx_unlock *tx);
extern unsigned int szedata2_poll(struct szedata2_app *app);
extern void szedata2_close(struct szedata2_app *app);

#endif
