/*
 * szedata 2 hardware registers
 *
 * Copyright (c) 2008 CESNET
 * Copyright (c) 2008 Jiri Slaby <jirislaby@gmail.com>
 *
 * Licensed under GPLv2
 */

#ifndef HW_H_FILE
#define HW_H_FILE

#include <linux/bitops.h>

#include "combo6pcr.h"

/* intr in pci bridge */
#define SZE2_HW_INTR_RX		INTR_USER(0)
#define SZE2_HW_INTR_TX		INTR_USER(1)

#define SZE2_HW_DMA_SIZE	0x40

#define SZE2_HW_DIR_RX		0
#define SZE2_HW_DIR_TX		1

#define SZE2_HW_ADDR_BASE	0x0800

#define SZE2_HW_DMA(dir, unit, addr) \
	((((dir) * SZE2_HW_DMA_SIZE) + \
	  ((unit) * 2 * SZE2_HW_DMA_SIZE)) | \
	 (addr) | SZE2_HW_ADDR_BASE)

#define SZE2_HW_CTL		0x00
#define SZE2_HW_CTL_START	0x1
#define SZE2_HW_CTL_PAUSE	0x2
#define SZE2_HW_CTL_STOP	0x4
#define SZE2_HW_STAT		0x04
#define SZE2_HW_STAT_UNDEF	0x0
#define SZE2_HW_STAT_IDLE	0x1
#define SZE2_HW_STAT_RUNNING	0x2
#define SZE2_HW_STAT_PAUSE	0x4
#define SZE2_HW_STARTPTR	0x08
#define SZE2_HW_ENDPTR		0x0c
#define SZE2_HW_BUFSIZE		0x10
#define SZE2_HW_IRQ		0x14
#define SZE2_HW_IRQ_TIMEOUTE	0x1
#define SZE2_HW_IRQ_PTRE	0x2
#define SZE2_HW_IRQ_PTR(p)	((p) & ~0x3)
#define SZE2_HW_TIMEOUT		0x18
#define SZE2_HW_TIMEOUT_NS(ns)	((ns) / 5)

#define SZE2_HW_DESCS_BASE	0x02240000
#define SZE2_HW_DESCS_SIZE	0x8

#define SZE2_HW_DESCS(dir, unit) \
	((((dir) * SZE2_HW_DESCS_SIZE) + \
	  ((unit) * 2 * SZE2_HW_DESCS_SIZE)) | \
	 SZE2_HW_DESCS_BASE)
#define SZE2_HW_DESCS_PTR	0x1

#define SZE2_HW_RX_IRQ		0x02280000
#define SZE2_HW_TX_IRQ		0x02280008

#endif
