/*
 *  kocompat.h: old kernel compatibility section
 *  Copyright (c) 2006 CESNET
 *  Author(s): Jaroslav Kysela <perex@perex.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#ifndef FILE_KOCOMPAT_H
#define FILE_KOCOMPAT_H

#include "config.h"

#include <generated/autoconf.h> /* old kernels don't include it on cmdline */

#include <linux/bitops.h>
#include <linux/compiler.h>
#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/string.h>
#include <linux/version.h>

#ifndef list_first_entry
#define list_first_entry(ptr, type, member) \
		list_entry((ptr)->next, type, member)
#endif

#ifndef BIT
#define BIT(nr)			(1UL << (nr))
#endif
#ifndef for_each_bit
#define for_each_bit(bit, addr, size) \
	for ((bit) = find_first_bit((addr), (size)); \
		(bit) < (size); \
		(bit) = find_next_bit((addr), (size), (bit) + 1))
#endif

#ifndef uninitialized_var
#define uninitialized_var(x)	x = x
#endif
#ifndef DIV_ROUND_UP
#define DIV_ROUND_UP(n,d)	(((n) + (d) - 1) / (d))
#endif

#ifndef SEEK_SET
#define SEEK_SET	0
#define SEEK_CUR	1
#define SEEK_END	2
#endif

#ifndef PCI_EXP_LNKCTL
#define PCI_EXP_LNKCTL		16
#endif
#ifndef PCI_EXP_LNKCTL_LD
#define PCI_EXP_LNKCTL_LD	0x0010
#endif
#ifndef PCI_EXP_LNKSTA
#define PCI_EXP_LNKSTA		18
#endif
#ifndef PCI_EXP_LNKSTA_NLW
#define PCI_EXP_LNKSTA_NLW	0x03f0
#endif

#ifndef clamp
#define clamp(val, min, max) ({			\
	typeof(val) __val = (val);		\
	typeof(min) __min = (min);		\
	typeof(max) __max = (max);		\
	(void) (&__val == &__min);		\
	(void) (&__val == &__max);		\
	__val = __val < __min ? __min: __val;	\
	__val > __max ? __max: __val; })
#endif

#ifndef clamp_t
#define clamp_t(type, val, min, max) ({		\
	type __val = (val);			\
	type __min = (min);			\
	type __max = (max);			\
	__val = __val < __min ? __min: __val;	\
	__val > __max ? __max: __val; })
#endif

#ifdef CONFIG_NO_READQ
#include <linux/io.h>
static inline __u64 readq(const volatile void __iomem *addr)
{
	const volatile u32 __iomem *p = addr;
	u32 low, high;

	low = readl(p);
	high = readl(p + 1);

	return low + ((u64)high << 32);
}
#endif

#ifndef CONFIG_HAVE_NET_DEVICE_OPS
struct net_device_ops {
	typeof(((struct net_device *)NULL)->hard_start_xmit) ndo_start_xmit;
#define DEFINE_NDO_OP(x)	typeof(((struct net_device *)NULL)->x) ndo_##x
	DEFINE_NDO_OP(open);
	DEFINE_NDO_OP(stop);
	DEFINE_NDO_OP(get_stats);
	DEFINE_NDO_OP(set_multicast_list);
	DEFINE_NDO_OP(do_ioctl);
	DEFINE_NDO_OP(tx_timeout);
	DEFINE_NDO_OP(change_mtu);
#undef DEFINE_NDO_OP
};

static inline void combo6_copy_ndev_ops(struct net_device *ndev,
		const struct net_device_ops *ops)
{
	ndev->hard_start_xmit = ops->ndo_start_xmit;
#define COPY_NDO_OP(x)	ndev->x = ops->ndo_##x
	COPY_NDO_OP(open);
	COPY_NDO_OP(stop);
	COPY_NDO_OP(get_stats);
	COPY_NDO_OP(set_multicast_list);
	COPY_NDO_OP(do_ioctl);
	COPY_NDO_OP(tx_timeout);
	COPY_NDO_OP(change_mtu);
#undef COPY_NDO_OP
}
#endif

#ifndef CONFIG_NDEV_NO_STATS
static inline struct net_device_stats *
combo_get_ndev_stats(struct net_device *ndev)
{
	return &ndev->stats;
}
#endif

/* it's broken there */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 19)
#include <asm/bug.h>
#undef WARN_ON
#define WARN_ON(x) unlikely(x)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,29)
#define CONFIG_PROC_ENTRY_HAS_OWNER
#endif

#ifndef CONFIG_HAVE_NETDEV_PRIV
static inline void *netdev_priv(struct net_device *ndev)
{
	return ndev->priv;
}
#endif

#ifdef CONFIG_NO_NDEV_ALLOC_SKB
#include <linux/device.h>
#include <linux/skbuff.h>
static inline struct sk_buff *__netdev_alloc_skb(struct net_device *dev,
		unsigned int length, gfp_t gfp_mask)
{
	struct sk_buff *skb;

	skb = alloc_skb(length + 32, gfp_mask);
	if (likely(skb)) {
		skb_reserve(skb, 32);
		skb->dev = dev;
	}
	return skb;
}
static inline struct sk_buff *netdev_alloc_skb(struct net_device *dev,
		unsigned int length)
{
	return __netdev_alloc_skb(dev, length, GFP_ATOMIC);
}
#endif

#ifdef CONFIG_NO_IS_POW2
static inline __attribute__((const)) int is_power_of_2(unsigned long n)
{
        return n != 0 && ((n & (n - 1)) == 0);
}
#endif

#ifndef CONFIG_HAVE_ROUND_JIFFIES
#define round_jiffies(j)	(j)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,18)
typedef unsigned long resource_size_t;
#endif

#ifdef CONFIG_NO_SETUP_TIMER
#include <linux/timer.h>
static inline void setup_timer(struct timer_list *timer,
		void (*function)(unsigned long),
		unsigned long data)
{
	timer->function = function;
	timer->data = data;
	init_timer(timer);
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,18)
#define IRQF_DISABLED	SA_INTERRUPT
#define IRQF_SHARED	SA_SHIRQ
#endif

#ifdef CONFIG_NO_VMALLOC_USER
#include <linux/vmalloc.h>
static inline void *vmalloc_user(unsigned long size)
{
	void *ret = vmalloc(size);
	if (ret)
		memset(ret, 0, size);
	return ret;
}
static inline void *vmalloc_32_user(unsigned long size)
{
	void *ret = vmalloc_32(size);
	if (ret)
		memset(ret, 0, size);
	return ret;
}
#endif

#ifndef CONFIG_DEVICE_CREATE5
#include <linux/module.h>
#include <linux/device.h>

#ifdef CONFIG_DEVICE_CREATE4
#define device_create(cls, parent, devt, drvdata, args...) ({ \
	struct device *__dcdev = device_create(cls, parent, devt, args); \
	if (!IS_ERR(__dcdev)) \
		dev_set_drvdata(__dcdev, drvdata); \
	__dcdev; \
	})
/* These struct class_simple aliasing to struct class are ugly as hell.
 * Maybe implementing class_simple for old kernels on our own would be the
 * best solution. Also class_simple is not in kernels prior to 2.6.5... -js */
#elif defined(CONFIG_CLASS_DEVICE_CREATE5)
#define device_create(cls, parent, devt, drvdata, args...) ({ \
		class_device_create(cls, NULL, devt, parent, args); \
		NULL; /* do not use its retval */ \
	})
#define device_destroy(cls, devt) \
	class_device_destroy(cls, devt)
#elif defined(CONFIG_CLASS_DEVICE_CREATE4)
#define device_create(cls, parent, devt, drvdata, args...) ({ \
		class_device_create(cls, devt, parent, args); \
		NULL; /* do not use its retval */ \
	})
static inline void device_destroy(struct class *cls, dev_t devt)
{
	class_device_destroy(cls, devt);
}
#else
#error UNSUPPORTED (old) kernel version
#endif /* >= 2.6.13 */
#endif /* < 2.6.18 */

#ifdef CONFIG_OLD_IRQ_HANDLER
#include <linux/interrupt.h>
#define request_irq(irq, handler, flags, devname, dev_id) \
	request_irq(irq, handler ## _old, flags, devname, dev_id);
#endif

#ifdef CONFIG_NO_DMA_BMSK
#define DMA_BIT_MASK(n)	(((n) == 64) ? ~0ULL : ((1ULL<<(n))-1))
#endif

#ifdef CONFIG_NO_DEVNAME
#include <linux/device.h>
static inline const char *dev_name(struct device *dev)
{
	return dev->bus_id;
}
#endif
#ifdef CONFIG_NO_DEVSETNAME
#define dev_set_name(dev, fmt...) \
	snprintf((dev)->bus_id, sizeof((dev)->bus_id), fmt)
#endif


#ifdef CONFIG_NO_PRINT_HEX
enum {
        DUMP_PREFIX_NONE,
        DUMP_PREFIX_ADDRESS,
        DUMP_PREFIX_OFFSET
};
static inline void print_hex_dump_bytes(const char *prefix_str, int prefix_type,
		const void *buf, size_t len)
{
	printk(KERN_DEBUG "%s: unsupported on this kernel\n", __func__);
}
static inline void print_hex_dump(const char *level, const char *prefix_str,
		int prefix_type, int rowsize, int groupsize, const void *buf,
		size_t len, int ascii)
{
	printk(KERN_DEBUG "%s: unsupported on this kernel\n", __func__);
}
#endif

#include <linux/sched.h>
#include <linux/signal.h>
static inline int combo_fatal_signal_pending(struct task_struct *p)
{
	int ret;

	if (!signal_pending(p))
		return 0;
	spin_lock_irq(&p->sighand->siglock);
	ret = sigismember(&p->pending.signal, SIGKILL) ||
		sigismember(&p->signal->shared_pending.signal, SIGKILL);
	spin_unlock_irq(&p->sighand->siglock);
	return ret;
}

#ifndef ciminor
#define ciminor(x) MINOR((x)->i_rdev)
#endif

#ifndef __RCSID

/*
 * Note that using these BSDisms is real bullshit in my eyes. The much
 * better way to identify sources is an external method like SCM tags and
 * version included to the binary. The Linux development model does not
 * allow using such useless "helpers", because developers are using
 * wide range of SCM tools (especially distributed ones) so referencing
 * something to RCS loses the original information after a time and
 * the final source might be very different and eventually this information
 * is very confusing. If you look to Linux sources you can find almost
 * all Id: strings with really old dates. Also being lazy and telling
 * "no, I do not need to use the diff and hand review for new code if
 * I have RCS IDs" is the biggest nonsense I have ever heard. You
 * cannot merge something without review and code insight. --perex
 * 
 * Note that RCSID and Id: strings in comments does not prevent:
 * 1) modification of sources and compilation from source without CVS commit
 * 2) header files modification (might have big influence to code behaviour)
 *
 * Using these helpers is the combo6 project management decision.
 */

#if __GNUC__ == 3 && __GNUC_MINOR__ >= 3 || __GNUC__ > 3
#define __IDSTRING(name,string) \
static const char name[] __attribute__((__used__)) = string
#else
#define __IDSTRING(name,string) \
static const char name[] __attribute__((__unused__)) = string
#endif
                
#define __RCSID(s) __IDSTRING(rcsid,s)

#endif /* !__RCSID*/

#endif /* FILE_KOCOMPAT_H */
