----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 03/27/2015 06:12:17 PM
-- Design Name: 
-- Module Name: kernel - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_SIGNED.ALL;


entity kernel is
    Generic(
       FRAME_WIDTH  : integer := 512
   );
    Port ( 
    
        aclk : in STD_LOGIC;
        resetn : in STD_LOGIC;
        
        in_00  : in std_logic_vector(15 downto 0);
        in_01  : in std_logic_vector(15 downto 0);
        in_10  : in std_logic_vector(15 downto 0);
        in_11  : in std_logic_vector(15 downto 0);
        in_valid   : std_logic;
        
        out_00  : out std_logic_vector(15 downto 0);
        out_01  : out std_logic_vector(15 downto 0);
        out_10  : out std_logic_vector(15 downto 0);
        out_11  : out std_logic_vector(15 downto 0);
        out_valid  : out std_logic   
           
           );
end kernel;

architecture Behavioral of kernel is

component p_h is
    Port ( aclk : in STD_LOGIC;
           resetn : in STD_LOGIC;
           valid_in : in std_logic;
           in_d : in STD_LOGIC_VECTOR (15 downto 0);
           in_s : in STD_LOGIC_VECTOR (15 downto 0);
           out_d : out STD_LOGIC_VECTOR (15 downto 0);
           out_s : out STD_LOGIC_VECTOR (15 downto 0));
end component;

component u_h is
    Port ( 
        aclk : in STD_LOGIC;
        resetn : in STD_LOGIC;
        valid_in : in std_logic;
        in_d : in STD_LOGIC_VECTOR (15 downto 0);
        in_s : in STD_LOGIC_VECTOR (15 downto 0);
        out_d : out STD_LOGIC_VECTOR (15 downto 0);
        out_s : out STD_LOGIC_VECTOR (15 downto 0));
end component;

component p_v is
     Generic(
       FRAME_WIDTH  : integer := 1920
   );
   Port ( 
       aclk : in STD_LOGIC;
       resetn : in STD_LOGIC;
       valid_in : in std_logic;
       in_d : in STD_LOGIC_VECTOR (15 downto 0);
       in_s : in STD_LOGIC_VECTOR (15 downto 0);
       out_d : out STD_LOGIC_VECTOR (15 downto 0);
       out_s : out STD_LOGIC_VECTOR (15 downto 0));
end component;

component u_v is
     Generic(
       FRAME_WIDTH  : integer := 1920
   );
   Port ( 
       aclk : in STD_LOGIC;
       resetn : in STD_LOGIC;
       valid_in : in std_logic;
       in_d : in STD_LOGIC_VECTOR (15 downto 0);
       in_s : in STD_LOGIC_VECTOR (15 downto 0);
       out_d : out STD_LOGIC_VECTOR (15 downto 0);
       out_s : out STD_LOGIC_VECTOR (15 downto 0));
end component;

-----------------------------------------------------------------------

type array_4x16b is array (3 downto 0) of std_logic_vector(15 downto 0);

signal input: array_4x16b;
signal preH : array_4x16b;
signal upH  : array_4x16b;
signal preV : array_4x16b;
signal upV  : array_4x16b;

signal next_valid_in    : std_logic_vector(3 downto 1);

begin

sync: process(aclk)
begin
    if aclk'event and aclk = '1' then
        next_valid_in(1) <= in_valid;
        next_valid_in(2) <= next_valid_in(1);
        next_valid_in(3) <= next_valid_in(2);
        out_valid <= next_valid_in(3);
    end if;
end process;

input(0) <= in_00;
input(1) <= in_01;
input(2) <= in_10;
input(3) <= in_11;


out_00  <= upH(0);
out_01  <= upH(1);
out_10  <= upH(2);
out_11  <= upH(3);


pV0_map: p_v 
generic map(
    FRAME_WIDTH => FRAME_WIDTH
)
port map(
    aclk => aclk,
    resetn => resetn,
    valid_in => in_valid,
    in_d => input(0),
    in_s => input(2),
    out_d => preV(2),
    out_s => preV(0)
);

pV1_map: p_v 
generic map(
    FRAME_WIDTH => FRAME_WIDTH
)
port map(
    aclk => aclk,
    resetn => resetn,
    valid_in => in_valid,
    in_d => input(1),
    in_s => input(3),
    out_d => preV(3),
    out_s => preV(1)
);

uV0_map: u_v 
generic map(
    FRAME_WIDTH => FRAME_WIDTH
)
port map(
    aclk => aclk,
    resetn => resetn,
    valid_in => next_valid_in(1),
    in_d => preV(2),
    in_s => preV(0),
    out_d => upV(2),
    out_s => upV(0)
);

uV1_map: u_v 
generic map(
    FRAME_WIDTH => FRAME_WIDTH
)
port map(
    aclk => aclk,
    resetn => resetn,
    valid_in => next_valid_in(1),
    in_d => preV(3),
    in_s => preV(1),
    out_d => upV(3),
    out_s => upV(1)
);

pH0_map: p_h port map(
    aclk => aclk,
    resetn => resetn,
    valid_in => next_valid_in(2),
    in_d => upV(0),
    in_s => upV(1),
    out_d => preH(1),
    out_s => preH(0)
);

pH1_map: p_h port map(
    aclk => aclk,
    resetn => resetn,
    valid_in => next_valid_in(2),
    in_d => upV(2),
    in_s => upV(3),
    out_d => preH(3),
    out_s => preH(2)
);

uH0_map: u_h port map(
    aclk => aclk,
    resetn => resetn,
    valid_in => next_valid_in(3),
    in_d => preH(1),
    in_s => preH(0),
    out_d => upH(1),
    out_s => upH(0)
);

uH1_map: u_h port map(
    aclk => aclk,
    resetn => resetn,
    valid_in => next_valid_in(3),
    in_d => preH(3),
    in_s => preH(2),
    out_d => upH(3),
    out_s => upH(2)
);

end Behavioral;
