----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 04/08/2015 08:22:00 PM
-- Design Name: 
-- Module Name: V2 - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_SIGNED.ALL;

entity V2 is
    Generic(
       FRAME_WIDTH  : integer := 1920
    );
    Port ( 
        aclk     : in STD_LOGIC;
        resetn   : in STD_LOGIC;
        valid_in : in std_logic;
        in_d     : in STD_LOGIC_VECTOR (15 downto 0);
        in_s     : in STD_LOGIC_VECTOR (15 downto 0);
        out_d    : out STD_LOGIC_VECTOR (15 downto 0);
        out_s    : out STD_LOGIC_VECTOR (15 downto 0)       
       );
end V2;

architecture Behavioral of V2 is

constant WIDTH    : integer := (FRAME_WIDTH+4)/2;
type array_linex16b is array (0 to WIDTH-1) of std_logic_vector(32 downto 0);

signal ram : array_linex16b := (others => (others =>'0'));

signal s0 : std_logic_vector(15 downto 0) := X"0000";
signal s1 : std_logic_vector(15 downto 0) := X"0000";
signal carry_old : std_logic;

signal act_s0       : std_logic_vector(15 downto 0) := X"0000";
signal act_s1       : std_logic_vector(15 downto 0) := X"0000";
signal act_carry    : std_logic;

signal ram_buff     : std_logic_vector(32 downto 0);
signal index : integer range 0 to WIDTH-1 := 0;

begin

sync: process(aclk)
    variable temp: std_logic_vector(16 downto 0);
    variable temp1: std_logic_vector(18 downto 0);
    variable temp2: std_logic_vector(17 downto 0);
    variable carry: std_logic;
begin
    if aclk'event and aclk= '1' then
        if resetn = '0' then
               index <= 0;
        elsif valid_in = '1' then
            temp := (in_s(15) & in_s) + act_s0;
            out_d <= in_d - temp(16 downto 1);            
            
            
            carry := not(in_s(0) and act_s0(0));
            carry_old <= carry;
            s0 <= in_s;                                                
            temp1 := in_s&"00" - in_s(15 downto 1)&'0' + in_d - act_s0(15 downto 1);
            s1 <= temp1(15 downto 0);
            temp2 := (act_s1(15)&act_s1(15)&act_s1 + in_d  + carry) - in_s(15 downto 1) + act_carry;
            out_s <= temp2(17 downto 2);
            
            act_s0  <= ram_buff(15 downto 0);
            act_s1  <= ram_buff(31 downto 16);
            act_carry<= ram_buff(32);
            
            if index = (WIDTH-1) then
                index <= 0;
            else
                index <= index + 1;
            end if;
        end if;
    end if;
end process;




bram: process(aclk)
begin
    if(aclk'event and aclk = '1') then
        if(valid_in = '1') then
            ram(index) <= carry_old&s1&s0;
        end if;                    
        ram_buff <= ram(index);
    end if;
end process;

end Behavioral;
