----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 04/08/2015 05:16:06 PM
-- Design Name: 
-- Module Name: H2 - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_SIGNED.ALL;

entity H2 is
    Port ( 
        aclk     : in STD_LOGIC;
        resetn   : in STD_LOGIC;
        valid_in : in std_logic;
        in_d     : in STD_LOGIC_VECTOR (15 downto 0);
        in_s     : in STD_LOGIC_VECTOR (15 downto 0);
        out_d    : out STD_LOGIC_VECTOR (15 downto 0);
        out_s    : out STD_LOGIC_VECTOR (15 downto 0)       
       );
end H2;

architecture Behavioral of H2 is

signal s0 : std_logic_vector(15 downto 0) := X"0000";
signal s1 : std_logic_vector(15 downto 0) := X"0000";
signal carry_old : std_logic;

begin

sync: process(aclk)
    variable temp: std_logic_vector(16 downto 0);
    variable temp1: std_logic_vector(18 downto 0);
    variable temp2: std_logic_vector(17 downto 0);
    variable carry: std_logic;
begin
    if aclk'event and aclk= '1' then
        if valid_in = '1' then
            temp := (in_s(15) & in_s) + s0;
            out_d <= in_d - temp(16 downto 1);            
            
            
            carry := not(in_s(0) and s0(0));
            carry_old <= carry;
            s0 <= in_s;                                                
            temp1 := in_s&"00" - in_s(15 downto 1)&'0' + in_d - s0(15 downto 1);
            s1 <= temp1(15 downto 0);
            temp2 := (s1(15)&s1(15)&s1 + in_d  + carry) - in_s(15 downto 1) + carry_old;
            out_s <= temp2(17 downto 2);
        end if;
    end if;
end process;



end Behavioral;
