/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ar.pl;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.graphics.PixelFormat;
import android.hardware.Camera;
import com.qualcomm.ar.pl.CameraSurface;
import com.qualcomm.ar.pl.SurfaceManager;
import com.qualcomm.ar.pl.SystemTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;

public class CameraPreview
implements Camera.PreviewCallback {
    private SurfaceManager surfaceManager = null;
    private Vector<CameraCacheInfo> cameraCacheInfo = null;
    private HashMap<Camera, Integer> cameraCacheInfoIndexCache = null;
    private static Method _addCallbackBufferFunc;
    private static Object[] _addCallbackBufferArgs;
    private static Method _setPreviewCallbackWithBufferFunc;
    private static Method _setPreviewTextureFunc;
    private static Method _updateTexImage;
    private static Constructor<?> _surfaceTextureConstructor;
    private static final int CAMERA_CAPTUREINFO_VALUE_WIDTH = 0;
    private static final int CAMERA_CAPTUREINFO_VALUE_HEIGHT = 1;
    private static final int CAMERA_CAPTUREINFO_VALUE_FORMAT = 2;
    private static final int CAMERA_CAPTUREINFO_VALUE_FRAMERATE = 3;
    private static final int CAMERA_CAPTUREINFO_VALUE_PREVIEWSURFACEENABLED = 4;
    private static final int _NUM_CAMERA_CAPTUREINFO_VALUE_ = 5;
    private static final int CAMERA_CAPSINFO_VALUE_SUPPORTED_QUERYABLE_PARAMS = 0;
    private static final int CAMERA_CAPSINFO_VALUE_SUPPORTED_SETTABLE_PARAMS = 1;
    private static final int CAMERA_CAPSINFO_VALUE_SUPPORTED_PARAMVALUES = 2;
    private static final int CAMERA_CAPSINFO_VALUE_NUM_SUPPORTED_IMAGESIZES = 3;
    private static final int CAMERA_CAPSINFO_VALUE_NUM_SUPPORTED_FRAMERATES = 4;
    private static final int CAMERA_CAPSINFO_VALUE_NUM_SUPPORTED_IMAGEFORMATS = 5;
    private static final int _NUM_CAMERA_CAPSINFO_VALUE_ = 6;
    private static final int AR_CAMERA_PARAMTYPE_BASE = 0x20000000;
    private static final int AR_CAMERA_PARAMTYPE_TORCHMODE = 0x20000001;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSMODE = 0x20000002;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSVALUE = 0x20000004;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSRANGE = 0x20000008;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSREGION = 0x20000010;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSUREMODE = 0x20000020;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSUREVALUE = 0x20000040;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSURERANGE = 0x20000080;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSURECOMPENSATIONVALUE = 0x20000100;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSURECOMPENSATIONRANGE = 0x20000200;
    private static final int AR_CAMERA_PARAMTYPE_WHITEBALANCEMODE = 0x20000400;
    private static final int AR_CAMERA_PARAMTYPE_WHITEBALANCEVALUE = 0x20000800;
    private static final int AR_CAMERA_PARAMTYPE_WHITEBALANCERANGE = 0x20001000;
    private static final int AR_CAMERA_PARAMTYPE_ZOOMVALUE = 0x20002000;
    private static final int AR_CAMERA_PARAMTYPE_ZOOMRANGE = 0x20004000;
    private static final int AR_CAMERA_PARAMTYPE_BRIGHTNESSVALUE = 0x20008000;
    private static final int AR_CAMERA_PARAMTYPE_BRIGHTNESSRANGE = 0x20010000;
    private static final int AR_CAMERA_PARAMTYPE_CONTRASTVALUE = 0x20020000;
    private static final int AR_CAMERA_PARAMTYPE_CONTRASTRANGE = 0x20040000;
    private static final int AR_CAMERA_PARAMTYPE_ROTATION = 0x20080000;
    private static final int AR_CAMERA_PARAMTYPE_ISO = 0x20100000;
    private static final int AR_CAMERA_PARAMTYPE_RECORDING_HINT = 0x20200000;
    private static final int AR_CAMERA_PARAMVALUE_BASE = 0x30000000;
    private static final int AR_CAMERA_TORCHMODE_OFF = 0x30000001;
    private static final int AR_CAMERA_TORCHMODE_ON = 0x30000002;
    private static final int AR_CAMERA_TORCHMODE_AUTO = 0x30000004;
    private static final int AR_CAMERA_TORCHMODE_CONTINUOUSAUTO = 0x30000008;
    private static final int AR_CAMERA_FOCUSMODE_NORMAL = 0x30000010;
    private static final int AR_CAMERA_FOCUSMODE_AUTO = 0x30000020;
    private static final int AR_CAMERA_FOCUSMODE_CONTINUOUSAUTO = 0x30000040;
    private static final int AR_CAMERA_FOCUSMODE_MACRO = 0x30000080;
    private static final int AR_CAMERA_FOCUSMODE_INFINITY = 0x30000100;
    private static final int AR_CAMERA_FOCUSMODE_FIXED = 0x30000200;
    private static final int AR_CAMERA_EXPOSUREMODE_LOCKED = 0x30001000;
    private static final int AR_CAMERA_EXPOSUREMODE_AUTO = 0x30002000;
    private static final int AR_CAMERA_EXPOSUREMODE_CONTINUOUSAUTO = 0x30004000;
    private static final int AR_CAMERA_WHITEBALANCEMODE_LOCKED = 0x30010000;
    private static final int AR_CAMERA_WHITEBALANCEMODE_AUTO = 0x30020000;
    private static final int AR_CAMERA_WHITEBALANCEMODE_CONTINUOUSAUTO = 0x30040000;
    private static final int AR_CAMERA_TYPE_UNKNOWN = 0x10003010;
    private static final int AR_CAMERA_TYPE_MONO = 0x10003011;
    private static final int AR_CAMERA_TYPE_STEREO = 268447762;
    private static final int AR_CAMERA_DIRECTION_UNKNOWN = 0x10002010;
    private static final int AR_CAMERA_DIRECTION_BACK = 0x10002011;
    private static final int AR_CAMERA_DIRECTION_FRONT = 0x10002012;
    private static final int AR_CAMERA_STATUS_UNKNOWN = 0x10002000;
    private static final int AR_CAMERA_STATUS_UNINITIALIZED = 0x10002001;
    private static final int AR_CAMERA_STATUS_OPENED = 0x10002002;
    private static final int AR_CAMERA_STATUS_CAPTURE_RUNNING = 268443651;
    private static final int AR_CAMERA_IMAGE_FORMAT_UNKNOWN = 0x10001100;
    private static final int AR_CAMERA_IMAGE_FORMAT_LUM = 0x10001101;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGB565 = 0x10001102;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGB888 = 0x10001103;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGB24 = 0x10001103;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA8888 = 0x10001104;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA32 = 0x10001104;
    private static final int AR_CAMERA_IMAGE_FORMAT_ARGB8888 = 0x10001105;
    private static final int AR_CAMERA_IMAGE_FORMAT_ARGB32 = 0x10001105;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGRA8888 = 0x10001106;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGRA32 = 0x10001106;
    private static final int AR_CAMERA_IMAGE_FORMAT_NV12 = 0x10001107;
    private static final int AR_CAMERA_IMAGE_FORMAT_NV16 = 0x10001108;
    private static final int AR_CAMERA_IMAGE_FORMAT_NV21 = 0x10001109;
    private static final int AR_CAMERA_IMAGE_FORMAT_YV12 = 0x1000110A;
    private static final int AR_CAMERA_IMAGE_FORMAT_YV16 = 0x1000110B;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA5551 = 0x1000110C;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA4444 = 0x1000110D;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGR888 = 0x1000110E;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGR24 = 0x1000110E;
    private static final int[] CAMERA_IMAGE_FORMAT_CONVERSIONTABLE;
    private static boolean CONVERT_FORMAT_TO_PL;
    private static boolean CONVERT_FORMAT_TO_ANDROID;
    private static final int NUM_CAPTURE_BUFFERS = 2;
    private static final int NUM_CAPTURE_BUFFERS_TO_ADD = 2;
    private static final int NUM_MAX_CAMERAOPEN_RETRY = 10;
    private static final int TIME_CAMERAOPEN_RETRY_DELAY_MS = 250;
    private static final String MODULENAME = "CameraPreview";
    private static final String FOCUS_MODE_CONTINUOUS_PICTURE = "continuous-picture";
    private static final String FOCUS_MODE_NORMAL = "normal";

    public CameraPreview() {
        _addCallbackBufferFunc = null;
        _addCallbackBufferArgs = null;
        _setPreviewCallbackWithBufferFunc = null;
    }

    private boolean checkPermission() {
        try {
            Activity activity = SystemTools.getActivityFromNative();
            PackageManager pm = activity.getPackageManager();
            int isPermissionGranted = pm.checkPermission("android.permission.CAMERA", activity.getPackageName());
            if (isPermissionGranted == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int getCameraDeviceIndex(int camIndex, int type, int direction) {
        if (type != 0x10003010) {
            // empty if block
        }
        if (SystemTools.checkMinimumApiLevel(9)) {
            int camInfoDirection = -1;
            switch (direction) {
                case 0x10002010: {
                    break;
                }
                case 0x10002011: {
                    camInfoDirection = 0;
                    break;
                }
                case 0x10002012: {
                    camInfoDirection = 1;
                    break;
                }
                default: {
                    SystemTools.setSystemErrorCode(2);
                    return -1;
                }
            }
            int num = Camera.getNumberOfCameras();
            for (int i = 0; i < num; ++i) {
                Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                try {
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                }
                catch (Exception e) {
                    continue;
                }
                if (camInfoDirection >= 0 && camInfoDirection != cameraInfo.facing || camIndex >= 0 && camIndex != i) continue;
                return i;
            }
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (direction == 0x10002012) {
            SystemTools.setSystemErrorCode(2);
            return -1;
        }
        if (camIndex >= 1) {
            SystemTools.setSystemErrorCode(2);
            return -1;
        }
        return 0;
    }

    private Camera.Parameters getCameraParameters(Camera camera) {
        Camera.Parameters params = null;
        try {
            params = camera.getParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return params;
    }

    private CameraCacheInfo getCameraCacheInfo(int cameraCacheInfoIndex) {
        if (cameraCacheInfoIndex < 0 || cameraCacheInfoIndex >= this.cameraCacheInfo.size()) {
            return null;
        }
        return this.cameraCacheInfo.get(cameraCacheInfoIndex);
    }

    private boolean setCustomCameraParams(Camera.Parameters cameraParams, String customData) {
        JSONObject jsonObj = null;
        try {
            jsonObj = new JSONObject(customData);
        }
        catch (JSONException e) {
            return false;
        }
        Iterator elements = jsonObj.keys();
        while (elements.hasNext()) {
            Object value;
            String key = (String)elements.next();
            try {
                value = jsonObj.get(key);
            }
            catch (JSONException e) {
                return false;
            }
            if (value.getClass() == String.class) {
                cameraParams.set(key, (String)value);
                continue;
            }
            if (value.getClass() == Integer.class) {
                cameraParams.set(key, ((Integer)value).intValue());
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean setCameraPreviewFps(int fps, Camera.Parameters params) {
        List supportedFpsRanges = params.getSupportedPreviewFpsRange();
        int min_fps = fps * 1000;
        int best_range = Integer.MAX_VALUE;
        int[] selected_range = null;
        for (int[] range : supportedFpsRanges) {
            int delta;
            if (range[0] != min_fps || (delta = range[1] - range[0]) >= best_range) continue;
            selected_range = range;
        }
        if (selected_range != null) {
            params.setPreviewFpsRange((int)selected_range[0], (int)selected_range[1]);
            return true;
        }
        return false;
    }

    private boolean setCameraCaptureParams(CameraCacheInfo camCacheInfo, Camera.Parameters camParams, int[] captureInfo, int[] overrideCaptureInfo) {
        boolean previewSurfaceEnabled;
        if (captureInfo != null || overrideCaptureInfo != null) {
            camCacheInfo.overrideWidth = overrideCaptureInfo != null ? overrideCaptureInfo[0] : captureInfo[0];
            camCacheInfo.overrideHeight = overrideCaptureInfo != null ? overrideCaptureInfo[1] : captureInfo[1];
            camCacheInfo.overrideFormatAndroid = this.translateImageFormat(overrideCaptureInfo != null ? overrideCaptureInfo[2] : captureInfo[2], CONVERT_FORMAT_TO_ANDROID);
        }
        if (captureInfo == null) {
            return true;
        }
        camCacheInfo.requestWidth = captureInfo[0];
        camCacheInfo.requestHeight = captureInfo[1];
        camCacheInfo.requestFormatAndroid = this.translateImageFormat(captureInfo[2], CONVERT_FORMAT_TO_ANDROID);
        int framerate = captureInfo[3];
        try {
            if (camCacheInfo.requestWidth > 0 && camCacheInfo.requestHeight > 0) {
                camParams.setPreviewSize(camCacheInfo.requestWidth, camCacheInfo.requestHeight);
            }
            if (framerate > 0) {
                if (SystemTools.checkMinimumApiLevel(8)) {
                    if (!this.setCameraPreviewFps(framerate, camParams)) {
                        camParams.setPreviewFrameRate(framerate);
                    }
                } else {
                    camParams.setPreviewFrameRate(framerate);
                }
            }
            if (camCacheInfo.requestFormatAndroid != 0) {
                camParams.setPreviewFormat(camCacheInfo.requestFormatAndroid);
            }
        }
        catch (Exception e) {
            return false;
        }
        boolean bl = previewSurfaceEnabled = captureInfo[4] > 0;
        if (previewSurfaceEnabled) {
            if (SystemTools.checkMinimumApiLevel(11)) {
                int textureID = -1;
                Object[] argList = new Object[]{new Integer(textureID)};
                try {
                    camCacheInfo.surfaceTexture = _surfaceTextureConstructor.newInstance(argList);
                }
                catch (Exception e) {
                    return false;
                }
                try {
                    argList[0] = camCacheInfo.surfaceTexture;
                    _setPreviewTextureFunc.invoke((Object)camCacheInfo.camera, argList);
                }
                catch (Exception e) {}
            } else if (this.surfaceManager != null) {
                boolean result = this.surfaceManager.addCameraSurface(camCacheInfo);
                if (!result) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean setupPreviewBuffer(CameraCacheInfo cci) {
        int bitsPerPixel;
        block6: {
            Camera.Parameters cameraParams = this.getCameraParameters(cci.camera);
            if (cameraParams == null) {
                return false;
            }
            int bufferFormatAndroid = 0;
            try {
                cci.bufferWidth = cci.requestWidth == cci.overrideWidth ? cameraParams.getPreviewSize().width : cci.overrideWidth;
                cci.bufferHeight = cci.requestHeight == cci.overrideHeight ? cameraParams.getPreviewSize().height : cci.overrideHeight;
                bufferFormatAndroid = cci.requestFormatAndroid == cci.overrideFormatAndroid ? cameraParams.getPreviewFormat() : cci.overrideFormatAndroid;
                cci.bufferFormatPL = this.translateImageFormat(bufferFormatAndroid, CONVERT_FORMAT_TO_PL);
            }
            catch (Exception e) {
                return false;
            }
            bitsPerPixel = 0;
            try {
                PixelFormat pixelFormatInfo = new PixelFormat();
                PixelFormat.getPixelFormatInfo((int)bufferFormatAndroid, (PixelFormat)pixelFormatInfo);
                bitsPerPixel = pixelFormatInfo.bitsPerPixel;
            }
            catch (Exception e) {
                bitsPerPixel = this.getBitsPerPixel(bufferFormatAndroid);
                if (bitsPerPixel != 0) break block6;
                return false;
            }
        }
        int bufferSize = cci.bufferWidth * cci.bufferHeight * bitsPerPixel / 8 + 4096;
        cci.buffer = new byte[2][];
        for (int i = 0; i < 2; ++i) {
            cci.buffer[i] = new byte[bufferSize];
            if (i >= 2) continue;
            this._addCallbackBuffer(cci.camera, cci.buffer[i]);
        }
        this._setPreviewCallbackWithBuffer(cci.camera, this);
        System.gc();
        return true;
    }

    private void setCameraCapsBit(CameraCacheInfo cci, int capsIndex, int paramType, boolean value) {
        int baseValue = 0;
        switch (capsIndex) {
            case 2: {
                baseValue = 0x30000000;
                break;
            }
            case 0: 
            case 1: {
                baseValue = 0x20000000;
                break;
            }
            default: {
                return;
            }
        }
        int index = (int)(Math.log(paramType & ~baseValue) / Math.log(2.0));
        if (value) {
            int n = capsIndex;
            cci.caps[n] = cci.caps[n] | 1 << index;
        } else {
            int n = capsIndex;
            cci.caps[n] = cci.caps[n] & ~(1 << index);
        }
    }

    private int translateImageFormat(int fromValue, boolean conversionMode) {
        for (int i = 0; i < CAMERA_IMAGE_FORMAT_CONVERSIONTABLE.length / 2; ++i) {
            int compareValue;
            int n = compareValue = conversionMode == CONVERT_FORMAT_TO_PL ? CAMERA_IMAGE_FORMAT_CONVERSIONTABLE[i * 2] : CAMERA_IMAGE_FORMAT_CONVERSIONTABLE[i * 2 + 1];
            if (fromValue != compareValue) continue;
            return conversionMode == CONVERT_FORMAT_TO_PL ? CAMERA_IMAGE_FORMAT_CONVERSIONTABLE[i * 2 + 1] : CAMERA_IMAGE_FORMAT_CONVERSIONTABLE[i * 2];
        }
        return conversionMode == CONVERT_FORMAT_TO_PL ? 0x10001100 : 0;
    }

    int getBitsPerPixel(int imgFormat) {
        switch (imgFormat) {
            case 16: {
                return 16;
            }
            case 4: {
                return 16;
            }
            case 17: {
                return 12;
            }
            case 842094169: {
                return 12;
            }
        }
        return 0;
    }

    public void onPreviewFrame(byte[] capturedBuffer, Camera camera) {
        long frameTimeStamp = System.nanoTime();
        Integer intObj = this.cameraCacheInfoIndexCache.get(camera);
        if (intObj == null) {
            return;
        }
        int cameraCacheInfoIndex = intObj;
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null) {
            return;
        }
        this.newFrameAvailable(cameraCacheInfoIndex, cci.bufferWidth, cci.bufferHeight, cci.bufferFormatPL, capturedBuffer, frameTimeStamp);
        this._addCallbackBuffer(camera, capturedBuffer);
    }

    private native void newFrameAvailable(int var1, int var2, int var3, int var4, byte[] var5, long var6);

    private void _addCallbackBuffer(Camera cam, byte[] buffer) {
        CameraPreview._addCallbackBufferArgs[0] = buffer;
        try {
            _addCallbackBufferFunc.invoke((Object)cam, _addCallbackBufferArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _setPreviewCallbackWithBuffer(Camera cam, Camera.PreviewCallback previewCB) {
        Object[] args = new Object[]{previewCB};
        try {
            _setPreviewCallbackWithBufferFunc.invoke((Object)cam, args);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean init() {
        this.cameraCacheInfo = new Vector();
        this.cameraCacheInfoIndexCache = new HashMap();
        String CLASSNAME_CAMERA = "android.hardware.Camera";
        String CLASSNAME_SURFACETEXTURE = "android.graphics.SurfaceTexture";
        try {
            Class<?> cameraClass = Class.forName("android.hardware.Camera");
            Class[] partypes = new Class[]{new byte[1].getClass()};
            _addCallbackBufferFunc = SystemTools.retrieveClassMethod(cameraClass, "addCallbackBuffer", partypes);
            if (_addCallbackBufferFunc == null) {
                return false;
            }
            _addCallbackBufferArgs = new Object[1];
            _setPreviewCallbackWithBufferFunc = SystemTools.retrieveClassMethod(cameraClass, "setPreviewCallbackWithBuffer", Camera.PreviewCallback.class);
            if (_setPreviewCallbackWithBufferFunc == null) {
                return false;
            }
            if (SystemTools.checkMinimumApiLevel(11)) {
                Class<?> surfaceTextureClass = Class.forName("android.graphics.SurfaceTexture");
                _setPreviewTextureFunc = SystemTools.retrieveClassMethod(cameraClass, "setPreviewTexture", surfaceTextureClass);
                if (_setPreviewTextureFunc == null) {
                    return false;
                }
                _surfaceTextureConstructor = surfaceTextureClass.getConstructor(Integer.TYPE);
                if (_surfaceTextureConstructor == null) {
                    return false;
                }
                _updateTexImage = SystemTools.retrieveClassMethod(surfaceTextureClass, "updateTexImage", new Class[0]);
                if (_updateTexImage == null) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void setSurfaceManager(SurfaceManager sm) {
        this.surfaceManager = sm;
    }

    public int getNumberOfCameras() {
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (SystemTools.checkMinimumApiLevel(9)) {
            try {
                int num = Camera.getNumberOfCameras();
                return num;
            }
            catch (Exception e) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
        }
        boolean deviceHasCamera = false;
        try {
            PackageManager pm = SystemTools.getActivityFromNative().getPackageManager();
            deviceHasCamera = pm.hasSystemFeature("android.hardware.camera");
        }
        catch (Exception e) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        return deviceHasCamera ? 1 : 0;
    }

    public int getDirection(int cameraID) {
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (SystemTools.checkMinimumApiLevel(9)) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            try {
                Camera.getCameraInfo((int)cameraID, (Camera.CameraInfo)cameraInfo);
            }
            catch (Exception e) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
            switch (cameraInfo.facing) {
                case 0: {
                    return 0x10002011;
                }
                case 1: {
                    return 0x10002012;
                }
            }
            return 0x10002010;
        }
        return 0x10002011;
    }

    public int getDeviceID(int cameraCacheInfoIndex) {
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null) {
            SystemTools.setSystemErrorCode(4);
            return -1;
        }
        return cci.deviceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open(int camIndex, int type, int direction, String customData, int[] captureInfo, int[] overrideCaptureInfo) {
        boolean setCustomData;
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        int cameraDeviceIndex = this.getCameraDeviceIndex(camIndex, type, direction);
        if (cameraDeviceIndex < 0) {
            return -1;
        }
        int cameraCacheInfoIndex = -1;
        CameraCacheInfo cci = null;
        int cameraCacheInfoSize = this.cameraCacheInfo.size();
        for (int i = 0; i < cameraCacheInfoSize; ++i) {
            cci = this.cameraCacheInfo.get(i);
            if (cci.deviceID != cameraDeviceIndex) continue;
            cameraCacheInfoIndex = i;
            break;
        }
        if (cameraCacheInfoIndex < 0) {
            cci = new CameraCacheInfo();
            cci.deviceID = cameraDeviceIndex;
            cci.camera = null;
            cci.surface = null;
            cci.buffer = null;
            cci.overrideWidth = 0;
            cci.requestWidth = 0;
            cci.bufferWidth = 0;
            cci.overrideHeight = 0;
            cci.requestHeight = 0;
            cci.bufferHeight = 0;
            cci.bufferFormatPL = 0x10001100;
            cci.overrideFormatAndroid = 0;
            cci.requestFormatAndroid = 0;
            cci.caps = null;
            cci.status = 0x10002001;
            cci.isAutoFocusing = false;
        }
        boolean resultCameraOpened = false;
        int cameraOpenRetryCount = 10;
        do {
            try {
                if (SystemTools.checkMinimumApiLevel(9)) {
                    cci.camera = Camera.open((int)cci.deviceID);
                } else if (cci.deviceID == 0) {
                    cci.camera = Camera.open();
                }
                resultCameraOpened = cci.camera != null;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (resultCameraOpened) continue;
            try {
                if (cameraOpenRetryCount <= 0) continue;
                CameraPreview e = this;
                synchronized (e) {
                    this.wait(250L);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (!resultCameraOpened && cameraOpenRetryCount-- > 0);
        if (cci.camera == null) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        boolean setCaptureInfo = captureInfo != null && captureInfo.length > 0 || overrideCaptureInfo != null && overrideCaptureInfo.length > 0;
        boolean bl = setCustomData = customData != null && customData.length() > 0;
        if (setCaptureInfo || setCustomData) {
            boolean result;
            Camera.Parameters cameraParams = this.getCameraParameters(cci.camera);
            if (cameraParams == null) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
            if (setCaptureInfo) {
                if (captureInfo != null && captureInfo.length != 5) {
                    SystemTools.setSystemErrorCode(2);
                    return -1;
                }
                result = this.setCameraCaptureParams(cci, cameraParams, captureInfo, overrideCaptureInfo);
                if (!result) {
                    SystemTools.setSystemErrorCode(6);
                    return -1;
                }
            }
            if (setCustomData && !(result = this.setCustomCameraParams(cameraParams, customData))) {
                SystemTools.setSystemErrorCode(2);
                return -1;
            }
            try {
                cci.camera.setParameters(cameraParams);
            }
            catch (Exception e) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
        }
        cci.status = 0x10002002;
        if (cameraCacheInfoIndex < 0) {
            this.cameraCacheInfo.add(cci);
            cameraCacheInfoIndex = this.cameraCacheInfo.size() - 1;
        }
        this.cameraCacheInfoIndexCache.put(cci.camera, cameraCacheInfoIndex);
        return cameraCacheInfoIndex;
    }

    public boolean close(int cameraCacheInfoIndex) {
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        this.cameraCacheInfoIndexCache.remove(cci.camera);
        boolean result = false;
        try {
            cci.camera.release();
            result = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        cci.camera = null;
        cci.buffer = null;
        cci.status = 0x10002001;
        System.gc();
        return result;
    }

    public int[] getCameraCapabilities(int cameraCacheInfoIndex) {
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        if (cci.caps != null) {
            return cci.caps;
        }
        Camera.Parameters cameraParams = this.getCameraParameters(cci.camera);
        if (cameraParams == null) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        List supportedImageSizes = cameraParams.getSupportedPreviewSizes();
        List supportedFrameRates = cameraParams.getSupportedPreviewFrameRates();
        List supportedImageFormats = cameraParams.getSupportedPreviewFormats();
        List supportedFlashModes = cameraParams.getSupportedFlashModes();
        List supportedFocusModes = cameraParams.getSupportedFocusModes();
        int numSupportedImageSizes = supportedImageSizes != null ? supportedImageSizes.size() : 0;
        int numSupportedFrameRates = supportedFrameRates != null ? supportedFrameRates.size() : 0;
        int numSupportedImageFormats = supportedImageFormats != null ? supportedImageFormats.size() : 0;
        int capsArraySize = 6 + numSupportedImageSizes * 2 + numSupportedFrameRates + numSupportedImageFormats;
        cci.caps = new int[capsArraySize];
        int capsIndex = 0;
        cci.caps[capsIndex] = 0x20000000;
        this.setCameraCapsBit(cci, capsIndex, 0x20000001, supportedFlashModes != null ? supportedFlashModes.contains("torch") || supportedFlashModes.contains("on") : false);
        this.setCameraCapsBit(cci, capsIndex, 0x20000002, true);
        this.setCameraCapsBit(cci, capsIndex, 0x20000004, SystemTools.checkMinimumApiLevel(8));
        this.setCameraCapsBit(cci, capsIndex, 0x20000100, SystemTools.checkMinimumApiLevel(8));
        this.setCameraCapsBit(cci, capsIndex, 0x20000200, SystemTools.checkMinimumApiLevel(8));
        this.setCameraCapsBit(cci, capsIndex, 0x20002000, SystemTools.checkMinimumApiLevel(8) && cameraParams.isZoomSupported());
        this.setCameraCapsBit(cci, capsIndex, 0x20004000, SystemTools.checkMinimumApiLevel(8) && cameraParams.isZoomSupported());
        capsIndex = 1;
        cci.caps[capsIndex] = 0x20000000;
        this.setCameraCapsBit(cci, capsIndex, 0x20000001, supportedFlashModes != null ? supportedFlashModes.contains("torch") || supportedFlashModes.contains("on") : false);
        this.setCameraCapsBit(cci, capsIndex, 0x20000002, true);
        this.setCameraCapsBit(cci, capsIndex, 0x20000100, SystemTools.checkMinimumApiLevel(8));
        this.setCameraCapsBit(cci, capsIndex, 0x20002000, SystemTools.checkMinimumApiLevel(8) && cameraParams.isZoomSupported());
        capsIndex = 2;
        cci.caps[capsIndex] = 0x30000000;
        if (supportedFlashModes != null && (supportedFlashModes.contains("torch") || supportedFlashModes.contains("on"))) {
            this.setCameraCapsBit(cci, capsIndex, 0x30000001, true);
            this.setCameraCapsBit(cci, capsIndex, 0x30000002, true);
        }
        if (supportedFocusModes != null) {
            this.setCameraCapsBit(cci, capsIndex, 0x30000010, true);
            this.setCameraCapsBit(cci, capsIndex, 0x30000020, supportedFocusModes.contains("auto"));
            this.setCameraCapsBit(cci, capsIndex, 0x30000040, SystemTools.checkMinimumApiLevel(9) && supportedFocusModes.contains("continuous-video") || SystemTools.checkMinimumApiLevel(14) && supportedFocusModes.contains(FOCUS_MODE_CONTINUOUS_PICTURE));
            this.setCameraCapsBit(cci, capsIndex, 0x30000080, supportedFocusModes.contains("macro"));
            this.setCameraCapsBit(cci, capsIndex, 0x30000100, supportedFocusModes.contains("infinity"));
            this.setCameraCapsBit(cci, capsIndex, 0x30000200, supportedFocusModes.contains("fixed"));
        }
        cci.caps[3] = numSupportedImageSizes;
        cci.caps[4] = numSupportedFrameRates;
        cci.caps[5] = numSupportedImageFormats;
        int indexOffset = 6;
        if (numSupportedImageSizes > 0) {
            ListIterator iterSizes = supportedImageSizes.listIterator();
            while (iterSizes.hasNext()) {
                Camera.Size size = (Camera.Size)iterSizes.next();
                cci.caps[indexOffset] = size.width;
                cci.caps[indexOffset + 1] = size.height;
                indexOffset += 2;
            }
        }
        if (numSupportedFrameRates > 0) {
            ListIterator iterFramerates = supportedFrameRates.listIterator();
            while (iterFramerates.hasNext()) {
                int framerate;
                cci.caps[indexOffset] = framerate = ((Integer)iterFramerates.next()).intValue();
                ++indexOffset;
            }
        }
        if (numSupportedImageFormats > 0) {
            ListIterator iterFormats = supportedImageFormats.listIterator();
            while (iterFormats.hasNext()) {
                int format = (Integer)iterFormats.next();
                cci.caps[indexOffset] = this.translateImageFormat(format, true);
                ++indexOffset;
            }
        }
        return cci.caps;
    }

    public boolean setCaptureInfo(int cameraCacheInfoIndex, int[] captureInfo, int[] overrideCaptureInfo) {
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        if (captureInfo.length != 5) {
            SystemTools.setSystemErrorCode(2);
            return false;
        }
        Camera.Parameters cameraParams = this.getCameraParameters(cci.camera);
        if (cameraParams == null) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        boolean result = this.setCameraCaptureParams(cci, cameraParams, captureInfo, overrideCaptureInfo);
        if (!result) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        try {
            cci.camera.setParameters(cameraParams);
        }
        catch (Exception e) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        return true;
    }

    public int[] getCaptureInfo(int cameraCacheInfoIndex) {
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        Camera.Parameters cameraParams = this.getCameraParameters(cci.camera);
        if (cameraParams == null) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        int[] captureInfo = null;
        try {
            captureInfo = new int[]{cameraParams.getPreviewSize().width, cameraParams.getPreviewSize().height, this.translateImageFormat(cameraParams.getPreviewFormat(), CONVERT_FORMAT_TO_PL), cameraParams.getPreviewFrameRate(), cci.surface != null || cci.surfaceTexture != null ? 1 : 0};
        }
        catch (Exception e) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        return captureInfo;
    }

    public boolean start(int cameraCacheInfoIndex) {
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        if (!this.setupPreviewBuffer(cci)) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        try {
            cci.camera.startPreview();
            cci.status = 268443651;
            return true;
        }
        catch (Exception e) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
    }

    public boolean stop(int cameraCacheInfoIndex) {
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        try {
            cci.camera.stopPreview();
            cci.status = 0x10002002;
            return true;
        }
        catch (Exception e) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
    }

    boolean setTypedCameraParameter(int cameraCacheInfoIndex, int type, Object value) {
        boolean doPostSetAction;
        Camera.Parameters cameraParams;
        CameraCacheInfo cci;
        block67: {
            cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
            if (cci == null || cci.camera == null) {
                SystemTools.setSystemErrorCode(4);
                return false;
            }
            cameraParams = this.getCameraParameters(cci.camera);
            if (cameraParams == null) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
            doPostSetAction = false;
            try {
                block3 : switch (type) {
                    case 0x20100000: {
                        int isoValue = ((Number)value).intValue();
                        cameraParams.set("iso", Integer.toString(isoValue));
                        break;
                    }
                    case 0x20200000: {
                        int val = ((Number)value).intValue();
                        cameraParams.set("recording-hint", val != 0 ? "true" : "false");
                        break;
                    }
                    case 0x20000001: {
                        int torchMode = ((Number)value).intValue();
                        switch (torchMode) {
                            case 0x30000002: {
                                if (cameraParams.getSupportedFlashModes().contains("torch")) {
                                    cameraParams.setFlashMode("torch");
                                    break block3;
                                }
                                cameraParams.setFlashMode("on");
                                break block3;
                            }
                            case 0x30000001: {
                                cameraParams.setFlashMode("off");
                                break block3;
                            }
                            case 0x30000004: {
                                SystemTools.setSystemErrorCode(3);
                                return false;
                            }
                        }
                        SystemTools.setSystemErrorCode(3);
                        return false;
                    }
                    case 0x20000002: {
                        cci.camera.cancelAutoFocus();
                        int focusMode = ((Number)value).intValue();
                        switch (focusMode) {
                            case 0x30000010: {
                                if (cameraParams.getSupportedFocusModes().contains(FOCUS_MODE_NORMAL)) {
                                    cameraParams.setFocusMode(FOCUS_MODE_NORMAL);
                                    break block3;
                                }
                                cameraParams.setFocusMode("auto");
                                doPostSetAction = true;
                                break block3;
                            }
                            case 0x30000020: {
                                cameraParams.setFocusMode("auto");
                                doPostSetAction = true;
                                break block3;
                            }
                            case 0x30000040: {
                                if (SystemTools.checkMinimumApiLevel(14) && cameraParams.getSupportedFocusModes().contains(FOCUS_MODE_CONTINUOUS_PICTURE)) {
                                    cameraParams.setFocusMode(FOCUS_MODE_CONTINUOUS_PICTURE);
                                    break block3;
                                }
                                if (SystemTools.checkMinimumApiLevel(9)) {
                                    cameraParams.setFocusMode("continuous-video");
                                    break block3;
                                }
                                SystemTools.setSystemErrorCode(6);
                                return false;
                            }
                            case 0x30000080: {
                                cameraParams.setFocusMode("macro");
                                break block3;
                            }
                            case 0x30000100: {
                                cameraParams.setFocusMode("infinity");
                                break block3;
                            }
                            case 0x30000200: {
                                cameraParams.setFocusMode("fixed");
                                break block3;
                            }
                        }
                        SystemTools.setSystemErrorCode(3);
                        return false;
                    }
                    case 0x20000004: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000008: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000010: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000020: {
                        int exposureMode = ((Number)value).intValue();
                        switch (exposureMode) {
                            case 0x30001000: {
                                if (cameraParams.isAutoExposureLockSupported()) {
                                    cameraParams.setAutoExposureLock(true);
                                    break block3;
                                }
                                break block67;
                            }
                            case 0x30002000: 
                            case 0x30004000: {
                                if (cameraParams.isAutoExposureLockSupported()) {
                                    cameraParams.setAutoExposureLock(false);
                                    break block3;
                                }
                                break block67;
                            }
                            default: {
                                SystemTools.setSystemErrorCode(3);
                                SystemTools.logSystemError("Cannot set unknown exposure mode (" + exposureMode + ")");
                                return false;
                            }
                        }
                    }
                    case 0x20000040: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000080: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000100: {
                        if (SystemTools.checkMinimumApiLevel(8)) {
                            int expCompValue = ((Number)value).intValue();
                            cameraParams.setExposureCompensation(expCompValue);
                            break;
                        }
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000200: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000400: {
                        int whiteBalanceMode = ((Number)value).intValue();
                        switch (whiteBalanceMode) {
                            case 0x30010000: {
                                if (cameraParams.isAutoWhiteBalanceLockSupported()) {
                                    cameraParams.setAutoWhiteBalanceLock(true);
                                    break block3;
                                }
                                break block67;
                            }
                            case 0x30020000: 
                            case 0x30040000: {
                                if (cameraParams.isAutoWhiteBalanceLockSupported()) {
                                    cameraParams.setAutoWhiteBalanceLock(false);
                                    break block3;
                                }
                                break block67;
                            }
                            default: {
                                SystemTools.setSystemErrorCode(3);
                                SystemTools.logSystemError("Cannot set unknown white balance mode (" + whiteBalanceMode + ")");
                                return false;
                            }
                        }
                    }
                    case 0x20000800: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20001000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20002000: {
                        if (SystemTools.checkMinimumApiLevel(8) && cameraParams.isZoomSupported()) {
                            int zoomValue = ((Number)value).intValue();
                            cameraParams.setZoom(zoomValue);
                            break;
                        }
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20004000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20008000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20010000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20020000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20040000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20080000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (Exception e) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
        }
        try {
            cci.camera.setParameters(cameraParams);
        }
        catch (Exception e) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        if (doPostSetAction) {
            try {
                switch (type) {
                    case 0x20000002: {
                        cci.isAutoFocusing = true;
                        cci.camera.autoFocus(new Camera.AutoFocusCallback(){

                            public void onAutoFocus(boolean success, Camera camera) {
                                int cameraCacheInfoIndex;
                                CameraCacheInfo cci;
                                Object intObj = CameraPreview.this.cameraCacheInfoIndexCache.get(camera);
                                if (intObj != null && (cci = CameraPreview.this.getCameraCacheInfo(cameraCacheInfoIndex = ((Integer)intObj).intValue())) != null) {
                                    cci.isAutoFocusing = false;
                                }
                            }
                        });
                        break;
                    }
                }
            }
            catch (Exception e) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
        }
        return true;
    }

    Object getTypedCameraParameter(int cameraCacheInfoIndex, int type) {
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null || cci.camera == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        Camera.Parameters cameraParams = this.getCameraParameters(cci.camera);
        if (cameraParams == null) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        try {
            switch (type) {
                case 0x20000001: {
                    String flashMode = cameraParams.getFlashMode();
                    if (flashMode.equals("torch") || flashMode.equals("on")) {
                        return 0x30000002;
                    }
                    if (flashMode.equals("off")) {
                        return 0x30000001;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000002: {
                    String focusMode = cameraParams.getFocusMode();
                    if (focusMode.equals("auto")) {
                        return cci.isAutoFocusing ? 0x30000020 : 0x30000010;
                    }
                    if (SystemTools.checkMinimumApiLevel(9) && focusMode.equals("continuous-video") || SystemTools.checkMinimumApiLevel(14) && focusMode.equals(FOCUS_MODE_CONTINUOUS_PICTURE)) {
                        return 0x30000040;
                    }
                    if (focusMode.equals("infinity")) {
                        return 0x30000100;
                    }
                    if (focusMode.equals("macro")) {
                        return 0x30000080;
                    }
                    if (focusMode.equals("fixed")) {
                        return 0x30000200;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000004: {
                    if (SystemTools.checkMinimumApiLevel(8)) {
                        return Float.valueOf(cameraParams.getFocalLength());
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000008: {
                    if (SystemTools.checkMinimumApiLevel(9)) {
                        float[] focusDistances = new float[3];
                        cameraParams.getFocusDistances(focusDistances);
                        float[] focusValueRange = new float[]{focusDistances[0], focusDistances[2]};
                        return focusValueRange;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000010: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000020: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000040: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000080: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000100: {
                    if (SystemTools.checkMinimumApiLevel(8)) {
                        return cameraParams.getExposureCompensation();
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000200: {
                    if (SystemTools.checkMinimumApiLevel(8)) {
                        int[] exposureCompRange = new int[]{cameraParams.getMinExposureCompensation(), cameraParams.getMaxExposureCompensation()};
                        return exposureCompRange;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000400: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000800: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20001000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20002000: {
                    if (SystemTools.checkMinimumApiLevel(8) && cameraParams.isZoomSupported()) {
                        return cameraParams.getZoom();
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20004000: {
                    if (SystemTools.checkMinimumApiLevel(8) && cameraParams.isZoomSupported()) {
                        int[] zoomRange = new int[]{0, cameraParams.getMaxZoom()};
                        return zoomRange;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20008000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20010000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20020000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20040000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20080000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
    }

    int getStatus(int cameraCacheInfoIndex) {
        CameraCacheInfo cci = this.getCameraCacheInfo(cameraCacheInfoIndex);
        if (cci == null) {
            SystemTools.setSystemErrorCode(4);
            return 0x10002000;
        }
        return cci.status;
    }

    static {
        CAMERA_IMAGE_FORMAT_CONVERSIONTABLE = new int[]{16, 0x10001108, 17, 0x10001109, 4, 0x10001102, 842094169, 0x1000110A};
        CONVERT_FORMAT_TO_PL = true;
        CONVERT_FORMAT_TO_ANDROID = false;
    }

    public class CameraCacheInfo {
        int deviceID;
        Camera camera;
        CameraSurface surface;
        Object surfaceTexture;
        byte[][] buffer;
        int bufferWidth;
        int bufferHeight;
        int bufferFormatPL;
        int requestWidth;
        int requestHeight;
        int requestFormatAndroid;
        int overrideWidth;
        int overrideHeight;
        int overrideFormatAndroid;
        int[] caps;
        int status;
        boolean isAutoFocusing;
    }
}

