/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ar.pl;

import com.qualcomm.ar.pl.ARHttpParams;
import com.qualcomm.ar.pl.ARHttpRequest;
import com.qualcomm.ar.pl.ARHttpResponse;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;

public class ARHttpClient {
    private static final String MODULENAME = "ARHttpClient";
    private Future<HttpResponse> requestTask = null;
    private Future<?> postDSNTimeoutTask = null;
    ExecutorService executor;

    public boolean execute(ARHttpRequest arRequest, ARHttpParams arParams) {
        if (arRequest == null) {
            return false;
        }
        try {
            this.executor = Executors.newFixedThreadPool(2);
            this.requestTask = this.executor.submit(new HttpResponseCallable(arRequest, arParams));
            this.postDSNTimeoutTask = this.executor.submit(new HttpResponseWatcher(arRequest, arParams));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean cancel() {
        if (this.requestTask != null) {
            this.requestTask.cancel(true);
            return this.requestTask.isDone();
        }
        return false;
    }

    public native void nativeCallback(ARHttpResponse var1, long var2);

    private class HttpResponseWatcher
    implements Runnable {
        private ARHttpParams arParams;
        private ARHttpRequest arRequest;

        public HttpResponseWatcher(ARHttpRequest arRequest, ARHttpParams arParams) {
            this.arParams = arParams;
            this.arRequest = arRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ARHttpResponse arResponse = null;
            int networkStatus = ARHttpResponse.ERROR_NONE;
            try {
                HttpResponse httpResponse = (HttpResponse)ARHttpClient.this.requestTask.get(this.arParams.delayedStart_ms + this.arParams.requestTimeout_ms, TimeUnit.MILLISECONDS);
                arResponse = ARHttpResponse.createARResponse(httpResponse);
                if (arResponse.statusCode != 200) {
                    // empty if block
                }
            }
            catch (CancellationException e) {
                networkStatus = ARHttpResponse.ERROR_CANCELED;
            }
            catch (TimeoutException e) {
                networkStatus = ARHttpResponse.ERROR_TIMEOUT;
            }
            catch (Exception e) {
                networkStatus = ARHttpResponse.ERROR_OPERATION_FAILED;
            }
            finally {
                if (ARHttpClient.this.requestTask != null && !ARHttpClient.this.requestTask.isCancelled()) {
                    ARHttpClient.this.requestTask.cancel(true);
                }
                if (networkStatus != ARHttpResponse.ERROR_NONE) {
                    arResponse = ARHttpResponse.createARResponse(networkStatus);
                }
            }
            ARHttpClient.this.nativeCallback(arResponse, this.arRequest.nativeRequestPtr);
            ARHttpClient.this.executor.shutdownNow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpResponseCallable
    implements Callable<HttpResponse> {
        private ARHttpRequest arRequest;
        private ARHttpParams arParams;

        public HttpResponseCallable(ARHttpRequest arRequest, ARHttpParams arParams) {
            this.arRequest = arRequest;
            this.arParams = arParams;
        }

        @Override
        public HttpResponse call() throws Exception {
            if (this.arParams.delayedStart_ms != 0) {
                Thread.sleep(this.arParams.delayedStart_ms);
            }
            HttpParams httpParams = ARHttpParams.createHttpParams(this.arParams);
            DefaultHttpClient httpClient = new DefaultHttpClient(httpParams);
            HttpUriRequest httpPost = ARHttpRequest.createHttpRequest(this.arRequest);
            return httpClient.execute(httpPost);
        }
    }
}

