/*
								+----------------------------------+
								|                                  |
								|      ***  Perlin noise  ***      |
								|                                  |
								|   Copyright  -tHE SWINe- 2007   |
								|                                  |
								|            Noise.cpp             |
								|                                  |
								+----------------------------------+
*/

/**
 *	@file dev/Noise.cpp
 *	@date 2007
 *	@author -tHE SWINe-
 *	@brief Perlin noise
 *
 *	@deprecated This file is deprecated in favor of gl3/GLNoise.h
 */

#include "../NewFix.h"

#include "../CallStack.h"
#include <math.h>
#include "Noise.h"

/*
 *								=== CPerlinNoise ===
 */

/*
 *	const int CPerlinNoise::m_p_perm_table
 *		- perlin noise permutation table
 *		- note there is twice the same contents to avoid index wrap-arround calculations
 *		- note this would fit to unsigned char, but int will be better aligned and likely
 *		  faster ond most architectures
 */
const int CPerlinNoise::m_p_perm_table[512] = {151, 160, 137, 91, 90, 15,
	131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240,
	21, 10, 23, 190,  6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117,
	35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168,  68, 175,
	74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133,
	230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54,  65, 25, 63, 161,  1, 216,
	80, 73, 209, 76, 132, 187, 208,  89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86,
	164, 100, 109, 198, 173, 186,  3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147,
	118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223,
	183, 170, 213, 119, 248, 152,  2, 44, 154, 163,  70, 221, 153, 101, 155, 167,  43,
	172, 9, 129, 22, 39, 253,  19, 98, 108, 110, 79, 113, 224, 232, 178, 185,  112, 104,
	218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241,  81, 51,
	145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184,  84, 204, 176,
	115, 121, 50, 45, 127,  4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243,
	141, 128, 195, 78, 66, 215, 61, 156, 180, 151, 160, 137, 91, 90, 15,
	131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240,
	21, 10, 23, 190,  6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117,
	35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168,  68, 175,
	74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133,
	230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54,  65, 25, 63, 161,  1, 216,
	80, 73, 209, 76, 132, 187, 208,  89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86,
	164, 100, 109, 198, 173, 186,  3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147,
	118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223,
	183, 170, 213, 119, 248, 152,  2, 44, 154, 163,  70, 221, 153, 101, 155, 167,  43,
	172, 9, 129, 22, 39, 253,  19, 98, 108, 110, 79, 113, 224, 232, 178, 185,  112, 104,
	218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241,  81, 51,
	145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184,  84, 204, 176,
	115, 121, 50, 45, 127,  4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243,
	141, 128, 195, 78, 66, 215, 61, 156, 180
};

/*
 *	static float CPerlinNoise::f_Noise(float f_x, float f_y, float f_z)
 *		- returns noise function value at f_x, f_y, f_z
 */
float CPerlinNoise::f_Noise(float f_x, float f_y, float f_z)
{
	int n_x = (int)floor(f_x) & 255,
		n_y = (int)floor(f_y) & 255,
		n_z = (int)floor(f_z) & 255;
	f_x -= (float)floor(f_x);
	f_y -= (float)floor(f_y);
	f_z -= (float)floor(f_z);
	float u = f_Fade(f_x), v = f_Fade(f_y), w = f_Fade(f_z);
	int A = m_p_perm_table[n_x] + n_y, AA = m_p_perm_table[A] + n_z,
		AB = m_p_perm_table[A + 1] + n_z, B = m_p_perm_table[n_x + 1] + n_y,
		BA = m_p_perm_table[B] + n_z, BB = m_p_perm_table[B + 1] + n_z;
	return f_Lerp(w, f_Lerp(v, f_Lerp(u, f_Grad(m_p_perm_table[AA], f_x, f_y, f_z),
		f_Grad(m_p_perm_table[BA], f_x - 1, f_y, f_z)),
		f_Lerp(u, f_Grad(m_p_perm_table[AB], f_x, f_y - 1, f_z),
		f_Grad(m_p_perm_table[BB], f_x - 1, f_y - 1, f_z))),
		f_Lerp(v, f_Lerp(u, f_Grad(m_p_perm_table[AA + 1], f_x, f_y, f_z - 1 ),
		f_Grad(m_p_perm_table[BA + 1], f_x - 1, f_y, f_z - 1)),
		f_Lerp(u, f_Grad(m_p_perm_table[AB + 1], f_x, f_y - 1, f_z - 1),
		f_Grad(m_p_perm_table[BB + 1], f_x - 1, f_y - 1, f_z - 1))));
}

/*
 *	static float CPerlinNoise::f_Noise(float f_x, float f_y, float f_z, float f_w)
 *		- returns noise function value at f_x, f_y, f_z, f_w
 */
float CPerlinNoise::f_Noise(float f_x, float f_y, float f_z, float f_w)
{
	int n_x = (int)floor(f_x) & 255,
		n_y = (int)floor(f_y) & 255,
		n_z = (int)floor(f_z) & 255,
		n_w = (int)floor(f_w) & 255;
	f_x -= (float)floor(f_x);
	f_y -= (float)floor(f_y);
	f_z -= (float)floor(f_z);
	f_w -= (float)floor(f_w);
	float f_x1 = f_x - 1;
	float f_y1 = f_y - 1;
	float f_z1 = f_z - 1;
	float f_w1 = f_w - 1;
	float s = f_Fade(f_x), t = f_Fade(f_y), r = f_Fade(f_z), q = f_Fade(f_w);
	int A = m_p_perm_table[n_w], B = m_p_perm_table[n_w + 1];
	int CA = m_p_perm_table[n_z + A], CB = m_p_perm_table[n_z + B];
	int DA = m_p_perm_table[n_z + 1 + A], DB = m_p_perm_table[n_z + 1 + B];
	int ECA = m_p_perm_table[n_y + CA], ECB = m_p_perm_table[n_y + CB];
	int EDA = m_p_perm_table[n_y + DA], EDB = m_p_perm_table[n_y + DB];
	int FCA = m_p_perm_table[n_y + 1 + CA], FCB = m_p_perm_table[n_y + 1 + CB];
	int FDA = m_p_perm_table[n_y + 1 + DA], FDB = m_p_perm_table[n_y + 1 + DB];
	float f_corner_a = f_Lerp(q, f_Grad(m_p_perm_table[n_x + ECA], f_x, f_y, f_z, f_w),
		f_Grad(m_p_perm_table[n_x + ECB], f_x, f_y, f_z, f_w1));
	float f_corner_b = f_Lerp(q, f_Grad(m_p_perm_table[n_x + EDA], f_x, f_y, f_z1, f_w),
		f_Grad(m_p_perm_table[n_x + EDB], f_x, f_y, f_z1, f_w1));
	float f_corner_c = f_Lerp(q, f_Grad(m_p_perm_table[n_x + FCA],
		f_x, f_y1, f_z, f_w), f_Grad(m_p_perm_table[n_x + FCB], f_x, f_y1, f_z, f_w1));
	float f_corner_d = f_Lerp(q, f_Grad(m_p_perm_table[n_x + FDA], f_x, f_y1, f_z1, f_w),
		f_Grad(m_p_perm_table[n_x + FDB], f_x, f_y1, f_z1, f_w1));
	float f_corner_e = f_Lerp(q, f_Grad(m_p_perm_table[n_x + 1 + ECA], f_x1, f_y, f_z, f_w),
		f_Grad(m_p_perm_table[n_x + 1 + ECB], f_x1, f_y, f_z, f_w1));
	float f_corner_f = f_Lerp(q, f_Grad(m_p_perm_table[n_x + 1 + EDA], f_x1, f_y, f_z1, f_w),
		f_Grad(m_p_perm_table[n_x + 1 + EDB], f_x1, f_y, f_z1, f_w1));
	float f_corner_g = f_Lerp(q, f_Grad(m_p_perm_table[n_x + 1 + FCA], f_x1, f_y1, f_z, f_w),
		f_Grad(m_p_perm_table[n_x + 1 + FCB], f_x1, f_y1, f_z, f_w1));
	float f_corner_h = f_Lerp(q, f_Grad(m_p_perm_table[n_x + 1 + FDA], f_x1, f_y1, f_z1, f_w),
		f_Grad(m_p_perm_table[n_x + 1 + FDB], f_x1, f_y1, f_z1, f_w1));
	return .87f * f_Lerp(s,
		f_Lerp(t, f_Lerp(r, f_corner_a, f_corner_b), f_Lerp(r, f_corner_c, f_corner_d)),
		f_Lerp(t, f_Lerp(r, f_corner_e, f_corner_f), f_Lerp(r, f_corner_g, f_corner_h)));
}

/*
 *	static float CPerlinNoise::f_Fade(float f_t)
 *		- fade function, returns fade of parameter f_t
 */
float CPerlinNoise::f_Fade(float f_t)
{
	return f_t * f_t * f_t * (f_t * (f_t * 6 - 15) + 10);
}

/*
 *	static inline float CPerlinNoise::f_Lerp(float f_t, float f_a, float f_b)
 *		- linear interpolation function
 *		- returns point between f_a and f_b on relative position f_t
 */
inline float CPerlinNoise::f_Lerp(float f_t, float f_a, float f_b)
{
	return f_a + f_t * (f_b - f_a);
}

/*
 *	static float CPerlinNoise::f_Grad(int n_hash, float f_x, float f_y, float f_z)
 *		- gradient function
 */
float CPerlinNoise::f_Grad(int n_hash, float f_x, float f_y, float f_z)
{
	n_hash &= 15;
	float f_u = (n_hash < 8)? f_x : f_y;
	float f_v = (n_hash < 4)? f_y : ((n_hash == 12 || n_hash == 14)? f_x : f_z);
	return ((n_hash & 1)? -f_u : f_u) + ((n_hash & 2)? -f_v : f_v);
}

/*
 *	static float CPerlinNoise::f_Grad(int n_hash, float f_x, float f_y, float f_z, float f_w)
 *		- 4D gradient function
 */
float CPerlinNoise::f_Grad(int n_hash, float f_x, float f_y, float f_z, float f_w)
{
    n_hash &= 31;
    float f_s = (n_hash < 24)? f_x : f_y;
    float f_t = (n_hash < 16)? f_y : f_z;
    float f_r = (n_hash < 8)? f_z : f_w;
    return ((n_hash & 1)? -f_s : f_s) + ((n_hash & 2)? -f_t : f_t) + ((n_hash & 4)? -f_r : f_r);
}

/*
 *								=== ~CPerlinNoise ===
 */
