#!/usr/bin/env python3
""" Main test package of SLIS """
# Copyright (C) 2013 Libor Polčák
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import unittest
import os
import modules.tests.clockskew
import modules.tests.nid
import modules.tests.iricore
import modules.tests.shared
import shutil

import modules.tools.log as log
from modules.tools.config import ReadConfig

log.setupLogging("warning")

def deleteFile(fileName):
    if os.path.exists(fileName):
        os.remove(fileName)

def suite():
    tests = (
            modules.tests.clockskew.suite(),
            modules.tests.nid.suite(),
            modules.tests.iricore.suite(),
            modules.tests.shared.suite()
            )
    return unittest.TestSuite(tests)

def test():
    runner = unittest.TextTestRunner()
    runner.run(suite())

if __name__ == '__main__':
    test()
    
# Final cleanup
deleteFile("iri-core.log")
