#!/bin/bash
# Shell script that control SIMS system
# Copyright (C) 2014 Libor Polčák
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

if [ -x /usr/bin/colordiff ]; then
  alias diff='colordiff'
fi

function quit {
  kill `ps x  | grep dhcpv6                       | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps x  | grep radius                       | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps x  | grep instant_messaging            | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps ax | grep sniff-dhcp.py | grep python  | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps ax | grep pppoe.py      | grep python  | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps ax | grep slaac.py      | grep python  | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps ax | grep clockskew.sh                 | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps ax | grep clockskew.py  | grep python3 | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps ax | grep pcf                          | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps x  | grep iricollector.py|grep python3 | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill `ps x  | grep af.py          |grep python3 | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
}

function quit9 {
  kill -9 `ps x  | grep iricollector.py|grep python3 | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill -9 `ps x  | grep af.py          |grep python3 | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
  kill -9 `ps x  | grep iri-core.py    |grep python3 | sed "s/\ \+/ /g" | sed "s/^ //" | cut -f1 -d" "` 2> /dev/null
}

pushd `dirname "$0"`> /dev/null

if [ "$1" = "stop-please" ]; then
  quit9
  exit
fi

if [ "$1" = "stop" ]; then
  quit
  sleep 1
  echo "----------------------- af.log -------------------------"
  cat af.log
  echo "----------------------- iri-core.log -------------------------"
  cat iri-core.log
  exit
fi

if [ -z $2 ]; then
  PARAM=""
else
  PARAM="$2"
fi

if [ "$1" = "start" ]; then
  popd > /dev/null
	./sims.sh startcore $2
	sleep 2
	./sims.sh startmodules $2
  exit
fi

if [ "$1" = "startcore" ]; then
	popd > /dev/null
  rm -f iri-core.log
	./af.py "$PARAM" &
	sleep 2
  ./iri-core.py "$PARAM" &
  exit
fi

if [ "$1" = "startmodules" ]; then
	popd > /dev/null
  ./iricollector.py "$PARAM" &
  exit
fi

if [ "$1" = "installpcf" ]; then
	PCF_INSTALL=/opt/pcf

  # Checkout PCF and compile
  pushd modules/iriiif
  	if [ -d pcf ]
  	then
  		pushd pcf
  			git pull
  		popd
  	else
  		git clone https://github.com/polcak/pcf.git
  	fi
  	cd pcf/src
  	mkdir -p $PCF_INSTALL
  	make
  	make install INSTALL_DIR=$PCF_INSTALL
  popd
fi


echo "USAGE OF SIMS SCRIPT:"
echo "./sims.sh start        <--- starts SIMS framework (all components)"
echo "./sims.sh startcore    <--- starts the core (Runs in a single point of the network)"
echo "./sims.sh startmodules <--- starts modules to discover identities. The collector proxies the messages to the Core"
echo "It is possible to add 'debug' parameter to enable debugging (for all start commands)"
echo ""
echo ""
