# Wrapper class, derive your own classes
#
# Copyright (C) 2011 Nichita Utiu
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# See http://code.activestate.com/recipes/577555-object-wrapper-class/
# for original implementation

class Wrapper(object):
    '''
    Object wrapper class.
    This a wrapper for objects. It is initialiesed with the object to wrap
    and then proxies the unhandled getattribute methods to it.
    Other classes are to inherit from it.
    '''

    def __init__(self, obj):
        '''
        Wrapper constructor.
        @param obj: object to wrap
        '''
        if self.__class__ is Wrapper:
            raise NotImplementedError("Abstract class cannot be created")
        # wrap the object
        self._wrapped_obj = obj

    def __getattr__(self, attr):
        # proxy to the wrapped object
        return getattr(self._wrapped_obj, attr)

