# -*- coding: utf-8 -*-
# Short functions used in LILT system connected with time
#
# Copyright (C) 2011 Matěj Grégr, Michal Kajan, Libor Polčák, Vladimír Veselý
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import time

# Converters

def periodToStructTime(period):
    """ Ensure that struct time is used even when integers are given """
    s, e = period
    if type(s) == type(e) == int or type(s) == type(e) == float:
        return (time.localtime(s), time.localtime(e))
    return (s, e)

def sleepAtLeast(t):
    """ Sleep at least t seconds

    Wrapper around sleep.time that ensures that wake up won't be too early
    """
    remainder = t
    while remainder > 0:
        a = time.time()
        time.sleep(remainder)
        b = time.time()
        remainder = remainder - (b - a)
