#!/usr/bin/env python3
# Configuration of programs
#
# Copyright (C) 2011 Michal Kajan, Libor Polčák, Petr Kramoliš
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

if __name__ != "__main__":
    from . import log
else:
    import log

import configparser

configError = configparser.Error

def ReadConfig(f):
    """ Read and parse configuration from file f"""
    scp = configparser.SafeConfigParser()
    scp.read(f)
    return scp

def parseIRICoreNIDConfig(ifcName, iniFileName):
    """ Parse configuration file and returns port numbers """
    cfg = ReadConfig(iniFileName)
    ifcBig = ifcName.upper()
    try:
        nonUnique = cfg.get(ifcName, "nonUniqueNIDs")
    except configError:
        log.critical("Missing non unique NID configuration for %s " % ifcBig)
        raise
    ifc = nonUnique.split(' ')
    log.info("%s settings: nonUniqueNIDs: %s" % (ifcBig, ifc))
    return ifc

def parseServerTcpIfcConfig(ifcName, iniFileName):
    """ Parse configuration file and returns port numbers """
    cfg = ReadConfig(iniFileName)
    ifcBig = ifcName.upper()
    try:
        port = int(cfg.get(ifcName, "port"))
    except configError:
        log.critical("Missing port configuration for %s interface" % ifcBig)
        raise
    except ValueError:
        log.critical("Port in %s interface configuration is not number" % ifcBig)
        raise
    try:
        addr = cfg.get(ifcName, "address")
    except configError:
        log.critical("Missing address configuration for %s interface" % ifcBig)
        raise
    ifc = (addr, port)
    log.info("TCP settings of %s: %s" % (ifcBig, str(ifc)))
    return ifc

def parseClientTcpIfcConfig(ifcName, iniFileName):
    """ Parse configuration File for client TCP settings """
    cfg = ReadConfig(iniFileName)
    ifcBig = ifcName.upper()
    try:
        port = int(cfg.get(ifcName, "port"))
    except configError:
        log.critical("Missing port configuration for %s interface" % ifcBig)
        raise
    except ValueError:
        log.critical("Port in %s interface configuration is not number" % ifcBig)
        raise
    try:
        server = cfg.get(ifcName, "server")
    except configError:
        log.critical("Missing address configuration for %s interface" % ifcBig)
        raise
    ifc = (server, port)
    log.info("TCP settings of %s: %s" % (ifcBig, str(ifc)))
    return ifc

if __name__ == "__main__":
    import sys
    f, section, key = sys.argv[1:]
    print(ReadConfig(f).get(section, key))
