""" Test package of MF """
# Copyright (C) 2013 Libor Polčák, Radek Hranický
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import unittest

from ..shared.lieval import lieval

from ..af.hi1intercept import HI1Intercept
from ..shared.ini1aintercept import INI1AIntercept
from ..shared.cid import CID
from ..shared.iri import IRI
from ..iriiif.dhcp_status import DHCPStatus
from IPy import IP

from ..shared.liexceptions import LIException

class Tests(unittest.TestCase):

    def testLIEvalString(self):
        o = "HEARTBEAT"
        e = lieval(repr(o))
        self.assertEqual(e, o)

    def testLIEvalTuple(self):
        o = (1,2,3)
        e = lieval(repr(o))
        self.assertEqual(e, o)

    def testLIEvalList(self):
        o = [1,2,3]
        e = lieval(repr(o))
        self.assertEqual(e, o)

    def testLIEvalDict(self):
        o = {1:2, 3:4}
        e = lieval(repr(o))
        self.assertEqual(e, o)

    def testLIEvalNestedStandard(self):
        o = ([1,2,3], ("hello", "dict", {1: 100, 2: 200}, "and", "world"))
        e = lieval(repr(o))
        self.assertEqual(e, o)

    @unittest.skip("Not working in SIMS")
    def testLIEvalHI1(self):
        o = HI1Intercept("lea", "liid", "2001:db8::", "1", "0", "never")
        e = lieval(repr(o))
        self.assertEqual(e, o)

    def testLIEvalINI1A(self):
        o = INI1AIntercept(CID("opid", "nid", "cin", "dcc"), "nid", "liid", True, 0.0, 1)
        e = lieval(repr(o))
        self.assertEqual(e, o)

    def testLIEvalIRI(self):
        source = "test"
        timestamp = 0.0
        iri_type = "BEGIN",
        description = "iriDescription"
        cc = False
        t = 'IRI("%s", %f, "%s", "%s", %s)' % (source, timestamp, iri_type, description, cc)
        o = IRI(source, timestamp, iri_type, description, cc)
        e = lieval(t)
        self.assertEqual(e.getSource(), o.getSource())
        self.assertEqual(e.__class__, o.__class__)

    def testLIEvalDHCPStatus(self):
        o = DHCPStatus()
        e = lieval("DHCPStatus()")
        self.assertEqual(e.__class__, o.__class__)
        self.assertEqual(repr(e), repr(o))

    def testLIEvalIPyIP(self):
        o = IP("1.2.3.4")
        e = lieval(repr(o))
        self.assertEqual(e, o)

    def testLIEvalCombined(self):
        oin = INI1AIntercept(CID("opid", "nid", "cin", "dcc"), "nid", "liid", True, 0.0, 1)
        o = ("test", oin)
        e = lieval(repr(o))
        self.assertEqual(e, o)

    def testLIEvalImportException(self):
        raised = False
        try:
            lieval("import os")
        except Exception:
            raised = True
        if not raised:
            self.assertTrue(False, "Exception not raised")




def suite():
	test = unittest.makeSuite(Tests, "test")
	return unittest.TestSuite(tuple(test))

def test():
	runner = unittest.TextTestRunner()
	runner.run(suite())

