#!/bin/bash

DIRECTORY="$HOME/pox"

# agruments: -d directory	(Pox installation folder)
while getopts "d:" opt; do
  case $opt in
    d)
	  DIRECTORY=$OPTARG
      ;;
  esac
done

# check if Pox is installed
if [ ! -d "$DIRECTORY" ]; then
	echo "POX is not in $DIRECTORY folder."
	exit 1
fi

# apply patches
HOST_TRACKER="$DIRECTORY/pox/host_tracker/host_tracker.py"
SLIS="$DIRECTORY/pox/misc/slis_wrapper.py"

patch "$HOST_TRACKER" < host_tracker.patch
cp "slis_wrapper.py" "$SLIS"
echo "slis_wrapper.py copied to $DIRECTORY/pox/misc"

# NEXT STEPS:
# run slis
# sudo mn --topo linear,2 --mac --switch ovsk --controller remote
# sudo ./pox.py samples.pretty_log openflow.discovery host_tracker forwarding.l2_learning misc.slis_wrapper
