#include "common.h"
#include "ethernet.h"
#include "ipv6.h"
#include "util.h"
#include "pcap.h"
#include "nc6.h"

#ifndef DEV
#define DEV "em0"
#endif

int main(int argc, char **argv)
{
	IPv6Address addr;
	MacAddress mac;
	string dev(DEV);

	if (argc == 3) {
		dev = argv[2];
	} else
	if (argc < 2 || argc > 3) {
		cerr << argv[0] << ": local_ipv6address [intf]" << endl;
		return 1;
	}
	debug = 1;
	if (dns_lookup6("www.nic.cz", addr)) {
		cerr << addr.to_string() << endl;
	}

	if (if_get_mac(DEV, mac)) {
		cerr << mac.to_string() << endl;
	}

	int i = 0;
	int plen = 0;
	while (if_get_ipv6(DEV, addr, plen, i++)) {
		cerr << addr.to_string() << "/" << plen << endl;
	}

	PCAP pcap;
	pcap.open(DEV);
	NC6 nc(pcap);
	if (argc > 1) {
		addr.addr(argv[1]);
	} else {
		addr.addr("2001:db8:1:0::1");
	}
	if (nc.lookup_mac(DEV, addr, mac)) {
		cerr << "target mac=" << mac.to_string() << endl;
	} else {
		cerr << "lookup failed" << endl;
	}
}
	
