#include <iostream>
#include "common.h"
#include "ethernet.h"
#include "ipv6.h"

int main()
{
	Buffer *pkt = new Buffer();
	debug = 2;

	Ethernet *p = new Ethernet();
	p->src("12:23:45:67:89:ab");
	p->dest("cd:ef:45:67:89:ab");
	cout << p << endl;

	IPv6 *ip6 = new IPv6();
	ip6->src("2001:718:802:809::93e5:90b");
	ip6->dest("2001:718:802:809::93e5:90c");
	IPv6HopByHopHeader *hbh = new IPv6HopByHopHeader();
	IPv6OptionRouterAlert *ra = new IPv6OptionRouterAlert(IPv6OptionRouterAlert::RSVPMessage);
	hbh->add_option(ra);
	ip6->add_exthdr(hbh);
	p->attach(ip6);
	p->build(*pkt);	// full packet build
	cout << ip6 << endl;

	cout << pkt << endl;

	Ethernet *de = new Ethernet();
	cout << "pkt length = " << pkt->length() << endl;
	pkt->setup(pkt->length());
	if (de->decode(*pkt)) {
		cout << "OK: " << de << endl;
		cout << "OK: " << de->payload() << endl;
	} else {
		cout << "FAIL Ethernet decode" << endl;
	}
	cout << pkt << endl;

}
