#include <iostream>
#include "common.h"
#include "ethernet.h"
#include "ipv4.h"
#include "arp.h"
#include "pcap.h"

#ifndef DEV
#define DEV "em0"
#endif

int main(int argc, char *argv[])
{
	Ethernet *e = new Ethernet();
	Buffer buf;
	debug = 2;
	bool finish = false;
	string dev(DEV);

	if (argc == 2) {
		dev = argv[1];
	} else
	if (argc > 2) {
		cerr << argv[0] << ": [intf]" << endl;
		return 1;
	}
	PCAP pcap;
	pcap.open(dev);
	pcap.set_filter("arp");
	while (!finish) {
		// get packet
		if (!pcap.read(buf, dev)) continue;
		// full decode
		if (!e->decode(buf)) continue;
		// is any decoded payload?
		if (!e->payload()) continue;
		// is ARP packet?
		if (dynamic_cast<ARP *>(e->payload()) == NULL) continue;
		ARP *arp = dynamic_cast<ARP *>(e->payload());
		cout << arp->to_string() << endl;
	}
}
