/*
 * Soubor:  sprava.h
 * Datum:   06.08.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: IM modul
 * Popis:   hlavickovy soubor pro funkce pro spravu sezeni
 */

#ifndef _SPRAVA_
#define _SPRAVA_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h> 

#include "my_string.h"
#include "zpracovany_packet.h"

//velikost hash tabulky
#define TABLE_SIZE 1000

struct sezeni
{
	int aktivni;
	struct timeval uzivatel_pripojen;
	int transportni_protokol;
	int typ_ip;
	struct in_addr ipv4_adresa;
	struct in_addr ipv4_adresa_2;
	struct in6_addr ipv6_adresa;
	struct in6_addr ipv6_adresa_2;
	int port;
	int port_2;
	int protokol;
	char *ID_uzivatele;
	char *server; // pro irc
	int aktualni_stav;
	char *potreba_dokoncit_prichozi;
	int ocekavat_dalsi_prichozi;
	char *potreba_dokoncit_odchozi;
	int ocekavat_dalsi_odchozi;
	int ukonceno;
};

struct sezeni_ptr 
{
	struct sezeni_ptr *dalsi;
	struct sezeni data;
};

struct seznam_sezeni
{
	struct sezeni_ptr *Prvni;
};

struct polozka_tabulky
{
	struct sezeni *sezeni;
	unsigned int index;
};


unsigned int hash_function_ipv4(struct in_addr ip1, int port1, struct in_addr ip2, int port2);
unsigned int hash_function_ipv6(struct in6_addr ip1, int port1, struct in6_addr ip2, int port2);

struct polozka_tabulky ziskat_sezeni(struct seznam_sezeni *Seznam, struct data_packetu obsah);

void inicializace_seznamu_sezeni(struct seznam_sezeni *Seznam);
void smazani_seznamu_sezeni(struct seznam_sezeni *Seznam);
void vloz_prvni_sezeni(struct seznam_sezeni *Seznam);
void odeber_sezeni(struct seznam_sezeni *Seznam, struct sezeni *Sezeni);

void inicializace_sezeni(struct sezeni *Sezeni);
void smazani_sezeni(struct sezeni *Sezeni);

struct sezeni *zapocate_sezeni_IPv4(struct seznam_sezeni *Seznam, int port, struct in_addr ip);
struct sezeni *zapocate_sezeni_IPv6(struct seznam_sezeni *Seznam, int port, struct in6_addr ip);

int porovnani_ipv6_adres(struct in6_addr *ip1, struct in6_addr *ip2);

#endif
