/*
 * Soubor:  oscar.h
 * Datum:   06.08.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: IM modul
 * Popis:   hlavickovy soubor pro funkce zpracovavajici protokol OSCAR
 */

#ifndef _OSCAR_
#define _OSCAR_

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "my_string.h"
#include "zpracovany_packet.h"
#include "iri.h"
#include "sprava.h"

#define FLAP_LENGTH 6
#define SNAC_LENGTH 10
#define TLV_HEADER_LENGTH 4

struct flap
{
	uint8_t id;
	uint8_t channel;
	uint16_t sequence_number;
	uint16_t data_size;
};

struct snac
{
	uint16_t group;
	uint16_t type;
	uint16_t flags;
	uint32_t id;
};

struct tlv
{
	uint16_t type;
	uint16_t length;
	char *value;
};

void zpracuj_oscar(struct data_packetu *zprava, struct sezeni *Sezeni);
void ukonci_oscar(struct data_packetu *zprava, struct sezeni *Sezeni);
void group0x01(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x02(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x03(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x04(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x06(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x07(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x08(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x09(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x0a(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x0b(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x0d(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x0e(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x0f(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x10(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x13(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x15(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);
void group0x17(struct snac *snac_zprava, int velikost_dat, struct sezeni *Sezeni, struct timeval *cas_zachyceni);

#endif
