#! /usr/bin/env bash
# Wrapper around pcf and clock skew processing
#
# Copyright (C) 2013 Libor Polčák,
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

PCF_DIR=/opt/pcf

INTERFACE=any

NAT=0

while getopts “i:p:d” OPTION
do
     case $OPTION in
         i)
             INTERFACE=$OPTARG
             ;;
         p)
             PCF_DIR=$OPTARG
             ;;
         d)
             NAT=1
             ;;
     esac
done

PCF=$PCF_DIR/pcf
if [ ! -f $PCF ]
then
    echo "PCF was not found. Please install it from https://github.com/polcak/pcf" 1>&2
    exit 1
fi

cat > $PCF_DIR/config <<__END__
# pcf config file generated by SLIS

interface $INTERFACE
num_packets 0
time 0
syn 0
ack 0
active active.xml
database database.xml

########################################
# Program constants                    #
# Be sure you know what you are doing! #
########################################

# Clock skew threshold
THRESHOLD 0.001

# Number of packets to do block operations
BLOCK 50

# Time limit for removing old lists (seconds)
TIME_LIMIT 3600
__END__

if [ $NAT == 1 ]
then
    ( cd $PCF_DIR ; ./pcf -die ) | ./clockskew.py #$PCF_DIR/www/data
else
    ( cd $PCF_DIR ; ./pcf -ie ) | ./clockskew.py #$PCF_DIR/www/data
fi
